/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "comp_rss.h"

guint rss_refresh_timeout;

static char *rss_generate ()
{
  return NULL;
}

static gboolean rss_update (gpointer user_data)
{
  GList *data;
  
  data = parse_rss ();

  return TRUE;
}

static void rss_load ()
{
  rss_update (NULL);
  rss_refresh_timeout = g_timeout_add (60 * 1000, rss_update, NULL);
}

static void rss_unload ()
{
  g_source_remove (rss_refresh_timeout);
}

static void rss_init ()
{
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/rss/type", 0);
  gaim_prefs_add_string ("/plugins/gtk/autoprofile/components/rss/location", 
    NULL);
}

struct component rss =
{
  N_("RSS / Blogs"),
  N_("Information taken from an RSS feed\n(Xanga and LiveJournal capable)"),
  'r',
  &rss_generate,
  &rss_init,
  &rss_load,
  &rss_unload,
  NULL
};

