/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#ifndef AUTOPROFILE_H
#define AUTOPROFILE_H

#define AUTOPROFILE_VERSION "2.14"

#include "sizes.h"

#include "component.h"
#include "utility.h"

#include "internal.h"
#include "plugin.h"
#include "debug.h"
#include "version.h"

#include "signals.h"
#include "prefs.h"
#include "conversation.h"
#include "util.h"
#include "notify.h"
#include "savedstatuses.h"

#include "gtkgaim.h"
#include "gtkplugin.h"
#include "gtkprefs.h"
#include "gtkutils.h"

#include "string.h"
#include "time.h"

/* General variables */
extern GaimPlugin *plugin_handle;

extern GList *components;
extern gboolean is_away;
extern gboolean sending_auto;
extern gpointer profile_timeout;
extern gboolean original_autoresponse;

/* Core functions */
char *autoprofile_generate (const char *);
gboolean profile_update (gpointer);
gboolean status_away ();
void status_back ();
gboolean away_update (gpointer);
void send_auto_response (GaimConversation *, char *, GaimAccount *);
void send_away_message (GaimConversation *, char *, char *, GaimAccount *);
void regular_received (GaimAccount *, char *, char *, int);

/* Gtk Away Messages */
void gtk_away_msgs_create (char *);
void gtk_away_msgs_destroy ();

/* Gtk Actions */
GList *actions (GaimPlugin *, gpointer);

/* Preferences */
GaimGtkPluginUiInfo ui_info;
gboolean get_account_boolean (GaimAccount *, const char *);

#endif /* #ifndef AUTOPROFILE_H */
