/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "component.h"
#include "gtkprefs.h"

static GtkWidget *spin_secs;
static GtkWidget *spin_mins;
static GtkWidget *spin_hour;
static GtkWidget *spin_day;
static GtkWidget *spin_month;
static GtkWidget *spin_year;

/* Generate the time! */
char *count_generate (void) 
{
  double d_secs, d_mins, d_hours, d_days;
  char *s_secs, *s_mins, *s_hours, *s_days;
  double difference;
  int l, s;

  struct tm *ref_time;
  char *result;

  ref_time = (struct tm *)malloc(sizeof (struct tm));

  ref_time->tm_sec = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/secs");
  ref_time->tm_min = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/mins");
  ref_time->tm_hour = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/hour");
  ref_time->tm_mday = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/day");
  ref_time->tm_mon = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/month") - 1;
  ref_time->tm_year = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/year") - 1900;
  ref_time->tm_isdst = -1;

  mktime (ref_time);
 
  if (gaim_prefs_get_int (
        "/plugins/gtk/autoprofile/components/count/down") == 1)
    difference = difftime (mktime (ref_time), time(NULL));
  else
    difference = difftime (time(NULL), mktime (ref_time));

  if (difference < 0) {
    d_secs = 0;
    d_mins = 0;
    d_hours = 0;
    d_days = 0;
  } else {
    d_mins = floor (difference / 60);
    d_secs = difference - (d_mins * 60);
    d_hours = floor (d_mins / 60);
    d_mins = d_mins - (d_hours * 60);
    d_days = floor (d_hours / 24);
    d_hours = d_hours - (d_days * 24);
  }

  result = (char *)malloc(sizeof (char) * AP_SIZE_MAXIMUM);
  l = gaim_prefs_get_int ("/plugins/gtk/autoprofile/components/count/large");
  s = gaim_prefs_get_int ("/plugins/gtk/autoprofile/components/count/small");

  if (l < s) {
   g_snprintf(result, AP_SIZE_MAXIMUM, "%.0f days, %.0f hours, %.0f minutes, %.0f seconds",
      d_days, d_hours, d_mins, d_secs); 
   free (ref_time);
   return result;
  }

  if (l < 3)
    d_hours = d_hours + (d_days * 24);
  if (l < 2)
    d_mins = d_mins + (d_hours * 60);
  if (l < 1)
    d_secs = d_secs + (d_mins * 60);

  if (d_days == 1.0)
    s_days = strdup ("day");
  else
    s_days = strdup ("days");

  if (d_hours == 1.0)
    s_hours = strdup ("hour");
  else
    s_hours = strdup ("hours");

  if (d_mins == 1.0)
    s_mins = strdup ("minute");
  else
    s_mins = strdup ("minutes");

  if (d_secs == 1.0)
    s_secs = strdup ("second");
  else
    s_secs = strdup ("seconds");

  switch (l) {
    case 3:
      switch (s) {
        case 3:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s",
            d_days, s_days);
          break;
        case 2:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s, %.0f %s",
            d_days, s_days, d_hours, s_hours);
          break;
        case 1:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s, %.0f %s, %.0f %s",
            d_days, s_days, d_hours, s_hours, d_mins, s_mins);
          break;
        case 0:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s, %.0f %s, %.0f %s, %.0f %s",
            d_days, s_days, d_hours, s_hours, d_mins, s_mins, d_secs, s_secs);
          break;
        default:
          *result = '\0';
      }
      break;
    case 2:
      switch (s) {
        case 2:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s",
            d_hours, s_hours);
          break;
        case 1:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s, %.0f %s",
            d_hours, s_hours, d_mins, s_mins);
          break;
        case 0:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s, %.0f %s, %.0f %s",
            d_hours, s_hours, d_mins, s_mins, d_secs, s_secs);
          break;
        default:
          *result = '\0';
      }
      break;
    case 1:
      switch (s) {
        case 1:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s",
            d_mins, s_mins);
          break;
        case 0:
          g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s, %.0f %s",
            d_mins, s_mins, d_secs, s_secs);
          break;
        default:
          *result = '\0';
      }
      break;
    case 0:
      g_snprintf (result, AP_SIZE_MAXIMUM, "%.0f %s",
        d_secs, s_secs);
      break;
    default:
      *result = '\0';
  }

  free (s_days);
  free (s_hours);
  free (s_mins);
  free (s_secs);
  free (ref_time);

  return result;
}

static void update_date (GtkSpinButton *spinner, gpointer data)
{
  int value = gtk_spin_button_get_value_as_int (spinner);

  if (!strcmp((char *)data, "year")) {
    gaim_prefs_set_int (
      "/plugins/gtk/autoprofile/components/count/year", value);
  }
  if (!strcmp((char *)data, "month")) {
    gaim_prefs_set_int (
      "/plugins/gtk/autoprofile/components/count/month", value);
  }
  if (!strcmp((char *)data, "day")) {
    gaim_prefs_set_int (
      "/plugins/gtk/autoprofile/components/count/day", value);
  }
  if (!strcmp((char *)data, "hour")) {
    gaim_prefs_set_int (
      "/plugins/gtk/autoprofile/components/count/hour", value);
  }
  if (!strcmp((char *)data, "mins")) {
    gaim_prefs_set_int (
      "/plugins/gtk/autoprofile/components/count/mins", value); 
  }
  if (!strcmp((char *)data, "secs")) {
    gaim_prefs_set_int (
      "/plugins/gtk/autoprofile/components/count/secs", value);
  }

  return;
}

void set_to_current_time (GtkButton *button, gpointer data)
{
  time_t the_time;
  struct tm *ref_time;

  the_time = time(NULL);
  ref_time = localtime(&the_time);

  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/count/year",
    ref_time->tm_year + 1900);
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/count/month",
    ref_time->tm_mon + 1);
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/count/day",
    ref_time->tm_mday);
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/count/hour", 
    ref_time->tm_hour);
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/count/mins",
    ref_time->tm_min);
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/count/secs",
    ref_time->tm_sec);

  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_secs), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/secs"));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_mins), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/mins"));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_hour), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/hour"));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_day), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/day"));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_month), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/month"));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_year), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/year"));
}

GtkWidget *count_menu ()
{
  GtkWidget *vbox, *hbox, *big_hbox, *frame;
  GtkWidget *label, *spinner, *dropbox, *button;

  big_hbox = gtk_hbox_new (FALSE, 6);
  
  frame = gaim_gtk_make_frame (big_hbox, _("The reference time"));
  vbox = gtk_vbox_new (FALSE, 6);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  hbox = gtk_hbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Year: "));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label, TRUE, TRUE, 0);
  spinner = gtk_spin_button_new_with_range (1970, 2035, 1);
  gtk_box_pack_end (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/year"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (update_date), strdup("year"));
  spin_year = spinner;

  hbox = gtk_hbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Month: "));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label, TRUE, TRUE, 0);
  spinner = gtk_spin_button_new_with_range (1, 12, 1);
  gtk_box_pack_end (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/month"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (update_date), strdup("month"));
  spin_month = spinner;

  hbox = gtk_hbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Day: "));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label, TRUE, TRUE, 0);
  spinner = gtk_spin_button_new_with_range (1, 31, 1);
  gtk_box_pack_end (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/day"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (update_date), strdup("day"));
  spin_day = spinner;

  hbox = gtk_hbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Hour: "));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label, TRUE, TRUE, 0);
  spinner = gtk_spin_button_new_with_range (0, 23, 1);
  gtk_box_pack_end (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/hour"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (update_date), strdup("hour"));
  spin_hour = spinner;

  hbox = gtk_hbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Minutes: "));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label, TRUE, TRUE, 0);
  spinner = gtk_spin_button_new_with_range (0, 59, 1);
  gtk_box_pack_end (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/mins"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (update_date), strdup("mins"));
  spin_mins = spinner;

  hbox = gtk_hbox_new (FALSE, 12);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Seconds: "));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label, TRUE, TRUE, 0);
  spinner = gtk_spin_button_new_with_range (0, 59, 1);
  gtk_box_pack_end (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/count/secs"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (update_date), strdup("secs"));
  spin_secs = spinner;

  hbox = gtk_hbox_new (FALSE, 12);
  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  button = gtk_button_new_with_label ("Set to current time");
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (set_to_current_time), NULL);
  gtk_box_pack_start (GTK_BOX(hbox), button, FALSE, FALSE, 0);

  frame = gaim_gtk_make_frame (big_hbox, _("Which way"));
  vbox = gtk_vbox_new (FALSE, 6);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  dropbox = gaim_gtk_prefs_dropdown (vbox, NULL,
    GAIM_PREF_INT, "/plugins/gtk/autoprofile/components/count/down",
    _("Count down to reference time"), 1,
    _("Count time since reference time"), 0, NULL);

  dropbox = gaim_gtk_prefs_dropdown (vbox, _("Largest units displayed"),
    GAIM_PREF_INT, "/plugins/gtk/autoprofile/components/count/large",
    _("Days"), 3,
    _("Hours"), 2,
    _("Minutes"), 1,
    _("Seconds"), 0, NULL);
    
  dropbox = gaim_gtk_prefs_dropdown (vbox, _("Smallest units displayed"),
    GAIM_PREF_INT, "/plugins/gtk/autoprofile/components/count/small",
    _("Days"), 3,
    _("Hours"), 2,
    _("Minutes"), 1,
    _("Seconds"), 0, NULL);

  return big_hbox;
}

/* Init prefs */
void count_init () {
  time_t the_time;
  struct tm *ref_time;

  the_time = time(NULL);
  ref_time = localtime(&the_time);

  gaim_prefs_add_none ("/plugins/gtk/autoprofile/components/count");
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/down", 1);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/small", 0);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/large", 3);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/year",
    ref_time->tm_year + 1900);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/month",
    ref_time->tm_mon + 1);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/day",
    ref_time->tm_mday);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/hour", 
    ref_time->tm_hour);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/mins",
    ref_time->tm_min);
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/count/secs",
    ref_time->tm_sec);
}

struct component count =
{
  N_("Count down/up"),
  N_("Acts as either a countdown timer or time since counter for specified "
     "date"),
  'c',
  &count_generate,
  &count_init,
  NULL,
  NULL,
  &count_menu
};

