/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "component.h"

GtkWidget* http_url_entry;
gpointer http_refresh_timeout;

/*---------- HTTP: HTTP requested Data ----------*/
void http_response(void* data, const char* c, size_t size)
{
  gaim_prefs_set_string( "/plugins/gtk/autoprofile/components/http_data", c );
}

char* http_generate()
{
  return strdup( gaim_prefs_get_string( "/plugins/gtk/autoprofile/components/http_data" ) );
}

gboolean http_refresh_update(gpointer user_data)
{
  char* http_url = strdup( gaim_prefs_get_string( "/plugins/gtk/autoprofile/components/http_url" ) );

  if( http_url && (http_url[0] != '\0') ) {
    gaim_url_fetch(http_url, TRUE, NULL, FALSE, http_response, NULL);
  } else {
    gaim_prefs_set_string( "/plugins/gtk/autoprofile/components/http_data", "" );
  }

  free( http_url );

  return TRUE;
}

void http_load()
{
  http_refresh_update( NULL );

  http_refresh_timeout = GINT_TO_POINTER (g_timeout_add (
    gaim_prefs_get_int( "/plugins/gtk/autoprofile/components/http_refresh_mins" ) * 60 * 1000,
    http_refresh_update, NULL ) );
}

void http_unload()
{
  g_source_remove (GPOINTER_TO_INT (http_refresh_timeout));
}

void http_init()
{
  gaim_prefs_add_string( "/plugins/gtk/autoprofile/components/http_url", "" );
  gaim_prefs_add_string( "/plugins/gtk/autoprofile/components/http_data", "" );
  gaim_prefs_add_int( "/plugins/gtk/autoprofile/components/http_refresh_mins", 5 );
}

static gboolean http_url_update (GtkWidget *widget, GdkEventFocus *evt, gpointer data)
{
    gaim_prefs_set_string ("/plugins/gtk/autoprofile/components/http_url",
    gtk_entry_get_text (GTK_ENTRY (http_url_entry)));

  return FALSE;
}

void http_data_update( GtkWidget* widget, gpointer user_data )
{
  http_refresh_update( NULL );
}

gboolean http_refresh_mins_update(GtkWidget *widget, GdkEventFocus *evt, gpointer data)
{
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/http_refresh_mins",
  gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget)));
   

  // Kill the current timer and run a new one
  g_source_remove( GPOINTER_TO_INT( http_refresh_timeout ));
  http_refresh_timeout = GINT_TO_POINTER( g_timeout_add(
    gaim_prefs_get_int( "/plugins/gtk/autoprofile/components/http_refresh_mins" ) * 60 * 1000,
    http_refresh_update, NULL ));

  return FALSE;
}

GtkWidget* http_menu()
{
  GtkWidget* ret = gtk_vbox_new(FALSE, 5);
  GtkWidget *label, *hbox, *button, *spinner;

  label = gtk_label_new (_("Select URL with source content"));
  gtk_box_pack_start (GTK_BOX (ret), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (ret), hbox, FALSE, FALSE, 0);

  // URL Entry
  http_url_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), http_url_entry, FALSE, FALSE, 0);
  gtk_entry_set_text (GTK_ENTRY (http_url_entry),
      gaim_prefs_get_string ("/plugins/gtk/autoprofile/components/http_url"));
  g_signal_connect (G_OBJECT (http_url_entry), "focus-out-event",
                    G_CALLBACK (http_url_update), NULL);

  // Update Now!
  button = gtk_button_new_with_label ("Update Now!");
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (http_data_update), NULL);

  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (ret), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("Delay"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  spinner = gtk_spin_button_new_with_range (1, 60, 1);
  gtk_box_pack_start (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner),
    gaim_prefs_get_int( "/plugins/gtk/autoprofile/components/http_refresh_mins" ));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (http_refresh_mins_update), NULL);

  label = gtk_label_new (_("minutes between http requests"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  return ret;
}

struct component http =
{
  N_("HTTP"),
  N_("Data requested from servers using HTTP"),
  'h',
  &http_generate,
  &http_init,
  &http_load,
  &http_unload,
  &http_menu
};
