// for testing
#include "cpuinfo.h"
#include "utils.h"
#include "IAudioResampler.h"
#include "AudioFpHQResampler.h"

#include <stdio.h>
#include <string.h>
#include <iostream>
#include <math.h>

using namespace std;

int main(int argc, char* argv[])
{
#define SZ1 4000
#define SZ2 5000
//#define TESTSTEREO 1

#ifdef TESTSTEREO
    avm::IAudioResampler* t = avm::CreateHQResampler(2, 16);
#else
    avm::IAudioResampler* t = avm::CreateHQResampler(1, 16);
#endif
    short in[2*(SZ1 + SZ2)];
    short out[2*(SZ1 + SZ2)];
    memset(in, 0, sizeof(in));
    memset(out, 0, sizeof(out));
    for (int i = 0; i < SZ1; i++)
    {
#if TESTSTEREO
	in[i*2] = i - SZ1/2;
	in[i*2+1] = i - SZ1/2;
#else
	in[i] = 100 * (i - SZ1/2);
	//in[i] = (short)(sin(i * 10 * 3.14 / 180) * 10000);
#endif
    }
    //in[SZ1] = in[SZ1 - 1];

    int64_t ts = longcount();
    for (int i = 0; i < 10000; i++)
    //for (int i = 0; i < 1; i++)
	t->resample(out, in, SZ2, SZ1);
    int64_t te = longcount();


    for (int i = 0; i < ((SZ1 > SZ2) ? (SZ1) : (SZ2)) && i < 100; i++)
    {
#ifdef TESTSTEREO
	cout << " i " << i << "   " << in[i*2] << "  " << in[i*2+1] << " -> " << out[i*2] << "  " << out[i*2+1] << endl;
#else
	cout << " i " << i << "   " << in[i] << " -> " << out[i] << "    " << out[i+1] - out[i] << endl;
#endif
    }
    cout << "time " << to_float(te, ts) << "s" << endl;

    //for (int i = 0; i < 40; i++)
    //    cout << sin(i * 10 * 3.14 / 180) * 10000 << "   " << sin(i * 10 * 4 / 5.0 * 3.14 / 180) * 10000 << endl;
}
