#include "aviPlayObject_impl.h"

AVIPlayObject_impl::AVIPlayObject_impl() : _player(0), _dpy(0)
{
}

bool AVIPlayObject_impl::loadMedia(const std::string& filename)
{
    try
    {
	delete _player;
	if(!_dpy)_dpy=XOpenDisplay(0);
	_player=CreateAviPlayer2(0, _dpy, filename.c_str(), 0);
    }
    catch(...)
    {
	return false;
    }
    return true;
}

AVIPlayObject_impl::~AVIPlayObject_impl()
{
    delete _player;
    if(_dpy)XCloseDisplay(_dpy);
}

poTime AVIPlayObject_impl::currentTime()
{
    double vtime=_player->GetPos();
    return poTime((int)vtime, (vtime-(int)vtime)*1000, 0, "");
}

poTime AVIPlayObject_impl::overallTime()
{
    double vtime=_player->GetVideoLength();
    if(vtime==0)vtime=_player->GetAudioLength();
    return poTime((int)vtime, (vtime-(int)vtime)*1000, 0, "");
}

poCapabilities AVIPlayObject_impl::capabilities()
{
    return poCapabilities(capSeek | capPause);
}

string AVIPlayObject_impl::mediaName()
{
    return string(_player->FileName());
}

poState AVIPlayObject_impl::state()
{
    if(!_player)return posIdle;
    if(_player->IsPaused())return posPaused;
    return posPlaying;
}
    
void AVIPlayObject_impl::play()
{
    _player->Play();
}

void AVIPlayObject_impl::seek(const poTime& newTime)
{
    _player->ReseekExact(newTime.seconds+newTime.ms*.001);
}

void AVIPlayObject_impl::pause()
{
    _player->Pause(true);
}

void AVIPlayObject_impl::halt()
{
    _player->Stop();
}


REGISTER_IMPLEMENTATION(AVIPlayObject_impl);

