# Configure paths for libxvidcore version 1.0

dnl AM_PATH_XVID([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libxvidcore, and define XVID4_CFLAGS and XVID4_LIBS
dnl
AC_DEFUN([AM_PATH_XVID4],
[
    AC_ARG_WITH(xvid4_prefix, [  --with-xvid4-prefix=PFX where XviD4 is installed.],
		[], with_xvid4_prefix="")

    XVID4_CFLAGS=""
    XVID4_LIBS=""

    have_xvid4=no
    ac_save_CPPFLAGS=$CPPFLAGS
    if test -n "$with_xvid4_prefix" ; then
	dnl user has specified extra path for XviD instalation
	CPPFLAGS="-I$with_xvid4_prefix $CPPFLAGS"
	AC_CHECK_HEADER(include/xvid.h,
			XVID4_CFLAGS="-I$with_xvid4_prefix/include"
			XVID4_LIBS="-L$with_xvid4_prefix/lib"
			have_xvid4=yes)
	if test "$have_xvid4" = no; then
	    AC_CHECK_HEADER(xvid.h,
			    XVID4_CFLAGS="-I$with_xvid4_prefix"
			    XVID4_LIBS="-L$with_xvid4_prefix"
			    have_xvid4=yes)
	fi
    else
	AC_CHECK_HEADER(xvid.h, have_xvid4=yes)
    fi
    CPPFLAGS=$ac_save_CPPFLAGS

dnl
dnl Now check if the installed XviD is sufficiently new.
dnl
    AC_AVM_CHECK_LIB(xvid4, [for xvid_global in -lxvidcore (4)],
                     XVID4_CFLAGS, XVID4_LIBS, -lxvidcore, [
#include <stdio.h>
#include <string.h>
#include <xvid.h>], [

  xvid_gbl_info_t xinfo;
  memset(&xinfo, 0, sizeof(xinfo));
  xinfo.version = XVID_VERSION;

  if (xvid_global(NULL, XVID_GBL_INIT, &xinfo, NULL) == XVID_ERR_FAIL) {
    printf("Header file and library are out of sync. Header file supports\n"
	   "version %d.%d API and shared library supports version %d.%d API.\n",
	   XVID_VERSION >> 16, XVID_VERSION & 0xFFFF,
	   xinfo.version >> 16, xinfo.version & 0xFFFF);
    ret = 1;
  }		     ], [$1], [$2])
])

