dnl Configure A52

dnl Usage:
dnl AM_PATH_A52([ACTION-IF-FOUND-A52 [, ACTION-IF-NOT-FOUND-A52]])
AC_DEFUN([AM_PATH_A52],
[
    AC_ARG_WITH(a52_prefix, [  --with-a52-prefix=PFX   where liba52 is installed.],
                A52_CFLAGS="-I$withval/include"
                A52_LIBS="-L$withval/lib",
                A52_CFLAGS=""
                A52_LIBS="")
    ac_save_LIBS=$LIBS
    AC_CHECK_LIB(a52, a52_frame,
                 [ A52_LIBS="$A52_LIBS -la52 -lm"
                   have_a52=yes
                   ifelse([$1], , :, [$1]) ],
                 [ A52_CFLAGS=""; A52_LIBS=""
                   have_a52=no
                   ifelse([$2], , :, [$2]) ],
                 [ $A52_LIBS -lm ])
    LIBS=$ac_save_LIBS
    AC_SUBST(A52_CFLAGS)
    AC_SUBST(A52_LIBS)
])

dnl as.m4
dnl Figure out how to run the assembler.

dnl AM_PROG_AS
AC_DEFUN([AM_PROG_AS],
[
dnl By default we simply use the C compiler to build assembly code.
    AC_REQUIRE([AC_PROG_CC])
    : ${CCAS='$(CC)'}
    # Set CCASFLAGS if not already set.
    : ${CCASFLAGS='$(CFLAGS)'}
    # Set ASCOMPILE if not already set.
    if test $CCAS = '$'CC; then
    : ${CCASCOMPILE='$(LIBTOOL) --mode=compile $(CCAS) $(AM_ASFLAGS) $(CCASFLAGS) -c'}
    else
    : ${CCASCOMPILE='$(LIBTOOL) --mode=compile $(CCAS) $(AM_ASFLAGS) $(CCASFLAGS)'}
    fi
    AC_SUBST(CCAS)
    AC_SUBST(CCASFLAGS)
    AC_SUBST(CCASCOMPILE)
])

dnl AC_GCC_VERSION
dnl check for compiler version
dnl sets COMPILER_VERSION and GCC_VERSION

AC_DEFUN([AC_CC_VERSION],
[
    AC_MSG_CHECKING([C compiler version])
    COMPILER_VERSION=`$CC -v 2>&1 | grep version`
    case "$COMPILER_VERSION" in
        *gcc*)
	   dnl Ok, how to turn $3 into the real $3
	   GCC_VERSION=`echo $COMPILER_VERSION | \
	   sed -e 's/[[^ ]]*\ [[^ ]]*\ \([[^ ]]*\)\ .*/\1/'` ;;
	*) GCC_VERSION=unknown ;;
    esac
    AC_MSG_RESULT($GCC_VERSION)
])

dnl AC_TRY_CFLAGS (CFLAGS, [ACTION-IF-WORKS], [ACTION-IF-FAILS])
dnl check if $CC supports a given set of cflags

AC_DEFUN([AC_TRY_CFLAGS],
[
    AC_REQUIRE([AC_PROG_CC])
    AC_MSG_CHECKING([whether $CC accepts $1 flag(s)])
    ac_save_CFLAGS=$CFLAGS
    CFLAGS="$1"
    AC_COMPILE_IFELSE(AC_LANG_PROGRAM(), ac_cv_try_cflags_ok=yes, ac_cv_try_cflags_ok=no)
    CFLAGS=$ac_save_CFLAGS
    AC_MSG_RESULT($ac_cv_try_cflags_ok)
    if test "$ac_cv_try_cflags_ok" = yes; then
        ifelse([$2], [], [:], [$2])
    else
        ifelse([$3], [], [:], [$3])
    fi
])

dnl AC_TRY_CXXFLAGS (CXXFLAGS, [ACTION-IF-WORKS], [ACTION-IF-FAILS])
dnl check if $CXX supports a given set of cxxflags

AC_DEFUN([AC_TRY_CXXFLAGS],
[
    AC_REQUIRE([AC_PROG_CXX])
    AC_MSG_CHECKING([if $CXX supports $1 flag(s)])
    AC_LANG_PUSH(C++)
    ac_save_CXXFLAGS=$CXXFLAGS
    CXXFLAGS="$1"
    AC_COMPILE_IFELSE(AC_LANG_PROGRAM(), ac_cv_try_cxxflags_ok=yes, ac_cv_try_cxxflags_ok=no)
    CXXFLAGS=$ac_save_CXXFLAGS
    AC_MSG_RESULT($ac_cv_try_cxxflags_ok)
    AC_LANG_POP
    if test "$ac_cv_try_cxxflags_ok" = yes; then
        ifelse([$2], [], [:], [$2])
    else
        ifelse([$3], [], [:], [$3])
    fi
])

dnl AC_CHECK_GNU_EXTENSIONS([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])

AC_DEFUN([AC_CHECK_GNU_EXTENSIONS],
[
    AC_CACHE_CHECK([if you need GNU extensions], ac_cv_gnu_extensions,
        AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <features.h>], [
#ifndef __GNU_LIBRARY__
gnuneeded
#endif
        ]), ac_cv_gnu_extensions=yes, ac_cv_gnu_extensions=no)
    )
    if test "$ac_cv_gnu_extensions" = yes; then
        ifelse([$1], [], [:], [$1])
    dnl AC_DEFINE_UNQUOTED(_GNU_SOURCE)
    else
        ifelse([$2], [], [:], [$2])
    fi
])

dnl
dnl AC_CHECK_GNU_VECTOR([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl
AC_DEFUN([AC_CHECK_GNU_VECTOR],
[
    AC_CACHE_CHECK([whether $CC supports vector builtins], ac_cv_gnu_vector,
        AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <features.h>], [
int main(void) { 
#if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 2)
return 0;
#else
#error no vector builtins
#endif
}
        ]), ac_cv_gnu_vector=yes, ac_cv_gnu_vector=no)
    )
    if test "$ac_cv_gnu_vector" = yes; then
        ifelse([$1], [], [:], [$1])
    else
        ifelse([$2], [], [:], [$2])
    fi
])

dnl
dnl AC_CHECK_ALIGN_POWER([ACTION-IF-FOUND-ALIGN_POWER [, ACTION-IF-NOT-FOUND-ALIGN_POWER]])
dnl
AC_DEFUN([AC_CHECK_ALIGN_POWER],
[
    AC_REQUIRE([AC_PROG_CC])
    AC_CACHE_CHECK([whether .align arg is power-of-two],
		   ac_cv_val_have_align_power,
		   AC_COMPILE_IFELSE(AC_LANG_PROGRAM([],
                   [ asm (".align 3") ]),
                   ac_cv_val_have_align_power=yes, ac_cv_val_have_align_power=no)
		   )
    if test "$ac_cv_val_have_align_power" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

dnl
dnl AC_CHECK_RESTRICT_KEYWORD([ACTION])
dnl
AC_DEFUN([AC_CHECK_RESTRICT_KEYWORD],
[
    AC_REQUIRE([AC_PROG_CC])
    AC_CACHE_CHECK([for restrict keyword],
		   ac_cv_val_restrict_keyword,
                   AC_COMPILE_IFELSE(AC_LANG_PROGRAM([],
                   [ void foo(char * restrict p); ]),
                   ac_cv_val_restrict_keyword=restrict,
                       AC_COMPILE_IFELSE(AC_LANG_PROGRAM([],
                       [ void foo(char * _restrict p); ]),
                       ac_cv_val_restrict_keyword=_restrict,
                           AC_COMPILE_IFELSE(AC_LANG_PROGRAM([],
                           [ void foo(char * __restrict__ p); ]),
                           ac_cv_val_restrict_keyword=__restrict__,
                               AC_COMPILE_IFELSE(AC_LANG_PROGRAM([],
                               [ void foo(char * __restrict p); ]),
                               ac_cv_val_restrict_keyword=__restrict,
                               ac_cv_val_restrict_keyword=)
                           )
                       )
                   )
    )
    have_restrict_keyword=$ac_cv_val_restrict_keyword
    ifelse([$1], , :, [$1])
])

# Configure paths for libdc1394_control

dnl AM_PATH_DC1394([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libdc1394_control, and define DC1394_CFLAGS and DC1394_LIBS
dnl
AC_DEFUN([AM_PATH_DC1394],
[
    AC_ARG_WITH(dc1394_prefix, [  --with-dc1394-prefix=PFX  where DC1394 is installed.],
                DC1394_CFLAGS="-I$withval/include"
                DC1394_LIBS="-L$withval/lib",
                DC1394_CFLAGS=""
                DC1394_LIBS="")

    AC_AVM_CHECK_LIB(dc1394, [for dc1394_create_handle in -ldc1394_control],
                     DC1394_CFLAGS, DC1394_LIBS, [ -ldc1394_control -lraw1394 ],
                     [#include <libdc1394/dc1394_control.h>],
                     dc1394_create_handle(0), [$1], [$2])
])

# Configure paths for DivX

dnl Usage:
dnl AM_PATH_DIVX([ACTION-IF-FOUND-DECORE [, ACTION-IF-NOT-FOUND-DECORE
dnl		 [, ACTION-IF-FOUND-ENCORE, [ACTION-IF-NOT-FOUND-DECORE]]]] )
dnl Test for libdivxdecore, libdivxencore, and define DIVX_CFLAGS and DIVX_LIBS
dnl
AC_DEFUN([AM_PATH_DIVX],
[
    AC_ARG_WITH(divx4_prefix, [  --with-divx4-prefix=PFX where divx4linux is installed.],
	        [], with_divx4_prefix=)

    have_divx_decore=no
    have_divx_encore=no
    DIVX_CFLAGS=""
    DIVX_LIBS=""
    ac_save_CPPFLAGS=$CPPFLAGS
    if test -n "$with_divx4_prefix"; then
	dnl user has specified extra path for DivX4 instalation
	CPPFLAGS="-I$with_divx4_prefix $CPPFLAGS"
	AC_CHECK_HEADER(include/decore.h,
			DIVX_CFLAGS="-I$with_divx4_prefix/include"
			DIVX_LIBS="-L$with_divx4_prefix/lib"
			have_divx_decore=yes)
	if test "$have_divx_decore" = no; then
	    AC_CHECK_HEADER(decore.h,
			    DIVX_CFLAGS="-I$with_divx4_prefix"
			    DIVX_LIBS="-L$with_divx4_prefix"
			    have_divx_decore=yes)
	fi
    else
	AC_CHECK_HEADER(decore.h, have_divx_decore=yes)
    fi

    AC_CHECK_HEADER(encore2.h, have_divx_encore=yes)
    CPPFLAGS=$ac_save_CPPFLAGS

    ac_save_LIBS=$LIBS
    if test "$have_divx_decore" = yes; then
        AC_CHECK_LIB(divxdecore, decore, [],
                     have_divx_decore=no, $DIVX_LIBS)
    fi

    if test "$have_divx_encore" = yes; then
	AC_CHECK_LIB(divxencore, encore, [],
		     have_divx_encore=no, $DIVX_LIBS)
    fi
    LIBS=$ac_save_LIBS

    if test "$have_divx_decore" = yes; then
        DIVX_LIBS="$DIVX_LIBS -ldivxdecore"
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi

    if test "$have_divx_encore" = yes; then
        DIVX_LIBS="$DIVX_LIBS -ldivxencore"
        ifelse([$3], , :, [$3])
    else
        ifelse([$4], , :, [$4])
    fi

    AC_SUBST(DIVX_CFLAGS)
    AC_SUBST(DIVX_LIBS)
])

# Configure paths for libdts

dnl AM_PATH_DTS([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libdts, and define DTS_CFLAGS and DTS_LIBS
dnl
AC_DEFUN([AM_PATH_DTS],
[
    AC_ARG_WITH(dts_prefix, [  --with-dts-prefix=PFX   where DTS is installed.],
                DTS_CFLAGS="-I$withval/include"
                DTS_LIBS="-L$withval/lib",
                DTS_CFLAGS=""
                DTS_LIBS="")

dnl dts.h needs stdint.h/inttypes.h for plain compile!
    AC_AVM_CHECK_LIB(dts, [for dts_init in -ldts],
                     DTS_CFLAGS, DTS_LIBS, [ -ldts -lm ], [
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif
#if HAVE_STDINT_H
# include <stdint.h>
#endif
#include <dts.h>], dts_state_t* d = dts_init(0), [$1], [$2])
])

# Configure paths for libfaad

dnl AM_PATH_FAAD([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libfaad, and define FAAD_CFLAGS and FAAD_LIBS
dnl
AC_DEFUN([AM_PATH_FAAD],
[
    AC_ARG_WITH(faad_prefix, [  --with-faad-prefix=PFX  where FAAD is installed.],
                FAAD_CFLAGS="-I$withval/include"
                FAAD_LIBS="-L$withval/lib",
                FAAD_CFLAGS=""
                FAAD_LIBS="")

    AC_AVM_CHECK_LIB(faad, [for faacDecOpen in -lfaad],
                     FAAD_CFLAGS, FAAD_LIBS, [ -lfaad -lm ],
                     [#include <faad.h>], faacDecHandle h = faacDecOpen(), [$1], [$2])
])

dnl Che
dnl currently needed only by ffmpeg
dnl AC_FUNC_LRINTF([ACTION-IF-FOUND-LRINTF [, ACTION-IF-NOT-FOUND-LRINTF]])
dnl
AC_DEFUN([AC_FUNC_LRINTF],
[
    AC_CACHE_CHECK([whether system declares lrintf function in math.h],
		   ac_cv_val_have_lrintf,
		   [ac_save_CFLAGS=$CFLAGS
		   ac_save_LIBS=$LIBS
                   CFLAGS="$CFLAGS -O2"
		   LIBS="$LIBS -lm"
                   AC_RUN_IFELSE(AC_LANG_SOURCE([
		    #define _ISOC9X_SOURCE  1
		    #include <math.h>
		    int main( void ) { return (lrintf(3.999f) > 0)?0:1; }]),
                    ac_cv_val_have_lrintf=yes, ac_cv_val_have_lrintf=no,
                    [ echo $ac_n "cross compiling; assumed OK... $ac_c" ])
                   CFLAGS=$ac_save_CFLAGS
                   LIBS=$ac_save_LIBS
		   ])
    if test "$ac_cv_val_have_lrintf" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

dnl
dnl AC_CHECK_IPV6([ACTION-IF-FOUND-IPV6 [, ACTION-IF-NOT-FOUND-IPV6]])
dnl
AC_DEFUN([AC_CHECK_IPV6],
[
    AC_CACHE_CHECK([whether system supports IPv6],
		   ac_cv_val_have_ipv6,
		   AC_COMPILE_IFELSE(AC_LANG_PROGRAM([
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
                   ], [
  struct sockaddr_storage saddr;
  struct ipv6_mreq mreq6;
  getaddrinfo(0,0,0,0);
  getnameinfo(0,0,0,0,0,0,0);
  IN6_IS_ADDR_MULTICAST((const struct in6_addr *)0);
                   ]), ac_cv_val_have_ipv6=yes, ac_cv_val_have_ipv6=no)
		   )
    if test "$ac_cv_val_have_ipv6" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

dnl Usage:
dnl AM_PATH_FFMPEG([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for ffmpeg, and define FFMPEG_CFLAGS and FFMPEG_LIBS

AC_DEFUN([AM_PATH_FFMPEG],
[
    AC_FUNC_LRINTF([    
	AC_DEFINE(HAVE_LRINTF, 1, [Define if you have lrintf on your system.])
        AC_DEFINE(_ISOC9X_SOURCE, 1, [Define for proper lrintf prototype.])])

    AC_CHECK_FUNCS(mkstemp)

    AC_CHECK_ALIGN_POWER([
        AC_DEFINE(ASMALIGN(ZEROBITS), [".align " #ZEROBITS "\n\t"], 
                   [ffmpeg Define if your .align arg is power-of-two.])],[
        AC_DEFINE(ASMALIGN(ZEROBITS), [".align 1<<" #ZEROBITS "\n\t"], 
                   [ffmpeg Define if your .align arg is not power-of-two.])
    ])

    AC_CHECK_RESTRICT_KEYWORD(AC_DEFINE_UNQUOTED(restrict, $have_restrict_keyword, [Define restrict keyword.]))

    AC_CHECK_HEADERS(sys/poll.h)
    
    dnl !!! - it really sucks - Makefile.am can not be optimized even by
    dnl !!! preparing some extra variable forward
    dnl !!! FFAVFORMAT_SRC=

    ac_enablef_mmx=0
    ac_enablef_armv4l=0
    ac_enablef_mlib=0
    ac_enablef_sparc=0
    ac_enablef_alpha=0
    ac_enablef_powerpc=0
    ac_enablef_mmi=0
    ac_enablef_sh4=0
    ac_enablef_bfin=0
    case "$target" in
        i?86*|ia64*|x86_64*|amd64*) ac_enablef_mmx=1 ;;
        alpha*) ac_enablef_alpha=1 ;;
        arm*) ac_enablef_armv4l=1 ;;
        sparc*) ac_enablef_sparc=1 ;;
        mips*) ac_enablef_mmi=1 ;;
        ppc*|powerpc*) ac_enablef_powerpc=1 ;;
    esac

    AC_DEFINE_UNQUOTED(ENABLE_MMX, $ac_enablef_mmx, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_ARMV4L, $ac_enablef_armv4l, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_MLIB, $ac_enablef_mlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_SPARC, $ac_enablef_sparc, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_ALPHA, $ac_enablef_alpha, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_POWERPC, $ac_enablef_powerpc, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_MMI, $ac_enablef_mmi, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_SH4, $ac_enablef_sh4, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_BFIN, $ac_enablef_bfin, [ffmpeg])


    AC_DEFINE(CONFIG_ENCODERS, 1, [ffmpeg Define if you want to build encoders.])
    AC_DEFINE(CONFIG_DECODERS, 1, [ffmpeg Define if you want to build decoders.])
    AC_DEFINE(CONFIG_MUXERS, 1, [ffmpeg Define if you want to build muxers.])
    AC_DEFINE(CONFIG_DEMUXERS, 1, [ffmpeg Define if you want to build demuxers.])

dnl GPL
    AC_ARG_ENABLE(ffmpeg_gpl, [  --disable-ffmpeg-gpl   disable GPL code in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_gpl=yes)
    if test "$enable_ffmpeg_threads" = yes; then
	AC_DEFINE(CONFIG_GPL, 1, [ffmpeg])
    fi
    AC_DEFINE(RUNTIME_CPUDETECT, 1, [ffmpeg for libpostprocess and libswscale])

dnl SMALL
    AC_ARG_ENABLE(ffmpeg_small, [  --enable-ffmpeg-small   optimize ffmpeg for size. [[disabled]]],
		  [], enable_ffmpeg_small=no)
    if test "$enable_ffmpeg_small" = yes; then
        ac_enablef_small=1
    else
        ac_enablef_small=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_SMALL, $ac_enablef_small, [ffmpeg])

dnl THREADS
    AC_ARG_ENABLE(ffmpeg_threads, [  --disable-ffmpeg-threads   support threads in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_threads=yes)
    if test "$enable_ffmpeg_threads" = yes; then
        ac_enablef_threads=1
    else
        ac_enablef_threads=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_THREADS, $ac_enablef_threads, [ffmpeg])

dnl LIBAC3
    AC_ARG_ENABLE(ffmpeg_a52, [  --disable-ffmpeg-a52    do not build ffmpeg with A52 (AC3) support. [[enabled]]],
		  [], enable_ffmpeg_a52=yes)
    if test "$enable_ffmpeg_a52" = yes; then
        enablef_ac3=1
	AC_DEFINE(CONFIG_LIBA52_DECODER, 1, [ffmpeg Define if you want to use A52 audio decoder.])

	AC_ARG_ENABLE(ffmpeg_a52bin, [  --enable-ffmpeg-a52bin  A52 plugin dlopens liba52.so.0 at runtime [[disabled]]],
		      [], enable_ffmpeg_a52bin=no)
        if test "$enable_ffmpeg_a52bin" = yes; then
            AC_DEFINE(CONFIG_LIBA52BIN, 1, [ffmpeg Define if you want to build with A52 dlopened decoder.])
        fi
    else
        enablef_ac3=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_LIBA52_DECODER, $enablef_ac3, [ffmpeg Define if you want to use A52 audio decoder.])

dnl DTS
    AC_REQUIRE([AM_PATH_DTS])
    AC_ARG_ENABLE(ffmpeg_dts, [  --disable-ffmpeg-dts    disable DTS support in ffmpeg. [[enabled]]],
                  [], enable_ffmpeg_dts=yes)
    if test "$enable_ffmpeg_dts" = yes -a "$have_dts" = yes; then
        enablef_dts=1
        AC_DEFINE(CONFIG_LIBDTS_DECODER, 1, [ffmpeg Define if you want to build with DTS decoder.])
    else
        enablef_dts=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_LIBDTS_DECODER, $enablef_dts, [ffmpeg Define if you want to build with DTS decoder.])

dnl DV1394
    AC_ARG_ENABLE(ffmpeg_dv1394, [  --disable-ffmpeg-dv1394 disable ffmpeg DV1394 support. [[enabled]]],
                  [], enable_ffmpeg_dv1394=yes)
    if test "$enable_ffmpeg_dv1394" = yes; then
        enablef_dv1394=1
        AC_DEFINE(CONFIG_DV1394_DEMUXER, 1, [ffmpeg Define if you want to have DV1394 support compiled.])
    else
        enablef_dv1394=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_DV1394_DEMUXER, $enablef_dv1394, [ffmpeg Define if you want to have DV1394 support compiled.])

dnl DC1394
    AC_ARG_ENABLE(ffmpeg_dc1394, [  --enable-ffmpeg-dc1394 ffmpeg DC1394 support. [[disabled]]],
                  [], enable_ffmpeg_dc1394=no)
    enablef_dc1394=0
    if test "$enable_ffmpeg_dc1394" = yes; then
        AM_PATH_DC1394([
            enablef_dc1394=1
            AC_DEFINE(CONFIG_DC1394_DEMUXER, 1, [ffmpeg Define if you want to have DV1394 demuxer.])
            ], [])
    fi
    AC_DEFINE_UNQUOTED(ENABLE_DC1394_DEMUXER, $enablef_dc1394, [ffmpeg Define if you want to have DV1394 support compiled.])

dnl LIBFAAD
    AC_REQUIRE([AM_PATH_FAAD])
    if test "$have_faad" = yes; then
        enablef_aac=1
dnl fix ffmpeg - MOV.C needs libfaad
        AC_DEFINE(CONFIG_LIBFAAD, 1, [ffmpeg Define if you want to have AAC support compiled.])
        AC_DEFINE(CONFIG_MPEG4AAC_DECODER, 1, [ffmpeg Define if you want to have AAC support compiled.])

        AC_ARG_ENABLE(ffmpeg_faadbin, [  --disable-ffmpeg-faadbin do not build ffmpeg with FAAD bin.support. [[enabled]]],
                      [], enable_ffmpeg_faadbin=yes)
        if test "$enable_ffmpeg_faadbin" = yes; then
            AC_DEFINE(CONFIG_LIBFAADBIN, 1, [ffmpeg Define if you want to build support for runtime linked libfaad.])
        fi
    else
        enablef_aac=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_LIBFAAD_DECODER, $enablef_aac, [ffmpeg Define if you want to have AAC support compiled.])
    AC_DEFINE_UNQUOTED(ENABLE_MPEG4AAC_DECODER, $enablef_aac, [ffmpeg Define if you want to have AAC support compiled.])


dnl OSS audio
    AC_REQUIRE([AC_CHECK_OSS])
    if test "$enable_oss" = yes; then
        enablef_audio=1
        AC_DEFINE(CONFIG_AUDIO_DEMUXER, 1, [ffmpeg Define if you want to have OSS audio demuxer.])
        AC_DEFINE(CONFIG_AUDIO_MUXER, 1, [ffmpeg Define if you want to have OSS audio muxer.])
    else
        enablef_audio=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_AUDIO_DEMUXER, $enablef_audio, [ffmpeg Define if you want to have OSS audio demuxer.])
    AC_DEFINE_UNQUOTED(ENABLE_AUDIO_MUXER, $enablef_audio, [ffmpeg Define if you want to have OSS audio muxer.])

dnl UNUSED!!!
    AC_ARG_ENABLE(ffmpeg_pp, [  --disable-ffmpeg-pp     disable postprocessing support in ffmpeg. [[enabled]]],
                  [], enable_ffmpeg_pp=yes)
    if test "$enable_ffmpeg_pp" = yes; then
        AC_DEFINE(CONFIG_PP, 1, [ffmpeg Define if you want to build with PP support.])
    fi

    AC_ARG_ENABLE(ffmpeg_swscaler, [  --enable-ffmpeg-swscaler build ffmpeg with SWScaler. [[disabled]]],
                  [], enable_ffmpeg_swscaler=no)
    if test "$enable_ffmpeg_swscaler" = yes; then
        AC_DEFINE(CONFIG_SWSCALER, 1, [ffmpeg Define if you want to build with SWScaler.])
    fi

    AC_ARG_ENABLE(ffmpeg_mpegaudiohp, [  --disable-ffmpeg-mpegaudiohp build ffmpeg with MPEG HighPrecision. [[enabled]]],
                  [], enable_ffmpeg_mpegaudiohp=yes)
    if test "$enable_ffmpeg_mpegaudiohp" = yes; then
        AC_DEFINE(CONFIG_MPEGAUDIO_HP, 1, [ffmpeg Define if you want to have highprecision mpeg audio support compiled.])
    fi

    AC_REQUIRE([AC_CHECK_V4L])
    if test "$enable_v4l" = yes; then
	AC_DEFINE(CONFIG_VIDEO4LINUX, 1, [ffmpeg Define if you have video4linux device.])
    fi
 
    AC_REQUIRE([AC_CHECK_V4L2])
    if test "$enable_v4l2" = yes; then
	AC_DEFINE(CONFIG_VIDEO4LINUX2, 1, [ffmpeg Define if you have video4linux2 device.])
    fi

    AC_ARG_ENABLE(ffmpeg_network, [  --disable-ffmpeg-network disable network support. [[enabled]]],
                  [], enable_ffmpeg_network=yes)
    if test "$enable_ffmpeg_network" = yes; then
        AC_DEFINE(CONFIG_NETWORK, 1, [ffmpeg Define if you want to build with network support.])
    fi

    AC_CHECK_IPV6([
       if test "$enable_ffmpeg_network" = yes; then
            AC_DEFINE(CONFIG_IPV6, 1, [ffmpeg Define if you want to build with IPv6 support.])
       fi], [])

    AC_ARG_ENABLE(ffmpeg_protocol, [  --disable-ffmpeg-protocol disable ffmpeg protocol support. [[enabled]]],
                  [], enable_ffmpeg_protocol=yes)
    if test "$enable_ffmpeg_protocol" = yes; then
        AC_DEFINE(CONFIG_PROTOCOLS, 1, [ffmpeg Define if you want to build with protocols registered.])
    fi
    
    AC_REQUIRE([AC_FIND_ZLIB])
    if  test "$have_zlib" = yes; then
	AC_DEFINE(CONFIG_ZLIB, 1, [ffmpeg Define if you have z library (-lz)])
    fi

    AC_DEFINE(CONFIG_FFSERVER, 1, [ffmpeg Define if you want to build server.])

    AC_DEFINE(SIMPLE_IDCT, 1, [ffmpeg Define if you want to build with simples idct.])
    AC_DEFINE(HAVE_PTHREADS, 1, [ffmpeg Define if you want to have pthread support compiled.])

    if test -n "$ffmpeg_profiling" ; then
	AC_DEFINE(HAVE_GPROF, 1, [ffmpeg Define if you want to build with gprof support.])
    fi

    test -z "$FFMPEG_CFLAGS" && FFMPEG_CFLAGS="-O4 $DEFAULT_FLAGS"
    FFMPEG_CFLAGS="$FFMPEG_CFLAGS $DEFAULT_DEFINES"

    AC_CHECK_GNU_VECTOR(FFMPEG_SSE="-msse";
		        AC_DEFINE(HAVE_BUILTIN_VECTOR, 1, [ffmpeg Define if your compiler supports vector builtins (MMX).]), [])
    AC_SUBST(FFMPEG_CFLAGS)
    AC_SUBST(FFMPEG_SSE)

dnl ffmpeg_x86opt=
dnl test x$enable_x86opt = xno && ffmpeg_x86opt="--disable-mmx"
dnl AC_MSG_RESULT([=== configuring ffmpeg ===])
dnl    ( cd $srcdir/ffmpeg ; \
dnl      ./configure --prefix=$prefix --cc=$CC \
dnl		$ffmpeg_profiling $ffmpeg_cpu \
dnl		$ffmpeg_x86opt --disable-mp3lib \
dnl		--enable-simple_idct )
])
# Configure paths for FreeType2
# Marcelo Magallon 2001-10-26, based on gtk.m4 by Owen Taylor

dnl AC_CHECK_FT2([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for FreeType2, and define FT2_CFLAGS and FT2_LIBS
dnl
AC_DEFUN([AC_CHECK_FT2],
[dnl
dnl Get the cflags and libraries from the freetype-config script
dnl
AC_ARG_WITH(ft-prefix,
[  --with-ft-prefix=PREFIX prefix where FreeType is installed],
            ft_config_prefix="$withval", ft_config_prefix="")
AC_ARG_WITH(ft-exec-prefix,
[  --with-ft-exec-prefix=PFX exec prefix where FreeType is installed],
            ft_config_exec_prefix="$withval", ft_config_exec_prefix="")
AC_ARG_ENABLE(freetypetest,
[  --disable-freetypetest  do not try to compile and run a test FT2 program.],
              [], enable_fttest=yes)

if test x$ft_config_exec_prefix != x ; then
  ft_config_args="$ft_config_args --exec-prefix=$ft_config_exec_prefix"
  if test x${FT2_CONFIG+set} != xset ; then
    FT2_CONFIG=$ft_config_exec_prefix/bin/freetype-config
  fi
fi
if test x$ft_config_prefix != x ; then
  ft_config_args="$ft_config_args --prefix=$ft_config_prefix"
  if test x${FT2_CONFIG+set} != xset ; then
    FT2_CONFIG=$ft_config_prefix/bin/freetype-config
  fi
fi
AC_PATH_PROG(FT2_CONFIG, freetype-config, no)

min_ft_version=ifelse([$1], ,6.1.0,$1)
AC_MSG_CHECKING(for FreeType - version >= $min_ft_version)
no_ft=""
if test "$FT2_CONFIG" = "no" ; then
  no_ft=yes
else
  FT2_CFLAGS=`$FT2_CONFIG $ft_config_args --cflags`
  FT2_LIBS=`$FT2_CONFIG $ft_config_args --libs`
  ft_config_major_version=`$FT2_CONFIG $ft_config_args --version | \
         sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  ft_config_minor_version=`$FT2_CONFIG $ft_config_args --version | \
         sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  ft_config_micro_version=`$FT2_CONFIG $ft_config_args --version | \
         sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
  ft_min_major_version=`echo $min_ft_version | \
         sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  ft_min_minor_version=`echo $min_ft_version | \
         sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  ft_min_micro_version=`echo $min_ft_version | \
         sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
  if test x$enable_fttest = xyes ; then
    ft_config_is_lt=""
    if test $ft_config_major_version -lt $ft_min_major_version ; then
      ft_config_is_lt=yes
    else
      if test $ft_config_major_version -eq $ft_min_major_version ; then
        if test $ft_config_minor_version -lt $ft_min_minor_version ; then
          ft_config_is_lt=yes
        else
          if test $ft_config_minor_version -eq $ft_min_minor_version ; then
            if test $ft_config_micro_version -lt $ft_min_micro_version ; then
              ft_config_is_lt=yes
            fi
          fi
        fi
      fi
    fi
    if test x$ft_config_is_lt = xyes ; then
      no_ft=yes
    else
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $FT2_CFLAGS"
      LIBS="$FT2_LIBS $LIBS"
dnl
dnl Sanity checks for the results of freetype-config to some extent
dnl
      AC_RUN_IFELSE(AC_LANG_SOURCE([
#include <ft2build.h>
#include FT_FREETYPE_H
#include <stdio.h>
#include <stdlib.h>

int
main()
{
  FT_Library library;
  FT_Error error;

  error = FT_Init_FreeType(&library);

  if (error)
    return 1;
  else
  {
    FT_Done_FreeType(library);
    return 0;
  }
}
]), [], no_ft=yes, [echo $ac_n "cross compiling; assumed OK... $ac_c"])
      CFLAGS="$ac_save_CFLAGS"
      LIBS="$ac_save_LIBS"
    fi             # test $ft_config_version -lt $ft_min_version
  fi               # test x$enable_fttest = xyes
fi                 # test "$FT2_CONFIG" = "no"
if test x$no_ft = x ; then
   AC_MSG_RESULT(yes)
   ifelse([$2], , :, [$2])
else
   AC_MSG_RESULT(no)
   if test "$FT2_CONFIG" = "no" ; then
     echo "*** The freetype-config script installed by FreeType 2 could not be found."
     echo "*** If FreeType 2 was installed in PREFIX, make sure PREFIX/bin is in"
     echo "*** your path, or set the FT2_CONFIG environment variable to the"
     echo "*** full path to freetype-config."
   else
     if test x$ft_config_is_lt = xyes ; then
       echo "*** Your installed version of the FreeType 2 library is too old."
       echo "*** If you have different versions of FreeType 2, make sure that"
       echo "*** correct values for --with-ft-prefix or --with-ft-exec-prefix"
       echo "*** are used, or set the FT2_CONFIG environment variable to the"
       echo "*** full path to freetype-config."
     else
       echo "*** The FreeType test program failed to run.  If your system uses"
       echo "*** shared libraries and they are installed outside the normal"
       echo "*** system library path, make sure the variable LD_LIBRARY_PATH"
       echo "*** (or whatever is appropiate for your system) is correctly set."
     fi
   fi
   FT2_CFLAGS=""
   FT2_LIBS=""
   ifelse([$3], , :, [$3])
fi
AC_SUBST(FT2_CFLAGS)
AC_SUBST(FT2_LIBS)
])

# Configure paths for  iconv

dnl Usage:
dnl AC_ICONV(MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for ares, and defines
dnl - ICONV_CFLAGS (compiler flags)
dnl - ICONV_LIBS (linker flags, stripping and path)
dnl prerequisites:

AC_DEFUN([AC_ICONV],
[
    dnl check it it is part of the libc
    AC_CHECK_LIB(c, iconv_open, ac_cv_have_iconv=yes, ac_cv_have_iconv=no)

    ICONV_CFLAGS=
    ICONV_LIBS=
    AC_ARG_WITH(iconv, [  --with-iconv=PATH       where iconv is installed],
    [
	if test x$ac_cv_have_iconv = xno; then
	    ac_iconv_path=
	    case "$with_iconv" in
	    'yes') ac_iconv_path="/usr" ;;
	    'no') ;;
	    *) ac_iconv_path=$with_iconv ;;
	    esac
	    if test -n "$ac_iconv_path"; then
		ac_save_ICONVLIBS=$LIBS
		LIBS="-L$ac_iconv_path/lib $LIBS"
		AC_CHECK_LIB(iconv, iconv_open, ac_cv_have_iconv=yes, [])
		if test "$ac_cv_have_iconv" = yes; then
		    ICONV_LIBS="-liconv"
		    if test "$ac_iconv_path" != "/usr"; then
			ICONV_CFLAGS="-I$ac_iconv_path/include"
			ICONV_LIBS="$ac_iconv_path/lib $ICONV_LIBS"
		    fi
		fi
		LIBS=$ac_save_ICONVLIBS
	    fi
	fi
    ])
    
    if test x$ac_cv_have_iconv = xyes ; then
    	AC_MSG_CHECKING([for iconv declaration])
	AC_CACHE_VAL(ac_cv_proto_iconv,
	AC_COMPILE_IFELSE(AC_LANG_PROGRAM([
#include <stdlib.h>
#include <iconv.h>
#ifdef __cplusplus
extern "C"
#endif
#if defined(__STDC__) || defined(__cplusplus)
size_t iconv(iconv_t cd, char**, size_t*, char**, size_t*);
#else
size_t iconv();
#endif
            ], []), ac_cv_proto_iconv="", ac_cv_proto_iconv="const")
        )
	AC_DEFINE_UNQUOTED(ICONV_CONST_CAST, $ac_cv_proto_iconv, [Use casting for iconv's inputbuffer - don't ask me.])
	if test "$ac_cv_proto_iconv" = const; then
	    AC_MSG_RESULT([using const])
	else
	    AC_MSG_RESULT([not using const])
	fi
    	ifelse([$2], , :, [$2])
    else
	ICONV_CFLAGS=""
	ICONV_LIBS=""
	ifelse([$3], , :, [$3])
    fi

    AC_SUBST(ICONV_CFLAGS)
    AC_SUBST(ICONV_LIBS)
])

dnl Usage:
dnl AM_PATH_MAD([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for MAD audio library, and defines
dnl prerequisites:

AC_DEFUN([AM_PATH_MAD],
[
    AC_REQUIRE([AC_CANONICAL_HOST])
    AC_REQUIRE([AC_CANONICAL_TARGET])

    MAD_CFLAGS=
    MAD_LIBS=
    ac_enable_libmad=yes
    AC_ARG_WITH(mad_prefix, [  --with-mad-prefix=PFX	  where MAD library is installed. [[internal]]],
                [], with_mad_prefix=internal)
    if test "$with_mad_prefix" != internal; then
        ac_save_LDFLAGS=$LDFLAGS
        ac_save_LIBS=$LIBS
	if test -n "$with_mad_prefix"; then
            MAD_CFLAGS="-I$with_mad_prefix/include"
	    LDFLAGS="-L$with_mad_prefix/lib"
        fi
        AC_CHECK_LIB(mad, mad_stream_init,
        	     MAD_LIBS="$LDFLAGS -lmad", ac_enable_libmad=no)
        LDFLAGS=$ac_save_LDFLAGS
        LIBS=$ac_save_LIBS
        AC_SUBST(MAD_CFLAGS)
        AC_SUBST(MAD_LIBS)
    else
        AC_MSG_RESULT(checking for mad library... using internal version)
    fi

    AC_ARG_ENABLE(mad_speed, [  --disable-mad-speed     build internal MAD for speed. [[enabled]]],
		  [], enable_mad_speed=yes)
    if test "$enable_mad_speed" = yes; then
	AC_DEFINE(OPT_SPEED, 1, [MAD Define to optimize for speed over accuracy.])
    fi
    AC_ARG_ENABLE(mad, [  --enable-mad-accuracy   build internal MAD for accuracy. [[disabled]]],
		  [], enable_mad=no)
    if test "$enable_mad_speed" = yes -a "$enable_mad_speed" = no; then
	AC_DEFINE(OPT_ACCURACY, 1, [MAD Define to optimize for accuracy over speed.])
    fi

    case "$target" in
	i?86*) AC_DEFINE(FPM_INTEL, 1, [MAD Define intel fixed-point math routines.]) ;;
	arm*) AC_DEFINE(FPM_ARM, 1, [MAD Define arm fixed-point math routines.]) ;;
	mips*) AC_DEFINE(FPM_MIPS, 1, [MAD Define mips fixed-point math routines.]) ;;
	sparc*) AC_DEFINE(FPM_SPARC, 1, [MAD Define sparc fixed-point math routines.]) ;;
	powerpc*) AC_DEFINE(FPM_PPC, 1, [MAD Define powerpc fixed-point math routines.]) ;;
	*) AC_DEFINE(FPM_DEFAULT, 1, [MAD Define default fixed-point math routines.]) ;;
    esac

    AC_ARG_ENABLE(madsso, [  --disable-mad-sso       use subband synthesis optimization. [[enabled]]],
		  [], enable_madsso=yes)
    if test "$enable_madsso" = yes; then
	AC_DEFINE(OPT_SSO, 1, [MAD Define to enable a fast subband synthesis approximation optimization.])
    fi
    AC_ARG_ENABLE(madaso, [  --disable-mad-aso       disable architecture-specific optimizations. [[enabled]]],
		  [], enable_madaso=yes)
    if test "$enable_madaso" = yes; then
    	case "$target" in
	    i?86*) 
                AC_DEFINE(ASO_ZEROCHECK, 1, [MAD Define for fast subband synthesis approximation.])
		;;
	esac
    fi

    if test "$ac_enable_libmad" = yes; then
	ifelse([$1], , :, [$1])
    else
	ifelse([$2], , :, [$2])
    fi
])

# Configure paths for libogg

dnl AM_PATH_OGG([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libogg, and define OGG_CFLAGS and OGG_LIBS
dnl
AC_DEFUN([AM_PATH_OGG],
[dnl
dnl Get the cflags and libraries
dnl
AC_ARG_WITH(ogg-prefix,[  --with-ogg-prefix=PFX   prefix where libogg is installed.],
            OGG_CFLAGS="-I$withval/include"
            OGG_LIBS="-L$withval/lib",
            OGG_CFLAGS=""
            OGG_LIBS="")

    AC_AVM_CHECK_LIB(ogg, [for ogg],
                     OGG_CFLAGS, OGG_LIBS, -logg,
                     [#include <ogg/ogg.h>], [], [$1], [$2])
])

dnl Usage:
dnl AC_CHECK_OSS([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for OSS audio interface, and defines
dnl prerequisites:

AC_DEFUN([AC_CHECK_OSS],
[
    AC_ARG_ENABLE(oss, [  --enable-oss            support the OSS audio API. [[autodetect]]],
		  [], enable_oss=yes)
    if test x$enable_oss = xyes; then
	AC_CACHE_CHECK([for OSS audio support], ac_cv_val_have_oss_audio,
	    [AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
		  #ifdef __NetBSD__
		  #include <sys/ioccom.h>
		  #include <soundcard.h>
		  #else
		  #include <sys/soundcard.h>
		  #endif
		]], [[ int arg = SNDCTL_DSP_SETFRAGMENT; ]])],[ ac_cv_val_have_oss_audio=yes ],[ ac_cv_val_have_oss_audio=no ])
	    ])
	enable_oss=$ac_cv_val_have_oss_audio
    fi
    
    if test x$enable_oss = xyes; then
	AC_CHECK_LIB([ossaudio], [_oss_ioctl])
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

# pkg.m4 - Macros to locate and utilise pkg-config.            -*- Autoconf -*-
# 
# Copyright © 2004 Scott James Remnant <scott@netsplit.com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.

# PKG_PROG_PKG_CONFIG([MIN-VERSION])
# ----------------------------------
AC_DEFUN([PKG_PROG_PKG_CONFIG],
[m4_pattern_forbid([^_?PKG_[A-Z_]+$])
m4_pattern_allow([^PKG_CONFIG(_PATH)?$])
AC_ARG_VAR([PKG_CONFIG], [path to pkg-config utility])dnl
if test "x$ac_cv_env_PKG_CONFIG_set" != "xset"; then
	AC_PATH_TOOL([PKG_CONFIG], [pkg-config])
fi
if test -n "$PKG_CONFIG"; then
	_pkg_min_version=m4_default([$1], [0.9.0])
	AC_MSG_CHECKING([pkg-config is at least version $_pkg_min_version])
	if $PKG_CONFIG --atleast-pkgconfig-version $_pkg_min_version; then
		AC_MSG_RESULT([yes])
	else
		AC_MSG_RESULT([no])
		PKG_CONFIG=""
	fi
		
fi[]dnl
])# PKG_PROG_PKG_CONFIG

# PKG_CHECK_EXISTS(MODULES, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check to see whether a particular set of modules exists.  Similar
# to PKG_CHECK_MODULES(), but does not set variables or print errors.
#
#
# Similar to PKG_CHECK_MODULES, make sure that the first instance of
# this or PKG_CHECK_MODULES is called, or make sure to call
# PKG_CHECK_EXISTS manually
# --------------------------------------------------------------
AC_DEFUN([PKG_CHECK_EXISTS],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
if test -n "$PKG_CONFIG" && \
    AC_RUN_LOG([$PKG_CONFIG --exists --print-errors "$1"]); then
  m4_ifval([$2], [$2], [:])
m4_ifvaln([$3], [else
  $3])dnl
fi])


# _PKG_CONFIG([VARIABLE], [COMMAND], [MODULES])
# ---------------------------------------------
m4_define([_PKG_CONFIG],
[if test -n "$PKG_CONFIG"; then
    if test -n "$$1"; then
        pkg_cv_[]$1="$$1"
    else
        PKG_CHECK_EXISTS([$3],
                         [pkg_cv_[]$1=`$PKG_CONFIG --[]$2 "$3" 2>/dev/null`],
			 [pkg_failed=yes])
    fi
else
	pkg_failed=untried
fi[]dnl
])# _PKG_CONFIG

# _PKG_SHORT_ERRORS_SUPPORTED
# -----------------------------
AC_DEFUN([_PKG_SHORT_ERRORS_SUPPORTED],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])
if $PKG_CONFIG --atleast-pkgconfig-version 0.20; then
        _pkg_short_errors_supported=yes
else
        _pkg_short_errors_supported=no
fi[]dnl
])# _PKG_SHORT_ERRORS_SUPPORTED


# PKG_CHECK_MODULES(VARIABLE-PREFIX, MODULES, [ACTION-IF-FOUND],
# [ACTION-IF-NOT-FOUND])
#
#
# Note that if there is a possibility the first call to
# PKG_CHECK_MODULES might not happen, you should be sure to include an
# explicit call to PKG_PROG_PKG_CONFIG in your configure.ac
#
#
# --------------------------------------------------------------
AC_DEFUN([PKG_CHECK_MODULES],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
AC_ARG_VAR([$1][_CFLAGS], [C compiler flags for $1, overriding pkg-config])dnl
AC_ARG_VAR([$1][_LIBS], [linker flags for $1, overriding pkg-config])dnl

pkg_failed=no
AC_MSG_CHECKING([for $1])

_PKG_CONFIG([$1][_CFLAGS], [cflags], [$2])
_PKG_CONFIG([$1][_LIBS], [libs], [$2])

m4_define([_PKG_TEXT], [Alternatively, you may set the environment variables $1[]_CFLAGS
and $1[]_LIBS to avoid the need to call pkg-config.
See the pkg-config man page for more details.])

if test $pkg_failed = yes; then
        _PKG_SHORT_ERRORS_SUPPORTED
        if test $_pkg_short_errors_supported = yes; then
	        $1[]_PKG_ERRORS=`$PKG_CONFIG --short-errors --errors-to-stdout --print-errors "$2"`
        else 
	        $1[]_PKG_ERRORS=`$PKG_CONFIG --errors-to-stdout --print-errors "$2"`
        fi
	# Put the nasty error message in config.log where it belongs
	echo "$$1[]_PKG_ERRORS" >&AS_MESSAGE_LOG_FD

	ifelse([$4], , [AC_MSG_ERROR(dnl
[Package requirements ($2) were not met:

$$1_PKG_ERRORS

Consider adjusting the PKG_CONFIG_PATH environment variable if you
installed software in a non-standard prefix.

_PKG_TEXT
])],
		[AC_MSG_RESULT([no])
                $4])
elif test $pkg_failed = untried; then
	ifelse([$4], , [AC_MSG_FAILURE(dnl
[The pkg-config script could not be found or is too old.  Make sure it
is in your PATH or set the PKG_CONFIG environment variable to the full
path to pkg-config.

_PKG_TEXT

To get pkg-config, see <http://www.freedesktop.org/software/pkgconfig>.])],
		[$4])
else
	$1[]_CFLAGS=$pkg_cv_[]$1[]_CFLAGS
	$1[]_LIBS=$pkg_cv_[]$1[]_LIBS
        AC_MSG_RESULT([yes])
	ifelse([$3], , :, [$3])
fi[]dnl
])# PKG_CHECK_MODULES
# Configure paths for SDL
# Sam Lantinga 9/21/99
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# shamelessly stolen from Owen Taylor
# modified for avifile

dnl AM_PATH_SDL([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for SDL, and define SDL_CFLAGS and SDL_LIBS
dnl
AC_DEFUN([AM_PATH_SDL],
[dnl 
dnl Get the cflags and libraries from the sdl-config script
dnl
AC_ARG_WITH(sdl-prefix,[  --with-sdl-prefix=PFX   prefix where SDL is installed.],
            sdl_prefix="$withval", sdl_prefix="")
AC_ARG_WITH(sdl-exec-prefix,[  --with-sdl-exec-prefix=PFX exec prefix where SDL is installed.],
            sdl_exec_prefix="$withval", sdl_exec_prefix="")
AC_ARG_ENABLE(sdltest, [  --disable-sdltest       do not try to compile and run a test SDL program.],
		    , enable_sdltest=yes)

  if test x$sdl_exec_prefix != x ; then
     sdl_args="$sdl_args --exec-prefix=$sdl_exec_prefix"
     if test x${SDL_CONFIG+set} != xset ; then
        SDL_CONFIG=$sdl_exec_prefix/bin/sdl-config
     fi
  fi
  if test x$sdl_prefix != x ; then
     sdl_args="$sdl_args --prefix=$sdl_prefix"
     if test x${SDL_CONFIG+set} != xset ; then
        SDL_CONFIG=$sdl_prefix/bin/sdl-config
     fi
  fi
  if test -z "$SDL_CONFIG"; then
      AC_CHECK_PROGS(SDL_MY_CONFIG, sdl-config sdl11-config, "")
      if test -n "$SDL_MY_CONFIG"; then
	   SDL_CONFIG=`which $SDL_MY_CONFIG`
	   AC_MSG_RESULT(setting SDL_CONFIG to $SDL_CONFIG)
      fi
  fi

  AC_REQUIRE([AC_CANONICAL_TARGET])
  PATH="$prefix/bin:$prefix/usr/bin:$PATH"
  AC_PATH_PROG(SDL_CONFIG, sdl-config, no, [$PATH])
  min_sdl_version=ifelse([$1], ,0.11.0,$1)
  AC_MSG_CHECKING(for SDL - version >= $min_sdl_version)
  no_sdl=""
  if test "$SDL_CONFIG" = "no" ; then
    no_sdl=yes
  else
    SDL_CFLAGS=`$SDL_CONFIG $sdlconf_args --cflags`
    SDL_LIBS=`$SDL_CONFIG $sdlconf_args --libs | sed -e 's!-L/usr/lib[[^/]]!!g'`

    sdl_major_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    sdl_minor_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    sdl_micro_version=`$SDL_CONFIG $sdl_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_sdltest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $SDL_CFLAGS"
      LIBS="$LIBS $SDL_LIBS"
dnl
dnl Now check if the installed SDL is sufficiently new. (Also sanity
dnl checks the results of sdl-config to some extent
dnl
      rm -f conf.sdltest
      AC_RUN_IFELSE([AC_LANG_SOURCE([[
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SDL.h"

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main (int argc, char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  /* This hangs on some systems (?)
  system ("touch conf.sdltest");
  */
  { FILE *fp = fopen("conf.sdltest", "a"); if ( fp ) fclose(fp); }

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_sdl_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_sdl_version");
     exit(1);
   }

   if (($sdl_major_version > major) ||
      (($sdl_major_version == major) && ($sdl_minor_version > minor)) ||
      (($sdl_major_version == major) && ($sdl_minor_version == minor) && ($sdl_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'sdl-config --version' returned %d.%d.%d, but the minimum version\n", $sdl_major_version, $sdl_minor_version, $sdl_micro_version);
      printf("*** of SDL required is %d.%d.%d. If sdl-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If sdl-config was wrong, set the environment variable SDL_CONFIG\n");
      printf("*** to point to the correct copy of sdl-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

]])],[],[no_sdl=yes],[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_sdl" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$SDL_CONFIG" = "no" ; then
       echo "*** The sdl-config script installed by SDL could not be found"
       echo "*** If SDL was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the SDL_CONFIG environment variable to the"
       echo "*** full path to sdl-config."
     else
       if test -f conf.sdltest ; then
        :
       else
          echo "*** Could not run SDL test program, checking why..."
          CFLAGS="$CFLAGS $SDL_CFLAGS"
          LIBS="$LIBS $SDL_LIBS"
          AC_LINK_IFELSE([AC_LANG_PROGRAM([[
#include <stdio.h>
#include "SDL.h"

int main(int argc, char *argv[])
{ return 0; }
#undef  main
#define main K_and_R_C_main
]], [[ return 0; ]])],[ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding SDL or finding the wrong"
          echo "*** version of SDL. If it is not finding SDL, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],[ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means SDL was incorrectly installed"
          echo "*** or that you have moved SDL since it was installed. In the latter case, you"
          echo "*** may want to edit the sdl-config script: $SDL_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     SDL_CFLAGS=""
     SDL_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(SDL_CFLAGS)
  AC_SUBST(SDL_LIBS)
  rm -f conf.sdltest
])

AC_DEFUN([MY_TEST_SDL],
[
AC_MSG_CHECKING([for SDL development libraries])
cat > conftest.c <<EOF
void main()
{
}
EOF
SDL_LIBTOOL=`$SDL_CONFIG --prefix`/lib/libSDL.la
if test -r $SDL_LIBTOOL ; then
    if libtool $CC conftest.c $SDL_LIBTOOL $LIBS $SDL_LIBS -o conftest >&5 2>&5; then
	AC_MSG_RESULT([found])
        GOOD_SDL_INSTALLATION=yes
    else
	AC_MSG_RESULT([linking against SDL library failed. Check config.log for details.])
        GOOD_SDL_INSTALLATION=no
    fi
else
    AC_MSG_RESULT([not found])
    GOOD_SDL_INSTALLATION=no
fi
rm -f conftest.c conftest
])

# Configure paths for video4linux

dnl Usage:
dnl AC_CHECK_V4L([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for video4linux interface, and defines
dnl prerequisites:

AC_DEFUN([AC_CHECK_V4L],
[
    AC_ARG_ENABLE(v4l, [  --enable-v4l            support v4l video interface. [[autodetect]]],
		  [], enable_v4l=yes)
    if test "$enable_v4l" = yes; then
	AC_CHECK_HEADER([linux/videodev.h], [], enable_v4l=no)
    fi

    if test "$enable_v4l" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

# Configure paths for video4linux v2

dnl Usage:
dnl AC_CHECK_V4L2([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for video4linux v2 interface, and defines
dnl prerequisites:

AC_DEFUN([AC_CHECK_V4L2],
[
    AC_ARG_ENABLE(v4l2, [  --enable-v4l2           support v4l2 video interface. [[autodetect]]],
		  [], enable_v4l2=yes)
    if test "$enable_v4l2" = yes; then
        AC_CACHE_CHECK([whether system supports Video4Linux2],
                       ac_cv_val_have_v4l2,
                       AC_COMPILE_IFELSE(AC_LANG_PROGRAM([
#include <sys/time.h>
#include <asm/types.h>
#include <linux/videodev2.h>], [
int dummy = V4L2_PIX_FMT_YUV420;
struct v4l2_buffer dummy1 ]), ac_cv_val_have_v4l2=yes, ac_cv_val_have_v4l2=no)
                       )
        test "$ac_cv_val_have_v4l2" = no && enable_v4l2=no
    fi

    if test "$enable_v4l2" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])
dnl    -*- shell-script -*-

dnl    This file is part of the Avifile packages
dnl    and has been heavily modified for its purposes
dnl    Copyright (C) 2002 Zdenek Kabelac (kabi@users.sourceforge.net)
dnl
dnl    Originaly this file was part of the KDE libraries/packages
dnl    Copyright (C) 1997 Janos Farkas (chexum@shadow.banki.hu)
dnl              (C) 1997 Stephan Kulow (coolo@kde.org)

dnl    This file is free software; you can redistribute it and/or
dnl    modify it under the terms of the GNU Library General Public
dnl    License as published by the Free Software Foundation; either
dnl    version 2 of the License, or (at your option) any later version.

dnl    This library is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl    Library General Public License for more details.

dnl    You should have received a copy of the GNU Library General Public License
dnl    along with this library; see the file COPYING.LIB.  If not, write to
dnl    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
dnl    Boston, MA 02111-1307, USA.


dnl ------------------------------------------------------------------------
dnl Find a file (or one of more files in a list of dirs)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN([AC_FIND_FILE],
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

AC_DEFUN([KDE_MOC_ERROR_MESSAGE],
[
    AC_MSG_ERROR([No valid Qt meta object compiler (moc) found!
Please check whether you installed Qt correctly.
You need to have a running moc binary.
configure tried to run $ac_cv_path_moc and the test did not
succeed. If configure should not have tried this one, set
the environment variable MOC to the right one before running
configure.])
])

AC_DEFUN([KDE_UIC_ERROR_MESSAGE],
[
    AC_MSG_WARN([No valid Qt ui compiler (uic) found!
Please check whether you installed Qt correctly.
You need to have a running uic binary.
configure tried to run $ac_cv_path_uic and the test did not
succeed. If configure should not have tried this one, set
the environment variable UIC to the right one before running
configure.])
])

dnl ------------------------------------------------------------------------
dnl Find the meta object compiler in the PATH, in $QTDIR/bin, and some
dnl more usual places
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN([AC_PATH_QT_MOC_UIC],
[
dnl usually qt is installed in such a way it might help to
dnl try this binpath first
    cutlib_binpath=`echo "$ac_qt_libraries" | sed 's%/[[^/]]*$%%'`
    lc_qt_binpath="$ac_qt_binpath:$cutlib_binpath/bin:$PATH:/usr/local/bin:/usr/local/qt3/bin:/usr/local/qt2/bin:/usr/local/qt/bin:/usr/lib/qt3/bin:/usr/lib/qt2/bin:/usr/lib/qt/bin:/usr/bin:/usr/X11R6/bin"
    AC_PATH_PROGS(MOC, moc moc3 moc2, , $lc_qt_binpath)
    dnl AC_PATH_PROGS(UIC, uic, , $lc_qt_binpath)

    if test -z "$MOC"; then
        if test -n "$ac_cv_path_moc"; then
            output=`eval "$ac_cv_path_moc --help 2>&1 | sed -e '1q' | grep Qt"`
        fi
        echo "configure:__oline__: tried to call $ac_cv_path_moc --help 2>&1 | sed -e '1q' | grep Qt" >&AS_MESSAGE_LOG_FD
        echo "configure:__oline__: moc output: $output" >&AS_MESSAGE_LOG_FD

        if test -z "$output"; then
            KDE_MOC_ERROR_MESSAGE
        fi
    fi

    AC_SUBST(MOC)

    dnl We do not need UIC
    dnl [KDE_UIC_ERROR_MESSAGE])
    dnl AC_SUBST(UIC)
])


dnl AC_PATH_QT([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl ------------------------------------------------------------------------
dnl Try to find the Qt headers and libraries.
dnl $(QT_LIBS) will be -Lqtliblocation (if needed) -lqt_library_name
dnl and $(QT_CFLAGS) will be -Iqthdrlocation (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN([AC_PATH_QT],
[
AC_REQUIRE([AC_PATH_XTRA])

ac_have_qt=yes
ac_qt_binpath=
ac_qt_includes=
ac_qt_libraries=
ac_qt_notfound=
qt_libraries=
qt_includes=
min_qt_version=ifelse([$1], ,100, $1)

AC_ARG_WITH(qt_prefix, [  --with-qt-prefix        where the root of Qt is installed.],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
       ac_qt_binpath="$withval"/bin
    ])

test -n "$QTDIR" && ac_qt_binpath="$ac_qt_binpath:$QTDIR/bin:$QTDIR"

AC_ARG_WITH(qt_includes, [  --with-qt-includes      where the Qt includes are installed.],
    [ ac_qt_includes=$withval ])

AC_ARG_WITH(qt_libraries, [  --with-qt-libraries     where the Qt library is installed.],
    [ ac_qt_libraries=$withval ])

if test -z "$ac_qt_includes" || test -z "$ac_qt_libraries" ; then
    AC_CACHE_VAL(ac_cv_have_qt,
    [ AC_LANG_PUSH(C++)
      # try to guess Qt locations
      # various paths from various distros -
      # you are welcome to suggest another
	qt_incdirs="$QTINC
            /usr/local/lib/qt3/include
            /usr/local/lib/qt2/include
            /usr/local/qt/include
            /usr/local/include
            /usr/lib/qt-3.1/include
            /usr/lib/qt3/include
            /usr/lib/qt-2.3.1/include
            /usr/lib/qt2/include
            /usr/include/qt3
            /usr/include/qt
            /usr/lib/qt/include
            $x_includes/qt3
            $x_includes/qt2
            $x_includes/X11/qt
            $x_includes
            /usr/include"
	qt_libdirs="$QTLIB
            /usr/local/lib/qt3/lib
            /usr/local/lib/qt2/lib
            /usr/local/qt/lib
            /usr/local/lib
            /usr/lib/qt-3.1/lib
            /usr/lib/qt3/lib
            /usr/lib/qt-2.3.1/lib
            /usr/lib/qt2/lib
            /usr/lib/qt/lib
            /usr/lib/qt
            $x_libraries/qt3
            $x_libraries/qt2
            $x_libraries
            /usr/lib"

	if test -n "$QTDIR" ; then
            qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
	    qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
        fi

	qt_incdirs="$ac_qt_includes $qt_incdirs"
	qt_libdirs="$ac_qt_libraries $qt_libdirs"

	AC_FIND_FILE(qmovie.h, $qt_incdirs, qt_incdir)
	ac_qt_includes="$qt_incdir"

	qt_libdir=NONE
	for dir in $qt_libdirs ; do
            for qtname in qt3 qt2 qt ; do
                try="ls -1 $dir/lib$qtname.* $dir/lib$qtname-mt.*"
                if test -n "`$try 2> /dev/null`"; then
                      test -z "$QTNAME" && QTNAME=$qtname
                      qt_libdir=$dir
                      break
                fi
            done
            if test x$qt_libdir != xNONE ; then
                break
            fi
	    echo "tried $dir" >&AS_MESSAGE_LOG_FD
        done

        ac_qt_libraries=$qt_libdir

	test -z "$QTNAME" && QTNAME=qt
        ac_QTNAME=$QTNAME

	ac_save_QTLIBS=$LIBS
	LIBS="-L$ac_qt_libraries $LIBS $PTHREAD_LIBS"
        AC_CHECK_LIB($QTNAME-mt, main, ac_QTNAME=$QTNAME-mt)
	LIBS=$ac_save_QTLIBS

	ac_cv_have_qt="ac_have_qt=yes ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries ac_QTNAME=$ac_QTNAME"

        if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NONE ; then
            ac_cv_have_qt="ac_have_qt=no"
            ac_qt_notfound="(headers)"
            if test "$ac_qt_includes" = NO; then
                if test "$ac_qt_libraries" = NONE; then
                    ac_qt_notfound="(headers and libraries)"
                fi
            else
                ac_qt_notfound="(libraries)";
            fi
        fi
        AC_LANG_POP
    ])
    eval "$ac_cv_have_qt"
else
    for qtname in qt3 qt2 qt ; do
        try="ls -1 $ac_qt_libraries/lib$qtname.* $ac_qt_libraries/lib$qtname-mt.*"
        if test -n "`$try 2> /dev/null`"; then
            test -z "$QTNAME" && QTNAME=$qtname
            break
        fi
    done
    ac_QTNAME=$QTNAME
    ac_save_QTLIBS=$LIBS
    LIBS="-L$ac_qt_libraries $LIBS $PTHREAD_LIBS"
    AC_CHECK_LIB($QTNAME-mt, main, ac_QTNAME=$QTNAME-mt)
    LIBS=$ac_save_QTLIBS
fi

if test x$ac_have_qt = xyes ; then
    AC_MSG_CHECKING([for Qt library (version >= $min_qt_version)])
    AC_CACHE_VAL(ac_cv_qt_version,
    [
	AC_LANG_PUSH(C++)
	ac_save_QTCXXFLAGS=$CXXFLAGS
	ac_save_QTLIBS=$LIBS
	CXXFLAGS="$CXXFLAGS -I$ac_qt_includes"
	LIBS="-L$ac_qt_libraries -l$ac_QTNAME $X_LIBS $LIBS $PTHREAD_LIBS"
	AC_RUN_IFELSE([AC_LANG_SOURCE([[
	    /*#include <qapplication.h>*/
	    /*#include <qmovie.h>*/
	    #include <qstring.h>
	    #include <qglobal.h>
	    #include <stdio.h>

	    int main(int argc, char* argv[]) {
		/*QApplication a( argc, argv );*/
		/*QMovie m; int s = m.speed();*/
		QString qa("test");
		unsigned int v = QT_VERSION;
		FILE* f = fopen("conf.qttest", "w");
		if (v > 400) v = (((v >> 16) & 0xff) * 100) + (((v >> 8) & 0xff) * 10) + (v & 0xff);
		if (f) fprintf(f, "%d\n", v);
		return 0;
	    }
	]])],[ AC_MSG_RESULT(yes); ac_cv_qt_version=`cat conf.qttest`; rm -f conf.qttest ],[ AC_MSG_RESULT(no); ac_have_qt=no; ac_cv_qt_version=ERROR ],[ echo $ac_n "cross compiling; assumed OK... $ac_c" ])

	if test x$ac_cv_qt_version = xERROR ; then
	    AC_MSG_WARN([
*** Could not run Qt test program, checking why...
*** Configure discovered/uses these settings:
*** Qt libraries: $ac_qt_libraries
*** Qt headers: $ac_qt_includes
*** Note:
***    Compilation of Qt utilities also might be turned off (if not wanted).
***    If you are experiencing problems which will not be described
***    bellow please report then on 'avifile@prak.org' mailing list
***    (i.e. some misdetection or omitted path)]
             )
             AC_LINK_IFELSE([AC_LANG_PROGRAM([[ #include <qstring.h> ]], [[ QString qa("test") ]])],[ AC_MSG_ERROR([
*** Qt test program compiled, but did not run. This usually means
*** that the run-time linker is not finding Qt library or finding the wrong
*** version of Qt. If it is not finding Qt, you will need to set your
*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point
*** to the installed location  Also, make sure you have run ldconfig if that
*** is required on your system.
***
*** If you have an old version installed, it is best to remove it, although
*** you may also be able to get things to work by modifying LD_LIBRARY_PATH
***
*** i.e. bash> export LD_LIBRARY_PATH=$ac_qt_libraries:\$LD_LIBRARY_PATH]) ],[ AC_MSG_ERROR([
*** The test program failed to compile or link. See the file config.log for the
*** exact error that occured. This usually means Qt was incorrectly installed
*** or that you have moved Qt since it was installed. In the latter case, you
*** may want to set QTDIR shell variable
***
*** Another possibility is you try to link Qt libraries compiled with
*** different version of g++. Unfortunately you can not mix C++ libraries
*** and object files created with different C++ compiler
*** i.e. g++-2.96 libraries and g++-2.95 objects
*** The most common case: Some users seems to be downgrading their
*** compiler without thinking about consequencies...]) 
	    ])
	fi

	CXXFLAGS=$ac_save_QTCXXFLAGS
	LIBS=$ac_save_QTLIBS
	AC_LANG_POP
     ])
     qt_version=$ac_cv_qt_version
fi

if test x$ac_have_qt != xyes; then
    AC_MSG_WARN([
*** Could not find usable Qt $ac_qt_notfound on your system!
*** If it _is_ installed, delete ./config.cache and re-run ./configure,
*** specifying path to Qt headers and libraries in configure options.
*** Switching off Qt compilation!])
    ac_have_qt=no
else
    AC_MSG_RESULT([found $ac_QTNAME version $qt_version, libraries $ac_qt_libraries, headers $ac_qt_includes])
    if test $min_qt_version -le $qt_version ; then
        qt_libraries=$ac_qt_libraries
        qt_includes=$ac_qt_includes

        if test "$qt_includes" = "$x_includes" -o -z "$qt_includes" ; then
            QT_CFLAGS=
        else
            QT_CFLAGS="-I$qt_includes"
            all_includes="$QT_CFLAGS $all_includes"
        fi
	QT_CFLAGS="$QT_CFLAGS -DQT_THREAD_SUPPORT"

        if test "$qt_libraries" = NONE -o "$qt_libraries" = "$x_libraries" -o -z "$qt_libraries" -o "$qt_libraries" = "/usr/lib" ; then
            QT_LIBS=
        else
            QT_LIBS="-L$qt_libraries"
            all_libraries="$QT_LIBS $all_libraries"
        fi

        QT_LIBS="$QT_LIBS -l$ac_QTNAME"

        if test x$ac_have_qt = xyes ; then
            AC_PATH_QT_MOC_UIC
        fi

        AC_SUBST(qt_version)
        AC_SUBST(QT_CFLAGS)
        AC_SUBST(QT_LIBS)
    else
        AC_MSG_WARN([
*** Unsupported old version of Qt library found. Please upgrade.])
        ac_have_qt=no
    fi
fi

if test x$ac_have_qt = xyes ; then
    ifelse([$2], , :, [$2])
else
    ifelse([$3], , :, [$3])
fi

])


AC_DEFUN([AC_FIND_ZLIB],
[
    AC_CACHE_CHECK([for libz], ac_cv_lib_z,
		   ac_save_LIBS=$LIBS
		   LIBS="$LIBS -lz"
		   AC_LINK_IFELSE(AC_LANG_PROGRAM([#include<zlib.h>], [return (zlibVersion() == ZLIB_VERSION)]),
                   ac_cv_lib_z=yes, ac_cv_lib_z=no)
		   LIBS=$ac_save_LIBS)
    if test "$ac_cv_lib_z" = yes; then
	Z_LIBS="-lz"
	have_zlib=yes
	ifelse([$1], , :, [$1])
    else
	Z_LIBS=
	have_zlib=no
	ifelse([$2], , :, [$2])
    fi
    AC_SUBST(Z_LIBS)
])


AC_DEFUN([AC_FIND_PNG],
[
AC_REQUIRE([AC_FIND_ZLIB])
AC_MSG_CHECKING([for libpng])
AC_CACHE_VAL(ac_cv_lib_png,
[ac_save_LIBS="$LIBS"
LIBS="$all_libraries -lpng $LIBZ -lm -lX11 $LIBSOCKET"
AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include<png.h>]], [[
    png_structp png_ptr = png_create_read_struct(  // image ptr
		PNG_LIBPNG_VER_STRING, 0, 0, 0 );
    return( png_ptr != 0 );
    ]])],[eval "ac_cv_lib_png='-lpng $LIBZ -lm'"],[eval "ac_cv_lib_png=no"])
    LIBS=$ac_save_LIBS
])
if eval "test ! \"`echo $ac_cv_lib_png`\" = no"; then
  AC_DEFINE_UNQUOTED(HAVE_LIBPNG)
  LIBPNG="$ac_cv_lib_png"
  AC_SUBST(LIBPNG)
  AC_MSG_RESULT($ac_cv_lib_png)
else
  AC_MSG_RESULT(no)
  LIBPNG=""
  AC_SUBST(LIBPNG)
fi
])


dnl just a wrapper to clean up configure.in
AC_DEFUN([KDE_PROG_LIBTOOL],
[
AC_REQUIRE([AM_ENABLE_SHARED])
AC_REQUIRE([AM_ENABLE_STATIC])
dnl libtool is only for C, so I must force him
dnl to find the correct flags for C++
ac_save_cc=$CC
ac_save_cflags="$CFLAGS"
CC=$CXX
CFLAGS="$CXXFLAGS"
dnl AM_PROG_LIBTOOL dnl for libraries
CC=$ac_save_cc
CFLAGS="$ac_save_cflags"
])


dnl Check for the type of the third argument of getsockname
AC_DEFUN([AC_CHECK_KSIZE_T],
[AC_MSG_CHECKING(for the third argument of getsockname)
AC_LANG([C++])
AC_CACHE_VAL(ac_cv_ksize_t,
[AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#include <sys/types.h>
#include <sys/socket.h>
]], [[
socklen_t a=0;
getsockname(0,(struct sockaddr*)0, &a);
]])],[ac_cv_ksize_t=socklen_t],[ac_cv_ksize_t=])
if test -z "$ac_cv_ksize_t"; then
ac_save_cxxflags="$CXXFLAGS"
if test "$GCC" = "yes"; then
  CXXFLAGS="-Werror $CXXFLAGS"
fi
AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[
#include <sys/types.h>
#include <sys/socket.h>
]], [[
int a=0;
getsockname(0,(struct sockaddr*)0, &a);
]])],[ac_cv_ksize_t=int],[ac_cv_ksize_t=size_t])
CXXFLAGS=$ac_save_cxxflags
fi
])

if test -z "$ac_cv_ksize_t"; then
  ac_cv_ksize_t=int
fi

AC_MSG_RESULT($ac_cv_ksize_t)
AC_DEFINE_UNQUOTED(ksize_t, $ac_cv_ksize_t)

])



# Search path for a program which passes the given test.
# Ulrich Drepper <drepper@cygnus.com>, 1996.

# serial 1
# Stephan Kulow: I appended a _KDE against name conflicts

dnl AM_PATH_PROG_WITH_TEST_KDE(VARIABLE, PROG-TO-CHECK-FOR,
dnl   TEST-PERFORMED-ON-FOUND_PROGRAM [, VALUE-IF-NOT-FOUND [, PATH]])
AC_DEFUN([AM_PATH_PROG_WITH_TEST_KDE],
[# Extract the first word of "$2", so it can be a program name with args.
    set dummy $2; ac_word=[$]2
    AC_MSG_CHECKING([for $ac_word])
    AC_CACHE_VAL(ac_cv_path_$1,
        [case "[$]$1" in
          /*) ac_cv_path_$1="[$]$1" # Let the user override the test with a path.
              ;;
          *)
              IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
              for ac_dir in ifelse([$5], , $PATH, [$5]); do
                test -z "$ac_dir" && ac_dir=.
                if test -f $ac_dir/$ac_word; then
                  if [$3]; then
                    ac_cv_path_$1="$ac_dir/$ac_word"
                    break
                  fi
                fi
              done
              IFS="$ac_save_ifs"
              dnl If no 4th arg is given, leave the cache variable unset,
              dnl so AC_PATH_PROGS will keep looking.
              ifelse([$4], , , [  test -z "[$]ac_cv_path_$1" && ac_cv_path_$1="$4"
                    ])
              ;;
         esac
        ])
    $1="$ac_cv_path_$1"
    if test -n "[$]$1"; then
      AC_MSG_RESULT([$]$1)
    else
      AC_MSG_RESULT(no)
    fi
    AC_SUBST($1)dnl
])



AC_DEFUN([AM_DISABLE_LIBRARIES],
[
    AC_PROVIDE([AM_ENABLE_STATIC])
    AC_PROVIDE([AM_ENABLE_SHARED])
    enable_static=no
    enable_shared=no
])






# Check whether LC_MESSAGES is available in <locale.h>.
# Ulrich Drepper <drepper@cygnus.com>, 1995.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU General Public
# License or the GNU Library General Public License but which still want
# to provide support for the GNU gettext functionality.
# Please note that the actual code of the GNU gettext library is covered
# by the GNU Library General Public License, and the rest of the GNU
# gettext package package is covered by the GNU General Public License.
# They are *not* in the public domain.

# serial 2

AC_DEFUN([AM_LC_MESSAGES],
[
    if test $ac_cv_header_locale_h = yes; then
    AC_CACHE_CHECK([for LC_MESSAGES], am_cv_val_LC_MESSAGES,
      [AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <locale.h>]], [[return LC_MESSAGES]])],[am_cv_val_LC_MESSAGES=yes],[am_cv_val_LC_MESSAGES=no])])
    if test $am_cv_val_LC_MESSAGES = yes; then
      AC_DEFINE(HAVE_LC_MESSAGES, 1,
        [Define if your <locale.h> file defines LC_MESSAGES.])
    fi
  fi
])


dnl AM_PATH_LINUX([DEFAULT PATH, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl define LINUX_PATH and LINUX_CFLAGS
AC_DEFUN([AM_PATH_LINUX],
[
    AC_ARG_WITH(linux_prefix, [  --with-linux-prefix=PFX where are linux sources [[=/usr/src/linux]]],
	        [], with_linux_prefix=ifelse([$1], [], /usr/src/linux, $1))
    if test -f $with_linux_prefix/include/linux/modversions.h ; then
	LINUX_CFLAGS="-D__KERNEL__ -DMODULE -I$with_linux_prefix/include -include $with_linux_prefix/include/linux/modversions.h"
	LINUX_PREFIX=$with_linux_prefix
    else
        LINUX_CFLAGS=""
        LINUX_PREFIX=""
    fi
    AC_SUBST(LINUX_CFLAGS)
    AC_SUBST(LINUX_PREFIX)

    if test -n "$LINUX_PREFIX"; then
        ifelse([$2], [], [:], [$2])
    else
        ifelse([$3], [], [:], [$3])
    fi
])


dnl
dnl AC_AVM_CHECK_LIB([NAME, text [, CFLAGS [, LIBS [, ADLIBS [, HEADER [, CODE
dnl      [, OK [, FAIL ]]]]]]])
dnl
AC_DEFUN([AC_AVM_CHECK_LIB],
[
    AC_ARG_ENABLE($1test, [  --disable-$1test      do not try to compile and run a test $1 program.],
		  [], enable_$1test=yes)

    test "${have_$1+set}" = set || have_$1=yes

    if test "$have_$1" = yes -a "$enable_$1test" = yes; then
	AC_CACHE_CHECK([$2],
		       ac_cv_val_have_$1, [
		       rm -f conf.$1test
		       ac_save_CFLAGS=$CFLAGS
		       ac_save_LDFLAGS=$LDFLAGS
		       ac_save_LIBS=$LIBS
		       CFLAGS="$CFLAGS $[$3]"
		       LDFLAGS="$LDFLAGS $[$4]"
		       LIBS="$LIBS $5"
		       AC_RUN_IFELSE(AC_LANG_SOURCE([#include <stdlib.h>
$6

int main() {
    int ret = 0;
    $7;
    system("touch conf.$1test");
    return ret; 
}
                       ]), ac_cv_val_have_$1=yes, ac_cv_val_have_$1=no,
                       [ echo $ac_n "cross compiling; assumed OK... $ac_c" ])
                       if test ! -f conf.$1test; then
                           AC_MSG_WARN([Could not run $1 test program, checking why...])
                           AC_LINK_IFELSE(AC_LANG_PROGRAM([$6], []), [
AC_MSG_RESULT([*** The test program compiled, but did not run. This usually means
*** that the run-time linker is not finding $1 or finding the wrong
*** version of $1. If it is not finding $1, you will need to set your
*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point
*** to the installed location  Also, make sure you have run ldconfig if that
*** is required on your system
***
*** If you have an old version installed, it is best to remove it, although
*** you may also be able to get things to work by modifying LD_LIBRARY_PATH])], [
AC_MSG_RESULT([*** The test program failed to compile or link. See the file config.log for the
*** exact error that occured. This usually means $1 was incorrectly installed.])])
                       fi
                       rm -f conf.$1test
		       CFLAGS=$ac_save_CFLAGS
		       LDFLAGS=$ac_save_LDFLAGS 
		       LIBS=$ac_save_LIBS ])
	test "$ac_cv_val_have_$1" = no && have_$1=no
    fi

    if test "$have_$1" = yes; then
	$4="[$]$4 $5"
	ifelse([$8], , :, [$8])
    else
	$3=""
	$4=""
	ifelse([$9], , :, [$9])
    fi
    AC_SUBST($3)
    AC_SUBST($4)
])
# Configure paths for VIDIX

dnl Check if vidix support should be build

AC_DEFUN([AM_PATH_VIDIX],
[
    AC_ARG_ENABLE(vidix, [  --disable-vidix         build vidix drivers. [[enabled]]],
		  [], enable_vidix=yes)
    AC_MSG_CHECKING([for vidix])
    if test "$enable_vidix" = yes -a "$ac_cv_prog_AWK" != no; then
      case "$target" in
        i?86-*-linux* | k?-*-linux* | athlon-*-linux*)
          enable_vidix=yes
          enable_linux=yes
          ;;
        i386-*-freebsd*)
          enable_vidix=yes
          enable_dha_kmod=no
          ;;
        *)
          enable_dha_kmod=no
          enable_vidix=no
          ;;
      esac
    fi
dnl for now without linux kernel support
    enable_linux=no 
    test "$have_x" = no && enable_vidix=no

    AC_MSG_RESULT([$enable_vidix])

    if test "$enable_vidix" = yes ; then
    	AC_DEFINE(HAVE_VIDIX, 1, [Define if you want to have vidix support.])
    fi
])

# Configure paths for libvorbis

dnl AM_PATH_VORBIS([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libvorbis, and define VORBIS_CFLAGS and VORBIS_LIBS
dnl
AC_DEFUN([AM_PATH_VORBIS],
[
    AC_ARG_WITH(vorbis-prefix, [  --with-vorbis-prefix=PFX prefix where libvorbis is installed.],
                VORBIS_CFLAGS="-I$withval/include"
                VORBIS_LIBS="-L$withval/lib",
                VORBIS_CFLAGS=""
                VORBIS_LIBS="")

    AC_AVM_CHECK_LIB(vorbis, [for vorbis],
                     VORBIS_CFLAGS, VORBIS_LIBS, -lvorbis -lm,
                     [#include <vorbis/codec.h>], [], [$1], [$2])

dnl VORBISFILE_LIBS="-lvorbisfile"
dnl VORBISENC_LIBS="-lvorbisenc"
dnl LIBS="$LIBS $VORBIS_LIBS $OGG_LIBS"
dnl VORBISFILE_LIBS="" VORBISENC_LIBS=""
dnl AC_SUBST(VORBISFILE_LIBS)
dnl AC_SUBST(VORBISENC_LIBS)
])

# Configure paths for libxvidcore

dnl AM_PATH_XVID([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libxvidcore, and define XVID_CFLAGS and XVID_LIBS
dnl
AC_DEFUN([AM_PATH_XVID],
[
    AC_ARG_WITH(xvid_prefix, [  --with-xvid-prefix=PFX  where old XviD is installed.],
		[], with_xvid_prefix="")

    XVID_CFLAGS=""
    XVID_LIBS=""

    have_xvid=no
    ac_save_CPPFLAGS=$CPPFLAGS
    if test -n "$with_xvid_prefix" ; then
	CPPFLAGS="-I$with_xvid_prefix $CPPFLAGS"
	AC_CHECK_HEADER(include/xvid.h,
			XVID_CFLAGS="-I$with_xvid_prefix/include"
			XVID_LIBS="-L$with_xvid_prefix/lib"
			have_xvid=yes)
	if test "$have_xvid" = no ; then
	    AC_CHECK_HEADER(xvid.h,
			    XVID_CFLAGS="-I$with_xvid_prefix"
			    XVID_LIBS="-L$with_xvid_prefix"
			    have_xvid=yes)
	fi
    else
	AC_CHECK_HEADER(xvid.h, have_xvid=yes)
    fi
    CPPFLAGS=$ac_save_CPPFLAGS

    AC_AVM_CHECK_LIB(xvid, [for xvid_init in -lxvidcore],
                     XVID_CFLAGS, XVID_LIBS, -lxvidcore, [
#include <stdio.h>
#include <xvid.h>], [
    XVID_INIT_PARAM xinit;

    xinit.cpu_flags = 0;
    xvid_init(NULL, 0, &xinit, NULL);

    if (xinit.api_version != API_VERSION) {
        printf("Header file and library are out of sync. Header file supports\n"
               "version %d.%d API and shared library supports version %d.%d API.\n",
               API_VERSION >> 16, API_VERSION & 0xFFFF,
               xinit.api_version >> 16, xinit.api_version & 0xFFFF);
        ret = 1;
    }		     ], [$1], [$2])
])

# Configure paths for libxvidcore version 1.0

dnl AM_PATH_XVID([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libxvidcore, and define XVID4_CFLAGS and XVID4_LIBS
dnl
AC_DEFUN([AM_PATH_XVID4],
[
    AC_ARG_WITH(xvid4_prefix, [  --with-xvid4-prefix=PFX where XviD4 is installed.],
		[], with_xvid4_prefix="")

    XVID4_CFLAGS=""
    XVID4_LIBS=""

    have_xvid4=no
    ac_save_CPPFLAGS=$CPPFLAGS
    if test -n "$with_xvid4_prefix" ; then
	dnl user has specified extra path for XviD instalation
	CPPFLAGS="-I$with_xvid4_prefix $CPPFLAGS"
	AC_CHECK_HEADER(include/xvid.h,
			XVID4_CFLAGS="-I$with_xvid4_prefix/include"
			XVID4_LIBS="-L$with_xvid4_prefix/lib"
			have_xvid4=yes)
	if test "$have_xvid4" = no; then
	    AC_CHECK_HEADER(xvid.h,
			    XVID4_CFLAGS="-I$with_xvid4_prefix"
			    XVID4_LIBS="-L$with_xvid4_prefix"
			    have_xvid4=yes)
	fi
    else
	AC_CHECK_HEADER(xvid.h, have_xvid4=yes)
    fi
    CPPFLAGS=$ac_save_CPPFLAGS

dnl
dnl Now check if the installed XviD is sufficiently new.
dnl
    AC_AVM_CHECK_LIB(xvid4, [for xvid_global in -lxvidcore (4)],
                     XVID4_CFLAGS, XVID4_LIBS, -lxvidcore, [
#include <stdio.h>
#include <string.h>
#include <xvid.h>], [

  xvid_gbl_info_t xinfo;
  memset(&xinfo, 0, sizeof(xinfo));
  xinfo.version = XVID_VERSION;

  if (xvid_global(NULL, XVID_GBL_INIT, &xinfo, NULL) == XVID_ERR_FAIL) {
    printf("Header file and library are out of sync. Header file supports\n"
	   "version %d.%d API and shared library supports version %d.%d API.\n",
	   XVID_VERSION >> 16, XVID_VERSION & 0xFFFF,
	   xinfo.version >> 16, xinfo.version & 0xFFFF);
    ret = 1;
  }		     ], [$1], [$2])
])

