/*
			      File Browser
 */

#ifndef FB_H
#define FB_H

#include <gtk/gtk.h>


/*
 *	File Type:
 */
typedef struct _fb_type_struct		fb_type_struct;
struct _fb_type_struct {

	gchar		*ext,		/* Space separated list of extensions */
			*name;		/* Description of this file type */

};


extern gint FileBrowserInit(void);
extern void FileBrowserSetStyle(GtkRcStyle *rc_style);
extern void FileBrowserSetTransientFor(GtkWidget *w);
extern gboolean FileBrowserIsQuery(void);
extern void FileBrowserBreakQuery(void);
extern GtkWidget *FileBrowserGetToplevel(void);
extern void FileBrowserReset(void);
extern gboolean FileBrowserGetResponse(
	const gchar *title,
	const gchar *ok_label, const gchar *cancel_label,
	const gchar *path,
	fb_type_struct **type, gint total_types,
	gchar ***path_rtn, gint *path_total_rtns,
	fb_type_struct **type_rtn
);
extern void FileBrowserMap(void);
extern void FileBrowserUnmap(void);
extern void FileBrowserShutdown(void);

extern void FileBrowserShowHiddenObjects(gboolean show);
extern void FileBrowserListStandard(void);
extern void FileBrowserListDetailed(void);

extern gint FileBrowserTypeListNew(
	fb_type_struct ***list, gint *total,
	const gchar *ext,
	const gchar *name
);
extern void FileBrowserDeleteTypeList(
	fb_type_struct **t, gint total
);


#endif	/* FB_H */
