#ifndef OBJ_H
#define OBJ_H

#include <glib.h>


typedef struct _obj_struct		obj_struct;


/*
 *	Object:
 */
struct _obj_struct {

	gchar		*name,
			*path;
	gboolean	recursive,
			executables_only;
	gulong		last_runned;

};
#define OBJ(p)		((obj_struct *)(p))


extern obj_struct *ObjNew(void);
extern obj_struct *ObjCopy(const obj_struct *obj);
extern void ObjDelete(obj_struct *obj);

extern GList *ObjDDEBufferParse(const guint8 *buf, gint buf_len);
extern guint8 *ObjDDEBufferAppend(
        guint8 *buf, gint *buf_len,
        const obj_struct *obj  
);
extern GList *ObjDDEBufferParsePath(const guint8 *buf, gint buf_len);
extern guint8 *ObjDDEBufferAppendPath(
        guint8 *buf, gint *buf_len, 
        const obj_struct *obj
);


#endif	/* OBJ_H */
