/*
			    Win
 */
#ifndef WIN_H
#define WIN_H

#include <stdio.h>
#include <gtk/gtk.h>
#include "toolbar.h"
#include "obj.h"
#include "hview.h"


typedef struct _win_opid_struct         win_opid_struct;
#define WIN_OPID(p)			((win_opid_struct *)(p))
typedef struct _win_db_item_struct	win_db_item_struct;
#define WIN_DB_ITEM(p)			((win_db_item_struct *)(p))
typedef struct _win_struct              win_struct;
#define WIN(p)				((win_struct *)(p))
typedef struct _win_scan_context_struct	win_scan_context_struct;
#define WIN_SCAN_CONTEXT(p)		((win_scan_context_struct *)(p))
typedef struct _win_pattern_dlg_struct	win_pattern_dlg_struct;
#define WIN_PATTERN_DLG(p)		((win_pattern_dlg_struct *)(p))


/*
 *	Operation IDs:
 */
typedef enum {

	WIN_OPID_SEPARATOR				= 10,

	WIN_OPID_CLOSE					= 100,
	WIN_OPID_EXIT					= 101,

	WIN_OPID_ADD					= 200,
	WIN_OPID_EDIT					= 201,
	WIN_OPID_REMOVE					= 202,

	WIN_OPID_NEW					= 300,
	WIN_OPID_CUT					= 310,
	WIN_OPID_COPY					= 311,
	WIN_OPID_PASTE					= 312,
	WIN_OPID_DELETE					= 320,
	WIN_OPID_SELECT_ALL				= 330,
	WIN_OPID_UNSELECT_ALL				= 331,
	WIN_OPID_INVERT_SELECTION			= 332,
	WIN_OPID_PROPERTIES				= 340,

	WIN_OPID_START					= 400,
	WIN_OPID_STOP					= 401,
	WIN_OPID_PAUSE_RESUME				= 402,
	WIN_OPID_LOCATION				= 410,
	WIN_OPID_RECURSIVE				= 411,
	WIN_OPID_EXECUTABLES_ONLY			= 412,
	WIN_OPID_IGNORE_LINKS				= 413,
	WIN_OPID_SCANNER_SETTINGS			= 490,

	WIN_OPID_RESULTS_RECYCLE			= 500,
	WIN_OPID_RESULTS_MOVE				= 501,
	WIN_OPID_RESULTS_SELECT_ALL			= 510,
	WIN_OPID_RESULTS_UNSELECT_ALL			= 511,
	WIN_OPID_RESULTS_INVERT_SELECTION		= 512,
	WIN_OPID_RESULTS_REPORT				= 520,
	WIN_OPID_RESULTS_OPEN				= 530,
	WIN_OPID_RESULTS_SAVE_AS			= 531,
	WIN_OPID_RESULTS_CLEAR				= 540,

	WIN_OPID_DB_REFRESH				= 600,
	WIN_OPID_DB_PATTERN_DETAILS			= 610,
	WIN_OPID_DB_LOCATION				= 620,
	WIN_OPID_DB_UPDATE_NET				= 670,

	WIN_OPID_VIEW_SCAN_PAGE				= 710,
	WIN_OPID_VIEW_RESULTS_PAGE			= 711,
	WIN_OPID_VIEW_DB_PAGE				= 712,
	WIN_OPID_VIEW_TOOLBAR				= 720,
	WIN_OPID_VIEW_STATUSBAR				= 721,

	WIN_OPID_HELP_CONTENTS				= 1000,
	WIN_OPID_HELP_SCANNING				= 1001,
	WIN_OPID_HELP_UPDATING				= 1002,
	WIN_OPID_ABOUT					= 1100

} win_opid;


/*
 *      Win Operation ID:
 */
struct _win_opid_struct {

	win_opid	id;
	win_struct	*win;        

	gboolean	allow_multiple;
	toolbar_item_type	item_type;

	gchar		*button_name,
			*menu_name,
			*tooltip;

	guint		accel_key,
			accel_mods;

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

	void (*func_cb)(
		GtkWidget *,		/* GtkWidget */
		gpointer		/* Win */
	);
	gint (*enter_func_cb)(
		GtkWidget *,		/* GtkWidget */
		GdkEventCrossing *,	/* GdkEventCrossing */
		gpointer		/* OPID */
	);
	gint (*leave_func_cb)(
		GtkWidget *,		/* GtkWidget */
		GdkEventCrossing *,	/* GdkEventCrossing */
		gpointer		/* OPID */             
	);

};


/*
 *	Page Numbers:
 */
typedef enum {
	WIN_PAGE_NUM_SCAN,
	WIN_PAGE_NUM_RESULTS,
	WIN_PAGE_NUM_DB
} win_page_num;


/*
 *	Datbase Item Types:
 */
typedef enum {
	WIN_DB_ITEM_TYPE_PATTERN,
	WIN_DB_ITEM_TYPE_FOLDER
} win_db_item_type;

/*
 *	Database Item:
 */
struct _win_db_item_struct {

	win_db_item_type	type;
	gchar		*name;

};


/*
 *	Win:
 */
struct _win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing,
			paused;
	gint		busy_count,
			passive_busy_count,
			freeze_count,
			stop_count;
	gpointer	core;

	GList		*opid;

	GtkWidget	*main_vbox;

	gboolean	menubar_map_state;
	GtkWidget	*menubar_handle,
			*menubar;

	GtkWidget	*file_mlabel,
			*new_mi,
			*close_mi,
			*edit_mlabel,
			*cut_mi,
			*copy_mi,
			*paste_mi,
			*delete_mi,
			*properties_mi,
			*scan_mlabel,
			*start_mi,
			*stop_mi,
			*pause_resume_mi,
			*location_mi,
			*recursive_micheck,
			*executables_only_micheck,
			*ignore_links_micheck,
			*scanner_options_mi,
			*results_mlabel,
			*results_recycle_mi,
			*results_move_mi,
			*results_report_mi,
			*results_open_mi,
			*results_save_as_mi,
			*results_clear_mi,
			*db_mlabel,
			*db_refresh_mi,
			*db_pattern_details_mi,
			*db_location_mi,
			*db_update_net_mi,
			*view_mlabel,
			*view_scan_page_micheck,
			*view_results_page_micheck,
			*view_db_page_micheck,
			*view_toolbar_micheck,
			*view_statusbar_micheck,
			*help_mlabel,
			*help_contents_mi,
			*about_mi;

	gboolean	toolbar_map_state;
	GtkWidget	*toolbar_handle;
	toolbar_struct	*toolbar;

	win_page_num	page_num;

	GtkWidget	*lists_vbox,
			*notebook,
			*scan_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*location_entry,
			*location_browse_btn,
			*recursive_check,
			*executables_only_check,
			*ignore_links_check,
			*results_location_label,
			*results_status_label,
			*results_report_btn,
			*results_clist,
			*results_recycle_btn,
			*results_move_btn,
			*results_clear_btn,
			*db_find_entry,
			*db_ctree,
			*db_stats_label,
			*db_refresh_btn,
			*db_location_btn,
			*db_update_net_btn,
			*anim_icon,
			*start_btn,
			*stop_btn,
			*pause_resume_btn,
			*close_btn;

	GtkCTreeNode	*db_root_node;		/* Toplevel node */
	guint		db_ctree_load_idleid;
	gpointer	db;			/* Opaque pointer to the
						 * virus database */
	gpointer	db_stat;		/* Stat record used to check
						 * for db updates/changes */

	gboolean	statusbar_map_state;
	GtkWidget	*statusbar;
	GtkWidget	*statusbar_progress,
			*statusbar_label,
			*statusbar_time_label;
	gfloat		statusbar_progress_last;
	gulong		status_time;

	/* Scan List right-click menu */
	GtkWidget	*scan_list_menu,
			*scan_list_menu_start_mi,
			*scan_list_menu_stop_mi,
			*scan_list_menu_pause_resume_mi,
			*scan_list_menu_new_mi,
			*scan_list_menu_cut_mi,
			*scan_list_menu_copy_mi,
			*scan_list_menu_paste_mi,
			*scan_list_menu_delete_mi,
			*scan_list_menu_properties_mi;

	/* Results List right-click menu */
	GtkWidget	*results_list_menu,
			*results_list_menu_recycle_mi,
			*results_list_menu_move_mi,
			*results_list_menu_clear_mi;

	/* Virus Database List right-click menu */
	GtkWidget	*db_list_menu,
			*db_list_menu_pattern_details_mi;

	/* Styles */
	GtkStyle	*infected_style;


	/* Scan context */
	win_scan_context_struct	*scan_context;

	/* Update virus database process */
	guint		db_update_net_toid;
	gint		db_update_net_pid;
	gulong		db_update_net_start_time;

	/* Child process' output files */
	FILE		*stdout_fp,
			*stderr_fp;
	gchar		*stdout_path,
			*stderr_path;

	win_pattern_dlg_struct	*pattern_dlg;
};


/*
 *	Scan Context:
 */
struct _win_scan_context_struct {

	guint		toid;
	gint		pid;
	gulong		start_time,		/* In seconds */
			duration;		/* In seconds, set after scan
						 * is complete or interrupted */
	gulong		nscanned,
			ninfected,
			nproblems,
			total;
	gulong		blocks_scanned;		/* 1 block = 1024 bytes */

};


/*
 *	Pattern Dialog:
 */
struct _win_pattern_dlg_struct {

	GtkWidget	*toplevel;
	hview_struct	*hview;
	GtkWidget	*stats_label,
			*close_btn;

};


/* Process */
extern void WinProcessOutputDelete(win_struct *win);
extern void WinScanProcessStart(
	win_struct *win,
	const gchar *db_location,	/* Virus Scanner Database Location */
	GList *paths_list,		/* List of objects to scan */
	const avscan_options options
);
extern void WinScanProcessStop(win_struct *win);
extern gboolean WinScanProcessIsRunning(win_struct *win);

extern void WinDBUpdateNetProcessStart(win_struct *win);
extern void WinDBUpdateNetProcessStop(win_struct *win);
extern gboolean WinDBUpdateNetProcessIsRunning(win_struct *win);

/* Scan List & Settings Update */
extern void WinScanListOpenFromFile(win_struct *win, const gchar *path);
extern void WinScanSettingsUpdate(win_struct *win, const obj_struct *obj);
extern void WinResultsLocationUpdate(win_struct *win, GList *paths_list);
extern void WinResultsStatusUpdate(win_struct *win, const gchar *s);

/* Operation IDs */
extern win_opid_struct *WinOPIDNew(
	win_opid id, win_struct *win
);
extern void WinOPIDDelete(win_opid_struct *opid);
extern GList *WinOPIDListNew(win_struct *win);
extern void WinOPIDListDelete(GList *glist);
extern win_opid_struct *WinOPIDListFind(GList *glist, win_opid id);

/* Win */
extern win_struct *WinNew(gpointer core_ptr);
extern void WinSavePositions(win_struct *win);
extern void WinUpdateTitle(win_struct *win);
extern void WinUpdate(win_struct *win);
extern void WinSetBusy(win_struct *win, gboolean busy);
extern void WinSetPassiveBusy(win_struct *win, gboolean busy);
extern gboolean WinToolBarIsShown(win_struct *win);
extern void WinToolBarSetShow(win_struct *win, gboolean show);
extern void WinToolBarUpdateItems(win_struct *win);
extern gboolean WinStatusBarIsShown(win_struct *win);
extern void WinStatusBarSetShow(win_struct *win, gboolean show);
extern void WinStatusProgress(
	win_struct *win, const gfloat v, gboolean allow_gtk_iteration
);
extern void WinStatusMessage(
	win_struct *win, const gchar *mesg, gboolean allow_gtk_iteration
);
extern void WinStatusTime(
	win_struct *win, const gulong t, gboolean allow_gtk_iteration
);
extern gboolean WinIsMapped(win_struct *win);
extern void WinMap(win_struct *win);
extern void WinUnmap(win_struct *win);
extern void WinDelete(win_struct *win);

/* Win Pattern Dialog */
extern win_pattern_dlg_struct *WinPatternDlgNew(void);
extern void WinPatternDlgDelete(win_pattern_dlg_struct *d);


#endif	/* WIN_H */
