(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Color

module type COLORMAP = sig
  type t
  val size : t map -> int
  val find_exact : t map -> t -> int
  val add_color : t map -> t -> int
  val add_colors : t map -> t list -> int list
  val find_nearest : t map -> t -> int
end

class virtual ['a] map (cmap : 'a Color.map) = object
  val mapobj = cmap
  method colormap = mapobj
  
  method max = mapobj.max
  method map = mapobj.map
  
  method query_color x = if x < size cmap then cmap.map.(x) else raise Not_found
  
  method set_max max = mapobj.max <- max
  method set_map map = mapobj.map <- map
  
  method size = size mapobj
  method find_exact = find_exact mapobj
  method add_color = add_color mapobj
  method add_colors = add_colors mapobj
  method virtual find_nearest : 'a -> int
end

class rgbmap (cmap : rgb Color.map) = object
  inherit [rgb] map cmap
  method find_nearest = Rgb.find_nearest mapobj
end

class rgbamap (cmap : rgba Color.map) = object
  inherit [rgba] map cmap
  method find_nearest = Rgba.find_nearest mapobj
end

class cmykmap (cmap : cmyk Color.map) = object
  inherit [cmyk] map cmap
  method find_nearest = Cmyk.find_nearest mapobj
end

