(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Franois Pessaux, projet Cristal, INRIA Rocquencourt     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
(* RGBA 32 bit depth image format *)

type elt = Color.rgba
type rawimage
type t = { width : int;
	   height : int;
	   rawimage : rawimage;
	   mutable infos : Info.info list }
val dump : t -> string
val unsafe_access : t -> int -> int -> string * int
val get_strip : t -> int -> int -> int -> string
val set_strip : t -> int -> int -> int -> string -> unit
val get_scanline : t -> int -> string
val set_scanline : t -> int -> string -> unit
val unsafe_get : t -> int -> int -> elt
val unsafe_set : t -> int -> int -> elt -> unit
val get : t -> int -> int -> elt
val set : t -> int -> int -> elt -> unit
val destroy : t -> unit
val blit : t -> int -> int -> t -> int -> int -> int -> int -> unit
val map : (elt -> elt -> elt) -> 
  t -> int -> int -> t -> int -> int -> int -> int -> unit
val create_with : int -> int -> Info.info list -> string -> t
val create : int -> int -> t
val make : int -> int -> elt -> t
val copy : t -> t
val sub : t -> int -> int -> int -> int -> t
val resize : (float -> unit) option -> t -> int -> int -> t
