/*****************************************************************************
 *
 * uniar.c: Universal Archive Utility (actually UCB-like format)
 *
 * Original version (now obsolete: see uniar2.c)
 *
 * Copyright (c) 1990-2007 Aldor Software Organization Ltd (Aldor.org).
 *
 ****************************************************************************/

/*
 * Get basic configuration information
 */

#define _ALL_SOURCE

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#if defined(__STDC__) || defined(__EXTENDED__) || (_MSC_VER)
#   include <stddef.h>
#   include <stdlib.h>
#   define local static
#else
#   define const
#   define void int
#   define local
#endif

#include "platform.h"

#if !defined(CONFIG)
        /* this should stop things eventually */
        "Cannot determine your configuration. Please edit uniar.c."
#endif

#if defined(OS_WIN32) && defined(CC_MICROSOFT)
#include <sys\stat.h>
#define stat _stat
#endif
	
#if defined(OS_WIN32) && defined(CC_GNU)
#include <sys\stat.h>
#endif

#if defined(OS_MS_DOS) || defined(OS_IBM_OS2)
#include <sys\stat.h>
#endif

#if defined(OS_UNIX)
#include <sys/stat.h>
#endif

#if defined(OS_VMS)
#include <stat.h>
#endif

#if defined(OS_CMS)
struct stat {
    unsigned long st_mode;
    unsigned long st_uid;
    unsigned long st_gid;
    unsigned long st_size;      /* File size in bytes */
    unsigned long st_mtime;     /* Time of last data modification */
};

local int stat(char *path, struct stat *buf);

local void massageFileName(char *);

#else

#define massageFileName(x)

#endif

#define NOTIMPL errorExit1("Option '%c' not implemented", *flags);

/* Start of UCB-like portable archive header format */

#if defined(OS_CMS)
#define ARMAG       "<CMSaf>\n"
#define ARNAMELEN   20
#else
#define ARMAG   "!<arch>\n"
#define ARNAMELEN   16
#endif

#define SARMAG  8

#define ARFMAG  "`\n"

struct ar_hdr {
        char    ar_name[ARNAMELEN];
        char    ar_date[12];
        char    ar_uid[6];
        char    ar_gid[6];
        char    ar_mode[8];
        char    ar_size[10];
        char    ar_fmag[2];
};

#define	SARFHDR	(ARNAMELEN + 44)

unsigned long alignment = 2;

/* End of UCB-like portable archive header format */

#ifndef SEEK_SET
#  define SEEK_SET	0
#endif
#ifndef SEEK_END
#  define SEEK_END      2
#endif


#define errorExit(msg) \
    { fprintf(stderr, "(uniar): Error. %s.\n", (msg)); exit(1); }
#define errorExit1(msg, x) \
    { \
        fprintf(stderr, "(uniar): Error. "); \
        fprintf(stderr, (msg), (x)); \
        fprintf(stderr, ".\n"); \
        exit(1); \
    }

#define info(msg) printf("(uniar): %s.\n", (msg))
#define info1(msg,x) \
    { printf("(uniar): "); printf((msg), (x)); printf(".\n"); }

#if defined(__STDC__) || defined(OS_CMS)
#define _OF(X)	X
#else
#define	_OF(X)	()
#endif

local int	fileExists	_OF((char *));
local void	uniTOC		_OF((char *));
local void	uniExtract	_OF((char *, int, char **));
local void	uniQAppend	_OF((char *, int, char **));

int     opt_delete          = 0,
        opt_move            = 0,
        opt_print           = 0,
        opt_quick_append    = 0,
        opt_replace         = 0,
        opt_toc             = 0,
        opt_extract         = 0,
        opt_create_quietly  = 0,
        opt_local           = 0,
        opt_olddate         = 0,
        opt_update          = 0,
        opt_verbose         = 0,
        opt_after_pos       = 0,
        opt_before_pos      = 0,
        opt_regen_stab      = 0;

char   *str_after_pos       = 0,
       *str_before_pos      = 0;


int
main(argc, argv)
    int argc;
    char **argv;
{
    char    *flags = 0, *positionName = 0, *archive = 0;
    int      disjointOptions = 0;
    FILE    *ar = 0;


    /*
     * At least two arguments are always required. The first is the set
     * of options, no hyphens, no blanks.  The second is usually the
     * archive but if 'a', 'b', or 'i' are given, the second argument is
     * a position name.
     */

    if (argc < 3)
        errorExit("At least two arguments are required");

    flags = argv[1];

    while (*flags) {
        switch (*flags) {
            case 'm': opt_move           = 1; disjointOptions++; NOTIMPL; break;
            case 'r': opt_replace        = 1; disjointOptions++; break;
            case 'x': opt_extract        = 1; disjointOptions++; break;
            case 't': opt_toc            = 1; disjointOptions++; break;
            case 'd': opt_delete         = 1; disjointOptions++; NOTIMPL; break;
            case 'p': opt_print          = 1; disjointOptions++; NOTIMPL; break;
            case 'q': opt_quick_append   = 1; disjointOptions++; break;

            case 'c': opt_create_quietly = 1; break;
            case 'l': opt_local          = 1; NOTIMPL; break;
            case 'o': opt_olddate        = 1; NOTIMPL; break;
            case 'u': opt_update         = 1; NOTIMPL; break;
            case 'v': opt_verbose        = 1; break;
            case 'a': opt_after_pos      = 1; NOTIMPL; break;

            case 'b':
            case 'i': opt_before_pos     = 1; NOTIMPL; break;

            case 's': opt_regen_stab     = 1; NOTIMPL; break;

            default:
                errorExit1("Unknown option '%c'", *flags);
        }
        ++flags;
    }

    if (disjointOptions > 1)
        errorExit("Only one of [mrxtdpq] allowed");

    if (opt_after_pos || opt_before_pos) {
        if (argc < 4) {
            errorExit("At least three arguments are required if\n\t'a', 'b', or 'i' are used");
        }
        positionName = argv[2];
        archive = argv[3];
	argc -= 4;
	argv += 4;
    }
    else {
        archive = argv[2];
	argc -= 3;
	argv += 3;
    }

    massageFileName(archive);

    if (! fileExists(archive)) {
        if (opt_quick_append || opt_replace) {
            ar = fopen(archive, "wb");
            if (! ar)
                errorExit1("Cannot create archive '%s'", archive);
            fprintf(ar, "%s", ARMAG);
            fclose(ar);
            if (! opt_create_quietly)
                info1("Created archive %s", archive);
        }
        else if (!opt_delete)
            errorExit1("Archive '%s' must already exist for given options", archive);
    }

    if (opt_toc)
        uniTOC(archive);

    if (opt_extract)
    	uniExtract(archive, argc, argv);

        /* just treat these two as equal today */
    if (opt_quick_append || opt_replace)
	uniQAppend(archive, argc, argv);

    return 0;
}

void
uniTOC(archive)
	char *	archive;
{
	int		j;
	struct stat	arstat, statbuf;
	FILE *		ar = 0;
	unsigned long	pos;
	char		buf[ARNAMELEN];

	if (stat(archive, &arstat) != 0)
		errorExit1("Cannot get file info about archive file '%s'", archive);

	ar = fopen(archive, "rb");
	if (! ar)
		errorExit1("Cannot open archive '%s'", archive);

	pos = SARMAG;
	while (pos + SARFHDR <= arstat.st_size) {
		long x;
		
		if (fseek(ar, pos, SEEK_SET) != 0)
			errorExit1("Could not seek to position '%d'", pos);

		for (j = 0; j < ARNAMELEN; j += 1)
			buf[j] = fgetc(ar);
		while (j > 0 && buf[--j] == ' ') buf[j] = '\0';

		fscanf(ar, "%12lu", &x);
		statbuf.st_mtime = x;
		fscanf(ar, "%6lu",  &x);
		statbuf.st_uid = x;
		fscanf(ar, "%6lu",  &x);
		statbuf.st_gid = x;
		fscanf(ar, "%8lo",  &x);
		statbuf.st_mode = x;
		fscanf(ar, "%10lu", &x);
		statbuf.st_size = x;

		if (opt_verbose)
			/* Could do better here. */
			fprintf(stdout, "%9lu %s\n", statbuf.st_size, buf);
		else
			fprintf(stdout, "%s\n", buf);

		pos += SARFHDR + statbuf.st_size;
		if (pos % alignment != 0)
			pos += alignment - pos % alignment;
	}

	fclose(ar);
}

local void
uniExtract(archive, filec, filev)
	char *	archive;
	int	filec;
	char **	filev;
{
	int		i;
	struct stat	arstat;
	FILE *		ar = 0;

	if (stat(archive, &arstat) != 0)
		errorExit1("Cannot get file info about archive file '%s'", archive);

	ar = fopen(archive, "rb");
	if (! ar)
		errorExit1("Cannot open archive '%s'", archive);

	for (i = 0; i < filec; i += 1) {
		char *		fn = filev[i];
		FILE *		out;
		struct stat	statbuf;
		int		j;
		unsigned long	cc, pos;
		char		buf[ARNAMELEN];

		if (fn[strlen(fn) - 1] == '/') fn[strlen(fn) - 1] = '\0';
		pos = SARMAG;
		while (pos + SARFHDR <= arstat.st_size) {
			if (fseek(ar, pos, SEEK_SET) != 0)
				errorExit1("Could not seek to position '%d'", pos);

			for (j = 0; j < ARNAMELEN; j += 1)
				buf[j] = fgetc(ar);
			while (j > 0 && buf[--j] == ' ') buf[j] = '\0';

			fscanf(ar, "%12lu", &statbuf.st_mtime);
			fscanf(ar, "%6lu",  &statbuf.st_uid);
			fscanf(ar, "%6lu",  &statbuf.st_gid);
			fscanf(ar, "%8lo",  &statbuf.st_mode);
			fscanf(ar, "%10lu", &statbuf.st_size);

			if (strncmp(fn, buf, j) == 0) break;

			pos += SARFHDR + statbuf.st_size;
			if (pos % alignment != 0)
				pos += alignment - pos % alignment;
		}
		pos += SARFHDR;
		if (pos > arstat.st_size)
			errorExit1("Could not find member '%s'", fn);
		if (pos + statbuf.st_size > arstat.st_size)
			errorExit1("Could not extract member '%s'", fn);
		if (fseek(ar, pos, SEEK_SET) != 0)
			errorExit1("Could not seek to position '%d'", pos);

		massageFileName(fn);
		if (fileExists(fn))
			errorExit1("File '%s' to be extracted already exists", fn);
		out = fopen(fn, "wb");		

		if (opt_verbose)
			printf("x - %s\n", fn);

		for (cc = 0; cc < statbuf.st_size; cc += 1)
			fputc(fgetc(ar), out);
		fclose(out);
	}

	fclose(ar);
}

local void
uniQAppend(archive, filec, filev)
	char *	archive;
	int	filec;
	char **	filev;
{
        int i;
	FILE *	ar = 0;

        ar = fopen(archive, "ab");
        if (! ar)
            errorExit1("Cannot open archive '%s'", archive);
        fseek(ar, 0L, SEEK_END);

	for (i = 0; i < filec; i += 1) {
		char *		fn = filev[i];
            FILE *in;
            struct stat statbuf;
		int		j;
		unsigned long	cc;

            massageFileName(fn);
		if (stat(fn, &statbuf) != 0)
                errorExit1("Cannot get file info about required file '%s'", fn);
            in = fopen(fn, "rb");

            if (opt_verbose)
                printf("a - %s\n", fn);

		/* name */
		for (j = 0; j < ARNAMELEN-1; j += 1)
			fputc(*fn ? *fn++ : ' ', ar);
            fputc(' ', ar);

		/* date */
		fprintf(ar, "%-11lu ", (unsigned long) statbuf.st_mtime);

	    /*
		 *  For VMS the st_uid does not fit in 5 characters,
		 *  so it is output as 100.
	    */
#if defined(OS_VMS)
		statbuf.st_uid = 100;
		statbuf.st_mode = 0;
#endif
		fprintf(ar,"%-5lu ", (unsigned long) statbuf.st_uid);
		fprintf(ar,"%-5lu ", (unsigned long) statbuf.st_gid);
		fprintf(ar,"%-7lo ", (unsigned long) statbuf.st_mode);
		fprintf(ar,"%-9lu ", (unsigned long) statbuf.st_size);

            fprintf(ar,"%2s", ARFMAG);

		for (cc = 0; cc < statbuf.st_size; cc += 1)
                fputc(fgetc(in), ar);

		for (; cc % alignment; cc += 1)
                fputc('\n', ar);

            fclose(in);
        }

        fclose(ar);
    }


local int
fileExists(fileName)
    char *fileName;
{
    FILE *fh = fopen(fileName, "r");
    if (! fh)
        return 0;
    fclose(fh);
    return 1;
}

#if defined(OS_CMS)
#include <ctype.h>

local unsigned long osFileSize(char *name);

local unsigned long
osFileSize(char *name)
{
        FILE *file = fopen(name, "rb");
        long  size = 0;

        if (file) {
                int ch;
                ch = fgetc(file);
                while (ch != EOF) {
                        ++size;
                        ch = fgetc(file);
                }
                fclose(file);
        }
        return size;
}

local int
stat(char *path, struct stat *buf)
{
    buf->st_mode    = 0;
    buf->st_uid     = 0;
    buf->st_gid     = 0;
    buf->st_mtime   = 0;
    buf->st_size    = osFileSize(path);
    if (buf->st_size == 0)
            return -1;
    return 0;
}

local void
massageFileName(char *fn)
{
    if (fn)
        while (*fn) {
            if (*fn == '.')
                *fn = ' ';
            else if (islower(*fn))
                *fn = toupper(*fn);
            fn++;
        }
}
#endif

