; NOTE: this .NSI script is designed for NSIS v1.3+

; !define VERSION $%VERSION%
; !define MACHINE $%MACHINE%
; !define ALDORROOT $%ALDORROOT%

Name "Aldor"
OutFile "${ALDORROOT}\aldor-${MACHINE}-${VERSION}.exe"


; Some default compiler settings (uncomment and change at will):
; SetCompress auto ; (can be off or force)
; SetDatablockOptimize on ; (can be off)
CRCCheck on ; (can be off)
; AutoCloseWindow false ; (can be true for the window go away automatically at end)
; ShowInstDetails hide ; (can be show to have them shown, or nevershow to disable)
; SetDateSave off ; (can be on to have files restored to their orginal date)

LicenseText "You must agree to this license before installing."
LicenseData "license.txt"

InstallDir "C:\Aldor"
InstallDirRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Aldor" ""
DirText "Select the directory to install Aldor in:"

Section "" ; (default section)
SetOutPath "$INSTDIR"
; add files / whatever that need to be installed here.

; [July 31 GDC] -- This line causes the compiled Aldor stuff to be
; put in $INSTDIR

File /r ${ALDORROOT}\bin
File /r ${ALDORROOT}\include
File /r ${ALDORROOT}\lib
;File /r $%VERSION%\doc
;File /r $%VERSION%\src
;File /r $%VERSION%\test
File ${ALDORROOT}\..\..\..\..\aldor\tools\win32\Readme.txt

WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Aldor" "" "$INSTDIR"
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aldor" "DisplayName" "Aldor (remove only)"
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aldor" "UninstallString" '"$INSTDIR\uninst.exe"'

WriteUninstaller "uninst.exe"

; Pop up readme.txt
ExecShell "" "$WINDIR\notepad.exe" "$INSTDIR\Readme.txt"

; Setup the environment
; MSVSDir
; ReadRegStr "$R0" "HKEY_LOCAL_MACHINE" "SOFTWARE\Microsoft\VisualStudio\6.0\Setup\Microsoft Visual Studio" "ProductDir"
; MSVCDir
; ReadRegStr "$R1" "HKEY_LOCAL_MACHINE" "SOFTWARE\Microsoft\VisualStudio\6.0\Setup\Microsoft Visual C++" "ProductDir"
; MsCommonDir
; ReadRegStr "$R2" "HKEY_LOCAL_MACHINE" "SOFTWARE\Microsoft\VisualStudio\6.0\Setup" "VsCommonDir"
; VcOsDir
; ReadEnvStr "$R3" "OS"
; StrCmp "$R3" "Windows_NT" nt_label
; StrCpy "$R3" "WIN95"
; nt_label:
; Set Environment Variables
WriteRegStr "HKEY_CURRENT_USER" "Environment" "ALDORROOT" "$INSTDIR"
; Old PATH
ReadRegStr "$R9" "HKEY_CURRENT_USER" "Environment" "PATH" 
; WriteRegExpandStr "HKEY_CURRENT_USER" "Environment" "PATH" "$R1\BIN;$R2TOOLS\$R3;$R2TOOLS;$INSTDIR\bin;$R9" 
WriteRegExpandStr "HKEY_CURRENT_USER" "Environment" "PATH" "$INSTDIR\bin;$R9" 
; Update to find include dir
; ReadREgStr "$R9" "HKEY_CURRENT_USER" "Environment" "INCLUDE" 
; WriteRegStr "HKEY_CURRENT_USER" "Environment" "INCLUDE" "$R1\INCLUDE;$R9" 
; Update to find lib dir
; ReadREgStr "$R9" "HKEY_CURRENT_USER" "Environment" "LIB" 
; WriteRegStr "HKEY_CURRENT_USER" "Environment" "LIB" "$R1\LIB;$R9" 

;!!!!!!!!!!!!!!!!!!!! modify here !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

; MessageBox "MB_OKCANCEL" "$R0"
SectionEnd ; end of default section


; begin uninstall settings/section
UninstallText "This will uninstall Aldor from your system"
Section Uninstall
; add delete commands to delete whatever files/registry keys/etc you installed here.
; [July 31 GDC] Delete the files in the installation directory
;Delete "$INSTDIR\bin\*.*"
;RMDir "$INSTDIR\bin"
;Delete "$INSTDIR\lib\*.*"
;RMDir "$INSTDIR\lib"
;Delete "$INSTDIR\src\libaldor\*.*"
;RMDir "$INSTDIR\src\libaldor"
;Delete "$INSTDIR\src\*.*"
;RMDir "$INSTDIR\src"
;Delete "$INSTDIR\doc\libaldor\*.*"
;RMDir "$INSTDIR\doc\libaldor"
;Delete "$INSTDIR\doc\*.*"
;RMDir "$INSTDIR\doc"
;Delete "$INSTDIR\include\*.*"
;RMDir "$INSTDIR\include"
;Delete "$INSTDIR\Readme.txt"
;Delete "$INSTDIR\uninst.exe"
;Delete "$INSTDIR\*.*"
RMDir /r "$INSTDIR"

; Uninstall reg keys for Visual C++ ??????????
; Try it here if necessary

DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Aldor"
DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Aldor"
RMDir "$INSTDIR"
SectionEnd ; end of uninstall section

; eof
