/*
 * tee.c
 */

#include <stdio.h>
#include <string.h>
#include <windows.h>

#define BUFC 1

typedef char * String;

int
cmdLength(int argc, char **argv)
{
	int	i, cc = 0;

	for (i = 0; i < argc; i += 1) {
		if (i > 0) cc += 1;
		cc += strlen(argv[i]);
	}

	return cc;
}

String
cmdString(int argc, char ** argv)
{
	int	i, cc = cmdLength(argc, argv);
	String	buf = (String) malloc(cc + 1);

	buf[0] = '\0';
	for (i = 0; i < argc; i += 1) {
		if (i > 0) strcat(buf, " ");
		strcat(buf, argv[i]);
	}

	return buf;
}

int
osRunRedirect(String cmd, BOOL wait, HANDLE hin, HANDLE hout, HANDLE herr)
{
	HANDLE				sin, sout, serr;
	static STARTUPINFO		si;
	static PROCESS_INFORMATION	pi;
	BOOL				rc;

	/* Save standard handles. */
	sin  = GetStdHandle(STD_INPUT_HANDLE);
	sout = GetStdHandle(STD_OUTPUT_HANDLE);
	serr = GetStdHandle(STD_ERROR_HANDLE);

	/* Redirect standard handles for the child process. */
	if (hin)  SetStdHandle(STD_INPUT_HANDLE, hin);
	if (hout) SetStdHandle(STD_OUTPUT_HANDLE, hout);
	if (herr) SetStdHandle(STD_ERROR_HANDLE, herr);

	/* Create process. */
	si.cb		= sizeof(si);
	si.lpReserved	= NULL;
	si.lpDesktop	= NULL;
	si.lpTitle	= "!";
	si.dwFlags	= 0;
	si.cbReserved2	= 0;
	si.lpReserved2	= NULL;

	rc = CreateProcess(NULL, cmd, NULL, NULL, TRUE,
			   NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi);
	if (rc == FALSE) return -1;

	/* Restore standard handles. */
	SetStdHandle(STD_INPUT_HANDLE, sin);
	SetStdHandle(STD_OUTPUT_HANDLE, sout);
	SetStdHandle(STD_ERROR_HANDLE, serr);

	if (wait == TRUE) {
		rc = WaitForSingleObject(pi.hProcess, INFINITE);
		if (rc == WAIT_FAILED) return -1;
	}

	return 0;
}

int
main(int argc, char **argv)
{
	String				fn, cmd;
	HANDLE				pin, pout, fout;
	static SECURITY_ATTRIBUTES	sa;
	BOOL				rc;
	char				buf[BUFC];
	DWORD				bufc = BUFC;
	DWORD				readc;

	/* Collect shell command. */
	if (argc < 3) {
		fprintf(stderr, "usage:  tee fn cmd ...\n");
		exit(1);
	}
	fn = argv[1];
	argc -= 2;
	argv += 2;
	cmd = cmdString(argc, argv);

	/* Create pipe. */
	sa.nLength		= sizeof(sa);
	sa.lpSecurityDescriptor	= NULL;
	sa.bInheritHandle	= TRUE;

	rc = CreatePipe(&pout, &pin, &sa, 0);
	if (rc == FALSE) {
		fprintf(stderr, "tee:  could not create pipe\n");
		exit(1);
	}

	/* Output from child is input to pipe. */
	rc = osRunRedirect(cmd, FALSE, NULL, pin, pin);
	if (rc == -1) {
		fprintf(stderr, "tee:  could not create process\n");
		exit(1);
	}
	CloseHandle(pin);

	/* Open files. */
	fout = CreateFile(fn, GENERIC_WRITE, FILE_SHARE_READ, NULL,
			  CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

	/* Echo output. */
	while (ReadFile(pout, buf, bufc, &readc, NULL)) {
		putc(buf[0], stdout);
		WriteFile(fout, buf, bufc, &readc, NULL);
		if (buf[0] == '\n') FlushFileBuffers(fout);
	}

	/* Close files. */
	CloseHandle(pout);
	CloseHandle(fout);

	return 0;
}
