# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::tree;
use base 'AXP::Command';

use Arch::Tree;

sub options {
	(
		$_[0]->tree_options,
		$_[0]->step_options,
		$_[0]->own_options,
	)
}

sub tree_options {
		revision  => { sh => 'R', type => "=s", arg => 'REV', desc => "fetch REV first as tmp tree or new DIR" },
		dir       => { sh => 'd', type => "=s", arg => 'DIR', desc => "cd to DIR first" },
}

sub step_options {
	(
		test      => { desc => "do not actually perform commands" },
		verbose   => { sh => 'v', desc => "be more verbose" },
		quiet     => { sh => 'q', desc => "be quiet" },
	)
}

sub own_options {
	(
	)
}

sub infoline {
	"operations on arch tree"
}

sub tree {
	my $self = shift;
	my %params = @_;

	unless ($self->{tree}) {
		my $rev = $self->{options}->{revision};
		my $dir = $self->{options}->{dir};
		if ($rev) {
			require Arch::Session;
			$self->{tree} = Arch::Session->new->get_tree($rev, $dir);
		} else {
			$self->{tree} = Arch::Tree->new($dir, own_logs => 1, %params);
		}
	}
	return $self->{tree};
}

1;
