/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.util.Date;
import nz.net.catalyst.ELog;
import nz.net.catalyst.IPackage;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.xml.DOMConfigurator;

public class Log
implements IPackage {
    public static final String THRESHOLD_PROPERTY = String.valueOf(PACKAGE) + "LogThreshold";
    static ELog threshold = ELog.INFO;
    private static Category logger;

    static {
        Log.init();
    }

    public static void init() {
        String thresholdProp = System.getProperty(THRESHOLD_PROPERTY);
        if (thresholdProp != null) {
            ELog newThreshold = ELog.getByName(thresholdProp = thresholdProp.trim());
            if (newThreshold != null) {
                threshold = newThreshold;
            }
        } else {
            thresholdProp = "INFO";
        }
        String log4jConfigPath = System.getProperty(String.valueOf(PACKAGE) + "Log4jConfigPath");
        System.out.println("Log4jConfigPath:" + log4jConfigPath);
        if (log4jConfigPath != null && !log4jConfigPath.equals("") && !log4jConfigPath.equals("null")) {
            logger = Category.getInstance((String)"nz.net.catalyst.lucene");
            if (logger != null) {
                if (thresholdProp.equalsIgnoreCase("DEBUG")) {
                    logger.setLevel(Level.DEBUG);
                } else if (thresholdProp.equalsIgnoreCase("INFO")) {
                    logger.setLevel(Level.INFO);
                } else if (thresholdProp.equalsIgnoreCase("WARNING")) {
                    logger.setLevel(Level.WARN);
                } else if (thresholdProp.equalsIgnoreCase("ERROR")) {
                    logger.setLevel(Level.ERROR);
                } else if (thresholdProp.equalsIgnoreCase("FATAL")) {
                    logger.setLevel(Level.FATAL);
                } else {
                    logger.setLevel(Level.OFF);
                }
                DOMConfigurator.configure((String)log4jConfigPath);
                logger.warn((Object)"LuceneServer now initialised and Log4J logging started.");
                System.out.println("Logging now passed to Log4J (threshold " + thresholdProp + ").");
            } else {
                System.out.println("=================================");
                System.out.println(new Date() + "Error while initialising Log4j. Will use std out instead.");
                System.err.println(new Date() + "Error while initialising Log4j. Will use std out instead.");
                System.out.println("=================================");
                logger = null;
            }
        }
    }

    public static void log(ELog severity, Object message) {
        if (severity.lessThan(threshold)) {
            return;
        }
        if (severity == ELog.DEBUG) {
            Log.debug(message);
        } else if (severity == ELog.INFO || severity == ELog.NOTICE) {
            Log.info(message);
        } else if (severity == ELog.WARNING) {
            Log.warn(message);
        } else if (severity == ELog.ERROR || severity == ELog.CRITICAL || severity == ELog.ALERT) {
            Log.error(message);
        } else if (severity == ELog.FATAL) {
            Log.fatal(message);
        }
    }

    public static boolean willDebug() {
        return Log.isDebugEnabled();
    }

    private Log() {
    }

    public static void debug(Object message) {
        if (logger != null) {
            logger.debug(message);
        } else {
            System.out.println(message);
        }
    }

    public static void info(Object message) {
        if (logger != null) {
            logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    public static void warn(Object message) {
        if (logger != null) {
            logger.warn(message);
        } else {
            System.out.println(message);
        }
    }

    public static void error(Object message) {
        if (logger != null) {
            logger.error(message);
        } else {
            System.out.println(message);
        }
    }

    public static void fatal(Object message) {
        if (logger != null) {
            logger.fatal(message);
        } else {
            System.out.println(message);
        }
    }

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public static boolean isInfoEnabled() {
        return logger.isInfoEnabled();
    }
}

