/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import nz.net.catalyst.lucene.server.Constants;
import org.apache.lucene.document.Field;

class FieldDef
implements Cloneable,
Constants {
    final String name;
    Field.Store stored = Field.Store.YES;
    Field.Index indexed = Field.Index.TOKENIZED;
    boolean date = false;

    FieldDef(String name) {
        this.name = name;
        if (name.equals("Id")) {
            this.stored = Field.Store.YES;
            this.indexed = Field.Index.UN_TOKENIZED;
        } else if (name.equals("Domain")) {
            this.stored = Field.Store.YES;
            this.indexed = Field.Index.UN_TOKENIZED;
        }
    }

    public void defineStored(boolean is_stored) {
        this.stored = is_stored ? Field.Store.YES : Field.Store.NO;
    }

    public void defineIndexed(boolean is_indexed) {
        this.indexed = is_indexed ? Field.Index.TOKENIZED : Field.Index.NO;
    }

    public void defineTokenized(boolean is_tokenized) {
        this.indexed = is_tokenized ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED;
    }

    public void defineAsDate() {
        this.date = true;
        if (this.indexed != Field.Index.NO) {
            this.indexed = Field.Index.UN_TOKENIZED;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldDef)) {
            return false;
        }
        FieldDef that = (FieldDef)o;
        return this.name.equals(that.name);
    }

    public FieldDef copy() {
        try {
            return (FieldDef)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

