/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

/**
 * Lucene Field attributes.
 * 
 * The default settings for a field are:<br>
 * not stored<br>
 * indexed <br>
 * tokenised by whitespace <br>
 * not a date field <br>
 */

class FieldDef implements Cloneable, Constants
{
  final String name;
  boolean store = false;
  boolean index = true;
  boolean token = true;
  boolean date = false;

  /**
   * Define a Field with default attributes.  The Id and Domain fields
   * have special characteristics.
   */

  FieldDef(String name)
  {
    this.name = name;
    if (name.equals(ID))
    {
      store = true;
      index = false;
      token = false;
    }
    else if (name.equals(DOMAIN))
    {
      store = true;
      index = true;
      token = false;
    }
  }

  public boolean equals(Object o)
  {
    if (this == o)
      return true;

    if (!(o instanceof FieldDef))
      return false;

    FieldDef that = (FieldDef)o;
    return this.name.equals(that.name);
  }

  public FieldDef copy()
  {
    try
    {
      return (FieldDef) clone();
    }
    catch (CloneNotSupportedException e)
    {
      // Can't happen
      return null;
    }
  }
}
