/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.Pair;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.AnalyzerPool;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.DateField;
import nz.net.catalyst.lucene.server.FieldDef;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;

public class Application
implements IPackage,
Constants {
    private static final String DIRECTORY_PROPERTY = String.valueOf(IPackage.PACKAGE) + "ApplicationDirectory";
    private static final String RESCAN_PROPERTY = String.valueOf(IPackage.PACKAGE) + "ApplicationRescan";
    private static final String UNDEFINED_APP_PROP = String.valueOf(IPackage.PACKAGE) + "MissingAppIsError";
    private static final String PROP_FILE_SUFFIX = ".properties";
    private static final String DEFAULT_INDEX_PROPERTY = String.valueOf(IPackage.PACKAGE) + "Lucene-Index-Directory";
    private static final SimpleDateFormat[] sdf = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy-MM-dd")};
    private Analyzer analyzer = null;
    private final List fields = new LinkedList();
    private final List fieldsView = Collections.unmodifiableList(this.fields);
    private final Map fieldMap = new HashMap();
    private static final Map cache;
    private final Properties properties = new Properties();
    private final String name;
    private long lastModTime = -1L;

    static {
        int i = 0;
        while (i < sdf.length) {
            sdf[i].setLenient(false);
            ++i;
        }
        cache = new TreeMap();
    }

    public Application(String name) {
        this.name = name;
        Map map = cache;
        synchronized (map) {
            cache.put(name, this);
        }
        this.organise();
    }

    FieldDef getFieldDef(String name) {
        FieldDef field = (FieldDef)this.fieldMap.get(name);
        field = field == null ? new FieldDef(name) : field.copy();
        return field;
    }

    List getAllFieldDefs() {
        return this.fieldsView;
    }

    public Field makeField(String name, String value) {
        FieldDef field = this.getFieldDef(name);
        if (field.date) {
            value = DateField.dateToString(Application.makeDate(value));
        }
        return new Field(name, value, field.store, field.index, field.token);
    }

    public static Analyzer getAnalyzer(Transmission tr) {
        String stopList = tr.get("Stop-List", Constants.NO_APP);
        Application app = tr.getApplication();
        if (stopList == null && app != null) {
            return app.getAnalyzer();
        }
        return AnalyzerPool.get(stopList);
    }

    public static File getIndexDirectory(Application application) {
        String luceneStore;
        File luceneStoreDir = null;
        if (application != null && (luceneStore = application.getProperty("Lucene-Index-Directory")) != null && !(luceneStoreDir = new File(luceneStore)).isDirectory()) {
            luceneStoreDir.mkdirs();
            if (!luceneStoreDir.isDirectory()) {
                luceneStoreDir = null;
            }
        }
        if (luceneStoreDir == null) {
            luceneStore = System.getProperty(DEFAULT_INDEX_PROPERTY);
            luceneStore = luceneStore == null ? "index" : luceneStore.trim();
            luceneStoreDir = new File(luceneStore);
        }
        return luceneStoreDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date makeDate(String value) {
        try {
            return new Date((long)Integer.parseInt(value) * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            SimpleDateFormat[] simpleDateFormatArray = sdf;
            synchronized (sdf) {
                int i = 0;
                while (i < sdf.length) {
                    try {
                        // ** MonitorExit[var1_2] (shouldn't be in output)
                        return sdf[i].parse(value);
                    }
                    catch (ParseException parseException) {
                        ++i;
                    }
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                throw new IllegalArgumentException("Cannot parse date: " + value);
            }
        }
    }

    public static String format(Date d) {
        SimpleDateFormat[] simpleDateFormatArray = sdf;
        synchronized (sdf) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sdf[0].format(d);
        }
    }

    public synchronized String remove(String key) {
        String oldValue = (String)this.properties.remove(key);
        long now = System.currentTimeMillis();
        this.lastModTime = this.lastModTime < now ? now : this.lastModTime + 1L;
        return oldValue;
    }

    public String appendProperty(String key, String value) {
        return this.appendProperty(key, value, " ");
    }

    public synchronized String appendProperty(String key, String value, String sep) {
        String oldValue;
        Properties properties = this.properties;
        synchronized (properties) {
            oldValue = (String)this.properties.setProperty(key, value);
            if (oldValue != null) {
                this.properties.setProperty(key, String.valueOf(oldValue) + sep + value);
            }
        }
        long now = System.currentTimeMillis();
        this.lastModTime = this.lastModTime < now ? now : this.lastModTime + 1L;
        return oldValue;
    }

    public synchronized String setProperty(String key, String value) {
        String oldValue = (String)this.properties.setProperty(key, value);
        long now = System.currentTimeMillis();
        this.lastModTime = this.lastModTime < now ? now : this.lastModTime + 1L;
        return oldValue;
    }

    public synchronized String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public synchronized Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void load(File file) throws IOException {
        Log.log(ELog.INFO, "Reading Application properties from: " + file.getPath());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties properties = this.properties;
            synchronized (properties) {
                this.properties.clear();
                this.properties.load(in);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((InputStream)in).close();
        this.lastModTime = file.lastModified();
        this.organise();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void store(File file) throws IOException {
        Log.log(ELog.INFO, "Writing Application properties to: " + file.getPath());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            Properties properties = this.properties;
            synchronized (properties) {
                this.properties.store(out, this.name);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((OutputStream)out).close();
        this.lastModTime = file.lastModified();
    }

    public void store() {
        this.organise();
        File directory = new File(System.getProperty(DIRECTORY_PROPERTY).trim());
        if (!directory.isDirectory()) {
            directory.mkdirs();
            if (!directory.isDirectory()) {
                Log.log(ELog.ERROR, "Cannot store Application defaults into directory: " + Util.getFullPath(directory));
                return;
            }
        }
        File file = new File(directory, String.valueOf(this.name) + PROP_FILE_SUFFIX);
        try {
            this.store(file);
        }
        catch (IOException e) {
            Log.log(ELog.ERROR, "Cannot store Application defaults into file: " + Util.getFullPath(file) + ": " + e);
            return;
        }
    }

    private synchronized void organise() {
        this.buildAnalyzer();
        this.buildFieldDefs();
    }

    private void buildAnalyzer() {
        this.analyzer = AnalyzerPool.get(this.properties.getProperty("Stop-List"));
    }

    Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private void buildFieldDefs() {
        this.fields.clear();
        this.fieldMap.clear();
        String fieldProperty = this.properties.getProperty("Field-Definitions");
        if (fieldProperty == null) {
            return;
        }
        String[] fieldDefList = Util.split(fieldProperty, ",");
        int i = 0;
        while (i < fieldDefList.length) {
            String fieldDef = fieldDefList[i];
            String[] fieldAttributeList = Util.split(fieldDef);
            if (fieldAttributeList.length != 0) {
                int index;
                FieldDef field = new FieldDef(fieldAttributeList[0]);
                if (fieldAttributeList.length >= 2) {
                    String type = fieldAttributeList[1];
                    field.token = type.equalsIgnoreCase("Text");
                    field.date = type.equalsIgnoreCase("Date");
                }
                if (fieldAttributeList.length >= 3) {
                    String indexed = fieldAttributeList[2];
                    field.index = indexed.equalsIgnoreCase("Yes");
                }
                if (fieldAttributeList.length >= 4) {
                    String stored = fieldAttributeList[3];
                    field.store = stored.equalsIgnoreCase("Yes");
                }
                if (this.fieldMap.containsKey(field.name)) {
                    index = this.fields.indexOf(field);
                    this.fields.remove(index);
                } else {
                    index = this.fields.size();
                }
                this.fields.add(index, field);
                this.fieldMap.put(field.name, field);
            }
            ++i;
        }
        String[] specials = new String[]{"Id", "Domain"};
        int i2 = 0;
        while (i2 < specials.length) {
            FieldDef field = (FieldDef)this.fieldMap.get(specials[i2]);
            if (field == null) {
                field = new FieldDef(specials[i2]);
                field.store = true;
                field.index = false;
                field.token = false;
                this.fields.add(0, field);
                this.fieldMap.put(field.name, field);
            }
            ++i2;
        }
    }

    public static Application getAppOrDefault(String name) {
        Map map = cache;
        synchronized (map) {
            Application result;
            Application application = result = name == null ? null : (Application)cache.get(name);
            if (result == null) {
                if (name != null && Boolean.getBoolean(UNDEFINED_APP_PROP)) {
                    throw new ApplicationMissingException("Application \"" + name + "\" is not defined");
                }
                result = (Application)cache.get("default");
            }
            return result;
        }
    }

    public static Application get(String name) {
        Map map = cache;
        synchronized (map) {
            return (Application)cache.get(name);
        }
    }

    public static void Start(String[] args) {
        Application.scanDirectory();
        Application.startMonitor();
    }

    private static synchronized void scanDirectory() {
        Application app;
        File directory = new File(System.getProperty(DIRECTORY_PROPERTY).trim());
        if (!directory.isDirectory()) {
            return;
        }
        String[] propsFiles = directory.list(new FilenameFilter(){

            public boolean accept(File parent, String file) {
                return file.endsWith(Application.PROP_FILE_SUFFIX);
            }
        });
        int i = 0;
        while (i < propsFiles.length) {
            int baseLength = propsFiles[i].length() - PROP_FILE_SUFFIX.length();
            String appName = propsFiles[i].substring(0, baseLength);
            boolean readApp = false;
            app = Application.get(appName);
            File propFile = new File(directory, propsFiles[i]);
            if (app == null || app.lastModTime < propFile.lastModified()) {
                try {
                    new Application(appName).load(propFile);
                }
                catch (IOException e) {
                    Map map = cache;
                    synchronized (map) {
                        cache.remove(appName);
                    }
                }
            }
            ++i;
        }
        ArrayList<Pair> changes = new ArrayList<Pair>(cache.size());
        Map baseLength = cache;
        synchronized (baseLength) {
            Iterator it = cache.values().iterator();
            while (it.hasNext()) {
                Application app2 = (Application)it.next();
                File propFile = new File(directory, String.valueOf(app2.name) + PROP_FILE_SUFFIX);
                if (propFile.exists() && app2.lastModTime <= propFile.lastModified()) continue;
                changes.add(new Pair(propFile, app2));
            }
        }
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            File propFile = (File)pair.getKey();
            app = (Application)pair.getValue();
            try {
                app.store(propFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void monitor() {
        try {
            try {
                while (true) {
                    int sleepMinutes;
                    if ((sleepMinutes = Integer.getInteger(RESCAN_PROPERTY, 1).intValue()) < 1) {
                        sleepMinutes = 1;
                    }
                    Thread.sleep((long)sleepMinutes * 60L * 1000L);
                    Application.scanDirectory();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            Application.startMonitor();
            throw throwable;
        }
        {
            Object var1_4 = null;
        }
        Application.startMonitor();
    }

    private static void startMonitor() {
        Thread monitor = new Thread(new Runnable(){

            public void run() {
                Application.monitor();
            }
        }, "Application Monitor");
        monitor.setDaemon(true);
        int priority = monitor.getPriority() - 1;
        if (priority < 1) {
            ++priority;
        }
        monitor.setPriority(priority);
        monitor.start();
    }
}

