/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.Control;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Index;
import nz.net.catalyst.lucene.server.Query;
import nz.net.catalyst.lucene.server.Session;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.UnIndex;

public class Dialogue
implements IPackage,
Constants {
    private final Transmission incomingTransmission;
    private Transmission result;
    private final BufferedReader input;
    private final PrintWriter output;

    public static Dialogue create(String line, BufferedReader input, PrintWriter output) {
        ECommand command = ECommand.getByName(line.trim());
        if (command == null) {
            return null;
        }
        Transmission transmission = new Transmission(command);
        return new Dialogue(new Transmission(command), input, output);
    }

    public static Dialogue create(Transmission transmission) {
        return new Dialogue(transmission, null, null);
    }

    public static Dialogue create(Transmission transmission, BufferedReader input, PrintWriter output) {
        return new Dialogue(transmission, input, output);
    }

    private Dialogue(Transmission transmission, BufferedReader input, PrintWriter output) {
        this.incomingTransmission = transmission;
        this.input = input;
        this.output = output;
    }

    public void process() throws IOException {
        if (!this.incomingTransmission.isXML()) {
            this.incomingTransmission.read(this.input);
        }
        ECommand command = this.incomingTransmission.getCommand();
        Log.debug("Transmission Command is \"" + command.getName() + "\"");
        if (command == ECommand.QUERY) {
            Query query = new Query(this.incomingTransmission);
            this.result = query.execute();
        } else if (command == ECommand.INDEX) {
            Index index = new Index(this.incomingTransmission);
            this.result = index.execute();
        } else if (command == ECommand.CONTROL) {
            Control control = new Control(this.incomingTransmission);
            this.result = control.execute();
        } else if (command == ECommand.UNINDEX) {
            UnIndex unIndex = new UnIndex(this.incomingTransmission);
            this.result = unIndex.execute();
        } else {
            String msg = "Unknown command, cannot process \"" + command.getName() + "\"";
            Log.error(msg);
            Session.error(this.output, msg);
            return;
        }
        this.result.setXML(this.incomingTransmission.isXML());
        this.result.write(this.output);
    }
}

