/*
 * TestIt.java
 *
 * See package.html for licence.
 *
 * Created on 2002. j?lius 14., 16:07
 */

package nz.net.catalyst.lucene.cache;
import java.io.File;
import java.io.IOException;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;

/**
 * This code is a test client for the IndexSearherCache
 *
 * It has since been rendered inoperable because of Hamish Carpenter's changes
 * to IndexSearcherCache.  Comments in code below.
 *
 * @author  Hal&aacute;csy P&eacute;ter
 */
public class TestIt {

    /** Creates a new instance of TestIt */
    public TestIt() {
    }
    static Analyzer analyzer = new SimpleAnalyzer();
    /** The main method to run the test client.
     * @param args the command line arguments
     * @throws Exception If something bad happens.  Usually unable to open index.
     */
    public static void main(String[] args) throws Exception {
        // creating an index
        File tempFile = new File("c:\\temp\\index34");
        
        modifyIndex(tempFile, true);
        
        //CHANGES HERE BECAUSE OF CHANGE TO IndexSearcherCache BECOMMING A 
        //SINGLETON.
        //IndexSearcherCache sm = new IndexSearcherCache(tempFile);
        IndexSearcherCache sm = IndexSearcherCache.getInstance(tempFile);

        Searcher s;
        s = sm.getSearcher();
        s = sm.getSearcher();
        s = sm.getSearcher();
        s = sm.getSearcher();
        s = sm.getSearcher();
        s.close();
        s.close();
        s.close();
        s.close();
        s.close();


        System.out.println("requesting 1. searcher");
        Searcher searcher1  = sm.getSearcher();
        search(searcher1);
        System.out.println("requesting 2. searcher");
        Searcher searcher2  = sm.getSearcher();
        System.out.println("modifying index");
        modifyIndex(tempFile, false);
        System.out.println("requesting 3. searcher");
        Searcher searcher3  = sm.getSearcher();
        System.out.println("closing 2. searcher");
        searcher2.close();
        System.out.println("closgin 3. searcher");
        searcher3.close();
        System.out.println("rerequesting 3. searcher");
        searcher3  = sm.getSearcher();
         search(searcher1);
        System.out.println("release everything");
        sm.release();
    }
    /** Perform a hardcoded search.
     * @param searcher The searcher to use when searching.
     * @throws Exception If something bad happens.
     */    
    public static void search(Searcher searcher) throws Exception {
        Query q = QueryParser.parse("bar", "foo", analyzer);
        Hits hits = searcher.search(q);
        System.out.println(hits.length());
    }
    /** Modify the index to test that it will be reopened.  I.e. make the searcher old.
     * @param file The file (directory) that represents the index.
     * @throws IOException If index cannot be opened/modified.
     */    
    public static void modifyIndex(File file, boolean _overwrite) throws IOException {
        IndexWriter writer = new IndexWriter(file, analyzer, _overwrite);
    	
        Document d = new Document();
        d.add(new Field("foo", "bar", true, true, true));
    	
        writer.addDocument(d);
        writer.close();

    }
}
