/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.Writer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultAttribute;

public abstract class AbstractAttribute
extends AbstractNode
implements Attribute {
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String asXML() {
        return String.valueOf(this.getQualifiedName()) + "=\"" + this.getValue() + "\"";
    }

    protected Node createXPathResult(Element parent) {
        return new DefaultAttribute(parent, this.getQName(), this.getValue());
    }

    public Object getData() {
        return this.getValue();
    }

    public String getName() {
        return this.getQName().getName();
    }

    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public short getNodeType() {
        return 2;
    }

    public String getPath(Element context) {
        Element parent = this.getParent();
        return parent != null && parent != context ? String.valueOf(parent.getPath(context)) + "/@" + this.getName() : "@" + this.getName();
    }

    public abstract QName getQName();

    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    public String getText() {
        return this.getValue();
    }

    public String getUniquePath(Element context) {
        Element parent = this.getParent();
        return parent != null && parent != context ? String.valueOf(parent.getUniquePath(context)) + "/@" + this.getName() : "@" + this.getName();
    }

    public abstract String getValue();

    public void setData(Object data) {
        this.setValue(data == null ? null : data.toString());
    }

    public void setNamespace(Namespace namespace) {
        throw new UnsupportedOperationException("This Attribute is read only and cannot be changed");
    }

    public void setText(String text) {
        this.setValue(text);
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException("This Attribute is read only and cannot be changed");
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\"]";
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getQualifiedName());
        writer.write("=\"");
        writer.write(this.getValue());
        writer.write("\"");
    }
}

