/*
 * Decompiled with CFR 0.152.
 */
package hu.origo.lucenetools.iac;

import hu.origo.lucenetools.iac.ManagedSearcher;
import hu.origo.lucenetools.iac.SearcherEvent;
import hu.origo.lucenetools.iac.SearcherListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexAccessControl
implements SearcherListener {
    private Analyzer analyzer;
    private Directory directory;
    private static final Map WRITER_PATHS = new HashMap();
    private static final Map SEARCHER_PATHS = new HashMap();
    private static final Map OLD_SEARCHERS = new HashMap();
    private static final Map instances = new HashMap();
    CheckoutInfo searcherInfo = null;
    CheckoutInfo oldSearcherInfo = null;

    public static IndexAccessControl getInstance(String path) throws IOException {
        return IndexAccessControl.getInstance(new File(path));
    }

    public static IndexAccessControl getInstance(File path) throws IOException {
        return IndexAccessControl.getInstance((Directory)FSDirectory.getDirectory((File)path, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexAccessControl getInstance(Directory directory) throws IOException {
        Map map = instances;
        synchronized (map) {
            IndexAccessControl iac = (IndexAccessControl)instances.get(directory);
            if (iac == null) {
                iac = new IndexAccessControl(directory, (Analyzer)new SimpleAnalyzer());
                instances.put(directory, iac);
            }
            return iac;
        }
    }

    private IndexAccessControl(Directory directory, Analyzer analyzer) {
        this.directory = directory;
        this.analyzer = analyzer;
    }

    private IndexAccessControl(File path, Analyzer analyzer) throws IOException {
        this((Directory)FSDirectory.getDirectory((File)path, (boolean)false), analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter getWriter() throws IOException {
        IndexWriter writer = null;
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            do {
                CheckoutInfo info;
                if ((info = (CheckoutInfo)WRITER_PATHS.get(this.directory)) != null) {
                    if (info.writer != null) {
                        ++info.checkoutCount;
                        writer = info.writer;
                        continue;
                    }
                    try {
                        info.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return null;
                    }
                } else {
                    writer = new IndexWriter(this.directory, this.analyzer, false);
                    writer.setUseCompoundFile(true);
                    writer.setMergeFactor(2);
                    CheckoutInfo checkoutInfo = new CheckoutInfo(writer);
                }
            } while (writer == null);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriter(IndexWriter writer) throws IOException {
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            CheckoutInfo info = (CheckoutInfo)WRITER_PATHS.get(this.directory);
            if (info != null && writer == info.writer) {
                if (info.checkoutCount > 1) {
                    --info.checkoutCount;
                    writer = null;
                } else {
                    WRITER_PATHS.remove(this.directory);
                    writer = info.writer;
                    info.notify();
                }
            }
        }
        if (writer != null) {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Searcher getSearcher() throws IOException {
        ManagedSearcher is;
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            if (this.searcherInfo == null || this.searcherInfo.searcher == null || this.searcherInfo.reader == null) {
                if (this.searcherInfo != null && this.searcherInfo.searcher != null) {
                    if (this.searcherInfo.checkoutCount > 1) {
                        --this.searcherInfo.checkoutCount;
                        this.oldSearcherInfo = this.searcherInfo;
                    } else {
                        System.out.println("closing a searcher");
                        this.searcherInfo.searcher.getRealSearcher().close();
                    }
                }
                System.out.println("creating new searcher");
                is = new ManagedSearcher(this, (Searcher)new IndexSearcher(IndexReader.open((Directory)this.directory)));
                this.searcherInfo = new CheckoutInfo(is);
            } else {
                is = this.searcherInfo.searcher;
                System.out.println("using existing searcher");
                ++this.searcherInfo.checkoutCount;
            }
        }
        return is;
    }

    public void searcherClosed(SearcherEvent event) throws IOException {
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " searcherClosed event received");
        this.releaseSearcher((ManagedSearcher)((Object)event.getSource()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSearcher(ManagedSearcher searcher) throws IOException {
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            CheckoutInfo info = this.searcherInfo;
            if (info == null || searcher != info.searcher) {
                info = this.oldSearcherInfo;
            }
            if (info != null) {
                if (info.checkoutCount > 1) {
                    --info.checkoutCount;
                } else {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " releaseSearcher() last reference: close");
                    info.searcher.getRealSearcher().close();
                }
            } else {
                throw new RuntimeException("huups!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getReader() throws IOException {
        IndexReader reader = null;
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            do {
                CheckoutInfo info;
                if ((info = (CheckoutInfo)WRITER_PATHS.get(this.directory)) != null) {
                    if (info.reader != null) {
                        ++info.checkoutCount;
                        reader = info.reader;
                        continue;
                    }
                    try {
                        info.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return null;
                    }
                } else {
                    reader = IndexReader.open((Directory)this.directory);
                    CheckoutInfo checkoutInfo = new CheckoutInfo(reader);
                }
            } while (reader == null);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReader(IndexReader reader) throws IOException {
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            CheckoutInfo info = (CheckoutInfo)WRITER_PATHS.get(this.directory);
            if (info != null && reader == info.reader) {
                if (info.checkoutCount > 1) {
                    --info.checkoutCount;
                    reader = null;
                } else {
                    WRITER_PATHS.remove(this.directory);
                    reader = info.reader;
                    info.notify();
                }
            }
        }
        if (reader != null) {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter releaseReaderAndGetWriter(IndexReader reader) throws IOException {
        IndexAccessControl indexAccessControl = this;
        synchronized (indexAccessControl) {
            this.releaseReader(reader);
            return this.getWriter();
        }
    }

    private static class CheckoutInfo {
        public IndexReader reader;
        public IndexWriter writer;
        public ManagedSearcher searcher;
        public int checkoutCount = 1;
        public long creationTime;

        CheckoutInfo(IndexWriter writer) {
            this.writer = writer;
        }

        CheckoutInfo(IndexReader reader) {
            this.reader = reader;
        }

        CheckoutInfo(ManagedSearcher searcher) {
            this.searcher = searcher;
            this.creationTime = System.currentTimeMillis();
        }
    }
}

