<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    or-schema-defs.php                                      */
/* Author:      Paul Waite                                              */
/* Description: Definitions for managing Oracle DATABASE SCHEMAS.       */
/*                                                                      */
/*              The main use of this class is to read in database info  */
/*              for other utilities, such as table maintenance scripts. */
/*                                                                      */
/* ******************************************************************** */
/** @package database */

/** Generic schema classes */
include_once("schema-defs.php");

// ----------------------------------------------------------------------
/** Defines a database sequence.
* @package database
*/
class DB_dbsequence extends dbsequence {
  // ....................................................................
  function DB_dbsequence(&$schema, $name) {
    $this->dbsequence($schema, $name);
  }
  // ....................................................................
  /** Get schema info for sequence */
  function getschema() {
  }
} // class DB_dbsequence

// ----------------------------------------------------------------------
/** Defines a database function (procedure).
* @package database
*/
class DB_dbfunction extends dbfunction {
  // ....................................................................
  function DB_dbfunction(&$schema, $name, $returns="", $src="", $args="", $lang="") {
    $this->dbfunction($schema, $name, $returns, $src, $args, $lang);
  }
  // ....................................................................
  /** Obtain function schema information. */
  function getschema() {
  }
} // class DB_dbfunction
// ----------------------------------------------------------------------
/** Defines a database index.
* @package database
*/
class DB_dbindex extends dbindex {
  // ....................................................................
  function DB_dbindex(&$schema, $name, $tablename, $flds="", $primary=false, $unique=false) {
    $this->dbindex($schema, $name, $tablename, $flds, $primary, $unique);
  }
  // ....................................................................
  /** Obtain index schema information.
  */
  function getschema() {
  }
} // class DB_dbindex

// ----------------------------------------------------------------------
/** Defines a database constraint.
* @package database
*/
class DB_dbconstraint extends dbconstraint {
  // ....................................................................
  function DB_dbconstraint(&$schema, $name, $type="p", $table="", $fktable="", $flds="",
                        $fkflds="", $updact="", $delact="", $match="", $cksrc="") {
    $this->dbconstraint($schema, $name, $type, $table, $fktable, $flds, $fkflds, $updact, $delact, $match, $cksrc);
  }
  // ....................................................................
  /** Obtain constraint schema information. */
  function getschema() {
  }
} // class DB_dbconstraint

// ----------------------------------------------------------------------
/** Defines a database trigger.
* @package database
*/
class DB_dbtrigger extends dbtrigger {
  // ....................................................................
  function DB_dbtrigger(&$schema, $name, $bitmask=0, $table="", $funcname="", $args="") {
    $this->dbtrigger($schema, $name, $bitmask, $table, $funcname, $args);
  }
  // ....................................................................
  /** Obtain trigger schema information. */
  function getschema() {
  }
} // class DB_dbtrigger

// ----------------------------------------------------------------------
/** Class describing a database field of a table.
* @package database
*/
class DB_dbfield extends dbfield {
  // ....................................................................
  function DB_dbfield(&$schema, $name, $num, $type, $defaultval="", $notnull=false, $ispkey=false) {
    $this->dbfield($schema, $name, $num, $type, $defaultval, $notnull, $ispkey);
  }
} // class DB_dbfield
// ----------------------------------------------------------------------
/** Class describing a database table. Inherits the standard
* dbtable class properties and methods, but adds in the getschema
* specifics for acquiring table info from the metadata for this DB, and
* provides a specific create() method.
* @package database
*/
class DB_dbtable extends dbtable {
  // ....................................................................
  /** Construct a table of given name and array of primary key fields.
  * @param string $name The name of the table
  * @param integer $dbversion Optional database version information
  */
  function DB_dbtable(&$schema, $name) {
    $this->dbtable($schema, $name);
  }
  // ....................................................................
  /**
  * Acquires the table fields and constraints which apply to it.
  * NB: This function is apt for this DB. Over-ride for other db types
  * @param mixed $schema Schema this table is in, or false if n/a
  */
  function getschema($mode=ALL) {
  }
} // class DB_dbtable

// ----------------------------------------------------------------------
/**
* Class describing a database schema.
* @package database
*/
class DB_schema extends schema {
  // ....................................................................
  /**
  * Create a schema (database) of given name. The name should be a
  * valid existing database name that is currently connected.
  * @param string $name Name of this particular database
  */
  function DB_schema($name) {
    $this->schema($name, "Oracle");
  }
  // ....................................................................
  /**
  * Populates our array of tables with all tables in this schema.
  */
  function gettables() {
  }
  // ....................................................................
  /**
  * Populates our array of triggers with all user triggers in this schema.
  */
  function gettriggers() {
  }
  // ....................................................................
  /**
  * Populates our array of functions with all user functions in this schema.
  */
  function getfunctions() {
  }
  // ....................................................................
  /**
  * Populates our array of sequences with all user sequences in this schema.
  */
  function getsequences() {
  }
  // ....................................................................
  /** Acquire the database server version. */
  function getversion() {
    $vstr = 1.0;
    $this->set_dbversion( (float) $vstr );
    debugbr("$this->database_server version detection", DBG_DEBUG);
    debugbr("database version set to $this->database_version", DBG_DEBUG);
    return $this->database_version;
  }
} // class DB_schema

// ----------------------------------------------------------------------
?>