<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-template.inc                                       */
/* Author:      Paul Waite                                              */
/* Description: Php webpage with Non-Content Management Layout.         */
/*              If you want to create a new non-managed webpage, then   */
/*              copy this one, and then customise it.                   */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Set these as appropriate:
$PAGE_TITLE = "My Page Title";
$TEMPLATE   = "My Template Name";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($PAGE_TITLE, $TEMPLATE, $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// -----------------------------------------------------------------------
// MAIN CONTENT
// Provide your main page content here, then plug it into the template.

$s  = "<h3>Under Construction</h3>";
$s .= "<p>This is a new page titled '$PAGE_TITLE' ";
$s .= "and using template '$TEMPLATE'. </p>";

$RESPONSE->plugin("MAIN_CONTENT", $s);


// #######################################################################
// OUTPUT..
$RESPONSE->send();
?>