<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-orgs.php                                           */
/* Author:      Paul Waite                                              */
/* Date:        February 2002                                           */
/* Description: Organisation setup page                                 */
/*              DEPRECATED in favour of the schema independent approach */
/*              using the maintainer-defs.php module. This is retained  */
/*              for non-Postgres implementations of Axyl due to the     */
/*              schema-independent parts not being written as yet.      */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------
$HEADING = "Organisations Setup";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");
include_once("pim-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) {
  $mode = "edit";  // Determines the action(s) we take
}

// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);


// #######################################################################
// POST PROCESSING

// SAVE
if (isset($_save_x) && isset($_REC_org_id)) {
  $ORG = new organisation($_REC_org_id);
  $ORG->POSTprocess();
  $recvalid = $ORG->exists;
  $mode = "edit";
}
// DELETE
elseif ($mode == "remove" && isset($_REC_org_id)) {
  $ORG = new organisation($_REC_org_id);
  if ($ORG->exists) {
    $ORG->delete();
  }
  $ORG = new organisation();
  $recvalid = false;
  $mode = "edit";
}
// ADD NEW
elseif (isset($_add_x)) {
  $ORG = new organisation();
  $recvalid = true;
  $HEADING .= " - New";
  $mode = "add";
}
// GENERAL EDIT MODE or CANCEL ADD
elseif (isset($_REC_org_id)) {
  $ORG = new organisation($_REC_org_id);
  $recvalid = $ORG->exists;
  $mode = "edit";
}
// NOTHING SELECTED
else {
  $ORG = new organisation();
  $recvalid = false;
}

// Put existing organisation name in heading..
if ($recvalid && $mode != "add" && $ORG->org_name != "") {
  $HEADING .= " - $ORG->org_name";
}

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// CONTROL BUTTONS
$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new record",        57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this record",    57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this item?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Item survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// ORGANISATION SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield("_REC_org_id", "Organisations", $ORG->orgid, EDITABLE, "width:250px;");
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.main_fm.submit()");
  $oQ = dbrecordset("SELECT * FROM ax_organisation WHERE org_id > 0 ORDER BY org_name");
  if ($oQ->rowcount > 0) {
    do {
      $orgid = $oQ->field("org_id");
      $orgname = $oQ->field("org_name");
      $Sel_F->additem($orgid, $orgname);
    } while ($oQ->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>Select:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$REC_SELECT = $s;

// -----------------------------------------------------------------------
// ORGANISATION DETAILS

$s = "";
if ($recvalid) {
  if ($mode == "add") {
    $REC_DETAILS = $ORG->render("hide_id");
  }
  else {
    $REC_DETAILS = $ORG->render("no_hide_id");
  }
}

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name=main_fm method="post">
  <!--AUTH_CODE_HIDDEN-->
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--REC_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--REC_DETAILS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("REC_SELECT",        $REC_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("REC_DETAILS",       $REC_DETAILS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>