<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-microsites.php                                     */
/* Author:      Paul Waite                                              */
/* Description: Microsites Setup Webpage                                */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("menumaint-defs.php");
include_once("recmaint-defs.php");
include_once("microsite-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Microsite Builder", "maint", $theme);

//debug_on(DBG_DUMP|DBG_DIAGNOSTIC|DBG_SQL|DBG_DEBUG);
//debug_on(DBG_TABLES);
//debug_output(DBG_O_LOG);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor,Author")) {
  $RESPONSE->send();
  exit;
}

// Only if enabled, else polite message..
if ($RESPONSE->microsites_mode == MICROSITES_ENABLED) {
  $microsite = new microsite("");
  $microsite->setalign("center");
  $MICROSITE = $microsite->render();
}
else {
  $MICROSITE = "<div align=\"center\"><p class=\"axerror\">"
             . "Microsite features are not enabled on this Axyl website."
             . "</p></div>";
}

// -----------------------------------------------------------------------------------------------
// MAIN CONTENT
$RESPONSE->plugin("MAIN_CONTENT", $MICROSITE);

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>