<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-prefs.php                                         */
/* Author:      Paul Waite                                              */
/* Description: Maintenance page for user preferences.                  */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
$HEADING = "Preferences for " . $RESPONSE->userid;

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if ($RESPONSE->ismemberof_group("Guest")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take

// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// PREFERENCES SETUP DETAILS
$href = "/axyl-login.php";
$href = href_addparm($href, "changepassword", "yes");
$change_password_link = new anchor($href, "Change Your Password");
$prefs = new configurator("preferences", $RESPONSE->userid);

$s  = "";
$s .= "<tr><td align=\"center\" valign=\"top\">" . $prefs->render() . "</td></tr>\n";
$s .= "<tr><td height=\"20\">&nbsp;</td></tr>\n";
$s .= "<tr><td align=\"center\" valign=\"top\">" . $change_password_link->render() . "</td></tr>\n";
$PREFS = $s;

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form class="axform" name="main_fm" method="post">
  <!--MODE_HIDDEN-->
  <table border="0" cellspacing="3" cellpadding="0" width="100%" align="center">
    <tr class="axtitle">
      <td colspan="2" align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align="center" colspan="2" class="axerror"><!--ERROR_MSG--></td>
    </tr>
    <tr><td colspan="2"><hr noshade></td></tr>
    <tr>
      <td valign="top" colspan="2"><!--PREFS--></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",      $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",          $HEADING);
$RESPONSE->plugin("ERROR_MSG",        $ERROR_MSG);
$RESPONSE->plugin("PREFS",            $PREFS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>