<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    db-odbc.php                                             */
/* Author:      Paul Waite                                              */
/* Description: Definitions for ODBC database access.                   */
/*                                                                      */
/* ******************************************************************** */
/** @package database */

/**
* ODBC database interface
* This is a database interface class. It is an impedance-matcher
* between the high-level Phplib functions for accessing data, and
* the specific functions suplpied by Php to access a particular
* flavour of databse such as Postgres, MS-SQL Server, Sybase etc.
* @package database
* @access private
*/
class db_odbc extends database {
  /** Constructor */
  function db_odbc($name="", $user="", $passwd="", $host="", $port=0) {
    $this->database($name, $user, $passwd, $host, $port);
    $this->type = "odbc";
  }
  // ....................................................................
  /**
  * Connect to the database.
  * @param boolean $persistent Whether to connect persistently or not
  * @return boolean Status true if connected successfully
  */
  function connect($persistent==NOT_PERSISTENT) {
    if (!$this->connected) {
      $dsn = "";
      $server  = "";
      if ($this->host != "") $server .= $this->host;
      if ($this->port != 0) $server .= ":" . $this->port;
      if ($server != "") $dsn .= "SERVER=$server;";
      $dsn .= "DATABASE=" . $this->name . ";";
      $dsn = trim($connstr);
      if ($persistent)
        $this->dbid = odbc_pconnect($dsn, $this->user, $this->passwd, SQL_CUR_USE_ODBC);
      else
        $this->dbid = odbc_connect($dsn, $this->user, $this->passwd, SQL_CUR_USE_ODBC);
      if ($this->dbid) {
        $this->connected = true;
      }
    }
    return $this->connected;
  }
  // ....................................................................
  /** Disconnect from the database, if connected. */
  function disconnect() {
    if (odbc_close($this->dbid)) {
      $this->connected = false;
    }
  }
  // ....................................................................
  /**
  * Execute a query on the connected database.
  * @param string $sql The SQL query to execute on the database
  * @return resource A database query resource ID, or false if query failed
  */
  function query($sql) {
    $sql = $this->convert_boolean_syntax($sql);
    $this->timer->restart();
    $rid = odbc_exec($this->dbid, $sql);
    $this->timer->stop();
    $this->executable_sql = $sql;
    $this->rid = $rid;
    $this->query_report();
    return $rid;
  }
  // ....................................................................
  /**
  * Return the number of rows returned by a SELECT query.
  * @param resource $rid The resource ID for the executed query
  * @return integer The number of rows returned by the query
  */
  function numrows($rid) {
    return odbc_num_rows($rid);
  }
  // ....................................................................
  /**
  * Return the number of rows affected by a query.
  * @param resource $rid The resource ID for the executed query
  * @return integer The number of rows affected by the query
  */
  function affectedrows($rid) {
    return odbc_num_rows($rid);
  }
  // ....................................................................
  /**
  * Free a resource.
  * @param resource $rid The resource ID for the executed query
  */
  function freeresult($rid) {
    odbc_free_result($rid);
  }
  // ....................................................................
  /**
  * Return the last error message.
  * @return string The last error message which was generated
  */
  function errormessage() {
    return odbc_errormsg($this->dbid);
  }
  // ....................................................................
  /**
  * Return the specified row, as a standard (enumerated) array of
  * field values.
  * @param resource $rid The resource ID for the executed query
  * @param integer $rowno Row number (zero-based) of row to return
  * @return array Enumerated array of field values
  */
  function fetch_row($rid, $rowno) {
    return odbc_fetch_row($rid, $rowno);
  }
  // ....................................................................
  /**
  * Return the specified row, as an associative array of fields
  * in a fieldname => value format.
  * @param resource $rid The resource ID for the executed query
  * @param integer $rowno Row number (zero-based) of row to return
  * @return array Associative array of field values
  */
  function fetch_array($rid, $rowno) {
    if(odbc_fetch_into($rid, $rowno, $ret)) {
      while (list($key, $value) = @each($ret)) {
        $arret[odbc_field_name($res, $key+1)] = $value;
      }
      return $arret;
    } else return false;
  }
}

// ----------------------------------------------------------------------
// Ensure ODBC Php module is present..
if (!extension_loaded("odbc")) {
  if (!dl("odbc.so")) {
    exit;
  }
}
// ----------------------------------------------------------------------
?>