/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    recmaint.js                                             */
/* Author:      Paul Waite                                              */
/* Description: Functions for maintaining a record in the browser.      */
/*                                                                      */
/* This function set is designed to display a set of records in a       */
/* web-browser and allow the user to scroll through these and make      */
/* modifications to multiple records before opting to save. As well as  */
/* including this file, you must provide some additional data           */
/* structures in the global Javascript scope, and some form elements    */
/* to return the submitted records, if modified.                        */
/*                                                                      */
/* (see recmaint-defs.php for usage)                                    */
/*                                                                      */
/* ******************************************************************** */
var field_delim = '^_^';
var record_delim = '~_~';
var orderchanged = false;
var disabled = false;
function disable(fm, mode, prefix) {
  if (disabled != mode) {
    var fdata=prefix+'_fdata',fpkey=prefix+'_fpkey';
    var fspec=prefix+'_fspec',flist=prefix+'_flist';
    var fmObj = eval('document.forms.' + fm);
    for (var i=0; i < fmObj.length; i++) {
      var e=fmObj.elements[i];
      if (e.id == fdata||e.id == fpkey||e.id == fspec||e.id == flist) {
        if (mode == true) {
          if (e.type == 'text'||e.type == 'textarea') e.value = '';
        }
        if (e.readOnly != null) e.readonly = mode;
        if (e.disabled != null) e.disabled = mode;
      }
    }
    disabled = mode;
  }
}
function getcurid(fm, pfx) {
  curid[pfx] = -1;
  var keycombo = findFieldObj(fm, keyfield[pfx]);
  if (keycombo != null && keycombo.options.length > 0) {
    ix = keycombo.selectedIndex;
    if (ix == -1) {
      keycombo.selectedIndex = 0;
      ix = 0;
    }
    curid[pfx] = keycombo.options[ix].value;
  }
}
function inlist(val, list) {
  var a = list.split(',');
  for (var i=0; i<a.length; i++) {
    if (val == a[i]) {
      return true;
    }
  }
  return false;
}
function comboSet(combo, val) {
  if (combo != null) {
    for (var ix=0; ix<combo.options.length; ix++) {
      if (combo.options[ix].value != null) {
        if (combo.type == 'select-one') {
          if (combo.options[ix].value == val) {
            combo.selectedIndex = ix;
            break;
          }
        }
        else {
          if (inlist(combo.options[ix].value, val))
            combo.options[ix].selected = true;
          else combo.options[ix].selected = false;
        }
      }
    }
  }
}
function comboMove(fm, fname, direction) {
  var combo = findFieldObj(fm, fname);
  if (combo.options.length > 0) {
    if (combo.selectedIndex == -1) combo.selectedIndex = 0;
    var ix = combo.selectedIndex;
    if (direction == 'up') {
      if (ix == 0) return;
      tmpval = combo.options[ix - 1].value;
      tmptxt = combo.options[ix - 1].text;
      combo.options[ix - 1].value = combo.options[ix].value;
      combo.options[ix - 1].text  = combo.options[ix].text;
      combo.options[ix].value = tmpval;
      combo.options[ix].text  = tmptxt;
      combo.selectedIndex = ix - 1;
    }
    else {
      if (ix >= (combo.options.length - 1)) return;
      tmpval = combo.options[ix + 1].value;
      tmptxt = combo.options[ix + 1].text;
      combo.options[ix + 1].value = combo.options[ix].value;
      combo.options[ix + 1].text  = combo.options[ix].text;
      combo.options[ix].value = tmpval;
      combo.options[ix].text  = tmptxt;
      combo.selectedIndex = ix + 1;
    }
    orderchanged = true;
  }
}
function findFieldObj(fm, fname) {
  var fObj = eval('document.forms.' + fm + '.' + fname);
  if (fObj == null) {
    var fmObj = eval('document.forms.' + fm);
    var max = fname.length;
    for (var i=0; i < fmObj.length; i++) {
      var e = fmObj.elements[i];
      if (e.name.substr(0, max) == fname) {
        fObj = e;
        break;
      }
    }
  }
  return fObj;
}
function setField(fm, fname, val) {
  var fObj = findFieldObj(fm, fname);
  if (fObj != null) {
    if (fObj.type != null) {
      if (fObj.type.substr(0,6) == 'select') { comboSet(fObj, val); }
      else if (fObj.type == 'checkbox') { fObj.checked = (val == 't'); }
      else if (fObj.type == 'textarea') {
        if ( fObj.id.substr(-5,5) == 'flist' ) {
          fObj.value = val.replace(/[|]/g, '\n');
        }
        else {
          fObj.value = val;
        }
      }
      else fObj.value=val;
    }
  }
}
function getField(fm, fname) {
  var val = '';
  var fObj = findFieldObj(fm, fname);
  if (fObj != null && fObj.type != null) {
    if (fObj.type == 'checkbox') {
      if (fObj.checked) val='t';
      else val='f';
    }
    else if (fObj.type == 'select-multiple') {
      for (var i=0; i<fObj.options.length; i++) {
        if (fObj.options[i].selected) {
          if (val != '') val += ',';
          val += fObj.options[i].value;
        }
      }
    }
    else if (fObj.type == 'textarea') {
      if ( fObj.id.substr(-5,5) == 'flist' ) {
        val = fObj.value.replace(/[\n]/g, '|');
      }
      else {
        val = fObj.value;
      }
    }
    else val = fObj.value;
  }
  return val;
}
function updateFields(fm, id, pfx) {
  var datObj = eval(pfx + 'dat_' + fm);
  if (datObj != null && datObj[id] != null) {
    rec = datObj[id].data;
    for (var fld in rec) {
      val = getField(fm, fld);
      setValue(fm, fld, id, val, pfx);
    }
  }
}
function displayFields(fm, id, pfx) {
  var datObj = eval(pfx + 'dat_' + fm);
  if (datObj != null && datObj[id] != null) {
    rec = datObj[id].data;
    for (var fld in rec) {
      val = getValue(fm, fld, id, pfx);
      setField(fm, fld, val);
    }
  }
}
function getValue(fm, fname, id, pfx) {
  var fldval = eval(pfx + 'dat_' + fm + '["' + id + '"].data.' + fname);
  if (fldval != null) return unescape(fldval);
  else return '';
}
function setValue(fm, fname, id, val, pfx) {
  var datObj = eval(pfx + 'dat_' + fm);
  if (datObj != null) {
    datObj[id].data[fname] = escape(val);
    datObj[id].changed=true;
  }
}
function changedValue(fm, fld, pfx) {
  if (curid[pfx] == -1) getcurid(fm, pfx);
  if (curid[pfx] != -1) {
    var fname = fld.name;
    if (fld.name.indexOf('[]') != -1) {
      fname = fname.substr(0, fname.length - 2);
    }
    setValue(fm, fname, curid[pfx], getField(fm, fname), pfx);
  }
}
function changeRecord(fm, keycombo, pfx) {
  if (keycombo.options.length > 0) {
    ix = keycombo.selectedIndex;
    if (ix == -1) ix = 0;
    id = keycombo.options[ix].value;
    displayFields(fm, id, pfx);
    curid[pfx] = id;
  }
}
function firstRecord(fm, pfx) {
  var keycombo = findFieldObj(fm, keyfield[pfx]);
  if (keycombo != null && keycombo.options.length > 0) {
    keycombo.selectedIndex = 0;
    changeRecord(fm, keycombo, pfx);
  }
}
function focusRecordByValue(fm, pfx, val) {
  var keycombo = findFieldObj(fm, keyfield[pfx]);
  if (keycombo != null && keycombo.options.length > 0) {
    comboSet(keycombo, val);
    changeRecord(fm, keycombo, pfx);
  }
}
function deleteRecord(fm, pfx) {
  var keycombo = findFieldObj(fm, keyfield[pfx]);
  if (keycombo != null && keycombo.options.length > 0) {
    getcurid(fm, pfx);
    if (curid[pfx] != -1) {
      var postDels = eval('document.forms.' + fm + '.' + pfx + 'recmaintpost_dels');
      if (postDels != null) {
        if (postDels.value != '') postDels.value += field_delim;
        postDels.value += curid[pfx];
      }
      datObj = eval(pfx + 'dat_' + fm);
      datObj[curid[pfx]] = null;
      ix = keycombo.selectedIndex;
      keycombo.options[ix] = null;
      if (ix > 0) keycombo.selectedIndex = (ix - 1);
      getcurid(fm, pfx);
      displayFields(fm, curid[pfx], pfx);
    }
    if (keycombo.options.length == 0) {
      disable(fm, true, keycombo.name);
    }
  }
}
function addRecord(fm, pfx) {
  var keycombo = findFieldObj(fm, keyfield[pfx]);
  if (keycombo != null) {
    disable(fm, false, keycombo.name);
    var newFunc = eval(pfx + 'new_' + fm);
    var newID = 'NEW_' + newid[pfx].toString();
    if (newFunc != null) {
      newFunc(newID);
      var newopt = new Option('<new item>', newID);
      newix = keycombo.options.length;
      keycombo.options[newix] = newopt;
      keycombo.selectedIndex = newix;
      changeRecord(fm, keycombo, pfx);
      newid[pfx] += 1;
      orderchanged = true;
    }
  }
}
function storeRecords(fm, pfx) {
  var stored=false;
  var datObj = eval(pfx + 'dat_' + fm);
  if (datObj != null) {
    var postData = eval('document.forms.' + fm + '.' + pfx + 'recmaintpost_data');
    if (postData != null) {
      postData.value = '';
      for (var id in datObj) {
        rec = datObj[id];
        if (rec != null && rec.changed) {
          if (postData.value != '') postData.value += record_delim;
          datastr=rec.keyid;
          for (var fld in rec.data) {
            if (datastr != '') datastr += field_delim;
            datastr += getValue(fm, fld, id, pfx);
          }
          postData.value += datastr;
        }
      }
      if (orderchanged) {
        var cboObj = eval('document.forms.' + fm + '.' + keyfield[pfx]);
        var postOrd = eval('document.forms.' + fm + '.' + pfx + 'recmaintpost_order');
        if (postOrd != null && cboObj != null && cboObj.options.length > 0) {
          for (var ix=0; ix<cboObj.options.length; ix++) {
            if (postOrd.value != '') postOrd.value += field_delim;
            postOrd.value += cboObj.options[ix].value;
          }
        }
      }
      stored = true;
    }
  }
  return stored;
}
function saveRecords(fm, pfx) {
  if (storeRecords(fm, pfx)) {
    var theForm = eval('document.forms.' + fm);
    if (theForm != null) theForm.submit();
  }
}
function datarec(keyid, data, pfx) {
  this.keyid=keyid;
  this.data=data;
  this.changed=false;
  curid[pfx] = keyid;
}
function limitInt(fld, lo, hi) {
  val = fld.value;
  re = /\$|,|%/g;
  valnew = val.replace(re, "");
  vali = parseInt(valnew);
  if (vali < lo || isNaN(vali)) vali = lo;
  else if (vali > hi) vali = hi;
  fld.value = vali;
}
function urlEncode(str) {
  len = str.length;
  res = new String();
  charOrd = new Number();
  for (i = 0; i < len; i++) {
    chk = str.substr(i, 3);
    if (chk == '%0D'||chk == '%0A'||chk == '%27') {
      res += chk;
      i += 3;
    }
    else {
      charOrd = str.charCodeAt(i);
      if ((charOrd >= 65 && charOrd <= 90)
       || (charOrd >= 97 && charOrd <= 122)
       || (charOrd >= 48 && charOrd <= 57)
       || (charOrd == 33)
       || (charOrd == 36)
       || (charOrd == 95)) {
        // this is alphanumeric or $-_.+!*'(), which according
        // to RFC1738 we don't escape
        res += str.charAt(i);
      }
      else {
        res += '%';
        if (charOrd > 255) res += 'u';
        hexValStr = charOrd.toString(16);
        if ((hexValStr.length) % 2 == 1) hexValStr = '0' + hexValStr;
        res += hexValStr;
      }
    }
  }
  return res;
}
function urlDecode(str) {
  mystr = unescape(mystr);
  return mystr;
}