<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    keep-defs.php                                           */
/* Author:      Paul Waite                                              */
/* Description: Definitions for a 'keep' which guards the values of     */
/*              variables for a session. This currently uses the PHP    */
/*              'session' handling to achieve this.                     */
/*                                                                      */
/*              NB: This assumes 'track_vars' and 'register_globals'    */
/*              are set to 'On' in php.ini.                             */
/*              ('register_globals' is the newer name, but in older     */
/*              versions of php, it was called 'gpc_globals').          */
/*                                                                      */
/* ******************************************************************** */
/** @package core */

// ----------------------------------------------------------------------
/**
* Keep class
* A simple class for remembering variables or forgetting
* them using the PHP session handling routines..
* @package core
*/
class keep {
  /** The name of the cookie to use
      @access private */
  var $cookiename = "";
  // ....................................................................
  /**
  * Constructor
  * Create a new keep object. Sets basic field attributes.
  * @param string  $name        The name of the keep. This is used as the cookie name.
  * @param integer $expiresecs  Lifetime of the keep cookie
  */
  function keep($name="SESSIONKEEP", $expiresecs=0) {
    global $RESPONSE;
    $this->cookiename = $name;
    session_name($name);
    if (isset($RESPONSE)) {
      session_set_cookie_params($expiresecs, "/", $RESPONSE->http_host);
    }
    else {
      session_set_cookie_params($expiresecs);
    }
    session_start();
  } // keep
  // ....................................................................
  /**
  * Remember variable names
  * Register the given comma-delimited list of varnames
  * in the current session..
  * @param string $varnames A list of comma-delimited var names to remember in the keep
  */
  function remember($varnames) {
    $allvars = explode(",", $varnames);
    foreach ($allvars as $var) {
      global $$var;
      if (!isset($$var)) $$var = "";
      if (!session_is_registered($var)) {
        debugbr("session keep variable '$var' registered");
        session_register($var);
      }
    }
  } // remember
  // ....................................................................
  /**
  * Forget variable names
  * Un-register the given comma-delimited list of varnames
  * in the current session..
  * @param string $varnames A list of comma-delimited var names to forget from the keep
  */
  function forget($varnames) {
    $allvars = explode(",", $varnames);
    foreach ($allvars as $var) {
      global $$var;
      if (session_is_registered($var)) {
        session_unregister($var);
      }
    }
  } // forget
  // ....................................................................
  /**
  * Unset all registered variables.
  */
  function forgetall() {
    session_unset();
  } // forgetall
  // ....................................................................
  /**
  * Delete registered variables.
  * Unset all vars, and delete the session cookie.
  */
  function delete() {
    //$this->forgetall();
    setcookie($this->cookiename, "", time() - 3600);
  } // delete
} // keep class

// ----------------------------------------------------------------------
?>