<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    site-search.php                                         */
/* Author:      Paul Waite                                              */
/* Date:        June 2004                                               */
/* Description: Search site for managed content.                        */
/*                                                                      */
/*              This module is designed to be called from pages which   */
/*              implement the search form. It checks for search form    */
/*              submission, and if a search is being done, it snaffles  */
/*              the page for itself and returns search results.         */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -------------------------------------------------------------------------
// CHECK FOR LUCENE
$lucene_enabled = true;
$config = new configuration("sys_control");
if ($config->field_exists("Lucene Site Indexing")) {
  $lucene_enabled = $config->value("Lucene Site Indexing");
}

// -------------------------------------------------------------------------
// GENERATE THE SEARCH FORM
// This piece of code is responsible for generating the widget(s) used to
// provide the user interface for entering search keywords and executing
// a search. Customise as you like. We are currently just plugging this
// content into the <!--SITE_SEARCH--> position in the template.

if ($lucene_enabled) {
  $search_textbox = new form_textfield("_search_text");
  $search_textbox->setclass("axsearchbox");
  $search_button = new form_imagebutton("_search_find", "", "", "$LIBDIR/img/_find.gif", "Find", 57, 15);

  $SEARCHFORM  = "<form name=searchfm>";
  $SEARCHFORM .= "<table cellspacing=0 cellpadding=2 border=0>";
  $SEARCHFORM .= "<tr>";
  $SEARCHFORM .= "<td>" . $search_textbox->render() . "</td>";
  $SEARCHFORM .= "<td>" . $search_button->render()  . "</td>";
  $SEARCHFORM .= "</tr>";
  $SEARCHFORM .= "</table>";
  $SEARCHFORM .= "</form>";
}

// -------------------------------------------------------------------------
// FIRST, CHECK FOR SEARCHING ACTIVITY
// Check if they are executing a search..
// $_search_x      Button   - Search execution
// $_search_text   Textbox  - search term(s)
// $_search_news   Checkbox - News and Press releases
// $_search_vac    Checkbox - Vacancies
// $_search_ind    Checkbox - Industry and Product Info (site webpages)
if ($lucene_enabled && isset($_search_find_x) && isset($_search_text) && $_search_text != "") {
  include_once("lucene-defs.php");

  // Redefine the webpage for search results..
  // Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
  $RESPONSE->page("Search", "main", $theme);

  // -----------------------------------------------------------------------
  // Show story window..
  $RESPONSE->body->add_popup_script(
    "showitem", 500, 480, 120, 20,
    "toolbar=no,status=yes,scrollbars=yes,resizable=yes"
    );

  // Consult Lucene. We assume that site content is indexed with a common
  // field called 'category' which categorises the content. We predefine
  // one such category as "sitecontent" and this means anything within the
  // standard Axyl content-managed blocks. Feel free to define other such
  // categories as you like, and then you should add them here.
  // Tip: if you do this, then you can also add some user controls for them
  // to select which categories to search, eg. with checkboxes next to the
  // search form textbox.

  $M = new lucene_search();

  // Always search Axyl managed content..
  $M->may_match("(category:sitecontent AND $_search_text)");

  // Also search the standard news stories..
  $M->may_match("(category:news AND $_search_text)");

  // Maybe there is a user-specified category. Obviously you can add
  // widgets like checkbozes etc. and use these to specify or filter
  // the searching however you like at this point..
  if (isset($_search_category)) {
    $M->may_match("(category:\"$_search_category\" AND $_search_text)");
  }

  // We also set a standard here for Axyl indexed content: we have the following
  // fields already defined and support is also in the Axyl DB for them:
  //  category     - The category, eg. 'sitecontent' is Axyl managed-content.
  //  title        - The title of the item
  //  path         - Local path to the item (blank for remote URL)
  //  remote_url   - If item is remote webpage, the URL of that page
  //  written      - Date-time item was published/written
  //  lastmodified - Date-time item was last changed

  $M->set_returnfields("category,title,path,remote_url,written:Date,lastmodified:Date");
  $M->set_sortorder("rank");
  $M->set_maxresults(100);
  $M->execute();

  // -----------------------------------------------------------------------
  // MAIN CONTENT
  $Tn = new table("search_results", "tablestyle_1");
  $Tn->rowstripes("axyl_rowstripe_dark,axyl_rowstripe_lite");
  $Tn->tr();
  $Tn->th("Rank", "text-align:center");
  $Tn->th("Date", "text-align:center");
  $Tn->th("Article", "text-align:left");

  if ($M->hitcount > 0) {
    $alreadyfound = array();
    foreach ($M->hit as $hitfields) {

      $category = trim($hitfields["category"]);
      $rank = number_format( $hitfields["RANK"] * 100, 1 );

      switch ($category) {
        case "sitecontent":
          $pagetitle = trim($hitfields["title"]);
          $pagepath  = trim($hitfields["path"]);
          if (!in_array($pagepath, $alreadyfound)) {
            $alreadyfound[] = $pagepath;
            $page_date = timestamp_to_displaydate(NICE_DATE, trim($hitfields["lastmodified"]));
            $hitlink = new Link("");
            $hitlink->label = rawurldecode($pagetitle);
            $hitlink->set_href( $pagepath );
            // Put it in the table..
            $Tn->tr();
            $Tn->td( $rank );
            $Tn->td_alignment("center", "top");
            $Tn->td( $page_date );
            $Tn->td_contentcss("storytxt");
            $Tn->td_alignment("center", "top");
            $Tn->td( $hitlink->render(), "storytxt" );
            $Tn->td_alignment("", "top");
          }
          break;

        default:
          $story_id   = trim($hitfields["Id"]);
          $headline   = trim($hitfields["title"]);
          $story_date = timestamp_to_displaydate(NICE_DATE, trim($hitfields["written"]));
          $remote_url = $hitfields["remote_url"];
          $hitlink = new Link("");
          $hitlink->label = rawurldecode($headline);
          if ($remote_url != "") {
            $hitlink->set_href( add_http_prefix($remote_url) );
            $hitlink->target = "_new";
          }
          else {
            $hitlink->set_href( "javascript:showitem('/story-viewer.php?sid=$story_id')" );
          }
          // Put it in the table..
          $Tn->tr();
          $Tn->td( $rank );
          $Tn->td_alignment("center", "top");
          $Tn->td( $story_date );
          $Tn->td_alignment("center", "top");
          $Tn->td_contentcss("storytxt");
          $Tn->td_alignment("", "top");
          $Tn->td( $hitlink->render(), "storytxt" );
          $Tn->td_alignment("", "top");
      } // switch

    } // foreach
  }
  else {
    $Tn->tr();
    $Tn->td( "No articles matched your query." );
    $Tn->td_colspan(3);
  }
  $Tn->set_width_profile("10%,20%,70%");

  $CONTENT = $Tn->render();

  //debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
  //debug_on(DBG_ALL);

  // #######################################################################
  // OUTPUT..
  // These go last of all, since they are content
  // replacements within replacements..
  $RESPONSE->plugin("MAIN_CONTENT", $CONTENT);
  $RESPONSE->plugin("SITE_SEARCH", $SEARCHFORM);

  // -----------------------------------------------------------------------
  // DELIVER..
  $RESPONSE->send();
  exit;

}
else {
  // Plugin the search form on the pre-existing page..
  $RESPONSE->plugin("SITE_SEARCH", $SEARCHFORM);
}
?>