#!/bin/bash

# Get Axyl config..
if [ ! -f /etc/axyl/axyl.conf ] ; then
  echo "Axyl is not installed."
  exit 1
fi
. /etc/axyl/axyl.conf

# Stem for various filenames etc..
PROJECT=axyl

# Path to Axyl diff utility..
DBDIFF=${AXYL_HOME}/scripts/dbdiff.php

# Remote database host, or leave blank..
DBHOST=localhost

# User to connect as..
DBUSER=$USER

# Databse version..
PGVER=7.4

# Name of core database schema..
DBCORE="${PROJECT}_core"

# Diff options..
#OPTS="--no-drops"
OPTS=

# File to store diffs in. This will be over-written
# on each exec of the diff-get.sh script..
DIFFS="${PROJECT}_diffs.sql"
