#! /bin/sh
# Set up Axyl
# This script is intended for use when you have grabbed a CVS copy
# of the Axyl system, and need to set up the config file(s) as if
# it had been installed from its Debian package - a sort of
# developer's hack if you will.
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set -e

echo ""
echo "AXYL SETUP"
echo ""
echo "Note: this is generally used by Developers to install a copy"
echo "of Axyl which has been obtained from CVS or a tarball. Make sure"
echo "you know what you're doing - possibly you want to run the"
echo "create-axyl-website.sh to create a new website instead?"
echo ""
echo -n "Continue? [N] :"
read ANS
if [ "$ANS" != "y" -a "$ANS" != "Y" ]
then
  echo "Ok, aborting.."
  exit 0
fi

# Get common funcs etc..
if [ -x ./axyl-common.sh ]
then
  . ./axyl-common.sh
else
  echo "ERROR: axyl-common.sh not found or not executable. You must"
  echo "execute this from within the Axyl 'install' directory, or"
  echo "check file permissions."
  exit 1
fi

if [ "${AXYL_HOME}" != "" ]
then
  echo "Axyl seems to be already installed."
  echo "The config file ($CONF) says it is in $AXYL_HOME"
  echo ""
  echo -n "Do you want to re-write the configuration file? [N] :"
  read ANS
  if [ "$ANS" != "y" -a "$ANS" != "Y" ]
  then
    echo "Ok, aborting.."
    exit 0
  fi

  # Nullify old config file. Definitions come from
  # the include of axyl-common.sh above..
  if [ -d $CONFDIR ]
  then
    rm -f $CONF
  fi
  AXYL_HOME=
  AXYL_DATA=/var/lib/axyl
  AXYL_LOGS=
fi

echo ""
echo "This script will initialise the Axyl config file to point to"
echo "the current Axyl location, and also optionally install the"
echo "Lucene Server for you."

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL INSTALLATION LOCATION
HERE=`pwd`
cd ..
AXYL_HOME=`pwd`
cd $HERE
echo ""
echo "Axyl Location"
echo "Enter the full path of the Axyl distribution.."
echo -n "[$AXYL_HOME] :"
read ANS
[ "$ANS" != "" ] && AXYL_HOME=$ANS

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# USERS AND GROUPS

# Set up the required users and groups
AXUSER=axyl
echo -n "Enter the Axyl administrator user [$AXUSER] :"
read ANS
[ "$ANS" != "" ] && AXUSER=$ANS

# The Axyl user..
mkuser $AXUSER $AXUSER $AXYL_HOME /bin/false Axyl Admin

# Webserver user and group..
WWWUSER=www-data
WWWGROUP=www-data
if [ -r ${APACHE_CONFDIR}/httpd.conf} ]
then
  G=`grep "^Group " ${APACHE_CONFDIR}/httpd.conf | cut -d" " -f2`
  U=`grep "^User " ${APACHE_CONFDIR}/httpd.conf | cut -d" " -f2`
  [ "$G" != "" ] && WWWGROUP=$G
  [ "$U" != "" ] && WWWUSER=$U
fi
mkuser $WWWUSER $WWWGROUP /var/www /bin/sh WWW User

# Web hosting administration group..
WWWADMIN=wwwadmin
mkgroup $WWWADMIN

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL VAR DATA AREA
# Tha main usage of this area is by the Luceneserver which comes
# with Axyl, and stores Lucene configs, and indexes here. The
# Lucene indexes can get big, so symlink as necessary to manage
# that aspect of the operation.
AXYL_DATA=/var/lib/axyl
echo ""
echo "Setting up the Axyl data area. This is where Lucene will store"
echo "varying (growing) data such as Lucene indexes, so make sure you"
echo "pick a location with that in mind."
echo ""
echo "Enter the full path of the Axyl data area.."
echo -n "[$AXYL_DATA] :"
read ANS
[ "$ANS" != "" ] && AXYL_DATA=$ANS

# Create directory and set perms..
mkaxyldir $AXYL_DATA
chown -R ${AXUSER}:${AXUSER} ${AXYL_DATA}
find ${AXYL_DATA} -type f -exec chmod 0664 {} \;
find ${AXYL_DATA} -type d -exec chmod 6755 {} \;

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL LOGGING AREA
if [ -d /var/log ]
then
  AXYL_LOGS=/var/log/axyl
else
  AXYL_LOGS=${AXYL_DATA}/log
fi

# Create directory and set perms..
mkaxyldir $AXYL_LOGS
chown -R ${AXUSER}:${AXUSER} ${AXYL_LOGS}
find ${AXYL_LOGS} -type f -exec chmod 0664 {} \;
find ${AXYL_LOGS} -type d -exec chmod 0755 {} \;

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# RE-WRITE CONFIGURATION
# Write out the config file for Axyl Lucene installer to use..
[ -z $LUCENE_PORT ] && LUCENE_PORT="null"
rewrite_axylconf $AXUSER $AXYL_HOME $AXYL_DATA $AXYL_LOGS $LUCENE_PORT

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# LUCENE (RE-)INSTALLATION
# This will (re-)install the Lucene Server, even if it is already
# installed. That way we ensure paths are re-written. But, we only
# do this if Axyl Lucene is installed..
if [ -e ${AXYL_HOME}/lucene ]
then
  LUCENE_INSTALLER=${AXYL_HOME}/lucene/install/install-lucene.sh
  if [ -x $LUCENE_INSTALLER ]
  then
    echo ""
    echo "(re-)installing Axyl Lucene.."
    LUCENE_OVERWRITE=y
    LUCENE_DEBCONF=n
    sh $LUCENE_INSTALLER $LUCENE_PORT $LUCENE_OVERWRITE $LUCENE_DEBCONF
  fi
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# HTMLAREA acquisition
# The htmlarea javascript package is required for content-managed
# HTML wysiwyg editing in Axyl. It is acquired from the relevant
# CVS repository on SourceForge here, as an export.
if [ ! -f ${AXYL_HOME}/lib/js/htmlarea/htmlarea.js ]
then
  echo ""
  echo "HTMLArea is a required Axyl package for wysiwyg content"
  echo "editing. It is acquired via CVS export from SourceForge. Do"
  echo -n "you want to acquire it now (recommended)? [Y] :"
  read ANS
  if [ "$ANS" = "y" -o "$ANS" = "Y" -o "$ANS" = "" ]
  then
    cd ${AXYL_HOME}/install
    ./get-htmlarea.sh
  fi
fi
# Confirm end result..
echo ""
if [ -f ${AXYL_HOME}/lib/js/htmlarea/htmlarea.js ]
then
  echo "HTMLArea is installed in ${AXYL_HOME}/lib/js/htmlarea."
else
  echo "HTMLArea is NOT installed in ${AXYL_HOME}/lib/js/htmlarea."
  echo "You will not have wysiwyg content editing facilities until"
  echo "such time as it is. See ${AXYL_HOME}/install/get-htmlarea.sh"
  echo "which is provided for this purpose."
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# FINISH UP
# Confirm directly from the configuration file itself..
if [ -f $CONF ]
then
  # Read everything back..
  . $CONF

  # Always re-write version file if we can establish version..
  # (nb: some vars below are defined in axyl-common.sh)
  CHGLOG=../debian/changelog
  if [ -f $CHGLOG ]
  then
    echo ""
    echo "re-writing the Axyl version file.."
    NEW_AXYL_VERSION=`head -n 1 $CHGLOG | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`
    echo $NEW_AXYL_VERSION >$VERSIONFILE
    if [ "$AXYL_VERSION" != "$NEW_AXYL_VERSION" ] ; then
      if [ "$AXYL_VERSION" = "" ] ; then
        AXYL_VERSION=unset
      fi
      echo "Note: version is now $NEW_AXYL_VERSION (was $AXYL_VERSION)"
      AXYL_VERSION=$NEW_AXYL_VERSION
    fi
  else
    echo "ERROR: could not locate Debian 'changelog' file. Are you running"
    echo "this script from AXYL_HOME/install/ ?"
  fi

  # Assert proper ownership & perms..
  chown -R ${AXUSER}:${AXUSER} $CONFDIR
  chmod -R 0644 $CONFDIR
  find $CONFDIR -type d -exec chmod 0775 {} \;

  # Read the current version file..
  AXYL_VERSION=`cat $VERSIONFILE`
  if [ "$AXYL_VERSION" = "" ]
  then
    AXYL_VERSION="unknown"
  fi

  echo ""
  echo "Configuration summary"
  echo " Axyl version: $AXYL_VERSION"
  echo " Axyl administrator: $AXUSER"
  echo " Axyl installation home: $AXYL_HOME"
  echo " Axyl data area: $AXYL_DATA"
  echo " Axyl logging area: $AXYL_LOGS"
  echo " Lucene port: $LUCENE_PORT"
  echo ""
  echo "To create website(s) from now on, you need to execute the script"
  echo "$AXYL_HOME/install/create-axyl-website.sh"

else
  echo "Axyl was NOT set up successfully."
fi

# END
