<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    mime-types.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Mime types for usage within Axyl.                       */
/*                                                                      */
/* ******************************************************************** */
/** @package core */

// ----------------------------------------------------------------------
/** TEXT */
define("CONTENT_TEXT",      "text/plain");
/** HTML attachments */
define("CONTENT_HTML",      "text/html");
/** XML attachments */
define("CONTENT_XML",       "text/xml");
/** CSV attachments */
define("CONTENT_CSV",       "text/csv");

// IMAGES
/** Jpeg image attachment */
define("CONTENT_JPEG",      "image/jpeg");
/** Photo Jpeg image attachment */
define("CONTENT_PHOTO",     "image/pjpeg");
/** GIF attachment */
define("CONTENT_GIF",       "image/gif");
/** PNG attachment */
define("CONTENT_PNG",       "image/png");
/** BMP attachment */
define("CONTENT_BMP",       "image/bmp");
/** TIFF attachment */
define("CONTENT_TIFF",      "image/tiff");

// MISC. BINARIES/EXECUTABLES
/** Binaries of questionable parentage */
define("CONTENT_OCTET",     "application/octet-stream");

// MICROSOFT
/** EXE files, binaries of poor parentage */
define("CONTENT_MSDOS",     "application/x-msdos-program");
/** M$ Word docs */
define("CONTENT_MSWORD",    "application/msword");
/** M$ Excel spreadsheets */
define("CONTENT_MSEXCEL",   "application/vnd.ms-excel");
/** M$ Project files */
define("CONTENT_MSPROJECT", "application/vnd.ms-project");
/** M$ Word docs */
define("CONTENT_MSACCESS",  "application/msaccess");

// DOCUMENTS
/** Adobe PDF's */
define("CONTENT_PDF",       "application/pdf");
/** Postscript format */
define("CONTENT_PSCRIPT",   "application/postscript");
/** Rich text format */
define("CONTENT_RTF",       "application/rtf");
/** Tex format */
define("CONTENT_TEX",       "application/x-tex");
/** Latex format */
define("CONTENT_LATEX",     "application/x-latex");

// ARCHIVE
/** ZIP archive */
define("CONTENT_ZIP",       "application/zip");

// AUDIO
/** AU/SND basic audio files */
define("CONTENT_AUDIO",     "audio/basic");
/** MP3 audio files */
define("CONTENT_MP3",       "audio/mpeg");
/** AIFF sound files */
define("CONTENT_AIFF",      "audio/x-aiff");
/** WAV sound files */
define("CONTENT_WAV",       "audio/x-wav");
/** REALAUDIO sound files */
define("CONTENT_RA",        "audio/x-realaudio");
/** OGG sound files */
define("CONTENT_OGG",       "audio/x-ogg");

// MOVIES
/** MPEG Movies */
define("CONTENT_MPEG",      "video/mpeg");
/** AVI Movies */
define("CONTENT_AVI",       "video/x-msvideo");
/** Media player ASF, ASX Movies */
define("CONTENT_ASF",       "video/x-ms-asf");
/** Quicktime movies */
define("CONTENT_QUICKTIME", "video/quicktime");
/** Shockwave Flash movies */
define("CONTENT_FLASH",     "application/x-shockwave-flash");
/** Windows Media Player */
define("CONTENT_WINMEDIA",  "application/x-mplayer2");

// .........................................................................
// Mime type groupings
define("IMAGE_MIMES",
        CONTENT_JPEG    . ","
      . CONTENT_PHOTO   . ","
      . CONTENT_GIF     . ","
      . CONTENT_PNG     . ","
      . CONTENT_BMP     . ","
      . CONTENT_TIFF
      );
define("DOCUMENT_MIMES",
        CONTENT_TEXT    . ","
      . CONTENT_HTML    . ","
      . CONTENT_XML     . ","
      . CONTENT_TEX     . ","
      . CONTENT_LATEX   . ","
      . CONTENT_CSV     . ","
      . CONTENT_MSWORD  . ","
      . CONTENT_MSEXCEL . ","
      . CONTENT_PDF     . ","
      . CONTENT_PSCRIPT . ","
      . CONTENT_RTF
      );
define("AUDIO_MIMES",
        CONTENT_AUDIO   . ","
      . CONTENT_MP3     . ","
      . CONTENT_AIFF    . ","
      . CONTENT_WAV     . ","
      . CONTENT_RA      . ","
      . CONTENT_OGG
      );
define("MOVIE_MIMES",
        CONTENT_MPEG    . ","
      . CONTENT_AVI     . ","
      . CONTENT_ASF     . ","
      . CONTENT_QUICKTIME
      );
define("FLASH_MIMES",
        CONTENT_FLASH
      );
define("ALL_MIMES",
        IMAGE_MIMES      . ","
      . DOCUMENT_MIMES   . ","
      . AUDIO_MIMES      . ","
      . MOVIE_MIMES
        );

// .........................................................................
// Mimetype grouping values and descriptions
$mime_categories = array(
  "image"    => "Images",
  "document" => "Documents",
  "audio"    => "Audio",
  "movie"    => "Movies",
  "flash"    => "Flash"
  );

// .........................................................................
// Mime types by file extension
$extn_mimetypes = array(
  "au"    => CONTENT_AUDIO,
  "snd"   => CONTENT_AUDIO,
  "mp3"   => CONTENT_MP3,
  "aif"   => CONTENT_AIFF,
  "aiff"  => CONTENT_AIFF,
  "aifc"  => CONTENT_AIFF,
  "wav"   => CONTENT_WAV,
  "ogg"   => CONTENT_OGG,
  "ra"    => CONTENT_RA,
  "ram"   => CONTENT_RA,
  "mpg"   => CONTENT_MPEG,
  "mpe"   => CONTENT_MPEG,
  "mpeg"  => CONTENT_MPEG,
  "avi"   => CONTENT_AVI,
  "asf"   => CONTENT_ASF,
  "asx"   => CONTENT_ASF,
  "mov"   => CONTENT_QUICKTIME,
  "qt"    => CONTENT_QUICKTIME,
  "qtm"   => CONTENT_QUICKTIME,
  "swf"   => CONTENT_FLASH,
  "zip"   => CONTENT_ZIP,
  "txt"   => CONTENT_TEXT,
  "html"  => CONTENT_HTML,
  "htm"   => CONTENT_HTML,
  "xml"   => CONTENT_XML,
  "csv"   => CONTENT_CSV,
  "tex"   => CONTENT_TEX,
  "latex" => CONTENT_LATEX,
  "jfif"  => CONTENT_JPEG,
  "jpg"   => CONTENT_JPEG,
  "jpeg"  => CONTENT_JPEG,
  "pjpeg" => CONTENT_PHOTO,
  "gif"   => CONTENT_GIF,
  "png"   => CONTENT_PNG,
  "bmp"   => CONTENT_BMP,
  "tif "  => CONTENT_TIFF,
  "tiff " => CONTENT_TIFF,
  "exe"   => CONTENT_MSDOS,
  "doc"   => CONTENT_MSWORD,
  "xls"   => CONTENT_MSEXCEL,
  "mpp"   => CONTENT_MSPROJECT,
  "mdb"   => CONTENT_MSACCESS,
  "pdf"   => CONTENT_PDF,
  "rtf"   => CONTENT_RTF,
  "ps"    => CONTENT_PSCRIPT,
  "eps"   => CONTENT_PSCRIPT,
  "ai"    => CONTENT_PSCRIPT,
  ""      => CONTENT_OCTET
  );

// .........................................................................
/**
* Returns the category associated with the given mimetype. This just
* allows you to ascertain what basic group of objects the mimetype
* belongs to, like 'image', 'document', 'movie', 'sound', etc.
* @param string $mimetype The mimetype to categorise.
* @return string The overall mime category name
*/
function mimetype_category($mimetype="") {
  $cat = "";
  if ($mimetype != "") {
    $mimetype = strtolower(trim($mimetype));
    if     (strstr(IMAGE_MIMES,    $mimetype)) $cat = "image";
    elseif (strstr(DOCUMENT_MIMES, $mimetype)) $cat = "document";
    elseif (strstr(AUDIO_MIMES,    $mimetype)) $cat = "audio";
    elseif (strstr(MOVIE_MIMES,    $mimetype)) $cat = "movie";
    elseif (strstr(FLASH_MIMES,    $mimetype)) $cat = "flash";
  }
  return $cat;
} // mimetype_category

// .........................................................................
/**
* Returns the mimetype associated with the given filepath
* or false of no match was found..
* @param string $extn The file extension, eg: '.gif' etc.
* @return string The mimetype of the given file
*/
function mimetype_from_filename($path="") {
  global $extn_mimetypes;
  $rc = false;
  $extn = strtolower(get_file_extn($path));
  if ($extn != "") {
    if (isset($extn_mimetypes[$extn])) {
      $rc = $extn_mimetypes[$extn];
    }
  }
  return $rc;
} // mimetype_from_filename

// -------------------------------------------------------------------------
?>