<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    catalog-json.php                                        */
/* Author:      Paul Waite                                              */
/* Date:        April 2008                                              */
/* Description: Returns a JSON data stream of catalog references.       */
/*              Also asserts that a thumbnail image exists for each     */
/*              image in the catalog.                                   */
/*                                                                      */
/*              Allows catalog to be searched/filtred by keywords,      */
/*              mime categories, categories, and sorted as well.        */
/*                                                                      */
/************************************************************************/
include_once("application.php");
include_once("catalog-defs.php");

// -----------------------------------------------------------------------
// Example URL:
//  /axyl-catalog-json.php?$keywords=foo&mimecats=image&categories=rugby

// Search filtering
if (isset($keywords)) {
  $keywords = explode("|", $keywords);
}
if (isset($mimecats)) {
  $mimecats = explode("|", $mimecats);
}
if (isset($categories)) {
  $categories = explode("|", $categories);
}
if (!isset($sortby)) {
  $sortby = "uploaded";
}

// -----------------------------------------------------------------------
// Gather the catalog of media, then send to the browser direct
$catalog = new catalog();
$catalog->search($keywords, $mimecats, $categories, $sortby);
$catalog->send_as_json();
      
// ----------------------------------------------------------------------
?>