<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-catalog.php                                        */
/* Author:      Paul Waite                                              */
/* Description: A page for maintaining catalog entries. This is a       */
/*              facility for uploading various types of content, which  */
/*              is identified by its mime type, to the system. The      */
/*              database table 'catalog' is used to keep track of it.   */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
$HEADING = "Media Catalog";
//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "maint", $theme);
$RESPONSE->body->add_script(
    "function go(mode, catid) {\n"
  . "  if (mode == 'detach') {\n"
  . "    if (!confirm('NOTICE:\\nThis will remove the catalog item record, but\\n"
                    . "leave the physical file alone.\\n\\n"
                    . "Is that what you want?')) return false;\n"
  . "  }\n"
  . "  else if (mode == 'delete') {\n"
  . "    if (!confirm('NOTICE:\\nThis will remove both the catalog item record,\\n"
                    . "AND the physical file itself.\\n\\n"
                    . "Is that what you want?')) return false;\n"
  . "  }\n"
  . "  else {\n"
  . "    if (mode != 'edit' && document.forms.upload_fm.upload_name.value == '') {\n"
  . "      alert('Please fill in a name for the item.');\n"
  . "      return false;\n"
  . "    }\n"
  . "  }\n"
  . "  document.forms.upload_fm.mode.value=mode;\n"
  . "  document.forms.upload_fm.catid.value=catid;\n"
  . "  document.forms.upload_fm.submit();\n"
  . "  return true;\n"
  . "}\n"
  );

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("mime-types.php");
include_once("form-defs.php");
include_once("button-defs.php");
include_once("catalog-defs.php");

// -----------------------------------------------------------------------
// CATALOG
// Here is where we define the Catalog Object which we will be using.
// This is also where you define your user categories, which allow you
// to grup catalog items, if you wish. An example is shown below, so
// uncomment it and define your own as appropriate..
$catalog = new catalog();

// User-defined categories.
// These are your own categories for grouping your catalog items. Each
// category should have a simple one-word code, and a descriptive name
// associated with it. Define these as you like, but always leave the
// Nullstring option in the list since this is required to denote "Any"
// or "All" categories. The ones below are just examples.
$categories = array(
    ""      => "",
    "news"  => "News",
    "misc"  => "Miscellaneous"
    );

// Add microsites as categories, which allows filtering..
if ($RESPONSE->microsite_detected != "") {
  $msites = dbrecordset("SELECT microsite_name FROM ax_microsite ORDER BY microsite_name");
  if ($msites->hasdata) {
    do {
      $msname = $msites->field("microsite_name");
      $categories[$msname] = "Microsite $msname";
    } while ($msites->get_next());
  }
}
$catalog->set_categories($categories);

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) {
  $mode = "view";  // Determines the action(s) we take
  $firsttime = true;
}
else {
  $firsttime = false;
}
// Cancel out of editing..
if (isset($_refresh_x)) $mode = "view";


// Always want a catalog item..
$catalog_item = new catalogitem();

// #######################################################################
// POST PROCESSING
$overwrite_chk = false;
switch ($mode) {

  // ADD NEW CATALOG ITEM
  case "add":
    $errmsgs = $catalog_item->upload($upload_name, $category, $upload_desc, $keywords);
    if ($catalog_item->valid) {
      // Reset submitted values..
      $upload_name = "";
      $upload_desc = "";
      $keywords = "";
      $category = "";
      $mime_category = "";
      $width = 0;
      $height = 0;
    }
    break;

  // REMOVE CATALOG ITEM
  case "delete":
    if (isset($catid)) {
      $catalog_item->get($catid);
      if (!$catalog_item->delete()) {
        $errmsgs[] = "Failed to remove catalog item $catid. Permissions?";
      }
    }
    break;

  case "detach":
    if (isset($catid)) {
      $catalog_item->get($catid);
      if (!$catalog_item->detach()) {
        $errmsgs[] = "Failed to detach catalog item record $catid. Database issues?";
      }
    }
    break;

  // CANCEL EDITING
  case "cancel":
    $mode = "view";
    break;

  // SAVE EDITING CHANGES
  case "save":
    if (isset($catid)) {
      $catalog_item->get($catid);
      if ($catalog_item->valid) {
        $catalog_item->cat_name = $upload_name;
        $catalog_item->cat_desc = $upload_desc;
        $catalog_item->keywords = $keywords;
        $catalog_item->mime_category = $mime_category;
        $catalog_item->category = $category;
        $catalog_item->width = $width;
        $catalog_item->height = $height;
        $catalog_item->save();
        $upload_name = "";
        $upload_desc = "";
        $keywords = "";
        $category = "";
        $mime_category = "";
        $width = 0;
        $height = 0;
      }
    }
    $mode = "view";
    break;

} // switch


// #######################################################################
// FILE UPLOAD FORM
$uT = new table("upload");
$uT->setpadding(4);

// Width of form elements..
$pxwidth = "190px";

// Set form element display values..
if ($mode == "edit" && isset($catid)) {
  $catalog_item->get($catid);
  if ($catalog_item->valid) {
    $upload_name   = $catalog_item->cat_name;
    $upload_desc   = $catalog_item->cat_desc;
    $keywords      = $catalog_item->keywords;
    $mime_category = $catalog_item->mime_category;
    $category      = $catalog_item->category;
    $width         = $catalog_item->width;
    $height        = $catalog_item->height;
  }
}

// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs) && count($errmsgs) > 0) {
    $s .= "<span class=\"axerror\">" . implode("<br>", $errmsgs) . "</span>";
}
if ($s != "") {
  $uT->tr();
  $uT->td($s, "text-align:center");
  $uT->td_colspan(2);
}


// Upload file field, and overwrite field..
if ($mode != "edit") {
  $fld = new form_fileuploadfield("upload_file", "", "", 5242880, true);
  $uT->tr();
  $uT->td( "File to upload:", "axfmlbl" );
  $uT->td( $fld->render() );

  $fld = new form_checkbox("_overwrite", "Overwrite existing");
  $uT->tr();
  $uT->td( "Overwrite existing:", "axfmlbl" );
  $uT->td( $fld->render() );

}
else {
  $fld = new form_labelfield("filepath", $catalog_item->filepath);
  $uT->tr();
  $uT->td( "File path:", "axfmlbl" );
  $uT->td( $fld->render(), "axfmlbl" );
}

// Upload mime_category
if (!isset($mime_category)) $mime_category = "";
$fld = new form_combofield("mime_category", "Content type", $mime_category, EDITABLE, "width:$pxwidth;");
$fld->setclass("axcombo");
if ($mode != "edit") {
  $fld->additem("", "auto-detect");
}
$fld->additem("image",    "Image");
$fld->additem("document", "Document");
$fld->additem("audio",    "Audio");
$fld->additem("movie",    "Movie");
$uT->tr();
$uT->td( "Content type:", "axfmlbl" );
$uT->td( $fld->render() );

// Upload Name
$fld = new form_textfield("upload_name", "Name", $upload_name);
$fld->setclass("axtxtbox");
$fld->setstyle("width:$pxwidth;");
$uT->tr();
$uT->td( "Name:", "axfmlbl" );
$uT->td( $fld->render() );

// Upload Description
$fld = new form_memofield("upload_desc", "Description", $upload_desc);
$fld->setclass("axmemo");
$fld->setstyle("width:$pxwidth;height:100px;");
$uT->tr();
$uT->td( "Description:", "axfmlbl" );
$uT->td_alignment("", "top");
$uT->td( $fld->render() );
$uT->td_alignment("", "top");

// Keywords
$fld = new form_textfield("keywords", "Keywords", $keywords);
$fld->setclass("axtxtbox");
$fld->setstyle("width:$pxwidth;");
$uT->tr();
$uT->td( "Keywords:", "axfmlbl" );
$uT->td( $fld->render() );

// Optional categorisation selector. Uncomment this form element if
// you want to define a list of hard-coded category values to assign
// to your catalog items. Define values as per your requirement here..
if (!isset($category)) $category = "";
$fld = new form_combofield("category", "Category", $category, EDITABLE, "width:$pxwidth;");
$fld->setclass("axcombo");
foreach ($catalog->categories as $catval => $catdesc) {
  $fld->additem($catval, $catdesc);
}
$uT->tr();
$uT->td( "Category:", "axfmlbl" );
$uT->td( $fld->render() );

// Metrics
$wfld = new form_textfield("width", "", $width);
$wfld->setclass("axnumbox");
$wfld->setstyle("width:60px;");
$hfld = new form_textfield("height", "", $height);
$hfld->setclass("axnumbox");
$hfld->setstyle("width:60px;");
$Tm = new table("metrics");
$Tm->setwidth("");
$Tm->td($wfld->render() . "&nbsp;x&nbsp;" . $hfld->render());
$Tm->td("&nbsp;(Width x Height)");
$uT->tr();
$uT->td( "Size:", "axfmlbl" );
$uT->td( $Tm->render() );


// HIDDEN FIELDS
$hid_auth  = new form_hiddenfield("auth_code", $auth_code);
$hid_mode  = new form_hiddenfield("mode", $mode);
$hid_catid = new form_hiddenfield("catid", $catid);
$uT->tr();
$uT->td( $hid_auth->render() .  $hid_mode->render() . $hid_catid->render() );
$uT->td_colspan(2);

// ADD BUTTONS
$btns = array();
if ($mode == "edit") {
  $btn = new form_imagebutton("_save", "Save", "", "$LIBDIR/img/_save.gif", "Save changes", 57, 15);
  $btn->set_onclick("go('save','$catid')");
  $btns[] = $btn->render();
  $btn = new form_imagebutton("_detach", "Detach", "", "$LIBDIR/img/_detach.gif", "Remove catalog item record, leave file", 57, 15);
  $btn->set_onclick("go('detach','$catid')");
  $btns[] = $btn->render();
  $btn = new form_imagebutton("_delete", "Delete", "", "$LIBDIR/img/_delete.gif", "Delete file AND item record", 57, 15);
  $btn->set_onclick("go('delete','$catid')");
  $btns[] = $btn->render();
  
  $btn = new form_imagebutton("_show", "Show", "", "$LIBDIR/img/_show.gif", "Show the media item", 57, 15);
  $href = "/axyl-media-viewer.php";
  $href = href_addparm($href, "cat_id", $catid);
  $btn->set_onclick("show('$href','" . ceil($width * 1.08) . "','" . ceil($height * 1.05) . "')");
  $btns[] = $btn->render();
  $btn = new form_imagebutton("_cancel", "Cancel", "", "$LIBDIR/img/_cancel.gif", "Cancel edit", 57, 15);
  $btn->set_onclick("go('cancel','')");
  $btns[] = $btn->render();
}
else {
  $btn = new form_imagebutton("_add", "Add", "", "$LIBDIR/img/_add.gif", "Add this catalog item", 57, 15);
  $btn->set_onclick("go('add','')");
  $btns[] = $btn->render();
}
$uT->tr();
$uT->td();
$uT->td( implode("&nbsp;", $btns) );

// RENDER THE UPLOAD FIELDS
$UPLOAD_FIELDS = $uT->render();


// #######################################################################
// CATALOG FILTER FORM
// We do this form in a custom table, since we need the flexibility
// to format it nicely in this case.

// Table for filter elements..
$fT = new table("filter");
$fT->setpadding(4);

// Sorting
if (!isset($filt_sortby)) $filt_sortby = "uploaded";
$fld = new form_combofield("filt_sortby", "", $filt_sortby, EDITABLE, "width:$pxwidth;");
$fld->setclass("axcombo");
$fld->additem("rank",     "Most relevant");
$fld->additem("uploaded", "Most recent first");
$fld->additem("catname",  "Name");
$fld->additem("mimecat",  "Content type");
$fld->additem("category", "Category");
$fT->tr();
$fT->td( "Sorted by:", "axfmlbl" );
$fT->td( $fld->render() );

// Filter by keywords..
if ($SE_AVAILABLE) {
  $fld = new form_textfield("filt_keywords", "", $filt_keywords);
  $fld->setclass("axtxtbox");
  $fld->setstyle("width:$pxwidth;");
  $fT->td( "Keywords:", "axfmlbl" );
  $fT->td( $fld->render() );
}
else {
  $fT->td();
  $fT->td_colspan(2);
}

// Filter by content type(s)..
if (!isset($filt_mimecat)) $filt_mimecat = "";
$fld = new form_combofield("filt_mimecat", "", $filt_mimecat, EDITABLE, "width:$pxwidth;");
$fld->setclass("axlistbox");
$fld->set_size(5);
$fld->multiselect = true;
$fld->additem("",         "Any");
$fld->additem("image",    "Images");
$fld->additem("document", "Documents");
$fld->additem("audio",    "Audio clips");
$fld->additem("movie",    "Movies");
$fT->tr();
$fT->td( "Types:", "axfmlbl" );
$fT->td_alignment("", "top");
$fT->td( $fld->render() );

// Filter by category..
if (!isset($filt_category)) $filt_category = "";
$fld = new form_combofield("filt_category", "", $filt_category, EDITABLE, "width:$pxwidth;");
$fld->setclass("axlistbox");
$fld->set_size(5);
$fld->multiselect = true;
foreach ($catalog->categories as $catval => $catdesc) {
  $fld->additem($catval, $catdesc);
}
$fld->setvalue($filt_category);
$fT->td( "Categories:", "axfmlbl" );
$fT->td_alignment("", "top");
$fT->td( $fld->render() );

// Refresh button..
$btn = new form_imagebutton("_refresh", "Refresh", "", "$LIBDIR/img/_refresh.gif", "Refresh catalog list", 77, 15);
$fT->tr();
$fT->td();
$fT->td( $btn->render() );
$fT->td_colspan(3);

$FILTER_FIELDS = $fT->render();

// #######################################################################
// CATALOG CONTENTS

// Insert heading row into catalog table..
function catheadings(&$Tcat) {
  $Tcat->tr();
  $Tcat->td("<b>Name</b>", "axfmlbl");
  $Tcat->td("<b>Type</b>", "axfmlbl");
  $Tcat->td("<b>Category</b>", "axfmlbl");
  $Tcat->td("<b>Uploaded</b>", "axfmlbl");
  $Tcat->td("");
}

if (!$firsttime) {
  $catalog->search($filt_keywords, $filt_mimecat, $filt_category, $filt_sortby);
  $s = "";
  if ($catalog->itemcount() > 0) {
    // Table to hold catalog directory..
    $Tcat = new table("catalog", "font-size:85%;");
    $Tcat->tbody("");

    // Place javascript in page for popup display window..
    $RESPONSE->body->add_popup_script(
      "show",
      $width=false,
      $height=false,
      $left=120,
      $top=40,
      $features="toolbar=no,status=no,scrollbars=no,resizable=yes"
      );

    // Buttons used for every catalog item line..
    $editBtn   = new form_imagebutton("catedit",   "", "", "$LIBDIR/img/_e.gif",   "Edit",   14, 14);
    $showBtn   = new form_imagebutton("catshow",   "", "", "$LIBDIR/img/_dot.gif", "Show",   14, 14);

    // Once-only headings for non-grouped directory listings..
    if ($filt_sortby != "mimecat" && $filt_sortby != "category") {
      catheadings($Tcat);
    }

    // List out the directory..
    $last = "";
    foreach ($catalog->catalogitems as $ci) {
      // The reason we re-get is because the 'search' is usually conducted
      // via Lucene, and this does not contains the media metrics. This
      // re-get will retrieve ALL media information from the database..
      $ci->get($ci->cat_id);
      $cat_id        = $ci->cat_id;
      $cat_name      = $ci->cat_name;
      $mime_category = $ci->mime_category;
      $category      = $ci->category;
      $path          = $ci->filepath;
      $file          = basename($path);
      $timestamp     = $ci->uploaded;
      $width         = $ci->width;
      $height        = $ci->width;
      // Groupings..
      switch ($filt_sortby) {
        case "mimecat":
          // Mime category label,,
          if ($mime_category != $last) {
            $Tcat->tr("bgdark");
            $Tcat->td("<b>" . $mime_categories[$mime_category] . "</b>");
            $Tcat->td_colspan(6);
            $Tcat->td_alignment("center");
            $last = $mime_category;
            catheadings($Tcat);
          }
          break;
        case "category":
          // Category label,,
          if ($category != $last) {
            $Tcat->tr("bgdark");
            $Tcat->td("<b>$category</b>");
            $Tcat->td_colspan(6);
            $Tcat->td_alignment("center");
            $last = $category;
            catheadings($Tcat);
          }
          break;
      } //switch

      // Catalog entry..
      if (isset($catid) && $catid == $cat_id) {
        $tdcss = "axhl";
      }
      else {
        $tdcss = "axfg";
      }
      $Tcat->tr();
      $Tcat->td($cat_name);
      if ($tdcss != "") $Tcat->td_css($tdcss);
      $Tcat->td_alignment("", "top");
      $Tcat->td($mime_category);
      if ($tdcss != "") $Tcat->td_css($tdcss);
      $Tcat->td_alignment("", "top");
      $Tcat->td($category);
      if ($tdcss != "") $Tcat->td_css($tdcss);
      $Tcat->td_alignment("", "top");
      $Tcat->td($timestamp);
      if ($tdcss != "") $Tcat->td_css($tdcss);
      $Tcat->td_alignment("", "top");

      $buttons = "";
      $editBtn->set_onclick("go('edit','$cat_id')");
      $editBtn->settitle("Edit $file");

      if (file_exists($RESPONSE->site_docroot . $path)) {
        $href = "/axyl-media-viewer.php";
        $href = href_addparm($href, "cat_id", $cat_id);
        $showBtn->set_onclick("show('$href','" . ceil($width * 1.08) . "','" . ceil($height * 1.05) . "')");
        $buttons .= $showBtn->render() . "&nbsp;";
      }
      $buttons .= $editBtn->render();
      $Tcat->td( $buttons );
      $Tcat->td_alignment("right");
    }
    $Tcat->rowstripes("axyl_rowstripe_lite,axyl_rowstripe_dark");
    $Tcat->set_width_profile("30%,10%,25%,25%,10%");
    $s = $Tcat->render();
  }
  $CATALOG_CONTENTS = $s;
}
else {
  $CATALOG_CONTENTS = "";
}


// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<table border=0 cellspacing=0 cellpadding=0 width=100%>
  <tr>
    <td align=center valign=top>
      <form class="axform" name="upload_fm" method="post" enctype="multipart/form-data">
        <table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
          <tr class="axtitle">
            <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
          </tr>
          <tr class="axhdg">
            <td align=center><span class="axhdg"><b>Upload New Media</b></span></td>
          </tr>
          <tr class="axyl_rowstripe_lite">
            <td valign=top><!--UPLOAD_FIELDS--></td>
          </tr>
          <tr class="axhdg">
            <td align=center><span class="axhdg"><b>Catalog Directory Filter</b></span></td>
          </tr>
          <tr class="axyl_rowstripe_dark">
            <td valign=top><!--FILTER_FIELDS--></td>
          </tr>
          <tr class="axhdg">
            <td align=center><span class="axhdg"><b>Catalog Directory</b></span></td>
          </tr>
          <tr class="axyl_rowstripe_lite">
            <td valign=top><!--CATALOG_CONTENTS--></td>
          </tr>
          <tr>
            <td class="axfoot"></td>
          </tr>
        </table>
      </form>
    </td>
  </tr>
</table>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("HEADING",          $HEADING);
$RESPONSE->plugin("UPLOAD_FIELDS",    $UPLOAD_FIELDS);
$RESPONSE->plugin("FILTER_FIELDS",    $FILTER_FIELDS);
$RESPONSE->plugin("CATALOG_CONTENTS", $CATALOG_CONTENTS);
if ($RESPONSE->microsite_detected != "") {
  $RESPONSE->plugin("MAIN_MENU", "main_menu()");
}

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>