#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
from msrestazure.azure_operation import AzureOperationPoller
import uuid

from .. import models


class LbOperations(object):
    """LbOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def create_or_update(
            self, resource_group_name, deployment_name, load_balancer_name, content_version=None, backend_pool_name=None, dns_name_type="none", frontend_ip_name="LoadBalancerFrontEnd", location=None, private_ip_address=None, private_ip_address_allocation="dynamic", public_ip_address=None, public_ip_address_allocation="dynamic", public_ip_address_type="new", public_ip_dns_name=None, subnet=None, subnet_address_prefix="10.0.0.0/24", subnet_type="none", tags=None, virtual_network_name=None, vnet_address_prefix="10.0.0.0/16", custom_headers=None, raw=False, **operation_config):
        """
        Create or update a virtual machine.

        :param resource_group_name: The name of the resource group. The name
         is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param load_balancer_name: Name for load balancer.
        :type load_balancer_name: str
        :param content_version: If included it must match the ContentVersion
         in the template.
        :type content_version: str
        :param backend_pool_name: Name of load balancer backend pool.
        :type backend_pool_name: str
        :param dns_name_type: Associate VMs with a public IP address to a DNS
         name. Possible values include: 'none', 'new'
        :type dns_name_type: str or :class:`dnsNameType
         <lbcreationclient.models.dnsNameType>`
        :param frontend_ip_name: Name of the frontend IP configuration.
        :type frontend_ip_name: str
        :param location: Location for load balancer resource.
        :type location: str
        :param private_ip_address: Static private IP address to use.
        :type private_ip_address: str
        :param private_ip_address_allocation: Private IP address allocation
         method. Possible values include: 'dynamic', 'static'
        :type private_ip_address_allocation: str or
         :class:`privateIpAddressAllocation
         <lbcreationclient.models.privateIpAddressAllocation>`
        :param public_ip_address: Name or ID of the public IP address to use.
        :type public_ip_address: str
        :param public_ip_address_allocation: Public IP address allocation
         method. Possible values include: 'dynamic', 'static'
        :type public_ip_address_allocation: str or
         :class:`publicIpAddressAllocation
         <lbcreationclient.models.publicIpAddressAllocation>`
        :param public_ip_address_type: Type of Public IP Address to associate
         with the load balancer. Possible values include: 'none', 'new',
         'existingName', 'existingId'
        :type public_ip_address_type: str or :class:`publicIpAddressType
         <lbcreationclient.models.publicIpAddressType>`
        :param public_ip_dns_name: Globally unique DNS Name for the Public IP
         used to access the Virtual Machine (new public IP only).
        :type public_ip_dns_name: str
        :param subnet: The subnet name or ID to associate with the load
         balancer. Cannot be used in conjunction with a Public IP.
        :type subnet: str
        :param subnet_address_prefix: The subnet address prefix in CIDR
         format (new subnet only).
        :type subnet_address_prefix: str
        :param subnet_type: Use new, existing or no subnet. Possible values
         include: 'none', 'new', 'existingName', 'existingId'
        :type subnet_type: str or :class:`subnetType
         <lbcreationclient.models.subnetType>`
        :param tags: Tags object.
        :type tags: object
        :param virtual_network_name: The VNet name containing the subnet.
         Cannot be used in conjunction with a Public IP.
        :type virtual_network_name: str
        :param vnet_address_prefix: The virtual network IP address prefix in
         CIDR format (new subnet only).
        :type vnet_address_prefix: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :rtype:
         :class:`AzureOperationPoller<msrestazure.azure_operation.AzureOperationPoller>`
         instance that returns :class:`DeploymentExtended
         <default.models.DeploymentExtended>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        parameters = models.DeploymentLb(content_version=content_version, backend_pool_name=backend_pool_name, dns_name_type=dns_name_type, frontend_ip_name=frontend_ip_name, load_balancer_name=load_balancer_name, location=location, private_ip_address=private_ip_address, private_ip_address_allocation=private_ip_address_allocation, public_ip_address=public_ip_address, public_ip_address_allocation=public_ip_address_allocation, public_ip_address_type=public_ip_address_type, public_ip_dns_name=public_ip_dns_name, subnet=subnet, subnet_address_prefix=subnet_address_prefix, subnet_type=subnet_type, tags=tags, virtual_network_name=virtual_network_name, vnet_address_prefix=vnet_address_prefix)

        # Construct URL
        url = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'deploymentName': self._serialize.url("deployment_name", deployment_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'DeploymentLb')

        # Construct and send request
        def long_running_send():

            request = self._client.put(url, query_parameters)
            return self._client.send(
                request, header_parameters, body_content, **operation_config)

        def get_long_running_status(status_link, headers=None):

            request = self._client.get(status_link)
            if headers:
                request.headers.update(headers)
            return self._client.send(
                request, header_parameters, **operation_config)

        def get_long_running_output(response):

            if response.status_code not in [200, 201]:
                exp = CloudError(response)
                exp.request_id = response.headers.get('x-ms-request-id')
                raise exp

            deserialized = None

            if response.status_code == 200:
                deserialized = self._deserialize('DeploymentExtended', response)
            if response.status_code == 201:
                deserialized = self._deserialize('DeploymentExtended', response)

            if raw:
                client_raw_response = ClientRawResponse(deserialized, response)
                return client_raw_response

            return deserialized

        if raw:
            response = long_running_send()
            return get_long_running_output(response)

        long_running_operation_timeout = operation_config.get(
            'long_running_operation_timeout',
            self.config.long_running_operation_timeout)
        return AzureOperationPoller(
            long_running_send, get_long_running_output,
            get_long_running_status, long_running_operation_timeout)
