/*
 * Created on 2004-2-16
 */
package org.cneclipse.bdcc;

import java.io.*;
import java.util.*;
import org.cneclipse.bdcc.ui.*;
import org.eclipse.swt.widgets.*;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.*;
import org.gudy.azureus2.plugins.download.*;
import org.jibble.lz.pircbot.*;

/**
 * @author Leon
 */
public class BDCCIrcClient extends PircBot {

	public static final String	VERSION_INFO		= "BitTorrent IRC Bot version 2.2";
	private DownloadManager		manager;
	private PluginConfig		config;
	private String				serverAddress;
	private int					serverPort;
	private String				nickName;
	//	private String altNickname;
	private String				channel;
	private String				channelPassword;
	private String				encoding;
	private IgnoreManager		ignoreManager;
	private BDCCAdminCommands	commands;
	private Date				starupTime;
	private DccChat				adminChat			= null;
	public static final int		USER_LEVEL_ADMIN	= 1;
	public static final int		USER_LEVEL_NORMAL	= 0;
	public static final int		USER_LEVEL_BANNED	= -1;
	private int					number;
	private PluginInterface		pluginInterface;
	private boolean				isQuit;
	private Text				text;

	/**
	 * @param pluginInterface
	 */
	public BDCCIrcClient(PluginInterface pluginInterface, int number) {
		this.number = number;
		ignoreManager = new IgnoreManager();
		manager = pluginInterface.getDownloadManager();
		config = pluginInterface.getPluginconfig();
		this.pluginInterface = pluginInterface;
		commands = new BDCCAdminCommands(this, pluginInterface);
		isQuit = false;
	}

	/**
	 *  
	 */
	public void connectToServer() {
		if (isQuit) { return; }
		serverAddress = config.getPluginStringParameter("BDCC IRC Server " + number, "");
		serverPort = config.getPluginIntParameter("BDCC IRC Server Port " + number, 6667);
		encoding = config.getPluginStringParameter("BDCC IRC Encoding", "");
		nickName = config.getPluginStringParameter("BDCC IRC Nickname " + number, "");
		channel = config.getPluginStringParameter("BDCC IRC Channel " + number, "");
		channelPassword = config.getPluginStringParameter("BDCC IRC Channel Password " + number, "");
		if (serverAddress.length() == 0 || nickName.length() == 0 || channel.length() == 0) {
			if (BDCCPlugin.bdccIsInited && text != null) {
				BDCCPluginView.getDisplay().asyncExec(new Runnable() {

					public void run() {
						if (text != null && !text.isDisposed()) {
							text.append("Missing necessary parameter when connect to irc server.\n");
						}
					}
				});
			}
			isQuit = true;
			return;
		}
		setName(nickName);
		setLogin("BTBOT");
		Thread t = new Thread() {

			/*
			 * @see java.lang.Thread#run()
			 */
			public void run() {
				try {
					if (encoding.length() > 0) setEncoding(encoding);
					connect(serverAddress, serverPort);
				} catch (Exception e) {
					e.printStackTrace();
					continueReconnect();
				}
			}
		};
		t.setDaemon(true);
		t.start();
	}

	/**
	 *  
	 */
	private void continueReconnect() {
		try {
			reconnect();
		} catch (Exception e) {
			disconnect();
			(new Timer()).schedule(new TimerTask() {

				public void run() {
					continueReconnect();
				}
			}, 30000);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onConnect()
	 */
	protected void onConnect() {
		rejoinChannels();
		if (starupTime == null) starupTime = new Date();
		sendTrigger();
		int adDelay = config.getPluginIntParameter("BDCC AD Delay", 0);
		if (config.getPluginBooleanParameter("BDCC Enable AD", false) && adDelay > 0) {
			(new Timer()).schedule(new TimerTask() {

				public void run() {
					sendTrigger();
				}
			}, adDelay * 60000);
		}
		if (BDCCPlugin.bdccIsInited && text != null) {
			BDCCPluginView.getDisplay().asyncExec(new Runnable() {

				public void run() {
					if (text != null && !text.isDisposed()) {
						text.append("Connected to server\n");
					}
				}
			});
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onDisconnect()
	 */
	protected void onDisconnect() {
		if (BDCCPlugin.bdccIsInited && text != null) {
			BDCCPluginView.getDisplay().asyncExec(new Runnable() {

				public void run() {
					if (text != null && !text.isDisposed()) {
						text.append("Disconnected from server\n");
					}
				}
			});
		}
		connectToServer();
	}

	/**
	 *  
	 */
	private void rejoinChannels() {
		StringTokenizer stc = new StringTokenizer(channel, ",");
		StringTokenizer stp = new StringTokenizer(channelPassword, ",");
		while (stc.hasMoreElements()) {
			String channelToJoin = (String) stc.nextElement();
			if (stp.hasMoreElements()) {
				String channelToJoinPass = (String) stp.nextElement();
				joinChannel(channelToJoin.trim(), channelToJoinPass.trim());
			} else {
				joinChannel(channelToJoin.trim());
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onServerResponse(int, java.lang.String)
	 */
	protected void onServerResponse(int code, String response) {
		super.onServerResponse(code, response);
		// Rejoin on banned
		if (code == ERR_BANNEDFROMCHAN) {
			if (BDCCPlugin.bdccIsInited && text != null) {
				BDCCPluginView.getDisplay().asyncExec(new Runnable() {

					public void run() {
						if (text != null && !text.isDisposed()) {
							text.append("Banned from channel\n");
						}
					}
				});
			}
			(new Timer()).schedule(new TimerTask() {

				public void run() {
					rejoinChannels();
				}
			}, 5000);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onKick(java.lang.String, java.lang.String, java.lang.String, java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	protected void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname,
			String recipientNick, String reason) {
		// On kicked rejoin.
		if (recipientNick.equalsIgnoreCase(getNick())) {
			rejoinChannels();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onVersion(java.lang.String, java.lang.String, java.lang.String,
	 *      java.lang.String)
	 */
	protected void onVersion(String sourceNick, String sourceLogin, String sourceHostname, String target) {
		super.onVersion(sourceNick, sourceLogin, sourceHostname, target);
		this.sendRawLine("NOTICE " + sourceNick + " :\u0001VERSION " + VERSION_INFO + " running on "
				+ Constants.AZUREUS_NAME + " " + Constants.AZUREUS_VERSION + "\u0001");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onMessage(java.lang.String, java.lang.String, java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	protected void onMessage(String channel, String sender, String login, String hostname, String message) {
		String[] incomingWords = BDCCHelper.splitWords(message);
		if (config.getPluginBooleanParameter("BDCC Response To list", true)) {
			if (incomingWords[0].equalsIgnoreCase("!LIST")) {
				if (incomingWords.length == 1 || incomingWords[2].equalsIgnoreCase(this.getName())) {
					sendTrigger(sender);
				}
			}
			if (message.toUpperCase().startsWith("!BT")) {
				sendTrigger(sender);
			}
		}
	}

	/**
	 * @param sender
	 */
	private void sendTrigger() {
		if (config.getPluginBooleanParameter("BDCC Enable AD", false)) {
			String[] triggerMessage = createTriggerMessage();
			for (int i = 0; i < triggerMessage.length; i++) {
				sendMessage(getChannel(), triggerMessage[i]);
			}
		}
	}

	/**
	 * @param sender
	 */
	private void sendTrigger(String sender) {
		String[] triggerMessage = createTriggerMessage();
		for (int i = 0; i < triggerMessage.length; i++) {
			sendNotice(sender, triggerMessage[i]);
		}
	}

	/**
	 * @return
	 */
	private String[] createTriggerMessage() {
		String[] result = new String[2];
		StringBuffer msg = new StringBuffer();
		msg.append(formatInfo("BDCC Active"));
		msg.append(" - Torrents:" + formatInfo("" + commands.getAllTorrents().length));
		msg.append(" - Seeding:" + formatInfo("" + commands.getSeedingTorrents().length));
		msg.append(" - Downloading:" + formatInfo("" + commands.getDownloadingTorrents().length));
		msg.append(" - Quering:" + formatInfo("" + commands.getQueuedTorrents().length));
		msg.append(" - Upload Speed:"
				+ formatInfo("" + DisplayFormatters.formatByteCountToKiBEtcPerSec(commands.getTotalUploadingSpeed())));
		msg.append(" - Download Speed:"
				+ formatInfo(DisplayFormatters.formatByteCountToKiBEtcPerSec(commands.getTotalDownloadingSpeed())));
		msg.append(" - Total Bytes Sent:"
				+ formatInfo(DisplayFormatters.formatByteCountToKiBEtc(commands.getTotalUploaded()
						+ BDCCPlugin.getUploaded())));
		msg.append(" - Total Bytes Get:"
				+ formatInfo(DisplayFormatters.formatByteCountToKiBEtc(commands.getTotalDownloaded()
						+ BDCCPlugin.getDownloaded())));
		msg.append(" - " + Constants.AZUREUS_NAME + " " + Constants.AZUREUS_VERSION);
		result[0] = msg.toString();
		msg = new StringBuffer();
		msg.append(config.getPluginStringParameter("BDCC Color 1", Colors.DARK_GREEN));
		if (config.getPluginBooleanParameter("BDCC Send Torrent", true)) {
			msg.append("Message:" + formatInfo(config.getPluginStringParameter("BDCC AD Headline", "")));
			msg.append(" - List Trigger:" + formatInfo("/MSG " + getNick() + " BT LIST"));
			msg.append(" - Get Trigger:" + formatInfo("/MSG " + getNick() + " BT GET #x"));
			msg.append(" - Info Trigger:" + formatInfo("/MSG " + getNick() + " BT INFO #x"));
			msg.append(" - " + config.getPluginStringParameter("BDCC AD Creditline", ""));
			msg.append(" - " + VERSION_INFO);
		} else {
			msg.append("Message:" + formatInfo(config.getPluginStringParameter("BDCC AD Headline", "")));
			msg.append(" - Get Trigger:" + formatInfo("/MSG " + getNick() + " BT GET #x"));
			msg.append(" - Info Trigger:" + formatInfo("/MSG " + getNick() + " BT INFO #x"));
			msg.append(" - " + config.getPluginStringParameter("BDCC AD Creditline", ""));
			msg.append(" - " + VERSION_INFO);
		}
		result[1] = msg.toString();
		return result;
	}

	/**
	 * @param string
	 * @return
	 */
	private String formatInfo(String string) {
		return config.getPluginStringParameter("BDCC Color 1", Colors.DARK_GREEN) + "["
				+ config.getPluginStringParameter("BDCC Color 2", Colors.BLUE) + string
				+ config.getPluginStringParameter("BDCC Color 1", Colors.DARK_GREEN) + "]";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onPrivateMessage(java.lang.String, java.lang.String, java.lang.String,
	 *      java.lang.String)
	 */
	protected void onPrivateMessage(String sender, String login, String hostname, String message) {
		String[] incomingWords = BDCCHelper.splitWords(message);
		if (incomingWords[0].equalsIgnoreCase("BT") && incomingWords.length > 1) {
			try {
				if (incomingWords[1].equalsIgnoreCase("list")) {
					sendTorrentsList(sender);
				} else if (incomingWords[1].equalsIgnoreCase("GET")) {
					if (incomingWords.length > 2 && config.getPluginBooleanParameter("BDCC Send Torrent", true)) {
						String torrentNo = incomingWords[2];
						int btNo = -1;
						try {
							btNo = Integer.parseInt(torrentNo.substring(1));
						} catch (Exception e) {
							// Error in usage.
						}
						if (btNo > -1 && torrentNo.startsWith("#")) {
							sendTorrentFile(sender, btNo);
						}
					}
				} else if (incomingWords[1].equalsIgnoreCase("INFO")) {
					if (incomingWords.length > 2) {
						String torrentNo = incomingWords[2];
						int btNo = -1;
						try {
							btNo = Integer.parseInt(torrentNo.substring(1));
						} catch (Exception e) {
							// Error in usage.
						}
						if (btNo > -1 && torrentNo.startsWith("#")) {
							sendTorrentInfo(sender, btNo);
						}
					}
				}
			} catch (Exception e) {
				sendNotice(sender, "Error: " + e.getMessage());
			}
		} else if (incomingWords[0].equalsIgnoreCase("admin")) {
			if (incomingWords.length < 3) { return; }
			IrcUser user = new IrcUser(sender, login, hostname);
			if (isAdmin(user)) {
				String adminpass = config.getPluginStringParameter("BDCC Admin Password", "");
				String password = incomingWords[1];
				if (password.equals(adminpass)) {
					try {
						String command = incomingWords[2];
						if (command.equalsIgnoreCase("chatme")) {
							DccChat chat = dccSendChatRequest(sender, 120000);
							handleAdminChat(chat);
						} else if (command.equalsIgnoreCase("ADD")) {
							if (incomingWords.length < 4) {
								sendNotice(sender, "Error: Please input more parameter!");
							}
							String filename = incomingWords[3];
							int position = commands.add(filename);
							if (position < 0) sendNotice(sender, "Error: Torrent file dose not exist");
							else sendNotice(sender, "--> Download added to #" + position);
						} else if (command.equalsIgnoreCase("ADDURL")) {
							if (incomingWords.length < 4) {
								sendNotice(sender, "Error: Please input more parameter!");
							}
							String url = incomingWords[3];
							int position = commands.addUrl(url);
							sendNotice(sender, "--> Download added to #" + position);
						} else if (command.equalsIgnoreCase("QUEUE")) {
							int n = 0;
							try {
								n = Integer.parseInt(incomingWords[3]);
							} catch (RuntimeException e) {
								sendNoPackageError(sender);
							}
							String name = commands.queueTorrent(n);
							sendNotice(sender, "--> Download #" + n + " " + name + " is in the queue.");
						} else if (command.equalsIgnoreCase("START")) {
							int n = 0;
							try {
								n = Integer.parseInt(incomingWords[3]);
							} catch (RuntimeException e) {
								sendNoPackageError(sender);
							}
							String name = commands.startTorrent(n);
							sendNotice(sender, "--> Download #" + n + " " + name + " is started.");
						} else if (command.equalsIgnoreCase("STOP")) {
							int n = 0;
							try {
								n = Integer.parseInt(incomingWords[3]);
							} catch (RuntimeException e) {
								sendNoPackageError(sender);
							}
							String name = commands.stopTorrent(n);
							sendNotice(sender, "--> Download #" + n + " " + name + " is stopped.");
						} else if (command.equalsIgnoreCase("REMOVE")) {
							int n = 0;
							try {
								n = Integer.parseInt(incomingWords[3]);
							} catch (RuntimeException e) {
								sendNoPackageError(sender);
							}
							String name = commands.removeTorrent(n);
							sendNotice(sender, "--> Download #" + n + " " + name + " is removed.");
						} else if (command.equalsIgnoreCase("HOST")) {
							int n = 0;
							try {
								n = Integer.parseInt(incomingWords[1]);
							} catch (RuntimeException e) {
								sendNoPackageError(sender);
							}
							String name = commands.hostTorrent(n);
							sendNotice(sender, "--> Download #" + n + " " + name + " is hosted.");
						}
					} catch (Exception e) {
						sendNotice(sender, "--> Error: " + e);
					}
				}
			} else {
				sendNotice(sender, "Host " + user + " is NOT allowed to perform a admin chat with me.");
			}
		}
	}

	/**
	 *  
	 */
	private void sendNoPackageError(String sender) {
		sendNotice(sender, "--> Package dose not exists.");
	}

	/**
	 * @param sender
	 * @param btNo
	 */
	private void sendTorrentInfo(final String sender, final int n) {
		String[] info = commands.getTorrentInfo(n);
		if (info == null) {
			sendNoPackageError(sender);
			return;
		}
		if (adminChat != null) {
			try {
				adminChat.sendLine("--> " + sender + " requesting info about #" + n + ".");
			} catch (IOException e) {
			}
		}
		if (BDCCPlugin.bdccIsInited && text != null) {
			BDCCPluginView.getDisplay().asyncExec(new Runnable() {

				public void run() {
					if (text != null && !text.isDisposed()) {
						text.append("--> " + sender + " requesting info about #" + n + ".");
					}
				}
			});
		}
		for (int i = 0; i < info.length; i++) {
			sendNotice(sender, "--> " + info[i]);
		}
		if (config.getPluginBooleanParameter("BDCC Send Torrent", true)) {
			sendNotice(sender, "--> Use \"/msg " + getNick() + " bt get #" + n + "\" to get the torrent file.");
		}
	}

	/**
	 * @param sender
	 * @param i
	 */
	private void sendTorrentFile(final String sender, final int n) {
		try {
			final String name = commands.sendTorrent(sender, n);
			if (name == null) {
				sendNotice(sender, "--> Torrent #" + n + " dose not exist.");
			} else {
				sendNotice(sender, "--> Torrent #" + n + " " + name + " is sending.");
				if (adminChat != null) {
					adminChat.sendLine("--> " + sender + " requesting torrent #" + n + " " + name + ".");
				}
				if (BDCCPlugin.bdccIsInited && text != null) {
					BDCCPluginView.getDisplay().asyncExec(new Runnable() {

						public void run() {
							if (text != null && !text.isDisposed()) {
								text.append("Sending Torrent #" + n + " " + name + " to " + sender + "\n");
							}
						}
					});
				}
			}
		} catch (Exception e) {
			sendNotice(sender, "--> Error: " + e);
		}
	}

	/**
	 * @param sender
	 */
	private void sendTorrentsList(final String sender) {
		if (adminChat != null) {
			try {
				adminChat.sendLine("--> " + sender + " requesting torrent list.");
			} catch (IOException e) {
			}
		}
		String[] list = commands.getAllTorrents();
		sendNotice(sender, "--> ** " + config.getPluginStringParameter("BDCC AD Headline", ""));
		sendNotice(sender, "--> " + commands.getStatusLines());
		for (int i = 0; i < list.length; i++) {
			sendNotice(sender, "--> " + list[i]);
		}
		if (adminChat != null) {
			try {
				adminChat.sendLine("--> Sending Torrent list to " + sender);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		if (BDCCPlugin.bdccIsInited && text != null) {
			BDCCPluginView.getDisplay().asyncExec(new Runnable() {

				public void run() {
					if (text != null && !text.isDisposed()) {
						text.append("Sending Torrent list to " + sender + "\n");
					}
				}
			});
		}
		sendNotice(sender, "--> ** " + config.getPluginStringParameter("BDCC AD Creditline", ""));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onIncomingChatRequest(org.jibble.lz.pircbot.DccChat)
	 */
	protected void onIncomingChatRequest(DccChat chat) {
		IrcUser user = new IrcUser(chat.getNick(), chat.getLogin(), chat.getHostname());
		if (ignoreManager.isIgnored(user)) { return; }
		if (isAdmin(user)) {
			String adminpass = config.getPluginStringParameter("BDCC Admin Password", "");
			handleAdminChat(chat);
		} else {
			sendNotice(nickName, "Host " + user + " is NOT allowed to perform a admin chat with me.");
		}
	}

	/**
	 * @param chat
	 */
	private void handleAdminChat(final DccChat chat) {
		if (!config.getPluginBooleanParameter("BDCC Enable Admin", false)) return;
		final String adminpass = config.getPluginStringParameter("BDCC Admin Password", "");
		if (BDCCPlugin.bdccIsInited && text != null) {
			BDCCPluginView.getDisplay().asyncExec(new Runnable() {

				public void run() {
					if (text != null && !text.isDisposed()) {
						text.append(chat.getNick() + " requesting an admin chat session.\n");
					}
				}
			});
		}
		Thread t = new Thread() {

			/*
			 * @see java.lang.Thread#run()
			 */
			public void run() {
				try {
					try {
						chat.accept();
						chat.sendLine("Welcome to " + getNick());
						chat.sendLine(BDCCIrcClient.VERSION_INFO + " on " + Constants.AZUREUS_NAME + " "
								+ Constants.AZUREUS_VERSION);
						chat.sendLine("   running " + getRunningTime());
						chat.sendLine(" ");
						chat.sendLine("Enter Your Password:");
						String password = chat.readLine();
						if (password.equals(adminpass)) {
							try {
								if (adminChat != null) {
									adminChat.sendLine("Another admin chat accepted from " + chat.getNick());
									adminChat.close();
								}
							} catch (Exception e) {
							}
							adminChat = chat;
							chat.sendLine(" ");
							chat.sendLine(" *** Entering DCC Chat Admin Interface");
							chat.sendLine(" *** For Help type \"help\"");
							chat.sendLine(" ");
							if (BDCCPlugin.bdccIsInited && text != null) {
								BDCCPluginView.getDisplay().asyncExec(new Runnable() {

									public void run() {
										if (text != null && !text.isDisposed()) {
											text.append(chat.getNick()
													+ " is allowed to perform an admin chat session.\n");
										}
									}
								});
							}
							new BDCCAdminChat(commands, chat, config);
						} else {
							chat.close();
						}
					} catch (IOException e) {
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		};
		t.setDaemon(true);
		t.start();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jibble.lz.pircbot.PircBot#onFileTransferFinished(org.jibble.lz.pircbot.DccFileTransfer,
	 *      java.lang.Exception)
	 */
	protected void onFileTransferFinished(DccFileTransfer transfer, Exception e) {
		if (e != null) {
			sendNotice(transfer.getNick(), "-== Transfer failed: " + e.getMessage() + " ==-");
			return;
		}
		if (transfer.isOutgoing()) {
			transfer.getFile().delete();
		}
	}

	/**
	 * @return
	 */
	public String getRunningTime() {
		if (starupTime == null) return "";
		return BDCCHelper.formatTime(((new Date()).getTime() - this.starupTime.getTime()) / 1000);
	}

	/**
	 * @param user
	 * @return
	 */
	private boolean isAdmin(IrcUser user) {
		String adminhost = config.getPluginStringParameter("BDCC Admin Host Mask", "*!*@*");
		WildcardMatch wm = new WildcardMatch();
		if (wm.match(user.toString().toLowerCase(), adminhost.toLowerCase())) return true;
		return false;
	}

	/**
	 * @return Returns the channel.
	 */
	public String getChannel() {
		return channel;
	}

	/**
	 * @param isQuit
	 *            The isQuit to set.
	 */
	public void setQuit(boolean isQuit) {
		this.isQuit = isQuit;
	}

	public void setStatusListener(final Text text) {
		this.text = text;
		if (BDCCPlugin.bdccIsInited) {
			BDCCPluginView.getDisplay().asyncExec(new Runnable() {

				public void run() {
					if (text != null && !text.isDisposed()) {
						if (isConnected()) text.append("Connected\n");
						else text.append("Disconnected\n");
					}
				}
			});
		}
	}
}