/**
 * Copyright (C) 2012 by INdT
 * Copyright (C) 2014 Bacon2D Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @author Rodrigo Goncalves de Oliveira <rodrigo.goncalves@openbossa.org>
 * @author Roger Felipe Zanoni da Silva <roger.zanoni@openbossa.org>
 */

#ifndef _BEHAVIOR_H_
#define _BEHAVIOR_H_

#include <QtCore/QObject>

class Entity;

class Behavior : public QObject
{
    Q_OBJECT

    Q_PROPERTY(Entity *entity READ entity)
    Q_PROPERTY(int delta READ delta)

public:
    Behavior(QObject *parent = 0);

    Entity *entity() const;
    void setEntity(Entity *entity);

    void setDelta(int delta);
    int delta() const;

    virtual void update(const int &delta) { Q_UNUSED(delta);  }

private:
    Entity *m_entity;
    int m_delta;
};

#endif /* _BEHAVIOR_H_ */
