//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_10.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot10(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[10] = {6.019206314958798e-02,5.438675002946463e-01,1.522944105404443e+00,3.022513376451572e+00,5.084907750098527e+00,
    7.777439231525445e+00,1.120813020434867e+01,1.556116333218935e+01,2.119389209630153e+01,2.902495034023622e+01};
  constexpr double aw[10] = {4.622436696006099e-01,2.866755053628348e-01,1.090172060200231e-01,2.481052088746362e-02,3.243773342237849e-03,
    2.283386360163547e-04,7.802556478532124e-06,1.086069370769281e-07,4.399340992273179e-10,2.229393645534142e-13};
  constexpr double x[3840] = {  1.117385932489869e-02, -2.646305914233087e-04,  4.674253484103585e-06, -7.286013822367724e-08,  1.054622561867043e-09,
 -1.448499439613784e-11,  1.906334634578126e-13, -2.414645107190344e-15,  2.944572258899868e-17, -3.448320369367669e-19,  3.850746241593759e-21, -4.047000013499268e-23,
  9.919921792121178e-02, -2.249966504965895e-03,  3.633081582117316e-05, -4.823525755147673e-07,  5.302107710432267e-09, -4.409866476747967e-11,  1.525301300038303e-13,
  3.585026809558283e-15, -1.030304163273396e-16,  1.666357113281941e-18, -1.916225725833902e-20,  1.317232803425318e-22,  2.680412851579292e-01, -5.561473348664786e-03,
  7.350196291997001e-05, -6.220901071423950e-07,  8.423271260424795e-10,  7.848188860762296e-11, -1.511747422153693e-12,  1.299011630036181e-14,  5.029727408611577e-17,
 -3.536080563561655e-18,  5.665525863753406e-20, -3.358534508792065e-22,  5.036476118354057e-01, -9.078898671643215e-03,  8.238733839987035e-05, -1.296973879169425e-08,
 -1.108310158028148e-08,  1.326118984366043e-10,  4.229230919737166e-13, -3.186255594212851e-14,  3.213388523979841e-16,  2.832965230426219e-18, -1.114943729409729e-19,
  8.359694104348582e-22,  7.858919753011775e-01, -1.157256169131792e-02,  4.665443280583508e-05,  9.077485362896229e-07, -1.136068668748689e-08, -9.748544185890145e-11,
  2.777798964097813e-12,  4.612147074879488e-15, -6.535494549010274e-16,  2.862380730392215e-18,  1.418594691865344e-19, -1.601918007275976e-21,  1.089821610896933e+00,
 -1.211988443002240e-02, -1.820573611119463e-05,  1.174373401795528e-06,  4.630732383847700e-09, -2.020659131400055e-10, -1.289832806713838e-12,  4.160508924578187e-14,
  3.739946078515246e-16, -9.335068209303869e-18, -1.111777082039969e-19,  2.185662397417753e-21,  1.387461212036418e+00, -1.046064609890379e-02, -7.352583949223325e-05,
  4.482684820717837e-07,  1.444198981570887e-08,  4.866275310703924e-11, -2.408570205385555e-12, -3.312997292539204e-14,  2.267859850619428e-16,  1.007150702474587e-17,
  4.432283821800106e-20, -2.100529429164767e-21,  1.650210743577135e+00, -7.151606753943949e-03, -8.581609049045827e-05, -4.850052771792903e-07,  4.780680463817605e-09,
  1.524646324019471e-10,  1.503453549178403e-12, -6.408777665704611e-15, -4.263828223861159e-16, -5.736418658362447e-18,  5.816191857635100e-22,  1.370306994938576e-21,
  1.851753896059726e+00, -3.418529952180380e-03, -5.426187152798884e-05, -6.663176600521248e-07, -5.866345465396105e-09, -1.746969139255282e-11,  6.115558461970162e-13,
  1.596816126357275e-14,  2.271769909059677e-16,  1.806593519779410e-18, -6.487297307436305e-21, -5.265842533279878e-22,  1.971216789087024e+00, -7.087130545354101e-04,
 -1.289446756040645e-05, -2.043031591997974e-07, -2.953350463496227e-09, -3.953799190711689e-11, -4.900653924500524e-13, -5.544320222393278e-15, -5.505429683676355e-17,
 -4.268137231056423e-19, -1.209697596098818e-21,  4.305043843011112e-23,  1.018496549556585e-02, -2.304675018190221e-04,  3.892362231737817e-06, -5.807639921009207e-08,
  8.057035063206644e-10, -1.062512446233844e-11,  1.345421411665205e-13, -1.644454733066806e-15,  1.942107018266957e-17, -2.214750864395170e-19,  2.426798592453540e-21,
 -2.536874889226100e-23,  9.074593559909834e-02, -1.981096321925444e-03,  3.102320499074355e-05, -4.043476523108309e-07,  4.463163928303010e-09, -3.955550429528091e-11,
  2.147837498923712e-13,  1.111497472226296e-15, -5.541395966984103e-17,  1.017921068489533e-18, -1.331209141942199e-20,  1.256253522509740e-22,  2.469246096786167e-01,
 -5.002981750049836e-03,  6.616350025030588e-05, -5.979015105495574e-07,  2.079102348379093e-09,  4.664373023046422e-11, -1.141695935535686e-12,  1.296768607459299e-14,
 -4.029283131726451e-17, -1.617592424632412e-18,  3.859377342132478e-20, -4.332133992523061e-22,  4.686452414884775e-01, -8.423233380182527e-03,  8.125625763143533e-05,
 -1.688114749453420e-07, -8.395327026169813e-09,  1.332836363104869e-10, -3.156053290118209e-13, -2.072663881888919e-14,  3.533689351124518e-16, -7.443604616532616e-19,
 -6.533300817016021e-20,  1.123635732654707e-21,  7.404126601962593e-01, -1.115896899962531e-02,  5.640420335209663e-05,  7.140050931502769e-07, -1.264494233499069e-08,
 -3.150121032594689e-11,  2.636559674739865e-12, -1.371313558159226e-14, -4.679206938786679e-16,  6.866330584873119e-18,  5.458860482886684e-20, -2.120355850073776e-21,
  1.041141395771769e+00, -1.220821685346346e-02, -3.806385146470492e-06,  1.214868804896106e-06,  3.797906973386955e-10, -2.180263188982693e-10, -1.277222873568021e-14,
  4.754946144297585e-14, -1.546663792547469e-17, -1.150130161273925e-17,  8.586617585413587e-21,  2.959887814738924e-21,  1.344481898333340e+00, -1.102335563525315e-02,
 -6.673905979599532e-05,  6.836893123968308e-07,  1.476773780691587e-08, -1.911224814802908e-11, -3.178836268623985e-12, -1.993559942249009e-14,  5.952254847267249e-16,
  9.596882082504763e-18, -7.580282056148004e-20, -3.139827250096724e-21,  1.620196555564529e+00, -7.859871326569458e-03, -9.107047000868625e-05, -3.822507119814331e-07,
  8.167499966949577e-09,  1.846650069430882e-10,  1.102757543646985e-12, -2.321450432776619e-14, -6.148641837816323e-16, -4.170361865902839e-18,  8.576594543982785e-20,
  2.457338278897612e-21,  1.837158665999656e+00, -3.886224373545108e-03, -6.282934683100195e-05, -7.620093312160850e-07, -6.028260260052358e-09,  3.451425794077290e-12,
  1.169549279309788e-12,  2.417311035954294e-14,  2.804248235244487e-16,  9.105505791967624e-19, -4.318179727371572e-20, -1.194197955501203e-21,  1.968158879459563e+00,
 -8.225431848010556e-04, -1.565794546875831e-05, -2.585784383578745e-07, -3.875390470537826e-09, -5.337594602232715e-11, -6.723195253479769e-13, -7.556246886272940e-15,
 -7.063140559508321e-17, -4.139088149184764e-19,  2.588935017801379e-21,  1.450715413024255e-22,  9.321248921866206e-03, -2.019122030225045e-04,  3.266308774220186e-06,
 -4.672419999903165e-08,  6.220954619557741e-10, -7.885171023746727e-12,  9.612131360866485e-14, -1.133804421879850e-15,  1.295538140253650e-17, -1.435964202323059e-19,
  1.536211100462222e-21, -1.585356537829823e-23,  8.328882809583438e-02, -1.751163654146240e-03,  2.657431862532251e-05, -3.389784560699054e-07,  3.725218381803000e-09,
 -3.419716395521242e-11,  2.259165846685714e-13, -1.679087703210671e-16, -2.710222176371622e-17,  5.869481588266338e-19, -8.477621352682916e-21,  9.291622134327596e-23,
  2.279267385649642e-01, -4.501745678528687e-03,  5.921456798629607e-05, -5.585414082654895e-07,  2.766435189391020e-09,  2.341041183566033e-11, -8.034928384538381e-13,
  1.100835467494910e-14, -7.515292984507201e-17, -4.337231944438422e-19,  2.131619580230591e-20, -3.373469075195362e-22,  4.362366172592444e-01, -7.783370769409647e-03,
  7.851071780572255e-05, -2.823976792277772e-07, -5.845967014734738e-09,  1.199822889986714e-10, -7.447207908357987e-13, -1.025837681739835e-14,  2.909364900019835e-16,
 -2.430628605036534e-18, -2.117068995305247e-20,  8.305095007839010e-22,  6.967286242644721e-01, -1.067692885880925e-02,  6.374827266443248e-05,  5.099259437517404e-07,
 -1.268102824924487e-08,  2.571567230403883e-11,  2.082103638214263e-12, -2.448574695126354e-14, -2.027788574595342e-16,  7.322170066069357e-18, -2.675265441044553e-20,
 -1.442858321271903e-21,  9.923396677190011e-01, -1.218058021067161e-02,  1.066577298053728e-05,  1.186491427535495e-06, -3.877842802907424e-09, -2.027862063297598e-10,
  1.251345906556277e-12,  4.074182518558353e-14, -3.934634599146978e-16, -8.745300681257621e-18,  1.213431302676974e-19,  1.895352156193569e-21,  1.299378208863131e+00,
 -1.152049095519214e-02, -5.714354364640547e-05,  9.126227210511089e-07,  1.358973870291472e-08, -9.965871078348433e-11, -3.424163734056273e-12,  3.786331540888758e-15,
  8.533863658453798e-16,  3.894292555045877e-18, -2.028519146836915e-19, -2.247666088819218e-21,  1.587274408303940e+00, -8.604272792465140e-03, -9.474756507827700e-05,
 -2.208488193511007e-07,  1.206083592723254e-08,  2.009981796319461e-10,  1.607268150685865e-13, -4.440716806768118e-14, -6.755517500561729e-16,  1.581773286123669e-18,
  2.029559419004842e-19,  2.583586272016499e-21,  1.820548292275451e+00, -4.427058910752181e-03, -7.254428039674715e-05, -8.561355547828979e-07, -5.618398605381271e-09,
  4.067233747337241e-11,  1.973908491162769e-12,  3.321990129110578e-14,  2.671345003812799e-16, -2.123824505378769e-18, -1.150482194440686e-19, -2.078295151021376e-21,
  1.964596924882875e+00, -9.613598235137887e-04, -1.917120019615379e-05, -3.300782388618206e-07, -5.122778265873007e-09, -7.231860366290286e-11, -9.175470101010413e-13,
 -1.001915982337328e-14, -8.162334174714157e-17, -1.244659618587486e-19,  1.367259887613087e-20,  3.933119433151586e-22,  8.562534058044689e-03, -1.778665059487793e-04,
  2.760513752948356e-06, -3.791696603321921e-08,  4.851129709689852e-10, -5.916755230475544e-12,  6.947890525854587e-14, -7.913281509531618e-16,  8.741936240054084e-18,
 -9.415871359968825e-20,  9.783028203470320e-22, -9.979472179474248e-24,  7.668496456105889e-02, -1.553876891653469e-03,  2.284257415067370e-05, -2.845550460585347e-07,
  3.094682714742490e-09, -2.891221362882234e-11,  2.118266712757256e-13, -7.551454694309755e-16, -1.118112881516040e-17,  3.197527410012670e-19, -5.115739265829012e-21,
  6.093546436015801e-23,  2.108258410525053e-01, -4.054057375267198e-03,  5.278998006618629e-05, -5.114807560344054e-07,  3.065325647098802e-09,  7.544417452385144e-12,
 -5.302583606671761e-13,  8.491460666403215e-15, -7.864721961239444e-17,  1.603697023373209e-19,  9.322806201528223e-21, -2.099392419929938e-22,  4.063358305843189e-01,
 -7.170254566507914e-03,  7.463655180314855e-05, -3.577869134274800e-07, -3.643242281907161e-09,  9.962913736197145e-11, -9.155585129502627e-13, -2.447931561158232e-15,
  1.958524108780617e-16, -2.672458504375142e-18,  5.983951766971773e-21,  4.091449695876179e-22,  6.550748383406778e-01, -1.014585994479004e-02,  6.867511036596416e-05,
  3.136157908010707e-07, -1.172533538450060e-08,  6.695914329960429e-11,  1.343183566129041e-12, -2.706947976731347e-14,  2.905262512915800e-17,  5.290056614689324e-18,
 -6.723330397602303e-20, -4.078546710334825e-22,  9.438762926819779e-01, -1.203965303538084e-02,  2.440383473402998e-05,  1.093990801001006e-06, -7.549295756497217e-09,
 -1.607414062582040e-10,  2.175973995088820e-12,  2.417973557026876e-14, -6.060228523137396e-16, -2.800441689097135e-18,  1.610099000367904e-19, -1.229863966467119e-22,
  1.252456290362912e+00, -1.193031708715257e-02, -4.496745990961284e-05,  1.109740677164760e-06,  1.079963324618262e-08, -1.774110627304716e-10, -2.926833012476645e-12,
  3.162091322612511e-14,  8.303166403503990e-16, -5.446392595725482e-18, -2.427825610490655e-19,  6.562735592663273e-22,  1.551329604692517e+00, -9.369268903350499e-03,
 -9.610783121042180e-05,  4.028411896657927e-09,  1.600647765408672e-08,  1.876057511986504e-10, -1.364414164525843e-12, -6.334845007044035e-14, -4.489595997880483e-16,
  1.150662460037049e-17,  2.764258697412026e-19,  2.619289565159396e-22,  1.801612228945271e+00, -5.049955683584873e-03, -8.332118850976871e-05, -9.366160029284005e-07,
 -4.251309312901345e-09,  1.000669064594816e-10,  3.004813976720439e-12,  3.946476696034152e-14,  8.388061414136246e-17, -8.753616094458129e-18, -2.196060644151674e-19,
 -2.483314341895562e-21,  1.960417537971026e+00, -1.132084769134905e-03, -2.367580520106066e-05, -4.249108499454074e-07, -6.813611190682166e-09, -9.800071367688387e-11,
 -1.234339546002710e-12, -1.255589230618027e-14, -7.091647911041221e-17,  9.027814729537859e-19,  4.173338840521048e-20,  9.529592525249526e-22,  7.892529689552110e-03,
 -1.574788996325726e-04,  2.348450128744141e-06, -3.101824119059054e-08,  3.818090685401785e-10, -4.486418879899205e-12,  5.077775464405262e-14, -5.590542676103862e-16,
  5.961834227976265e-18, -6.262046204952428e-20,  6.248186966529092e-22, -6.362318409902775e-24,  7.081444462953020e-02, -1.383995377141567e-03,  1.970679471069179e-05,
 -2.393976478864215e-07,  2.565395605543038e-09, -2.411318809308344e-11,  1.871504119184015e-13, -9.634873646423016e-16, -2.778593232614427e-18,  1.610338184542435e-19,
 -2.994551968047827e-21,  3.703378637582598e-23,  1.954165657051583e-01, -3.655447486419969e-03,  4.694943051699517e-05, -4.618440832800632e-07,  3.106771536794967e-09,
 -2.605543986691168e-12, -3.264453612750508e-13,  6.122977552015773e-15, -6.809393822214550e-17,  3.802748064042256e-19,  2.391553330490826e-21, -1.111628545473421e-22,
  3.788205961385899e-01, -6.591183273990985e-03,  7.005521005068974e-05, -4.013436953417068e-07, -1.872654157875176e-09,  7.745493698642624e-11, -9.103205733808925e-13,
  2.354999166058141e-15,  1.073267581029912e-16, -2.176811994068642e-18,  1.650784543421343e-20,  9.541174489758721e-23,  6.156096795769216e-01, -9.584482902255706e-03,
  7.136203926013476e-05,  1.382216539817115e-07, -1.012396191633846e-08,  9.036209091965238e-11,  6.230564530199429e-13, -2.363140737843419e-14,  1.690762198409402e-16,
  2.489571137060152e-18, -6.749417543619590e-20,  3.175070213655730e-22,  8.961880885633176e-01, -1.179418911971047e-02,  3.671062626037770e-05,  9.505109168003893e-07,
 -1.019861191951380e-08, -1.026346038107372e-10,  2.574991803172473e-12,  4.373892660879581e-15, -5.970772949965622e-16,  3.011598208345908e-18,  1.185751321045886e-19,
 -1.622792064169492e-21,  1.204103645311044e+00, -1.223414447074056e-02, -3.074231503583279e-05,  1.250684537284031e-06,  6.635200109755539e-09, -2.342736925569999e-10,
 -1.711687461872533e-12,  5.329480466238379e-14,  4.752663675893249e-16, -1.361906192601238e-17, -1.439627673546245e-19,  3.618368182524047e-21,  1.512321614058104e+00,
 -1.013331391931783e-02, -9.440651783132242e-05,  2.877431400506588e-07,  1.928096877245079e-08,  1.324095380150753e-10, -3.262052659164324e-12, -6.900632927556875e-14,
  1.554021561874811e-16,  2.148099878912860e-17,  1.863147381975467e-19, -4.622214024777615e-21,  1.780006686760521e+00, -5.762459684928648e-03, -9.488893946873027e-05,
 -9.843311726346477e-07, -1.439214970911658e-09,  1.853890562945424e-10,  4.086770245422318e-12,  3.521188127972544e-14, -4.132994699432880e-16, -1.941464652481634e-17,
 -2.997561345275180e-19, -5.566462385581600e-22,  1.955475266049824e+00, -1.343900262640477e-03, -2.949907300455386e-05, -5.513419519388769e-07, -9.099492249225780e-09,
 -1.320562093719253e-10, -1.609939814373828e-12, -1.388501842368860e-14,  4.227711185366775e-18,  3.694074430016201e-18,  1.061241011918643e-19,  2.096530615053354e-21,
  7.297970042104780e-03, -1.400827362163690e-04,  2.010124690369244e-06, -2.556586835084927e-08,  3.031025794919305e-10, -3.435960222394993e-12,  3.748769148726977e-14,
 -4.000207691710553e-16,  4.097170758302888e-18, -4.243681737861843e-20,  4.029557679574240e-22, -3.788698230048872e-24,  6.557651634530261e-02, -1.237169431514762e-03,
  1.706515137045403e-05, -2.019746762463056e-07,  2.125830785232909e-09, -1.995075399698288e-11,  1.596516172278566e-13, -9.798770559498134e-16,  1.210695364337210e-18,
  6.912183072217988e-20, -1.695159069808525e-21,  2.419333722060731e-23,  1.815120511244792e-01, -3.301181970512894e-03,  4.170260199113377e-05, -4.129242828852376e-07,
  2.988983536114173e-09, -8.616042140625307e-12, -1.833671641591644e-13,  4.173248131651846e-15, -5.365860261019001e-17,  4.000179838859241e-19, -8.985969685611739e-22,
 -4.121585431146452e-23,  3.535456708540004e-01, -6.050405297041924e-03,  6.510666210693740e-05, -4.200719095677793e-07, -5.349757144920409e-10,  5.671889929586858e-11,
 -8.071406657993140e-13,  4.667727308064129e-15,  4.133547088732486e-17, -1.487558901374097e-18,  1.690613607633906e-20, -4.864324279007884e-23,  5.784203442702748e-01,
 -9.009564106611115e-03,  7.211048327018495e-05, -8.704424150005307e-09, -8.217336731756464e-09,  9.805166921915651e-11,  4.707575310724077e-14, -1.727362160593076e-14,
  2.145137244620355e-16,  1.777558023434226e-19, -4.612877335400664e-20,  5.919652255225818e-22,  8.496668465385123e-01, -1.145778774299976e-02,  4.708085210483229e-05,
  7.742737500848332e-07, -1.163401167083177e-08, -4.139498248185605e-11,  2.451928136838013e-12, -1.223349238243817e-14, -4.221007982822638e-16,  6.169665960180875e-18,
  3.791402468767776e-20, -1.821207348413682e-21,  1.154772305773546e+00, -1.241861333291665e-02, -1.525752477418993e-05,  1.317664066343170e-06,  1.666635036234173e-09,
 -2.562130640985274e-10, -8.619499436585865e-14,  5.988720313749638e-14, -7.621755717953841e-17, -1.578561230012322e-17,  4.047053894748185e-20,  4.279097788762844e-21,
  1.470307353113057e+00, -1.086933952869714e-02, -8.903076559753550e-05,  6.125331858817263e-07,  2.099584749320392e-08,  3.225051640892949e-11, -5.000849378108020e-12,
 -5.070968974954939e-14,  1.000385793361660e-15,  2.342523140884431e-17, -1.191868242264273e-19, -8.649378998920543e-21,  1.755363680158159e+00, -6.568892625142290e-03,
 -1.066986273664234e-04, -9.720679675467754e-07,  3.318486630914978e-09,  2.930800575136701e-10,  4.766115054881168e-12,  8.528704269109027e-15, -1.320200900460829e-15,
 -3.030254271286274e-17, -1.947351843111063e-19,  6.304939503628431e-21,  1.949582001024581e+00, -1.609047335795373e-03, -3.708304159456341e-05, -7.202921930690524e-07,
 -1.215777012954690e-08, -1.751876642625483e-10, -1.969802684052294e-12, -1.059235971120972e-14,  2.404737563945512e-16,  1.030370726618559e-17,  2.387836252056185e-19,
  4.072666008829970e-21,  6.767967970251376e-03, -1.251513794201052e-04,  1.730312931000616e-06, -2.122065546173684e-08,  2.425441330422805e-10, -2.657154886694831e-12,
  2.791348389612645e-14, -2.905253538170806e-16,  2.826254120083324e-18, -2.889271500111933e-20,  2.939813818501185e-22, -1.075958997979239e-24,  6.088630895130545e-02,
 -1.109793797518603e-03,  1.483301663846647e-05, -1.709545430274009e-07,  1.762940573207629e-09, -1.644209423818842e-11,  1.330500022779431e-13, -9.123789107967649e-16,
  2.728278170241226e-18,  2.208426303760248e-20, -6.406606457779967e-22,  2.635360338034567e-23,  1.689443113993299e-01, -2.986582982861431e-03,  3.702809240234160e-05,
 -3.666818179083042e-07,  2.781172068355927e-09, -1.179568092553192e-11, -8.845479504742064e-14,  2.677236784804222e-15, -4.016835421196971e-17,  3.469753724880239e-19,
 -1.264774765896062e-21,  2.604700094253165e-23,  3.303537306941854e-01, -5.549781361135912e-03,  6.004859323305204e-05, -4.205624714469318e-07,  4.168540420914427e-10,
  3.902041786039939e-11, -6.650732106580708e-13,  5.259448734109862e-15, -6.240593799897876e-19, -8.589109995421948e-19,  1.468647650905284e-20, -2.755061257145173e-23,
  5.435322346524406e-01, -8.435184490869883e-03,  7.128166300918362e-05, -1.245826865625990e-07, -6.280190038824255e-09,  9.414770223117547e-11, -3.417581528802597e-13,
 -1.061055541351401e-14,  1.941800109536479e-16, -1.125990180604771e-18, -1.874861727157974e-20,  6.382244803149663e-22,  8.046433089293932e-01, -1.104718306533461e-02,
  5.523792980676750e-05,  5.845624589144537e-07, -1.190818530191794e-08,  1.202652752394687e-11,  1.954911121974144e-12, -2.203994196549637e-14, -1.902408993673633e-16,
  6.290347502768195e-18, -2.521919638994392e-20, -9.192077747475908e-22,  1.104954003532080e+00, -1.247735971776840e-02,  5.465078031057599e-07,  1.303782361030536e-06,
 -3.346072459763780e-09, -2.389404231411988e-10,  1.475327734882271e-12,  4.901479069026545e-14, -5.734579327958160e-16, -1.081164556726347e-17,  1.946413362497253e-19,
  2.451582883380447e-21,  1.425460126368316e+00, -1.154646863558167e-02, -7.966574579949581e-05,  9.466975541814850e-07,  2.034746638516484e-08, -1.004632338155103e-10,
 -5.856683001881176e-12, -6.874234707855447e-15,  1.666037072054660e-15,  1.115012377925131e-17, -4.767883787988668e-19, -6.178838039047922e-21,  1.727308966972104e+00,
 -7.467752409799598e-03, -1.178313172531818e-04, -8.658823595415765e-07,  1.031420663726783e-08,  4.045137358050266e-10,  4.242810723893133e-12, -5.194506795993682e-14,
 -2.455576740145296e-15, -2.932383123417212e-17,  3.285981549600524e-19,  1.780812669499650e-20,  1.942492699613173e+00, -1.943876000365385e-03, -4.701786499236630e-05,
 -9.454952487147294e-07, -1.615208085812144e-08, -2.247342964688689e-10, -2.087511095940146e-12,  5.274206237971078e-15,  8.329913600743505e-16,  2.414838860588173e-17,
  4.704860681370761e-19,  6.361879717580743e-21,  6.293522783652194e-03, -1.122653108474624e-04,  1.497306346754509e-06, -1.773128839185896e-08,  1.954903895668870e-10,
 -2.075509319212092e-12,  2.090447281440733e-14, -2.144976462107670e-16,  1.994394564867788e-18, -1.720418496147346e-20,  3.111698882139686e-22,  1.717212475896193e-24,
  5.667211486962193e-02, -9.988798697970333e-04,  1.294049135056073e-05, -1.452132319471726e-07,  1.464015064327978e-09, -1.354497051020277e-11,  1.088240211179674e-13,
 -8.148324835927771e-16,  3.372200138450279e-18,  2.308317075341542e-20,  7.798347982560823e-22,  3.807291493338531e-23,  1.575636046579463e-01, -2.707221054495424e-03,
  3.288680798991609e-05, -3.241626997333799e-07,  2.529398559497954e-09, -1.315302149889055e-11, -2.966013351768436e-14,  1.585455091382658e-15, -2.811909563582403e-17,
  3.403021877753818e-19,  1.422364522315750e-21,  9.215834219215869e-23,  3.090836514662993e-01, -5.089412305799209e-03,  5.506494176262229e-05, -4.084670923741894e-07,
  1.049455025947266e-09,  2.479903647382424e-11, -5.219330485882005e-13,  4.857609022223277e-15, -2.097564160223610e-17, -2.634475009310883e-19,  1.595127980248780e-20,
  8.749987961310846e-23,  5.109203078921942e-01, -7.872479610293014e-03,  6.924421970323009e-05, -2.105366470283230e-07, -4.499867241023543e-09,  8.304125143085072e-11,
 -5.586670623935559e-13, -5.134847699500376e-15,  1.469616942161090e-16, -1.309296278113960e-18,  9.643892602765519e-21,  6.431309334631044e-22,  7.613782811933232e-01,
 -1.058042589582018e-02,  6.112509116698295e-05,  3.982853445716020e-07, -1.125116044170150e-08,  5.105179500619445e-11,  1.284871102201429e-12, -2.475596110369563e-14,
  1.169694952086118e-17,  4.845266217382723e-18, -3.790931162879291e-20,  3.161931476298669e-22,  1.055150650889197e+00, -1.241166477336407e-02,  1.572038053066412e-05,
  1.214363832978498e-06, -7.671669500075252e-09, -1.894387110653094e-10,  2.544040339711118e-12,  2.610658921209658e-14, -8.031640051787101e-16, -1.592217318498816e-18,
  2.491138807949913e-19,  1.101557162216962e-22,  1.378079098645598e+00, -1.213302080285343e-02, -6.644297304606045e-05,  1.248592097801274e-06,  1.694920160884499e-08,
 -2.370802572720775e-10, -5.271056623329941e-12,  4.879354529260908e-14,  1.681207435209961e-15, -1.078971410951467e-17, -5.462365444479001e-19,  3.822942650049297e-21,
  1.695491661965711e+00, -8.448512174652052e-03, -1.269486016445429e-04, -6.312657750308945e-07,  1.925537815847534e-08,  4.791649488141017e-10,  1.557418310688509e-12,
 -1.431640743813997e-13, -3.059215189913741e-15,  2.248921479825416e-18,  1.294965371589162e-18,  2.360232214158969e-20,  1.933886377700820e+00, -2.370154830412325e-03,
 -6.007125714393388e-05, -1.242492070500882e-06, -2.111631413400523e-08, -2.691032577682462e-10, -1.406798045836383e-12,  5.003707127115172e-14,  2.110854751321297e-15,
  4.874129235453495e-17,  7.522544785742846e-19,  5.228695993850375e-21,  5.867141984213333e-03, -1.010877758355900e-04,  1.302011146386824e-06, -1.491018294080037e-08,
  1.585459648724688e-10, -1.639143675573458e-12,  1.571703135481302e-14, -1.580117810810163e-16,  1.620689718019634e-18, -2.942155176080621e-21,  4.000402325080856e-22,
  1.361647489292393e-24,  5.287314319960088e-02, -9.019476660053359e-04,  1.132997736515194e-05, -1.238218048990743e-07,  1.217452706891544e-09, -1.119371820368239e-11,
  8.770661874758157e-14, -6.842743790789385e-16,  5.173609068881298e-18,  8.778729321301066e-20,  2.377094130411191e-21,  2.640979169313950e-23,  1.472372176996160e-01,
 -2.459018579603039e-03,  2.923090874065898e-05, -2.858220683634692e-07,  2.262340150668278e-09, -1.342191086873016e-11,  4.103920051389061e-15,  9.010809286573314e-16,
 -1.379931924071770e-17,  4.838957412242230e-19,  5.646491667078223e-21,  7.439849591521844e-23,  2.895764452032561e-01, -4.668180243851566e-03,  5.027836997210022e-05,
 -3.883437543195778e-07,  1.430776412983277e-09,  1.382480358382883e-11, -3.958147020286115e-13,  4.166576589670071e-15, -1.787421110695437e-17,  4.671570522615733e-19,
  2.048698080361067e-20,  6.902626348899417e-23,  4.805207284328043e-01, -7.329734291630567e-03,  6.633812840349673e-05, -2.700162684502976e-07, -2.982192503685016e-09,
  6.839979911729400e-11, -6.428462174177739e-13, -1.058135254161976e-15,  1.132989229939784e-16, -3.953247459068127e-19,  3.432398697866407e-20,  3.958268681823057e-22,
  7.200606429143086e-01, -1.007528046152498e-02,  6.486288757061767e-05,  2.278775895924209e-07, -9.977034502265836e-09,  7.376468331603810e-11,  6.213179622790562e-13,
 -2.184038414259704e-14,  1.645027710093039e-16,  3.845184544876792e-18, -8.447500987190072e-21,  7.975813009021041e-22,  1.005844512380877e+00, -1.222996433157526e-02,
  2.944253591244329e-05,  1.064820634451934e-06, -1.080564919143624e-08, -1.224987502893874e-10,  2.920195279572628e-12,  1.388343294622570e-15, -6.848448519133885e-16,
  7.940746998434282e-18,  2.153810803625436e-19, -1.584953751168771e-21,  1.328584801313541e+00, -1.260042427195612e-02, -5.000996277531030e-05,  1.475540923951364e-06,
  1.108258979584542e-08, -3.416096354497054e-10, -3.237248663109357e-12,  9.268309896947483e-14,  9.690577184062817e-16, -2.616980663119776e-17, -1.581363587206564e-19,
  1.247541381195722e-20,  1.659626821179924e+00, -9.488430316641048e-03, -1.323566404227835e-04, -2.460395517786171e-07,  2.883236474159463e-08,  4.578576645960869e-10,
 -3.727226844426335e-12, -2.278968082780366e-13, -1.822978999118003e-15,  7.132872570530238e-17,  2.009914693419713e-18,  2.954423451195698e-21,  1.923341529545388e+00,
 -2.916526098421836e-03, -7.719019690529343e-05, -1.624607532403991e-06, -2.667541453473840e-08, -2.765836918976028e-10,  1.246959648717692e-12,  1.517582650820897e-13,
  4.436720986471083e-15,  8.027319090616059e-17,  7.028963592948536e-19, -1.189121767684389e-20,  5.482547641250777e-03, -9.134661632794146e-05,  1.137290060727328e-06,
 -1.261661447546070e-08,  1.292070871019310e-10, -1.309152659618642e-12,  1.202509523713713e-14, -1.047339660337295e-16,  1.801956414788242e-18,  1.243864515299669e-20,
  3.059380854707380e-22, -7.312750559165857e-24,  4.943766768425144e-02, -8.169364488080420e-04,  9.953956891116007e-06, -1.060253206131940e-07,  1.013187595187276e-09,
 -9.296352265233701e-12,  7.147917387037485e-14, -4.485067864412124e-16,  1.016950448523952e-17,  1.877258173203926e-19,  2.003779193482963e-21, -5.834339681271259e-23,
  1.378479573772471e-01, -2.238295739265609e-03,  2.600940920898798e-05, -2.517588772180179e-07,  1.996747003421960e-09, -1.305278480338445e-11,  2.610617055913841e-14,
  7.855529135285657e-16,  8.047713809921162e-18,  7.245317795271769e-19,  4.651520997013346e-21, -1.640815207903033e-22,  2.716792371564873e-01, -4.284186759668325e-03,
  4.576315803428608e-05, -3.637167473964771e-07,  1.621479478110541e-09,  5.681840838068939e-12, -2.834919725215731e-13,  4.022691509355959e-15,  1.360578097602066e-17,
  1.249495385075921e-18,  1.520404214890022e-20, -4.024775476655513e-22,  4.522416651094582e-01, -6.812702700508009e-03,  6.285406123636062e-05, -3.076284249115399e-07,
 -1.768781340364359e-09,  5.302259514621030e-11, -6.218281208395834e-13,  2.626414122573223e-15,  1.260208663038300e-16,  1.097778408177136e-18,  3.297681820649071e-20,
 -6.160748226711278e-22,  6.808109680397302e-01, -9.548036587060724e-03,  6.669039367406078e-05,  8.066199440287847e-08, -8.398545060481357e-09,  8.205987340046906e-11,
  1.041743769341988e-13, -1.436957954980819e-14,  3.033732560823670e-16,  3.966951249925434e-18,  4.697343198492061e-21, -5.543897111822347e-22,  9.574722981853340e-01,
 -1.194641335047758e-02,  4.111446429738790e-05,  8.761109815315602e-07, -1.256310214104250e-08, -5.410435539947424e-11,  2.706140526686438e-12, -1.445904623470511e-14,
 -2.657731156701760e-16,  1.458545270963006e-17,  9.989530615487805e-20, -3.938215837480212e-21,  1.277498628112102e+00, -1.292720562084730e-02, -3.147614171961819e-05,
  1.594917470253371e-06,  3.698006539413603e-09, -3.855451022761804e-10, -3.520035681830335e-13,  1.084856076153032e-13,  4.609019984440372e-17, -2.166986979616383e-17,
  3.497431512187834e-19,  7.884436685668776e-21,  1.619548630494575e+00, -1.055059769947850e-02, -1.322609020884381e-04,  2.814228219301865e-07,  3.655611357874402e-08,
  2.881584231873607e-10, -1.043075086622468e-11, -2.301703111143372e-13,  2.100071033675816e-15,  1.404052230488591e-16,  1.055772179319435e-18, -4.955798340338011e-20,
  1.910306137788282e+00, -3.619685922019680e-03, -9.941888486120748e-05, -2.092272329213837e-06, -3.146879776876094e-08, -1.767966554145310e-10,  7.947559605376227e-12,
  3.436459907283187e-13,  7.591454487830015e-15,  8.451859994549513e-17, -9.232558636985715e-19, -7.175052245941074e-20,  5.134446069076658e-03, -8.282064149817737e-05,
  9.974788914377146e-07, -1.074395865000190e-08,  1.057081941385490e-10, -1.048747351684880e-12,  9.979029536151843e-15, -3.844203431300433e-17,  2.351155374840796e-18,
  1.361111477673287e-20, -3.720583505960053e-22, -2.422013123780570e-23,  4.632149844957294e-02, -7.421319651466199e-04,  8.773075497580070e-06, -9.121205069292403e-08,
  8.436163654537822e-10, -7.688150015737528e-12,  6.456181553645523e-14, -7.028712729442200e-18,  1.736249434563099e-17,  1.729742739248313e-19, -3.909984584630710e-21,
 -2.167873148405103e-22,  1.292925322136188e-01, -2.041781355220339e-03,  2.317150821557234e-05, -2.218570086511489e-07,  1.743994257902280e-09, -1.210828699218039e-11,
  5.576712443563185e-14,  1.474943055978742e-15,  3.462088973839388e-17,  6.408672502529019e-19, -1.220546329031882e-20, -6.210162439762860e-22,  2.552476894210381e-01,
 -3.935092426520321e-03,  4.155687963810155e-05, -3.371939086542253e-07,  1.676644069836999e-09,  3.234909026953309e-13, -1.574344901576988e-13,  5.245768771586139e-15,
  6.298933837952364e-17,  1.248190794748904e-18, -2.216361503302834e-20, -1.336786637271565e-21,  4.259725601291529e-01, -6.325041998026067e-03,  5.902517466879822e-05,
 -3.282224299647696e-07, -8.490740420971617e-10,  3.948066880511618e-11, -4.845223617196161e-13,  7.464151765313779e-15,  1.783135839978441e-16,  1.378721596705888e-18,
 -3.215019299287127e-20, -2.409042312892923e-21,  6.436889380944149e-01, -9.012801045753560e-03,  6.690635424514838e-05, -4.056467797343713e-08, -6.758708137987808e-09,
  8.096008409597732e-11, -1.410436256303594e-13, -2.435962701937577e-15,  4.362880092094550e-16,  2.835332280970666e-18, -8.399927671315090e-20, -3.631615693363958e-21,
  9.104061559794950e-01, -1.157892151635857e-02,  5.039705636920108e-05,  6.698249273820021e-07, -1.303134655869777e-08,  5.526934894692642e-12,  2.264382101650446e-12,
 -1.419411187994353e-14,  2.796239591991684e-16,  1.401295313311907e-17, -1.582236581928465e-19, -7.963406700713966e-21,  1.225408050967003e+00, -1.310203675822638e-02,
 -1.223525897067695e-05,  1.592966945875218e-06, -3.853136464886386e-09, -3.579875829295913e-10,  2.610870887909936e-12,  1.005938957662615e-13, -4.395481164920015e-16,
 -5.378066039075580e-18,  3.344257624957218e-19, -9.726817922835079e-21,  1.575265944743552e+00, -1.158489383619853e-02, -1.252338400470199e-04,  8.968314059175735e-07,
  3.935360960572174e-08, -2.708453370406884e-11, -1.514610617116940e-11, -7.915254456090359e-14,  7.248807384639888e-15,  1.241576334847946e-16, -2.155120830745252e-18,
 -8.767429838227141e-20,  1.894065348065884e+00, -4.524208623409126e-03, -1.276200740465037e-04, -2.609899484332643e-06, -3.216564328426964e-08,  1.592315431165886e-10,
  2.133267134388624e-11,  6.201435385829398e-13,  8.928517880840624e-15, -4.707532383944469e-17, -6.524105452605743e-18, -1.891670359879128e-19,  4.818345219784977e-03,
 -7.532927848656767e-05,  8.780487304786235e-07, -9.207623132340955e-09,  8.708633111974388e-11, -8.133723711360374e-13,  9.995648858726254e-15,  3.939088932629223e-17,
  2.273797967781290e-18, -2.706898356246551e-20, -1.743716119791373e-21, -3.488624764321468e-23,  4.348671691703271e-02, -6.761072105002050e-04,  7.754719258608841e-06,
 -7.885898252930588e-08,  7.056755790490547e-10, -6.074083366505104e-12,  7.274291032786043e-14,  5.966824880023881e-16,  1.807778287712603e-17, -2.160410748330415e-19,
 -1.630678709782726e-20, -3.168286167269125e-22,  1.214799359123006e-01, -1.866601911934860e-03,  2.066893594699873e-05, -1.958011838965209e-07,  1.519278293295024e-09,
 -1.013262719306900e-11,  1.150240126429561e-13,  2.796520321524612e-15,  4.116695621211890e-17, -5.150547037986581e-19, -4.781427920038338e-20, -9.115139729485149e-22,
  2.401472461755399e-01, -3.618367225747430e-03,  3.767120637608571e-05, -3.104666549439033e-07,  1.658548007341413e-09, -1.432336930231939e-12,  2.245572433916258e-14,
  7.678298216190127e-15,  7.542521826974619e-17, -1.063576943614754e-18, -9.797550507635796e-20, -1.930798640815805e-21,  4.015915984192142e-01, -5.868769918158461e-03,
  5.502922812507212e-05, -3.360394099768345e-07, -1.553409193965837e-10,  3.103615550499744e-11, -1.913000777363037e-13,  1.347879545124572e-14,  1.747991037578136e-16,
 -2.495940785273859e-18, -1.701899266914416e-19, -3.535592985465308e-21,  6.087027180593231e-01, -8.481213817085944e-03,  6.582358702564615e-05, -1.359282107341034e-07,
 -5.170440459078238e-09,  7.839654685377977e-11, -5.150149886111944e-15,  1.214363303480850e-14,  4.313752730464543e-16, -4.564458926529175e-18, -3.018798388365980e-19,
 -5.717572191895326e-21,  8.649427600070183e-01, -1.114711098831839e-02,  5.719684522179969e-05,  4.650489072724063e-07, -1.240256223477527e-08,  5.651821632494952e-11,
  2.055043379381779e-12,  8.515147766313173e-16,  5.758332981128429e-16, -3.549663299864027e-19, -5.776284917894008e-19, -1.020821224395623e-20,  1.172923041782263e+00,
 -1.312502185894566e-02,  6.287744049998323e-06,  1.478370793956827e-06, -1.016685385288105e-08, -2.632298910615507e-10,  5.213440735577080e-12,  8.485464449266174e-14,
 -5.433959389155046e-16, -5.653376126276540e-18, -4.503701890500168e-19, -2.337112221804209e-20,  1.527005680921032e+00, -1.253318361750784e-02, -1.107765924324391e-04,
  1.502168741054637e-06,  3.514756467832219e-08, -3.876238944555520e-10, -1.360451797613405e-11,  2.003343771939214e-13,  9.274520399812246e-15, -3.373322540303607e-17,
 -5.432348101784222e-18, -4.574475087640491e-20,  1.873716473571926e+00, -5.678739147520845e-03, -1.618141240811943e-04, -3.064811482127891e-06, -2.230243925730336e-08,
  9.080630736215164e-10,  4.197895252883007e-11,  8.102054048675095e-13,  2.570328309982471e-16, -5.018783139605685e-16, -1.649327306449123e-17, -2.180545878723643e-19,
  4.530409026914355e-03, -6.872431630750268e-05,  7.754242814763417e-07, -7.930840991084167e-09,  7.334386517907564e-11, -5.534726186107008e-13,  1.185821675266087e-14,
  8.028455145122408e-17, -2.928478865089749e-19, -1.230357196602059e-19, -2.831331306510776e-21, -3.259592192915745e-24,  4.090062992329201e-02, -6.176713276557875e-04,
  6.872472747006370e-06, -6.843845478456087e-08,  6.032943305590174e-10, -4.074735911647788e-12,  9.533158474869670e-14,  8.992661721249146e-16, -4.500207025028447e-18,
 -1.106555892582978e-18, -2.618466089312714e-20, -2.864811860261388e-23,  1.143299148470579e-01, -1.710249922749858e-03,  1.845904920530558e-05, -1.729350231574133e-07,
  1.351216521680577e-09, -6.315760298936911e-12,  2.059169266823059e-13,  3.374445667129748e-15, -2.060881774053610e-17, -3.113577166760338e-18, -7.626914137229929e-20,
 -8.374502751366001e-23,  2.262535558237922e-01, -3.331450455666779e-03,  3.410418659137910e-05, -2.840525244876820e-07,  1.653853115066965e-09,  1.892863805041984e-12,
  2.591719535216493e-13,  8.566908949829145e-15, -5.207719324044745e-17, -6.438212506618858e-18, -1.585764110929950e-19, -2.054090699484660e-22,  3.789714487309943e-01,
 -5.444662005329413e-03,  5.100189291202447e-05, -3.336704278358266e-07,  4.527597835279554e-10,  3.146863550063228e-11,  2.398561760069019e-13,  1.603437291967583e-14,
 -7.190864736764626e-17, -1.198406375719169e-17, -2.824426277149226e-19, -4.510131262534394e-22,  5.758188820663064e-01, -7.962436237276290e-03,  6.374818354305502e-05,
 -2.059777122280243e-07, -3.569128208390217e-09,  8.366611111598163e-11,  4.840751492017044e-13,  2.052290802444721e-14, -6.039117790506488e-18, -2.099519118630252e-17,
 -4.841380194555104e-19, -6.808825701494659e-22,  8.213001821277095e-01, -1.067048387130387e-02,  6.163287718545854e-05,  2.783742876799728e-07, -1.076699317443794e-08,
  1.080155762689550e-10,  2.298338413914788e-12,  1.379865197916408e-14,  4.972519369435196e-17, -3.103239230302731e-17, -8.910750698406459e-19, -9.988868179948957e-22,
  1.120631543188735e+00, -1.300687558006907e-02,  2.290257912439635e-05,  1.281151117598726e-06, -1.399934170256685e-08, -1.119231156613216e-10,  7.278970474075730e-12,
  5.874942568177354e-14, -1.311853328572279e-15, -4.294344226362110e-17, -1.315184482958801e-18, -9.392813138052028e-21,  1.475227274823937e+00, -1.333842474319031e-02,
 -8.968309718962037e-05,  1.987250548975398e-06,  2.474723692272545e-08, -6.159711203915365e-10, -4.336170751983456e-12,  4.335356391839173e-13,  3.929905573086892e-15,
 -2.613823279440779e-16, -5.133883852997252e-18,  6.515684913122582e-20,  1.848173314681166e+00, -7.124655980890480e-03, -1.999357028122028e-04, -3.214151626201887e-06,
  7.687442192260691e-09,  2.167090615771390e-09,  6.107108419340240e-11,  3.884297778831947e-13, -3.113805937394239e-14, -1.246274096532339e-15, -1.636722703716801e-17,
  3.907916123350265e-19,  4.267342992003837e-03, -6.288239019572336e-05,  6.869819106662288e-07, -6.829746355491339e-09,  6.527684161167015e-11, -2.478120405935191e-13,
  1.315919427875714e-14, -2.051923681983981e-17, -6.546653678982154e-18, -2.103071509408214e-19, -6.226046466749396e-22,  1.212538282778466e-22,  3.853492741893674e-02,
 -5.658178419403464e-04,  6.106862417241809e-06, -5.930566378964740e-08,  5.464526441147975e-10, -1.544739775770341e-12,  1.111197216798502e-13, -7.232536132872905e-17,
 -6.121841541982235e-17, -1.915150089401117e-18, -5.915412140264502e-21,  1.111620993507099e-21,  1.077716254713720e-01, -1.570518585944283e-03,  1.651032834736621e-05,
 -1.520283105177758e-07,  1.281074843996166e-09, -4.385297618078455e-13,  2.702768218460080e-13,  3.669980269242449e-16, -1.819508852844963e-16, -5.477810974796753e-18,
 -1.793462842054802e-20,  3.203315378135946e-21,  2.134524750982007e-01, -3.071796182895709e-03,  3.085687807394650e-05, -2.568750531635535e-07,  1.771302956671299e-09,
  1.054631494239504e-11,  4.324533942410903e-13,  2.036350317828792e-15, -3.865881974136087e-16, -1.138086828683854e-17, -3.858156794551614e-20,  6.638776870424033e-21,
  3.579837124044382e-01, -5.052489308741079e-03,  4.706348832477358e-05, -3.209364084811035e-07,  1.172749329326755e-09,  4.187789004926949e-11,  5.767172398689512e-13,
  4.766239385581855e-15, -6.869803324143019e-16, -2.083330999935235e-17, -6.992075832492706e-20,  1.189292374652388e-20,  5.449722571753943e-01, -7.463176295087979e-03,
  6.099158981532140e-05, -2.488812043543030e-07, -1.736636669324717e-09,  1.013288784590774e-10,  9.166378636472512e-13,  4.699345106670461e-15, -1.076706072648947e-15,
 -3.619736248649774e-17, -1.245101673820053e-19,  2.008097040616806e-20,  7.796216363377865e-01, -1.016680324291524e-02,  6.402106880629882e-05,  1.265009193969092e-07,
 -8.028116554531817e-09,  1.667192582217036e-10,  2.491587391933938e-12, -9.011216086091055e-15, -1.650326818409181e-15, -5.950983357403851e-17, -2.780807773104559e-19,
  3.394749351719255e-20,  1.069062330145597e+00, -1.276607361468905e-02,  3.689060833646883e-05,  1.049197755138780e-06, -1.438953097709423e-08,  7.597095937745703e-11,
  8.030598550916760e-12, -1.812541019502869e-14, -3.777654607235265e-15, -8.908910066661618e-17, -5.241465046111916e-19,  5.478807322143087e-20,  1.420597925317734e+00,
 -1.395472215501868e-02, -6.387358871804713e-05,  2.283255624406821e-06,  1.240234298736478e-08, -5.700931121918844e-10,  7.909487194493143e-12,  3.769015179699355e-13,
 -8.151287245282005e-15, -3.725753579903315e-16,  5.056371148935826e-19,  1.934133614643467e-19,  1.816239400880930e+00, -8.872510349899670e-03, -2.360752871407710e-04,
 -2.663675106091369e-06,  6.579690501851081e-08,  3.605997955517635e-09,  5.066068389356572e-11, -1.394978644481745e-12, -7.998908931615392e-14, -1.145614172279774e-15,
  3.255877907793367e-17,  1.875428170074541e-18,  4.026310787592934e-03, -5.769687563365664e-05,  6.111818063188240e-07, -5.808517315313585e-09,  6.328061494894140e-11,
  3.059019827703758e-14,  8.555135560398468e-15, -3.423950822789481e-16, -1.280733019594811e-17, -7.726908355865225e-20,  8.400646580053819e-21,  2.678041760249236e-22,
  3.636506652071929e-02, -5.196624083608239e-04,  5.447090507431963e-06, -5.067016048113387e-08,  5.406513947006036e-10,  8.140277570491835e-13,  7.167369357259616e-14,
 -3.055764170942579e-15, -1.182955943615655e-16, -7.031957973678629e-19,  7.686660941305187e-20,  2.459203090667324e-21,  1.017426561223845e-01, -1.445383281306384e-03,
  1.480980000711541e-05, -1.312594978393496e-07,  1.333837947602469e-09,  5.334687816545595e-12,  1.704108514337015e-13, -8.390471989314434e-15, -3.455398774182867e-16,
 -2.014610289533618e-18,  2.211648169490066e-19,  7.118651004463334e-21,  2.016401838182490e-01, -2.836769695014183e-03,  2.795319165624894e-05, -2.262934594565160e-07,
  2.081821615670537e-09,  1.983964141872868e-11,  2.567262094108248e-13, -1.644281458862192e-14, -7.273965105792649e-16, -4.229530961640659e-18,  4.594606352866635e-19,
  1.488769650247688e-20,  3.385029202521585e-01, -4.690998808608523e-03,  4.335490791097377e-05, -2.947280600772982e-07,  2.143778396407659e-09,  5.415531280229071e-11,
  2.932861881809578e-13, -2.841798376733845e-14, -1.313407119477829e-15, -7.970464437186031e-18,  8.291924850618764e-19,  2.703676739135651e-20,  5.160760483073444e-01,
 -6.987500569801148e-03,  5.790896722590674e-05, -2.593001357645407e-07,  4.954027153276047e-10,  1.198280727066152e-10,  3.757532490379790e-13, -4.930061526187517e-14,
 -2.174997678776088e-15, -1.463425886126425e-17,  1.403037148547207e-18,  4.623736503515848e-20,  7.399856512942621e-01, -9.650472724549372e-03,  6.488839140881600e-05,
  2.775659498391411e-08, -4.155427025657109e-09,  2.155548210716044e-10,  1.183942641611723e-12, -9.441524300627849e-14, -3.494806036521088e-15, -2.569935623738237e-17,
  2.312726092035722e-18,  7.893445133883647e-20,  1.018662734430481e+00, -1.242431968509150e-02,  4.818250184408698e-05,  8.411359587944134e-07, -1.106710938212608e-08,
  2.459948202932114e-10,  5.355276731026817e-12, -1.879723204756566e-13, -6.525034273071612e-15, -3.383210256999904e-17,  3.937262706111104e-18,  1.400601609861297e-19,
  1.363934309678402e+00, -1.435352556736995e-02, -3.561855757516477e-05,  2.403696213511678e-06,  3.550613853332206e-09, -2.948986394573670e-10,  1.293065056605199e-11,
 -7.559544765252497e-14, -1.878704134240862e-14, -1.430836643010499e-16,  1.180640696570259e-17,  3.016391653616790e-19,  1.776802641562769e+00, -1.086525037904721e-02,
 -2.591785723788391e-04, -9.867533558641448e-07,  1.453016003330804e-07,  4.039082540192164e-09, -2.763005537651426e-11, -4.187464590432976e-12, -7.605458539398780e-14,
  1.950581986130948e-15,  1.174815578690338e-16,  1.118395906665152e-18,  3.804885175205858e-03, -5.306891830985779e-05,  5.475999344575771e-07, -4.784075629731020e-09,
  6.492910267803142e-11,  7.486431919192917e-14, -6.595953252404489e-15, -7.098902121160049e-16, -6.915147069321374e-18,  4.613703753020905e-19,  1.644553719374953e-20,
 -2.546092395725512e-23,  3.436992919591031e-02, -4.783691262554096e-04,  4.891692955403171e-06, -4.183286818682030e-08,  5.649870840853155e-10,  1.082659428852265e-12,
 -6.526945307769032e-14, -6.450733059585127e-15, -6.413346695044812e-17,  4.234786301564761e-18,  1.509497253805758e-19, -2.247269980942685e-22,  9.618862818540293e-02,
 -1.332833469458112e-03,  1.336670238013173e-05, -1.089448216612489e-07,  1.455929377805026e-09,  5.364779562038089e-12, -2.146060942081853e-13, -1.831473272620226e-14,
 -1.888207669837199e-16,  1.224218832518400e-17,  4.368442239710583e-19, -5.983604277263907e-22,  1.907239985413293e-01, -2.623408632197249e-03,  2.545116101884001e-05,
 -1.896793648675380e-07,  2.489308578835853e-09,  1.786330571351395e-11, -5.199204110339833e-13, -3.737983814075018e-14, -4.019455668859573e-16,  2.551800900991537e-17,
  9.145289905537829e-19, -1.088318893339246e-21,  3.204111370248526e-01, -4.357640277511800e-03,  4.006000834867737e-05, -2.517369900421228e-07,  3.208168519119478e-09,
  4.691693893387323e-11, -1.075155149644215e-12, -6.639664933558588e-14, -7.352664569388788e-16,  4.598414259377117e-17,  1.665821058198350e-18, -1.572869971441392e-21,
  4.890333135393028e-01, -6.536358079591000e-03,  5.492397047860134e-05, -2.323237120135800e-07,  2.829344550139660e-09,  1.044141929021877e-10, -1.958433150547969e-12,
 -1.126489565190140e-13, -1.230344020541399e-15,  7.735361328410944e-17,  2.857154655084317e-18, -1.748521626843324e-21,  7.024229265250205e-01, -9.130831280153111e-03,
  6.496680474533091e-05, -3.827145426977345e-09,  1.596081429172660e-10,  1.995591526321231e-10, -2.998358974547383e-12, -1.965853039798489e-13, -1.961003037193226e-15,
  1.287455584400973e-16,  4.848437540415211e-18, -7.037493289619747e-22,  9.697965895105539e-01, -1.200108673517740e-02,  5.739275129664042e-05,  7.081893068956968e-07,
 -5.410060244793378e-09,  2.880282164075189e-10, -2.728102455211650e-12, -3.740072467812325e-13, -3.481121390025084e-15,  2.354806650612502e-16,  8.562776093180067e-18,
  2.306470566523960e-21,  1.306133891473546e+00, -1.452247817696188e-02, -6.578325718577138e-06,  2.428217959349809e-06,  2.271404935348401e-10, -7.877640341457267e-11,
  2.416684211269704e-12, -6.436696359970022e-13, -1.253760513518435e-14,  5.512968779411121e-16,  2.040815118054909e-17, -5.440932374428945e-20,  1.729183124201947e+00,
 -1.294082988037915e-02, -2.546399355259446e-04,  1.904641344069405e-06,  2.089301290070201e-07,  1.792071583738955e-09, -1.618008737086602e-10, -4.584273816417080e-12,
  7.644273035838721e-14,  5.998564262489425e-15,  3.581416321325248e-17, -5.390542926678614e-18,  3.601032481446460e-03, -4.890007040058178e-05,  4.964267363509002e-07,
 -3.748801832930926e-09,  6.318484612611498e-11, -3.273889002019248e-13, -2.624969660336634e-14, -5.547122052485331e-16,  1.909391621575916e-17,  8.539797078764443e-19,
 -3.136382623644055e-21, -8.567112663486549e-22,  3.253175852512936e-02, -4.410891054756606e-04,  4.444203042062336e-06, -3.276834996918667e-08,  5.558880295350652e-10,
 -2.703441731183654e-12, -2.441335200101172e-13, -5.046860600975453e-15,  1.746770618710174e-16,  7.844216725395166e-18, -2.861527595394280e-20, -7.869949098625870e-21,
  9.106344818720544e-02, -1.230727746643788e-03,  1.220127569742338e-05, -8.525172885745769e-08,  1.468796552409305e-09, -6.102523413376188e-12, -7.238248940701447e-13,
 -1.435848699065551e-14,  5.022945538152324e-16,  2.272251540442692e-17, -8.171867525400214e-20, -2.280926516508340e-20,  1.806241508731202e-01, -2.428205941990163e-03,
  2.342256915460305e-05, -1.480390421489788e-07,  2.633977713387972e-09, -7.543056933548421e-12, -1.562532787639212e-12, -2.936078627946068e-14,  1.042477218770044e-15,
  4.757453069476682e-17, -1.671984953372299e-19, -4.784303674710305e-20,  3.036037145587280e-01, -4.048312010383770e-03,  3.737178162152285e-05, -1.949576074534403e-07,
  3.732221981316833e-09, -1.894493595411704e-12, -2.930818708847165e-12, -5.214181289980434e-14,  1.881904396316214e-15,  8.646218226814692e-17, -2.940381150276817e-19,
 -8.734581674376085e-20,  4.637502762420085e-01, -6.107211666343738e-03,  5.246530801795164e-05, -1.740138085433994e-07,  4.182775164508133e-09,  1.842658300163547e-11,
 -5.100667636212305e-12, -8.801141343259643e-14,  3.213013933724593e-15,  1.474488497896973e-16, -4.822334840014042e-19, -1.503625075071876e-19,  6.669391969469868e-01,
 -8.610968783835531e-03,  6.504996997163989e-05,  2.481459935775084e-08,  2.971506024947157e-09,  5.999858748806831e-11, -8.438352047704898e-12, -1.520132587559136e-13,
  5.505732858818508e-15,  2.488107432276884e-16, -8.003650793737032e-19, -2.578550345074792e-19,  9.227627974477856e-01, -1.150902666322947e-02,  6.554022268827598e-05,
  6.604910537240486e-07, -1.176078227088331e-09,  9.436348830547658e-11, -1.305000953225921e-11, -2.911164093444191e-13,  9.997786266540133e-15,  4.461877376925897e-16,
 -1.628420109144376e-18, -4.709219260029115e-19,  1.248123185368349e+00, -1.445862056135558e-02,  2.252222303209339e-05,  2.415743133534596e-06, -2.365478201768099e-09,
 -2.588444113298688e-10, -1.722784248432960e-11, -5.919381733892613e-13,  1.871804897226088e-14,  1.015710065010849e-15, -5.223851923690400e-18, -1.106774754215315e-18,
  1.673572182432968e+00, -1.482853199042401e-02, -2.113293226831564e-04,  5.287146677282473e-06,  1.978113201622534e-07, -3.158849938588287e-09, -2.246105744908566e-10,
  1.044289389466383e-12,  2.492417153268115e-13,  1.612062306017642e-15, -2.519526364541791e-16, -4.708702102159077e-18,  3.413113420876714e-03, -4.509215271500677e-05,
  4.571692131406121e-07, -2.828154816925667e-09,  4.954703813032623e-11, -1.049119871632515e-12, -2.923317304526560e-14,  4.453996148600603e-16,  3.793804850440930e-17,
 -5.498430544067906e-20, -3.890417446474564e-20, -3.772658888015931e-22,  3.083622417212984e-02, -4.069635193178502e-04,  4.101435549061337e-06, -2.465860114166180e-08,
  4.360664387035033e-10, -9.391552497041289e-12, -2.704914166404104e-13,  4.118004074322950e-15,  3.478478626428883e-16, -5.033541177568908e-19, -3.575229459785938e-19,
 -3.472807282200430e-21,  8.632982191182026e-02, -1.136826033552901e-03,  1.131189939597793e-05, -6.376622046604795e-08,  1.152809050606694e-09, -2.580089316329865e-11,
 -7.944810536919115e-13,  1.207705114913310e-14,  1.004312543247486e-15, -1.454227310466623e-18, -1.036929156757470e-18, -1.010481239768431e-20,  1.712758156138909e-01,
 -2.247240569642599e-03,  2.188682517761176e-05, -1.093325686261356e-07,  2.067198687049303e-09, -4.971168432687722e-11, -1.694797365647160e-12,  2.570901527160632e-14,
  2.094384672271362e-15, -3.068989298567300e-18, -2.176826077358167e-18, -2.130683617716535e-20,  2.879949940724398e-01, -3.757710113660578e-03,  3.537596772319211e-05,
 -1.397064528723957e-07,  2.919118097988399e-09, -8.035247441798448e-11, -3.142520152390006e-12,  4.755847990724141e-14,  3.793811210766545e-15, -5.789602679945351e-18,
 -3.977041623514467e-18, -3.910135542568640e-20,  4.401492343135829e-01, -5.694722458592122e-03,  5.076764822949476e-05, -1.113624598074965e-07,  3.206809669296829e-09,
 -1.175139133125279e-10, -5.434462804892286e-12,  8.211429163531815e-14,  6.466332282488742e-15, -1.088753376712706e-17, -6.848471315479047e-18, -6.740226392627012e-20,
  6.335391718605519e-01, -8.088555346616266e-03,  6.563409145854609e-05,  6.996505840723398e-08,  1.936824029301043e-09, -1.662227558324170e-10, -9.063776403538496e-12,
  1.374093811361196e-13,  1.094978151560650e-14, -2.238742398026998e-17, -1.174479245508051e-17, -1.139901228637980e-19,  8.778251169941617e-01, -1.095329882561900e-02,
  7.335475159135968e-05,  6.378109205208038e-07, -2.836334301420950e-09, -2.671830147024159e-10, -1.464948538094360e-11,  2.295991729943664e-13,  1.952754820660683e-14,
 -5.479798614347359e-17, -2.145980536092239e-17, -1.932660248377481e-19,  1.190831017662194e+00, -1.416369154007015e-02,  5.102885950994781e-05,  2.309996641409792e-06,
 -1.253963142203564e-08, -7.736582257060562e-10, -2.078802487915106e-11,  4.516694571277558e-13,  3.931135607676568e-14, -1.737561210870287e-16, -4.844133323523903e-17,
 -2.977720884740882e-19,  1.611345979361069e+00, -1.621816785276631e-02, -1.318610560340311e-04,  7.679927395941571e-06,  8.770795347514961e-08, -7.319177167165192e-09,
 -9.008340251933373e-11,  7.829515587785515e-12,  1.118925321697120e-13, -8.558695694670735e-15, -1.487572564834374e-16,  9.317137678420522e-18,  3.239861226429145e-03,
 -4.155888530939898e-05,  4.271892292632634e-07, -2.234804389463813e-09,  2.322012149179951e-11, -1.476645561451329e-12, -2.231121162383677e-15,  1.328046609489975e-15,
  9.022495411418811e-18, -1.382804973408573e-18, -1.391989062914787e-20,  1.391930691446623e-21,  2.927226509440968e-02, -3.752333217172483e-04,  3.840212857543470e-06,
 -1.947627970247921e-08,  1.987194705221850e-10, -1.335915300215361e-11, -2.199816003553431e-14,  1.220496113913478e-14,  8.219695935074511e-17, -1.270303204201997e-17,
 -1.275828183240936e-19,  1.281017595717669e-20,  8.195904542921183e-02, -1.049123175913562e-03,  1.063745421784499e-05, -5.030860552480678e-08,  4.910048998698960e-10,
 -3.751891786829741e-11, -7.204642845571167e-14,  3.538922066594742e-14,  2.341326435225730e-16, -3.681714510485548e-17, -3.678219419109547e-19,  3.726805432674501e-20,
  1.626294114715078e-01, -2.076919828134475e-03,  2.073429859497069e-05, -8.604761452418672e-08,  7.609926369395952e-10, -7.488954158988462e-11, -1.745763313236290e-13,
  7.419373766582400e-14,  4.774980158479892e-16, -7.721863062679573e-17, -7.637107145776306e-19,  7.863691328721835e-20,  2.735204816733902e-01, -3.480759832891333e-03,
  3.391522257724762e-05, -1.092687292666672e-07,  7.317235955889528e-10, -1.273857387564813e-10, -3.641632562643771e-13,  1.350043191033807e-13,  8.357222858529318e-16,
 -1.409323519935937e-16, -1.368087702679965e-18,  1.447986864328868e-19,  4.181751079034555e-01, -5.293273565306187e-03,  4.964173828216888e-05, -8.476348300354287e-08,
 -1.492281446792576e-10, -1.992549432039542e-10, -6.784849302519405e-13,  2.301055666058462e-13,  1.350251785227576e-15, -2.424158593585593e-16, -2.271160699667294e-18,
  2.522891794430693e-19,  6.022407383907121e-01, -7.559917668158182e-03,  6.651681754039065e-05,  6.451789597707335e-08, -3.061857117388205e-09, -3.020272317005037e-10,
 -1.083941578746745e-12,  3.849372850737067e-13,  2.089328329963386e-15, -4.148642563351080e-16, -3.613650513067498e-18,  4.402624653230047e-19,  8.352323094874803e-01,
 -1.033713185144919e-02,  8.050683460501779e-05,  5.339511461124898e-07, -1.083979648458521e-08, -4.788106702432639e-10, -9.498517145766664e-13,  6.603823565267309e-13,
  3.078235315112078e-15, -7.507112586375673e-16, -5.485277404579340e-18,  8.242730222602716e-19,  1.135161723143557e+00, -1.364931260645144e-02,  7.696407108856752e-05,
  1.965122358286017e-06, -3.131564346044329e-08, -9.975824812527479e-10,  5.945180348589308e-12,  1.256809656883068e-12,  2.137229902201554e-15, -1.599627389161835e-15,
 -5.743659940241214e-18,  1.908519647438081e-18,  1.544965727085008e+00, -1.689206537668705e-02, -3.628039597795836e-05,  7.872655676106527e-06, -6.173512665041104e-08,
 -6.749881487667054e-09,  1.298687859675151e-10,  6.216298971902339e-12, -1.944510273185992e-13, -5.621783197941246e-15,  2.606531352151294e-16,  4.797709615678872e-18,
  3.080296878167858e-03, -3.824452655865105e-05,  4.016513408131483e-07, -2.089827384164191e-09, -3.866829654695732e-12, -1.098080906059091e-12,  3.147150393096640e-14,
  8.375613038525297e-16, -3.557738574470858e-17, -7.178307379306467e-19,  4.073621926957580e-20,  5.528684833446444e-22,  2.783134502449728e-02, -3.454123415374201e-04,
  3.616982877017461e-06, -1.834691087289393e-08, -4.635562832326386e-11, -9.918241773246715e-12,  2.874657558420958e-13,  7.681109185429333e-15, -3.271143419219156e-16,
 -6.569596624269769e-18,  3.748150429447890e-19,  5.057507218688810e-21,  7.792904317604601e-02, -9.663607622870901e-04,  1.005674282634154e-05, -4.821338912977429e-08,
 -1.973257558676847e-10, -2.775384002591310e-11,  8.236419099214545e-13,  2.217174843015914e-14, -9.496383510355506e-16, -1.888713719291712e-17,  1.089883223266040e-18,
  1.452126465857448e-20,  1.546470858865829e-01, -1.915080529973970e-03,  1.972654936828052e-05, -8.537789718893122e-08, -6.126056099654775e-10, -5.502807216562017e-11,
  1.697710978714972e-12,  4.613056490811801e-14, -1.996090833515295e-15, -3.906840323801009e-17,  2.297686117500867e-18,  2.994674346800902e-20,  2.601318110882385e-01,
 -3.214674245298398e-03,  3.259213940566985e-05, -1.171393256700778e-07, -1.601815020148542e-09, -9.248617761368622e-11,  3.027473910602296e-12,  8.292394420128873e-14,
 -3.651257892803754e-15, -6.971989865500394e-17,  4.224628563892586e-18,  5.307772846962945e-20,  3.977893888369789e-01, -4.900546644991066e-03,  4.848184395330420e-05,
 -1.177432172327048e-07, -3.784751348376823e-09, -1.414724934740979e-10,  5.062877478170476e-12,  1.385549182440651e-13, -6.288782769162634e-15, -1.155538827562522e-16,
  7.341207935301736e-18,  8.660537243154344e-20,  5.730684696879119e-01, -7.025969235775736e-03,  6.680312675494681e-05, -3.058794420382543e-08, -8.509532472297435e-09,
 -2.049762449531110e-10,  8.412251860666553e-12,  2.237111282942777e-13, -1.074586470805502e-14, -1.851101862011437e-16,  1.274040083249276e-17,  1.334567251698060e-19,
  7.952073772863736e-01, -9.671100875585177e-03,  8.557055964968679e-05,  2.888327524733255e-07, -1.919440246770735e-08, -2.932835784647306e-10,  1.497183430534587e-11,
  3.553820993023804e-13, -1.929878919076411e-14, -2.917169516514931e-16,  2.351482405734409e-17,  1.865149097883650e-19,  1.081931356619505e+00, -1.294920033828186e-02,
  9.693751439059995e-05,  1.323650133625460e-06, -4.716872012396093e-08, -4.756933122688620e-10,  3.404226643168001e-11,  5.158417679245596e-13, -4.097074022821576e-14,
 -3.966729715915836e-16,  5.181459878628023e-17,  9.208119567481512e-20,  1.477379744016551e+00, -1.683013619028985e-02,  4.848607902301888e-05,  6.019147863069419e-06,
 -1.556135465357003e-07, -2.357589278558389e-09,  2.017278045109839e-10, -1.101318477298165e-12, -2.006802910564661e-13,  4.489103358385408e-15,  1.521969873184613e-16,
 -7.378520544466553e-18,  2.933583053199526e-03, -3.513405230473837e-05,  3.756261783546830e-07, -2.280882484631038e-09, -1.709921340665308e-11, -2.021546891035759e-13,
  3.743013584952585e-14, -3.901298235303926e-16, -3.190057282641800e-17,  7.914211864258929e-19,  2.234331367791141e-20, -1.080986770325094e-21,  2.650613874245648e-02,
 -3.173821091670684e-04,  3.387182620069598e-06, -2.025056180666066e-08, -1.649558900833152e-10, -1.731862992169964e-12,  3.418618214910662e-13, -3.589906679625629e-15,
 -2.923542412223924e-16,  7.289950727191284e-18,  2.043845190295850e-19, -9.954647736020601e-21,  7.422072215002998e-02, -8.883091644378377e-04,  9.444817061930456e-06,
 -5.459286491849364e-08, -5.237159418801072e-10, -4.286065562344514e-12,  9.790010337696331e-13, -1.044550183650228e-14, -8.428888824345786e-16,  2.124517951651346e-17,
  5.869193180279609e-19, -2.899548186666551e-20,  1.472955744237289e-01, -1.761600547597750e-03,  1.861492113244387e-05, -1.014711364149018e-07, -1.241511726234004e-09,
 -6.642617958209855e-12,  2.014465529389079e-12, -2.207268363937039e-14, -1.751517475024462e-15,  4.494266684380395e-17,  1.211443374319127e-18, -6.128491204836452e-20,
  2.477849211709193e-01, -2.960107553902733e-03,  3.098598472553476e-05, -1.530842782102746e-07, -2.610554241648615e-09, -6.281180661947698e-12,  3.575683216882561e-12,
 -4.083643838322777e-14, -3.147222995198554e-15,  8.302151066639231e-17,  2.153443237011196e-18, -1.130592262664824e-19,  3.789522863316477e-01, -4.519540386819810e-03,
  4.663615612162460e-05, -1.934516565425566e-07, -5.211106556746476e-09,  2.088996319168089e-12,  5.912816024878160e-12, -7.198296217351701e-14, -5.271349670881348e-15,
  1.451391532337946e-16,  3.543123195978435e-18, -1.972211746853528e-19,  5.460275387503463e-01, -6.495559762724970e-03,  6.552344076986366e-05, -1.871800187188148e-07,
 -1.029662124193694e-08,  3.064689781199341e-11,  9.568720589353861e-12, -1.288517052220168e-13, -8.598517601995131e-15,  2.537668393029802e-16,  5.593259335876452e-18,
 -3.433874616828312e-19,  7.579062695518102e-01, -8.978200790540514e-03,  8.706964412876487e-05, -4.361222355151138e-08, -2.103895301934082e-08,  1.124356689700662e-10,
  1.597629043719559e-11, -2.544382330641914e-13, -1.413007867083396e-14,  4.728028327884206e-16,  8.520369652204763e-18, -6.329099984340457e-19,  1.031767466772436e+00,
 -1.212341616848456e-02,  1.081298643035946e-04,  5.394432329734803e-07, -4.811404882147063e-08,  3.669137668998223e-10,  3.065063342138728e-11, -6.617385830226547e-13,
 -2.370401357854081e-14,  1.063482605566624e-15,  1.033223460604613e-17, -1.359499743144271e-18,  1.411229986649792e+00, -1.619762735604717e-02,  1.050177349370316e-04,
  3.393829368631409e-06, -1.598629354075808e-07,  1.563792084298466e-09,  1.100059186624213e-10, -4.385515409983423e-12, -4.513993300148058e-15,  4.658638594140739e-15,
 -1.046370427698988e-16, -2.473975783306598e-18,  2.798876913016195e-03, -3.224319195185982e-05,  3.466244259069202e-07, -2.543415879699553e-09, -1.351336640382580e-11,
  4.799059943033045e-13,  1.718821747391365e-14, -8.749135544075184e-16,  1.518171612244498e-18,  7.980363080580593e-19, -1.688780562520595e-20, -4.327426947642910e-22,
  2.528920273487795e-02, -2.913015142523024e-04,  3.128509515384090e-06, -2.277087211084440e-08, -1.299862097575263e-10,  4.487026661499469e-12,  1.561069670739987e-13,
 -8.017412383300555e-15,  1.463338352368432e-17,  7.312676580591063e-18, -1.557666526005723e-19, -3.947145758683425e-21,  7.081425343307902e-02, -8.155124383596446e-04,
  8.740350763476042e-06, -6.252560228986410e-08, -4.105308898189546e-10,  1.345905495957031e-11,  4.417662727061295e-13, -2.311606729122693e-14,  4.663317376273888e-17,
  2.107796735084216e-17, -4.552107668954991e-19, -1.126473171929034e-20,  1.405388288745043e-01, -1.617883946812564e-03,  1.728140532345365e-05, -1.200739710745083e-07,
 -9.665462331291913e-10,  2.965333669000265e-11,  8.912765977116898e-13, -4.807153153511161e-14,  1.124865787681307e-16,  4.378510586243432e-17, -9.671632067563868e-19,
 -2.300516552677782e-20,  2.364276522404833e-01, -2.720259672557597e-03,  2.890784850633384e-05, -1.917496618794401e-07, -2.016338027927312e-09,  5.755004934463291e-11,
  1.534429255456053e-12, -8.661006561629655e-14,  2.466562476725961e-16,  7.864678015763882e-17, -1.797672578251040e-18, -4.018822297148828e-20,  3.616036616483053e-01,
 -4.157105529557727e-03,  4.383827456135470e-05, -2.697449021921109e-07, -3.989312986967392e-09,  1.061401023652723e-10,  2.419936940749421e-12, -1.461199450303566e-13,
  5.329213796306228e-16,  1.316907436074023e-16, -3.168799791555536e-18, -6.421452587649413e-20,  5.210756490470290e-01, -5.983037864557496e-03,  6.234500754207515e-05,
 -3.362133379288360e-07, -7.800981918691622e-09,  1.951820554540233e-10,  3.624797377314645e-12, -2.427257422601431e-13,  1.203823894529327e-15,  2.148263775934672e-16,
 -5.598582577939711e-18, -9.599514748152349e-20,  7.233755647899925e-01, -8.289168383197765e-03,  8.465988461065920e-05, -3.445399804015798e-07, -1.572592192557404e-08,
  3.760769882703886e-10,  5.253122300798837e-12, -4.186294681145447e-13,  3.065520178453377e-15,  3.534454158614402e-16, -1.054745398292702e-17, -1.285870550577266e-19,
  9.850274205001653e-01, -1.124478955727631e-02,  1.103359453365111e-04, -1.390888764098186e-07, -3.521145077011315e-08,  8.300854381052901e-10,  7.227443430992087e-12,
 -8.282724386599099e-13,  1.028813480856203e-14,  5.968285703192444e-16, -2.369575511813837e-17, -7.221455870102379e-20,  1.348320365290441e+00, -1.523495796800460e-02,
  1.317825391976726e-04,  1.189308437623044e-06, -1.116739341173911e-07,  2.837277725322842e-09,  4.036415314161179e-12, -2.742202024012775e-12,  8.008219863005362e-14,
  2.219629771600931e-16, -8.294279255406374e-17,  2.186928569367393e-18,  2.675252743707458e-03, -2.959512099052716e-05,  3.151736127562573e-07, -2.668372452114009e-09,
 -1.652251817588040e-12,  6.252639468795723e-13, -3.360695747085434e-15, -5.152758323459653e-16,  1.632482092814520e-17,  4.003109120288589e-20, -1.527904846764781e-20,
  3.412269012951581e-22,  2.417228254068106e-02, -2.673940190855427e-04,  2.846200810599574e-06, -2.400188886010333e-08, -1.983178672787132e-11,  5.787806297110049e-12,
 -3.191855029242082e-14, -4.704625197385862e-15,  1.498395771803694e-16,  3.482677112763733e-19, -1.399187034005541e-19,  3.146268514484352e-21,  6.768717010288697e-02,
 -7.486793783325968e-04,  7.960804438072024e-06, -6.657399586811081e-08, -8.441316692946982e-11,  1.702414890613142e-11, -9.866151852042378e-14, -1.346022054703480e-14,
  4.334647090370151e-16,  8.905625400313707e-19, -4.027577881305722e-19,  9.187451636252196e-21,  1.343343650645544e-01, -1.485608717721417e-03,  1.576986729217055e-05,
 -1.300664969227634e-07, -2.613877668295309e-10,  3.645931589049891e-11, -2.267654754629455e-13, -2.763605801842789e-14,  9.060971728600138e-16,  1.459701305634183e-18,
 -8.347627434138592e-19,  1.949186851186869e-20,  2.259939187876664e-01, -2.498652764580516e-03,  2.645559674892511e-05, -2.135824475235082e-07, -6.797698180901859e-10,
  6.823829825952332e-11, -4.638212743248567e-13, -4.881797992194202e-14,  1.644362463068426e-15,  1.534768925092991e-18, -1.494086406290918e-18,  3.613585299832116e-20,
  3.456548498866817e-01, -3.820256945536308e-03,  4.029502237107959e-05, -3.147454351545511e-07, -1.592019225178968e-09,  1.204813795627653e-10, -9.098262202498687e-13,
 -7.989308500525626e-14,  2.800934008070995e-15, -2.550789416465342e-19, -2.487718443525187e-18,  6.339615038921726e-20,  4.981128864527789e-01, -5.502221410767328e-03,
  5.769972659970111e-05, -4.272301762260243e-07, -3.531044593309259e-09,  2.104768218675423e-10, -1.797652583786122e-12, -1.263787411986668e-13,  4.709809310111735e-15,
 -7.948436837851657e-18, -4.019818231563074e-18,  1.109798770505740e-19,  6.915420126837639e-01, -7.632107077995296e-03,  7.927597609509114e-05, -5.327972002486627e-07,
 -7.796846687710982e-09,  3.813336499385853e-10, -3.778608067943254e-12, -1.998402351358870e-13,  8.239990417592938e-15, -3.602729599593675e-17, -6.494593854465962e-18,
  2.049369214083159e-19,  9.417912423776598e-01, -1.037706855438428e-02,  1.058454580086273e-04, -5.672585416808213e-07, -1.850047468467661e-08,  7.759455432073566e-10,
 -9.376702684829826e-12, -3.269850335736847e-13,  1.647134071042414e-14, -1.590508222924117e-16, -1.047937131780158e-17,  4.361025765763453e-19,  1.289542154533054e+00,
 -1.414974800638796e-02,  1.371642305817487e-04, -1.592354789348996e-07, -5.871930171400479e-08,  2.291519936069940e-09, -3.914263060694380e-11, -5.055043186040099e-13,
  5.095641104614658e-14, -1.287187623670598e-15, -1.031705661586956e-18,  1.133548275424636e-18,  2.561712799321756e-03, -2.720136154096702e-05,  2.833821240972431e-07,
 -2.603010311279327e-09,  9.175640841464234e-12,  4.283827616795385e-13, -1.092056519753497e-14, -5.696080266524146e-17,  1.054237196156314e-17, -2.631500989141644e-19,
 -8.045897503146268e-22,  2.313363358519028e-22,  2.314642495190354e-02, -2.457735537227457e-04,  2.559860174010827e-06, -2.346998552933456e-08,  8.032512396670087e-11,
  3.962818578265054e-12, -1.006920026191365e-13, -5.057651110901628e-16,  9.637993558770019e-17, -2.417351007146359e-18, -7.011195280702224e-21,  2.115751587679857e-21,
  6.481476584448136e-02, -6.881869374001697e-04,  7.164348703832550e-06, -6.542988940072878e-08,  2.097505333913502e-10,  1.163995235326425e-11, -2.939202469496132e-13,
 -1.361185078283834e-15,  2.764820725524556e-16, -7.004702349592078e-18, -1.801156251973938e-20,  6.073598691226137e-21,  1.286343319759564e-01, -1.365711642318591e-03,
  1.420650186585071e-05, -1.289163596551713e-07,  3.671352943698608e-10,  2.486897377766205e-11, -6.226021042310296e-13, -2.507385819535032e-15,  5.700248482471394e-16,
 -1.467941370314227e-17, -2.990666183887113e-20,  1.253105564114771e-20,  2.164062334733539e-01, -2.297346934004235e-03,  2.386940968534479e-05, -2.145059973236032e-07,
  4.926601918440953e-10,  4.636777314561678e-11, -1.149446168219632e-12, -3.661227507319480e-15,  1.012873096340128e-15, -2.673067463181427e-17, -3.305978647131273e-20,
  2.226957639801933e-20,  3.309942384646991e-01, -3.513265207065127e-03,  3.643926660431893e-05, -3.227112576697619e-07,  4.683035297636589e-10,  8.137210133841201e-11,
 -1.998228791863447e-12, -4.106587552770910e-15,  1.670993388256054e-15, -4.572404408647623e-17, -2.638729438087814e-21,  3.666915562526068e-20,  4.769937677832201e-01,
 -5.061791164190602e-03,  5.236273004826605e-05, -4.533038567181716e-07,  4.404702535209988e-11,  1.407633354439616e-10, -3.435436129014075e-12, -1.845420721556992e-15,
  2.672244286741968e-15, -7.724329224925775e-17,  1.325616193431075e-19,  5.817290480264769e-20,  6.622392282406576e-01, -7.025054028315870e-03,  7.236566141585458e-05,
 -6.028566355546120e-07, -1.386525387962241e-09,  2.507307567905835e-10, -6.136398032210592e-12,  9.760461003191458e-15,  4.290233498287527e-15, -1.356074500025981e-16,
  6.181451885080547e-19,  9.082386663807023e-20,  9.019277205649616e-01, -9.561476837445822e-03,  9.772870880117232e-05, -7.534726341798626e-07, -5.695944567232403e-09,
  4.932755241602159e-10, -1.239221824183581e-11,  6.110918237170459e-14,  7.183249341464472e-15, -2.695631357052307e-16,  2.636301778411642e-18,  1.346752597718580e-19,
  1.235107299267813e+00, -1.307290991946104e-02,  1.309570751104344e-04, -7.851760095328724e-07, -2.265383357445752e-08,  1.325294422277665e-09, -3.706473059228409e-11,
  4.455002182915981e-13,  1.176133467006205e-14, -7.688084516072513e-16,  1.824497678447661e-17, -5.463373637963640e-20,  2.457247903320365e-03, -2.505619493972933e-05,
  2.532633926500516e-07, -2.401866636511744e-09,  1.515355831218045e-11,  1.766983436803584e-13, -9.169655504159690e-15,  1.376659772153716e-16,  2.213663890084049e-18,
 -1.700767538622225e-19,  3.774663584043566e-21,  3.726712883265924e-24,  2.220254248965157e-02, -2.263942147719693e-04,  2.288121406588520e-06, -2.168159836546710e-08,
  1.357333049427581e-10,  1.646112061325334e-12, -8.431007021625605e-14,  1.269362299315890e-15,  2.004370819864023e-17, -1.555293066812272e-18,  3.467898083171101e-20,
  2.860814357765723e-23,  6.217177573297280e-02, -6.339405292402126e-04,  6.405768378166975e-06, -6.059267856496793e-08,  3.731162137108056e-10,  4.900814467336235e-12,
 -2.446835866291830e-13,  3.705859542461263e-15,  5.633107215235501e-17, -4.464044040654228e-18,  1.005091271231349e-19,  4.889731469170345e-23,  1.233891759757829e-01,
 -1.258115215078142e-03,  1.270854476655758e-05, -1.198679758768687e-07,  7.180251620639820e-10,  1.067032299696561e-11, -5.136275580651027e-13,  7.854325260451249e-15,
  1.122097203275076e-16, -9.210896253558006e-18,  2.106758172834476e-19, -1.240835882791576e-23,  2.075827237340642e-01, -2.116493144300955e-03,  2.136841952185695e-05,
 -2.006835925762869e-07,  1.151092816723543e-09,  2.035332951882789e-11, -9.360321947263307e-13,  1.452071803693247e-14,  1.888184575463153e-16, -1.638341027460692e-17,
  3.836444911635700e-19, -3.329217272169229e-22,  3.175000016309195e-01, -3.237006898292763e-03,  3.265706704684493e-05, -3.047539146571672e-07,  1.631832782484745e-09,
  3.661766383672641e-11, -1.598134330026798e-12,  2.531801743655082e-14,  2.853800242580652e-16, -2.705939333434778e-17,  6.558868977945909e-19, -1.339017979485270e-21,
  4.575502186589899e-01, -4.664450565033414e-03,  4.700600574093095e-05, -4.344322462070725e-07,  2.070113222876432e-09,  6.491994587923126e-11, -2.678771322553984e-12,
  4.378123222227080e-14,  3.915059962865357e-16, -4.331658193782263e-17,  1.105748313792835e-18, -4.170640111879660e-21,  6.352509518434467e-01, -6.475112464505149e-03,
  6.513864292586040e-05, -5.926088319769742e-07,  2.239633190158703e-09,  1.180569155084875e-10, -4.607966386476034e-12,  7.906774510933432e-14,  4.512071648726102e-16,
 -6.955006675487086e-17,  1.929365372246756e-18, -1.247659738937072e-20,  8.651868830120356e-01, -8.816713944631734e-03,  8.841592519775906e-05, -7.809000507765305e-07,
  1.433536092259982e-09,  2.343298849467974e-10, -8.732688400576124e-12,  1.630693847517295e-13,  1.304733193905128e-16, -1.160197693100303e-16,  3.761200363973037e-18,
 -4.219163782092620e-20,  1.184844888888797e+00, -1.206738000251955e-02,  1.200911396634886e-04, -9.791962985109824e-07, -3.904263415223890e-09,  6.071639038180152e-10,
 -2.254152155492297e-11,  5.081638405728829e-13, -4.357041553176006e-15, -1.856630665431841e-16,  9.770525660660795e-18, -2.259998315536437e-19,  2.360898879561753e-03,
 -2.314105786237810e-05,  2.259774127471562e-07, -2.141703006531570e-09,  1.682011255246983e-11,  6.244522082124428e-15, -5.043163405403511e-15,  1.382267715397687e-16,
 -1.407472026915514e-18, -4.158159395685275e-20,  2.288514667848557e-21, -4.829004565085751e-23,  2.133198236932459e-02, -2.090911896939205e-04,  2.041737830037061e-06,
 -1.934360986683727e-08,  1.514891954312134e-10,  7.923414584253583e-14, -4.636497278913632e-14,  1.268933646234282e-15, -1.300386924454734e-17, -3.776471458035700e-19,
  2.092431681439722e-20, -4.434542404292822e-22,  5.973405157758697e-02, -5.854957826468033e-04,  5.716777994484300e-06, -5.412044646561244e-08,  4.213346033410191e-10,
  3.557188923091915e-13, -1.345210286801161e-13,  3.671249432763324e-15, -3.812227611712684e-17, -1.068261103372127e-18,  6.003626917781512e-20, -1.283998170794582e-21,
  1.185512339630866e-01, -1.161992960549019e-03,  1.134414676708418e-05, -1.072633846626440e-07,  8.269776270055960e-10,  1.137949192961653e-12, -2.821753313442883e-13,
  7.671057410183198e-15, -8.132995579399523e-17, -2.151464780699702e-18,  1.237984779014483e-19, -2.686914221081807e-21,  1.994438676059814e-01, -1.954841781269554e-03,
  1.908059481795556e-05, -1.800856072324487e-07,  1.368034470953450e-09,  3.007262280355375e-12, -5.134143198072431e-13,  1.389554427733486e-14, -1.517880401702523e-16,
 -3.685014794154075e-18,  2.199689937554804e-19, -4.879966531119277e-21,  3.050520102713517e-01, -2.989891334578959e-03,  2.917477474454332e-05, -2.746199459682214e-07,
  2.040203419156411e-09,  7.074133092344624e-12, -8.737299296734068e-13,  2.355082473609342e-14, -2.681522304350460e-16, -5.736271691947554e-18,  3.626633773490807e-19,
 -8.307508848674059e-21,  4.396123946566314e-01, -4.308614094912795e-03,  4.202424738497590e-05, -3.939896748503063e-07,  2.827164476331978e-09,  1.560320403993356e-11,
 -1.455173352359498e-12,  3.914237608022332e-14, -4.721621075148890e-16, -8.317143256336622e-18,  5.787287622117470e-19, -1.390606571528126e-20,  6.103487340257097e-01,
 -5.981695188424044e-03,  5.830286796629018e-05, -5.431369923811324e-07,  3.674620243751325e-09,  3.384525977872128e-11, -2.471242461667639e-12,  6.670875667761695e-14,
 -8.744578053150203e-16, -1.101216243490232e-17,  9.235916901598654e-19, -2.394862612257726e-20,  8.312762697838219e-01, -8.146190026509308e-03,  7.930468828606502e-05,
 -7.303372447100573e-07,  4.383643431920707e-09,  7.708447421609410e-11, -4.553477492962470e-12,  1.252045967857636e-13, -1.869486094046009e-15, -1.031633582801826e-17,
  1.519424693177787e-18, -4.536719888666459e-20,  1.138421912826689e+00, -1.115395968690810e-02,  1.082838975558825e-04, -9.694143920237846e-07,  3.882293961415814e-09,
  2.172262824019102e-10, -1.083600053964256e-11,  3.195614485363692e-13, -6.122751767189816e-15,  3.816989955869127e-17,  2.320802135621985e-18, -1.069360903812475e-19,
  2.271793942375086e-03, -2.143149235157665e-05,  2.018778740275126e-07, -1.876946315258654e-09,  1.601795011171016e-11, -7.428697082667917e-14, -1.925374002045029e-15,
  8.299384011307623e-17, -1.728415940279263e-18,  1.233651745620589e-20,  5.751791754948582e-22, -2.641411239825748e-23,  2.052687320587146e-02, -1.936447915005813e-04,
  1.824044643855756e-06, -1.695644235906058e-08,  1.445459991841849e-10, -6.618789915445036e-13, -1.776310495970735e-14,  7.609539736335614e-16, -1.585983119595299e-17,
  1.144205109159122e-19,  5.227809468536766e-21, -2.414152304409921e-22,  5.747958500896384e-02, -5.422451737742060e-04,  5.107536138141780e-06, -4.746543634953452e-08,
  4.036789667362804e-10, -1.798680837449336e-12, -5.188977486840673e-14,  2.195892905122673e-15, -4.584452828396886e-17,  3.380701825938109e-19,  1.481216834098904e-20,
 -6.920992836115722e-22,  1.140769336942404e-01, -1.076163813070382e-03,  1.013612053760570e-05, -9.415051472668791e-08,  7.976956289578695e-10, -3.393737137429780e-12,
 -1.099193384993693e-13,  4.568996224297660e-15, -9.566834329200784e-17,  7.299268970865316e-19,  2.991358993926042e-20, -1.425193112287225e-21,  1.919166301130127e-01,
 -1.810468192298531e-03,  1.705105027783327e-05, -1.582640280428263e-07,  1.333307662479230e-09, -5.266396040859638e-12, -2.024679069063992e-13,  8.223851752991114e-15,
 -1.730133165728349e-16,  1.384893754926010e-18,  5.146175955320321e-20, -2.526937511825594e-21,  2.935391597693026e-01, -2.769115571853183e-03,  2.607674021891503e-05,
 -2.417790097791894e-07,  2.019893537693919e-09, -7.059384823662907e-12, -3.493963622306219e-13,  1.380696363196858e-14, -2.926814719261432e-16,  2.499698644585790e-18,
  8.069176312143944e-20, -4.152490187784819e-21,  4.230214864879390e-01, -3.990549525699732e-03,  3.757286977582763e-05, -3.478163556153638e-07,  2.869255790850653e-09,
 -8.021121574960811e-12, -5.902917908353000e-13,  2.262084535270323e-14, -4.854937320331932e-16,  4.523214100780543e-18,  1.185687398472700e-19, -6.591675084145720e-21,
  5.873149768130163e-01, -5.540309903002806e-03,  5.215147931888876e-05, -4.815747154988992e-07,  3.892601777563488e-09, -6.370935796708559e-12, -1.014793388461249e-12,
  3.767135184138585e-14, -8.259044269700670e-16,  8.668818077235341e-18,  1.619710682431325e-19, -1.042409296030709e-20,  7.999066748834679e-01, -7.545532346506519e-03,
  7.099607441124985e-05, -6.527338216207085e-07,  5.081313159339290e-09,  3.098903595076079e-12, -1.877515329443802e-12,  6.779050041092044e-14, -1.547795186151048e-15,
  1.933382341851618e-17,  1.750199377454004e-19, -1.683354481623129e-20,  1.095466768000751e+00, -1.033291247458128e-02,  9.712862189673715e-05, -8.840067456927815e-07,
  6.243612405257194e-09,  4.411250304830664e-11, -4.341013441617719e-12,  1.561887964833869e-13, -3.935066243293635e-15,  6.627480133840361e-17, -3.148846656127791e-19,
 -2.433357928050542e-20,  2.189161356772404e-03, -1.990233164014024e-05,  1.808369812942834e-07, -1.634371636939029e-09,  1.422821217844924e-11, -9.833906282824437e-14,
 -2.884858678417973e-16,  3.738711527487007e-17, -1.085967599422828e-18,  1.897518154053632e-20, -9.749651016272722e-23, -6.476304608181171e-24,  1.978024409334463e-02,
 -1.798281516382493e-04,  1.633949318278378e-06, -1.476649826610861e-08,  1.284946948466133e-10, -8.850535086775116e-13, -2.755383706201965e-15,  3.428661963170872e-16,
 -9.947237056160132e-18,  1.741025605230388e-19, -9.093974464246692e-22, -5.886401757817883e-23,  5.538886848613996e-02, -5.035565062714918e-04,  4.575348086697597e-06,
 -4.134392974255373e-08,  3.594338308758400e-10, -2.457916468363678e-12, -8.586739907781806e-15,  9.897466453661521e-16, -2.864818370817312e-17,  5.031968818806363e-19,
 -2.717278180116842e-21, -1.667879906602204e-22,  1.099275995071618e-01, -9.993829980408484e-04,  9.080293643777921e-06, -8.203607345427258e-08,  7.121394999999723e-10,
 -4.812610619156550e-12, -1.984292796803679e-14,  2.059968801575978e-15, -5.943028919925401e-17,  1.049905578862852e-18, -5.965595931148883e-21, -3.368619939626524e-22,
  1.849360457799808e-01, -1.681303178616047e-03,  1.527573675251290e-05, -1.379700193252251e-07,  1.195038083320730e-09, -7.932339704882432e-12, -4.043037981713380e-14,
  3.707509111349092e-15, -1.065382081197458e-16,  1.898462904584239e-18, -1.157008504552943e-20, -5.796385069170785e-22,  2.828623085925575e-01, -2.571570742440169e-03,
  2.336348279624029e-05, -2.109322035346751e-07,  1.821104681826778e-09, -1.176617171452472e-11, -7.766677132178740e-14,  6.218111380104333e-15, -1.779437009095887e-16,
  3.211438398119514e-18, -2.145703611058240e-20, -9.093463579956963e-22,  4.076351008384425e-01, -3.705897559759122e-03,  3.366725178258717e-05, -3.037754649610768e-07,
  2.610113418672692e-09, -1.617170657341382e-11, -1.461039824283373e-13,  1.015598291092883e-14, -2.896679977604602e-16,  5.327881892740252e-18, -4.008740035660372e-20,
 -1.338201972710351e-21,  5.659530342809169e-01, -5.145171572231024e-03,  4.673864041954723e-05, -4.213268453471137e-07,  3.592962581968158e-09, -2.074030550496216e-11,
 -2.783872816729644e-13,  1.678515347480679e-14, -4.785576084437687e-16,  9.067569906503055e-18, -7.967583035248546e-20, -1.837810795728347e-21,  7.708128157695675e-01,
 -7.007521228957113e-03,  6.364672871087506e-05, -5.728321230539782e-07,  4.820320284167209e-09, -2.411844932733293e-11, -5.651608529304725e-13,  2.965073428545310e-14,
 -8.522569834483434e-16,  1.700109685532007e-17, -1.848094626606675e-19, -2.051842606943201e-21,  1.055624439035721e+00, -9.596580849712219e-03,  8.713421135345470e-05,
 -7.814536491540072e-07,  6.373628663667366e-09, -1.974213623637144e-11, -1.397847999236588e-12,  6.462460992542058e-14, -1.929928237316112e-15,  4.306105102984968e-17,
 -6.539521638936651e-19,  2.588396000137272e-21,  2.112326474996157e-03, -1.853036596690523e-05,  1.625251270615627e-07, -1.422537666957283e-09,  1.225924027668036e-11,
 -9.603345082136690e-14,  3.668769832642900e-16,  1.244226003077420e-17, -5.143222350196342e-19,  1.222995970199021e-20, -1.881253009007984e-22,  7.421081256047549e-25,
  1.908599997784731e-02, -1.674317532517838e-04,  1.468498571960083e-06, -1.285309684071734e-08,  1.107474128828208e-10, -8.665012775153056e-13,  3.259918513626842e-15,
  1.144533114890313e-16, -4.708277086830414e-18,  1.119738101176670e-19, -1.726176038213470e-21,  6.965270440757032e-24,  5.344483894593719e-02, -4.688442330573401e-04,
  4.112089789820860e-06, -3.598968872472280e-08,  3.099914805574578e-10, -2.419308707508707e-12,  8.806879503661445e-15,  3.323831848462143e-16, -1.354259101788328e-17,
  3.221952896681932e-19, -4.989520933724843e-21,  2.106641643993913e-23,  1.060693811788212e-01, -9.304920785979404e-04,  8.161011226490824e-06, -7.142156301883200e-08,
  6.148268179655848e-10, -4.778839646661956e-12,  1.644752052234101e-14,  6.978873982633822e-16, -2.803353248416976e-17,  6.674708809135295e-19, -1.041218518295994e-20,
  4.706373780206236e-23,  1.784452018821407e-01, -1.565407045072238e-03,  1.372949549680916e-05, -1.201421711234521e-07,  1.033359010848045e-09, -7.983127414003029e-12,
  2.508813309183098e-14,  1.270202590655433e-15, -5.008479786290409e-17,  1.194295415877040e-18, -1.883238149502528e-20,  9.330221116786613e-23,  2.729344857037032e-01,
 -2.394310576521032e-03,  2.099916538963014e-05, -1.837294751375067e-07,  1.578345617843554e-09, -1.208481579021959e-11,  3.261209128695592e-14,  2.158478889922231e-15,
 -8.321436074019726e-17,  1.989863482291381e-18, -3.186894616815318e-20,  1.774877034002347e-22,  3.933280685117989e-01, -3.450456224770874e-03,  3.026145013672073e-05,
 -2.647116582624067e-07,  2.269939919971915e-09, -1.714905459075994e-11,  3.467982165454154e-14,  3.575755424557559e-15, -1.343322419063317e-16,  3.229043083120305e-18,
 -5.289888956706758e-20,  3.409340430767999e-22,  5.460894813932595e-01, -4.790542055802998e-03,  4.201314779531106e-05, -3.673886233485241e-07,  3.141660165932996e-09,
 -2.323519423087170e-11,  2.132617768681264e-14,  5.990441492516832e-15, -2.188186092625344e-16,  5.312664435962882e-18, -9.007873089511117e-20,  6.972682368596700e-22,
  7.437593413783193e-01, -6.524572462344057e-03,  5.721784112542399e-05, -5.000693683848543e-07,  4.255839687150583e-09, -3.028919845523402e-11, -3.539326023310806e-14,
  1.067505189881544e-14, -3.794242461882035e-16,  9.404578702741014e-18, -1.688694716966764e-19,  1.660355799368110e-21,  1.018575268719363e+00, -8.935322554692768e-03,
  7.835111694147584e-05, -6.839508196381433e-07,  5.759251042971261e-09, -3.729522911472322e-11, -2.539503899351641e-13,  2.297543613466199e-14, -8.044373333650522e-16,
  2.103292606707425e-17, -4.250111019358543e-19,  5.943082856730190e-21,  2.040701819886103e-03, -1.729525463896899e-05,  1.465699832108815e-07, -1.241187058709586e-09,
  1.044677364915333e-11, -8.455037971845336e-14,  5.412387699409595e-16,  1.677147543087494e-18, -1.963126423734359e-19,  5.885666776684108e-21, -1.225545043303453e-22,
  1.712442861487165e-24,  1.843883293725259e-02, -1.562718751747045e-04,  1.324337375334840e-06, -1.121470102437955e-08,  9.438549798872457e-11, -7.635622471801183e-13,
  4.871499782552827e-15,  1.589614890762827e-17, -1.798045411037655e-18,  5.383741847904990e-20, -1.121796164651471e-21,  1.571330497435158e-23,  5.163263453183065e-02,
 -4.375942922838448e-04,  3.708419962011188e-06, -3.140302277633796e-08,  2.642603838855904e-10, -2.135828689093195e-12,  1.353101220385529e-14,  4.885045319083332e-17,
 -5.176884008634182e-18,  1.546110175318220e-19, -3.226262557044377e-21,  4.542226623245252e-23,  1.024727877299575e-01, -8.684720889269286e-04,  7.359905613705994e-06,
 -6.232242338529841e-08,  5.243405353168972e-10, -4.231511062819006e-12,  2.650187247009305e-14,  1.108537534154087e-16, -1.073055636869257e-17,  3.192799259728816e-19,
 -6.678481617766980e-21,  9.479669809010961e-23,  1.723944959635532e-01, -1.461068705049302e-03,  1.238185522451910e-05, -1.048437186383527e-07,  8.818129343572646e-10,
 -7.100538068175582e-12,  4.370600561328168e-14,  2.212907933654031e-16, -1.919908332421176e-17,  5.685451544951784e-19, -1.193682708813644e-20,  1.714783224349449e-22,
  2.636798489199000e-01, -2.234724968110508e-03,  1.893813943928388e-05, -1.603510894738194e-07,  1.348066887406262e-09, -1.081990686028185e-11,  6.489875536773203e-14,
  4.160194731746102e-16, -3.193587600819275e-17,  9.405529844041863e-19, -1.985960022532477e-20,  2.902179760355381e-22,  3.799911465581318e-01, -3.220478994500729e-03,
  2.729172728192628e-05, -2.310647047381051e-07,  1.941286791557486e-09, -1.550735020806253e-11,  8.939089226720717e-14,  7.651197808604345e-16, -5.155895530002408e-17,
  1.509947663498490e-18, -3.216407681910152e-20,  4.817451223068186e-22,  5.275727623459546e-01, -4.471251900147968e-03,  3.789096457048475e-05, -3.207670567181396e-07,
  2.692236317000638e-09, -2.134829540306448e-11,  1.152171289140744e-13,  1.422038516345610e-15, -8.376474819523639e-17,  2.442018315111338e-18, -5.277166397003114e-20,
  8.200488040829006e-22,  7.185401053907564e-01, -6.089721397167795e-03,  5.160565507651622e-05, -4.367878372598437e-07,  3.659851362356592e-09, -2.865388274693685e-11,
  1.359994089409510e-13,  2.797549047848602e-15, -1.438328863653244e-16,  4.192646633200876e-18, -9.299030821614688e-20,  1.534440282073775e-21,  9.840377513156998e-01,
 -8.339834681199207e-03,  7.067139673837876e-05, -5.979268927218535e-07,  4.992054423613877e-09, -3.798463401897165e-11,  1.222390252157943e-13,  6.550430717364480e-15,
 -2.947449625952433e-16,  8.739055028155398e-18, -2.056631298043337e-19,  3.823748855583771e-21,  1.973775438787385e-03, -1.617955412569839e-05,  1.326251294553500e-07,
 -1.086855567348001e-09,  8.886517414364221e-12, -7.154152590742574e-14,  5.261751321109109e-16, -2.021287403618887e-18, -5.575747608135254e-20,  2.344726615466652e-21,
 -5.902014466388854e-23,  1.112530269278481e-24,  1.783411728355636e-02, -1.461909279616855e-04,  1.198338773289230e-06, -9.820296070545792e-09,  8.029243970414240e-11,
 -6.462934335668585e-13,  4.748179328755196e-15, -1.801164524992889e-17, -5.125518357444329e-19,  2.144321579571171e-20, -5.396437671771100e-22,  1.018174295171525e-23,
  4.993930279397256e-02, -4.093655295363100e-04,  3.355600781072813e-06, -2.749875865087713e-08,  2.248241825927796e-10, -1.809044712336327e-12,  1.326037815176385e-14,
 -4.896716457227336e-17, -1.486398508910963e-18,  6.155156447528914e-20, -1.548439270512618e-21,  2.927218420749899e-23,  9.911211451304500e-02, -8.124479042615054e-04,
  6.659693837365690e-06, -5.457498144395040e-08,  4.461606295687515e-10, -3.588049921477711e-12,  2.620386943805224e-14, -9.248620114784832e-17, -3.113827647353830e-18,
  1.269959346595033e-19, -3.193416239883703e-21,  6.056097202171448e-23,  1.667406875650451e-01, -1.366816925033705e-03,  1.120388611968336e-05, -9.181273482761385e-08,
  7.505040961767508e-10, -6.030697005532094e-12,  4.380212327972940e-14, -1.438856021255387e-16, -5.648333652010852e-18,  2.257997361242414e-19, -5.676161773764264e-21,
  1.081579883559744e-22,  2.550322692782628e-01, -2.090565914668710e-03,  1.713648037545730e-05, -1.404263419372536e-07,  1.147705877375683e-09, -9.211639549685134e-12,
  6.637408844610638e-14, -1.941326263339041e-16, -9.551614739235968e-18,  3.725727078804925e-19, -9.367265966776385e-21,  1.797448403240513e-22,  3.675290526606680e-01,
 -3.012731041388779e-03,  2.469547016348403e-05, -2.023642327934425e-07,  1.653549320754358e-09, -1.324900278142608e-11,  9.434320620043352e-14, -2.248393536401205e-16,
 -1.571010511913490e-17,  5.954196471969451e-19, -1.498949908776944e-20,  2.906477565769837e-22,  5.102706242079128e-01, -4.182820139025776e-03,  3.428663725707508e-05,
 -2.809477608968534e-07,  2.294879298806299e-09, -1.833986229121026e-11,  1.282003839582556e-13, -1.943331458763144e-16, -2.602745639346202e-17,  9.550683411044479e-19,
 -2.413575950107174e-20,  4.757092166744869e-22,  6.949750639420406e-01, -5.696888795166811e-03,  4.669726333921984e-05, -3.826186595288722e-07,  3.123578665595917e-09,
 -2.485318264695228e-11,  1.681694498524617e-13,  1.149141316659113e-17, -4.549259941299406e-17,  1.612891975673871e-18, -4.116657653443610e-20,  8.346246779284419e-22,
  9.517655549252533e-01, -7.801862617258485e-03,  6.395108907313602e-05, -5.239257534511291e-07,  4.272098180947747e-09, -3.367442364699635e-11,  2.112880389447487e-13,
  8.533742169837326e-16, -9.372976486029956e-17,  3.223698601104282e-18, -8.471072412603532e-20,  1.825315942574416e-21,  1.911099897871101e-03, -1.516840941715267e-05,
  1.203909140558944e-07, -9.554538142518230e-10,  7.576621299012766e-12, -5.973023639735698e-14,  4.545377852924420e-16, -2.826512332272623e-18, -3.799913375053849e-21,
  7.734592048147849e-22, -2.379269886396930e-23,  5.313596955065079e-25,  1.726781023621156e-02, -1.370546955416292e-04,  1.087796265795070e-06, -8.633029343156375e-09,
  6.845825354445897e-11, -5.396583890277274e-13,  4.105124851067399e-15, -2.545871277383592e-17, -3.726703573074503e-20,  7.080247368047432e-21, -2.174347302078489e-22,
  4.857122799453267e-24,  4.835352322814615e-02, -3.837821515589411e-04,  3.046059384225584e-06, -2.417426773599578e-08,  1.916942597487703e-10, -1.510946739841183e-12,
  1.148434556151177e-14, -7.082155835390892e-17, -1.214661582057323e-19,  2.036143986924536e-20, -6.232255347949206e-22,  1.392925749915367e-23,  9.596489470756776e-02,
 -7.616738338472572e-04,  6.045365261667712e-06, -4.797736616515281e-08,  3.804357067641035e-10, -2.998031993742917e-12,  2.275780333223348e-14, -1.390628303223682e-16,
 -2.957379369506652e-19,  4.212424328780219e-20, -1.282996370291753e-21,  2.870236108615445e-23,  1.614459808407646e-01, -1.281397513802887e-03,  1.017038200988529e-05,
 -8.071411759875644e-08,  6.399976235481438e-10, -5.042062835170134e-12,  3.820066016669580e-14, -2.302419140619197e-16, -6.337230814888231e-19,  7.515105200325888e-20,
 -2.274155079410469e-21,  5.095535990512888e-23,  2.469339398572566e-01, -1.959915810667958e-03,  1.555573847330859e-05, -1.234526918246059e-07,  9.788283763232163e-10,
 -7.708274308323090e-12,  5.823996758005508e-14, -3.439801075544996e-16, -1.270741251582101e-18,  1.244713844536795e-19, -3.737210266070884e-21,  8.395115572733382e-23,
  3.558584857378089e-01, -2.824450351056622e-03,  2.241748643992706e-05, -1.779072055376276e-07,  1.410478907169726e-09, -1.110089170311413e-11,  8.353589295445306e-14,
 -4.785235172182134e-16, -2.468536520305646e-18,  1.996540556954688e-19, -5.941334291647249e-21,  1.340328474217443e-22,  4.940674236488779e-01, -3.921415131628127e-03,
  3.112400138712348e-05, -2.470000912672305e-07,  1.958036517033456e-09, -1.539644455731247e-11,  1.151493834180175e-13, -6.278993665582622e-16, -4.791050789088510e-18,
  3.210308851487104e-19, -9.464919000707830e-21,  2.151136134189799e-22,  6.729067373886061e-01, -5.340863132214977e-03,  4.239000469718598e-05, -3.364008789318416e-07,
  2.666243047217616e-09, -2.093387590181153e-11,  1.549402168408934e-13, -7.711828440230394e-16, -9.708643192971695e-18,  5.412069118444714e-19, -1.583268066204921e-20,
  3.649923233366241e-22,  9.215430788057122e-01, -7.314289705511035e-03,  5.805277892400688e-05, -4.606813727583003e-07,  3.649883769841017e-09, -2.856841285904177e-11,
  2.067667356301349e-13, -8.098568168351730e-16, -2.286793190364717e-17,  1.063388449881318e-18, -3.114387122798283e-20,  7.427254655368164e-22  };
  constexpr double w[3840] = {  2.968302283923635e-01, -4.268115239376112e-03,  6.897417044285957e-05, -1.163497796936555e-06,  1.969204541656956e-08,
 -3.293748207725426e-10,  5.418882291917955e-12, -8.766592515998998e-14,  1.395723303150878e-15, -2.189745156138463e-17,  3.389053631164636e-19, -5.178906807153212e-21,
  2.787909973404095e-01, -9.449569591071991e-03,  3.181393735225450e-04, -9.511830056578094e-06,  2.601934051724836e-07, -6.649735159186712e-09,  1.608122265872734e-10,
 -3.711300075509768e-12,  8.223719860557596e-14, -1.757646454027380e-15,  3.636270351370752e-17, -7.299696942592916e-19,  2.469142742404652e-01, -1.764297590752233e-02,
  9.521934131638857e-04, -4.211734036938538e-05,  1.626968779972612e-06, -5.669454351599973e-08,  1.817846551673314e-09, -5.435207334361804e-11,  1.529855042851779e-12,
 -4.082635862267345e-14,  1.038632998822041e-15, -2.528513391957189e-17,  2.076226295579504e-01, -2.571539710418750e-02,  2.031239304777614e-03, -1.240367550425253e-04,
  6.353696609318353e-06, -2.848949946654153e-07,  1.147701708496489e-08, -4.226901701209827e-10,  1.440949257618953e-11, -4.589014004039179e-13,  1.375073784280010e-14,
 -3.895983844264062e-16,  1.669829791120040e-01, -3.105990639909540e-02,  3.356990943672765e-03, -2.677957124441194e-04,  1.734188827008332e-05, -9.586785118154334e-07,
  4.665797098540126e-08, -2.041006069273999e-09,  8.144185423940661e-11, -2.997308750638030e-12,  1.026132380053774e-13, -3.287270997780943e-15,  1.290258310337295e-01,
 -3.242410092173494e-02,  4.508151338856927e-03, -4.473712958783816e-04,  3.513438903217748e-05, -2.308155415228523e-06,  1.312712917951968e-07, -6.614925502275607e-09,
  3.003109414989235e-10, -1.243785200466529e-11,  4.745375185330329e-13, -1.679078210496185e-14,  9.545107794007074e-02, -2.985124156195272e-02,  5.045806026009958e-03,
 -5.952232375590586e-04,  5.453617621718509e-05, -4.114668458102266e-06,  2.651794916059757e-07, -1.496777732817408e-08,  7.534331281346153e-10, -3.428777015535612e-11,
  1.425860100577429e-12, -5.458374800698586e-14,  6.624542415313653e-02, -2.413491331216946e-02,  4.710669117493773e-03, -6.327228142555255e-04,  6.515633389796071e-05,
 -5.462248291878099e-06,  3.872363023967666e-07, -2.383108399918854e-08,  1.297673670703977e-09, -6.343716653039319e-11,  2.815955346909833e-12, -1.144007092751821e-13,
  4.049656140266560e-02, -1.627741380823917e-02,  3.499274091183574e-03, -5.135629387893839e-04,  5.731234017675817e-05, -5.167483006823620e-06,  3.913207685812399e-07,
 -2.556770973919035e-08,  1.470016027818403e-09, -7.550367027677260e-11,  3.505811784794551e-12, -1.483696092477531e-13,  1.700198804764639e-02, -7.198311488393952e-03,
  1.631046058665027e-03, -2.513445487819022e-04,  2.932599821058887e-05, -2.753213990432615e-06,  2.162838879693424e-07, -1.460966021461075e-08,  8.657591610210341e-10,
 -4.570557794604415e-11,  2.175861189676285e-12, -9.419400526948610e-14,  2.807798831898882e-01, -3.767272079174953e-03,  5.670605477522352e-05, -8.948110885071100e-07,
  1.422955510144463e-08, -2.243752512340616e-10,  3.487373550598743e-12, -5.338689106548447e-14,  8.051692972064554e-16, -1.197919201404993e-17,  1.759428181992010e-19,
 -2.553849879232188e-21,  2.454481635074520e-01, -7.299151048274000e-03,  2.251813098659362e-04, -6.233636837351097e-06,  1.586972699093020e-07, -3.789658686308355e-09,
  8.591463232158013e-11, -1.863956651013719e-12,  3.892128222273965e-14, -7.855744118596032e-16,  1.537754722838244e-17, -2.926142021161078e-19,  1.889043744746995e-01,
 -1.167751786996949e-02,  5.720273105003977e-04, -2.321935124240047e-05,  8.298114481399933e-07, -2.691388876078058e-08,  8.070539582835821e-10, -2.265652202820575e-11,
  6.008100838333238e-13, -1.515087009086015e-14,  3.652031350308340e-16, -8.444891160924235e-18,  1.298049407287945e-01, -1.404360015716764e-02,  1.004100762580194e-03,
 -5.624523731766839e-05,  2.667682160134277e-06, -1.115275107249524e-07,  4.212317536154377e-09, -1.461203301924357e-10,  4.710312734828961e-12, -1.423433487661257e-13,
  4.059769539694585e-15, -1.097958295132150e-16,  8.124239659968803e-02, -1.348174760573721e-02,  1.329968142919520e-03, -9.804975118070352e-05,  5.920491650817406e-06,
 -3.072749328754876e-07,  1.411830376279944e-08, -5.857660999563631e-10,  2.225808495900417e-11, -7.828035393757038e-13,  2.568957578462275e-14, -7.911537446253330e-16,
  4.742211012655737e-02, -1.092085422262764e-02,  1.409250030518372e-03, -1.310332688874797e-04,  9.712895954664668e-06, -6.058060929361713e-07,  3.287017154627534e-08,
 -1.586763087033809e-09,  6.925660484452060e-11, -2.766275139938421e-12,  1.020666274506939e-13, -3.501450873638626e-15,  2.639437909169792e-02, -7.778761865395485e-03,
  1.246164950243446e-03, -1.401734739768980e-04,  1.230986454000444e-05, -8.940629979387818e-07,  5.567189969024655e-08, -3.045728268032457e-09,  1.490091602722921e-10,
 -6.606839804381371e-12,  2.682563328217349e-13, -1.004630522336567e-14,  1.414268546661125e-02, -4.978082628794275e-03,  9.403621892230103e-04, -1.226362895561984e-04,
  1.229886775803976e-05, -1.006779220079731e-06,  6.985471692850367e-08, -4.215950012981847e-09,  2.255365823003729e-10, -1.084857424631284e-11,  4.744965820858933e-13,
 -1.901794391225681e-14,  7.058250033782029e-03, -2.792932729041958e-03,  5.911686084572243e-04, -8.553397097026728e-05,  9.422794875003387e-06, -8.397013856935170e-07,
  6.291634535928154e-08, -4.071215248981365e-09,  2.320198769017085e-10, -1.182142440277791e-11,  5.448547486633074e-13, -2.290315458264699e-14,  2.623176062297898e-03,
 -1.105268675348413e-03,  2.491930054774596e-04, -3.821985466725151e-05,  4.439817798621919e-06, -4.151298980586016e-07,  3.248839522368131e-08, -2.186859770766130e-09,
  1.291695617986675e-10, -6.798450781073397e-12,  3.227274587483901e-13, -1.393391895866580e-14,  2.665551349826640e-01, -3.353017966503962e-03,  4.719972914886181e-05,
 -6.989512400832257e-07,  1.047145517660482e-08, -1.560596266023195e-10,  2.296972702053637e-12, -3.335557215638423e-14,  4.776025609814796e-16, -6.754322112000907e-18,
  9.432645608834591e-20, -1.303695923348491e-21,  2.194348696238918e-01, -5.758860754319796e-03,  1.634312898507542e-04, -4.204303453130310e-06,  9.992629546187676e-08,
 -2.235693251609763e-09,  4.762926099411274e-11, -9.735007171532692e-13,  1.919263329460549e-14, -3.664590493486281e-16,  6.797941171530900e-18, -1.227862444190687e-19,
  1.498542544436937e-01, -8.025123117521628e-03,  3.581952466296030e-04, -1.337838577236176e-05,  4.432475377766499e-07, -1.340329105295089e-08,  3.763951798355189e-10,
 -9.932208360299702e-12,  2.483577300785355e-13, -5.922108343005341e-15,  1.353183790282657e-16, -2.973075744509017e-18,  8.626020478514818e-02, -8.124634095709005e-03,
  5.262636788375844e-04, -2.704973099089526e-05,  1.188058539337091e-06, -4.630670682921978e-08,  1.639334478805647e-09, -5.353933027792613e-11,  1.631104788484912e-12,
 -4.673996486302807e-14,  1.267838644789954e-15, -3.270025995066138e-17,  4.292357295648493e-02, -6.308246140074700e-03,  5.662125297235915e-04, -3.847926542752030e-05,
  2.161604854822545e-06, -1.051032348463713e-07,  4.549689267316612e-09, -1.786782289737143e-10,  6.452552518795764e-12, -2.164324941132286e-13,  6.795344282207330e-15,
 -2.007924208777429e-16,  1.912103959123039e-02, -3.996975519809768e-03,  4.757637940413459e-04, -4.124481695298630e-05,  2.873439511422991e-06, -1.695111603879129e-07,
  8.744420271963804e-09, -4.030942016774233e-10,  1.686392446311485e-11, -6.477821783490810e-13,  2.305279403767414e-14, -7.648128330589848e-16,  7.956226844415416e-03,
 -2.189334822343427e-03,  3.300752106509550e-04, -3.519811098976233e-05,  2.947971079070263e-06, -2.052100119273588e-07,  1.229782408070574e-08, -6.498071198874529e-10,
  3.079932670889261e-11, -1.326557537058521e-12,  5.244700376296198e-14, -1.916718691082693e-15,  3.219355913993345e-03, -1.087452800788061e-03,  1.976751248792744e-04,
 -2.490872302878283e-05,  2.422541751922596e-06, -1.929274784898763e-07,  1.305864030868375e-08, -7.706724922791751e-10,  4.039822019926441e-11, -1.907560816282534e-12,
  8.203469315795575e-14, -3.237594076281033e-15,  1.273771738277365e-03, -4.945005215480665e-04,  1.027333483141103e-04, -1.461357794076988e-05,  1.585413443054860e-06,
 -1.393442170536871e-07,  1.031117547750835e-08, -6.597182958040693e-10,  3.721324305735282e-11, -1.878345915968413e-12,  8.583619395745790e-14, -3.580048399326716e-15,
  4.094788254319355e-04, -1.715473192302754e-04,  3.844998350751364e-05, -5.864750786703149e-06,  6.778088722394201e-07, -6.307845925069363e-08,  4.915171966500227e-09,
 -3.295243929334342e-10,  1.939149049021660e-11, -1.017092476646345e-12,  4.812706945424147e-14, -2.071698463624490e-15,  2.538488695144644e-01, -3.006340767305171e-03,
  3.972347837293578e-05, -5.536713612942313e-07,  7.833944288368844e-09, -1.106139089737295e-10,  1.545036864985772e-12, -2.133338395187304e-14,  2.905349924066197e-16,
 -3.915835938859803e-18,  5.204865942191311e-20, -6.876956589755623e-22,  1.987291492077903e-01, -4.629073219203101e-03,  1.212755771682843e-04, -2.909243781959193e-06,
  6.474857610077296e-08, -1.360831878359174e-09,  2.730712001942796e-11, -5.269237259600923e-13,  9.827082712660279e-15, -1.778126710061683e-16,  3.130799915501998e-18,
 -5.375451065680482e-20,  1.226149889692197e-01, -5.698756094845399e-03,  2.327257899743548e-04, -8.020730432796903e-06,  2.469138119772897e-07, -6.974089932838552e-09,
  1.836979447669470e-10, -4.562274681728010e-12,  1.076882613218194e-13, -2.430218902517106e-15,  5.267594670953400e-17, -1.100223572889350e-18,  6.050437573983237e-02,
 -4.948417092268769e-03,  2.909079933249746e-04, -1.373271165517996e-05,  5.589035191761540e-07, -2.031758789896353e-08,  6.743058763290089e-10, -2.073346620385768e-11,
  5.968596132695060e-13, -1.621270048592690e-14,  4.180645131269787e-16, -1.027737128214848e-17,  2.448496164894905e-02, -3.165818257265469e-03,  2.580183330324042e-04,
 -1.613522808148941e-05,  8.419269269858018e-07, -3.829238996307471e-08,  1.559246114756208e-09, -5.787227692931057e-11,  1.983052837337465e-12, -6.333569903702679e-14,
  1.899377222344411e-15, -5.376011453039330e-17,  8.448911170526936e-03, -1.588008899068103e-03,  1.733941304798305e-04, -1.395352184818515e-05,  9.102011434464106e-07,
 -5.061333773376902e-08,  2.474552517045351e-09, -1.086072374365823e-10,  4.343149429878052e-12, -1.600152121126303e-13,  5.478528702005806e-15, -1.753525279204136e-16,
  2.627415313845113e-03, -6.683041146928050e-04,  9.413356876493058e-05, -9.460022944391090e-06,  7.518174346955499e-07, -4.993593291920196e-08,  2.868608433569290e-09,
 -1.458667584771778e-10,  6.675896825952131e-12, -2.784673293389115e-13,  1.069011445921452e-14, -3.802469740597643e-16,  7.879071726718457e-04, -2.533746763364024e-04,
  4.403189152158237e-05, -5.331542015775870e-06,  5.004904621776644e-07, -3.861750800331256e-08,  2.540696009795080e-09, -1.461477362416040e-10,  7.485073591331893e-12,
 -3.460491314151384e-13,  1.459782801152815e-14, -5.660771265595296e-16,  2.395633055935380e-04, -9.085308074339953e-05,  1.845435175222460e-05, -2.572230616345469e-06,
  2.740210260395250e-07, -2.369391172509627e-08,  1.727733721116358e-09, -1.090864001784178e-10,  6.079913213588151e-12, -3.035575956258814e-13,  1.373482396279162e-14,
 -5.676900013791620e-16,  6.481073207019977e-05, -2.696520954019275e-05,  6.001658595840526e-06, -9.094710423320806e-07,  1.044824809845982e-07, -9.670141977444264e-09,
  7.497275429212334e-10, -5.003127480579605e-11,  2.931645525450622e-12, -1.531605668089624e-13,  7.220833262378346e-15, -3.097788595373411e-16,  2.424198049843493e-01,
 -2.713154313336406e-03,  3.376448894464992e-05, -4.441974806769326e-07,  5.949015587511288e-09, -7.976769527783211e-11,  1.059224845383943e-12, -1.394240958657178e-14,
  1.807542470998217e-16, -2.331739539166087e-18,  2.941887354588115e-20, -3.746595448232925e-22,  1.819545632497306e-01, -3.782760356731217e-03,  9.178539422901729e-05,
 -2.059836270865769e-06,  4.305194853665452e-08, -8.521252348129174e-10,  1.614230287972140e-11, -2.946708019833681e-13,  5.208446377638727e-15, -8.946258192104982e-17,
  1.497492381652115e-18, -2.447575216260298e-20,  1.030165681584578e-01, -4.164018990582148e-03,  1.562499796728118e-04, -4.983757857359608e-06,  1.428880095863033e-07,
 -3.777203320681130e-09,  9.347688604093724e-11, -2.188165395625039e-12,  4.881527452695142e-14, -1.043660797904006e-15,  2.147786638248605e-17, -4.267604830205123e-19,
  4.450161617474684e-02, -3.154314756678174e-03,  1.687499298071444e-04, -7.326253174513679e-06,  2.765865027175753e-07, -9.385012949199323e-09,  2.921565297176433e-10,
 -8.460261339673543e-12,  2.301657237146906e-13, -5.926464300245786e-15,  1.452545281178681e-16, -3.402484411815467e-18,  1.498410143538035e-02, -1.694444386414070e-03,
  1.252890657823157e-04, -7.202470243151872e-06,  3.487591954632021e-07, -1.482295542813593e-08,  5.671738967448616e-10, -1.987236001489164e-11,  6.453553204146114e-13,
 -1.960161593639640e-14,  5.607383642571660e-16, -1.518215184426639e-17,  4.080084912363667e-03, -6.832020786607324e-04,  6.811039313998062e-05, -5.068831655288764e-06,
  3.085883138040432e-07, -1.612728417480578e-08,  7.452424033854985e-10, -3.106075331827855e-11,  1.184308981620930e-12, -4.175039436408842e-14,  1.372016781473988e-15,
 -4.227117539043894e-17,  9.539108517366866e-04, -2.218907877007019e-04,  2.898765843480886e-05, -2.729358286568577e-06,  2.048008943726415e-07, -1.292258110235451e-08,
  7.087904503183034e-10, -3.455928272717278e-11,  1.522200511657792e-12, -6.130269543771687e-14,  2.278541862130669e-15, -7.867292092920194e-17,  2.090820104745254e-04,
 -6.341675768770020e-05,  1.045860608868024e-05, -1.209483492467375e-06,  1.090210981822514e-07, -8.113397326345198e-09,  5.167797165793446e-10, -2.887159243387692e-11,
  1.440132557164540e-12, -6.500102404858791e-14,  2.682678875750170e-15, -1.019737793604152e-16,  4.731765020545409e-05, -1.743547983971865e-05,  3.446238638690634e-06,
 -4.687733046348896e-07,  4.886686231087120e-08, -4.144441579461267e-09,  2.970199272287276e-10, -1.846375706522817e-11,  1.014725344047931e-12, -5.002314593852725e-14,
  2.237372765593929e-15, -9.151015640644387e-17,  1.042929398218902e-05, -4.302875856434683e-06,  9.496390357499576e-07, -1.427878153993307e-07,  1.628781554068376e-08,
 -1.497779635586715e-09,  1.154416941963593e-10, -7.662395622340923e-12,  4.467784305983085e-13, -2.323577059970445e-14,  1.090885492614751e-15, -4.661925881450188e-17,
  2.320757956667413e-01, -2.462854636194399e-03,  2.895671577928869e-05, -3.605167253953010e-07,  4.579330251219757e-09, -5.844751614112622e-11,  7.386459552256572e-13,
 -9.302949013062441e-15,  1.145493452642358e-16, -1.428079744414227e-18,  1.698485626093031e-20, -2.057058945860770e-22,  1.681505216483923e-01, -3.136810358846481e-03,
  7.069920347821074e-05, -1.488796423757572e-06,  2.930134378348103e-08, -5.474948436556459e-10,  9.812399664760836e-12, -1.697873393661406e-13,  2.849480964072529e-15,
 -4.653926655547003e-17,  7.417720850403895e-19, -1.155722301286976e-20,  8.852991096675077e-02, -3.119415312557388e-03,  1.080138876813027e-04, -3.198056827096708e-06,
  8.559956942505893e-08, -2.122050318874465e-09,  4.942829761789823e-11, -1.092217125423611e-12,  2.305991982457086e-14, -4.676059122659912e-16,  9.145660569000619e-18,
 -1.730216955352236e-19,  3.411765612337444e-02, -2.092880770062204e-03,  1.022383224365236e-04, -4.089248652697102e-06,  1.434064094373594e-07, -4.546889568281058e-09,
  1.328789027889656e-10, -3.626142915975641e-12,  9.327090252152973e-14, -2.277120099234182e-15,  5.305375868444310e-17, -1.184132332483586e-18,  9.772860864683829e-03,
 -9.615074340762847e-04,  6.452146652501284e-05, -3.408653913581088e-06,  1.531195214983443e-07, -6.078722213425691e-09,  2.184341721614376e-10, -7.219844484107141e-12,
  2.220315839065950e-13, -6.407632068882859e-15,  1.746817085803941e-16, -4.519474024167218e-18,  2.144465111155047e-03, -3.170938480805275e-04,  2.875784032865679e-05,
 -1.973313011651719e-06,  1.118301853680611e-07, -5.479615158852610e-09,  2.387784098097207e-10, -9.429704835304228e-12,  3.420726903049004e-13, -1.151417627573702e-14,
  3.624309949534120e-16, -1.072657047056892e-17,  3.814291510207688e-04, -8.023646320155020e-05,  9.654057215148896e-06, -8.469182237130480e-07,  5.971845899811287e-08,
 -3.564694478503289e-09,  1.859738230315320e-10, -8.664507083849571e-12,  3.660978757170883e-13, -1.419165659240106e-14,  5.092678184963786e-16, -1.702312273925628e-17,
  6.064955970991853e-05, -1.716556243409726e-05,  2.664931368627115e-06, -2.924110546199428e-07,  2.516797510495311e-08, -1.797789273345437e-09,  1.103867891482256e-10,
 -5.966901414259624e-12,  2.888781150576294e-13, -1.268982504596373e-14,  5.109415923881327e-16, -1.898895620643883e-17,  9.903878509261316e-06, -3.521643581406341e-06,
  6.734272981428523e-07, -8.896036534022076e-08,  9.036980675318303e-09, -7.490693782466394e-10,  5.259840870291328e-11, -3.210454649328704e-12,  1.735622417329622e-13,
 -8.430115202775525e-15,  3.720183885550108e-16, -1.503159354846472e-17,  1.712231152949048e-06, -6.991170268554081e-07,  1.527139614058801e-07, -2.274717973998731e-08,
  2.572837109713112e-09, -2.347844593778553e-10,  1.797098544887039e-11, -1.185325757663012e-12,  6.871807532434043e-14, -3.555115090249585e-15,  1.661041636956233e-16,
 -7.067108974164291e-18,  2.226619340177105e-01, -2.247343128776753e-03,  2.503445016866378e-05, -2.957175271276251e-07,  3.568510763482488e-09, -4.347480762727822e-11,
  5.225956449662227e-13, -6.344379102247194e-15,  7.350957781468778e-17, -8.946924339638922e-19,  1.049332610366460e-20, -9.400080684254419e-23,  1.566315692321002e-01,
 -2.635465390527870e-03,  5.532266656862834e-05, -1.096227722797701e-06,  2.036870052839314e-08, -3.601075643603996e-10,  6.118771910612829e-12, -1.005475530637759e-13,
  1.605112642746157e-15, -2.496615194325127e-17,  3.795245984190226e-19, -5.645617855401947e-21,  7.756650832311925e-02, -2.388380769061420e-03,  7.663780724045091e-05,
 -2.112612030989418e-06,  5.291727887068541e-08, -1.232726420884150e-09,  2.707505269031529e-11, -5.656198842875203e-13,  1.131827716420013e-14, -2.179396879024202e-16,
  4.055337263279283e-18, -7.313294399082362e-20,  2.711835435217648e-02, -1.438186825982061e-03,  6.441311047203244e-05, -2.378271344038597e-06,  7.760329590234587e-08,
 -2.302193461783200e-09,  6.322886051058938e-11, -1.627379205811666e-12,  3.960281667895718e-14, -9.171935110435935e-16,  2.032040739398253e-17, -4.322471846895037e-19,
  6.748708280808048e-03, -5.749824561986905e-04,  3.506964404243058e-05, -1.703109945767545e-06,  7.098846448081177e-08, -2.632378071687698e-09,  8.882150270917848e-11,
 -2.768639694698163e-12,  8.059382554015307e-14, -2.208682398947642e-15,  5.734270240552642e-17, -1.416639875194155e-18,  1.220300454553154e-03, -1.580081931835737e-04,
  1.300510438667271e-05, -8.209957246876099e-07,  4.322775567031744e-08, -1.982282714735508e-09,  8.130878732820238e-11, -3.037050177400807e-12,  1.046317761179960e-13,
 -3.356764928973702e-15,  1.010255582175200e-16, -2.867098372676794e-18,  1.679507247392924e-04, -3.158566608949420e-05,  3.477949531486790e-06, -2.828398228244969e-07,
  1.866088899151296e-08, -1.049716163056925e-09,  5.190793810379548e-11, -2.303301924775834e-12,  9.307187392003007e-14, -3.462785390362932e-15,  1.196419699362881e-16,
 -3.861629948343063e-18,  1.937181330528880e-05, -5.054569628486961e-06,  7.323784279470751e-07, -7.572245528150807e-08,  6.187157957625127e-09, -4.220655015168321e-10,
  2.487060136517618e-11, -1.295505120262217e-12,  6.065421234807330e-14, -2.584577305738705e-15,  1.012185054838277e-16, -3.667730498126575e-18,  2.219425642963975e-06,
 -7.550839198734716e-07,  1.387165945179240e-07, -1.769297189660369e-08,  1.742912145965364e-09, -1.406046256299342e-10,  9.638359141996268e-12, -5.758073331855046e-13,
  3.053599162803580e-14, -1.457709797402246e-15,  6.332995823079419e-17, -2.522939624889889e-18,  2.880791173073714e-07, -1.160997837375676e-07,  2.504043350984981e-08,
 -3.687303137984185e-09,  4.127997047149509e-10, -3.732585441988023e-11,  2.833551159458286e-12, -1.855094958274143e-13,  1.068248837661667e-14, -5.492783765977070e-16,
  2.552042895458453e-17, -1.080255669495178e-18,  2.140519265910446e-01, -2.060353269758209e-03,  2.180177665256470e-05, -2.449518297390054e-07,  2.811305965902579e-09,
 -3.282544591272192e-11,  3.735824680412085e-13, -4.432767742885254e-15,  4.812081368991303e-17, -5.291725558540793e-19,  8.454211997828369e-21, -2.374545539182444e-24,
  1.468987169235756e-01, -2.240462589614997e-03,  4.390911847450274e-05, -8.208293312207529e-07,  1.443383102714965e-08, -2.419735178897434e-10,  3.905795629379217e-12,
 -6.105890260117195e-14,  9.288824128685424e-16, -1.377963924178515e-17,  1.999795440708338e-19, -2.850261549737935e-21,  6.909674106579305e-02, -1.863958588057898e-03,
  5.565416429063429e-05, -1.432597275348526e-06,  3.366231630439160e-08, -7.383148347386356e-10,  1.532022626209818e-11, -3.030189219549597e-13,  5.755719349803310e-15,
 -1.053965980495099e-16,  1.866512140607484e-18, -3.216276001131671e-20,  2.224124629770304e-02, -1.018962188979573e-03,  4.203451857001757e-05, -1.435777520980185e-06,
  4.367190167891244e-08, -1.213997498725726e-09,  3.137518598343421e-11, -7.623828086077495e-13,  1.756797887815087e-14, -3.862431873597341e-16,  8.140543851586272e-18,
 -1.651231326863825e-19,  4.903251041981487e-03, -3.602268518154153e-04,  2.002385393859521e-05, -8.945725011965999e-07,  3.462239424848290e-08, -1.199710428814019e-09,
  3.801979185285361e-11, -1.117675297941223e-12,  3.079315405435421e-14, -8.011821463276841e-16,  1.980195235356681e-17, -4.669073001169621e-19,  7.473012735673490e-04,
 -8.406156833460303e-05,  6.272900866720528e-06, -3.637937518263052e-07,  1.777457441483873e-08, -7.618419280648724e-10,  2.937652510905617e-11, -1.036433316898310e-12,
  3.386413773243559e-14, -1.033994022414961e-15,  2.971034654451829e-17, -8.073157560852037e-19,  8.126704583004976e-05, -1.350698182961288e-05,  1.353755859749406e-06,
 -1.016106426567479e-07,  6.249340011450319e-09, -3.301664598843813e-10,  1.542649482239313e-11, -6.500221103467274e-13,  2.504909609010352e-14, -8.920854057817382e-16,
  2.960009803327052e-17, -9.202428676603857e-19,  6.852898717076628e-06, -1.626482483313336e-06,  2.180193358881506e-07, -2.109240846836809e-08,  1.626475647459231e-09,
 -1.054159262934964e-10,  5.934155353618987e-12, -2.966511730399517e-13,  1.338129968075485e-14, -5.512211476139486e-16,  2.093060549496396e-17, -7.373346592378136e-19,
  5.386486743243879e-07, -1.734804933180173e-07,  3.036293135639701e-08, -3.713888409383758e-09,  3.527608236334262e-10, -2.756276012048313e-11,  1.836782180582817e-12,
 -1.070092597651597e-13,  5.548845286286825e-15, -2.595990509813513e-16,  1.107504867898227e-17, -4.340269515038258e-19,  4.996086170587122e-08, -1.980259468188236e-08,
  4.203704810917267e-09, -6.103128338426064e-10,  6.747554409914330e-11, -6.033865395492911e-12,  4.535459522907065e-13, -2.943130681139467e-14,  1.681333757985295e-15,
 -8.583099313952215e-17,  3.961847891786799e-18, -1.667063661886422e-19,  2.061417431044047e-01, -1.896978996338134e-03,  1.911204507187289e-05, -2.047751259020481e-07,
  2.235236455725615e-09, -2.519012366170514e-11,  2.686291481328920e-13, -3.131492011781981e-15,  3.530083938870602e-17, -1.758097519299280e-19,  9.474416752547503e-21,
  3.144853335527655e-23,  1.385821255416348e-01, -1.925000816842681e-03,  3.530015524203071e-05, -6.240368641022129e-07,  1.040886700548028e-08, -1.658000569437216e-10,
  2.547444534946821e-12, -3.794347075719889e-14,  5.510078671902152e-16, -7.817005607064116e-18,  1.080045880333658e-19, -1.486115622536788e-21,  6.243409037443554e-02,
 -1.479339181498679e-03,  4.126493474313806e-05, -9.947036427204825e-07,  2.197998996513444e-08, -4.546828564090114e-10,  8.932527189348479e-12, -1.675077397144177e-13,
  3.022977566473665e-15, -5.282413457156399e-17,  8.879973656162786e-19, -1.467838281895319e-20,  1.874346373313789e-02, -7.413359723094810e-04,  2.831158219001362e-05,
 -8.966134025149301e-07,  2.547388173631341e-08, -6.645364788077274e-10,  1.618597768820753e-11, -3.717218963763114e-13,  8.118016993010978e-15, -1.696418200868549e-16,
  3.401556079875688e-18, -6.585510586157104e-20,  3.725978368143071e-03, -2.351053957644804e-04,  1.195662021722615e-05, -4.919216090973907e-07,  1.769753733588382e-08,
 -5.734639903705207e-10,  1.707868661102305e-11, -4.736566664132825e-13,  1.235303148219817e-14, -3.051676404014205e-16,  7.179155535891206e-18, -1.615322093186840e-19,
  4.893346783022376e-04, -4.745625416770367e-05,  3.212528194771795e-06, -1.710237939849183e-07,  7.749506219103058e-09, -3.102328975157376e-10,  1.123666244178998e-11,
 -3.741180943705998e-13,  1.158135495955649e-14, -3.361973143708796e-16,  9.212215441966563e-18, -2.393880479194124e-19,  4.304864229400085e-05, -6.250800766543312e-06,
  5.679383384115777e-07, -3.920328067462567e-08,  2.240784327692464e-09, -1.108756178443718e-10,  4.881901865832768e-12, -1.948435371982543e-13,  7.142903385659602e-15,
 -2.429160815236768e-16,  7.722523195019022e-18, -2.307304555378494e-19,  2.695223133353385e-06, -5.734765032476892e-07,  7.050481461553075e-08, -6.339240683484232e-09,
  4.587026784250171e-10, -2.810504312104538e-11,  1.504642328884370e-12, -7.189220809839864e-14,  3.112700955286700e-15, -1.235268878034055e-16,  4.533248468515226e-18,
 -1.547899809545238e-19,  1.433203100511515e-07, -4.312757685005959e-08,  7.121701059567588e-09, -8.288966359046844e-10,  7.542588299856655e-11, -5.676657026410168e-12,
  3.660120407121881e-13, -2.070834023198067e-14,  1.046125575158164e-15, -4.780974420793696e-17,  1.997134118989279e-18, -7.679436573346901e-20,  8.999717745415720e-09,
 -3.490982394143427e-09,  7.263000120263992e-10, -1.036016733326943e-10,  1.127866250622793e-11, -9.949975483474590e-13,  7.390095827317042e-14, -4.744822346261373e-15,
  2.684957821230263e-16, -1.359004124348306e-17,  6.224849918850860e-19, -2.601104812800369e-20,  1.988448674776589e-01, -1.753340009512139e-03,  1.685375942990128e-05,
 -1.727190340600257e-07,  1.789447329500820e-09, -1.967074145048498e-11,  1.963428276796244e-13, -2.028372451882351e-15,  3.594389634401657e-17,  2.078070672471584e-19,
  8.750648091411081e-21, -1.011000533672973e-22,  1.314031878584707e-01, -1.669954225205458e-03,  2.871138905922594e-05, -4.810295695007538e-07,  7.627489771758130e-09,
 -1.156510493405430e-10,  1.694851446895936e-12, -2.409297180635835e-14,  3.338318640973220e-16, -4.566456598381947e-18,  5.957404589982981e-20, -7.871742890080153e-22,
  5.710899080078584e-02, -1.191609552504928e-03,  3.117228190432423e-05, -7.055433781519893e-07,  1.470007030066960e-08, -2.871937444995125e-10,  5.353147721718490e-12,
 -9.543301313231749e-14,  1.630911074368130e-15, -2.747381738245548e-17,  4.358757188458795e-19, -6.858789658611008e-21,  1.617156638320078e-02, -5.518404798850828e-04,
  1.961895060451604e-05, -5.773253304199356e-07,  1.535550221025452e-08, -3.764442579913823e-10,  8.655399604951120e-12, -1.881734772635101e-13,  3.894078308978593e-15,
 -7.756761476361455e-17,  1.478940693853824e-18, -2.731525143482608e-20,  2.945281683577852e-03, -1.589974375523560e-04,  7.435543417242203e-06, -2.820631705766381e-07,
  9.446913068888585e-09, -2.865220578626992e-10,  8.025933988873804e-12, -2.101389732427510e-13,  5.188766191669358e-15, -1.217798028708240e-16,  2.726766567237369e-18,
 -5.853936613697694e-20,  3.403679027035820e-04, -2.824871527245117e-05,  1.738718516218754e-06, -8.494628214396177e-08,  3.569972915168009e-09, -1.334502708597326e-10,
  4.538699320094023e-12, -1.425358197455673e-13,  4.177720997452290e-15, -1.152212587998130e-16,  3.008275708961484e-18, -7.468966969507143e-20,  2.483402987637068e-05,
 -3.114356175126806e-06,  2.559179386664563e-07, -1.620092592941844e-08,  8.586506977066326e-10, -3.970408546287848e-11,  1.643931463857631e-12, -6.201660255268407e-14,
  2.158334930539417e-15, -6.994809543729604e-17,  2.126225977406004e-18, -6.092766490090105e-20,  1.180147127614184e-06, -2.216535400586263e-07,  2.479885767561799e-08,
 -2.059185744054994e-09,  1.390795247405686e-10, -8.018130575446078e-12,  4.065113225818134e-13, -1.849204351013888e-14,  7.657162532374503e-16, -2.917543777513133e-17,
  1.031523037207285e-18, -3.403837339475312e-20,  4.232322526301135e-08, -1.171234776257097e-08,  1.804876328158089e-09, -1.981717530563656e-10,  1.715260858433297e-11,
 -1.235937055473703e-12,  7.669812394925382e-14, -4.194890363673307e-15,  2.056116520258483e-16, -9.146150568892787e-18,  3.728804288967593e-19, -1.402751354528883e-20,
  1.700862154660808e-09, -6.412341181360207e-10,  1.300082654878020e-10, -1.813639914730478e-11,  1.936866049230376e-12, -1.680421596924903e-13,  1.230001209552315e-14,
 -7.796275812571065e-16,  4.361620808091437e-17, -2.185288747430210e-18,  9.918602883836676e-20, -4.110675618584601e-21,  1.920886906617238e-01, -1.626342040142311e-03,
  1.494071773138374e-05, -1.469960261827654e-07,  1.439263319786165e-09, -1.550105323427836e-11,  1.571823845674137e-13, -7.047425064577761e-16,  4.785504045632514e-17,
  3.781276915151868e-19, -2.850182326972933e-21, -4.571930043638184e-22,  1.251489089232933e-01, -1.461440342487065e-03,  2.360152423465389e-05, -3.754932582301495e-07,
  5.672239267057544e-09, -8.199969725962244e-11,  1.148018238141901e-12, -1.564033202501262e-14,  2.052035301213618e-16, -2.745659168681951e-18,  3.430419889330217e-20,
 -3.953124313903758e-22,  5.279280919346185e-02, -9.724942598917278e-04,  2.394778159085740e-05, -5.101257977320474e-07,  1.005150474143892e-08, -1.856929745032044e-10,
  3.283961440898570e-12, -5.621254510265936e-14,  8.951108535333466e-16, -1.478051246627296e-17,  2.258274292342114e-19, -3.114008163066931e-21,  1.423945569607347e-02,
 -4.189306296659554e-04,  1.394893230753152e-05, -3.821492651205234e-07,  9.540278029009437e-09, -2.200833746801843e-10,  4.780869725809170e-12, -9.881709682450504e-14,
  1.929980731926649e-15, -3.683047846314038e-17,  6.704328166117423e-19, -1.166814103910838e-20,  2.409952238363339e-03, -1.108588009605542e-04,  4.797732502219964e-06,
 -1.679986017266677e-07,  5.248266202795160e-09, -1.491502735482426e-10,  3.932771494621281e-12, -9.736669076715898e-14,  2.275006337003087e-15, -5.079106862954177e-17,
  1.083229494169136e-18, -2.215752131732441e-20,  2.498814180918096e-04, -1.761553022627278e-05,  9.900286729297344e-07, -4.438748308310574e-08,  1.731374268504798e-09,
 -6.044471339573083e-11,  1.930304657996692e-12, -5.718216782635814e-14,  1.586103787397009e-15, -4.154881925632838e-17,  1.033123021802972e-18, -2.448854250466009e-20,
  1.550472198465701e-05, -1.659976168297369e-06,  1.233463170272447e-07, -7.146384754941992e-09,  3.507034132621506e-10, -1.513075195332743e-11,  5.881871208771247e-13,
 -2.094011007544154e-14,  6.906916550134410e-16, -2.129568094676899e-17,  6.178955493074651e-19, -1.695215296537429e-20,  5.746260197213142e-07, -9.372522021988006e-08,
  9.481898515183599e-09, -7.230692320878601e-10,  4.537441335087137e-11, -2.451094151489852e-12,  1.172296429140830e-13, -5.058862135899823e-15,  1.996601916848193e-16,
 -7.280722405339407e-18,  2.472453353416583e-19, -7.861742819683142e-21,  1.402913732534451e-08, -3.503838245408050e-09,  4.979669044444229e-10, -5.110521049621469e-11,
  4.175654727313307e-12, -2.862013660722985e-13,  1.699801135661635e-14, -8.942562217051027e-16,  4.234068444004893e-17, -1.825945614837892e-18,  7.239585363455628e-20,
 -2.655953920306518e-21,  3.417320915977983e-10, -1.239986787645400e-10,  2.431242303196239e-11, -3.296906806065941e-12,  3.437089396998695e-13, -2.920935579020241e-14,
  2.099996945640142e-15, -1.310362390455447e-16,  7.230324185225106e-18, -3.578551016007317e-19,  1.606627481521026e-20, -6.593966250612386e-22,  1.858117255523519e-01,
 -1.513502878028905e-03,  1.330535742153705e-05, -1.262464669379284e-07,  1.166308949623490e-09, -1.178174840950426e-11,  1.605131728659149e-13,  9.755450246995676e-16,
  5.343144613223687e-17, -2.611095940346715e-19, -3.183953624806645e-20, -8.203035804761516e-22,  1.196542596763617e-01, -1.289224578255434e-03,  1.959049245799248e-05,
 -2.964969947375456e-07,  4.275776737406628e-09, -5.904301026901641e-11,  7.888756108676253e-13, -1.041969401463974e-14,  1.275880187320689e-16, -1.644188517308092e-18,
  2.242342816842918e-20, -1.682515745937071e-22,  4.925074681269836e-02, -8.029209082247652e-04,  1.868119594739444e-05, -3.752129550928900e-07,  7.013155316995420e-09,
 -1.229637829952187e-10,  2.042109593387545e-12, -3.456611975432222e-14,  4.987120677213778e-16, -7.835497393940371e-18,  1.350386415499757e-19, -1.236052571980622e-21,
  1.276114104558635e-02, -3.233856135058221e-04,  1.015164809017678e-05, -2.593131352765240e-07,  6.093372927445940e-09, -1.326283301720517e-10,  2.711131136265286e-12,
 -5.395024621115334e-14,  9.853848415643161e-16, -1.791900595551817e-17,  3.228451040403915e-19, -5.044444610927664e-21,  2.032266294091577e-03, -7.931080334853431e-05,
  3.201537333435426e-06, -1.035600155038179e-07,  3.024598536147930e-09, -8.068427476018560e-11,  2.000982804337816e-12, -4.705090928381147e-14,  1.038212651496105e-15,
 -2.204166437645941e-17,  4.506055899834053e-19, -8.720940201525530e-21,  1.924477642035330e-04, -1.143282616641327e-05,  5.905782063165666e-07, -2.429598339233874e-08,
  8.807326506931462e-10, -2.873687679895777e-11,  8.615379541703555e-13, -2.409937126940970e-14,  6.322516640073773e-16, -1.572750371639966e-17,  3.726374881860885e-19,
 -8.422356583903972e-21,  1.040483706955128e-05, -9.396906933595094e-07,  6.330201758437441e-08, -3.351114881716751e-09,  1.521847085265239e-10, -6.120711698510185e-12,
  2.231301888978214e-13, -7.489241694392785e-15,  2.338135002137148e-16, -6.849580272423374e-18,  1.894595999584304e-19, -4.969191836212876e-21,  3.100057675304447e-07,
 -4.316339389645075e-08,  3.932513883369765e-09, -2.741011445352888e-10,  1.592123583263764e-11, -8.030386604876204e-13,  3.611147862494722e-14, -1.473666502080537e-15,
  5.526791131675929e-17, -1.923187468148821e-18,  6.255263778703255e-20, -1.911421347199580e-21,  5.267759723333585e-09, -1.161678256279762e-09,  1.504710159978207e-10,
 -1.429904179317276e-11,  1.094434042594402e-12, -7.088224947940597e-14,  4.005648496066998e-15, -2.016574763266036e-16,  9.180326764426563e-18, -3.822103273925845e-19,
  1.468141390025915e-20, -5.234403409113651e-22,  7.425892200649190e-11, -2.557354788134785e-11,  4.799539350564087e-12, -6.276809187749945e-13,  6.347874545288747e-14,
 -5.257192368811045e-15,  3.696818459541746e-16, -2.262870189772744e-17,  1.227825003945285e-18, -5.987840907532476e-20,  2.653360051889363e-21, -1.076411493358435e-22,
  1.799614310647190e-01, -1.412819101889543e-03,  1.189530083137822e-05, -1.092487426222283e-07,  9.723336435636785e-10, -7.427682739792821e-12,  2.081871612009645e-13,
  2.218100166354640e-15,  1.242772054320471e-17, -2.238625768352425e-18, -6.441190207125030e-20, -4.356106227722340e-22,  1.147898069030309e-01, -1.145653006107403e-03,
  1.640711444513464e-05, -2.365942921170835e-07,  3.262788602170020e-09, -4.319847335656861e-11,  5.465467894044339e-13, -7.123085497112362e-15,  8.308041959536163e-17,
 -8.624358788691790e-19,  1.714579151843051e-20, -1.034861583466389e-22,  4.631191270847757e-02, -6.697451009330038e-04,  1.477854555782717e-05, -2.803133801465424e-07,
  4.973932184526337e-09, -8.398968038619276e-11,  1.262182972156494e-12, -2.216639777304948e-14,  3.033991133575550e-16, -3.249075256502047e-18,  9.872336617719504e-20,
 -6.330136129706783e-22,  1.161241733654821e-02, -2.531430018036895e-04,  7.547507313035337e-06, -1.799607230412438e-07,  3.985297603995486e-09, -8.264179646572833e-11,
  1.560573878287214e-12, -3.061708697358512e-14,  5.287403019307693e-16, -8.444119098653296e-18,  1.705961450794645e-19, -2.316360078691902e-21,  1.759395806619288e-03,
 -5.795436114461747e-05,  2.203299562174748e-06, -6.585532454419982e-08,  1.801128055969266e-09, -4.534073671199985e-11,  1.050442141113377e-12, -2.367596173515395e-14,
  4.944484008611268e-16, -9.818232605216028e-18,  1.974819006565402e-19, -3.580886246485628e-21,  1.546078090135868e-04, -7.672222056081004e-06,  3.677088575436967e-07,
 -1.387282562117128e-08,  4.680263950085921e-10, -1.430690747593659e-11,  4.018497901316067e-13, -1.064468198581057e-14,  2.642109769167199e-16, -6.223549083132817e-18,
  1.410863852957435e-19, -3.034275924661746e-21,  7.452407768557043e-06, -5.604479112997536e-07,  3.443753953463492e-08, -1.663075500575537e-09,  6.989996770682822e-11,
 -2.620991410303161e-12,  8.949354852540751e-14, -2.831573607914702e-15,  8.360120977251034e-17, -2.324032934480483e-18,  6.124838043150511e-20, -1.533673522082898e-21,
  1.842602106026473e-07, -2.150169641332118e-08,  1.763092350085894e-09, -1.118691545336413e-10,  5.998195329693347e-12, -2.817289706608535e-13,  1.187838646035270e-14,
 -4.572365719874997e-16,  1.625247312156788e-17, -5.382911489928541e-19,  1.672774741520428e-20, -4.899936663913752e-22,  2.253539928941421e-09, -4.279531398034338e-10,
  4.998890016396490e-11, -4.358801930717765e-12,  3.102159262912367e-13, -1.886292618747637e-14,  1.008443608589426e-15, -4.833017361515981e-17,  2.105517372435864e-18,
 -8.426412050094341e-20,  3.123409964235696e-21, -1.078307343162957e-22,  1.783837422876557e-11, -5.714534234074219e-12,  1.012806873273455e-12, -1.264476201955712e-13,
  1.230680004586616e-14, -9.869058523843430e-16,  6.752063010927733e-17, -4.036626169703775e-18,  2.145848116484540e-19, -1.027902516751558e-20,  4.483603979337275e-22,
 -1.793721614911366e-23,  1.744925374060726e-01, -1.322645582192029e-03,  1.067369426341333e-05, -9.458756505168869e-08,  8.786254947140180e-10, -1.733646532695627e-12,
  2.601191533203158e-13,  8.200964497612674e-16, -1.146054979236023e-16, -4.661135517202538e-18, -3.860290617164323e-20,  2.057613533684364e-21,  1.104528993316487e-01,
 -1.024926485256480e-03,  1.385483528051255e-05, -1.906514629304592e-07,  2.515282533873327e-09, -3.219848809569238e-11,  3.805384559978919e-13, -4.839247484167050e-15,
  6.304220072036191e-17, -2.972624071417295e-19,  9.949637474829679e-21, -2.619192793353752e-22,  4.384983917470256e-02, -5.637368117913759e-04,  1.184164917786443e-05,
 -2.127153415531680e-07,  3.552094992502617e-09, -6.013039232852293e-11,  7.649500900858375e-13, -1.362833494681682e-14,  2.496046806343981e-16, -1.339810741408698e-20,
  5.601852561210147e-20, -1.600180024326381e-21,  1.070830821469445e-02, -2.004307699711032e-04,  5.721894891528961e-06, -1.276439087272019e-07,  2.646405770767469e-09,
 -5.380177773093913e-11,  9.028097340288351e-13, -1.742328387975658e-14,  3.259430774448117e-16, -3.364343917416495e-18,  8.732957634258222e-20, -1.765949798818031e-21,
  1.558436906812228e-03, -4.306013339075789e-05,  1.559909565992591e-06, -4.311894728720364e-08,  1.100753200579996e-09, -2.657616655653338e-11,  5.652058306366037e-13,
 -1.224673113246162e-14,  2.519794884748491e-16, -4.358581994668879e-18,  8.921291506653034e-20, -1.672235283879677e-21,  1.289027274727010e-04, -5.287927141923134e-06,
  2.381797256562338e-07, -8.235959595731959e-09,  2.583726517834203e-10, -7.457426392268065e-12,  1.949613168469428e-13, -4.901763356878169e-15,  1.162025915236730e-16,
 -2.553622140554505e-18,  5.585247198412145e-20, -1.156863974883660e-21,  5.657626814483715e-06, -3.491028823627599e-07,  1.977676584354594e-08, -8.696995157979158e-10,
  3.382335553307259e-11, -1.185431520088970e-12,  3.782050412716067e-14, -1.128522254157368e-15,  3.154355949137132e-17, -8.295920819263631e-19,  2.084885351871686e-20,
 -4.984329916854001e-22,  1.198043017752877e-07, -1.148075649641441e-08,  8.509516110212334e-10, -4.897186804636367e-11,  2.419135792140928e-12, -1.056649612265970e-13,
  4.166668568092435e-15, -1.510045808426810e-16,  5.077204177576001e-18, -1.596784515804947e-19,  4.731665145936415e-21, -1.325793274923421e-22,  1.100120658917252e-09,
 -1.748448153956572e-10,  1.828255900193040e-11, -1.450481634025077e-12,  9.535568659747389e-14, -5.411747596768367e-15,  2.722220298561596e-16, -1.235862401551213e-17,
  5.128775210697784e-19, -1.964629889294305e-20,  6.999518744145309e-22, -2.331260046514972e-23,  4.864327949745872e-12, -1.408450688893030e-12,  2.317668585106262e-13,
 -2.727578373008125e-14,  2.529836581579817e-15, -1.948949605999949e-16,  1.288949815892839e-17, -7.485636125821338e-19,  3.881000037015361e-20, -1.819048854317132e-21,
  7.784667720499124e-23, -3.062571809423611e-24,  1.693658822274709e-01, -1.241557675110068e-03,  9.622944988067810e-06, -8.046944036938888e-08,  9.054206351087950e-10,
  4.210366220616118e-12,  2.057695599176589e-13, -5.580212742558690e-15, -2.772459648692563e-16, -3.166625135618187e-18,  1.433157003241405e-19,  6.016121550714617e-21,
  1.065612863882656e-01, -9.226008466000153e-04,  1.178872500391482e-05, -1.551045513860506e-07,  1.952810704218680e-09, -2.447138090235778e-11,  2.720669981341042e-13,
 -2.943671391593691e-15,  5.599690736129498e-17, -2.089430113689913e-19, -7.269416974947603e-21, -4.861622944765377e-22,  4.176944290865232e-02, -4.783332802820186e-04,
  9.593296113685768e-06, -1.646185781935378e-07,  2.506872270696942e-09, -4.543718196010655e-11,  4.972193018656796e-13, -5.389490853378223e-15,  2.670376558943465e-16,
  2.160784164509976e-19, -5.947200320217189e-20, -3.560498582064407e-21,  9.989351645170980e-03, -1.601375678983813e-04,  4.412122358259472e-06, -9.287832938285099e-08,
  1.753220108166303e-09, -3.690167704559694e-11,  5.466580116309290e-13, -8.417397024236393e-15,  2.475982832115925e-16, -1.586340370820110e-18, -3.302319083163104e-21,
 -2.383368126602873e-21,  1.408252715475424e-03, -3.238728684668626e-05,  1.132718951043296e-06, -2.912389175873814e-08,  6.812764634413127e-10, -1.633861239974343e-11,
  3.157459653711443e-13, -6.134498496016548e-15,  1.437166954053378e-16, -2.038839678058254e-18,  3.080212077338565e-20, -1.098854108940355e-21,  1.110220627457182e-04,
 -3.717425950599916e-06,  1.599421918910139e-07, -5.081014931350986e-09,  1.467578658566409e-10, -4.076849597842476e-12,  9.852729977889199e-14, -2.306725898922119e-15,
  5.455675387775881e-17, -1.091987661943319e-18,  2.197012814332118e-20, -4.941838606762519e-22,  4.522506183353359e-06, -2.249618997678040e-07,  1.193969632467619e-08,
 -4.778726581613372e-10,  1.712252805215727e-11, -5.656115301099493e-13,  1.680284569502809e-14, -4.709255725464728e-16,  1.258217739080281e-17, -3.109520994267382e-19,
  7.413007379872138e-21, -1.718867842966452e-22,  8.452895899244368e-08, -6.497097091954698e-09,  4.401283185403765e-10, -2.290313872013186e-11,  1.039685168263674e-12,
 -4.228484068419238e-14,  1.555465515845359e-15, -5.297359202494122e-17,  1.684582164403566e-18, -5.016863732732553e-20,  1.415036243095317e-21, -3.790765751252209e-23,
  6.111230445274516e-10, -7.866310439504803e-11,  7.352818692304775e-12, -5.267835263925428e-13,  3.180738139314052e-14, -1.676972686778124e-15,  7.897620539571973e-17,
 -3.381287765022167e-18,  1.331130409952660e-19, -4.860501229553467e-21,  1.658154446862407e-22, -5.308851389973984e-24,  1.550807486740348e-12, -3.897686871617716e-13,
  5.839653737217868e-14, -6.381340555865621e-15,  5.575455619897975e-16, -4.087992620316028e-17,  2.593404114295713e-18, -1.453705190040845e-19,  7.310753867096706e-21,
 -3.337320541671242e-22,  1.395695114510471e-23, -5.381119436195854e-25,  1.645478608719338e-01, -1.168182571099946e-03,  8.747689562737539e-06, -6.511274453355399e-08,
  1.020915056810258e-09,  6.218749673171370e-12, -8.085702995117105e-14, -1.464096045306199e-14, -2.236663249601858e-16,  7.734588035479919e-18,  3.726149102099288e-19,
  1.795509587252308e-21,  1.030484182456945e-01, -8.352399167972667e-04,  1.009987026395126e-05, -1.274447232948334e-07,  1.523009317969300e-09, -1.873832793171096e-11,
  2.129659154579815e-13, -1.368001730602680e-15,  3.848933967668240e-17, -8.679523676934317e-19, -2.219057880145284e-20,  1.087051703547812e-24,  3.999796817553875e-02,
 -4.088717704585220e-04,  7.830546016004831e-06, -1.311642629483338e-07,  1.710174110354523e-09, -3.436613107333925e-11,  4.620396320162793e-13,  2.511424874605763e-15,
  1.943372048430843e-16, -5.181189098333130e-18, -1.933382067022181e-19, -1.098034251474245e-21,  9.412941287630072e-03, -1.288736671426247e-04,  3.443663765639291e-06,
 -7.008298500075847e-08,  1.131677269660695e-09, -2.577358871361181e-11,  4.119399213474879e-13, -1.637324721743382e-15,  1.633271850047207e-16, -3.709022511279439e-18,
 -9.285540720729790e-20, -9.392456571288272e-22,  1.294845581130936e-03, -2.456058931534883e-05,  8.390461929828971e-07, -2.047576725394286e-08,  4.187919424426579e-10,
 -1.036376435129565e-11,  1.985100791272356e-13, -2.560127289021712e-15,  8.188549033881372e-17, -1.651659652649569e-18, -7.274737211980654e-21, -5.039514821876461e-22,
  9.837439589358619e-05, -2.647317145968130e-06,  1.107318583678633e-07, -3.275529448071281e-09,  8.452020635009543e-11, -2.321178642544735e-12,  5.346283119859153e-14,
 -1.056926035067955e-15,  2.670162689869278e-17, -5.543777380394271e-19,  6.922918593216490e-21, -2.117726738215863e-22,  3.782972630918063e-06, -1.484616041927261e-07,
  7.536126044993058e-09, -2.762787517997830e-10,  8.972582571751918e-12, -2.836909171925329e-13,  7.906296196691527e-15, -2.023590903615295e-16,  5.288045553536910e-18,
 -1.252289073204774e-19,  2.653342587291710e-21, -6.260821788129827e-23,  6.417048726487776e-08, -3.845844591192185e-09,  2.426086329694914e-10, -1.141823067636247e-11,
  4.727557208643164e-13, -1.800757426100736e-14,  6.177235927242591e-16, -1.963661679278001e-17,  5.932520081559586e-19, -1.672434576487495e-20,  4.449644545258285e-22,
 -1.147158456712362e-23,  3.836163263868262e-10, -3.848513978582064e-11,  3.240854752673608e-12, -2.084229456929139e-13,  1.149133505980618e-14, -5.614737551366446e-16,
  2.465100993212159e-17, -9.909832028058238e-19,  3.689664137780586e-20, -1.279297076466285e-21,  4.162767499686111e-23, -1.277617202249318e-24,  5.944000693454955e-13,
 -1.227526218377228e-13,  1.643399406848139e-14, -1.639706237859665e-15,  1.332295669860894e-16, -9.200987286122512e-18,  5.549973104102086e-19, -2.980480310185976e-20,
  1.444772682534481e-21, -6.388573570436998e-23,  2.598711103644948e-24, -9.779569652554894e-26,  1.600105477856922e-01, -1.101040746498383e-03,  8.067700667028875e-06,
 -4.803817201986371e-08,  1.089962877632833e-09, -1.091063584876049e-12, -5.291097924256901e-13, -1.459564947151371e-14,  2.978157507983698e-16,  1.918379477088143e-17,
  5.787593439859770e-20, -1.699890048331977e-20,  9.985992019205926e-02, -7.601707768309926e-04,  8.705244270184977e-06, -1.058079458095419e-07,  1.196827564766688e-09,
 -1.398221754739718e-11,  1.860924256071988e-13, -7.858399983104412e-16, -5.393158691759003e-18, -1.385155883827052e-18,  5.565458271257871e-21,  1.211251646705136e-21,
  3.847839430900780e-02, -3.521062809491614e-04,  6.400111469414588e-06, -1.086637382124555e-07,  1.142143551681534e-09, -2.195585558819611e-11,  5.809527813355403e-13,
  4.316295785210366e-15, -1.184532768268256e-16, -1.108900838609913e-17, -2.367010452230229e-20,  9.278801811245118e-21,  8.947606192142419e-03, -1.044162504936468e-04,
  2.696017449517470e-06, -5.556955248004806e-08,  7.137910488663785e-10, -1.599602427223886e-11,  4.140358167582285e-13,  7.428118663091942e-16, -3.329906648869096e-17,
 -6.687724383087365e-18, -1.161332700338516e-20,  4.962066057716888e-21,  1.208613845531534e-03, -1.873131822429496e-05,  6.274840777334856e-07, -1.519421575609007e-08,
  2.546402477199771e-10, -6.221240802787537e-12,  1.540311823257265e-13, -9.678203395564728e-16,  1.540697471763217e-17, -1.981615310937308e-18,  2.198592127949196e-21,
  1.020883159469696e-21,  8.933621806206073e-05, -1.898817121967882e-06,  7.820949947237837e-08, -2.233424476166010e-09,  4.895709203557346e-11, -1.313544918035288e-12,
  3.312807091529698e-14, -4.821555600845783e-16,  1.015842499207187e-17, -3.891863045657880e-19,  3.224186182055848e-21,  4.437081411705999e-23,  3.291658183646579e-06,
 -9.936599453970847e-08,  4.923769837348255e-09, -1.694276947761839e-10,  4.820763617221897e-12, -1.463587636471882e-13,  4.051334092573808e-15, -8.918461120971302e-17,
  2.174227091527073e-18, -5.846468035033147e-20,  1.012145514393719e-21, -1.719458899354514e-23,  5.195213455367961e-08, -2.347392089841346e-09,  1.412673635635572e-10,
 -6.084272658151439e-12,  2.254275411525455e-13, -8.089123091950535e-15,  2.629155242010232e-16, -7.642938829296371e-18,  2.186309490864714e-19, -6.017279903652396e-21,
  1.468524315507887e-22, -3.544154968212353e-24,  2.691924735405000e-10, -2.012024495595763e-11,  1.555504977030814e-12, -8.973675612547899e-14,  4.473993375534076e-15,
 -2.027067651776300e-16,  8.289984324248131e-18, -3.107786412697861e-19,  1.092376080695835e-20, -3.595198918877960e-22,  1.108299523040394e-23, -3.251169563770041e-25,
  2.790068055353389e-13, -4.413543814281267e-14,  5.222418307612669e-15, -4.677555424457868e-16,  3.486251743192871e-17, -2.244220372312061e-18,  1.275018716998952e-19,
 -6.505773573953323e-21,  3.018789853680360e-22, -1.285112071870039e-23,  5.056843119540492e-25, -1.848911235669066e-26,  1.557322271071160e-01, -1.038515227697319e-03,
  7.592608510201914e-06, -3.157485860894222e-08,  9.162546197829999e-10, -1.700327142366092e-11, -7.069034495265451e-13,  4.765173812410321e-15,  8.224620296349698e-16,
  4.154638473506272e-18, -7.843979701311479e-19, -1.303757967012416e-20,  9.695091308732051e-02, -6.953017838788307e-04,  7.541979654669657e-06, -8.866158076181412e-08,
  9.597810799154146e-10, -9.841385547712043e-12,  1.551133478201912e-13, -1.604748145248443e-15, -3.801538920375413e-17, -9.906768439816601e-20,  5.282214225184207e-20,
  3.998951850853312e-22,  3.716451350078547e-02, -3.058388800824077e-04,  5.193839083480860e-06, -9.311604608610196e-08,  8.485123543573806e-10, -7.344364766455485e-12,
  5.926351739819823e-13, -5.135047820579413e-15, -4.214088511046737e-16, -2.577222963585501e-18,  4.350393313738731e-19,  7.037400551608140e-21,  8.569100662653850e-03,
 -8.534208792736297e-05,  2.088906274385627e-06, -4.616623835259965e-08,  4.933842104425177e-10, -6.143655583380206e-12,  3.859212342488256e-13, -3.767856098814950e-15,
 -2.202552869480121e-16, -1.924959474171427e-18,  2.455529246979761e-19,  4.197623064913684e-21,  1.142660461518351e-03, -1.437970167814700e-05,  4.661190064891604e-07,
 -1.192354320691007e-08,  1.650065176698630e-10, -2.856702477076042e-12,  1.238429972046032e-13, -1.491433547924528e-15, -4.073043999469951e-17, -7.321577309618904e-19,
  6.081249926463631e-20,  1.042347732501096e-21,  8.283905679733939e-05, -1.368765749952386e-06,  5.536998701894484e-08, -1.621164296775169e-09,  2.968204782971482e-11,
 -6.556378965215550e-13,  2.228920602693278e-14, -3.491640056131190e-16, -5.734688940025405e-19, -1.727484387416572e-19,  8.099502187400480e-21,  1.064818634064790e-22,
  2.961694576058204e-06, -6.698897943682269e-08,  3.271918231161121e-09, -1.111599227270142e-10,  2.696943194065727e-12, -7.292375302968275e-14,  2.261322783850369e-15,
 -4.647790957629934e-17,  6.854907705419753e-19, -2.588694053946396e-20,  7.403426967123917e-22, -4.807279812828681e-25,  4.443321781972055e-08, -1.458361325757319e-09,
  8.549941104159854e-11, -3.489604480040353e-12,  1.127738579427524e-13, -3.722580338999673e-15,  1.209269569471401e-16, -3.220995247778760e-18,  7.945290887578689e-20,
 -2.289930201439517e-21,  5.771289104872743e-23, -1.007871563934907e-24,  2.081648338829119e-10, -1.101678037366219e-11,  8.027419015837717e-13, -4.215156597218249e-14,
  1.867263211614307e-15, -7.814223655226776e-17,  3.015391584241541e-18, -1.045441849125695e-19,  3.419195153321302e-21, -1.082403757035692e-22,  3.171510558970660e-24,
 -8.626131830360364e-26,  1.604265992750870e-13, -1.790004454031673e-14,  1.881909633006408e-15, -1.494260113379265e-16,  1.005599166784282e-17, -5.978335415339136e-19,
  3.173128836377290e-20, -1.523971489744729e-21,  6.717837378583380e-23, -2.737527233552918e-24,  1.035555643791222e-25, -3.656806899417618e-27,  1.516975589987505e-01,
 -9.790721236830710e-04,  7.287714580510163e-06, -2.045873852745775e-08,  4.324524249848565e-10, -2.948812914520774e-11, -2.290258522578929e-13,  2.695618626403005e-14,
  3.709216908675021e-16, -2.723622556023497e-17, -4.816793574614869e-19,  2.664332971806706e-20,  9.428398973122006e-02, -6.389743724438542e-04,  6.564292057169950e-06,
 -7.469508540972331e-08,  7.958700572054296e-10, -6.784004569671384e-12,  9.550218678806156e-14, -2.480496826955663e-15, -6.059551480883698e-18,  1.629750777405463e-18,
  1.694538849354359e-20, -1.773840920986748e-21,  3.601749959308736e-02, -2.685334389203193e-04,  4.155360290311962e-06, -8.001829384779129e-08,  8.244390588345809e-10,
  3.672554342373401e-12,  2.718219174796784e-13, -1.650115197734569e-14, -1.822840621746533e-16,  1.473053927221298e-17,  2.643153791371427e-19, -1.467067596087902e-20,
  8.257827156224983e-03, -7.071892245049150e-05,  1.579718759828204e-06, -3.880214042541212e-08,  4.504642522192032e-10,  1.065144805910198e-12,  1.859770800671774e-13,
 -9.866690174906290e-15, -9.919253273277749e-17,  8.095294209079557e-18,  1.609150107037520e-19, -8.167132589328954e-21,  1.091752229553189e-03, -1.118157271308822e-05,
  3.374693048435025e-07, -9.596003020297472e-09,  1.334136558611335e-10, -5.390309683160403e-13,  6.352084107186926e-14, -2.702917665142861e-15, -1.938270888195569e-17,
  1.805492815014741e-18,  4.333063035876695e-20, -1.931714204313756e-21,  7.813700646289054e-05, -9.963727976150948e-07,  3.841763456292981e-08, -1.225500176249039e-09,
  2.110033885684813e-11, -2.434531844916829e-13,  1.179795750599410e-14, -3.998823457739546e-16, -5.537621655873591e-19,  1.612975317838273e-19,  6.096200657543450e-21,
 -2.208047211610872e-22,  2.738552315056915e-06, -4.550947533457793e-08,  2.157206174474198e-09, -7.713478136536874e-11,  1.685666349329427e-12, -3.244932221221889e-14,
  1.166962120777136e-15, -3.388912220191867e-17,  2.624658489147356e-19,  8.536441752969165e-22,  4.965501290239273e-22, -1.331185947320727e-23,  3.973952470026810e-08,
 -9.159605881691354e-10,  5.243115671560943e-11, -2.149475913259096e-12,  6.125307025530752e-14, -1.677375885657547e-15,  5.669286902447738e-17, -1.623493769577635e-18,
  3.005780387658558e-20, -6.513430920980483e-22,  2.700111968449576e-23, -5.942156056481998e-25,  1.743255655696835e-10, -6.207629668570577e-12,  4.350739175094636e-13,
 -2.165762807851151e-14,  8.423116340768937e-16, -3.141419288185561e-17,  1.173728236032516e-18, -3.882815836131832e-20,  1.123981705615355e-21, -3.317475046293467e-23,
  1.009337443675499e-24, -2.580530238209620e-26,  1.105120672445096e-13, -7.979480768005715e-15,  7.624379878197243e-16, -5.388057351355290e-17,  3.211025788323426e-18,
 -1.741482928308525e-19,  8.619700877709417e-21, -3.868598897046713e-22,  1.599966310116943e-23, -6.205677560024054e-25,  2.254316599244846e-26, -7.624775930115564e-28,
  1.478964252164390e-01, -9.216802325992705e-04,  7.064027829650558e-06, -1.828791108488579e-08, -1.483352810383218e-10, -2.556229613972539e-11,  5.328039829240906e-13,
  2.199132939458422e-14, -6.379377321029653e-16, -2.022340357464380e-17,  7.626353675571980e-19,  1.756015760481568e-20,  9.182773698405577e-02, -5.898385423931552e-04,
  5.740216594257870e-06, -6.294536928944198e-08,  6.776061510780691e-10, -5.292266593110174e-12,  3.219077493785648e-14, -1.758173752719952e-15,  4.626667370827172e-17,
  8.355359579774755e-19, -4.728024091294115e-20, -5.594725035695997e-22,  3.500409607590357e-02, -2.389001069348699e-04,  3.277415828903712e-06, -6.604743378165389e-08,
  9.245305704390774e-10,  4.521165038373273e-12, -1.857334441506210e-13, -1.322159261334777e-14,  3.635185922004702e-16,  1.088896882758935e-17, -4.171518575856408e-19,
 -9.556493832067484e-21,  7.997454516749833e-03, -5.981843386265077e-05,  1.158562137266519e-06, -3.127842703699645e-08,  4.934123893802319e-10,  2.148927270961913e-12,
 -8.665097220794142e-14, -7.935239791437092e-15,  2.088334196177978e-16,  6.302579661046318e-18, -2.323364079457278e-19, -5.786593427977570e-21,  1.051746821432291e-03,
 -8.906549022712989e-06,  2.349660339126064e-07, -7.490941076241308e-09,  1.316690460537707e-10,  7.453798228551916e-14, -9.793599978351562e-15, -2.141765062458286e-15,
  5.274161066868019e-17,  1.529361618063247e-18, -5.401310536850711e-20, -1.520195780480756e-21,  7.468077707509360e-05, -7.424053024563008e-07,  2.561610729153321e-08,
 -9.152246419544357e-10,  1.817266289043912e-11, -9.016102519965413e-14,  1.432876293503423e-15, -3.001944777077368e-16,  6.815349916194643e-18,  1.671916571816031e-19,
 -5.632867158414796e-21, -1.975956681031741e-22,  2.585760325364880e-06, -3.153675835163476e-08,  1.376088076424115e-09, -5.413838560864619e-11,  1.245311490575403e-12,
 -1.474683256088131e-14,  3.599378589359599e-16, -2.250805966762750e-17,  4.822871172644079e-19,  6.488998402921347e-21, -2.131826677384462e-22, -1.290381668149164e-23,
  3.677190042077239e-08, -5.851642111930343e-10,  3.161214304736318e-11, -1.377594060434006e-12,  3.812256886011849e-14, -7.690411942062602e-16,  2.236372539018086e-17,
 -8.798119768407826e-19,  1.973399622212270e-20, -8.985142396787510e-23,  2.073671355382557e-24, -4.431295566925354e-25,  1.550813363349742e-10, -3.576881455688337e-12,
  2.394087267040216e-13, -1.198467689968627e-14,  4.248414789819267e-16, -1.309926089806073e-17,  4.551502693336027e-19, -1.601715197240995e-20,  4.388282259934044e-22,
 -9.652868889412128e-24,  2.781084376775158e-25, -9.963878147666359e-27,  8.765610297816893e-14, -3.799343321730718e-15,  3.375697885914493e-16, -2.198386507161327e-17,
  1.149138684476471e-18, -5.514025972265677e-20,  2.538686872446469e-21, -1.078861120910629e-22,  4.143072069711464e-24, -1.487927719094694e-25,  5.185513251742687e-27,
 -1.717784123264375e-28,  1.443212373883357e-01, -8.661196698482712e-04,  6.816170048902333e-06, -2.389495875505527e-08, -4.957633093817836e-10, -8.131970935873391e-12,
  8.001876357124609e-13, -3.457162342776966e-15, -7.496647130006648e-16,  1.280668592001357e-17,  5.999489989543321e-19, -2.042920276295709e-20,  8.955569228472746e-02,
 -5.467617200589888e-04,  5.046527453289730e-06, -5.292196090524764e-08,  5.764326206770086e-10, -4.928780508736823e-12,  5.542101774042509e-15, -1.668941527182417e-16,
  4.273135298293966e-17, -8.738579113465715e-19, -2.509505598472570e-20,  1.180214943087429e-21,  3.409627616128393e-02, -2.155948026883946e-04,  2.575521629897536e-06,
 -5.087257567371355e-08,  9.482598988159780e-10, -2.829769834149447e-12, -3.597615364266228e-13,  1.069869549639393e-15,  4.189791043907315e-16, -7.132032531111547e-18,
 -3.261551006344304e-19,  1.118828403865736e-20,  7.774533083917340e-03, -5.191487349762628e-05,  8.314716316066312e-07, -2.321296339289812e-08,  5.021297846609926e-10,
 -1.704079904615816e-12, -1.956365137161694e-13,  3.318233236924127e-16,  2.444221834600948e-16, -4.014961142117684e-18, -1.913101425046667e-19,  6.329103756525220e-21,
  1.019361271354112e-03, -7.350627146509053e-06,  1.576764353478899e-07, -5.401552834073382e-09,  1.270917918075035e-10, -6.556042453333548e-13, -4.129514905859020e-14,
 -6.105226326286636e-17,  6.191345597944636e-17, -9.706401719702335e-19, -4.786312688993447e-20,  1.513352389394898e-21,  7.205825449056562e-05, -5.766013620997554e-07,
  1.631791191273745e-08, -6.393803410736577e-10,  1.617680670606828e-11, -1.282803003718592e-13, -3.388972405821050e-15, -3.933091601364509e-17,  7.748286760548408e-18,
 -1.147961871266483e-19, -5.670306133472557e-21,  1.686570485891675e-22,  2.477967535232731e-06, -2.280826635959022e-08,  8.372594060743333e-10, -3.628442303896196e-11,
  9.953576718098568e-13, -1.179067203188257e-14, -3.541947146468038e-17, -5.713244084269747e-18,  4.840422019999029e-19, -6.909628624895098e-21, -2.962208901487892e-22,
  8.103674981838120e-24,  3.484563263597072e-08, -3.890382229317561e-10,  1.830779868071354e-11, -8.686482199277987e-13,  2.646928817680653e-14, -4.597534475899737e-16,
  6.024510886123858e-18, -3.123994442838896e-19,  1.480306439915472e-20, -2.290606353707040e-22, -4.806062747981685e-24,  1.132061992967119e-25,  1.438344606941302e-10,
 -2.138027569924866e-12,  1.292987818002349e-13, -6.817018747923273e-15,  2.428244263568962e-16, -6.232899888609485e-18,  1.622327623234764e-19, -6.069848916856338e-21,
  2.122722551020395e-22, -4.457241567701527e-24,  4.421143256909227e-26, -1.467843697689283e-27,  7.654180340625384e-14, -1.907938725904038e-15,  1.561394303223828e-16,
 -9.918960431370227e-18,  4.715877276135094e-19, -1.929694996622674e-20,  7.861134378958045e-22, -3.227199239964048e-23,  1.209838934900672e-24, -3.957951418176367e-26,
  1.213044008703542e-27, -3.885060613982057e-29,  1.409638028747024e-01, -8.128780350432633e-04,  6.479657322418615e-06, -3.215980917863481e-08, -4.859464449977236e-10,
  7.745399486059874e-12,  4.590139063779932e-13, -1.731213517487480e-14, -8.641777628524449e-17,  1.811169904864091e-17, -2.668425377496157e-19, -1.212825452996169e-20,
  8.744557930883916e-02, -5.087804077215592e-04,  4.463573307679533e-06, -4.447964617699989e-08,  4.794666777968376e-10, -4.730822082750571e-12,  1.448386500810545e-14,
  6.027673470488753e-16,  5.188295080525602e-18, -9.273979301113721e-19,  1.682576505718845e-20,  4.702983470319338e-22,  3.327159378097694e-02, -1.971817871867672e-04,
  2.052781800309214e-06, -3.658858916410896e-08,  8.143250024449659e-10, -9.891459243717379e-12, -1.927158673673234e-13,  8.876007154200792e-15,  5.300245237930233e-17,
 -9.963249398459192e-18,  1.471182869736765e-19,  6.599407225024257e-21,  7.578600353394053e-03, -4.624491797462940e-05,  5.992118155390964e-07, -1.568970417296806e-08,
  4.257032343778183e-10, -5.575914621782122e-12, -1.057086586684223e-13,  4.950572177097061e-15,  3.421459487368113e-17, -5.786587952068456e-18,  8.282045284469911e-20,
  3.911695285642135e-21,  9.921181303303109e-04, -6.315255888781276e-06,  1.044584799080261e-07, -3.523898669276865e-09,  1.049135805987162e-10, -1.485312251847547e-12,
 -2.233106284503658e-14,  1.134283491678955e-15,  1.008748690381133e-17, -1.444480491558229e-18,  1.983802037456330e-20,  9.945675717015311e-22,  6.997026130625175e-05,
 -4.725719492962951e-07,  1.009939980057306e-08, -4.054269906919323e-10,  1.283282167979797e-11, -1.997969672841586e-13, -1.858300361104515e-15,  1.150640957624157e-16,
  1.555866136275402e-18, -1.746862671238554e-19,  2.268558973918048e-21,  1.214086247588586e-22,  2.397731023623375e-06, -1.759948242304718e-08,  4.893886542677683e-10,
 -2.231788448644084e-11,  7.459227462535536e-13, -1.310161431865849e-14, -2.749134729275317e-17,  4.339109173706741e-18,  1.255470325169755e-19, -1.011125115115975e-20,
  1.234410595526097e-22,  6.808652299549578e-24,  3.352568062946077e-08, -2.777303133239033e-10,  1.014103964812919e-11, -5.129632663090045e-13,  1.825210696823462e-14,
 -3.752166787470365e-16,  2.484714418667970e-18,  6.474315362439411e-21,  4.915368123106768e-21, -2.640806695745283e-22,  3.225243873386585e-24,  1.460843599042180e-25,
  1.369152323033683e-10, -1.373142615932585e-12,  6.724868267858397e-14, -3.763309544583538e-15,  1.467123411569486e-16, -3.748939434086456e-18,  6.533209019606120e-20,
 -1.555493567592605e-21,  7.870893261157326e-23, -2.917763001469288e-24,  4.627860574955677e-26,  4.749676697379180e-28,  7.080370840777303e-14, -1.030588616810936e-15,
  7.228768850229513e-17, -4.678618548396388e-18,  2.191461582965655e-19, -7.947189633618843e-21,  2.619294019116237e-22, -9.497396017017813e-24,  3.685399464772051e-25,
 -1.265377489282148e-26,  3.481553489297987e-28, -8.333108806904005e-30,  1.378133539265521e-01, -7.627017798817636e-04,  6.053690816294413e-06, -3.826073005866504e-08,
 -2.595270416119326e-10,  1.314283166221302e-11,  1.483028976210187e-14, -1.234886817402986e-14,  3.048628769571288e-16,  3.182059620488989e-18, -3.464919552717508e-19,
  5.718988885807333e-21,  8.547866922191832e-02, -4.750834688398418e-04,  3.972800924082009e-06, -3.754049199682037e-08,  3.896785716444720e-10, -4.187483378036899e-12,
  2.973170634602005e-14,  3.858431808566031e-16, -1.394200264032149e-17, -1.411094407555443e-19,  1.667336939077310e-20, -3.168617130777450e-22,  3.251322174253942e-02,
 -1.823105361392868e-04,  1.684782422543071e-06, -2.530913794840350e-08,  5.901401609263034e-10, -1.162348524210829e-11,  3.593992510009675e-14,  6.318436953531828e-15,
 -1.625323996867295e-16, -1.774671376323731e-18,  1.896903376392871e-19, -3.136052853740031e-21,  7.402167107814187e-03, -4.209767363689618e-05,  4.478055612392837e-07,
 -9.861277979491128e-09,  2.999685266516659e-10, -6.489472849167484e-12,  2.279832902899320e-14,  3.561533129553929e-15, -9.202967105169162e-17, -1.070221336003173e-18,
  1.104135782006552e-19, -1.791109069692256e-21,  9.682977643594132e-04, -5.622591216140122e-06,  7.119864219798757e-08, -2.101145128548305e-09,  7.243010740798841e-11,
 -1.644703786452940e-12,  7.562509860208620e-15,  8.323541640647915e-16, -2.181020917734036e-17, -2.828044263089725e-19,  2.755019509365875e-20, -4.358165064396375e-22,
  6.821526587814074e-05, -4.080605396420742e-07,  6.329601095396420e-09, -2.333626341278426e-10,  8.659185204956210e-12, -2.051038491613078e-13,  1.282108124445442e-15,
  8.847375320014060e-17, -2.372168103004383e-18, -3.735405062953863e-20,  3.309834025751904e-21, -5.053851161021880e-23,  2.333727312007987e-06, -1.457266345043671e-08,
  2.845434133911139e-10, -1.246963444832264e-11,  4.882125099633395e-13, -1.214099194021792e-14,  1.047201301095436e-16,  3.869845477082040e-18, -1.078156107416369e-19,
 -2.468391048312529e-21,  1.870516269094273e-22, -2.726338327777733e-24,  3.254431569305357e-08, -2.168076925839546e-10,  5.501249199897879e-12, -2.774445596651967e-13,
  1.141738620617643e-14, -3.032958459412555e-16,  3.668222407377277e-18,  4.485662355919430e-20, -1.368049442588460e-21, -7.694228948703846e-23,  4.545990217827710e-24,
 -6.368438611698666e-26,  1.322620816476306e-10, -9.810877910743992e-13,  3.394443214419105e-14, -1.941348972260097e-15,  8.499322233965844e-17, -2.502623855376533e-18,
  4.393853427446479e-20, -3.388278290848589e-22,  8.994913557386778e-24, -9.880864386846853e-25,  4.159390994668164e-26, -6.325212841207142e-28,  6.755295282969184e-14,
 -6.274813926084481e-16,  3.284412140322188e-17, -2.173281658311433e-18,  1.069278827526022e-19, -3.859018363977789e-21,  1.083960810914935e-22, -2.872258713534067e-24,
  9.704204896764388e-26, -3.840768342445645e-27,  1.286772325193610e-28, -3.062261645221528e-30,  1.348564242694445e-01, -7.161597579801793e-04,  5.578112164248689e-06,
 -4.038817426931205e-08, -1.527602819695104e-11,  1.047595102506815e-11, -1.929490288115385e-13, -2.866563244624802e-15,  2.407903952017357e-16, -4.755960501324195e-18,
 -5.546393891743056e-20,  5.358914618928726e-21,  8.363918866385418e-02, -4.450031111126181e-04,  3.557093813035068e-06, -3.193411646407697e-08,  3.136735752154348e-10,
 -3.395508844764631e-12,  3.427351175191120e-14, -4.226201229439380e-17, -1.064104471061386e-17,  2.275799826879651e-19,  2.385164359653933e-21, -2.466286961826660e-22,
  3.180921663775216e-02, -1.699037059948822e-04,  1.430344709652990e-06, -1.763051075179221e-08,  3.775048127408219e-10, -9.239892023865517e-12,  1.390924024410121e-13,
  1.248187786811305e-15, -1.286273423122761e-16,  2.572243454911940e-18,  3.049643955879794e-20, -2.928311155043692e-21,  7.240294446846783e-03, -3.891650664630499e-05,
  3.541582267790216e-07, -6.042640228273528e-09,  1.819543783811691e-10, -5.087893945369165e-12,  8.054948514077018e-14,  6.731148985280074e-16, -7.343311483783528e-17,
  1.473377532905157e-18,  1.812993080024878e-20, -1.710179680150496e-21,  9.468115294812264e-04, -5.136558570671472e-06,  5.190273805839381e-08, -1.189103543282589e-09,
  4.281558343936939e-11, -1.265269900606678e-12,  2.083076499088785e-14,  1.400808973949084e-16, -1.766806183497809e-17,  3.566102525406201e-19,  4.670913288056645e-21,
 -4.279535567048978e-22,  6.666949387543037e-05, -3.665672104051347e-07,  4.232489758153536e-09, -1.252803933022843e-10,  5.018795539009138e-12, -1.536382123750585e-13,
  2.646992595508323e-15,  1.140754747062439e-17, -1.983788531131651e-18,  4.033635279985903e-20,  5.909272119050407e-22, -5.147794708616336e-23,  2.279206107705006e-06,
 -1.277947974191894e-08,  1.742878893165780e-10, -6.435009100343002e-12,  2.771051939507463e-13, -8.754633981907336e-15,  1.600878689579036e-16,  1.573980632916415e-19,
 -9.770437810814498e-20,  1.998478317361519e-21,  3.635002297540232e-23, -2.893851511938665e-24,  3.174783680359910e-08, -1.834377622179967e-10,  3.084206415601491e-12,
 -1.381940238153921e-13,  6.301209534512916e-15, -2.065983052796603e-16,  4.107195512628588e-18, -1.479702391401019e-20, -1.699812170888654e-21,  3.432585313852218e-23,
  1.012069352075610e-24, -6.837618024510340e-26,  1.287613718822961e-10, -7.830454558918664e-13,  1.733334046669103e-14, -9.275416686882679e-16,  4.478322880504141e-17,
 -1.552284507588390e-18,  3.507511879452799e-20, -3.594941748383891e-22, -4.130207893719433e-24,  5.182906323276063e-26,  1.110245623237329e-26, -5.627395751847747e-28,
  6.543770685982892e-14, -4.450237949948345e-16,  1.487825882502571e-17, -9.608953311243707e-19,  5.062998872916910e-20, -1.969773802755145e-21,  5.639764096935522e-23,
 -1.213072387160623e-24,  2.438654743767140e-26, -8.045750999250213e-28,  3.603322692176653e-29, -1.278776525840929e-30,  1.320779785015707e-01, -6.734634384734280e-04,
  5.098045255695545e-06, -3.922176625452967e-08,  1.452384105118821e-10,  5.588883552073058e-12, -1.919204469070741e-13,  2.038664276913453e-15,  7.227766897038595e-17,
 -3.801809438636262e-18,  6.782673125178668e-20,  6.124733123838646e-22,  8.191377673400499e-02, -4.179987542568434e-04,  3.201898266102957e-06, -2.741492281468871e-08,
  2.537274017652639e-10, -2.617836656676733e-12,  2.958502502515452e-14, -2.500380876442631e-16, -2.672368533312126e-18,  1.788377877498141e-19, -3.193384856272033e-21,
 -2.693166675363222e-23,  3.115127537590228e-02, -1.592173688207816e-04,  1.249523039872645e-06, -1.288278996013900e-08,  2.268926477799229e-10, -5.858712652564143e-12,
  1.308083839415516e-13, -1.351681590986257e-15, -3.736689073109766e-17,  2.058354255539606e-18, -3.688589173078897e-20, -3.356529393363811e-22,  7.089896263543165e-03,
 -3.633083248285407e-05,  2.961038250616499e-07, -3.838114328841156e-09,  9.989874379923427e-11, -3.143153653399662e-12,  7.476438837732332e-14, -8.055491276161334e-16,
 -2.096344392083833e-17,  1.184241064641774e-18, -2.132251738907003e-20, -1.981122658218870e-22,  9.270194981864084e-04, -4.768512028017845e-06,  4.099792442064803e-08,
 -6.789916648319144e-10,  2.254958456015679e-11, -7.697758536262746e-13,  1.884786583326500e-14, -2.132639503570723e-16, -4.883268522072562e-18,  2.889914677196386e-19,
 -5.238027139163742e-21, -5.045577611945429e-23,  6.526307124195319e-05, -3.375666660901876e-07,  3.120734422972825e-09, -6.611253462461310e-11,  2.576090460038261e-12,
 -9.203941091645942e-14,  2.307164928557614e-15, -2.782694157309189e-17, -5.183284742078864e-19,  3.325037632065347e-20, -6.079450114834207e-22, -6.262304955072457e-24,
  2.230478288860625e-06, -1.163065046627478e-08,  1.185587993820247e-10, -3.197263723623005e-12,  1.392660727420880e-13, -5.141693940191276e-15,  1.323374624947129e-16,
 -1.737600304272067e-18, -2.285460416388490e-20,  1.715315709126273e-21, -3.168865782225053e-23, -3.730009769576439e-25,  3.105497846368677e-08, -1.639638204140231e-10,
  1.911172562426082e-12, -6.530971900214628e-14,  3.095098477320839e-15, -1.178476379298705e-16,  3.144311564799074e-18, -4.635975054375600e-20, -2.886110784172103e-22,
  3.339563083794901e-23, -6.214133163549868e-25, -9.839681174532702e-27,  1.258504687964387e-10, -6.787999469119930e-13,  9.615774876272737e-15, -4.172848682168082e-16,
  2.127815473921721e-17, -8.424480837103302e-19,  2.381504352568722e-20, -4.153810167231407e-22,  1.147818949896446e-24,  1.513951546171904e-25, -2.673705225467907e-27,
 -9.925577001863852e-29,  6.383866879406766e-14, -3.609174340363817e-16,  7.117844674453273e-18, -4.026626070044857e-19,  2.238954794573567e-20, -9.547601636060577e-22,
  3.045996681834124e-23, -7.056111842529124e-25,  1.114221907721398e-26, -1.344092460621631e-28,  4.674317731182200e-30, -2.896370479797342e-31,  1.294627776753292e-01,
 -6.345152368060436e-04,  4.644266133478428e-06, -3.623131576033294e-08,  2.164627522477970e-10,  1.821831904191631e-12, -1.192213448557749e-13,  2.693219228003809e-15,
 -1.577924286658851e-17, -1.217090502429126e-18,  5.083248413409492e-20, -8.805967132245036e-22,  8.029102104103895e-02, -3.936342113234804e-04,  2.895667443763701e-06,
 -2.373804625294950e-08,  2.078760114220410e-10, -1.996423080959224e-12,  2.217558340509826e-14, -2.575068006338436e-16,  1.473076873348857e-18,  5.730227742077109e-20,
 -2.407776993756216e-21,  4.022576863310615e-23,  3.053349587267850e-02, -1.497857116799169e-04,  1.113357733955201e-06, -1.003385196216898e-08,  1.376010529083105e-10,
 -3.250546689496599e-12,  8.528717467614961e-14, -1.650981752887220e-15,  1.017793753821858e-17,  6.519499139803911e-19, -2.765728404465978e-20,  4.798535937638158e-22,
  6.949051707072402e-03, -3.412324514232725e-05,  2.578548003701394e-07, -2.653733619200412e-09,  5.290556563044192e-11, -1.661913097682459e-12,  4.802671680152343e-14,
 -9.615882421471631e-16,  6.301071757706002e-18,  3.703364286152404e-19, -1.599099070215292e-20,  2.792391557762811e-22,  9.085571176755874e-04, -4.468008112542306e-06,
  3.458027297715016e-08, -4.190242504838306e-10,  1.113800170843703e-11, -3.986120937719622e-13,  1.195754141426708e-14, -2.442553004261858e-16,  1.736983848166152e-18,
  8.858475574778784e-20, -3.933917752135474e-21,  6.929162398338478e-23,  6.395853945448039e-05, -3.151952575046984e-07,  2.522910627759515e-09, -3.689901402686289e-11,
  1.220288057190510e-12, -4.695827000651446e-14,  1.441360909258577e-15, -3.006038209740878e-17,  2.375883179248132e-19,  9.871976226069559e-21, -4.586642559716837e-22,
  8.177118618463353e-24,  2.185654117597243e-06, -1.080454846765188e-08,  9.067929076672111e-11, -1.636496551587394e-12,  6.403430969454338e-14, -2.584081352852748e-15,
  8.092216399828790e-17, -1.733340387629150e-18,  1.566552522530867e-20,  4.818669138882593e-22, -2.422703410659521e-23,  4.393639067338592e-25,  3.042572160074835e-08,
 -1.511221528377184e-10,  1.358863881102060e-12, -3.099125238654839e-14,  1.386297378665533e-15, -5.807524649260614e-17,  1.861443844682667e-18, -4.143598373868455e-20,
  4.445029945871885e-22,  8.342587569285140e-24, -4.961547672712313e-25,  9.220274159449896e-27,  1.232641211121966e-10, -6.172136540387929e-13,  6.185137196911497e-15,
 -1.843948685064430e-16,  9.242423968341440e-18, -4.021324421041250e-19,  1.334363333476733e-20, -3.162188763668398e-22,  4.263252591654656e-24,  2.303417958985267e-26,
 -2.677161800973170e-27,  5.133682302279168e-29,  6.248525417021640e-14, -3.184362803063852e-16,  3.917095024783171e-18, -1.635126540099883e-19,  9.196829256170584e-21,
 -4.241599249612071e-22,  1.512028579896975e-23, -4.073594561258078e-25,  7.760051282876902e-27, -8.261043322383484e-29, -7.131760593955811e-32, -4.896979901729155e-33,
  1.269963570551405e-01, -5.990394521824519e-04,  4.231036289748915e-06, -3.260766598349040e-08,  2.299728498382452e-10, -2.199468438485459e-13, -5.510653582934086e-14,
  1.804647234138097e-15, -3.213190718529796e-17,  7.643285329253465e-20,  1.616580590930807e-20, -5.886196830001052e-22,  7.876108682924603e-02, -3.715546141248124e-04,
  2.629536590083981e-06, -2.070487786572943e-08,  1.727191388182046e-10, -1.544077252309629e-12,  1.582296847989827e-14, -1.925085257890852e-16,  2.222034583043395e-18,
 -4.957630306270637e-21, -8.046798200860156e-22,  2.774679392211002e-23,  2.995145132079126e-02, -1.413273400790137e-04,  1.004335222566679e-06, -8.255952410766511e-09,
  8.957234450346706e-11, -1.706506078987709e-12,  4.586375463616350e-14, -1.122391306933656e-15,  1.871487169733786e-17, -5.111066823675404e-20, -8.760146006643973e-21,
  3.209038336169497e-22,  6.816500164426950e-03, -3.217555821995443e-05,  2.301711732192890e-07, -2.019149065089993e-09,  2.916870874982528e-11, -8.010809773029675e-13,
  2.518786515031529e-14, -6.463029399813655e-16,  1.101663357153248e-17, -3.478314141057517e-20, -5.005858693498609e-21,  1.861098661445270e-22,  8.912101161242139e-04,
 -4.208965126205413e-06,  3.040263633112851e-08, -2.911855832655839e-10,  5.523085765596339e-12, -1.854114953284637e-13,  6.193856767008012e-15, -1.621146044087204e-16,
  2.812338713368875e-18, -1.060137300600399e-20, -1.210741521775835e-21,  4.600087077137966e-23,  6.273570889336782e-05, -2.965117189760017e-07,  2.171628172791044e-09,
 -2.327581091330114e-11,  5.643010545750453e-13, -2.138757082976658e-14,  7.383526564969992e-16, -1.961544117865239e-17,  3.475777036267939e-19, -1.609796819562869e-21,
 -1.375179050259199e-22,  5.403844188834096e-24,  2.143782598578678e-06, -1.014356812757770e-08,  7.578264271747383e-11, -9.352132991826625e-13,  2.818223445687155e-14,
 -1.157425956317656e-15,  4.089970424268784e-17, -1.104025497298799e-18,  2.013493293735919e-20, -1.178055640660884e-22, -6.956691450739609e-24,  2.891498520334347e-25,
  2.984105305907643e-08, -1.414360855591144e-10,  1.088583597110704e-12, -1.603839743379212e-14,  5.866117033539037e-16, -2.555542676680249e-17,  9.228258896747142e-19,
 -2.544534246902398e-20,  4.840398481146342e-22, -3.696594579125446e-24, -1.311301134608289e-25,  6.077576718600498e-27,  1.208830834360248e-10, -5.745815698823030e-13,
  4.643078209990561e-15, -8.618678016080631e-17,  3.765657945993732e-18, -1.725788373337996e-19,  6.403097061601569e-21, -1.826596426437877e-22,  3.719417100610115e-24,
 -3.895549530975322e-26, -5.564549182320738e-28,  3.536988667378995e-29,  6.126457735820370e-14, -2.929805397919815e-16,  2.612303274266880e-18, -6.792067600200751e-20,
  3.551920725510598e-21, -1.728438691358914e-22,  6.742307149767856e-24, -2.066259726584320e-25,  4.817911344838790e-27, -7.682357491971100e-29,  4.679462704756519e-31,
  1.326775708898173e-32,  1.246655050192912e-01, -5.666945013707541e-04,  3.861485809496404e-06, -2.901999346830947e-08,  2.158642565013435e-10, -1.046425264912726e-12,
 -1.792017286917925e-14,  9.029446310925467e-16, -2.272568281285570e-17,  3.406239820818016e-19,  4.737908727983058e-23, -1.798384358567778e-22,  7.731543077574128e-02,
 -3.514673974056318e-04,  2.396702170504296e-06, -1.816948284912905e-08,  1.452386836653533e-10, -1.221308868686350e-12,  1.136905775876173e-14, -1.284582644966513e-16,
  1.701881212679295e-18, -1.883733224541331e-20, -2.630707198307315e-23,  9.114025631477902e-24,  2.940161527809869e-02, -1.336668339067395e-04,  9.129038222675793e-07,
 -7.045537845711294e-09,  6.423961847121706e-11, -9.187456858878646e-13,  2.219971494286736e-14, -5.975203654000103e-16,  1.328487992339800e-17, -1.930502965894479e-19,
  2.462313732756558e-23,  9.791017657384684e-23,  6.691337045331572e-03, -3.042420607330327e-05,  2.083041198767786e-07, -1.653239382332034e-09,  1.792343149112256e-11,
 -3.760856048118966e-13,  1.164267518079053e-14, -3.390933804496213e-16,  7.733488415340548e-18, -1.143915555055624e-19,  7.030322205717929e-23,  5.611547536395194e-23,
  8.748403746115782e-04, -3.978454958263467e-06,  2.733862518377734e-08, -2.257727355165014e-10,  2.983828671773800e-12, -8.166120461313067e-14,  2.810208738429777e-15,
 -8.427747045963157e-17,  1.946936796669480e-18, -2.930800835854364e-20,  3.767753336409457e-23,  1.364343003924074e-23,  6.158281979224236e-05, -2.801295349797382e-07,
  1.935036450913601e-09, -1.687129750701349e-11,  2.754293104630530e-13, -9.082518275814486e-15,  3.308567384128452e-16, -1.009572022766214e-17,  2.360375099008575e-19,
 -3.634739972105577e-21,  8.055374041851418e-24,  1.563255189691860e-24,  2.104358653569881e-06, -9.575991522228204e-09,  6.664873294413931e-11, -6.254176023834134e-13,
  1.270012409093520e-14, -4.792808488506923e-16,  1.810977955023674e-17, -5.606930897294690e-19,  1.330329518249314e-20, -2.113968239317868e-22,  7.431503084784879e-25,
  8.034429303531985e-26,  2.929168970885505e-08, -1.333698086062238e-10,  9.388789260477027e-13, -9.750702597746945e-15,  2.477000875239359e-16, -1.035490611686528e-17,
  4.025491659331852e-19, -1.266809221028151e-20,  3.069376180677900e-22, -5.106405666991167e-24,  2.750661474484119e-26,  1.568194481576816e-27,  1.186536552830582e-10,
 -5.407654347835406e-13,  3.879277548833279e-15, -4.671375576725412e-17,  1.500213923488818e-18, -6.821359236387083e-20,  2.728234217384404e-21, -8.790764896655890e-23,
  2.204370625327034e-24, -3.945538315963004e-26,  3.269181695681899e-28,  7.563666666150181e-30,  6.013036907185439e-14, -2.745903877485254e-16,  2.047953369340866e-18,
 -3.163791025437329e-20,  1.324308308500755e-21, -6.543662738931031e-23,  2.730379949782084e-24, -9.223894962041969e-26,  2.485764381790720e-27, -5.124556915161286e-29,
  6.992399120498904e-31, -1.639279302599578e-33,  1.224583859163225e-01, -5.371385647197664e-04,  3.533222761576349e-06, -2.574970096898086e-08,  1.923052263671689e-10,
 -1.244253586436909e-12, -1.040853870096097e-15,  3.611076042346899e-16, -1.170176574793102e-17,  2.507229851557444e-19, -3.289997145419346e-21, -5.710182356923726e-24,
  7.594658097873225e-02, -3.331281760167454e-04,  2.191850156652264e-06, -1.602736825155475e-08,  1.232789072652525e-10, -9.860777861677484e-13,  8.434796260044581e-15,
 -8.447073692229566e-17,  1.071324767594483e-18, -1.503309891652191e-20,  1.558791683504202e-22,  6.993746938747004e-25,  2.888104197592759e-02, -1.266855493992655e-04,
  8.339981319941099e-07, -6.140659786501454e-09,  5.005904282288988e-11, -5.449322519909447e-13,  1.041438087604709e-14, -2.773295804186202e-16,  7.044869304044405e-18,
 -1.421732572261984e-19,  1.835746038432554e-21,  2.885684677915234e-24,  6.572853676631433e-03, -2.883274059479540e-05,  1.899791450135318e-07, -1.414228954423279e-09,
  1.255565339799416e-11, -1.863246311083384e-13,  5.018592036787189e-15, -1.534996074537919e-16,  4.060259179740226e-18, -8.322856628923226e-20,  1.092436954517187e-21,
  1.128185735363220e-24,  8.593478218908886e-04, -3.769875275058136e-06,  2.487185983316379e-08, -1.881206151345400e-10,  1.866273321645132e-12, -3.643516741654261e-14,
  1.171238056734790e-15, -3.772840828320950e-17,  1.013992559254114e-18, -2.099318008571754e-20,  2.806285693098888e-22,  8.918233846956965e-26,  6.049207059758908e-05,
 -2.653955713417597e-07,  1.754196232495964e-09, -1.356845517212556e-11,  1.542020713112818e-13, -3.796716075749926e-15,  1.352740069749987e-16, -4.479002313485784e-18,
  1.217236544766221e-19, -2.547768444446943e-21,  3.489559561209998e-23, -2.303914475061971e-26,  2.067077616622423e-06, -9.069965639984076e-09,  6.011041223124858e-11,
 -4.798446990038963e-13,  6.409153100553068e-15, -1.916305803772952e-16,  7.296449752298447e-18, -2.462255777173582e-19,  6.766853965276051e-21, -1.436953057101984e-22,
  2.035716230204320e-24, -4.090147380218016e-27,  2.877256950341457e-08, -1.262722904773289e-10,  8.402298219944067e-13, -7.022074314992373e-15,  1.135336573789004e-16,
 -4.000106951839930e-18,  1.597843749824455e-19, -5.485042457343840e-21,  1.529199893154336e-22, -3.316693403336349e-24,  4.934619702177288e-26, -1.935885800303759e-28,
  1.165495757993677e-10, -5.116496153970013e-13,  3.427259959922434e-15, -3.077619293964211e-17,  6.273350090412746e-19, -2.551318415017175e-20,  1.061260488992021e-21,
 -3.718727653271271e-23,  1.060219134879655e-24, -2.380995152064497e-26,  3.825908879767711e-28, -2.611052272356214e-30,  5.906277221547094e-14, -2.594452734867862e-16,
  1.761723061667034e-18, -1.809480473019073e-20,  5.015731356358273e-22, -2.342905188188542e-23,  1.020949947947926e-24, -3.709082122463194e-26,  1.107279372591193e-27,
 -2.672504905660883e-29,  4.963448525096586e-31, -5.954506793181863e-33,  1.203644776025030e-01, -5.100583470161811e-04,  3.241869823477108e-06, -2.287048077565137e-08,
  1.678027680855559e-10, -1.182774032130916e-12,  5.006382498435173e-15,  1.062842920196215e-16, -4.944946959151618e-18,  1.303516761772935e-19, -2.484028685956904e-21,
  2.943007803267613e-23,  7.464796524564567e-02, -3.163305876857710e-04,  2.010739287381459e-06, -1.420241964967478e-08,  1.054081800683448e-10, -8.086076091735184e-13,
  6.476844109889517e-15, -5.764183372136539e-17,  6.413537794712103e-19, -9.044147278867776e-21,  1.298468169394651e-22, -1.255385105765685e-24,  2.838719528607362e-02,
 -1.202954514613965e-04,  7.647939849183687e-07, -5.415561398940990e-09,  4.114428170209509e-11, -3.669238414806931e-13,  5.135219145204186e-15, -1.199691290298261e-16,
  3.191612539967522e-18, -7.506957143729309e-20,  1.386152431744340e-21, -1.626867802177716e-23,  6.460459393003757e-03, -2.737762227910069e-05,  1.741085361492845e-07,
 -1.237835891330705e-09,  9.750701492082443e-12, -1.052437438285911e-13,  2.148099758009306e-15, -6.332546519802057e-17,  1.812649016425253e-18, -4.359630677570303e-20,
  8.138904306547409e-22, -9.707364745449757e-24,  8.446526276244958e-04, -3.579469562349467e-06,  2.277363419734789e-08, -1.628639748640918e-10,  1.349363092713318e-12,
 -1.795791413428162e-14,  4.705604402436013e-16, -1.528225693914277e-17,  4.491550644339949e-19, -1.091204707118246e-20,  2.054927745604439e-22, -2.497823389173489e-24,
  5.945757707404490e-05, -2.519761523533998e-07,  1.604144108277289e-09, -1.156801300848582e-11,  1.025246358679377e-13, -1.690286023636194e-15,  5.246614314207998e-17,
 -1.793491569798285e-18,  5.350884268781176e-20, -1.311043939673375e-21,  2.495058218962760e-23, -3.111087318299153e-25,  2.031725195124382e-06, -8.610611106831741e-09,
  5.486643077470976e-11, -4.004042475412113e-13,  3.877415066030476e-15, -7.901495566210232e-17,  2.763525372397746e-18, -9.757798188048369e-20,  2.946166544572647e-21,
 -7.289712236735326e-23,  1.407480415009472e-24, -1.818102580112926e-26,  2.828042735364482e-08, -1.198615801356674e-10,  7.647774693280065e-13, -5.680747068449725e-15,
  6.187700977704948e-17, -1.552602744304776e-18,  5.933280361149899e-20, -2.147111863336901e-21,  6.565401298042844e-23, -1.646663003944410e-24,  3.247957331565385e-26,
 -4.414563902101938e-28,  1.145556737530903e-10, -4.855694565911534e-13,  3.104992453155587e-15, -2.373126439465048e-17,  3.042495553884660e-19, -9.396973672033164e-21,
  3.856638491704090e-22, -1.428985639410895e-23,  4.446697899300011e-25, -1.139896111122727e-26,  2.328604697170050e-28, -3.425044035198620e-30,  5.805195820205885e-14,
 -2.461120706073025e-16,  1.580772026097313e-18, -1.277817301559027e-20,  2.112770489786472e-22, -8.149349798408792e-24,  3.582337637960085e-25, -1.372046249030939e-26,
  4.414756019555940e-28, -1.183885676326395e-29,  2.597639443243600e-31, -4.417984039325320e-33,  1.183744380992604e-01, -4.851772806645654e-04,  2.982775734796789e-06,
 -2.036761258543441e-08,  1.455135655330189e-10, -1.041077340448996e-12,  6.350332982983066e-15,  6.458493945515402e-18, -1.734532677624723e-18,  5.596354582461502e-20,
 -1.290369387798050e-21,  2.242372475440945e-23,  7.341377426188507e-02, -3.008988952839612e-04,  1.849921707361956e-06, -1.263733073026075e-08,  9.067056949710146e-11,
 -6.704796103053656e-13,  5.107759603234617e-15, -4.143588793290670e-17,  3.956885560124530e-19, -4.967182673985035e-21,  7.548494290943339e-23, -1.078309743120105e-24,
  2.791785371418467e-02, -1.144263744305410e-04,  7.035339370683523e-07, -4.810227351033371e-09,  3.481649770920030e-11, -2.745964079519287e-13,  2.867884036586883e-15,
 -5.176163919178435e-17,  1.317909251266599e-18, -3.342288653880986e-20,  7.265095939519065e-22, -1.240189626272962e-23,  6.353644118075871e-03, -2.604166226597706e-05,
  1.601287857624852e-07, -1.096364008961707e-09,  8.046221119165882e-12, -6.965825866901591e-14,  9.911156164840215e-16, -2.497196381737500e-17,  7.287065375408441e-19,
 -1.922407351219696e-20,  4.235554601484117e-22, -7.293369620640803e-24,  8.306872362932419e-04, -3.404754860431174e-06,  2.093860449860020e-08, -1.436542212340863e-10,
  1.075522231356877e-12, -1.048668171419166e-14,  1.949060303965640e-16, -5.818862874774647e-18,  1.785869098940724e-19, -4.781419807175004e-21,  1.061225309719491e-22,
 -1.842179488100975e-24,  5.847449605484319e-05, -2.396725745295442e-07,  1.474236980780608e-09, -1.014373779818851e-11,  7.808103707166869e-14, -8.775996298219011e-16,
  2.034640447860963e-17, -6.697941011272126e-19,  2.110369848159763e-20, -5.704315676833530e-22,  1.275294080823052e-23, -2.236798679225328e-25,  1.998131538129869e-06,
 -8.189945028305343e-09,  5.039119745962205e-11, -3.481691802063129e-13,  2.785115912968667e-15, -3.689737672878987e-17,  1.025377239295163e-18, -3.593026295433088e-20,
  1.152090556487483e-21, -3.141889095997349e-23,  7.089005424918650e-25, -1.261425644682386e-26,  2.781280691273722e-08, -1.140011493041464e-10,  7.017276656521966e-13,
 -4.878551399878659e-15,  4.121939652586649e-17, -6.593575223228849e-19,  2.129168509697915e-20, -7.799819432716202e-22,  2.538672954764699e-23, -6.998247538631058e-25,
  1.599955878799471e-26, -2.908478542816647e-28,  1.126613736446253e-10, -4.617974508319715e-13,  2.844540781062010e-15, -1.997527296211666e-17,  1.833726122248157e-19,
 -3.656333137960660e-21,  1.342795044694804e-22, -5.102357886034108e-24,  1.689007251454692e-25, -4.731777526754296e-27,  1.105271181697078e-28, -2.080567090691600e-30,
  5.709189908296332e-14, -2.340316787993035e-16,  1.443553678787329e-18, -1.034080662286015e-20,  1.099602780958267e-22, -2.896218096320695e-24,  1.200635198820664e-25,
 -4.747027251269777e-27,  1.615518590649734e-28, -4.672785685640800e-30,  1.140669753902287e-31, -2.303107188542538e-33,  1.164799593083758e-01, -4.622546692179406e-04,
  2.751673340824827e-06, -1.819771773709280e-08,  1.262050768265247e-10, -8.912219987661962e-13,  5.996110670211898e-15, -2.505029416912706e-17, -4.424674427117017e-19,
  2.066974749460444e-20, -5.541830701030583e-22,  1.155209066748569e-23,  7.223885051702769e-02, -2.866824288219331e-04,  1.706556151804208e-06, -1.128758849380820e-08,
  7.839962541462850e-11, -5.605315627170571e-13,  4.101599950553094e-15, -3.113646895392868e-17,  2.610845438162051e-19, -2.754163176502067e-21,  3.862060208802218e-23,
 -6.094816144748357e-25,  2.747105202940685e-02, -1.090199189915215e-04,  6.489833054489018e-07, -4.293778589930798e-09,  2.991602886196908e-11, -2.193291175477575e-13,
  1.862462460261978e-15, -2.418507342542714e-17,  5.234866990138196e-19, -1.340083278360858e-20,  3.184974941332736e-22, -6.424987060730200e-24,  6.251959165410884e-03,
 -2.481116737697880e-05,  1.477025156801331e-07, -9.776748605499905e-10,  6.845571104110563e-12, -5.216391161994426e-14,  5.343311906990952e-16, -1.001656338681410e-17,
  2.745069260265404e-19, -7.585346113266448e-21,  1.843749813101939e-22, -3.753211961479050e-24,  8.173927105814165e-04, -3.243863407640425e-06,  1.931177873905278e-08,
 -1.279151328458881e-10,  9.021263362993785e-13, -7.251666646387243e-15,  9.111602884076663e-17, -2.180111869539903e-18,  6.595285799845167e-20, -1.872532717652937e-21,
  4.593739472896077e-23, -9.407120506195512e-25,  5.753865103305061e-05, -2.283455284615946e-07,  1.359500049281455e-09, -9.013540909283396e-12,  6.421835471839191e-14,
 -5.539174258922680e-16,  8.560472247431608e-18, -2.416951916182959e-19,  7.702783080841453e-21, -2.219440971941224e-22,  5.482867633013837e-24, -1.130274637992868e-25,
  1.966152561046741e-06, -7.802818849739387e-09,  4.645973744935651e-11, -3.084525806997734e-13,  2.229497130216647e-15, -2.106895241252732e-17,  3.987718419077081e-19,
 -1.264919807006031e-20,  4.164226573583526e-22, -1.213064720523999e-23,  3.019193164023714e-25, -6.279138099929914e-27,  2.736767388434638e-08, -1.086111396836073e-10,
  6.467799861479574e-13, -4.302807080668717e-15,  3.176314269583180e-17, -3.380597306986904e-19,  7.788372206556959e-21, -2.692404084462139e-22,  9.077400711296443e-24,
 -2.672996959783228e-25,  6.718711645113899e-27, -1.415455771987742e-28,  1.108582426457062e-10, -4.399546830526553e-13,  2.620485165614712e-15, -1.749055896705403e-17,
  1.334874385762789e-19, -1.668173523350636e-21,  4.663111016722306e-23, -1.726199935240981e-24,  5.947277255512909e-26, -1.775903264422544e-27,  4.533054555065173e-29,
 -9.753273461627139e-31,  5.617812079749433e-14, -2.229532717109797e-16,  1.328513863263566e-18, -8.924672887728282e-21,  7.254478433673686e-23, -1.153856592233471e-24,
  3.950211567106821e-26, -1.558558605202162e-27,  5.521482215241335e-29, -1.690669430786902e-30,  4.450478335344989e-32, -9.994797055144197e-34  };
  int offset = -10;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 10;
    if (std::isnan(t)) {
      fill_n(rr+offset, 10, 0.5);
      fill_n(ww+offset, 10, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 10; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=10; ++j) {
        const int boxof = it*120+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
