//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_11.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot11(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[11] = {5.483986957881850e-02,4.951741233503565e-01,1.384655740084600e+00,2.741919940106704e+00,4.597737700485708e+00,
    6.999397469528837e+00,1.001890827595723e+01,1.376930586610168e+01,1.844111968097818e+01,2.440196124238707e+01,3.259498009144084e+01};
  constexpr double aw[11] = {4.435452264349594e-01,2.869714332469075e-01,1.191023609587828e-01,3.114037088442390e-02,4.978399335051669e-03,
    4.648850508842522e-04,2.365512855251061e-05,5.884287563300994e-07,5.966990986059663e-09,1.744339007547982e-11,6.167183424404053e-15};
  constexpr double x[4224] = {  9.317228321983215e-03, -2.016470781270720e-04,  3.257873113172606e-06, -4.650557794732631e-08,  6.174625018523698e-10,
 -7.794956063138119e-12,  9.454276911663593e-14, -1.107377254450525e-15,  1.254554484784902e-17, -1.373699244544964e-19,  1.448345789301863e-21, -1.459954863498270e-23,
  8.289832655768302e-02, -1.730514327203232e-03,  2.595111196782076e-05, -3.247729291447446e-07,  3.461843558776383e-09, -3.005347405745891e-11,  1.711269962643137e-13,
  4.206195111936129e-16, -3.126304816906775e-17,  5.802721757581708e-19, -7.527226131806782e-21,  7.194846602217419e-23,  2.250039047047882e-01, -4.362075582505461e-03,
  5.558168220711867e-05, -4.940237353086402e-07,  1.996456327447544e-09,  2.741706275907260e-11, -7.291683379470070e-13,  8.547981607131324e-15, -3.765484859717601e-17,
 -7.076441231796701e-19,  1.915840029597953e-20, -2.305984088181459e-22,  4.257451488643479e-01, -7.352088461033334e-03,  7.004092515383431e-05, -2.042939167354023e-07,
 -5.366505836317743e-09,  9.314587806012010e-11, -3.854853932286969e-13, -1.003332345355987e-14,  2.009777656135870e-16, -9.499008323741604e-19, -2.416570192176597e-20,
  5.211168222875584e-22,  6.708671926199646e-01, -9.833516046042432e-03,  5.457569592896011e-05,  4.347807536824050e-07, -9.432162692512744e-09,  6.742745526118335e-12,
  1.458848319835428e-12, -1.258117791630539e-14, -1.674245449210906e-16,  3.779955372911284e-18,  2.029100242959124e-21, -7.909398177249843e-22,  9.424878093687387e-01,
 -1.105764157391601e-02,  1.190594238114509e-05,  8.908452397752952e-07, -2.754727451916796e-09, -1.271866365595726e-10,  6.647706482364975e-13,  2.170136423684496e-14,
 -1.644207353713266e-16, -4.026782938434892e-18,  4.115449819256300e-20,  7.785028673036897e-22,  1.220143520134159e+00, -1.062220386689767e-02, -3.792810474985859e-05,
  7.238011892695792e-07,  7.683709562669537e-09, -7.315273276821977e-11, -1.613692461950966e-12,  5.563545527842516e-15,  3.346664464984261e-16,  5.256462260386809e-19,
 -6.659408503151171e-20, -4.464008071109274e-22,  1.482163814382938e+00, -8.618763378573001e-03, -6.919025354644018e-05,  6.936845877933722e-08,  8.871127060945453e-09,
  7.992384933037650e-11, -5.893523932006045e-13, -2.033192582039370e-14, -1.159980536994449e-16,  2.623854677016960e-18,  5.316271768857295e-20,  7.333557095966803e-23,
  1.707351767783604e+00, -5.639706569308683e-03, -6.720167189301174e-05, -4.680100526853061e-07,  7.776221628193446e-10,  7.426212454131676e-11,  1.038511197235393e-12,
  4.546914948091771e-15, -1.045282158657392e-16, -2.560167673672138e-18, -2.377824044743323e-20,  8.415342555517349e-23,  1.876874585086325e+00, -2.618579537429147e-03,
 -3.896073860507266e-05, -4.623544558985216e-07, -4.259290995388514e-09, -2.345425019038867e-11,  1.195577922486150e-13,  5.721506942665185e-15,  9.645315105132450e-17,
  1.055718891621594e-18,  5.928711217720502e-21, -5.507122326173479e-23,  1.976192252268603e+00, -5.343549065834807e-04, -8.885781118830235e-06, -1.291605299854192e-07,
 -1.721849799793249e-09, -2.141650456190748e-11, -2.494306422176647e-13, -2.702775720758392e-15, -2.671357541604892e-17, -2.291938106397210e-19, -1.456482626465332e-21,
 -7.771151902413630e-25,  8.559453988734559e-03, -1.776595077457743e-04,  2.754310295038803e-06, -3.775986801312605e-08,  4.819585357250303e-10, -5.856842464048432e-12,
  6.848614231845976e-14, -7.750115378650683e-16,  8.504525040458157e-18, -9.053032885101370e-20,  9.324421895762554e-22, -9.254153251511603e-24,  7.636807526011807e-02,
 -1.537597129684748e-03,  2.236706789293235e-05, -2.739666400291081e-07,  2.902289096290880e-09, -2.590077349227880e-11,  1.716588299310444e-13, -2.978195889491952e-16,
 -1.508194168361873e-17,  3.367465213855943e-19, -4.794852549755082e-21,  5.208710343782656e-23,  2.084081777672496e-01, -3.940556338437479e-03,  4.986028833795489e-05,
 -4.585658657571871e-07,  2.388398144145000e-09,  1.263425838494690e-11, -5.095800283302426e-13,  7.064397937737644e-15, -5.163841675964126e-17, -1.280444665153097e-19,
  1.027894707286001e-20, -1.687452353263940e-22,  3.974400447803371e-01, -6.802888964186684e-03,  6.713383107067777e-05, -2.758402466649050e-07, -3.615259410946383e-09,
  8.121256265694135e-11, -5.826045101317593e-13, -4.293558853475231e-15,  1.544926552292136e-16, -1.504963411843124e-18, -4.910103695068569e-21,  3.421255055118675e-22,
  6.324357892676068e-01, -9.378584575646278e-03,  5.889783976170808e-05,  2.867182664282811e-07, -8.978316638551867e-09,  3.704714221460462e-11,  1.051772955469602e-12,
 -1.580788313046900e-14, -3.733867115022659e-17,  3.270131905655186e-18, -2.463972866921459e-20, -4.004065913847343e-22,  8.985141379788566e-01, -1.092056946431217e-02,
  2.225103148460779e-05,  8.274809081454446e-07, -5.093291432460969e-09, -1.046561340816653e-10,  1.179561089267269e-12,  1.449541358717369e-14, -2.730071603296605e-16,
 -1.864655653236514e-18,  6.237936900272062e-20,  1.576647242249204e-22,  1.177105651032101e+00, -1.088892079057755e-02, -2.855975415812897e-05,  8.330066243680517e-07,
  5.852245878394437e-09, -1.088034858467037e-10, -1.308970014677129e-12,  1.603456311608347e-14,  3.026745190167126e-16, -2.332958123561167e-18, -7.097427428621537e-20,
  2.827938714791547e-22,  1.446590548002276e+00, -9.166427270395138e-03, -6.745648783706440e-05,  2.231259477237817e-07,  1.028030269802546e-08,  5.863034876817653e-11,
 -1.193497925355531e-12, -2.212555734068040e-14,  1.600565822130306e-17,  4.645002777327063e-18,  4.320059748159160e-20, -5.669331552327553e-22,  1.683682604727801e+00,
 -6.199451053753348e-03, -7.268964172600936e-05, -4.422966060610847e-07,  2.520081919304841e-09,  1.002447433404042e-10,  1.103902189043396e-12, -4.430956472109543e-16,
 -2.120094665042438e-16, -3.333761863164430e-18, -1.193196769687540e-20,  4.913348527634836e-22,  1.865740075248059e+00, -2.953651327354544e-03, -4.493269385953860e-05,
 -5.340386802733772e-07, -4.684748744221812e-09, -1.827706458794508e-11,  3.289729496300347e-13,  9.454962158732931e-15,  1.378044828431541e-16,  1.205552245412524e-18,
  3.920148307130279e-22, -2.168060915256195e-22,  1.973902137008604e+00, -6.121440055360986e-04, -1.061626825667178e-05, -1.604895949464908e-07, -2.216706175232909e-09,
 -2.841559297343539e-11, -3.383960457279177e-13, -3.700738634472539e-15, -3.599012454844194e-17, -2.844821882405114e-19, -1.188725462328371e-21,  1.583633115540472e-23,
  7.890189196215786e-03, -1.573147630240669e-04,  2.343864760679219e-06, -3.090318133250747e-08,  3.796476656170724e-10, -4.445599036987736e-12,  5.015294494055924e-14,
 -5.485416793759982e-16,  5.828942206967891e-18, -6.027077963377692e-20,  6.049673658607469e-22, -5.888247295931515e-24,  7.055580274746449e-02, -1.371059495110705e-03,
  1.934170872182562e-05, -2.314539802472979e-07,  2.424557492880835e-09, -2.192558237626387e-11,  1.581460440676736e-13, -6.193445125636537e-16, -5.909719585230953e-18,
  1.852785946721989e-19, -2.907443122269485e-21,  3.442072832719433e-23,  1.934098034375546e-01, -3.563020341948253e-03,  4.459314591937805e-05, -4.189306421781479e-07,
  2.533832306771664e-09,  2.589491840850140e-12, -3.351161898166747e-13,  5.404273260159888e-15, -5.045039683828703e-17,  1.549445442992857e-19,  4.356156881270228e-21,
 -1.023707807711371e-22,  3.712804344332885e-01, -6.279923655115412e-03,  6.352773367202385e-05, -3.214815765795094e-07, -2.137899085036731e-09,  6.629531144136167e-11,
 -6.418733964886311e-13, -2.286403917321684e-16,  9.987239218841167e-17, -1.458540867258268e-18,  5.852196859864341e-21,  1.538231097289220e-22,  5.958822438655451e-01,
 -8.896017013002196e-03,  6.150502021651497e-05,  1.502126552081195e-07, -8.021063866329009e-09,  5.694448875159756e-11,  6.086031588527627e-13, -1.533641292031795e-14,
  5.951704809612073e-17,  2.053634638431894e-18, -3.336203492208455e-20, -1.533404248586913e-23,  8.552486129547489e-01, -1.070437597745835e-02,  3.162808873202551e-05,
  7.309010229459190e-07, -6.875745858097735e-09, -7.250808950045564e-11,  1.456489136769972e-12,  5.168787799819166e-15, -2.952846627152027e-16,  5.812241475918679e-19,
  5.561733281207403e-20, -4.273134528901046e-22,  1.133158336572117e+00, -1.107599833208183e-02, -1.807873650407695e-05,  9.076982639331282e-07,  3.403648161000360e-09,
 -1.338330169081632e-10, -7.407277160645201e-13,  2.386650670177774e-14,  1.726576633240639e-16, -4.698462613336705e-18, -4.218279384619702e-20,  9.773899732257880e-22,
  1.408866543820161e+00, -9.692494912758537e-03, -6.375898120008979e-05,  3.952278160185775e-07,  1.111728302136880e-08,  2.277507359490157e-11, -1.778673208972867e-12,
 -1.866616571712681e-14,  2.063427391618306e-16,  5.658521190429377e-18,  2.380130532678009e-21, -1.257279257565876e-21,  1.657689331987847e+00, -6.801351320070830e-03,
 -7.768449659609279e-05, -3.845161017850307e-07,  4.784467644072267e-09,  1.257099237603142e-10,  9.781078396542377e-13, -9.187921742997990e-15, -3.339425047880234e-16,
 -3.216412824439044e-18,  2.197640760769847e-20,  1.059658023195933e-21,  1.853164128427498e+00, -3.340045495554455e-03, -5.180129854433336e-05, -6.113905231075950e-07,
 -4.947148542317991e-09, -6.666879112839041e-12,  6.618643994463376e-13,  1.453896281896237e-14,  1.784879688232120e-16,  9.512353537751075e-19, -1.537257626203409e-20,
 -5.281510803721057e-22,  1.971270591488672e+00, -7.054268396705381e-04, -1.277523303542735e-05, -2.009823535527420e-07, -2.875340157990684e-09, -3.792043387160286e-11,
 -4.597347397355949e-13, -5.023533451987965e-15, -4.683061916122771e-17, -3.078332093797713e-19,  3.432948892976315e-22,  6.060523183031073e-23,  7.296220719586865e-03,
 -1.399502903629280e-04,  2.006737102552373e-06, -2.547958212751573e-08,  3.016292928746241e-10, -3.407010519613387e-12,  3.710953429965555e-14, -3.925248887077367e-16,
  4.038787467702327e-18, -4.055965415568467e-20,  3.959211910063729e-22, -3.775943302587461e-24,  6.536433034576161e-02, -1.226808154404346e-03,  1.678319872419397e-05,
 -1.959691401229672e-07,  2.022509234713586e-09, -1.835411741648357e-11,  1.390154383000221e-13, -7.214737116162599e-16, -1.006524695718281e-18,  9.511423466130946e-20,
 -1.695013516596837e-21,  2.147040696300382e-23,  1.798403485761354e-01, -3.225693303748574e-03,  3.980965248836294e-05, -3.783637553014444e-07,  2.516533933915906e-09,
 -3.813732874153800e-12, -2.053661495425382e-13,  3.904911881174211e-15, -4.267343951067832e-17,  2.550831127072976e-19,  1.010138059799865e-21, -5.304080946097794e-23,
  3.471520560200047e-01, -5.787619065566483e-03,  5.950576844696712e-05, -3.459139975939702e-07, -9.648937019733174e-10,  5.112804146532211e-11, -6.110405585932653e-13,
  2.182910055881099e-15,  5.281017157578403e-17, -1.131971262606860e-18,  9.541240366232600e-21,  2.544592392799772e-23,  5.612907119601749e-01, -8.398857367853167e-03,
  6.257731616769956e-05,  3.163902417383545e-08, -6.769523544911277e-09,  6.667230884225293e-11,  2.151424289329520e-13, -1.250287056617285e-14,  1.100060706509523e-16,
  7.843976594015070e-19, -2.849401654826134e-20,  2.051795299765072e-22,  8.129899370999529e-01, -1.041823592671706e-02,  3.969721531190701e-05,  6.112174437806420e-07,
 -7.970011086224772e-09, -3.684974123398358e-11,  1.474887736216673e-12, -3.559655804879648e-15, -2.398354874238151e-16,  2.326894356958668e-18,  2.982462193536509e-20,
 -6.799888785382446e-22,  1.088635100843453e+00, -1.117634145038909e-02, -6.950422449198897e-06,  9.400137860247328e-07,  6.058705383188555e-10, -1.431327160450074e-10,
 -2.234120842388812e-14,  2.645086315261490e-14, -1.545649436510056e-17, -5.420492411449898e-18,  7.544899892212799e-21,  1.176063018055551e-21,  1.369110752478776e+00,
 -1.018055319639674e-02, -5.794191780258036e-05,  5.742670829192281e-07,  1.110821623757943e-08, -2.525272926677784e-11, -2.178795802169320e-12, -8.901555682220160e-15,
  3.972946988992248e-16,  4.532260095793029e-18, -6.024477149994159e-20, -1.462593546238010e-21,  1.629213850495169e+00, -7.439783851932771e-03, -8.175257497489770e-05,
 -2.866860646058654e-07,  7.505908939388437e-09,  1.447913422930563e-10,  5.556166128281782e-13, -2.145657921464001e-14, -4.212853879563404e-16, -1.257276883963187e-18,
  7.893332764791710e-20,  1.454121472174851e-21,  1.838926754882194e+00, -3.785152044178969e-03, -5.961410858474623e-05, -6.905981528804711e-07, -4.885213921724604e-09,
  1.477450675856564e-11,  1.152919959606120e-12,  2.062682937309458e-14,  1.949057499196584e-16, -2.576653509479488e-19, -4.851510953265720e-20, -9.982607296273899e-22,
  1.968228020408350e+00, -8.181197336353912e-04, -1.549016162740743e-05, -2.537055592699821e-07, -3.756396335831891e-09, -5.082130494607313e-11, -6.229838503398732e-13,
 -6.690140546248114e-15, -5.680050772387850e-17, -2.152158001840822e-19,  5.072598825969784e-21,  1.695098393109335e-22,  6.766700276149369e-03, -1.250422521230634e-04,
  1.727837039359381e-06, -2.115373464744047e-08,  2.415752494250138e-10, -2.634913243292557e-12,  2.772874835783639e-14, -2.838875629445618e-16,  2.827705843054674e-18,
 -2.761109157149240e-20,  2.610916292224737e-22, -2.455468135834942e-24,  6.071147655680532e-02, -1.101425715582536e-03,  1.461418456816836e-05, -1.663712726666954e-07,
  1.687147339191893e-09, -1.526106314128165e-11,  1.187945505557169e-13, -7.103095001473485e-16,  1.398534567630242e-18,  4.337184756225279e-20, -9.555184992064122e-22,
  1.274400384927811e-23,  1.675467308822594e-01, -2.924700409931894e-03,  3.550758528477777e-05, -3.389426978929642e-07,  2.399066952117701e-09, -7.576114446937103e-12,
 -1.137335003098791e-13,  2.690156903211217e-15, -3.323069413303714e-17,  2.589791320346039e-19, -5.957136874470404e-22, -2.280456819619897e-23,  3.249271081499960e-01,
 -5.328366587543944e-03,  5.529339820511447e-05, -3.539448462777640e-07, -8.319495006360338e-11,  3.735249367238880e-11, -5.318557646458784e-13,  3.295216321403537e-15,
  1.898288501442442e-17, -7.507893006376320e-19,  9.056952024848139e-21, -3.820551027248351e-23,  5.286964598387101e-01, -7.898458872094156e-03,  6.235171526649101e-05,
 -6.583684754181099e-08, -5.410660314172872e-09,  6.805124287599415e-11, -8.286741324778959e-14, -8.731471371048424e-15,  1.201508542216825e-16, -1.499436211233256e-19,
 -1.787926361248954e-20,  2.536049646252494e-22,  7.719954824964038e-01, -1.007353135424610e-02,  4.624848482027499e-05,  4.796761313132377e-07, -8.365234443668915e-09,
 -3.431543010576701e-12,  1.281666571401106e-12, -9.722302448757358e-15, -1.417657523566471e-16,  2.930190506686616e-18,  1.103147413807117e-21, -5.783933676681170e-22,
  1.043889916418562e+00, -1.118687588428952e-02,  4.294025250788816e-06,  9.270258845347242e-07, -2.203193646851779e-09, -1.350130966002312e-10,  6.830042087387625e-13,
  2.298920604351551e-14, -1.933967635735799e-16, -4.169631984291288e-18,  5.184872154373912e-20,  7.491418693811851e-22,  1.327509304622206e+00, -1.061355943653268e-02,
 -5.001035957258091e-05,  7.450598034156824e-07,  1.006805605280599e-08, -7.896700346636043e-11, -2.229536097501500e-12,  5.838284492975283e-15,  5.026854542759735e-16,
  9.715756336390585e-19, -1.126917179763532e-19, -7.660496479678177e-22,  1.598128062737073e+00, -8.105300112151765e-03, -8.437495607741696e-05, -1.429323536751809e-07,
  1.047845911591894e-08,  1.493764190612335e-10, -2.356414849505520e-13, -3.492837969027994e-14, -3.945334192332557e-16,  3.138391099702317e-18,  1.378196002776872e-19,
  1.027815876462470e-21,  1.822778002747420e+00, -4.296509152023002e-03, -6.835507931730776e-05, -7.646854589062545e-07, -4.262691423025025e-09,  5.005572546137979e-11,
  1.813182704467061e-12,  2.624605869458396e-14,  1.387718392136103e-16, -3.221917746906973e-18, -1.029484874441136e-19, -1.434551153552028e-21,  1.964686865910985e+00,
 -9.553234910840705e-04, -1.893159901752248e-05, -3.228191404159499e-07, -4.938597231758980e-09, -6.823153394670373e-11, -8.365395835451168e-13, -8.574679481398554e-15,
 -5.858394155404585e-17,  1.957737744272283e-19,  1.725444199220365e-20,  4.156398515484714e-22,  6.292656741388221e-03, -1.121730094629291e-04,  1.495554565068569e-06,
 -1.767648823225416e-08,  1.949372203803247e-10, -2.055435829429740e-12,  2.091050728234012e-14, -2.074838957782424e-16,  1.998170577630947e-18, -1.905774815513839e-20,
  1.725574193380079e-22, -1.630320935639965e-24,  5.652757493959876e-02, -9.920613795831844e-04,  1.277010670516858e-05, -1.416704323236991e-07,  1.408857165286868e-09,
 -1.264239681820273e-11,  9.972034941715166e-14, -6.469685102299352e-16,  2.389899568633117e-18,  1.451742486797931e-20, -5.280513181344583e-22,  7.127607117059142e-24,
  1.563911959524833e-01, -2.656268791440966e-03,  3.166516770065928e-05, -3.018945566475548e-07,  2.225764704047070e-09, -9.513579710331655e-12, -5.193729144670467e-14,
  1.769731726523386e-15, -2.452649746684360e-17,  2.205849997585866e-19, -1.209089034117784e-21, -6.915893386171258e-24,  3.044714737890079e-01, -4.902978953919872e-03,
  5.106056745986096e-05, -3.499607970076371e-07,  5.439406753802052e-10,  2.574122386785091e-11, -4.346719068920154e-13,  3.536308368255285e-15, -2.008265668793595e-18,
 -4.302510460367705e-19,  6.832088899660445e-21, -5.744612622926534e-23,  4.980933055251308e-01, -7.404174663709742e-03,  6.108660495854503e-05, -1.417026879920376e-07,
 -4.087118657546545e-09,  6.355372431007358e-11, -2.751928580402202e-13, -5.089787966503377e-15,  1.044750811445261e-16, -6.533169964516885e-19, -7.695774048993021e-21,
  1.990865524738582e-22,  7.324745821738328e-01, -9.682789215466640e-03,  5.120441244515960e-05,  3.468540895238841e-07, -8.150553841305004e-09,  2.364575862542068e-11,
  9.615832930319962e-13, -1.260782813326314e-14, -4.093128667164964e-17,  2.542217645143987e-18, -1.843472914368379e-20, -2.977392680423168e-22,  9.992804632064054e-01,
 -1.110882411224205e-02,  1.512116977717287e-05,  8.712679792207793e-07, -4.691541217138592e-09, -1.117189646024321e-10,  1.220660400593462e-12,  1.485107094441556e-14,
 -3.001414013022493e-16, -1.648703714478165e-18,  6.872779675301385e-20,  6.435526639978390e-24,  1.284315210253059e+00, -1.097527944054367e-02, -4.016441347604440e-05,
  8.906950460315542e-07,  7.976282504240558e-09, -1.286965123237239e-10, -1.842079795265945e-12,  2.157001194506109e-14,  4.518017028556461e-16, -3.830067561555404e-18,
 -1.172451060351881e-19,  6.114705684457187e-22,  1.564350318566133e+00, -8.784087066331580e-03, -8.498758580399294e-05,  4.795948288970829e-08,  1.332343034571347e-08,
  1.307026682289357e-10, -1.365415699202472e-12, -4.461654482783046e-14, -1.750770937455898e-16,  9.134018368216406e-18,  1.489962193848376e-19, -7.450833161672877e-22,
  1.804438653113331e+00, -4.881121423203513e-03, -7.789912669792179e-05, -8.222580010195727e-07, -2.764861909695035e-09,  1.027538915965851e-10,  2.586412142354446e-12,
  2.791069475808550e-14, -6.677793934776327e-17, -8.612661638545103e-18, -1.648692947743234e-19, -1.177457597115594e-21,  1.960536089510785e+00, -1.123726119804213e-03,
 -2.332833232049165e-05, -4.139298933486240e-07, -6.524491399884301e-09, -9.138912800061640e-11, -1.100625486206304e-12, -1.016052306237804e-14, -3.359900520601830e-17,
  1.377789680026382e-18,  4.556675738694515e-20,  9.294401046427817e-22,  5.866621112068016e-03, -1.010069778676374e-04,  1.300877316807796e-06, -1.486094806825274e-08,
  1.584112666205459e-10, -1.616662437885751e-12,  1.590173728013897e-14, -1.533168816512508e-16,  1.420703307146278e-18, -1.341005421863352e-20,  1.140617259536765e-22,
 -1.043625962763432e-24,  5.275340086918413e-02, -8.963358990862146e-04,  1.119737259816155e-05, -1.210274646320394e-07,  1.178521014241176e-09, -1.045749690678065e-11,
  8.272862566305058e-14, -5.656605078061426e-16,  2.597845060231479e-18, -1.397808175450174e-21, -2.888577859316036e-22,  4.244179013962356e-24,  1.462506546524277e-01,
 -2.416847803728778e-03,  2.824965047824913e-05, -2.678568775163484e-07,  2.026613443872372e-09, -1.024714031018357e-11, -1.224800098109328e-14,  1.102185021328510e-15,
 -1.750329942417786e-17,  1.689317964889091e-19, -1.311038873602685e-21,  1.826063173575639e-24,  2.856501860544046e-01, -4.511108970487229e-03,  4.692850066168352e-05,
 -3.376725932895967e-07,  9.623724516372444e-10,  1.647748696253595e-11, -3.385361380196080e-13,  3.272017959792678e-15, -1.318564395122058e-17, -2.070186431347464e-19,
  4.381274338605721e-21, -5.038718674602548e-23,  4.694417778549186e-01, -6.923301193094139e-03,  5.903447567757395e-05, -1.973287961401073e-07, -2.891780331234318e-09,
  5.559325075916846e-11, -3.747691862836169e-13, -2.166602267074769e-15,  7.730817707102445e-17, -8.098556883637134e-19, -7.153391981604450e-22,  1.198869454938258e-22,
  6.945859839221068e-01, -9.258678385279278e-03,  5.460354416853102e-05,  2.213607933529221e-07, -7.475879600226867e-09,  4.241845816823528e-11,  6.028479613978149e-13,
 -1.261605010636509e-14,  3.494569000029612e-17,  1.628550052358117e-18, -2.522994761236346e-20, -2.159482796278030e-23,  9.551513101898342e-01, -1.094746884088109e-02,
  2.505775726589933e-05,  7.800413652397496e-07, -6.605053090285350e-09, -7.855455436782231e-11,  1.496829765158514e-12,  4.815829920953640e-15, -3.117723279976487e-16,
  9.096355681103667e-19,  5.494337997166701e-20, -5.713211796789637e-22,  1.239841941402131e+00, -1.125188192984765e-02, -2.880244278849618e-05,  9.955548550621702e-07,
  5.016964207802280e-09, -1.641831917311447e-10, -1.062467761977922e-12,  3.299352913880258e-14,  2.396699174177504e-16, -7.585028562538130e-18, -6.177471043864710e-20,
  1.795988251690745e-21,  1.527863174793281e+00, -9.457876764578437e-03, -8.305370516181667e-05,  2.798344308072364e-07,  1.550675338412537e-08,  8.265100791455901e-11,
 -2.636068789851963e-12, -4.391622658225727e-14,  2.463125770496447e-16,  1.368526866761236e-17,  5.957049738205117e-20, -3.316350862925509e-21,  1.783604463170217e+00,
 -5.544355477921089e-03, -8.795220026682619e-05, -8.464252549423664e-07, -2.838000367777364e-11,  1.736302177895250e-10,  3.281835859291116e-12,  1.946282531594630e-14,
 -5.041678287114728e-16, -1.578515851994366e-17, -1.778308670779184e-19,  1.030586083146166e-21,  1.955633772154938e+00, -1.332144797521366e-03, -2.898707607621043e-05,
 -5.344774181010851e-07, -8.639848647951061e-09, -1.212789305569350e-10, -1.389677236777313e-12, -9.996428903110842e-15,  6.081938804336862e-17,  4.262025966542176e-18,
  1.055872401871917e-19,  1.884126753914146e-21,  5.482335557040542e-03, -9.127252647325505e-05,  1.136749815853730e-06, -1.256567049837173e-08,  1.295714773609331e-10,
 -1.281814575273758e-12,  1.217857327287053e-14, -1.147773696861950e-16,  1.010606095437948e-18, -9.586622975196189e-21,  8.194837292506955e-23, -3.746913689759904e-25,
  4.933844959343722e-02, -8.122608994590109e-04,  9.851614227836137e-06, -1.037416671722261e-07,  9.879911175334401e-10, -8.652795417747546e-12,  6.803256376319580e-14,
 -4.852087225087443e-16,  2.383486074638423e-18, -9.271148564409621e-21, -9.793281297154768e-23,  5.212502499352247e-24,  1.370156583343498e-01, -2.203172122876939e-03,
  2.522313406936167e-05, -2.370771536888082e-07,  1.820926320012495e-09, -1.022878588672927e-11,  1.161547045099343e-14,  6.295765166180013e-16, -1.232209518955817e-17,
  1.208415642230051e-19, -1.014149991885872e-21,  1.285072074442054e-23,  2.683313422090965e-01, -4.151605155770427e-03,  4.297834533903070e-05, -3.200494725919072e-07,
  1.217822896937047e-09,  9.398560812133971e-12, -2.537293214845291e-13,  2.760704378525901e-15, -1.795789903735773e-17, -6.915970354772304e-20,  2.727049025025681e-21,
 -2.073368570767191e-23,  4.426771245686129e-01, -6.461202490617142e-03,  5.642398272872393e-05, -2.352070020797527e-07, -1.873443311296768e-09,  4.612345693024291e-11,
 -4.051678909661008e-13, -1.554915365727532e-16,  4.875141008985794e-17, -7.495519470317029e-19,  3.425142502609846e-21,  7.852783965578688e-23,  6.584389704969199e-01,
 -8.813189154566818e-03,  5.657241053969506e-05,  1.092025809557732e-07, -6.510582474361014e-09,  5.282141704988756e-11,  2.726882870505946e-13, -1.075238279811737e-14,
  7.578042996611625e-17,  6.653952090986452e-19, -2.144203075289090e-20,  1.831210960112237e-22,  9.118189644783566e-01, -1.071146794643087e-02,  3.373872272518913e-05,
  6.637697432361542e-07, -7.811629709992812e-09, -4.209578017460188e-11,  1.499636450888448e-12, -4.266785944356535e-15, -2.462168589220046e-16,  2.536151581517016e-18,
  2.565397749164427e-20, -6.713832810129370e-22,  1.194450824882688e+00, -1.143340717345024e-02, -1.648611630196365e-05,  1.048497837210664e-06,  1.556496549147813e-09,
 -1.779952746674466e-10, -7.477933757632485e-14,  3.598192108526419e-14, -5.735591526675376e-17, -8.330026540339034e-18,  2.613145893291627e-20,  2.018484025297501e-21,
  1.488730165533573e+00, -1.010455520950062e-02, -7.816471959642702e-05,  5.373330848336161e-07,  1.643408495891681e-08,  5.984082207742044e-12, -3.679865927807737e-12,
 -2.801310946820865e-14,  7.414033513926147e-16,  1.260020401121088e-17, -1.229155757783946e-19, -4.521090787264185e-21,  1.759955850749882e+00, -6.288316728111916e-03,
 -9.798315767719685e-05, -8.146736794650257e-07,  4.264188762100828e-09,  2.565400873308274e-10,  3.506583900767077e-12, -6.972594948934882e-15, -1.177963366951334e-15,
 -2.067472217187331e-17, -2.846957803276068e-20,  6.250779707105254e-21,  1.949797203339893e+00, -1.592242927469720e-03, -3.631639055171616e-05, -6.940208374860959e-07,
 -1.141976320591013e-08, -1.575947123431720e-10, -1.612401198473248e-12, -4.594998195884664e-15,  3.137895433161096e-16,  1.053778207996468e-17,  2.186531825665703e-19,
  3.308987764303201e-21,  5.134525767591449e-03, -8.274828704112310e-05,  9.976032405806185e-07, -1.068276713397426e-08,  1.066153419811179e-10, -1.024736449748160e-12,
  9.370074563034694e-15, -8.734404030032365e-17,  7.228921507286427e-19, -6.373243705504510e-21,  8.579247503333031e-23,  5.891069814690432e-25,  4.623951020374313e-02,
 -7.381714502711805e-04,  8.696125636677207e-06, -8.923401034049327e-08,  8.302057462126132e-10, -7.174748308412293e-12,  5.546191738717768e-14, -4.145090580862277e-16,
  2.046390684428411e-18, -7.231074365146747e-21,  2.413805026464947e-22,  1.082614029169142e-23,  1.285892010180592e-01, -2.012286884416659e-03,  2.254632977095949e-05,
 -2.095585508118750e-07,  1.620352061390916e-09, -9.779261024313467e-12,  2.432934959677193e-14,  2.984504332101507e-16, -8.519363419296716e-18,  9.680539049927584e-20,
 -4.296812479126585e-23,  3.253546758612024e-23,  2.523887352757855e-01, -3.822797258040421e-03,  3.925986291273589e-05, -2.993663082340332e-07,  1.350817636051767e-09,
  4.170140872665672e-12, -1.847052734534099e-13,  2.166305533150349e-15, -1.857718799760996e-17,  3.591140508925734e-20,  2.914567205540982e-21,  3.209386397974725e-23,
  4.177165913079770e-01, -6.021543461941178e-03,  5.345038111288615e-05, -2.583292982884985e-07, -1.047757875150346e-09,  3.649964787063652e-11, -3.915096354204234e-13,
  1.006099612898289e-15,  2.508553130482323e-17, -5.403592123141290e-19,  7.230223951529068e-21,  1.046341191583694e-22,  6.240972799491599e-01, -8.357056913388542e-03,
  5.729357224892162e-05,  1.374306972653289e-08, -5.411605372985326e-09,  5.604381889266245e-11,  8.098236104506952e-15, -8.090913863678420e-15,  8.669185724396880e-17,
  1.822231281063500e-20, -9.754585330721149e-21,  3.423498028716171e-22,  8.695602904163954e-01, -1.041187352368460e-02,  4.093244737169956e-05,  5.339483703563307e-07,
 -8.307531550641847e-09, -8.338377759036248e-12,  1.284684900292125e-12, -1.054027215344031e-14, -1.428641098398064e-16,  3.054267040880976e-18,  3.015273512399891e-21,
 -2.974801907718817e-22,  1.148533346399276e+00, -1.151481435349574e-02, -3.871591895151820e-06,  1.045160397751659e-06, -1.941956960057848e-09, -1.681731672146419e-10,
  8.643433759875740e-13,  2.971588172594593e-14, -3.182975938310582e-16, -5.658907707436926e-18,  1.025308206321549e-19,  1.358470165201163e-21,  1.447108428544772e+00,
 -1.069963409779860e-02, -7.015124634807158e-05,  7.962238602736307e-07,  1.562254526529616e-08, -8.868830367060590e-11, -4.072821957159045e-12,  1.651184525177440e-15,
  1.061915287590643e-15,  4.132061147499793e-18, -2.823778532242158e-19, -2.043448252339273e-21,  1.733175126284282e+00, -7.109707489406339e-03, -1.071661364423616e-04,
 -7.009794371201192e-07,  1.019584531206284e-08,  3.334157162709923e-10,  2.673862947272030e-12, -5.613935211954544e-14, -1.858430858130123e-15, -1.433531405496902e-17,
  3.930660543289269e-19,  1.266104042496708e-20,  1.942789705435450e+00, -1.919446548584021e-03, -4.585182044098200e-05, -9.040729637338806e-07, -1.496145972155526e-08,
 -1.962831898247802e-10, -1.529642596351555e-12,  1.351423612548561e-14,  8.894690839757562e-16,  2.260020810942557e-17,  3.924747334956629e-19,  4.355594638529045e-21,
  4.818721362874610e-03, -7.525271672793493e-05,  8.790061967254725e-07, -9.129447874198136e-09,  8.818403561801508e-11, -8.267750198125923e-13,  7.218906655807863e-15,
 -6.715217352917755e-17,  5.640577817435878e-19, -2.147938334166194e-21,  1.309715405029049e-22,  1.314048727897977e-24,  4.341948561750630e-02, -6.726703165140064e-04,
  7.700505734724780e-06, -7.703017101513687e-08,  6.991190793441534e-10, -5.975686215539573e-12,  4.475257910258135e-14, -3.502767431566210e-16,  2.092251124414799e-18,
  1.381756892647332e-20,  8.470651352622765e-22,  1.548886893472324e-23,  1.208854711987512e-01, -1.841548967286205e-03,  2.018083593398847e-05, -1.851635453904801e-07,
  1.431137425762213e-09, -9.122598730146907e-12,  2.940889231249344e-14,  8.442954661589905e-17, -4.665013002313176e-18,  1.295812470705614e-19,  1.794941531707156e-21,
  4.728469495294709e-23,  2.377034774296534e-01, -3.522715643786760e-03,  3.579917129606669e-05, -2.773074206614635e-07,  1.394465471510397e-09,  4.000037171721185e-13,
 -1.319956435980531e-13,  1.618768219080646e-15, -1.469798521001197e-17,  1.964974240957424e-19,  5.436503922933145e-21,  7.461115281645244e-23,  3.944656572244347e-01,
 -5.606572993457096e-03,  5.027231044828250e-05, -2.697530078823482e-07, -4.090448363601957e-10,  2.751643668470523e-11, -3.545702656599040e-13,  1.563338316858676e-15,
  1.208713236554462e-17, -1.441712406347995e-19,  1.287710528246364e-20,  1.424419123402520e-22,  5.915848278276090e-01, -7.899435729039062e-03,  5.697580118808062e-05,
 -6.393644340399618e-08, -4.305520275194224e-09,  5.383179186981104e-11, -1.798661749785436e-13, -5.349954846630439e-15,  8.427431835777103e-17, -3.742331079315273e-20,
  7.536637336704888e-21,  4.156689550309386e-22,  8.286051018166523e-01, -1.006104639338667e-02,  4.654193426819719e-05,  4.012606220779589e-07, -8.192117287106598e-09,
  1.853790158428832e-11,  9.421479544177802e-13, -1.334554481164070e-14, -3.245914046056864e-17,  3.069909723845226e-18,  1.471111428672486e-21,  1.998766289888774e-22,
  1.102490503802644e+00, -1.149639458943289e-02,  8.377280166866399e-06,  9.885685595424237e-07, -5.037217881410090e-09, -1.387526945413555e-10,  1.529406012104998e-12,
  1.716312507044101e-14, -4.362579518298722e-16, -6.346396731025861e-19,  1.417690566657331e-19,  4.099391730033359e-22,  1.403253763519604e+00, -1.121854493982166e-02,
 -5.917232205407898e-05,  1.026769270282346e-06,  1.289518184323503e-08, -1.819846133121185e-10, -3.544625651949975e-12,  3.574362424444878e-14,  9.990798186933922e-16,
 -7.464992212312464e-18, -2.578182887295822e-19,  3.310646158229718e-21,  1.702972971771769e+00, -7.997384040899908e-03, -1.143695018674237e-04, -4.816728481977008e-07,
  1.734229459041068e-08,  3.716653893438848e-10,  2.200677023540477e-13, -1.196804739582376e-13, -1.948686322227581e-15,  1.331901091719752e-17,  9.887934069580549e-19,
  1.234224024088860e-20,  1.934303426793883e+00, -2.334036530312716e-03, -5.827249012918167e-05, -1.176658999070549e-06, -1.920335098826287e-08, -2.243683190952747e-10,
 -6.067344723296762e-13,  5.838588841332322e-14,  2.029259681399514e-15,  4.176124654883475e-17,  5.442802575943017e-19,  1.272534133614100e-21,  4.531113036229833e-03,
 -6.863609316073058e-05,  7.774016511374096e-07, -7.841976984838814e-09,  7.323915010337867e-11, -6.740773269029935e-13,  5.587560768053962e-15, -4.922080655643461e-17,
  5.939076972276380e-19,  4.091034510424326e-21,  1.717419763290125e-22,  8.174718132824046e-27,  4.084641509476431e-02, -6.145822783289952e-04,  6.839495430379377e-06,
 -6.674520826127895e-08,  5.895935516150564e-10, -5.011026392788256e-12,  3.601095968934508e-14, -2.675679759145529e-16,  3.350448861950068e-18,  5.950513182565293e-20,
  1.344152218251648e-21,  2.346258563626917e-24,  1.138286278676784e-01, -1.688614474844339e-03,  1.809036748754838e-05, -1.636860520503329e-07,  1.255868303902048e-09,
 -8.400382054389077e-12,  3.050577834559085e-14,  2.751112771464525e-17,  1.756887796849720e-18,  2.379128657031030e-19,  3.356971062653146e-21,  9.941879209975951e-24,
  2.241648611880255e-01, -3.249254172297652e-03,  3.260509740660760e-05, -2.550895406724535e-07,  1.374216989473662e-09, -2.268940288331130e-12, -9.185583712067740e-14,
  1.309775980092332e-15, -2.965999724738454e-18,  4.722342546208007e-19,  7.875654290523735e-21,  7.349361428818481e-24,  3.728231153687011e-01, -5.217415016396747e-03,
  4.701271169213168e-05, -2.723418098861290e-07,  5.995210859483903e-11,  1.957478930840110e-11, -3.053856834567909e-13,  1.977967489022415e-15,  1.753885908237203e-17,
  4.772609524793285e-19,  1.723607757862045e-20,  6.946355699898554e-24,  5.608922909185717e-01, -7.447789300401912e-03,  5.582987720314713e-05, -1.244916642907378e-07,
 -3.282606029516497e-09,  4.802384781018119e-11, -2.914985513465776e-13, -2.582566554735902e-15,  9.245225471032509e-17,  5.894688945747419e-19,  2.194859373567726e-20,
  1.544401187922745e-22,  7.891329836562452e-01, -9.671643140567402e-03,  5.058648376352272e-05,  2.742535251643077e-07, -7.625681593522207e-09,  3.665101257922647e-11,
  5.707478740559986e-13, -1.258323617093670e-14,  8.180587080173636e-17,  3.355618881657916e-18,  1.251678733978586e-20,  1.472103020781324e-22,  1.056711897960067e+00,
 -1.138349243129066e-02,  1.967179171747208e-05,  8.879021180075054e-07, -7.414386393772716e-09, -9.783909467096448e-11,  1.819012134356629e-12,  3.948503684314495e-15,
 -3.555414331416994e-16,  5.076605038324540e-18,  1.349397653819903e-19, -8.207693919717259e-22,  1.357515412655164e+00, -1.163943580814706e-02, -4.574715769529655e-05,
  1.199753913102675e-06,  8.503231265535334e-09, -2.517439324977521e-10, -2.148739788905530e-12,  6.179226688402714e-14,  5.921385428901714e-16, -1.357604977857290e-17,
 -2.482993820587107e-20,  6.358401903124181e-21,  1.669124315572470e+00, -8.930182595619332e-03, -1.182418872039529e-04, -1.457002957689436e-07,  2.452351541519068e-08,
  3.304268283809633e-10, -3.872258809445518e-12, -1.658657065776058e-13, -6.577095920456898e-16,  6.000418139072555e-17,  1.216484783023225e-18, -5.351379524414346e-21,
  1.923937668630658e+00, -2.862262212774739e-03, -7.438468741246560e-05, -1.519895612778153e-06, -2.365955025030750e-08, -2.104356559081046e-10,  2.192892764942258e-12,
  1.515002965572983e-13,  3.907923971166857e-15,  6.106919158658425e-17,  2.952672983413362e-19, -1.631600034702279e-20,  4.268437929726286e-03, -6.277435321977901e-05,
  6.899064139581920e-07, -6.771144520608444e-09,  6.099883099899266e-11, -5.541841937009241e-13,  4.506718764709635e-15, -2.660110577104991e-17,  8.541532563824052e-19,
  9.720760575136363e-21,  7.077018041107512e-23, -5.334410358728965e-24,  3.849266200439191e-02, -5.629170387735867e-04,  6.091992372418833e-06, -5.806881768965826e-08,
  4.974811572568219e-10, -4.222206936685641e-12,  3.041418032106805e-14, -1.161400225173053e-16,  6.384499109732546e-18,  1.036844978233267e-19,  5.029244315602818e-22,
 -4.726604440266270e-23,  1.073516414553476e-01, -1.551419377254872e-03,  1.624128405461965e-05, -1.448959541755798e-07,  1.095314209499886e-09, -7.643817596365421e-12,
  3.353166848276090e-14,  2.457028793109839e-16,  1.255473901216295e-17,  3.474776745725369e-19,  1.081194352680657e-21, -1.326402391506996e-22,  2.116706614997697e-01,
 -3.000288069082283e-03,  2.967409633686818e-05, -2.335723809694270e-07,  1.309782366169434e-09, -4.026287512596993e-12, -5.353552730095717e-14,  1.544645754631770e-15,
  1.920577386039145e-17,  7.268506725956156e-19,  2.756696767484732e-21, -2.803097933368158e-22,  3.526850198235361e-01, -4.854342157339231e-03,  4.376204952218765e-05,
 -2.686286121576041e-07,  3.830535313816684e-10,  1.299408085585081e-11, -2.386419103224260e-13,  2.941141776986436e-15,  4.615896919945782e-17,  1.051936256751640e-18,
  7.730017388129200e-21, -5.096434225055654e-22,  5.319837828754003e-01, -7.007948321405015e-03,  5.405125947409935e-05, -1.697279188528374e-07, -2.396112513394345e-09,
  4.052023268230588e-11, -3.179734236858717e-13,  8.863348053145067e-16,  1.292525209871856e-16,  1.388697912836587e-18,  1.140964213801070e-20, -7.507216289697357e-22,
  7.512737886865160e-01, -9.255801309773319e-03,  5.317174982619848e-05,  1.587380307686761e-07, -6.782205293000191e-09,  4.653194642653731e-11,  2.739215729338427e-13,
 -7.937574863352776e-15,  2.109001851135706e-16,  3.716407231728904e-18, -3.539885715638258e-21, -1.094578657696968e-21,  1.011557133807712e+00, -1.118564871246862e-02,
  2.955799819702266e-05,  7.560066426707009e-07, -8.931449601448749e-09, -5.393795964522904e-11,  1.804624379021691e-12, -3.565789519542282e-15, -8.933497198695409e-17,
  9.183771427705848e-18,  5.397625859504681e-20, -3.080258384077481e-21,  1.310319637735205e+00, -1.194590980088626e-02, -3.070734029354989e-05,  1.293345666061832e-06,
  3.101966944899217e-09, -2.808556590629468e-10, -2.250797023424260e-13,  7.324660474917980e-14,  1.476911193877812e-16, -9.672837252830768e-18,  1.873169578114665e-19,
  1.894354510618829e-21,  1.631510670002386e+00, -9.875979382964008e-03, -1.174386633351559e-04,  2.929016929170445e-07,  2.982386330636834e-08,  1.816941816499263e-10,
 -8.424696653923838e-12, -1.439472708964266e-13,  2.240408413145575e-15,  9.491779267320267e-17,  2.934620627299175e-19, -3.718889288236845e-20,  1.911173479203064e+00,
 -3.537023098166204e-03, -9.501976577057170e-05, -1.927535607751069e-06, -2.691656322485143e-08, -9.070445139615961e-11,  8.521164544332966e-12,  3.119578823671058e-13,
  6.044406158297496e-15,  4.682351319689250e-17, -1.366940733678082e-18, -6.576627917693854e-20,  4.027886772301312e-03, -5.756433035902258e-05,  6.141612933416985e-07,
 -5.878149383340246e-09,  5.095378992261572e-11, -4.515433543506744e-13,  4.197704764292635e-15,  6.277217172214800e-18,  1.176862906935830e-18,  5.455994722970340e-21,
 -3.459427204992603e-22, -1.371531351962151e-23,  3.633423538864888e-02, -5.168392519013901e-04,  5.440264640342381e-06, -5.074565791774295e-08,  4.202070775918090e-10,
 -3.504739989381082e-12,  3.058142959100633e-14,  1.464016582944522e-16,  9.778773503302571e-18,  6.008659742685075e-20, -3.252825052962934e-21, -1.244080166632396e-22,
  1.013952180576894e-01, -1.428157504229530e-03,  1.460278816808930e-05, -1.285469082259407e-07,  9.513263617297773e-10, -6.699597439462384e-12,  4.789155993983039e-14,
  8.407961387112924e-16,  2.386275272217917e-17,  2.103761348587457e-19, -9.576049793520363e-21, -3.545668056696647e-22,  2.001270376766116e-01, -2.773757006215867e-03,
  2.699412725588358e-05, -2.133136135068477e-07,  1.220373304884887e-09, -4.698488978536073e-12,  2.227183899678480e-15,  2.567421179932062e-15,  4.321388487811294e-17,
  4.604038533758527e-19, -1.943634221510262e-20, -7.346231977125731e-22,  3.339475989837810e-01, -4.517017861955924e-03,  4.058293212011439e-05, -2.607004303568013e-07,
  5.933462556213901e-10,  8.457600127605456e-12, -1.298126783216210e-13,  5.026352237838918e-15,  8.210300953864577e-17,  6.809146281421331e-19, -3.225853275554969e-20,
 -1.318569630146262e-21,  5.048030682156336e-01, -6.584277953285928e-03,  5.180994250214122e-05, -2.019796656176441e-07, -1.657394704926598e-09,  3.370137205004100e-11,
 -2.275957106439308e-13,  5.822405688915132e-15,  1.759167203939718e-16,  7.868848613419677e-19, -5.172035078899777e-20, -2.134320865414480e-21,  7.151108869566518e-01,
 -8.824579910330093e-03,  5.445721256620830e-05,  5.796475666425564e-08, -5.799374675058644e-09,  5.132131509309619e-11,  1.653509477239814e-13,  7.945615053908106e-16,
  3.250349729769064e-16,  1.999154719830575e-18, -9.832051206481699e-20, -3.258229190752433e-21,  9.673414047070984e-01, -1.091539263750913e-02,  3.774458440653751e-05,
  6.067908475690339e-07, -9.585529078586413e-09, -1.183528603693467e-11,  1.715632679712126e-12, -1.037345561016768e-15,  2.391703325978468e-16,  7.712265278880058e-18,
 -1.509274530065646e-19, -6.242963642427108e-21,  1.262143605528702e+00, -1.212906951550620e-02, -1.507379846885980e-05,  1.298450042769986e-06, -2.401454839774278e-09,
 -2.613817000724493e-10,  1.850085745749192e-12,  7.384377049821752e-14, -7.126400317486894e-17, -3.388889129882168e-18,  4.996735042355081e-20, -8.496017243798335e-21,
  1.590161713529734e+00, -1.079311858691450e-02, -1.109797248408532e-04,  7.869846857342783e-07,  3.116462743836427e-08, -5.761343110373323e-11, -1.094257511432684e-11,
 -1.898818726540897e-14,  5.405021320046781e-15,  6.673766124315797e-17, -1.821815431292172e-18, -5.298170263225126e-20,  1.895348170999337e+00, -4.397073522226351e-03,
 -1.207489597509707e-04, -2.358223695139624e-06, -2.586038011494649e-08,  2.414940559931898e-10,  2.010285771912962e-11,  5.148234961438498e-13,  5.847117451228685e-15,
 -8.806198150819890e-17, -5.946137852953972e-18, -1.419916389008616e-19,  3.807027999102968e-03, -5.291998192261370e-05,  5.482351273679379e-07, -5.129524413737854e-09,
  4.296692329395726e-11, -3.443793136557221e-13,  4.903740972740389e-15,  4.310718377936125e-17,  9.610483276586662e-19, -2.226208587238498e-20, -1.065524568387210e-21,
 -1.691137371648398e-23,  3.435022061924761e-02, -4.756436885934784e-04,  4.869478045812014e-06, -4.454118044242643e-08,  3.579709000991844e-10, -2.685420340299545e-12,
  3.914008419025640e-14,  4.569977341113811e-16,  8.117561528108145e-18, -1.961839314536950e-19, -9.797418434894458e-21, -1.540463249276102e-22,  9.590681553707096e-02,
 -1.317256421101405e-03,  1.314735889875715e-05, -1.143255573747296e-07,  8.311987137557774e-10, -5.177867312553258e-12,  8.254291776838226e-14,  1.617923564304925e-15,
  2.031170284136699e-17, -5.327803977509930e-19, -2.826828473885866e-20, -4.406378079371199e-22,  1.894481632466702e-01, -2.567718089664555e-03,  2.454850198407766e-05,
 -1.945091112460682e-07,  1.133608575831235e-09, -3.617863763487552e-12,  9.449728998167348e-14,  3.995584963897081e-15,  3.703928862611947e-17, -1.062284553623586e-18,
 -5.811005066638399e-20, -9.116868203463196e-22,  3.165092849420671e-01, -4.204694619758071e-03,  3.751666589888613e-05, -2.499695789506112e-07,  7.443312948317312e-10,
  7.338545378070899e-12,  4.890052372909904e-14,  7.671597542405322e-15,  6.769077468555920e-17, -1.945538618602916e-18, -1.015860415660279e-19, -1.635221029298756e-21,
  4.792789940885994e-01, -6.179894628383579e-03,  4.924853754248946e-05, -2.233355160234857e-07, -1.021454190903506e-09,  3.083848397499743e-11,  1.448930742398242e-14,
  1.130194002086861e-14,  1.414342821711780e-16, -3.461709143908982e-18, -1.651431764003268e-19, -2.694747367842903e-21,  6.806861658408624e-01, -8.387637796724766e-03,
  5.463069296813357e-05, -2.636897439146773e-08, -4.725228662306216e-09,  5.676383533058863e-11,  3.368352319621625e-13,  1.127536572449436e-14,  2.869166595644927e-16,
 -5.289153029547275e-18, -2.734431548965874e-19, -4.189856094129653e-21,  9.243261773870797e-01, -1.058692069625530e-02,  4.410531593688456e-05,  4.537743708325486e-07,
 -9.407474450828758e-09,  3.005693273900597e-11,  1.823836357989855e-12,  9.312660083284703e-15,  3.356582271879492e-16, -4.454706474419005e-18, -4.654601593089385e-19,
 -7.228725733168700e-21,  1.213483406898129e+00, -1.218836565691044e-02,  1.142716960213974e-07,  1.221315088559954e-06, -7.019418165600369e-09, -1.925460461738728e-10,
  3.865122797831836e-12,  6.909846369823069e-14, -2.721744882835223e-16, -1.146654416114213e-17, -5.007726744050842e-19, -1.469197609151260e-20,  1.545285110101289e+00,
 -1.163488400805373e-02, -9.862794769866975e-05,  1.262324942805045e-06,  2.745132120879264e-08, -3.054624571336998e-10, -8.817152250606481e-12,  1.740411090970482e-13,
  5.976758242409265e-15, -4.733035620091136e-17, -3.654554290246919e-18, -2.201817706895988e-20,  1.875639467948902e+00, -5.482730887808894e-03, -1.512717518646464e-04,
 -2.701911223341032e-06, -1.494835052377351e-08,  9.131983230739037e-10,  3.625895908228802e-11,  5.923692504937639e-13, -3.203551835698536e-15, -4.583431901077877e-16,
 -1.235308864437184e-17, -1.058621471973727e-19,  3.603745853826872e-03, -4.876911073567771e-05,  4.906003268721299e-07, -4.490299589682353e-09,  3.736764033451920e-11,
 -2.097982006175761e-13,  6.354524835153101e-15,  5.152950611945249e-17, -7.578361914601414e-19, -7.609127441313227e-20, -1.470160209839685e-21,  4.965452952664840e-24,
  3.252230490928661e-02, -4.387321996818862e-04,  4.367754955287055e-06, -3.918750847640351e-08,  3.148057587192294e-10, -1.572686636234149e-12,  5.390209836205872e-14,
  5.164368965534266e-16, -7.368462628940401e-18, -6.902127182938025e-19, -1.348443322342873e-20,  4.533256331149436e-23,  9.083976863585282e-02, -1.217346180876961e-03,
  1.185222315883339e-05, -1.017307872831877e-07,  7.513942622859994e-10, -2.606158593192889e-12,  1.323059520689111e-13,  1.709339526440816e-15, -2.314162879224911e-17,
 -1.956025136399814e-18, -3.884215704730281e-20,  1.284943726822663e-22,  1.795557135307359e-01, -2.380362671633468e-03,  2.232133883976729e-05, -1.767871846397791e-07,
  1.093470626332070e-09,  7.335367968067786e-14,  2.136072789414587e-13,  4.051062633620378e-15, -5.116844899333091e-17, -3.993829695410363e-18, -8.016038989748851e-20,
  2.552718339324783e-22,  3.002720769399079e-01, -3.916345428692196e-03,  3.459374449232974e-05, -2.367460374501823e-07,  9.211152871760784e-10,  1.123860764135612e-11,
  2.771688094313479e-13,  7.808229865915697e-15, -9.011732890879894e-17, -7.104318354497088e-18, -1.417057745684974e-19,  4.227640124129515e-22,  4.553300890811426e-01,
 -5.796856706176955e-03,  4.649117828288422e-05, -2.346109010648060e-07, -3.736031226853452e-10,  3.532905167915153e-11,  3.652566870733540e-13,  1.235293058719436e-14,
 -1.263068886156161e-16, -1.188519633604093e-17, -2.322544031354003e-19,  6.470475371631766e-22,  6.480060052890322e-01, -7.953053492811144e-03,  5.389986193579270e-05,
 -9.232823997674732e-08, -3.479225493346435e-09,  6.941420053993632e-11,  7.355021651103825e-13,  1.497848213238264e-14, -1.380591955953511e-16, -1.905500188597330e-17,
 -3.776491415638562e-19,  1.041351675218475e-21,  8.827151343667954e-01, -1.021479417587554e-02,  4.867532020256974e-05,  3.105493908988422e-07, -8.342364162514398e-09,
  7.788092723364648e-11,  2.181965465068262e-12,  1.334424392795123e-14, -2.245035425797909e-16, -2.793130794722712e-17, -6.461417212839381e-19,  1.511157851635856e-21,
  1.164821556365169e+00, -1.213099439336028e-02,  1.398717541103956e-05,  1.083870778655624e-06, -9.793300251927345e-09, -7.809994585722536e-11,  5.581353282600089e-12,
  4.873418079534743e-14, -1.187013826707486e-15, -4.249226988963751e-17, -9.543213804465085e-19, -1.175364569588859e-21,  1.497273310456477e+00, -1.235637853096385e-02,
 -8.107817172127358e-05,  1.643189907524020e-06,  1.972192483765899e-08, -4.395949706718385e-10, -1.729488584183425e-12,  3.089965589692370e-13,  1.573361433286796e-15,
 -1.943234467663305e-16, -3.185470980653646e-18,  4.764313579074322e-20,  1.851079360169033e+00, -6.824940979004675e-03, -1.843594484788514e-04, -2.742490405565531e-06,
  1.322380958356747e-08,  1.952075232336009e-09,  4.822197164899556e-11,  1.267109507821801e-13, -2.885658124726725e-14, -9.416883724657254e-16, -8.063458876208114e-18,
  4.122059161319615e-19,  3.416191752485396e-03, -4.504994144969272e-05,  4.401935432421443e-07, -3.917293702809424e-09,  3.478733250630591e-11, -4.562558072021389e-14,
  6.972119973314748e-15, -2.653017386042391e-17, -4.355139394560928e-18, -1.135293307723009e-19,  1.129614050654170e-22,  7.509608591284930e-23,  3.083440027431822e-02,
 -4.055874457726861e-04,  3.926927483078148e-06, -3.432784955631171e-08,  2.972118755778382e-10, -1.585894981904590e-13,  6.064757062224270e-14, -2.085171517441658e-16,
 -4.009465907419076e-17, -1.034513377609777e-18,  9.704897676067595e-22,  6.859156797925526e-22,  8.615257275517062e-02, -1.127209863151858e-03,  1.070246517371091e-05,
 -8.993910359594386e-08,  7.341558216814195e-10,  9.847670333042598e-13,  1.572583857565887e-13, -4.220728190032428e-16, -1.163015521222930e-16, -2.952599688776228e-18,
  2.477005431611061e-21,  1.963317472838349e-21,  1.703783909686741e-01, -2.209978229192952e-03,  2.030590972479120e-05, -1.589680452740723e-07,  1.153795026715843e-09,
  6.222525962527411e-12,  2.784569369064957e-13, -4.331305228319022e-16, -2.420239125580180e-16, -6.063203969301603e-18,  4.391193289286360e-21,  4.030978361397666e-21,
  2.851425820346170e-01, -3.650688974749581e-03,  3.184998899927244e-05, -2.197835088011374e-07,  1.227295115453348e-09,  1.991541697649856e-11,  4.098184716513701e-13,
 -1.358954177329046e-16, -4.293933658146263e-16, -1.078648440641273e-17,  6.684585771095019e-21,  7.115856740163101e-21,  4.328686225638084e-01, -5.436232897581441e-03,
  4.366513086344657e-05, -2.343558898098766e-07,  4.443963193666188e-10,  4.733359075937803e-11,  5.784717963528672e-13, -1.259564491704487e-16, -6.915781884804730e-16,
 -1.796221835820914e-17,  9.037203910156905e-21,  1.164616728557543e-20,  6.170479838786361e-01, -7.527120321191849e-03,  5.250718584146533e-05, -1.358059639335370e-07,
 -1.886080215470734e-09,  9.086803705505947e-11,  9.707658048352917e-13, -3.009972450604864e-15, -1.048599009780861e-15, -2.906007253359589e-17,  5.536095225770620e-21,
  1.853095316193404e-20,  8.426553410758951e-01, -9.812616977089291e-03,  5.166194654318899e-05,  1.924766464988178e-07, -6.239567413152458e-09,  1.328223573691950e-10,
  2.270845008412150e-12, -1.441318610144326e-14, -1.620563960830930e-15, -4.568704418363404e-17, -3.464998115401547e-20,  2.978842706734940e-20,  1.116599892554975e+00,
 -1.196980447804193e-02,  2.602653475080890e-05,  9.223261614256210e-07, -9.934360818788525e-09,  6.626699101407027e-11,  6.134131256221453e-12, -2.055179584838677e-14,
 -3.315184392983046e-15, -7.002207824934921e-17, -6.155912810868254e-20,  4.811095044706976e-20,  1.446682119769986e+00, -1.292143455358153e-02, -5.975593830120782e-05,
  1.889103833152185e-06,  1.121493048704271e-08, -3.788046857638412e-10,  6.431390608658879e-12,  2.284308374981071e-13, -6.979011529189928e-15, -2.540153117307589e-16,
  8.862289920337127e-19,  1.417084216745253e-19,  1.820630916886560e+00, -8.424486611905445e-03, -2.145099143651276e-04, -2.156781024406406e-06,  6.344937293129434e-08,
  3.015262981107309e-09,  3.358832191927750e-11, -1.349304057719566e-12, -6.164960622572586e-14, -6.201225208711007e-16,  3.112918537511960e-17,  1.333385483368588e-18,
  3.242750707276988e-03, -4.170697389792696e-05,  3.965234657478823e-07, -3.359487321197098e-09,  3.539125928506973e-11,  9.348687200948171e-14,  3.715117385908800e-15,
 -2.223960084091716e-16, -7.331355388143385e-18, -1.807696434774393e-20,  5.148173346877122e-21,  1.377728659067735e-22,  2.927238684681017e-02, -3.757386702427422e-04,
  3.543664500281198e-06, -2.952376762741374e-08,  3.072337320905178e-10,  1.049492100112474e-12,  3.171380117300158e-14, -2.006661114843303e-15, -6.723109995604564e-17,
 -1.646447898056421e-19,  4.700182360064175e-20,  1.260673407583539e-21,  8.180842287519442e-02, -1.045704754136956e-03,  9.694957242858063e-06, -7.784277986774131e-08,
  7.880638985904939e-10,  4.104023143298116e-12,  7.867556733952076e-14, -5.615403363757576e-15, -1.938586327457772e-16, -4.716571585442877e-19,  1.344965075348489e-19,
  3.622811442000753e-21,  1.618517494237453e-01, -2.054835861138961e-03,  1.851428593873445e-05, -1.391709737536365e-07,  1.338750781239655e-09,  1.169450014820814e-11,
  1.277588193745596e-13, -1.120484215016601e-14, -4.017008665483222e-16, -9.857270272764855e-19,  2.763963016316707e-19,  7.488495325796255e-21,  2.710332378173758e-01,
 -3.406071238903371e-03,  2.934520196152559e-05, -1.964595832218818e-07,  1.714168415630751e-09,  2.781374361024282e-11,  1.599319930783709e-13, -1.927435914285414e-14,
 -7.147611232852423e-16, -1.834362827162036e-18,  4.894324241775867e-19,  1.335384359215654e-20,  4.118047934429079e-01, -5.097963424294660e-03,  4.092907806248879e-05,
 -2.189714368963008e-07,  1.514258723088414e-09,  5.810834630242205e-11,  1.754509633325670e-13, -3.127969102000097e-14, -1.170528170644889e-15, -3.319446854344491e-18,
  8.046864730816525e-19,  2.214984730812756e-20,  5.877687639666821e-01, -7.113948652116600e-03,  5.076025517426613e-05, -1.502873568352060e-07,  1.338942846962034e-10,
  1.084452384070938e-10,  2.709842009677220e-13, -5.126147052656755e-14, -1.833419905195404e-15, -6.007007336324450e-18,  1.280875420908809e-18,  3.577618324486631e-20,
  8.042439855364080e-01, -9.391559735211998e-03,  5.346925236060055e-05,  1.165947145225257e-07, -3.107335037462228e-09,  1.751663525147124e-10,  9.102176626906647e-13,
 -8.962863657757428e-14, -2.874661875981035e-15, -1.014345149674749e-17,  2.035090465024432e-18,  5.862840170149937e-20,  1.069203577109853e+00, -1.171987194511816e-02,
  3.620927941997094e-05,  7.815376503981890e-07, -7.254946807675382e-09,  1.923712808141179e-10,  3.720939408572182e-12, -1.621240921661969e-13, -5.191935886872076e-15,
 -1.092956893099439e-17,  3.425844623747967e-18,  1.011932393616034e-19,  1.394187485026352e+00, -1.330626732027124e-02, -3.622828127520162e-05,  2.017937950046462e-06,
  5.536134954677407e-09, -1.808037115475837e-10,  8.454526165651163e-12, -1.203603174058015e-13, -1.371131307255298e-14, -6.495153279921110e-17,  9.129221461958391e-18,
  2.129964177279209e-19,  1.783367564212474e+00, -1.022204608438879e-02, -2.322133115175285e-04, -6.323624782380766e-07,  1.275566924840125e-07,  3.135984150789492e-09,
 -3.276976455310433e-11, -3.321307928569742e-12, -4.722997002616808e-14,  1.774841317296810e-15,  8.195775853354332e-17,  3.681427631480542e-19,  3.082025668243876e-03,
 -3.868625399250039e-05,  3.596776552444765e-07, -2.776010441002562e-09,  3.751474596365869e-11,  8.251088859996108e-14, -5.547117522178244e-15, -4.169340237519841e-16,
 -3.014188165911950e-18,  2.821453128456295e-19,  8.539021357294024e-21, -4.596627416798832e-23,  2.782400727434321e-02, -3.487211760070987e-04,  3.219637767448342e-06,
 -2.442215395959425e-08,  3.300596116432738e-10,  9.033078906889775e-13, -5.231239202906923e-14, -3.791749874836329e-15, -2.776538497648184e-17,  2.579445696295606e-18,
  7.811679088952701e-20, -4.169516782948410e-22,  7.777511841999646e-02, -9.716606076375736e-04,  8.839362980394852e-06, -6.454036896353590e-08,  8.727602576382201e-10,
  3.433191409497316e-12, -1.588742726435897e-13, -1.076938017351516e-14, -8.074193958858757e-17,  7.398067734971783e-18,  2.244227448918948e-19, -1.177103453811421e-21,
  1.539185956690529e-01, -1.913019416690955e-03,  1.698065880793026e-05, -1.158455964100346e-07,  1.570571097609754e-09,  9.601926040102259e-12, -3.525814470692076e-13,
 -2.190725663219149e-14, -1.692313820072435e-16,  1.523904679792128e-17,  4.639073402079871e-19, -2.367094850324759e-21,  2.578642595177845e-01, -3.180230895444187e-03,
  2.717066783564326e-05, -1.646033679407668e-07,  2.252075995862276e-09,  2.269239570376857e-11, -6.767315916375614e-13, -3.837653783134593e-14, -3.049412014025792e-16,
  2.701616357928123e-17,  8.278595017453960e-19, -4.060613436614999e-21,  3.920518607949482e-01, -4.780541524188916e-03,  3.848488730891414e-05, -1.855899792636205e-07,
  2.626202861364001e-09,  4.773312661110835e-11, -1.188097317847374e-12, -6.269008504541845e-14, -5.047299155100288e-16,  4.437302432175595e-17,  1.374968038973995e-18,
 -6.385778391088558e-21,  5.601139797067390e-01, -6.714879755934168e-03,  4.904076122674933e-05, -1.310462345202960e-07,  2.217987291215777e-09,  9.132185054218548e-11,
 -1.930918770999814e-12, -1.006663467737255e-13, -7.924570328868626e-16,  7.053175952556659e-17,  2.220880821922262e-18, -9.569399123895946e-21,  7.675412772983380e-01,
 -8.958785392119098e-03,  5.468676123348259e-05,  9.505277084527137e-08,  3.584478089800463e-10,  1.568457317168654e-10, -2.802424253319294e-12, -1.670687272760403e-13,
 -1.220575469944501e-15,  1.132774614312841e-16,  3.615570423637172e-18, -1.409898030527113e-20,  1.022960463027942e+00, -1.139434233743796e-02,  4.502892009729650e-05,
  6.992151203605992e-07, -2.976643380934485e-09,  2.092163992699412e-10, -2.966943405140725e-12, -2.999609154179454e-13, -2.151836069243410e-15,  1.997159555721348e-16,
  6.220778946082144e-18, -2.296084806350493e-20,  1.340537969040327e+00, -1.349793923730279e-02, -1.157045750073767e-05,  2.086574884991729e-06,  3.421327563869202e-09,
 -6.713098295504697e-11, -8.091712846852367e-13, -5.095638152075164e-13, -7.542658557741904e-15,  4.440285641895568e-16,  1.417759463104869e-17, -8.696156510127518e-20,
  1.738770621506583e+00, -1.207108763478802e-02, -2.257165826924750e-04,  1.833855640110493e-06,  1.743283550396510e-07,  1.144045490335160e-09, -1.329401202494000e-10,
 -3.211196913089166e-12,  6.940313072984124e-14,  4.222556809964801e-15,  8.221890196814079e-18, -3.885522585487463e-18,  2.932839005369370e-03, -3.593181883746106e-05,
  3.299869603525627e-07, -2.173829833081254e-09,  3.687942600495049e-11, -1.900988820532386e-13, -1.663347020328137e-14, -2.962656509240326e-16,  1.167441331038762e-17,
  4.581968754437445e-19, -2.837262476651772e-21, -4.531350041554197e-22,  2.647890846365526e-02, -3.240458133265581e-04,  2.958532676565596e-06, -1.910149462272085e-08,
  3.268884379883402e-10, -1.621368161771119e-12, -1.531970544384421e-13, -2.694651513298969e-15,  1.065806901236949e-16,  4.192333408815025e-18, -2.588124866601926e-20,
 -4.147366836998011e-21,  7.402534042244188e-02, -9.038028958784018e-04,  8.149973607143648e-06, -5.033812687733940e-08,  8.786119757278830e-10, -3.988266810656054e-12,
 -4.457297316507090e-13, -7.654242433432928e-15,  3.049633676392606e-16,  1.204554761817819e-17, -7.390578798766563e-20, -1.192615193223383e-20,  1.465300215715386e-01,
 -1.782296985610184e-03,  1.574555463213937e-05, -8.985182252220621e-08,  1.627721838918930e-09, -6.210189132508604e-12, -9.369267009719912e-13, -1.556807255402745e-14,
  6.267461176200400e-16,  2.489069146425036e-17, -1.512848381250347e-19, -2.468600449297960e-20,  2.455664575627979e-01, -2.970127038501782e-03,  2.542272853722687e-05,
 -1.261934116293828e-07,  2.455351645505550e-09, -6.440860902617870e-12, -1.701625806059544e-12, -2.724791396203807e-14,  1.110611010586467e-15,  4.435228645497580e-17,
 -2.661884639012292e-19, -4.413161283657153e-20,  3.735324358141352e-01, -4.480796948624514e-03,  3.653474694754726e-05, -1.380899789391332e-07,  3.151647589598474e-09,
 -1.849919441901495e-12, -2.862702912886614e-12, -4.440929136608618e-14,  1.831732780112304e-15,  7.340909522420600e-17, -4.340814262690564e-19, -7.348049433390631e-20,
  5.340301615497924e-01, -6.328122987779031e-03,  4.773058377480689e-05, -8.443908521049138e-08,  3.349904163660521e-09,  1.119404588210757e-11, -4.614824457985795e-12,
 -7.101028401010066e-14,  2.946815957729188e-15,  1.178844266384642e-16, -6.883274053758458e-19, -1.192257394775572e-19,  7.325887601924811e-01, -8.516424630748585e-03,
  5.594907322970544e-05,  1.206164277825993e-07,  2.440418839833642e-09,  3.371705770665768e-11, -7.237629814279932e-12, -1.173650642180937e-13,  4.820704417727038e-15,
  1.909039234742600e-16, -1.122155408388458e-18, -1.962948322160905e-19,  9.781559237631733e-01, -1.100107982615997e-02,  5.325137241473429e-05,  6.782998153789375e-07,
 -1.909158731708409e-10,  3.765104678268667e-11, -1.094550371986571e-11, -2.133790601759822e-13,  8.403394842444776e-15,  3.313671758565887e-16, -2.117390358437180e-18,
 -3.480464647999376e-19,  1.286520804243918e+00, -1.348955090564484e-02,  1.373521304022306e-05,  2.124402870039562e-06,  6.635284831402818e-10, -2.667693868518890e-10,
 -1.537730423395408e-11, -4.057917152573293e-13,  1.579182030041747e-14,  7.196050189956127e-16, -5.777810627883562e-18, -7.893529886589764e-19,  1.687081838606582e+00,
 -1.374089254629174e-02, -1.868500873444204e-04,  4.608496477225112e-06,  1.598926304992072e-07, -2.740945744346809e-09, -1.706140029295021e-10,  1.129570289682574e-12,
  1.806658746496416e-13,  6.790590750290276e-16, -1.768812193487241e-16, -2.610615779735590e-18,  2.794239900883527e-03, -3.338667593706251e-05,  3.072402194783346e-07,
 -1.637746291297152e-09,  2.869024592171445e-11, -6.331792904051474e-13, -1.761014599230807e-14,  2.788813521958668e-16,  2.119065692070524e-17, -5.279645473609668e-20,
 -2.064779824836564e-20, -1.668184474693217e-22,  2.522873054558968e-02, -3.012093657743117e-04,  2.758929040230890e-06, -1.434754385666855e-08,  2.541102261053579e-10,
 -5.694994219688602e-12, -1.617860250125688e-13,  2.560539251023997e-15,  1.936737655560297e-16, -4.830092318996321e-19, -1.890091891954775e-19, -1.529070685421743e-21,
  7.053702703090958e-02, -8.407904575931525e-04,  7.625606871626606e-06, -3.754799655209915e-08,  6.817516212283079e-10, -1.580104392565996e-11, -4.684922770359812e-13,
  7.406465237432885e-15,  5.553139425486616e-16, -1.389136889973495e-18, -5.436566337046727e-19, -4.409310438030975e-21,  1.396465357058664e-01, -1.660220608638554e-03,
  1.481525244461382e-05, -6.612133064781348e-08,  1.258244739602606e-09, -3.092961751150930e-11, -9.784937981650567e-13,  1.544841284119002e-14,  1.144292837828534e-15,
 -2.884475678893402e-18, -1.125656640374955e-18, -9.161132453176838e-21,  2.340840330044653e-01, -2.772159777687278e-03,  2.413218618760160e-05, -9.032699502376312e-08,
  1.882778126750750e-09, -5.111549211531918e-11, -1.764587056475367e-12,  2.782960585820016e-14,  2.032851697996474e-15, -5.212732804348961e-18, -2.012778537090358e-18,
 -1.644037245883458e-20,  3.561844832423437e-01, -4.194318622061622e-03,  3.516610748038210e-05, -9.196737888905871e-08,  2.370510671608712e-09, -7.669434825787068e-11,
 -2.950433852288169e-12,  4.654324442257156e-14,  3.356371983444957e-15, -8.916076761917035e-18, -3.351061228991625e-18, -2.742517608228490e-20,  5.094761981400117e-01,
 -5.949444716197422e-03,  4.702551683355764e-05, -3.550536195267036e-08,  2.375338146186021e-09, -1.093001595596005e-10, -4.745066186619192e-12,  7.515227714726834e-14,
  5.385021118333266e-15, -1.532564013176084e-17, -5.433823455076572e-18, -4.426715410498091e-20,  6.994283361997843e-01, -8.062392739397146e-03,  5.762029893027211e-05,
  1.548911063038466e-07,  1.226042127268421e-09, -1.563870874243952e-10, -7.495385901301954e-12,  1.205116553825735e-13,  8.724851021576428e-15, -2.821817946835668e-17,
 -8.934046775387515e-18, -7.091718356441614e-20,  9.350550534120251e-01, -1.054260529430070e-02,  6.134730865025320e-05,  6.656409944946296e-07, -2.349571592807993e-09,
 -2.566884648855038e-10, -1.166031895919347e-11,  1.987503808296744e-13,  1.498810712693106e-14, -6.066427321401112e-17, -1.579437535015468e-17, -1.130075821586123e-19,
  1.232943357455321e+00, -1.327806717722474e-02,  3.904325377884969e-05,  2.069725597068861e-06, -8.897443209395605e-09, -6.944560169475630e-10, -1.649198006479825e-11,
  4.001983386275336e-13,  2.914740116107826e-14, -1.775218312770564e-16, -3.439125894645279e-17, -1.450898504936623e-19,  1.629533119164287e+00, -1.497650571556012e-02,
 -1.186708457345291e-04,  6.528037531582940e-06,  6.997264401139631e-08, -5.831882157687225e-09, -6.466409122375647e-11,  5.865431186319042e-12,  7.380267096813098e-14,
 -6.044293135136514e-15, -9.153740577501859e-17,  6.222835776260634e-18,  2.665494154597658e-03, -3.100065535451500e-05,  2.898596531208078e-07, -1.299020412085491e-09,
  1.280026215672705e-11, -8.930018795235507e-13, -1.732590464994531e-15,  7.693494066900473e-16,  5.183932278696536e-18, -7.470741436221014e-19, -7.404871932926028e-21,
  7.045119427674115e-22,  2.406703017855359e-02, -2.797673547361711e-04,  2.606806452003027e-06, -1.136769782903140e-08,  1.105477340932761e-10, -8.085918642110950e-12,
 -1.636383020074413e-14,  7.040683719130562e-15,  4.716531037202220e-17, -6.837092853550185e-18, -6.764269784001095e-20,  6.456354032657883e-21,  6.729324698403610e-02,
 -7.814299665313717e-04,  7.228346780488201e-06, -2.967450233736668e-08,  2.797184766934977e-10, -2.274594823909349e-11, -4.983409052031687e-14,  2.023683185304329e-14,
  1.339586781530435e-16, -1.965693126140898e-17, -1.936757891573484e-19,  1.861465406281315e-20,  1.332380840639059e-01, -1.544584454481504e-03,  1.411861338131468e-05,
 -5.199692195614442e-08,  4.596819795699227e-10, -4.549461078399983e-11, -1.109896825908088e-13,  4.183422959593795e-14,  2.717975808606011e-16, -4.067370896150199e-17,
 -3.978051253091623e-19,  3.869014677355491e-20,  2.233752479550411e-01, -2.583016685687068e-03,  2.318884534447596e-05, -7.029261397148094e-08,  5.352895091842576e-10,
 -7.749817306447929e-11, -2.138452103862275e-13,  7.455895005872132e-14,  4.716541363504633e-16, -7.266889378900030e-17, -7.018409963111120e-19,  6.957832544398905e-20,
  3.399636057359501e-01, -3.916897943848203e-03,  3.422869647277841e-05, -6.950923744430105e-08,  2.921336118552668e-10, -1.209594084010447e-10, -3.765223485422761e-13,
  1.233260326464929e-13,  7.517315269930392e-16, -1.208679276990655e-16, -1.142280190674602e-18,  1.168063811828340e-19,  4.864287775345464e-01, -5.574500177095550e-03,
  4.673805747818505e-05, -2.013122372484813e-08, -6.860906701283090e-10, -1.804798846450600e-10, -6.103612897292984e-13,  1.973961805101560e-13,  1.141271491007268e-15,
 -1.957363421549053e-16, -1.778575239065285e-18,  1.916983534583120e-19,  6.681125487111631e-01, -7.593955416582972e-03,  5.946624166473350e-05,  1.413902210641413e-07,
 -3.277271475571929e-09, -2.676528432416592e-10, -8.551638485269843e-13,  3.159393544562101e-13,  1.680084106536417e-15, -3.209635543747958e-16, -2.697708313832532e-18,
  3.207721818519019e-19,  8.939152527189748e-01, -1.002099096180476e-02,  6.889814788143815e-05,  5.745709212749544e-07, -9.575437648455202e-09, -4.219250809066800e-10,
 -5.672425539149637e-13,  5.255311016272399e-13,  2.333470586128553e-15, -5.618318746382123e-16, -3.921878534076241e-18,  5.815332982603100e-19,  1.180608127235156e+00,
 -1.286996364549899e-02,  6.251242713391236e-05,  1.800286691229107e-06, -2.535121343296356e-08, -8.655244937268655e-10,  5.000647589983057e-12,  9.841896087581286e-13,
  1.229512786740569e-15, -1.163858946495267e-15, -3.710024515929534e-18,  1.306160496574315e-18,  1.568239336177178e+00, -1.560261909073741e-02, -3.758098227861543e-05,
  6.688106665501158e-06, -4.840164718748802e-08, -5.358194643892853e-09,  9.823447724572276e-11,  4.618685939772971e-12, -1.385098860641660e-13, -3.913731678077024e-15,
  1.742651905392434e-16,  3.134162751355175e-18,  2.546033713955761e-03, -2.874198488041304e-05,  2.749236462758909e-07, -1.232020248304872e-09, -3.741672787273022e-12,
 -6.826603336881348e-13,  1.804845017758931e-14,  5.110551240652839e-16, -1.931385019734798e-17, -4.197337436728810e-19,  2.081318054005999e-20,  3.172502781260088e-22,
  2.298883219778277e-02, -2.594405780000149e-04,  2.475784851320801e-06, -1.084690576249251e-08, -3.923498917677355e-11, -6.174129031821689e-12,  1.645479514570084e-13,
  4.669563351757426e-15, -1.768709666443492e-16, -3.831335425332353e-18,  1.907246680666361e-19,  2.895684980808289e-21,  6.428098787493423e-02, -7.249855189466023e-04,
  6.884411567718555e-06, -2.871054288753201e-08, -1.415958618987464e-10, -1.732381576328752e-11,  4.694735692671503e-13,  1.337713027611204e-14, -5.091524687022172e-16,
 -1.095440670761443e-17,  5.498025745491602e-19,  8.277003030028153e-21,  1.272817788805230e-01, -1.434074470871999e-03,  1.350937658285889e-05, -5.166765735657016e-08,
 -3.827520003917933e-10, -3.449579977125390e-11,  9.602710424302655e-13,  2.750285654255812e-14, -1.055429131109376e-15, -2.245832835620515e-17,  1.142432093769906e-18,
  1.695508252640862e-20,  2.134089127783254e-01, -2.400850440034994e-03,  2.234661390624733e-05, -7.369769152284589e-08, -8.985472664842537e-10, -5.832925745495396e-11,
  1.689397811437419e-12,  4.860717101248115e-14, -1.889817641197469e-15, -3.955165385744567e-17,  2.053480435351996e-18,  2.979559072170120e-20,  3.248382632904787e-01,
 -3.646506558578895e-03,  3.334441776422560e-05, -8.350915202874027e-08, -1.941041747666483e-09, -8.991646935160396e-11,  2.757021623597770e-12,  7.937558872244485e-14,
 -3.150547655794664e-15, -6.433216664971277e-17,  3.444230144324418e-18,  4.821632571000206e-20,  4.648764355081385e-01, -5.202018797076117e-03,  4.631405126250305e-05,
 -5.891274916144821e-08, -4.001201947667972e-09, -1.312540024921267e-10,  4.369956836185945e-12,  1.244847540737195e-13, -5.111508484816724e-15, -1.004962390896201e-16,
  5.642366212791818e-18,  7.442229775329382e-20,  6.386971467656353e-01, -7.112729353430535e-03,  6.067622194050908e-05,  4.799288847219124e-08, -8.133361810434358e-09,
 -1.866612832877686e-10,  7.022991104911970e-12,  1.922706163028794e-13, -8.384213282993339e-15, -1.547100209512042e-16,  9.402748171174576e-18,  1.111779277214192e-19,
  8.549728281103132e-01, -9.445452406750010e-03,  7.460640111235940e-05,  3.580311488058762e-07, -1.699373882240723e-08, -2.690319233039816e-10,  1.223042658694682e-11,
  2.965985359163580e-13, -1.463966042475668e-14, -2.376946722672620e-16,  1.685506501367914e-17,  1.557633012900521e-19,  1.130253932391043e+00, -1.229157408084801e-02,
  8.115675985451140e-05,  1.271669626387578e-06, -3.936560990867936e-08, -4.473884707598911e-10,  2.723694888170224e-11,  4.316033260718763e-13, -3.057306581905093e-14,
 -3.260541142926105e-16,  3.638478519817530e-17,  1.126616555850320e-19,  1.505707802136081e+00, -1.560253784536646e-02,  3.500409812871650e-05,  5.218261798890360e-06,
 -1.244679660074021e-07, -2.028256579946944e-09,  1.546003172634709e-10, -6.304255146714366e-13, -1.474067500201374e-13,  2.949213957569128e-15,  1.093038148887012e-16,
 -4.708304874121232e-18,  2.435368329858313e-03, -2.660361654241348e-05,  2.594158820163564e-07, -1.374088072378867e-09, -1.230227157440345e-11, -1.555086609552710e-13,
  2.264577386971042e-14, -1.793431467529641e-16, -1.887239038150882e-17,  3.908942785220165e-19,  1.332151540393661e-20, -5.275826486528294e-22,  2.198983260422144e-02,
 -2.401734432450571e-04,  2.338566849638872e-06, -1.221609548130057e-08, -1.162793143909513e-10, -1.367370934603969e-12,  2.064223133341264e-13, -1.645805571289856e-15,
 -1.724192361642975e-16,  3.586271105479296e-18,  1.215917581646256e-19, -4.838955852590748e-21,  6.148893090088142e-02, -6.713487150459020e-04,  6.517102394637412e-06,
 -3.304456460536639e-08, -3.555376932678463e-10, -3.606971284736492e-12,  5.886075682407993e-13, -4.759968896557428e-15, -4.938771027065753e-16,  1.036327188088588e-17,
  3.475944084852430e-19, -1.397498104670383e-20,  1.217574996478501e-01, -1.328626914760965e-03,  1.283444525794374e-05, -6.187197057439824e-08, -8.015112124637494e-10,
 -6.439403956553620e-12,  1.202253048734842e-12, -9.950529908777555e-15, -1.015508804034034e-15,  2.161535272994760e-17,  7.123660402434777e-19, -2.912120638701572e-20,
  2.041570140706404e-01, -2.225932013364425e-03,  2.134556318712268e-05, -9.487536773615532e-08, -1.588167136146356e-09, -9.004963048235155e-12,  2.108479392023338e-12,
 -1.807299555075680e-14, -1.796259273341683e-15,  3.906029802290310e-17,  1.253593622238430e-18, -5.255060385152706e-20,  3.107785084221632e-01, -3.384398080838046e-03,
  3.210979991515291e-05, -1.248242481064549e-07, -2.961995778583556e-09, -9.614428194799756e-12,  3.418219571821801e-12, -3.085358695574485e-14, -2.940630664955591e-15,
  6.598621961838839e-17,  2.035808852260447e-18, -8.859288554689702e-20,  4.448031603620159e-01, -4.835580576614234e-03,  4.515719020330845e-05, -1.374085344864038e-07,
 -5.398965056480366e-09, -4.753282402341140e-12,  5.344181723421519e-12, -5.208620632701308e-14, -4.640229095146451e-15,  1.091320597160733e-16,  3.169981452276493e-18,
 -1.460461640905921e-19,  6.112172823015173e-01, -6.627445696244277e-03,  6.038140008139635e-05, -1.016033618101481e-07, -9.913771207574197e-09,  1.370330538984156e-11,
  8.344089431804436e-12, -9.144815970095483e-14, -7.272571222189716e-15,  1.841891861843836e-16,  4.846593778132160e-18, -2.450642846746893e-19,  8.184050092991341e-01,
 -8.836333371065657e-03,  7.715077140675471e-05,  6.085106048421410e-08, -1.905634696077530e-08,  6.801175961691615e-11,  1.362054502471505e-11, -1.803294326104972e-13,
 -1.165480238980696e-14,  3.361942307033035e-16,  7.328242842944508e-18, -4.413880738106821e-19,  1.082467083868921e+00, -1.159242444892262e-02,  9.246380038838452e-05,
  6.078321767959974e-07, -4.137941338613609e-08,  2.396056870033148e-10,  2.576282180794526e-11, -4.751363990132549e-13, -1.950819228823219e-14,  7.526669012015555e-16,
  9.655065554477532e-18, -9.406374623613903e-19,  1.444204017007570e+00, -1.510772065084488e-02,  8.495239984207852e-05,  3.089732297872059e-06, -1.316202924922183e-07,
  1.055387204755387e-09,  9.051413066185390e-11, -3.211171637417594e-12, -1.172094378157267e-14,  3.403793394081946e-15, -6.452051366669902e-17, -1.947439542458070e-18,
  2.332995277577353e-03, -2.459764924880397e-05,  2.417316252860438e-07, -1.569017422925349e-09, -1.067207756908910e-11,  2.750042422706971e-13,  1.174631938350776e-14,
 -5.019894320308749e-16, -9.047659755096073e-19,  4.643669564224077e-19, -7.649529383384486e-21, -2.770535647303246e-22,  2.106558214709689e-02, -2.220833558562990e-04,
  2.180714378962151e-06, -1.405128140411163e-08, -1.004461488769509e-10,  2.552497709127274e-12,  1.067068724779428e-13, -4.586994379541697e-15, -7.948486949963581e-18,
  4.243065162941834e-18, -7.030384872436115e-20, -2.525396153331818e-21,  5.890516040977777e-02, -6.208955750655847e-04,  6.086351591042497e-06, -3.861507046996761e-08,
 -3.047233404521478e-10,  7.544319587970953e-12,  3.021096528002648e-13, -1.314531628438969e-14, -2.085106007749206e-17,  1.215742439184177e-17, -2.038890274675654e-19,
 -7.198708435754871e-21,  1.166433321386440e-01, -1.229139522841097e-03,  1.201547000715598e-05, -7.430887888818874e-08, -6.797429928612532e-10,  1.625094199455725e-11,
  6.099638102596728e-13, -2.705955758399036e-14, -3.640469901487627e-17,  2.501067381706565e-17, -4.276658814659855e-19, -1.468285172686484e-20,  1.955869975702209e-01,
 -2.060150594571892e-03,  2.005684769140575e-05, -1.192471660852185e-07, -1.330386132724828e-09,  3.056117790872418e-11,  1.051301521416888e-12, -4.797779745280128e-14,
 -4.695924309301426e-17,  4.427496791097467e-17, -7.790120232541779e-19, -2.564628549829454e-20,  2.977440634863640e-01, -3.134304687912600e-03,  3.033445687486552e-05,
 -1.697500650914636e-07, -2.448102630554086e-09,  5.398703277138031e-11,  1.661191035897907e-12, -7.892777009790968e-14, -3.391750265934735e-17,  7.257257580734409e-17,
 -1.330301369166916e-18, -4.116720844497529e-20,  4.261708801058079e-01, -4.482352639083075e-03,  4.300745629254004e-05, -2.183288455143859e-07, -4.398700320055179e-09,
  9.341745484565834e-11,  2.498750757433926e-12, -1.257894458720537e-13,  5.134988619296401e-17,  1.147443902645037e-16, -2.231658271002774e-18, -6.289798433920485e-20,
  5.856621824790844e-01, -6.151882424884447e-03,  5.825139950328895e-05, -2.484067440177894e-07, -7.951250859492443e-09,  1.638809106488235e-10,  3.667911670943974e-12,
 -2.013428279395196e-13,  3.531669125436932e-16,  1.804286564486711e-16, -3.836024539690212e-18, -9.294599497504368e-20,  7.842916634267985e-01, -8.221181968384414e-03,
  7.614781853715890e-05, -2.177266199186507e-07, -1.500211893475329e-08,  3.044601996417810e-10,  5.360498624782268e-12, -3.391517182500969e-13,  1.401360295717384e-15,
  2.909013435846892e-16, -7.156621604564805e-18, -1.304099200021225e-19,  1.037607835372614e+00, -1.083423729688095e-02,  9.603763449707256e-05,  1.223262837874821e-08,
 -3.173648377925105e-08,  6.535749897234433e-10,  7.897765902050165e-12, -6.630866159155116e-13,  6.076996686223675e-15,  4.942508113613388e-16, -1.626487232295786e-17,
 -1.268566061533190e-19,  1.385319547681286e+00, -1.431337442805986e-02,  1.103899302840132e-04,  1.240619912052356e-06, -9.588431427363906e-08,  2.199216928256875e-09,
  9.661063461986886e-12, -2.208973366779002e-12,  5.593545066012648e-14,  3.963155102407740e-16, -6.156096222360049e-17,  1.339106245527709e-18,  2.238349691155114e-03,
 -2.274151771768551e-05,  2.220971997824061e-07, -1.685116960699449e-09, -3.451809791370126e-12,  3.979019668734431e-13, -7.127600170075573e-16, -3.367023291563534e-16,
  8.814145323916467e-18,  6.914607508446137e-20, -8.926528161526862e-21,  1.506663587041833e-22,  2.021103967872908e-02, -2.053348531594688e-04,  2.004474487955135e-06,
 -1.515347418861993e-08, -3.382260884745368e-11,  3.661505980306300e-12, -7.015606052352846e-15, -3.068919046107214e-15,  8.065813020894771e-17,  6.237615510055071e-19,
 -8.154632952865086e-20,  1.385022895333074e-21,  5.651592557346273e-02, -5.741277543897661e-04,  5.599637480492343e-06, -4.201156471647135e-08, -1.100581634182629e-10,
  1.064029936290903e-11, -2.304971776232822e-14, -8.748526657753000e-15,  2.318396857628498e-16,  1.738967688265814e-18, -2.335393759901032e-19,  4.018363216461581e-21,
  1.119131506154257e-01, -1.136738865624534e-03,  1.107112123114855e-05, -8.203988446938592e-08, -2.673554905154190e-10,  2.235897693869955e-11, -5.688767788021280e-14,
 -1.785484484101497e-14,  4.794646655095971e-16,  3.416360385464491e-18, -4.800623794215114e-19,  8.432987021735427e-21,  1.876578008546136e-01, -1.905728404275005e-03,
  1.852155664859618e-05, -1.347160259313906e-07, -5.711987795503336e-10,  4.072297237612088e-11, -1.244524945091071e-13, -3.125195715319660e-14,  8.556910217991882e-16,
  5.620578866937422e-18, -8.487603692974312e-19,  1.536768544887052e-20,  2.856784764385797e-01, -2.900350430486986e-03,  2.810308741057904e-05, -1.988423727156820e-07,
 -1.140606900596068e-09,  6.920212779745571e-11, -2.571047635024083e-13, -5.044478912096162e-14,  1.420102139751591e-15,  8.183180932481403e-18, -1.388483686730558e-18,
  2.624246787822119e-20,  4.089115135739351e-01, -4.149811838395491e-03,  4.003427421073341e-05, -2.716549665022966e-07, -2.201318682278173e-09,  1.144230359915006e-10,
 -5.207970760995527e-13, -7.813698622362317e-14,  2.289477248349365e-15,  1.049792689688274e-17, -2.188237940990844e-18,  4.396597964373142e-20,  5.619650993198076e-01,
 -5.699686509977334e-03,  5.462581588017836e-05, -3.464512353059666e-07, -4.222173558926180e-09,  1.903604626997392e-10, -1.071670845351085e-12, -1.195630815254618e-13,
  3.719618597103422e-15,  1.041266164351549e-17, -3.421230873561832e-18,  7.522851908442303e-20,  7.526036412844922e-01, -7.626037972520595e-03,  7.231010838939330e-05,
 -4.050911206719300e-07, -8.336033188445180e-09,  3.317827079594984e-10, -2.357047743232165e-12, -1.861458238774992e-13,  6.383469528103050e-15, -8.176232020374735e-19,
 -5.452420083760057e-18,  1.384686865568381e-19,  9.957975896512410e-01, -1.007295017392559e-02,  9.358651633498609e-05, -3.864316229736194e-07, -1.810654441938596e-08,
  6.542317570311642e-10, -6.163914066749941e-12, -3.073825622167525e-13,  1.271678695992304e-14, -7.270134606652587e-17, -8.987388230036225e-18,  3.012382976235666e-19,
  1.329894157180062e+00, -1.339345059043725e-02,  1.175161431555972e-04,  5.357875806992018e-08, -5.354227967145350e-08,  1.890306649464305e-09, -2.767628892346924e-11,
 -5.456677666661392e-13,  4.060819750090014e-14, -8.682198655051834e-16, -5.549664304947389e-18,  8.791617301560326e-19,  2.150808554296269e-03, -2.104597940239319e-05,
  2.017966699633569e-07, -1.680234949767253e-09,  3.738183629552086e-12,  2.997315779140368e-13, -6.223999989969636e-15, -6.895914648316813e-17,  6.714338061175450e-18,
 -1.345206372930063e-19, -1.396757747730006e-21,  1.392618822160457e-22,  1.942061431764584e-02, -1.900302411344698e-04,  1.821705773015978e-06, -1.514184152268777e-08,
  3.228743936035770e-11,  2.755175935655370e-12, -5.714505599263876e-14, -6.225734733184498e-16,  6.125490195277006e-17, -1.232242178014723e-18, -1.260427231039908e-20,
  1.271317091606421e-21,  5.430579426124148e-02, -5.313615188886686e-04,  5.091667577793885e-06, -4.216812489987774e-08,  8.174812203663455e-11,  7.988861216394582e-12,
 -1.653385918146611e-13, -1.739415660675255e-15,  1.749458313860997e-16, -3.549194797291118e-18, -3.516749113055589e-20,  3.635609518306558e-21,  1.075370387207760e-01,
 -1.052147742938926e-03,  1.007510461523890e-05, -8.295279283940011e-08,  1.346999367134435e-10,  1.672924371659807e-11, -3.452665740783701e-13, -3.434244283848136e-15,
  3.580871686323193e-16, -7.363427234735846e-18, -6.920290925086284e-20,  7.455513331391359e-21,  1.803208531367683e-01, -1.764118090796813e-03,  1.687580292894042e-05,
 -1.377432904492382e-07,  1.585594101313721e-10,  3.031833473769698e-11, -6.239832273929227e-13, -5.712591587419829e-15,  6.293406356695454e-16, -1.319953993091640e-17,
 -1.142293261624253e-19,  1.313368336267392e-20,  2.745113075808375e-01, -2.685279408233977e-03,  2.565097921702788e-05, -2.067426536282369e-07,  9.381509962977704e-11,
  5.116702989760875e-11, -1.051197596829093e-12, -8.527864166357940e-15,  1.021435615275771e-15, -2.203348631494704e-17, -1.675038094529108e-19,  2.136837454368430e-20,
  3.929315434862797e-01, -3.843009419561225e-03,  3.663473271493095e-05, -2.898430856257418e-07, -1.726736929688371e-10,  8.379417601902295e-11, -1.723035891803515e-12,
 -1.164629069674802e-14,  1.593698798957900e-15, -3.578448889735821e-17, -2.187959550834607e-19,  3.339444943523682e-20,  5.400127790395566e-01, -5.280182482306220e-03,
  5.018164949234483e-05, -3.858455611133219e-07, -8.752508880488560e-10,  1.374873274594146e-10, -2.845691609025966e-12, -1.416922354589707e-14,  2.462265442109973e-15,
 -5.865877705036888e-17, -2.317104611305482e-19,  5.149618917971673e-20,  7.232230941383492e-01, -7.068791690710905e-03,  6.685390777218654e-05, -4.898255810072007e-07,
 -2.573585873377153e-09,  2.345182115498094e-10, -4.944110331556960e-12, -1.246993905850007e-14,  3.884007115674922e-15, -1.016446271643201e-16, -6.113930852411489e-20,
  8.000455417827316e-20,  9.569680828875569e-01, -9.346800866361936e-03,  8.761075370631800e-05, -5.816463742430536e-07, -6.978043044182843e-09,  4.447173748878957e-10,
 -9.819138741880874e-12,  1.251688768632208e-14,  6.533785578961924e-15, -2.033863049423030e-16,  1.074554273496894e-18,  1.241250987429270e-19,  1.278187597478864e+00,
 -1.246269072946202e-02,  1.141410792239891e-04, -5.396638488049965e-07, -2.298025269027252e-08,  1.160686218119927e-09, -2.941997441957445e-11,  2.680906051108682e-13,
  1.191760473614893e-14, -6.120402296382770e-16,  1.213657421945044e-17,  3.553630157381035e-20,  2.069727653149518e-03, -1.951083936226086e-05,  1.821633778428662e-07,
 -1.580861767590783e-09,  8.188569678506991e-12,  1.468571512722155e-13, -5.893967503568039e-15,  6.724934547673785e-17,  1.983278469938117e-18, -1.070043782860607e-19,
  1.865230079359153e-21,  1.743622929410811e-23,  1.868850715660644e-02, -1.761709325422636e-04,  1.644672524272737e-06, -1.426141368020490e-08,  7.322983135217058e-11,
  1.353847412306573e-12, -5.397064163741122e-14,  6.182066144828696e-16,  1.800653549327110e-17, -9.764604367734363e-19,  1.709389056636308e-20,  1.568055168184082e-22,
  5.225865567436173e-02, -4.926193118354687e-04,  4.598050919571867e-06, -3.980427018125082e-08,  2.006537248770976e-10,  3.947718166844840e-12, -1.553062720207570e-13,
  1.793284740237635e-15,  5.091086097571618e-17, -2.790292177593567e-18,  4.928074622224872e-20,  4.342826490382954e-22,  1.034834264777288e-01, -9.754695772089596e-04,
  9.102144923099607e-06, -7.858375519927867e-08,  3.842591123978992e-10,  8.333223823150291e-12, -3.215867844365651e-13,  3.760407205599582e-15,  1.025100268142292e-16,
 -5.715920480734038e-18,  1.023832362612208e-19,  8.437878727514343e-22,  1.735240399613274e-01, -1.635639543329284e-03,  1.525541697840920e-05, -1.311882615103700e-07,
  6.120746050927544e-10,  1.525205638149816e-11, -5.743204435090310e-13,  6.837835014093971e-15,  1.757655833184731e-16, -1.005669308702414e-17,  1.838641732381197e-19,
  1.363888197238106e-21,  2.641650203100221e-01, -2.489901002337474e-03,  2.320832093805252e-05, -1.984499113608313e-07,  8.614626295348904e-10,  2.602554511240357e-11,
 -9.521201021382987e-13,  1.162088963817587e-14,  2.750107534754173e-16, -1.634443660367613e-17,  3.075845751784189e-19,  1.928858116501384e-21,  3.781237164530236e-01,
 -3.563778406406344e-03,  3.318797816832944e-05, -2.814681806102653e-07,  1.087973955853155e-09,  4.309954032876572e-11, -1.527368411262740e-12,  1.928711131837987e-14,
  4.058257969642915e-16, -2.554186210384608e-17,  5.006954597992534e-19,  2.343413400667305e-21,  5.196655401548884e-01, -4.897303175308356e-03,  4.554616275882984e-05,
 -3.815619680008274e-07,  1.197192178555154e-09,  7.140843456790918e-11, -2.449059532525564e-12,  3.243262174966522e-14,  5.724777275825581e-16, -3.952688660247808e-17,
  8.222035900660075e-19,  1.995910767925667e-21,  6.959797924394154e-01, -6.557857201568530e-03,  6.086302587014736e-05, -4.998355381874057e-07,  9.605355877345635e-10,
  1.224529647483146e-10, -4.075748092545768e-12,  5.788662886674658e-14,  7.601231355706912e-16, -6.241747264447868e-17,  1.423550944296743e-18, -1.329227981775596e-21,
  9.209365556516446e-01, -8.675137077244367e-03,  8.021431130956821e-05, -6.344822892298752e-07, -3.167648859867538e-10,  2.306205338884180e-10, -7.538351946058009e-12,
  1.200005788585980e-13,  7.935308099196247e-16, -1.047781126716059e-16,  2.815855691015680e-18, -1.841161182498667e-20,  1.230115283257990e+00, -1.158018657794044e-02,
  1.061091286441304e-04, -7.569022947780853e-07, -6.070891646482651e-09,  5.707226395812767e-10, -1.923300656104868e-11,  3.873907507274927e-13, -1.906236612045690e-15,
 -1.866462660692021e-16,  7.838545940276556e-18, -1.511904100566080e-19,  1.994482144395980e-03, -1.812700956424113e-05,  1.640531397989429e-07, -1.433304397746004e-09,
  9.887567002504251e-12,  3.213851914964595e-14, -3.596313844146453e-15,  8.377699521592163e-17, -5.164292000965445e-19, -3.506106084657942e-20,  1.439300913962810e-21,
 -2.369534464654187e-23,  1.800908461654347e-02, -1.636765484051115e-04,  1.481249280051144e-06, -1.293681019672348e-08,  8.897222300957345e-11,  3.037399055902241e-13,
 -3.291494327185468e-14,  7.664756360788250e-16, -4.773413056420502e-18, -3.187166033798663e-19,  1.313370966588808e-20, -2.171274071616422e-22,  5.035880553703626e-02,
 -4.576861523596286e-04,  4.141664217073230e-06, -3.614536283267731e-08,  2.470100395516962e-10,  9.281110498342187e-13, -9.461625023849062e-14,  2.201842759137308e-15,
 -1.400016883897142e-17, -9.034421310375061e-19,  3.752681060992916e-20, -6.257820217990756e-22,  9.972137118562414e-02, -9.063097803543730e-04,  8.200279407886826e-06,
 -7.148132647086237e-08,  4.834853007566155e-10,  2.088003610355516e-12, -1.955712269071471e-13,  4.547832867137999e-15, -2.985514852577432e-17, -1.826698927542350e-18,
  7.685984503174992e-20, -1.299400710020781e-21,  1.672158580581244e-01, -1.519708085988917e-03,  1.374775449503963e-05, -1.196308993995766e-07,  7.968400064943566e-10,
  4.118424195878838e-12, -3.483059929410871e-13,  8.095728372610955e-15, -5.554987565103048e-17, -3.151794885108988e-18,  1.351837288942057e-19, -2.331385069044971e-21,
  2.545620407691043e-01, -2.313493619973913e-03,  2.092310937595104e-05, -1.816215848890696e-07,  1.182965392874754e-09,  7.615594630743940e-12, -5.749946628636631e-13,
  1.336997428070751e-14, -9.726152171859809e-17, -4.977697073096783e-18,  2.195722209546680e-19, -3.894053263664596e-21,  3.643787079494867e-01, -3.311435568198603e-03,
  2.993734384686739e-05, -2.589558650524567e-07,  1.631621963768875e-09,  1.367892008459200e-11, -9.163997759185710e-13,  2.135765461070148e-14, -1.676159216183743e-16,
 -7.452122112573422e-18,  3.427493734186549e-19, -6.321509676037781e-21,  5.007766460246565e-01, -4.550833786614592e-03,  4.112003533813392e-05, -3.538437460739392e-07,
  2.117079651375576e-09,  2.450694448320739e-11, -1.454191600700395e-12,  3.410148917282327e-14, -2.954828382193025e-16, -1.077257852273998e-17,  5.292793708355873e-19,
 -1.032844344944842e-20,  6.706847587714679e-01, -6.094529380038335e-03,  5.502238818394820e-05, -4.696115721663233e-07,  2.569484529451620e-09,  4.513586108031444e-11,
 -2.377478109504660e-12,  5.655051101363526e-14, -5.598266971273630e-16, -1.504848684087970e-17,  8.320373421612195e-19, -1.770163860038410e-20,  8.874714827555799e-01,
 -8.063671469882957e-03,  7.269364489829604e-05, -6.113246452372950e-07,  2.761300561790021e-09,  9.012703132962260e-11, -4.248015630476457e-12,  1.044345705709793e-13,
 -1.253684614094785e-15, -1.880053290627812e-17,  1.381202692744089e-18, -3.417461307308107e-20,  1.185433387151061e+00, -1.076857399719974e-02,  9.674857513186370e-05,
 -7.842975890786361e-07,  1.551143091676076e-09,  2.280443024101825e-10, -9.891082229830671e-12,  2.670495302468302e-13, -4.474142274609305e-15,  7.485437205003819e-18,
  2.362188695799895e-18, -8.707586264788891e-20,  1.924493852710472e-03, -1.688067147401952e-05,  1.478107868904056e-07, -1.273898236004538e-09,  9.843910616539186e-12,
 -2.871131825163211e-14, -1.604342516420806e-15,  5.612300497581901e-17, -9.919925800690760e-19,  2.209052637044111e-21,  4.797950380545665e-22, -1.678023399923838e-23,
  1.737712967882193e-02, -1.524231031877181e-04,  1.334629285227353e-06, -1.150069490775100e-08,  8.876330453791025e-11, -2.533868263494903e-13, -1.470299082516691e-14,
  5.128265895281373e-16, -9.075356709170869e-18,  2.093293859354388e-20,  4.362859108070636e-21, -1.530866263865980e-22,  4.859167633079112e-02, -4.262199208547323e-04,
  3.731900148040704e-06, -3.214832710557382e-08,  2.475023717817857e-10, -6.745205259879404e-13, -4.237373763722952e-14,  1.469369963234333e-15, -2.606907024749620e-17,
  6.440701451000721e-20,  1.237515701531087e-20, -4.372075672534567e-22,  9.622209195970487e-02, -8.440054189403534e-04,  7.389582371555344e-06, -6.362574481282900e-08,
  4.878752782448240e-10, -1.227916872595434e-12, -8.791051621722886e-14,  3.022397299900438e-15, -5.384341205602169e-17,  1.469576661022046e-19,  2.504827742774429e-20,
 -8.947677114601390e-22,  1.613482088052964e-01, -1.415247919254506e-03,  1.239012687921060e-05, -1.066042607371383e-07,  8.126130265804851e-10, -1.794113293885977e-12,
 -1.572853481853506e-13,  5.347856232057143e-15, -9.585770259360503e-17,  2.972363659036507e-19,  4.328740364156074e-20, -1.571897095330889e-21,  2.456294969159904e-01,
 -2.154497509611311e-03,  1.886014154671933e-05, -1.621060728086637e-07,  1.225275533978833e-09, -2.156871630658491e-12, -2.609806506797260e-13,  8.756703863057586e-15,
 -1.583662497598633e-16,  5.725450795961350e-19,  6.852763093326909e-20, -2.548649435404989e-21,  3.515929278762398e-01, -3.083908912868881e-03,  2.699219044075775e-05,
 -2.316662026612143e-07,  1.729820965094733e-09, -1.911138552891039e-12, -4.180271677478674e-13,  1.381957307784515e-14, -2.532025948054193e-16,  1.095048653410884e-18,
  1.029731667641153e-19, -3.967682551046825e-21,  4.832051877284901e-01, -4.238255705735190e-03,  3.708801543833492e-05, -3.176435286912389e-07,  2.328974971761913e-09,
 -2.376609943111589e-13, -6.658663544726786e-13,  2.167777217615944e-14, -4.050090661797368e-16,  2.156190943129206e-18,  1.498046051177750e-19, -6.100453763213841e-21,
  6.471523638085888e-01, -5.676141757003732e-03,  4.965484036514132e-05, -4.238808166229810e-07,  3.017997053384919e-09,  4.746100456119874e-12, -1.088862138039995e-12,
  3.496913056902767e-14, -6.739025562548336e-16,  4.585976290489553e-18,  2.120923261884510e-19, -9.517212047555140e-21,  8.563346357437782e-01, -7.510609229135119e-03,
  6.566688349168106e-05, -5.573550745464044e-07,  3.756261603501496e-09,  1.841972210785156e-11, -1.926817281040650e-12,  6.150743188456366e-14, -1.252181730141792e-15,
  1.157523247269249e-17,  2.773299653168844e-19, -1.555111543000032e-20,  1.143848422844070e+00, -1.003153547268274e-02,  8.760090630424820e-05, -7.336306563808839e-07,
  4.263130356747515e-09,  6.494853222768677e-11, -4.284475939651620e-12,  1.402428036952939e-13, -3.230653720686206e-15,  4.640552894282419e-17,  3.492980007297526e-20,
 -2.538161047353014e-20,  1.859243031471355e-03, -1.575670958669408e-05,  1.334446059738844e-07, -1.122609797891039e-09,  8.994081853697527e-12, -5.177089661300291e-14,
 -4.461960000321917e-16,  2.813747234020303e-17, -7.108629113758281e-19,  1.032303834812465e-20,  9.162723772946616e-24, -5.467800030949495e-24,  1.678795072900379e-02,
 -1.422744464532785e-04,  1.204924840090737e-06, -1.013588651337027e-08,  8.116674238528452e-11, -4.651525950605826e-13, -4.122281243747285e-15,  2.570460192290183e-16,
 -6.492002409755488e-18,  9.446868299542020e-20,  7.462135984981797e-23, -4.971839431823223e-23,  4.694415709052999e-02, -3.978418402479362e-04,  3.369290533780110e-06,
 -2.833912101653624e-08,  2.267064688610650e-10, -1.287310654614177e-12, -1.206921044938082e-14,  7.361060476366199e-16, -1.858083424646876e-17,  2.715257238386594e-19,
  1.599369175216340e-22, -1.410179111629349e-22,  9.295965214816131e-02, -7.878125758430224e-04,  6.671798135390081e-06, -5.610545509368797e-08,  4.481074356072062e-10,
 -2.506817682148315e-12, -2.561661623589668e-14,  1.512691345477947e-15, -3.815691376161785e-17,  5.613575674403048e-19,  1.532526189951169e-22, -2.854087549656573e-22,
  1.558776642828831e-01, -1.321026709400049e-03,  1.118716267688745e-05, -9.404971496302436e-08,  7.493956943033088e-10, -4.099810579453794e-12, -4.717393001170961e-14,
  2.672364674068114e-15, -6.736730425659270e-17,  1.000821241400827e-18, -1.791460124314223e-22, -4.931807128311754e-22,  2.373014129353762e-01, -2.011069309917609e-03,
  1.703017301835978e-05, -1.431136302854099e-07,  1.136537576245464e-09, -6.017604532841007e-12, -8.096236448738416e-14,  4.364571983395635e-15, -1.100057699245730e-16,
  1.656836408232878e-18, -1.327864938305011e-21, -7.806594635007528e-22,  3.396722173200395e-01, -2.878626713648346e-03,  2.437555301178444e-05, -2.047241810853479e-07,
  1.618116614916535e-09, -8.158522307841361e-12, -1.346115397140962e-13,  6.859076324638213e-15, -1.730325703080879e-16,  2.656667566989047e-18, -4.389405208445153e-21,
 -1.172994090404336e-21,  4.668223201151654e-01, -3.956170071130458e-03,  3.349740831978500e-05, -2.811049874720039e-07,  2.206428328296592e-09, -1.029743329342133e-11,
 -2.230012450502500e-13,  1.068324434873670e-14, -2.703639174451422e-16,  4.266832403937468e-18, -1.209316299564247e-20, -1.706895308816530e-21,  6.252112178989206e-01,
 -5.298428945971992e-03,  4.485734058778692e-05, -3.759619122980715e-07,  2.919111862821898e-09, -1.188011225391198e-11, -3.791260743651672e-13,  1.701698264496416e-14,
 -4.341373696514422e-16,  7.141139927845351e-18, -3.249370271621701e-20, -2.420744184763783e-21,  8.273019719048601e-01, -7.010991232604277e-03,  5.934465752563394e-05,
 -4.963107590267708e-07,  3.780139311396352e-09, -1.125158654206811e-11, -6.940441507505012e-13,  2.918538094527372e-14, -7.593155713774412e-16,  1.337876819955805e-17,
 -9.736537903757139e-20, -3.201291982412359e-21,  1.105069868145023e+00, -9.364714655777401e-03,  7.923455206077236e-05, -6.594713107860439e-07,  4.797968444261560e-09,
 -9.285584144415968e-13, -1.561549051576770e-12,  6.228303962148926e-14, -1.714647088645403e-15,  3.481854164279521e-17, -4.396705573350079e-19, -1.049829655572647e-21,
  1.798269335107990e-03, -1.474067293366463e-05,  1.208012968202148e-07, -9.873437022436037e-10,  7.903543900588660e-12, -5.525924466036004e-14,  7.745951272123388e-17,
  1.106099837222788e-17, -3.721458631169592e-19,  7.818216033656124e-21, -9.724184483839910e-23, -3.125179521237976e-25,  1.623739161806134e-02, -1.331002243149563e-04,
  1.090767552462568e-06, -8.914954017861775e-09,  7.134913319745256e-11, -4.981161863949617e-13,  6.628839132909270e-16,  1.011517340479985e-16, -3.396245364751501e-18,
  7.138633011530470e-20, -8.902533036746986e-22, -2.757903899021832e-24,  4.540462898863597e-02, -3.721881583098665e-04,  3.050100784456304e-06, -2.492761239491250e-08,
  1.994235974647082e-10, -1.387990748306159e-12,  1.641821377039464e-15,  2.902632427539807e-16, -9.706087437712588e-18,  2.042354041079421e-19, -2.560984581453347e-21,
 -7.324255126201512e-24,  8.991105345271747e-02, -7.370133325336370e-04,  6.039822171423708e-06, -4.935807694730835e-08,  3.946186073061938e-10, -2.733093984093817e-12,
  2.581894431195949e-15,  5.982596874467127e-16, -1.988454373236545e-17,  4.191639647141564e-19, -5.301726753574550e-21, -1.318425507946791e-23,  1.507656834527930e-01,
 -1.235846480076271e-03,  1.012766282602594e-05, -8.275539105561889e-08,  6.610180598964696e-10, -4.545258150346779e-12,  2.690622143592052e-15,  1.060855364136912e-15,
 -3.498256580402347e-17,  7.394707350442062e-19, -9.470279916208064e-21, -1.852101544938603e-23,  2.295191655549728e-01, -1.881397894843037e-03,  1.541770127419176e-05,
 -1.259623350792280e-07,  1.004825809030437e-09, -6.838545676696929e-12,  5.614355631448726e-16,  1.739991597391229e-15, -5.683162553705793e-17,  1.206327734372259e-18,
 -1.571863375063637e-20, -1.932689971186804e-23,  3.285327641917762e-01, -2.693022181590109e-03,  2.206840254506383e-05, -1.802600668936912e-07,  1.435326316491561e-09,
 -9.625022785468703e-12, -6.379481629346194e-15,  2.746322316846556e-15, -8.872851755478391e-17,  1.895272576485820e-18, -2.529181783519454e-20, -6.250076696157775e-24,
  4.515130591751094e-01, -3.701100797182851e-03,  3.032846673422092e-05, -2.476546397212857e-07,  1.966717288740268e-09, -1.290173214007714e-11, -2.319747911148154e-14,
  4.292912034066046e-15, -1.370966765390296e-16,  2.957291854516117e-18, -4.080802907904914e-20,  4.480347700806716e-23,  6.047077404003831e-01, -4.956842964566823e-03,
  4.061697113253340e-05, -3.315146405096102e-07,  2.621963243031091e-09, -1.660656928923384e-11, -6.115404194454163e-14,  6.845797988302174e-15, -2.162468988278242e-16,
  4.740696939974324e-18, -6.871170723413812e-20,  2.067282991313062e-22,  8.001712249608961e-01, -6.559050475620352e-03,  5.374211618514893e-05, -4.382999754283584e-07,
  3.442313977763291e-09, -2.043467485437648e-11, -1.510440717196709e-13,  1.167177828065230e-14, -3.662590985106818e-16,  8.271346986558824e-18, -1.297044633706350e-19,
  7.709591931003168e-22,  1.068830469535659e+00, -8.761199917050058e-03,  7.177567401893253e-05, -5.843936145568561e-07,  4.518314647326470e-09, -2.264119561470380e-11,
 -4.212938356471861e-13,  2.413801668158924e-14, -7.667542374489104e-16,  1.855551452935018e-17, -3.393211708265136e-19,  3.855614787533589e-21,  1.741167351582076e-03,
 -1.381958819546297e-05,  1.096760048681619e-07, -8.695433149542432e-10,  6.836086689656444e-12, -5.079615762962695e-14,  2.574281193649171e-16,  2.913053743059385e-18,
 -1.589338844653665e-19,  4.172165298447897e-21, -7.694511405662464e-23,  8.458595753445304e-25,  1.572179187692850e-02, -1.247833422627966e-04,  9.903138251412067e-07,
 -7.851432063582277e-09,  6.172102587107551e-11, -4.583716057879873e-13,  2.311198368451995e-15,  2.679857251630068e-17, -1.450381641266424e-18,  3.805929111695649e-20,
 -7.025196157992862e-22,  7.747072451706463e-24,  4.396285729805974e-02, -3.489317186116064e-04,  2.769211168365061e-06, -2.195456049247807e-08,  1.725610057974855e-10,
 -1.280066995445971e-12,  6.386153180821405e-15,  7.780791222460843e-17, -4.144482023596212e-18,  1.086749225410243e-19, -2.009623502144223e-21,  2.230469125745498e-23,
  8.705603217635574e-02, -6.909607154248704e-04,  5.483628506821648e-06, -4.347354143734783e-08,  3.416154856537476e-10, -2.529528635134544e-12,  1.240425772733041e-14,
  1.631467369298900e-16, -8.488083000689598e-18,  2.223451357878180e-19, -4.123618767660122e-21,  4.623526621036422e-23,  1.459782955302614e-01, -1.158624483410527e-03,
  9.195090114194719e-06, -7.289472185642141e-08,  5.726058269086010e-10, -4.228727281487257e-12,  2.020980780580159e-14,  2.957709560434929e-16, -1.492351328266552e-17,
  3.904650040684669e-19, -7.272726339910346e-21,  8.273921917608340e-23,  2.222310562975201e-01, -1.763839485067344e-03,  1.399814285877104e-05, -1.109652182173369e-07,
  8.712285037114205e-10, -6.410093427542646e-12,  2.949948385510899e-14,  4.981297295849844e-16, -2.421453328291175e-17,  6.328651658467489e-19, -1.186022851986169e-20,
  1.376627523313820e-22,  3.181006020831389e-01, -2.524751610807979e-03,  2.003675277378687e-05, -1.588220559288111e-07,  1.246107773141856e-09, -9.120014816388570e-12,
  3.966642071364665e-14,  8.102089697081855e-16, -3.771825680262613e-17,  9.851773965203747e-19, -1.862583495062434e-20,  2.221982565847548e-22,  4.371758190273314e-01,
 -3.469845175354145e-03,  2.753689551491896e-05, -2.182485888048071e-07,  1.710666849928864e-09, -1.242438554386145e-11,  4.941924996731581e-14,  1.308507525249835e-15,
 -5.803161082085947e-17,  1.516658066397520e-18, -2.904701365067411e-20,  3.599325167803408e-22,  5.855060182033238e-01, -4.647132211446671e-03,  3.687943351605958e-05,
 -2.922470819488022e-07,  2.287242309929193e-09, -1.641657183630522e-11,  5.570127661939590e-14,  2.158299635989565e-15, -9.079373205326218e-17,  2.381071645790192e-18,
 -4.652599803050248e-20,  6.089655510834573e-22,  7.747628659753658e-01, -6.149247509817980e-03,  4.879910698317420e-05, -3.865989856457602e-07,  3.018040374895417e-09,
 -2.122106992924976e-11,  4.978323618830116e-14,  3.798574322753848e-15, -1.511926782222090e-16,  4.006620761245479e-18, -8.103896976879977e-20,  1.155402665566031e-21,
  1.034891353079890e+00, -8.213853457534776e-03,  6.518050943352014e-05, -5.160855761970281e-07,  4.007100820795060e-09, -2.688265001466905e-11, -5.267259563001336e-15,
  8.000903849724942e-15, -3.026195665186772e-16,  8.288205641005192e-18, -1.806389259749858e-19,  3.022793911429047e-21  };
  constexpr double w[4224] = {  2.713690595932859e-01, -3.515595142922015e-03,  5.096316735419691e-05, -7.727706863407616e-07,  1.179685663078811e-08,
 -1.784689776348988e-10,  2.661210992490681e-12, -3.908109947159908e-14,  5.655159247646613e-16, -8.072456888719508e-18,  1.137830189791741e-19, -1.584982762912131e-21,
  2.574596996933166e-01, -7.579423084117414e-03,  2.260356512085413e-04, -6.038040180281354e-06,  1.482358697461374e-07, -3.411862397913002e-09,  7.452882621615894e-11,
 -1.557715022668532e-12,  3.133402129835432e-14, -6.092753018830919e-16,  1.149106172128771e-17, -2.107164375320740e-19,  2.324127659903851e-01, -1.426138469126863e-02,
  6.781242253246591e-04, -2.666182093918175e-05,  9.213291748300851e-07, -2.886617809473677e-08,  8.357426835139994e-10, -2.264758320900371e-11,  5.797046890997673e-13,
 -1.411200611208555e-14,  3.284366121204153e-16, -7.335156632459016e-18,  2.006433310357017e-01, -2.136384721621868e-02,  1.482650578551925e-03, -8.037583758596198e-05,
  3.683379058912848e-06, -1.486741259048862e-07,  5.419841757128068e-09, -1.814619883642793e-10,  5.646987562856307e-12, -1.647933425399409e-13,  4.540752895462383e-15,
 -1.187073143032110e-16,  1.666413298597613e-01, -2.686178256689322e-02,  2.557149529044831e-03, -1.815920984168233e-04,  1.055530872264913e-05, -5.273475493697706e-07,
  2.333199422840686e-08, -9.326716933930710e-10,  3.416841265623064e-11, -1.159477015447656e-12,  3.674592204272620e-14, -1.093882545883683e-15,  1.337804295767708e-01,
 -2.953024062208452e-02,  3.644985510430629e-03, -3.242395674871271e-04,  2.301294502212637e-05, -1.375888249994290e-06,  7.165175653306584e-08, -3.324254784497522e-09,
  1.396366862988899e-10, -5.375217538756331e-12,  1.914055842448900e-13, -6.346301627471892e-15,  1.038947389715438e-01, -2.906116038456551e-02,  4.418086596207402e-03,
 -4.725270674400299e-04,  3.954650433558183e-05, -2.743612217459031e-06,  1.635591840898997e-07, -8.585520927682735e-09,  4.038704764738208e-10, -1.725273953626715e-11,
  6.762328560531759e-13, -2.449498643872878e-14,  7.749171430590984e-02, -2.580832546694082e-02,  4.612460063932576e-03, -5.707734730448046e-04,  5.449191674597594e-05,
 -4.259931298581538e-06,  2.831195385674223e-07, -1.641340396380946e-08,  8.456575990628878e-10, -3.927326855538423e-11,  1.662301020857950e-12, -6.461979371084439e-14,
  5.423179134015754e-02, -2.042993370120988e-02,  4.114078985493973e-03, -5.679920488184726e-04,  5.991107884849976e-05, -5.128843537718008e-06,  3.703209135445672e-07,
 -2.315860187665971e-08,  1.278921474347378e-09, -6.329744053898454e-11,  2.840402621540720e-12, -1.164965864737941e-13,  3.337185895771228e-02, -1.361980474099407e-02,
  2.972138056182626e-03, -4.421588357489267e-04,  4.994582387695343e-05, -4.552238682671411e-06,  3.480705838807852e-07, -2.293871735503092e-08,  1.329078456282686e-09,
 -6.873899299970751e-11,  3.211635001041089e-12, -1.366816640315882e-13,  1.406527189589651e-02, -5.990447716528837e-03,  1.365811474057570e-03, -2.117184106258463e-04,
  2.483935813272735e-05, -2.344024151272711e-06,  1.850240627574423e-07, -1.255412709340977e-08,  7.470660670462371e-10, -3.959419408584335e-11,  1.891861450814135e-12,
 -8.218227396842993e-14,  2.580675577813344e-01, -3.142024487876662e-03,  4.271493384179251e-05, -6.094442146152041e-07,  8.787065072352327e-09, -1.259264419846644e-10,
  1.782157580350800e-12, -2.487590944339181e-14,  3.424720762815807e-16, -4.655293267650959e-18,  6.252555563193801e-20, -8.305540817230767e-22,  2.303504864249304e-01,
 -6.025264429300798e-03,  1.658366712921487e-04, -4.128001258690614e-06,  9.486246735179971e-08, -2.050751121201625e-09,  4.219421014937300e-11, -8.326477616963918e-13,
  1.584640237693756e-14, -2.920525827066091e-16,  5.229414607948514e-18, -9.118023797475673e-20,  1.844946335751076e-01, -9.903288649598649e-03,  4.305986196705126e-04,
 -1.563245701175434e-05,  5.023467542082375e-07, -1.471398969080711e-08,  3.999265224504641e-10, -1.020930008843397e-11,  2.469059654539731e-13, -5.693656647784025e-15,
  1.258172415427209e-16, -2.673726884578798e-18,  1.339671739344766e-01, -1.254616711365028e-02,  7.925458904296751e-04, -3.958194203880466e-05,  1.685237580625343e-06,
 -6.359162619632642e-08,  2.177958566949296e-09, -6.879080260177377e-11,  2.026607610152731e-12, -5.616132215287663e-14,  1.473538776887333e-15, -3.677433260741674e-17,
  8.950831627708004e-02, -1.289037171243996e-02,  1.122042289476953e-03, -7.372412395903470e-05,  3.998223598535101e-06, -1.875597586497738e-07,  7.831947644016529e-09,
 -2.967471559853903e-10,  1.034246800023710e-11, -3.349703923680290e-13,  1.016123818518617e-14, -2.903012849738460e-16,  5.602596628831523e-02, -1.128549286272679e-02,
  1.289199637197430e-03, -1.071644481011409e-04,  7.159309560429767e-06, -4.052263563955453e-07,  2.007326635637815e-08, -8.894218212040724e-10,  3.580505662684681e-11,
 -1.324944508008310e-12,  4.547701404270168e-14, -1.457057232613948e-15,  3.346833808914509e-02, -8.745692120604883e-03,  1.251243275250072e-03, -1.267991433405184e-04,
  1.011129651653224e-05, -6.714939729508851e-07,  3.846928904313178e-08, -1.947089614758998e-09,  8.857564549675898e-11, -3.668645369041118e-12,  1.397393878676664e-13,
 -4.929388393446405e-15,  1.935357002136643e-02, -6.159633457348370e-03,  1.055108513251248e-03, -1.256624918686517e-04,  1.159002536096583e-05, -8.781759073882248e-07,
  5.672870910603409e-08, -3.204477130973897e-09,  1.612207662380153e-10, -7.325320511982956e-12,  3.038698306724785e-13, -1.159517889493183e-14,  1.082976087523167e-02,
 -3.974823151024981e-03,  7.803625782109636e-04, -1.052607627385760e-04,  1.087068416076097e-05, -9.129194512846560e-07,  6.477369888738828e-08, -3.986571445997033e-09,
  2.169617939247564e-10, -1.059496170337311e-11,  4.696061329450030e-13, -1.904313009822194e-14,  5.615751998857117e-03, -2.264911671085368e-03,  4.883700117902535e-04,
 -7.184868541073746e-05,  8.033395889298576e-06, -7.253719943549590e-07,  5.498963632696527e-08, -3.595571341572745e-09,  2.068285195799279e-10, -1.062604039668425e-11,
  4.934298944010363e-13, -2.088080197143009e-14,  2.138804015624099e-03, -9.075192258743213e-04,  2.060999441497353e-04, -3.182814578220133e-05,  3.720984056656377e-06,
 -3.499802265312023e-07,  2.754019719005442e-08, -1.863240546661209e-09,  1.105767680301456e-10, -5.845625118186093e-12,  2.786437056467486e-13, -1.207706523802326e-14,
  2.461397205731937e-01, -2.827345659151501e-03,  3.616898044622077e-05, -4.868918361868401e-07,  6.645636090499991e-09, -9.041379679373653e-11,  1.216933650563668e-12,
 -1.617878431484888e-14,  2.123238349062093e-16, -2.753917873701013e-18,  3.530802926927431e-20, -4.481234401493391e-22,  2.086218116701600e-01, -4.873707760702372e-03,
  1.242127629219356e-04, -2.890308251339748e-06,  6.234521698757020e-08, -1.269003287630986e-09,  2.464673819982728e-11, -4.601229168363636e-13,  8.299852996852167e-15,
 -1.452288844809039e-16,  2.472572731110289e-18, -4.104945245513660e-20,  1.507501530054702e-01, -7.091621188305599e-03,  2.829809018188674e-04, -9.510897584636422e-06,
  2.848154359567347e-07, -7.812882263300824e-09,  1.996546604941083e-10, -4.807444984364407e-12,  1.099682126576812e-13, -2.404334096101191e-15,  5.048373578611783e-17,
 -1.021421630758252e-18,  9.399453704114706e-02, -7.728344459026606e-03,  4.450574271211153e-04, -2.049626163634574e-05,  8.113066435831976e-07, -2.863417861322458e-08,
  9.216414174830079e-10, -2.746510947398648e-11,  7.659877968558439e-13, -2.015443710180521e-14,  5.034038860154716e-16, -1.198869452086331e-17,  5.152515849916144e-02,
 -6.595729074106647e-03,  5.241118324815346e-04, -3.182080499687094e-05,  1.608196141184653e-06, -7.075486112770677e-08,  2.785187664038431e-09, -9.990622555531856e-11,
  3.308566755399971e-12, -1.021461320808119e-13,  2.962088713566748e-15, -8.110959872611157e-17,  2.547609309462774e-02, -4.648559309018982e-03,  4.893090689674273e-04,
 -3.787607453169506e-05,  2.374644941885120e-06, -1.269010192191814e-07,  5.964459291470053e-09, -2.517990839156625e-10,  9.692636080306259e-12, -3.440426150149058e-13,
  1.135892627703533e-14, -3.509673670888103e-16,  1.172674802657353e-02, -2.839678818424696e-03,  3.800915632250408e-04, -3.632073412266263e-05,  2.748234461112713e-06,
 -1.740650106185615e-07,  9.551185451890628e-09, -4.647117799168277e-10,  2.038633015769127e-11, -8.165156996639056e-13,  3.014982404800825e-14, -1.033357315566270e-15,
  5.198282644530098e-03, -1.569928776726489e-03,  2.562650447224782e-04, -2.923199180316018e-05,  2.593644121642505e-06, -1.897628819624302e-07,  1.187503546996622e-08,
 -6.516336688845836e-10,  3.192586805116614e-11, -1.415666262700423e-12,  5.742067875526259e-14, -2.146198877556814e-15,  2.276378318642249e-03, -8.100995023708972e-04,
  1.543944771474676e-04, -2.027141480679671e-05,  2.043061747123654e-06, -1.678289072390309e-07,  1.167143866389590e-08, -7.053297780578272e-10,  3.775094672296111e-11,
 -1.815531053364534e-12,  7.934867297006079e-14, -3.176463677685933e-15,  9.708098299499493e-04, -3.860200454629070e-04,  8.206156342061436e-05, -1.191535990138352e-05,
  1.316383525553670e-06, -1.175713298354578e-07,  8.824604479730628e-09, -5.717784420318408e-10,  3.261723801292417e-11, -1.662957099523107e-12,  7.667834968554911e-14,
 -3.223865540825846e-15,  3.282170017750327e-04, -1.386584645519937e-04,  3.134631331089207e-05, -4.819877111917564e-06,  5.612054691645798e-07, -5.258582475296402e-08,
  4.123506494196442e-09, -2.780652919612421e-10,  1.645183622526188e-11, -8.672410886476694e-13,  4.122821199189961e-14, -1.782448318709870e-15,  2.353744206962554e-01,
 -2.559684842187771e-03,  3.090933672701931e-05, -3.935822783501425e-07,  5.096342575227644e-09, -6.595843305658146e-11,  8.458858137498194e-13, -1.073239396288468e-14,
  1.344908118258921e-16, -1.667837532801177e-18,  2.044036370772892e-20, -2.484611292051378e-22,  1.909163577816086e-01, -4.003522382656268e-03,  9.476997879854936e-05,
 -2.067582171597702e-06,  4.197364835571866e-08, -8.062971935298920e-10,  1.481373559405420e-11, -2.621324201772997e-13,  4.489649302893942e-15, -7.470604060052794e-17,
  1.211183222427350e-18, -1.917264031973637e-20,  1.262841310961455e-01, -5.217212711941457e-03,  1.917694337493003e-04, -5.983077720883003e-06,  1.673318643466580e-07,
 -4.306773019750872e-09,  1.036412387821657e-10, -2.357142830200415e-12,  5.105917613702572e-14, -1.059533056787798e-15,  2.115724689864863e-17, -4.078574789222060e-19,
  6.890698422637798e-02, -4.967867869164894e-03,  2.613713952385672e-04, -1.111403844293887e-05,  4.094305673692511e-07, -1.352658674849431e-08,  4.094022844283084e-10,
 -1.151561274310964e-11,  3.041158470870020e-13, -7.598333777730418e-15,  1.806678002538541e-16, -4.105370555090256e-18,  3.161025916910360e-02, -3.580732663627121e-03,
  2.595537959303342e-04, -1.455109304403311e-05,  6.848715123607172e-07, -2.824024098260288e-08,  1.047141131893899e-09, -3.553092755216346e-11,  1.117063657429630e-12,
 -3.284342666016359e-14,  9.095491233010199e-16, -2.384603605105081e-17,  1.254146034460800e-02, -2.058362602482219e-03,  1.989021120769932e-04, -1.429563262201168e-05,
  8.389874477224687e-07, -4.223404773043273e-08,  1.879385029197960e-09, -7.543894421188049e-11,  2.771210495061693e-12, -9.417102048641405e-14,  2.985075544620253e-15,
 -8.878325253908228e-17,  4.476006869721251e-03, -9.960596820249377e-04,  1.240170894375081e-04, -1.112314162870833e-05,  7.954412992494601e-07, -4.787984660205078e-08,
  2.508287930635857e-09, -1.169696479896276e-10,  4.934690086794868e-12, -1.906336481375960e-13,  6.807269041363871e-15, -2.261701139156909e-16,  1.510072698894817e-03,
 -4.293728068691164e-04,  6.637803762666207e-05, -7.214587858781667e-06,  6.130583209904102e-07, -4.314201929157186e-08,  2.606153561907369e-09, -1.384849896926443e-10,
  6.588088490495534e-12, -2.843393136974487e-13,  1.124938383006479e-14, -4.109241293479189e-16,  5.071305630296442e-04, -1.739914191736413e-04,  3.203216130710534e-05,
 -4.076339070327731e-06,  3.994511161824437e-07, -3.199193545163826e-08,  2.174353997050142e-09, -1.286882168328233e-10,  6.757921779292411e-12, -3.193985425083309e-13,
  1.373850624205517e-14, -5.419860554535447e-16,  1.732234266124048e-04, -6.770938257102077e-05,  1.415243254575610e-05, -2.023268810738765e-06,  2.203975236163999e-07,
 -1.943452011720127e-08,  1.441863511272984e-09, -9.244079064865010e-11,  5.222629703540688e-12, -2.639270413310218e-13,  1.207125406595723e-14, -5.037600368065445e-16,
  5.090590260622679e-05, -2.139504857036609e-05,  4.810999549567043e-06, -7.360301313783532e-07,  8.529968310337999e-08, -7.958120370704324e-09,  6.215320106073994e-10,
 -4.175654474914659e-11,  2.461993539881137e-12, -1.293629487003133e-13,  6.131334410573322e-15, -2.643353677986641e-16,  2.256021517252182e-01, -2.330009457056084e-03,
  2.663537917497485e-05, -3.215851933082129e-07,  3.958142345438188e-09, -4.882726296140305e-11,  5.976168300973847e-13, -7.250672418826922e-15,  8.687080544072269e-17,
 -1.032570443533681e-18,  1.209702918214990e-20, -1.415205702688014e-22,  1.762760980070600e-01, -3.334301038435046e-03,  7.351270118663088e-05, -1.507926498031688e-06,
  2.888294017869578e-08, -5.247968643835799e-10,  9.139288360205076e-12, -1.535735973597116e-13,  2.501774381033150e-15, -3.965009824562583e-17,  6.130540468603016e-19,
 -9.265804306872874e-21,  1.080854865690534e-01, -3.930498278881206e-03,  1.335774716472130e-04, -3.879221900752327e-06,  1.015477119195640e-07, -2.456922064001202e-09,
  5.577037127302492e-11, -1.199787892695889e-12,  2.464227982106053e-14, -4.858686408249349e-16,  9.235824937531917e-18, -1.697798234357074e-19,  5.250669173418434e-02,
 -3.316571231925199e-03,  1.598519266519481e-04, -6.286195179841115e-06,  2.158057313513411e-07, -6.680915289416251e-09,  1.903026705125195e-10, -5.055676592338493e-12,
  1.264887815715884e-13, -3.001980672862974e-15,  6.796363624848603e-17, -1.473674934544625e-18,  2.055013289891769e-02, -2.051949718983008e-03,  1.356973943792384e-04,
 -7.023573739336614e-06,  3.078099672001970e-07, -1.189230051155627e-08,  4.152197673353388e-10, -1.332097959323127e-11,  3.973613379439298e-13, -1.111892669847248e-14,
  2.938516762387335e-16, -7.370383521578926e-18,  6.657952082805346e-03, -9.763566071608788e-04,  8.635937775952621e-05, -5.749763665091786e-06,  3.152462496382246e-07,
 -1.492078174063237e-08,  6.275102419004449e-10, -2.390825414709506e-11,  8.367052285458442e-13, -2.717519232236440e-14,  8.256713808626386e-16, -2.360043687707149e-17,
  1.861485457361706e-03, -3.774601172256587e-04,  4.348013985695596e-05, -3.644535327901797e-06,  2.454142699925799e-07, -1.399265509608616e-08,  6.977436388475372e-10,
 -3.109909625882798e-11,  1.258428851463641e-12, -4.677453169553876e-14,  1.611455988203797e-15, -5.178568031943801e-17,  4.767803072234693e-04, -1.265415916147562e-04,
  1.840693172593490e-05, -1.896113856448146e-06,  1.536030498929677e-07, -1.035478204822062e-08,  6.016500817223352e-10, -3.085713045441588e-11,  1.421107295412961e-12,
 -5.953399944226204e-14,  2.291571046351213e-15, -8.161514207554339e-17,  1.206236436322960e-04, -3.963070102974813e-05,  7.008015277231391e-06, -8.602407082406090e-07,
  8.162084705559976e-08, -6.350152198210887e-09,  4.204370550698336e-10, -2.429936176707978e-11,  1.248760234446291e-12, -5.786583700437460e-14,  2.444404008596087e-15,
 -9.484695692310210e-17,  3.208171591399628e-05, -1.228262156699414e-05,  2.515854245920670e-06, -3.531053329779234e-07,  3.782997565499363e-08, -3.286146056834839e-09,
  2.405153746617486e-10, -1.523122249724096e-11,  8.509308450390910e-13, -4.256457555170807e-14,  1.928650807744007e-15, -7.980069276144610e-17,  7.994580056913468e-06,
 -3.339419608723054e-06,  7.462018682749598e-07, -1.134881789965785e-07,  1.308077087213570e-08, -1.214269314357033e-09,  9.439692542369563e-11, -6.314847655953655e-12,
  3.708578449396119e-13, -1.941497104753389e-14,  9.170639273176892e-16, -3.941138349077416e-17,  2.166852675514862e-01, -2.131355373823922e-03,  2.312646096247861e-05,
 -2.653517697709234e-07,  3.110069545096075e-09, -3.663784696805869e-11,  4.285292776892033e-13, -4.983121566775557e-15,  5.709228909331887e-17, -6.534629713007724e-19,
  7.281945867995390e-21, -8.300481878501719e-23,  1.640106234222708e-01, -2.811450655783803e-03,  5.787894714963441e-05, -1.119163959787631e-06,  2.027384180617049e-08,
 -3.491757762599711e-10,  5.775070616026676e-12, -9.231756394341903e-14,  1.432759916206348e-15, -2.166184124326341e-17,  3.198714433758931e-19, -4.622295387812673e-21,
  9.424051581212251e-02, -3.023773059738578e-03,  9.536163884312391e-05, -2.584844865448338e-06,  6.347321413457782e-08, -1.446387969750036e-09,  3.102128437527740e-11,
 -6.321979983779274e-13,  1.232807576596357e-14, -2.312273852813168e-16,  4.188575133901401e-18, -7.349107015465490e-20,  4.139154236272056e-02, -2.289546246840780e-03,
  1.014152087144274e-04, -3.695113161815740e-06,  1.183932986364990e-07, -3.438796086521809e-09,  9.228002903338488e-11, -2.317402417678759e-12,  5.496494010770568e-14,
 -1.239780367262899e-15,  2.673563061292896e-17, -5.533321428265339e-19,  1.407783931462752e-02, -1.234875280662236e-03,  7.457602391852294e-05, -3.564949619298127e-06,
  1.455128391831416e-07, -5.268116639650006e-09,  1.731927911217506e-10, -5.252631890347794e-12,  1.486236280868555e-13, -3.956500628001398e-15,  9.973884810637470e-17,
 -2.392002874446346e-18,  3.793988848093605e-03, -4.940298323804149e-04,  3.991647330196615e-05, -2.457730065576851e-06,  1.257022695700234e-07, -5.586141196976079e-09,
  2.217282343542688e-10, -8.007562096986364e-12,  2.666110529505479e-13, -8.264740249112332e-15,  2.403559498690758e-16, -6.593182085699283e-18,  8.425223023715033e-04,
 -1.543568491001925e-04,  1.636965202840336e-05, -1.277365486741369e-06,  8.072589958066558e-08, -4.346903021632668e-09,  2.057593008381990e-10, -8.742903875171556e-12,
  3.385158586412692e-13, -1.207811359724848e-14,  4.005763470200699e-16, -1.242469783740489e-17,  1.642574673280934e-04, -4.031690835564043e-05,  5.481571856894352e-06,
 -5.322819152398542e-07,  4.091865373939840e-08, -2.631736996576443e-09,  1.465434358738929e-10, -7.230144169554311e-12,  3.213741459273910e-13, -1.303130829862800e-14,
  4.867410429611023e-16, -1.686099073663992e-17,  3.086580619960366e-05, -9.635120162777466e-06,  1.626110080740350e-06, -1.915090609898195e-07,  1.751297263296355e-08,
 -1.318264516682333e-09,  8.472290629581571e-11, -4.766496294923153e-12,  2.390291480058460e-13, -1.083161691486650e-14,  4.482976610602237e-16, -1.707214725220344e-17,
  6.208087958353528e-06, -2.317491255453740e-06,  4.633068431526456e-07, -6.361610589196735e-08,  6.682878702917820e-09, -5.703637061103353e-10,  4.108722685770120e-11,
 -2.564848103479049e-12,  1.414376263884851e-13, -6.991548369121779e-15,  3.133890883287990e-16, -1.283961595607351e-17,  1.274226311816674e-06, -5.283279573953635e-07,
  1.171723729759810e-07, -1.769636703206684e-08,  2.026674120168238e-09, -1.870334515760788e-10,  1.446202568554342e-11, -9.627010222616246e-13,  5.628110661958928e-14,
 -2.934062520072567e-15,  1.380525463819768e-16, -5.911577664331342e-18,  2.085108278445288e-01, -1.958286912531913e-03,  2.021831428018024e-05, -2.209378954644839e-07,
  2.469839401268886e-09, -2.784091819808815e-11,  3.114055440288141e-13, -3.482796751951994e-15,  3.803431381775119e-17, -4.240829689292201e-19,  4.431444436308214e-21,
 -4.920136363581298e-23,  1.536129696268671e-01, -2.397110298807667e-03,  4.618701082248720e-05, -8.439140095540791e-07,  1.449097723920686e-08, -2.370531163888830e-10,
  3.730367901770748e-12, -5.682574545780674e-14,  8.415472576992711e-16, -1.215563604885306e-17,  1.716716294757264e-19, -2.374725615217698e-21,  8.349653487686133e-02,
 -2.369650419178877e-03,  6.959863859761098e-05, -1.765548545336824e-06,  4.075824298667520e-08, -8.763919632516780e-10,  1.778981570949516e-11, -3.439563596679961e-13,
  6.376866496738595e-15, -1.139128151980212e-16,  1.968603205061955e-18, -3.299928003844927e-20,  3.361461042465924e-02, -1.627928848535028e-03,  6.650709828290966e-05,
 -2.249644493162624e-06,  6.738441802408809e-08, -1.838858150777742e-09,  4.654277303824486e-11, -1.105935382677935e-12,  2.488759984911885e-14, -5.338702785141730e-16,
  1.097228049764202e-17, -2.168437379713865e-19,  1.010752436823904e-02, -7.765595449391994e-04,  4.290391423741917e-05, -1.895586246642033e-06,  7.210881172775447e-08,
 -2.447390161698856e-09,  7.578076243499090e-11, -2.172952146183907e-12,  5.832064450231899e-14, -1.476866614654924e-15,  3.550484006069301e-17, -8.139245559604901e-19,
  2.308796996905230e-03, -2.654090562676061e-04,  1.956776570902740e-05, -1.112995480480168e-06,  5.305191466581009e-08, -2.211497173979685e-09,  8.276616911221641e-11,
 -2.830381458634122e-12,  8.956098845486955e-14, -2.646955452936836e-15,  7.359929872178147e-17, -1.935249172629265e-18,  4.139979463921561e-04, -6.795866282196987e-05,
  6.607340024482714e-06, -4.783929711213435e-07,  2.829373398106098e-08, -1.435186968161037e-09,  6.433280165426008e-11, -2.600088140234129e-12,  9.611933001403103e-14,
 -3.285197301695979e-15,  1.046757072487461e-16, -3.127543593388620e-18,  6.190997551159534e-05, -1.391544010739331e-05,  1.756785389676740e-06, -1.599620035091423e-07,
  1.161689346370024e-08, -7.100194881081275e-10,  3.775403634937383e-11, -1.786051273095253e-12,  7.639061694505223e-14, -2.989767642802675e-15,  1.080812796123987e-16,
 -3.632590378494650e-18,  8.561008251384781e-06, -2.516236978109692e-06,  4.024387764245248e-07, -4.520791610334101e-08,  3.964674102552627e-09, -2.874886008705853e-10,
  1.786606571385536e-11, -9.750736860804592e-13,  4.756743177055093e-14, -2.101988931576710e-15,  8.501859668121752e-17, -3.170235987527755e-18,  1.264913894249282e-06,
 -4.578226143923253e-07,  8.889358913197879e-08, -1.189130470802529e-08,  1.220472677899877e-09, -1.020231078895896e-10,  7.213850192055402e-12, -4.428338939749661e-13,
  2.405265655685921e-14, -1.172741511655304e-15,  5.191365700761593e-17, -2.102835345662328e-18,  2.067211624110188e-07, -8.494036980527903e-08,  1.866815698977335e-08,
 -2.795982467023703e-09,  3.177867458372014e-10, -2.912553637753329e-11,  2.237972913999247e-12, -1.481238856566222e-13,  8.614167833566650e-15, -4.469119732937587e-16,
  2.093451970125677e-17, -8.927677574164282e-19,  2.009852777018358e-01, -1.806513456078047e-03,  1.778701947859780e-05, -1.854997904164066e-07,  1.980514449773103e-09,
 -2.141285269455902e-11,  2.288531095181208e-13, -2.479536566838113e-15,  2.550549364547329e-17, -2.825693803873183e-19,  2.825818865237234e-21, -2.407399333921890e-23,
  1.447045094016878e-01, -2.064511736065743e-03,  3.730912174912226e-05, -6.456134561248661e-07,  1.053049101923754e-08, -1.639362659312920e-10,  2.458860049723203e-12,
 -3.575264892131875e-14,  5.059909893994409e-16, -6.992399886356280e-18,  9.459187495351099e-20, -1.253723772820140e-21,  7.501139646049117e-02, -1.887717524483150e-03,
  5.181352843914062e-05, -1.233344761961508e-06,  2.682473228769897e-08, -5.452556051154781e-10,  1.049326363457292e-11, -1.927557152560085e-13,  3.402495981126791e-15,
 -5.795405265564645e-17,  9.565736779385766e-19, -1.533842171696503e-20,  2.801866613364284e-02, -1.187973593656024e-03,  4.493790622140445e-05, -1.414129723548154e-06,
  3.966870766966167e-08, -1.018567675257910e-09,  2.434771250112395e-11, -5.480078223015923e-13,  1.171177636584743e-14, -2.391153427466177e-16,  4.686779037552829e-18,
 -8.849768178296772e-20,  7.567169067348541e-03, -5.078700105082235e-04,  2.573555434169249e-05, -1.052047009758151e-06,  3.733237765203321e-08, -1.188695642195635e-09,
  3.468490125271724e-11, -9.406667762981804e-13,  2.395365349777559e-14, -5.770757521438033e-16,  1.323035711089249e-17, -2.898835910409951e-19,  1.492341826656555e-03,
 -1.506343709992912e-04,  1.013310962716205e-05, -5.321525428915874e-07,  2.362922212030267e-08, -9.234792522418036e-10,  3.256831142455820e-11, -1.053927924282827e-12,
  3.167095569924935e-14, -8.916970565766131e-16,  2.368492906492858e-17, -5.964322234326886e-19,  2.200736668254783e-04, -3.210497969208548e-05,  2.852193099667476e-06,
 -1.910937009647737e-07,  1.055256963218005e-08, -5.031614448844681e-10,  2.131595086546246e-11, -8.178628508224343e-13,  2.881286135388096e-14, -9.416073104981168e-16,
  2.877200990757725e-17, -8.266394368655120e-19,  2.555737830537677e-05, -5.206819441750304e-06,  6.065413272799625e-07, -5.152921928077526e-08,  3.520314265799173e-09,
 -2.037006971040209e-10,  1.030808152455299e-11, -4.661200107122603e-13,  1.912757544989219e-14, -7.205953986433467e-16,  2.514727514103392e-17, -8.180568924724169e-19,
  2.592054484673790e-06, -7.099834038578596e-07,  1.067885837331903e-07, -1.137125279848441e-08,  9.513220338991351e-10, -6.614726965556274e-11,  3.958766074266082e-12,
 -2.088295998452683e-13,  9.877597161156494e-15, -4.243717033178945e-16,  1.672817808545887e-17, -6.092431325454116e-19,  2.737939646481532e-07, -9.540800377966158e-08,
  1.788567856133869e-08, -2.319324225079697e-09,  2.315895216948708e-10, -1.889216389580949e-11,  1.307009053646139e-12, -7.867819408417134e-14,  4.198745126327866e-15,
 -2.014805186946955e-16,  8.790770441751747e-18, -3.514322379002723e-19,  3.426250537302675e-08, -1.392162966884526e-08,  3.026078478253408e-09, -4.486807099304771e-10,
  5.053501403962507e-11, -4.593796863033349e-12,  3.503761236069377e-13, -2.303478661863425e-14,  1.331410938131348e-15, -6.868925892261067e-17,  3.201098584398064e-18,
 -1.358710140624209e-19,  1.940304381182867e-01, -1.672613309800979e-03,  1.573792482227353e-05, -1.569612501672272e-07,  1.601998013165135e-09, -1.666993683661045e-11,
  1.694690543101736e-13, -1.805919674059530e-15,  1.718233102133632e-17, -1.829617853787623e-19,  2.355291597782425e-21,  3.447047863527928e-24,  1.369980812914452e-01,
 -1.794393831810671e-03,  3.047401892635005e-05, -5.004592383698762e-07,  7.769361206326426e-09, -1.153157766082708e-10,  1.651269946971480e-12, -2.295384362012072e-14,
  3.109219615320180e-16, -4.115171006008793e-18,  5.342446569530922e-20, -6.791720768870410e-22,  6.820511847449399e-02, -1.525861697849397e-03,  3.926849023971564e-05,
 -8.793427406999740e-07,  1.805710490283517e-08, -3.475728545599332e-10,  6.352664738222413e-12, -1.110151508570123e-13,  1.868646324722423e-15, -3.038661266245655e-17,
  4.792441243569448e-19, -7.371553719570926e-21,  2.389172754097223e-02, -8.869237565005465e-04,  3.119451569336925e-05, -9.151974315270262e-07,  2.408720982435675e-08,
 -5.828299948966549e-10,  1.317600097973627e-11, -2.812210333543467e-13,  5.713872237458115e-15, -1.111309494925356e-16,  2.078680306526053e-18, -3.753590831472741e-20,
  5.879778403115515e-03, -3.438812794866292e-04,  1.603567867831065e-05, -6.073022947753487e-07,  2.012715026105666e-08, -6.017845389712625e-10,  1.655981762639898e-11,
 -4.250110599357414e-13,  1.027286825048401e-14, -2.355198765887261e-16,  5.150308988719342e-18, -1.078669919727555e-19,  1.019008919267784e-03, -8.985602985054253e-05,
  5.520585618344964e-06, -2.676700558942960e-07,  1.107199941243585e-08, -4.056410060965814e-10,  1.347755277746195e-11, -4.125730350070879e-13,  1.176895446147896e-14,
 -3.154968230445043e-16,  8.000467313511126e-18, -1.928141160616664e-19,  1.259975870022141e-04, -1.620608110498569e-05,  1.312564597895450e-06, -8.120913684597774e-08,
  4.179914811197275e-09, -1.870398026773562e-10,  7.476763648186002e-12, -2.719116409233838e-13,  9.114647984146959e-15, -2.843683882391853e-16,  8.320022860358970e-18,
 -2.295023864786270e-19,  1.155024284996084e-05, -2.110528037067190e-06,  2.255559542112423e-07, -1.779811510045245e-08,  1.139433386094851e-09, -6.220770863118210e-11,
  2.986493976075219e-12, -1.287081404034380e-13,  5.053541222218905e-15, -1.827836573507615e-16,  6.142641619282554e-18, -1.929554096460432e-19,  8.619895262256338e-07,
 -2.175138191104850e-07,  3.052062405444464e-08, -3.060849068137291e-09,  2.429518845559187e-10, -1.612183674977972e-11,  9.252773840692345e-13, -4.699825838003291e-14,
  2.147997852497653e-15, -8.944130597266852e-17,  3.426144005995461e-18, -1.215508980469211e-19,  6.358928480336633e-08, -2.114894101851896e-08,  3.800864037825672e-09,
 -4.749989455924673e-10,  4.591570575672354e-11, -3.639761028743566e-12,  2.454689060081097e-13, -1.444341736353214e-14,  7.551576324614941e-16, -3.557324173353272e-17,
  1.526328773234959e-18, -6.009987327236420e-20,  5.829268726836336e-09, -2.335549247051111e-09,  5.007945888849541e-10, -7.334659542160360e-11,  8.170861482153823e-12,
 -7.355021922237406e-13,  5.560576971141651e-14, -3.626767999731761e-15,  2.081251480238415e-16, -1.066749169245726e-17,  4.941764532657621e-19, -2.086140081994888e-20,
  1.875804460915206e-01, -1.553832291399389e-03,  1.399785086681640e-05, -1.337916301832585e-07,  1.305473719735706e-09, -1.315275637858792e-11,  1.257446669493938e-13,
 -1.342481996556400e-15,  1.240502649879468e-17, -7.737973023440423e-20,  3.111610289326295e-21,  2.864856237321241e-23,  1.302728240974724e-01, -1.572672756430748e-03,
  2.514468135694951e-05, -3.926466395130199e-07,  5.812570168732638e-09, -8.239696266423963e-11,  1.128218082214762e-12, -1.501424785476275e-14,  1.950021732578213e-16,
 -2.473110991118721e-18,  3.085814629799445e-20, -3.779055098424211e-22,  6.266943680812333e-02, -1.249489980517372e-03,  3.024467406627603e-05, -6.387039018331755e-07,
  1.240957267837585e-08, -2.265456284098094e-10,  3.940053554721397e-12, -6.557387356801350e-14,  1.053814965582718e-15, -1.640786740949263e-17,  2.464576042272830e-19,
 -3.662223018698014e-21,  2.078179728885380e-02, -6.755315918496315e-04,  2.218899296642240e-05, -6.082211521978695e-07,  1.504799348644697e-08, -3.436286733235905e-10,
  7.358284506892910e-12, -1.490918375096346e-13,  2.882980687973714e-15, -5.348685436326984e-17,  9.547483427863918e-19, -1.651503482411209e-20,  4.721347119437135e-03,
 -2.400638768631782e-04,  1.034338798226896e-05, -3.634252041706827e-07,  1.126514894519709e-08, -3.166188780584948e-10,  8.224630972503083e-12, -1.999035100106209e-13,
  4.589069321804274e-15, -1.001770789037326e-16,  2.089971972325506e-18, -4.185566575894393e-20,  7.311332673103784e-04, -5.604711504243361e-05,  3.151519273078302e-06,
 -1.411235255275650e-07,  5.440374497390285e-09, -1.868853877398240e-10,  5.850421849468813e-12, -1.694054888382883e-13,  4.586480297656903e-15, -1.170378503640613e-16,
  2.832371918546531e-18, -6.530107074498321e-20,  7.729922634919865e-05, -8.698427951018796e-06,  6.415915760756023e-07, -3.660473760196014e-08,  1.754062341657800e-09,
 -7.357376529375562e-11,  2.771898474817090e-12, -9.543543790908268e-14,  3.040152097855741e-15, -9.043787750511772e-17,  2.530345108545068e-18, -6.692571735433386e-20,
  5.703024757116379e-06, -9.246934686406031e-07,  9.022390814798219e-08, -6.586540574726339e-09,  3.938356075933734e-10, -2.022607829089921e-11,  9.186611288935740e-13,
 -3.763468619278488e-14,  1.410344372578206e-15, -4.885876794500823e-17,  1.577556681267217e-18, -4.774622773566919e-20,  3.163391990353468e-07, -7.261541094843453e-08,
  9.427978469012337e-09, -8.847559115236274e-10,  6.626718453654579e-11, -4.176770041359275e-12,  2.289118884027548e-13, -1.115300840294838e-14,  4.908145284518338e-16,
 -1.974393660872327e-17,  7.327835551504307e-19, -2.525476433435436e-20,  1.602013084457850e-08, -5.031161391749925e-09,  8.596559562397087e-10, -1.028378008720240e-10,
  9.569124126033795e-12, -7.335486514712698e-13,  4.802360901610690e-14, -2.751864257653455e-15,  1.405027133562858e-16, -6.478691361735044e-18,  2.726598043317545e-19,
 -1.055001405976876e-20,  1.024335321260571e-09, -4.031347282607652e-10,  8.498190372422764e-11, -1.225936432821557e-11,  1.347539528144342e-12, -1.198684058137287e-13,
  8.967098817333295e-15, -5.793551097940960e-16,  3.296519177704969e-17, -1.676700694098296e-18,  7.713411147071012e-20, -3.235603949055744e-21,  1.815793905880626e-01,
 -1.447935381003421e-03,  1.250949407609187e-05, -1.148565180763992e-07,  1.069776799057692e-09, -1.054275290912361e-11,  9.348009872868129e-14, -9.634793011927618e-16,
  1.217809680617816e-17,  7.309966942279752e-20,  4.323569259980538e-21,  1.544380015262827e-23,  1.243566849646958e-01, -1.388897671836361e-03,  2.094094986330278e-05,
 -3.114890599120783e-07,  4.404674660905587e-09, -5.973387721875958e-11,  7.833227632489829e-13, -9.989559026014961e-15,  1.246933154463019e-16, -1.516575107394963e-18,
  1.813757103393782e-20, -2.163645129309903e-22,  5.811120002750840e-02, -1.035128783971190e-03,  2.363711420643020e-05, -4.718222947489019e-07,  8.693153811158752e-09,
 -1.506914007400586e-10,  2.499229404582971e-12, -3.967611968241990e-14,  6.075806795263678e-16, -9.151386733779268e-18,  1.293405936430940e-19, -1.865084793705694e-21,
  1.839363055693690e-02, -5.235875422761410e-04,  1.613576131852050e-05, -4.140908913650144e-07,  9.650452835192853e-09, -2.082468462053781e-10,  4.231150318589008e-12,
 -8.149225548814718e-14,  1.499950591402696e-15, -2.663194974101220e-17,  4.528075052576529e-19, -7.514474479408324e-21,  3.902734357862550e-03, -1.721170123199482e-04,
  6.884948099501135e-06, -2.247591015730690e-07,  6.526767728658322e-09, -1.726347688127138e-10,  4.238163312865289e-12, -9.764018889141918e-14,  2.129935730601904e-15,
 -4.431710004459978e-17,  8.821132378363081e-19, -1.690087078278083e-20,  5.484122498170443e-04, -3.637055660922352e-05,  1.877897278121330e-06, -7.770776155844386e-08,
  2.794204074704583e-09, -9.004184051380107e-11,  2.656860106458123e-12, -7.278683906067400e-14,  1.870406310658036e-15, -4.543477193961667e-17,  1.049133616850098e-18,
 -2.313407724209072e-20,  5.054004026016045e-05, -4.937789372826411e-06,  3.317960610471597e-07, -1.744040060120958e-08,  7.775935796521043e-10, -3.055149677247010e-11,
  1.084011377747209e-12, -3.530405166547140e-14,  1.067805867565335e-15, -3.025874614368141e-17,  8.087747717901723e-19, -2.048965414130088e-20,  3.065963099854458e-06,
 -4.363608726019303e-07,  3.872866526546192e-08, -2.607164609060583e-09,  1.452074988496109e-10, -6.997445292177864e-12,  2.999761648185616e-13, -1.165543087522630e-14,
  4.159723900486070e-16, -1.377328212723431e-17,  4.263906832666776e-19, -1.240907104464869e-20,  1.284863769016559e-07, -2.646613134800605e-08,  3.154538449564860e-09,
 -2.752900990983834e-10,  1.935495899417580e-11, -1.153426267304118e-12,  6.011717081504373e-14, -2.799008432117684e-15,  1.181952476422078e-16, -4.578626297614091e-18,
  1.641550306096859e-19, -5.480569642402316e-21,  4.427855776208231e-09, -1.296139573227931e-09,  2.085594133935882e-10, -2.370084662944449e-11,  2.109496725594368e-12,
 -1.555358225332172e-13,  9.838305200968623e-15, -5.467677209287352e-16,  2.716239382918987e-17, -1.222018586850782e-18,  5.029895950877377e-20, -1.907502074973584e-21,
  1.874053496716615e-10, -7.206669343532154e-11,  1.486830275675669e-11, -2.104789686615673e-12,  2.275749727826231e-13, -1.995289362259240e-14,  1.473691073655629e-15,
 -9.413958063181963e-17,  5.302512234489180e-18, -2.672573086366185e-19,  1.219425242689939e-20, -5.077398762497920e-22,  1.759794624865993e-01, -1.353096837169614e-03,
  1.122732801191759e-05, -9.931336879440978e-08,  8.794140866717666e-10, -8.575287294764845e-12,  7.259387023543215e-14, -4.982053200873517e-16,  1.788881960593217e-17,
  2.363287648990113e-19,  3.054305442963704e-21, -9.250218508084626e-23,  1.191140558156731e-01, -1.235208076784562e-03,  1.758957267049629e-05, -2.496378216900622e-07,
  3.377471305458706e-09, -4.388559845963362e-11,  5.521698416233187e-13, -6.749629882857751e-15,  8.114413320695642e-17, -9.511772358027190e-19,  1.078920269420473e-20,
 -1.256253332692579e-22,  5.431608097167508e-02, -8.665244073582489e-04,  1.871994509680249e-05, -3.539252296153459e-07,  6.199336417714580e-09, -1.021163712100308e-10,
  1.617255191384315e-12, -2.464682658057751e-14,  3.544554714473299e-16, -5.300800832427473e-18,  7.001292337030042e-20, -9.209418152006981e-22,  1.652931099646546e-02,
 -4.120370715583917e-04,  1.197163617943120e-05, -2.881741805194528e-07,  6.340847930156437e-09, -1.294320358467342e-10,  2.498837041153230e-12, -4.589526947705033e-14,
  8.008671863656271e-16, -1.371845169918472e-17,  2.218303407718523e-19, -3.496142828307736e-21,  3.309544308665960e-03, -1.262811937889144e-04,  4.716128520044665e-06,
 -1.432335304720071e-07,  3.904115579452188e-09, -9.728649480791295e-11,  2.259867408713379e-12, -4.942659002082444e-14,  1.024065658614715e-15, -2.035478121213683e-17,
  3.865746493971081e-19, -7.078312446885523e-21,  4.279877983204675e-04, -2.443468761424749e-05,  1.163805120579698e-06, -4.453075277827921e-08,  1.495389254282859e-09,
 -4.523460161485632e-11,  1.258837144538166e-12, -3.264758728633618e-14,  7.962909913982987e-16, -1.842139633269887e-17,  4.058575466111908e-19, -8.557564409326125e-21,
  3.501934426289929e-05, -2.947734580668623e-06,  1.807997288329265e-07, -8.751219203554473e-09,  3.630325336717086e-10, -1.335654782200599e-11,  4.461485510169116e-13,
 -1.373830672840734e-14,  3.942871198048647e-16, -1.063664438854694e-17,  2.713973594845088e-19, -6.580384140667856e-21,  1.786410677984565e-06, -2.207320527956464e-07,
  1.778254382129301e-08, -1.101056284841955e-09,  5.700449955472921e-11, -2.572516369122722e-12,  1.038932505255304e-13, -3.821497168056962e-15,  1.296493602221547e-16,
 -4.095544838425053e-18,  1.213466048394381e-19, -3.389699691194327e-21,  5.780409147243026e-08, -1.052978918377525e-08,  1.144002303591555e-09, -9.230663416083128e-11,
  6.062832344754334e-12, -3.401566255493107e-13,  1.679539690866282e-14, -7.446133355319737e-16,  3.007159129967548e-17, -1.118307031711410e-18,  3.861782134571356e-20,
 -1.245566115237385e-21,  1.357645161284499e-09, -3.647170629138977e-10,  5.468403534695585e-11, -5.854355965529032e-12,  4.949870340382794e-13, -3.489671833736773e-14,
  2.121861925778535e-15, -1.138556455235325e-16,  5.481383400170073e-18, -2.397474330029925e-19,  9.620260152035557e-21, -3.565411866853997e-22,  3.607216813688986e-11,
 -1.345524463351285e-11,  2.700610728753205e-12, -3.733419286688532e-13,  3.954911799589520e-14, -3.406436832310247e-15,  2.477117346084762e-16, -1.560843808118165e-17,
  8.685375866030145e-19, -4.330379166248837e-20,  1.956713268519101e-21, -8.076364521215683e-23,  1.707394858322832e-01, -1.267818492016782e-03,  1.011462836057449e-05,
 -8.652359910834678e-08,  7.245708682281165e-10, -6.927297821990738e-12,  6.804334363911430e-14,  2.226916998384997e-16,  2.710651610414414e-17,  2.199729091318291e-19,
 -5.436596747311610e-21, -3.051420131393140e-22,  1.144368987268073e-01, -1.105617765691784e-03,  1.489136023334769e-05, -2.019593025914871e-07,  2.618364139529861e-09,
 -3.263688935231819e-11,  3.949218079166653e-13, -4.627288970094334e-15,  5.350679319195121e-17, -6.119918224698124e-19,  6.571997482552523e-21, -7.024734247632480e-23,
  5.112479599220938e-02, -7.322096321555611e-04,  1.500682294364512e-05, -2.691792264177950e-07,  4.495191746442247e-09, -7.046061790095979e-11,  1.060703643582565e-12,
 -1.588477772588985e-14,  2.059950442244860e-16, -3.125249465604913e-18,  4.286797993780874e-20, -3.554483436455158e-22,  1.505300740793261e-02, -3.285491749006284e-04,
  9.046317309798856e-06, -2.045613743202404e-07,  4.261069083488835e-09, -8.238658970964943e-11,  1.508987589018125e-12, -2.671618813471048e-14,  4.358321372787824e-16,
 -7.264284712494169e-18,  1.145270591546371e-19, -1.605230679066814e-21,  2.870317618819444e-03, -9.449627826840966e-05,  3.316315520988510e-06, -9.379830413148581e-08,
  2.405264023098019e-09, -5.653770841556598e-11,  1.242752907653649e-12, -2.591367313282777e-14,  5.082205594562938e-16, -9.677581607412076e-18,  1.762399780099438e-19,
 -3.052824187124525e-21,  3.459809467707550e-04, -1.691442554751394e-05,  7.477162716660743e-07, -2.646641506682739e-08,  8.314104008298970e-10, -2.362932396795262e-11,
  6.204421712481491e-13, -1.525593883754390e-14,  3.529847272297501e-16, -7.783132208520861e-18,  1.637541809193462e-19, -3.297176479106370e-21,  2.557282435228853e-05,
 -1.839731516142075e-06,  1.034012291880028e-07, -4.606999579330910e-09,  1.779194274452351e-10, -6.130194754483767e-12,  1.927457139695401e-13, -5.612039720075740e-15,
  1.527583336882031e-16, -3.921911125407555e-18,  9.548785828015175e-20, -2.214226408669350e-21,  1.121980501322232e-06, -1.189987768350087e-07,  8.700946116403891e-09,
 -4.945213812607940e-10,  2.376837271432912e-11, -1.003069734851234e-12,  3.810832294425589e-14, -1.325141702604123e-15,  4.267302305016441e-17, -1.284166811862013e-18,
  3.636055957686553e-20, -9.734173029245365e-22,  2.876428441992022e-08, -4.562778425955874e-09,  4.492732277386615e-10, -3.334702912992106e-11,  2.037642590158014e-12,
 -1.072252303386586e-13,  4.998050025093468e-15, -2.103126719218082e-16,  8.098171471987660e-18, -2.882677446753024e-19,  9.561490784665093e-21, -2.971411829415348e-22,
  4.664005668241767e-10, -1.129058803602654e-10,  1.559847993108133e-11, -1.559464164028181e-12,  1.243513945322543e-13, -8.330931241305049e-15,  4.843073499080439e-16,
 -2.497089524191342e-17,  1.160062668027027e-18, -4.913907605286654e-20,  1.915578066168087e-21, -6.916241879033626e-23,  7.404801801980364e-12, -2.651762786149088e-12,
  5.136527557792381e-13, -6.890706109531590e-14,  7.115235009496953e-15, -5.995298711237025e-16,  4.277417148353638e-17, -2.650686972508756e-18,  1.453499191101578e-19,
 -7.153254499847034e-21,  3.194994001749076e-22, -1.305142498388820e-23,  1.658237352251855e-01, -1.190867449690280e-03,  9.141629575033658e-06, -7.594614755122768e-08,
  6.033902206999978e-10, -5.116323317128343e-12,  8.714210195063672e-14,  1.144648697112465e-15,  2.728877048539724e-17, -3.284629767911700e-19, -2.322819366220179e-20,
 -4.684265836252525e-22,  1.102382845320467e-01, -9.955152030186357e-04,  1.269922684182570e-05, -1.648132154683091e-07,  2.050832606239314e-09, -2.453873434405259e-11,
  2.863468576656960e-13, -3.222186389816962e-15,  3.556711637766916e-17, -3.996883819374022e-19,  4.282816827510632e-21, -3.739615325720767e-23,  4.841720442420182e-02,
 -6.239517738117608e-04,  1.216580342345474e-05, -2.072857419490432e-07,  3.307971120190654e-09, -4.968888676015587e-11,  6.935196478203428e-13, -1.078557863290134e-14,
  1.216500772987311e-16, -1.609425438071499e-18,  3.529194881361304e-20, -3.263246243654010e-23,  1.386949095842972e-02, -2.649521725007059e-04,  6.952009403678097e-06,
 -1.478271969160560e-07,  2.922126652685973e-09, -5.378462520100036e-11,  9.224769011085985e-13, -1.618759690101630e-14,  2.427635489022746e-16, -3.776065731030019e-18,
  6.648812976215682e-20, -6.932285473479408e-22,  2.539087116670218e-03, -7.189035309171792e-05,  2.388973121209984e-06, -6.295689035379344e-08,  1.522288280520431e-09,
 -3.385994754960437e-11,  7.008501202126144e-13, -1.408827582697430e-14,  2.601093280005265e-16, -4.704703521820577e-18,  8.472213011014193e-20, -1.342535580854004e-21,
  2.885530069235825e-04, -1.200823794541971e-05,  4.966120908861961e-07, -1.626067826106379e-08,  4.787720788123745e-10, -1.280815945967570e-11,  3.168919038737361e-13,
 -7.416823908586903e-15,  1.625830327732164e-16, -3.412650393941950e-18,  6.896568366146219e-20, -1.318853311199622e-21,  1.957599776047665e-05, -1.193178522378450e-06,
  6.184048474994146e-08, -2.534713139753352e-09,  9.123028385431346e-11, -2.945725653143704e-12,  8.714520679569036e-14, -2.401455410029517e-15,  6.196736132564160e-17,
 -1.513548163263947e-18,  3.518245251501869e-20, -7.793882709843661e-22,  7.550756349320061e-07, -6.791804418028308e-08,  4.518588063854438e-09, -2.353272702007934e-10,
  1.049459565682874e-11, -4.138382465184023e-13,  1.477408646421500e-14, -4.852532226567517e-16,  1.481524589848906e-17, -4.242255687227247e-19,  1.146593660778465e-20,
 -2.937917625542670e-22,  1.577808826551281e-08, -2.143809804454114e-09,  1.906394389567551e-10, -1.295981103923685e-11,  7.342338399452821e-13, -3.612411340030968e-14,
  1.584859228320818e-15, -6.311822077051386e-17,  2.310910790602859e-18, -7.853306862688133e-20,  2.495630857417199e-21, -7.454251641014201e-23,  1.809136833302142e-10,
 -3.864195732810276e-11,  4.865019936181083e-12, -4.502168760259080e-13,  3.361364803932508e-14, -2.126661169231974e-15,  1.175517799623904e-16, -5.795358790754042e-18,
  2.586487138981935e-19, -1.056785044217288e-20,  3.987525437705014e-22, -1.397860037279073e-23,  1.649595091857095e-12, -5.589529251118564e-13,  1.033874590606893e-13,
 -1.334935285163881e-14,  1.334921368901799e-15, -1.094546755866144e-16,  7.628239881831151e-18, -4.631985162414608e-19,  2.495149843196067e-20, -1.208871004010548e-21,
  5.324948812085223e-23, -2.148529968942560e-24,  1.612009820448525e-01, -1.121222683966124e-03,  8.285226181515484e-06, -6.698442075869791e-08,  5.250110209676314e-10,
 -2.559948624241437e-12,  1.281346113970513e-13,  1.610662511790394e-15, -5.922947761999850e-18, -1.625583744851068e-18, -3.906270400790654e-20, -1.020780475211937e-22,
  1.064476267698979e-01, -9.013096125567802e-04,  1.090328355615625e-05, -1.355812155740199e-07,  1.622085572218624e-09, -1.863264058989488e-11,  2.101152270308820e-13,
 -2.284108543948231e-15,  2.390984999719318e-17, -2.567562848720236e-19,  2.931202337759758e-21, -2.809785016788780e-23,  4.610147396721116e-02, -5.357454252193705e-04,
  9.965811702415392e-06, -1.614994311876522e-07,  2.458257992524136e-09, -3.627230917458781e-11,  4.392482959053331e-13, -7.548376913017054e-15,  8.900618150096752e-17,
 -2.081041294736670e-19,  3.428639815336075e-20, -1.063892532228480e-22,  1.291070284637347e-02, -2.157116276938703e-04,  5.426619668939773e-06, -1.086155523469460e-07,
  2.035181446615116e-09, -3.631494735765168e-11,  5.609032700593780e-13, -1.013199239594905e-14,  1.485991441400085e-16, -1.597172343958642e-18,  4.460103196935343e-20,
 -4.002464684883635e-22,  2.285487995917632e-03, -5.543256942458114e-05,  1.759913258658103e-06, -4.322295480332639e-08,  9.856148454384556e-10, -2.096830943742799e-11,
  4.015221754144424e-13, -7.919626878523371e-15,  1.399574522921645e-16, -2.238282129734944e-18,  4.372132111513718e-20, -6.326738363615023e-22,  2.473912182373096e-04,
 -8.702723589135147e-06,  3.401609392512735e-07, -1.029772151386878e-08,  2.844594961509602e-10, -7.203859727020760e-12,  1.668166874040935e-13, -3.743068822671954e-15,
  7.804623416455357e-17, -1.535309418916928e-18,  3.042343660404767e-20, -5.502752782607380e-22,  1.563003120973108e-05, -7.991445567657236e-07,  3.855195776265149e-08,
 -1.452098931554532e-09,  4.875919739837111e-11, -1.479127130835119e-12,  4.108162090438137e-14, -1.073973169896181e-15,  2.628941793909250e-17, -6.090986288212197e-19,
  1.356561972513051e-20, -2.866873587496842e-22,  5.411503125902615e-07, -4.073395200502827e-08,  2.480772362586424e-09, -1.181722027111463e-10,  4.889833288016510e-12,
 -1.802103657762420e-13,  6.038042601167058e-15, -1.872973257646572e-16,  5.417693535335758e-18, -1.474335150052588e-19,  3.802109278100906e-21, -9.313219827573448e-23,
  9.491574929448980e-09, -1.085006496496892e-09,  8.711935163361023e-11, -5.403582635097388e-12,  2.831445569985107e-13, -1.299381831896283e-14,  5.352066246670884e-16,
 -2.012773016797318e-17,  6.990668451490504e-19, -2.262785836689576e-20,  6.873951439331191e-22, -1.968993484199425e-23,  7.960227097124053e-11, -1.464437519382735e-11,
  1.664008366165110e-12, -1.413395617329783e-13,  9.813022468371605e-15, -5.828001717494400e-16,  3.046622585638774e-17, -1.429213735164698e-18,  6.100678542972307e-20,
 -2.394478347185837e-21,  8.712376496847827e-23, -2.955134093495036e-24,  4.075792438898603e-13, -1.279981102506489e-13,  2.229911808200031e-14, -2.742692158489129e-15,
  2.634552732345555e-16, -2.088251156566469e-17,  1.413951539199530e-18, -8.374767786135731e-20,  4.414793248653169e-21, -2.098790478167025e-22,  9.091915478323988e-24,
 -3.614672051270634e-25,  1.568437620412376e-01, -1.058016057447520e-03,  7.530705109806493e-06, -5.881259826165811e-08,  5.078382410933096e-10,  9.703296690243329e-13,
  1.596775580267945e-13,  1.946252036907496e-16, -9.045595314018893e-17, -2.905650305293538e-18, -1.302767434332926e-20,  1.529143792164184e-21,  1.030071243430540e-01,
 -8.201766786926022e-04,  9.420563274780849e-06, -1.123553698106783e-07,  1.295093390377816e-09, -1.427867076186924e-11,  1.556291241250200e-13, -1.646768058269494e-15,
  1.646398864261867e-17, -1.660211384452657e-19,  1.551184927024894e-21, -3.473480840910133e-23,  4.410654685876372e-02, -4.631540040010197e-04,  8.241544535635312e-06,
 -1.274641617590945e-07,  1.822778916938534e-09, -2.794260874730529e-11,  2.684314204585132e-13, -4.573971639599477e-15,  1.035624854173608e-16,  8.918419564004114e-19,
  1.478620458296791e-20, -9.168399570143542e-22,  1.212714164927589e-02, -1.770095358771461e-04,  4.296770314103258e-06, -8.121897871828188e-08,  1.423113484944581e-09,
 -2.576199018051346e-11,  3.373810344744116e-13, -5.989269238966538e-15,  1.185548479362368e-16, -2.205079549672451e-19,  2.165556777908609e-20, -7.513804882373452e-22,
  2.088971710569961e-03, -4.318868839364790e-05,  1.323527824029422e-06, -3.035159661923197e-08,  6.469917703581414e-10, -1.355031168378359e-11,  2.324794542670492e-13,
 -4.441548106002114e-15,  8.496603822182055e-17, -9.627818152121436e-19,  2.134722629195876e-20, -4.516859943911066e-22,  2.173366546934399e-04, -6.408048655015329e-06,
  2.397600599625764e-07, -6.712594810024437e-09,  1.731980295194803e-10, -4.219428833113277e-12,  9.010135849519083e-14, -1.935475870350057e-15,  3.987189764093091e-17,
 -6.945602548127440e-19,  1.371509127249090e-20, -2.578628384340207e-22,  1.295606800909058e-05, -5.491119864686957e-07,  2.498063905058240e-08, -8.637826400406647e-10,
  2.701769355779989e-11, -7.760088217859477e-13,  2.011623743652413e-14, -4.993292508108066e-16,  1.170561348029591e-17, -2.539518778789796e-19,  5.448361786337378e-21,
 -1.112900385949995e-22,  4.104974541075923e-07, -2.546038109856277e-08,  1.434553356308842e-09, -6.237941650361239e-11,  2.393669292788974e-12, -8.266287721737204e-14,
  2.593448707995293e-15, -7.598902446572039e-17,  2.085026117392713e-18, -5.377185527338886e-20,  1.323929189225675e-21, -3.101364535117856e-23,  6.222212311277808e-09,
 -5.864198561321320e-10,  4.271112584225378e-11, -2.408570290454391e-12,  1.165147156676806e-13, -4.981848196645265e-15,  1.922076339142963e-16, -6.814317431656353e-18,
  2.241307197628104e-19, -6.895228816116580e-21,  1.998902695630508e-22, -5.480444595646612e-24,  3.976587910909030e-11, -6.129580383365278e-12,  6.245731099643745e-13,
 -4.831419038476001e-14,  3.100405826618245e-15, -1.719215520832729e-16,  8.456941557874776e-18, -3.757800375902915e-19,  1.527608860306801e-20, -5.736746465869835e-22,
  2.005330093393299e-23, -6.558300067864937e-25,  1.146059738602414e-13, -3.239786823013970e-14,  5.226631011074164e-15, -6.046275414693441e-16,  5.524082692041817e-17,
 -4.199214419629459e-18,  2.744260921096828e-19, -1.576780946222912e-20,  8.096527280638746e-22, -3.761946700461950e-23,  1.597251854553518e-24, -6.238813328983941e-26,
  1.527279179719697e-01, -1.000452480622326e-03,  6.875009479365957e-06, -5.032898812771159e-08,  5.639079307771157e-10,  4.444682102628967e-12,  1.091293151292751e-13,
 -4.300567585375921e-15, -1.818533907888920e-16, -1.388535900309188e-18,  1.044466910083224e-19,  3.564836571417419e-21,  9.986907790485601e-02, -7.498734236498932e-04,
  8.187820852940666e-06, -9.373019576150242e-08,  1.043421662884299e-09, -1.104251927442813e-11,  1.160654285701098e-13, -1.206464124686433e-15,  1.125542662052112e-17,
 -1.315449613478202e-19,  3.606023772419708e-22, -7.963204613967067e-24,  4.237675486444670e-02, -4.028845176560258e-04,  6.869551219585121e-06, -1.024568869148393e-07,
  1.320045180951707e-09, -2.263123463948202e-11,  1.918328926671800e-13, -7.327375616615664e-16,  1.333013282952122e-16,  3.187400711871979e-19, -5.145400602509186e-20,
 -1.962302684696144e-21,  1.148217732939262e-02, -1.461833493450124e-04,  3.443046308484220e-06, -6.218049110247484e-08,  9.774618436989176e-10, -1.925173162473065e-11,
  2.223574459381611e-13, -2.232376601795683e-15,  1.163578169229656e-16, -2.214921750930928e-19, -2.646251264494950e-20, -1.369160998698783e-21,  1.935310221141704e-03,
 -3.390017632997356e-05,  1.013355641951028e-06, -2.190174093792371e-08,  4.231774426941551e-10, -9.183035879572349e-12,  1.419168005695810e-13, -2.152003760270074e-15,
  6.076309882954580e-17, -5.214796576131821e-19,  2.173406917884123e-22, -5.093378265713588e-22,  1.950893776116209e-04, -4.770794924091309e-06,  1.733870184326752e-07,
 -4.515137365356007e-09,  1.067033554369278e-10, -2.582961368749039e-12,  5.065004226495814e-14, -9.735617504185726e-16,  2.236083738847385e-17, -3.359571918920055e-19,
  4.919282203042743e-21, -1.583021589776450e-22,  1.110267167286819e-05, -3.844095795831038e-07,  1.677038624517929e-08, -5.335165799537237e-10,  1.538064018440621e-11,
 -4.258183508460627e-13,  1.025668978644527e-14, -2.370377726179355e-16,  5.528580643452675e-18, -1.105504228538011e-19,  2.177120554866836e-21, -4.768366816654209e-23,
  3.276453322748962e-07, -1.643387459422137e-08,  8.704961152509184e-10, -3.453246279268464e-11,  1.223016515937442e-12, -3.989295312969139e-14,  1.168696965554511e-15,
 -3.220058683125707e-17,  8.456740708695251e-19, -2.055631485113998e-20,  4.803172157346372e-22, -1.092206273000713e-23,  4.413336328844140e-09, -3.348658684836689e-10,
  2.236993750962045e-11, -1.143558495814920e-12,  5.093683788831703e-14, -2.032000465457656e-15,  7.326472562195625e-17, -2.444117949786231e-18,  7.613348199681055e-20,
 -2.220526294440034e-21,  6.132309473502711e-23, -1.608924392249974e-24,  2.248744375494047e-11, -2.812873134373150e-12,  2.568718002206655e-13, -1.797026932268968e-14,
  1.060296924077334e-15, -5.466403916771492e-17,  2.518768148796854e-18, -1.055766416126570e-19,  4.071812088194203e-21, -1.457483978417898e-22,  4.877428335193125e-24,
 -1.532902527040106e-25,  3.770818937576902e-14, -9.215464790942069e-15,  1.350674939997591e-15, -1.447918672043245e-16,  1.243897521241965e-17, -8.984421036884851e-19,
  5.623423612257593e-20, -3.114150653543936e-21,  1.549049702867035e-22, -7.001436489080616e-24,  2.901756341366927e-25, -1.109641437946372e-26,  1.488325095042552e-01,
 -9.477073851324568e-04,  6.328450283714130e-06, -4.050602793675127e-08,  6.657738043982954e-10,  4.951388168044553e-12, -9.277205717479892e-14, -9.814745091636259e-15,
 -1.207476790991397e-16,  5.599748638897277e-18,  2.212759839209385e-19,  2.223730527017895e-22,  9.699384556617414e-02, -6.886019510937043e-04,  7.156399440939656e-06,
 -7.866171126143102e-08,  8.478828710347386e-10, -8.625890036081288e-12,  8.663739649169438e-14, -9.186045240018276e-16,  6.905290096634330e-18, -1.005181875180776e-19,
  1.814048417816939e-21,  7.350278256454840e-23,  4.086780648116077e-02, -3.525197599086883e-04,  5.752668369773655e-06, -8.470535169511125e-08,  9.142695693515143e-10,
 -1.779915946484272e-11,  2.289682970142515e-13,  3.155647668200440e-15,  8.807533648766188e-17, -3.276857956357206e-18, -1.152857621486664e-19, -1.250275891389683e-22,
  1.094814600072437e-02, -1.213852270268444e-04,  2.778909606925049e-06, -4.934529609437413e-08,  6.428372573179073e-10, -1.426204184415754e-11,  2.086525298732481e-13,
  1.044592215008758e-15,  7.552815291920807e-17, -2.366369790950990e-18, -7.249566753027916e-20, -1.972053007248486e-22,  1.814404179812354e-03, -2.674235284141312e-05,
  7.856514764777826e-07, -1.643189217720599e-08,  2.697547330817764e-10, -6.298732935618780e-12,  1.058260378984771e-13, -5.483034363933467e-16,  3.707972600058561e-17,
 -9.137356441547797e-19, -1.722738305641580e-20, -1.403281256378948e-22,  1.784735285250796e-04, -3.574939621316584e-06,  1.279359708053552e-07, -3.163055759002167e-09,
  6.536647912906237e-11, -1.623753078261409e-12,  3.178755333144672e-14, -4.259478443040181e-16,  1.232046720443003e-17, -2.566790821889209e-19, -2.878820702698949e-22,
 -6.417683470392512e-23,  9.797962465056094e-06, -2.722419907355618e-07,  1.160162061918701e-08, -3.441214081122375e-10,  8.877883648714420e-12, -2.424782046064098e-13,
  5.597094257693945e-15, -1.105154818625870e-16,  2.697330602189811e-18, -5.618131885745467e-20,  7.393504536664738e-22, -1.997807777968953e-23,  2.736138485103387e-07,
 -1.084686486165158e-08,  5.514014163137961e-10, -2.008224235175122e-11,  6.459331344909440e-13, -2.017702808204842e-14,  5.565044873292867e-16, -1.404777627249337e-17,
  3.598372166220369e-19, -8.414535762900159e-21,  1.760171180089239e-22, -4.031203209053213e-24,  3.361030665128411e-09, -1.995085445295521e-10,  1.245209463721429e-11,
 -5.772703489828045e-13,  2.349861449304073e-14, -8.794047505158709e-16,  2.963272288184769e-17, -9.241384449743939e-19,  2.737351773723586e-20, -7.570765884338345e-22,
  1.974422874920254e-23, -4.986076500260141e-25,  1.429963075288115e-11, -1.397916715981383e-12,  1.153564971370176e-13, -7.258544813294184e-15,  3.916179152671254e-16,
 -1.873335453811935e-17,  8.054433622912843e-19, -3.171872620698571e-20,  1.157457090412945e-21, -3.935184733304720e-23,  1.256136787432763e-24, -3.784244020438256e-26,
  1.488858437638239e-14, -2.980532345568754e-15,  3.899139096954583e-16, -3.810864208715481e-17,  3.040194280427395e-18, -2.065343396999965e-19,  1.227407373539691e-20,
 -6.503180959453749e-22,  3.113975297301896e-23, -1.361667391262383e-24,  5.482812843933838e-26, -2.044261574291854e-27,  1.451401207079855e-01, -8.988367272817390e-04,
  5.908900456761117e-06, -2.928072276468894e-08,  7.190253912882250e-10, -7.647816290817495e-13, -3.799130816211773e-13, -8.896894715019922e-15,  2.160154288367024e-16,
  1.166763184229440e-17,  2.471202033144435e-21, -1.030155661343024e-20,  9.434827103721281e-02, -6.349083126491553e-04,  6.288505635981534e-06, -6.637108505027846e-08,
  6.941918619634021e-10, -6.832952344272116e-12,  6.360432933128808e-14, -7.349361131764402e-16,  5.389633308668518e-18,  3.454948478283146e-20,  4.340812363253927e-21,
 -1.104655562534500e-23,  3.954365058506274e-02, -3.103405367806726e-04,  4.813285961391403e-06, -7.259225744008047e-08,  6.214672312760874e-10, -1.106457208259898e-11,
  3.330881688968314e-13,  3.277824259272882e-15, -9.997733432330194e-17, -6.398717721005031e-18,  1.773631472007034e-21,  5.500039648086606e-21,  1.050353797810756e-02,
 -1.013675180192620e-04,  2.239983241288905e-06, -4.105608646524689e-08,  4.110485052683016e-10, -8.728350409439226e-12,  2.551339368374664e-13,  1.582028226779802e-15,
 -5.460974754832469e-17, -4.387946998945447e-18, -1.682583442822622e-22,  3.562207816167191e-21,  1.718848439110670e-03, -2.118119369767435e-05,  6.106456702130485e-07,
 -1.298886037337731e-08,  1.684813778830588e-10, -3.844187336002731e-12,  1.012078618273052e-13, -1.538181531242895e-17, -6.948415129505513e-18, -1.414976799517845e-18,
  6.865048608446920e-22,  9.900996332804803e-22,  1.660025181764648e-04, -2.687714910689985e-06,  9.530768538726983e-08, -2.338905974772137e-09,  3.974781963073145e-11,
 -9.681199524642414e-13,  2.395809302255752e-14, -1.842974189580813e-16,  2.654989744582339e-18, -2.726201356530467e-19,  9.014422727227810e-22,  1.242336471148122e-22,
  8.871444506413174e-06, -1.938578058536854e-07,  8.185546020561389e-09, -2.344720185905722e-10,  5.164078391879194e-12, -1.372273980109405e-13,  3.439749119389283e-15,
 -5.216552932764545e-17,  1.057254651057009e-18, -3.738953453699967e-20,  3.663181688856768e-22,  2.588218190698755e-24,  2.377353944062341e-07, -7.250441767505023e-09,
  3.611418932857882e-10, -1.236344774749970e-11,  3.497829372068744e-13, -1.047851507619660e-14,  2.868278793683735e-16, -6.304725557760887e-18,  1.502928605848441e-19,
 -3.923591007786605e-21,  6.915816208337276e-23, -1.169165179570997e-24,  2.725889041987970e-09, -1.223322108709130e-10,  7.305117284800864e-12, -3.106495422946092e-13,
  1.134801219920934e-14, -4.003837087568130e-16,  1.280298065896956e-17, -3.664040659227238e-19,  1.027725497687541e-20, -2.773897348503767e-22,  6.670457722992448e-24,
 -1.576898187400098e-25,  1.012193200923406e-11, -7.398484696488826e-13,  5.621290450903756e-14, -3.180262950505530e-15,  1.554393786257576e-16, -6.903703802696417e-18,
  2.768402884476934e-19, -1.017697072694462e-20,  3.507834076302328e-22, -1.132698985637708e-23,  3.427303909851796e-25, -9.867932289723684e-27,  7.163742137858692e-15,
 -1.097598135449305e-15,  1.269421367474500e-16, -1.113074240746658e-17,  8.138263457292773e-19, -5.148356401761896e-20,  2.878649951132458e-21, -1.447479176236822e-22,
  6.626957162315597e-24, -2.786597826894758e-25,  1.084180630046548e-26, -3.923149425839987e-28,  1.416373609647314e-01, -8.527801511540278e-04,  5.624261622890501e-06,
 -1.845994400057634e-08,  5.979822716145667e-10, -1.172601337773657e-11, -4.745851086591933e-13,  3.779718070514694e-15,  5.170734844088338e-16,  1.790477624620006e-18,
 -4.717331268336089e-19, -6.709525983403526e-21,  9.190446318899237e-02, -5.876071399156427e-04,  5.554435731628984e-06, -5.628096784179292e-08,  5.712406480429350e-10,
 -5.531662779076913e-12,  4.583738973033877e-14, -5.148481127445230e-16,  8.902659792398208e-18,  1.175107741273957e-19, -2.047786398228501e-21, -2.484658358023641e-22,
  3.837400417322432e-02, -2.751635152628351e-04,  3.996007928328852e-06, -6.396268659297894e-08,  4.848220413205644e-10, -2.530261109506229e-12,  3.485373180398183e-13,
 -3.073792222050151e-15, -2.647705916577448e-16, -1.022987802643254e-18,  2.532903544858547e-19,  3.506126195109173e-21,  1.013093051574175e-02, -8.531759061797992e-05,
  1.782116476995485e-06, -3.553344797718013e-08,  2.996882482728408e-10, -2.408726999557776e-12,  2.531690766956677e-13, -2.353132256175375e-15, -1.703710549343707e-16,
 -8.839773257857071e-19,  1.681024066886103e-19,  2.478681597558375e-21,  1.642964909390885e-03, -1.687865703233558e-05,  4.688411310909137e-07, -1.077743421647330e-08,
  1.155312671438092e-10, -1.490017103516753e-12,  9.059971640720486e-14, -9.505041984186392e-16, -4.530815416649867e-17, -3.776469293184035e-19,  4.981408878487407e-20,
  7.725357910943771e-22,  1.566123931358529e-04, -2.027986475451446e-06,  7.051422205062616e-08, -1.828291772305840e-09,  2.573040428846222e-11, -4.539590483777464e-13,
  1.863489637154484e-14, -2.364862313163036e-16, -4.882841393964446e-18, -9.839546262263360e-20,  7.814769284745941e-21,  1.195157467223001e-22,  8.210904122612524e-06,
 -1.384051476454133e-07,  5.790368777338343e-09, -1.697604048404923e-10,  3.141641054396946e-12, -6.950968617167429e-14,  2.273274243682340e-15, -3.654217312511065e-17,
  4.222248140382592e-20, -1.650474821487043e-20,  7.190072438328118e-22,  7.755757883669124e-24,  2.136883320780948e-07, -4.873372046104404e-09,  2.405116617050221e-10,
 -8.121203167980095e-12,  1.970701742994649e-13, -5.282935435887783e-15,  1.597619837750340e-16, -3.293003165496465e-18,  5.071390413845883e-20, -1.742050712445283e-21,
  4.760513444603104e-23, -1.243330576353989e-25,  2.333506303698004e-09, -7.623087161785671e-11,  4.448411277332696e-12, -1.793696239333208e-13,  5.740732051077563e-15,
 -1.867309592382168e-16,  5.948937008601600e-18, -1.566438270645934e-19,  3.825906421591465e-21, -1.070421006207109e-22,  2.641945476405193e-24, -4.686213298368736e-26,
  7.868559799284587e-12, -4.090692224681856e-13,  2.936614220817899e-14, -1.514929007370349e-15,  6.596943827278357e-17, -2.710219151256628e-18,  1.026104567331604e-19,
 -3.494864793527011e-21,  1.122492919159186e-22, -3.484368845092182e-24,  1.002887222315626e-25, -2.684384312038118e-27,  4.191890855107476e-15, -4.542712042945997e-16,
  4.674322680676390e-17, -3.634816296292390e-18,  2.399554203973558e-19, -1.401281331896884e-20,  7.315148967012158e-22, -3.459640818709194e-23,  1.503324573151157e-24,
 -6.044913354905919e-26,  2.258809193375499e-27, -7.886471625676805e-29,  1.383150270305487e-01, -8.085310147374440e-04,  5.450583021407566e-06, -1.131821201602825e-08,
  2.675489373837297e-10, -2.005456014103618e-11, -1.549166421202488e-13,  1.751051742428523e-14,  2.283036019731932e-16, -1.654271177076196e-17, -2.778235468188097e-19,
  1.519949109809828e-20,  8.963883698091270e-02, -5.457258046917869e-04,  4.930434031680431e-06, -4.797069334577864e-08,  4.706199288131394e-10, -4.569530902242393e-12,
  3.581506210091396e-14, -1.980316910771088e-16,  9.307191379915687e-18, -1.412361499156619e-19, -8.557535985210904e-21,  5.977215267660580e-23,  3.733260963585703e-02,
 -2.461348969282883e-04,  3.274679937934425e-06, -5.620208421899744e-08,  5.060702765032204e-10,  3.884190592880822e-12,  1.530403401588888e-13, -1.007760763585093e-14,
 -1.128079667837201e-16,  8.756126959915118e-18,  1.468588006029953e-19, -8.136325627265394e-21,  9.815586240876145e-03, -7.268642158629414e-05,  1.383877057559103e-06,
 -3.082707990030349e-08,  3.038079137965769e-10,  2.280540334496214e-12,  1.160258383686868e-13, -6.933818554079533e-15, -7.512636883937540e-17,  5.749225177090664e-18,
  1.037875096718680e-19, -5.358942935637154e-21,  1.582174930084067e-03, -1.361537460249175e-05,  3.499703220916723e-07, -9.061208256387643e-09,  1.044725224164347e-10,
  2.033322394899085e-13,  4.458890813052379e-14, -2.204439573742131e-15, -2.069094965256438e-17,  1.635445257953584e-18,  3.308279384344810e-20, -1.556491155540269e-21,
  1.494988789711012e-04, -1.545176721176950e-06,  5.081697822656728e-08, -1.467527195661712e-09,  2.049050941205333e-11, -1.047940888716356e-13,  9.757131585102756e-15,
 -3.841642213503624e-16, -2.370410756082637e-18,  2.239056201881065e-19,  5.632856209112202e-21, -2.302972461105358e-22,  7.738116880907040e-06, -9.946430020319913e-08,
  4.017612220347782e-09, -1.280014741898441e-10,  2.213373160078961e-12, -2.741679975041052e-14,  1.221444050533531e-15, -3.883264512174221e-17, -7.990944061979746e-21,
  1.259421046113957e-20,  5.407599808579189e-22, -1.778324301866885e-23,  1.974924355747606e-07, -3.292314406250972e-09,  1.590849783842392e-10, -5.633686166501157e-12,
  1.230344688131859e-13, -2.416856749944180e-15,  8.338761730559787e-17, -2.321515457450718e-18,  2.010635263059244e-20, -6.095739114231325e-23,  3.138454687352042e-23,
 -7.713841873513117e-25,  2.088011039278971e-09, -4.793180707779339e-11,  2.745410096145535e-12, -1.109189395245861e-13,  3.137353299379173e-15, -8.567185115774055e-17,
  2.823231490793884e-18, -7.880771617124705e-20,  1.478537144254487e-21, -3.244862160654573e-23,  1.230297557558023e-24, -2.603909158774695e-26,  6.607831322126462e-12,
 -2.323031638496813e-13,  1.608864755866110e-14, -7.864691873755543e-16,  3.015623608010714e-17, -1.108954994572387e-18,  4.061163049241213e-20, -1.318021136401328e-21,
  3.768934251952137e-23, -1.094693600403891e-24,  3.242951809527038e-26, -8.154123452010892e-28,  2.916712014458946e-15, -2.059425598984919e-16,  1.929216290221713e-17,
 -1.335979268484746e-18,  7.818610985589154e-20, -4.167224431129730e-21,  2.027695927641648e-22, -8.958038084528411e-24,  3.651672257127808e-25, -1.396510993792265e-26,
  5.004718409518243e-28, -1.672776416269555e-29,  1.351673140625095e-01, -7.654277849072318e-04,  5.327033665268332e-06, -1.027413710489180e-08, -1.292418464502382e-10,
 -1.765474363549772e-11,  3.412396591853998e-13,  1.460337744599063e-14, -3.863892542807529e-16, -1.270788763244114e-17,  4.339585689053746e-19,  1.054224956088616e-20,
  8.753134686808348e-02, -5.084635665352495e-04,  4.397096749341113e-06, -4.112655757944573e-08,  3.875220866603135e-10, -3.749618408633616e-12,  3.327823093160143e-14,
 -3.369643673635019e-17, -1.347251711594608e-20, -2.974189514971447e-19,  2.849337275360405e-21,  3.310691851654086e-22,  3.639639671675370e-02, -2.224907981666183e-04,
  2.651776537832853e-06, -4.738322394822141e-08,  5.968421206981368e-10,  4.075911705891165e-12, -1.286834580521915e-13, -8.289269004730604e-15,  2.117334133593312e-16,
  6.671389086741437e-18, -2.313098957867629e-19, -5.549377098585271e-21,  9.544761787466950e-03, -6.300835828524388e-05,  1.044926505357121e-06, -2.551823552666328e-08,
  3.610103166363394e-10,  2.670949654984661e-12, -7.793779309408796e-14, -5.745028402066454e-15,  1.420538279307668e-16,  4.551856109659512e-18, -1.525367572010732e-19,
 -3.902024602685197e-21,  1.532665175288841e-03, -1.122155371528703e-05,  2.515287920740776e-07, -7.320545983452671e-09,  1.141063403801426e-10,  5.177590565037438e-13,
 -1.661306927369608e-14, -1.822641477007390e-15,  4.289459361538380e-17,  1.366032546228423e-18, -4.404580298790157e-20, -1.226406897487322e-21,  1.440274516908678e-04,
 -1.203603823946249e-06,  3.513565741678057e-08, -1.147427984368635e-09,  1.985623257131404e-11,  1.683473856322685e-16, -6.722121822118839e-16, -3.107606752051292e-16,
  6.845384661237761e-18,  2.057747578968870e-19, -6.321649644776981e-21, -2.011395402015813e-22,  7.395619176367563e-06, -7.289857645855163e-08,  2.680145300277948e-09,
 -9.574514705634845e-11,  1.872143083842904e-12, -1.065456727358192e-14,  2.180603143694136e-16, -2.948657869784153e-17,  6.052307600748740e-19,  1.480652338315774e-20,
 -4.287281473580287e-22, -1.748109410039315e-23,  1.864835419087356e-07, -2.259657582866759e-09,  1.019920063156840e-10, -3.963842558947862e-12,  8.983789938198052e-14,
 -1.118109128651563e-15,  2.834889322593921e-17, -1.548303117562891e-18,  3.079791102354070e-20,  3.721513560039146e-22, -9.983046306265042e-24, -7.920726253103016e-25,
  1.932839597481771e-09, -3.054895123466686e-11,  1.669107982509336e-12, -7.141227796241688e-14,  1.946865278359784e-15, -3.984227833598984e-17,  1.158215121185198e-18,
 -4.290627922440211e-20,  9.242626704751109e-22, -5.512142562400122e-24,  1.605259229525637e-25, -1.939402348903941e-26,  5.885990698308837e-12, -1.345372797680304e-13,
  8.956403692157367e-15, -4.389309362429397e-16,  1.531215937765628e-17, -4.698137325740916e-19,  1.610689654152256e-20, -5.501946499943660e-22,  1.476756771706742e-23,
 -3.286852633196991e-25,  9.394709323476592e-27, -3.150252094014400e-28,  2.323496718422531e-15, -9.942604310105263e-17,  8.685882423332092e-18, -5.536995226834848e-19,
  2.845067907286047e-20, -1.345501664605636e-21,  6.093047723822769e-23, -2.544015850568093e-24,  9.627658205087925e-26, -3.417015597958620e-27,  1.174283824944749e-28,
 -3.826752900748838e-30,  1.321899739625322e-01, -7.233631989003821e-04,  5.181436222455981e-06, -1.461201335370606e-08, -3.758475746269711e-10, -6.243754739094386e-12,
  5.353048916416202e-13, -1.249805402747682e-15, -4.845061670373555e-16,  6.843486805590255e-18,  3.805389351047034e-19, -1.093612017093839e-20,  8.556486217853018e-02,
 -4.751608807824308e-04,  3.938444867771426e-06, -3.548318398328956e-08,  3.204027036376769e-10, -2.970807954943905e-12,  3.101476757980669e-14, -1.605100116324570e-16,
 -6.052708532623687e-18,  2.423857801881933e-21,  8.798389061952466e-21, -1.019125198412412e-22,  3.554549640383495e-02, -2.033838624515579e-04,  2.142443585018057e-06,
 -3.741239757417388e-08,  6.333163651407863e-10, -8.816359010644581e-13, -2.442050264775503e-13,  2.924902983629816e-16,  2.610131511742191e-16, -3.699766334550796e-18,
 -2.008854192785579e-19,  5.828046194303984e-21,  9.307650661141019e-03, -5.577245585070817e-05,  7.746744001357042e-07, -1.946032225835566e-08,  3.858197532497786e-10,
 -5.124241321245165e-13, -1.601169682643597e-13,  6.168814699919264e-17,  1.779519673946290e-16, -2.441146322822663e-18, -1.380048029835291e-19,  3.878567259660520e-21,
  1.491291647075091e-03, -9.529099612254510e-06,  1.748683031381165e-07, -5.447780183511641e-09,  1.172847872067783e-10, -3.067557619170034e-13, -4.385095093552646e-14,
 -6.340274289257153e-17,  5.427909388368189e-17, -7.148252950303759e-19, -4.202854083488579e-20,  1.136551038615254e-21,  1.396956048740892e-04, -9.722122859927503e-07,
  2.326313193810495e-08, -8.330230409427912e-10,  1.914306476770118e-11, -9.083045363555450e-14, -5.607721451828997e-15, -3.241151049712020e-17,  8.623176575750886e-18,
 -1.078195362078870e-19, -6.547562688813064e-21,  1.680078674829368e-22,  7.140328954248325e-06, -5.555952176870298e-08,  1.704157098940223e-09, -6.744766199700154e-11,
  1.657388277049591e-12, -1.279347697550949e-14, -2.860011667455938e-16, -5.871198843187517e-18,  7.263039736057404e-19, -8.615871779628525e-21, -5.154534512159651e-22,
  1.228677461892008e-23,  1.788080122145876e-07, -1.611074025100260e-09,  6.239694672001958e-11, -2.680982436500801e-12,  7.138156188679078e-14, -8.383000906240493e-16,
 -3.833087512749728e-20, -4.734378762595699e-19,  3.173292373431624e-20, -3.748649736839744e-22, -1.835130637879301e-23,  3.902233001423119e-25,  1.832600109011323e-09,
 -2.014686855638052e-11,  9.766799928162581e-13, -4.547742032963728e-14,  1.347222431074969e-15, -2.329303209516130e-17,  3.420828604202508e-19, -1.655624436764192e-20,
  6.941959583272953e-22, -9.626920602582612e-24, -1.968979050483923e-25,  2.966060243509809e-27,  5.462867985173031e-12, -8.039001110731410e-14,  4.904896195030205e-15,
 -2.524995467306718e-16,  8.770848173626979e-18, -2.236271328089352e-19,  5.924631011674517e-21, -2.162733365432087e-22,  7.149710764285143e-24, -1.449834958206778e-25,
  1.664587819159099e-27, -5.942052502709948e-29,  2.031443129156084e-15, -5.040597326136050e-17,  4.088356618663113e-18, -2.534632051084136e-19,  1.180717269166362e-20,
 -4.777440499914945e-22,  1.928113130942616e-23, -7.772059445568156e-25,  2.850211530256308e-26, -9.199811493290850e-28,  2.813174784173079e-29, -8.918370735749433e-31,
  1.293781622987960e-01, -6.827204460515678e-04,  4.968050622136290e-06, -2.096620989493176e-08, -3.828717835735321e-10,  4.738826285662309e-12,  3.352377343663311e-13,
 -1.091488273414534e-14, -9.273257780145020e-17,  1.146371087083958e-17, -1.249225569673589e-19, -8.028084762002056e-21,  8.372465445235876e-02, -4.452736271226400e-04,
  3.541570515295701e-06, -3.079352616749624e-08,  2.679610970889414e-10, -2.300090120023039e-12,  2.422689914604671e-14, -2.992079533954003e-16, -1.501208956555019e-18,
  1.874227011280082e-19, -2.627929481466785e-22, -2.036065517179999e-22,  3.476363562063246e-02, -1.878711798589908e-04,  1.752723931624785e-06, -2.772108965553569e-08,
  5.619349546885629e-10, -5.865409675963737e-12, -1.469734844870107e-13,  5.516043026816725e-15,  5.149412726871144e-17, -6.107135448567557e-18,  6.709852530236328e-20,
  4.236674246739851e-21,  9.095622116950707e-03, -5.040630317064156e-05,  5.772012794491212e-07, -1.356716485979147e-08,  3.401545540563419e-10, -3.801218774826992e-12,
 -9.733253152497813e-14,  3.656737250713166e-15,  3.675329080446574e-17, -4.156581656776372e-18,  4.411587975142792e-20,  2.930598577401681e-21,  1.455603076663567e-03,
 -8.360572952204432e-06,  1.203725921164903e-07, -3.674955805972097e-09,  1.013615069508796e-10, -1.216888860126649e-12, -2.685551982289892e-14,  1.047918107909755e-15,
  1.200337175492032e-17, -1.258242966903283e-18,  1.278865714503002e-20,  9.011390123707039e-22,  1.361227657610812e-04, -8.210704525299141e-07,  1.502133186124062e-08,
 -5.483874128810392e-10,  1.604773997267748e-11, -2.101126177051657e-13, -3.500217146573588e-15,  1.475793264595955e-16,  2.106384114952294e-18, -1.963888478425122e-19,
  1.882027579242968e-21,  1.426472551798587e-22,  6.940838976116632e-06, -4.473491420623639e-08,  1.044193308799690e-09, -4.336282379920201e-11,  1.331498912021569e-12,
 -1.940224191546999e-14, -1.927825001949218e-16,  9.694274857373528e-18,  2.034611842779261e-19, -1.591261748940490e-20,  1.416046749368210e-22,  1.158132674431785e-23,
  1.731840246479089e-07, -1.222459042037071e-09,  3.651656816895425e-11, -1.675699586182087e-12,  5.405754864391120e-14, -9.000510658576814e-16, -1.871272110650718e-18,
  2.278083131989879e-19,  1.051521085854883e-20, -6.401124302952789e-22,  5.355718307573559e-24,  4.450836865679867e-25,  1.764656781466314e-09, -1.418302233631870e-11,
  5.460240374215023e-13, -2.731967863531275e-14,  9.373618550603664e-16, -1.849959916269954e-17,  1.291777270887034e-19, -9.328406993312137e-22,  2.682402293887975e-22,
 -1.189682884151545e-23,  1.079233249533322e-25,  6.590524161703986e-27,  5.203568946255064e-12, -5.118340444523164e-14,  2.589701787403576e-15, -1.418723225030007e-16,
  5.344262607795697e-18, -1.326931548594916e-19,  2.361692112770429e-21, -6.083474996224922e-23,  2.849463710645359e-24, -9.511712851200145e-26,  1.344933280335966e-27,
  1.331896701780578e-29,  1.879714871913833e-15, -2.724699089464259e-17,  1.929940627955794e-18, -1.217179337947858e-19,  5.543074576359192e-21, -1.974494257671974e-22,
  6.508023259343380e-24, -2.358472396397056e-25,  8.926250624331192e-27, -2.958628165167308e-28,  7.987518187209224e-30, -1.957769262350281e-31,  1.267250413042067e-01,
 -6.440770418797595e-04,  4.683955407994961e-06, -2.600230202085172e-08, -2.326767157639840e-10,  9.115648246025706e-12,  4.032941587169711e-14, -8.713879721588081e-15,
  1.782111233424199e-16,  3.005159753079867e-18, -2.185445557560910e-19,  2.583422348061143e-21,  8.199798329295158e-02, -4.183495719960495e-04,  3.196348890589126e-06,
 -2.684544111854326e-08,  2.270920929934429e-10, -1.818807190102745e-12,  1.609415341516474e-14, -2.548803391586959e-16,  3.509022204014736e-18,  6.583548562645773e-20,
 -4.088870524339132e-21,  2.347531884373861e-23,  3.403829046586623e-02, -1.750370489903662e-04,  1.469670971374596e-06, -1.980674934369153e-08,  4.220539719708903e-10,
 -7.530952811964041e-12,  2.720899864336277e-15,  4.411743056109051e-15, -9.279399556548670e-17, -1.604552920258876e-18,  1.159896405177669e-19, -1.378831606620329e-21,
  8.902323198833691e-03, -4.635382039541431e-05,  4.442275291977794e-07, -8.824216937366101e-09,  2.492241337325351e-10, -4.896954832059675e-12,  2.522835106612136e-15,
  2.951873915907511e-15, -6.206827690921563e-17, -1.114382829704243e-18,  7.914900928176820e-20, -9.191214151148060e-22,  1.423843709408649e-03, -7.548445976655213e-06,
  8.511530468588675e-08, -2.272625526828027e-09,  7.301954187079178e-11, -1.502764821630135e-12,  2.089057689805874e-15,  8.595853008375938e-16, -1.815716790454987e-17,
 -3.469183466079113e-19,  2.398947007748828e-20, -2.705598980608209e-22,  1.330428605812496e-04, -7.231991710573960e-07,  9.831806866036326e-09, -3.283404933891616e-10,
  1.135446024099094e-11, -2.426920703717807e-13,  6.693089682189742e-16,  1.249725559058946e-16, -2.656123281015293e-18, -5.644490979468019e-20,  3.739522669342716e-21,
 -4.051125182278934e-23,  6.775781790727981e-06, -3.813125021638603e-08,  6.383138440808405e-10, -2.531529735597508e-11,  9.209352938718367e-13, -2.050693531355635e-14,
  9.582919849634697e-17,  8.838906061330675e-18, -1.887289201226203e-19, -4.863832786066568e-21,  3.004762454491851e-22, -3.082996859596488e-24,  1.687700502266619e-07,
 -9.974276948146748e-10,  2.100277843608125e-11, -9.546262657945259e-13,  3.623811051146290e-14, -8.494581242912669e-16,  6.217888630957128e-18,  2.644983032780471e-19,
 -5.590454583540633e-21, -2.135742766693326e-22,  1.175673684931698e-23, -1.131664263306199e-25,  1.714909044820310e-09, -1.089822685362410e-11,  2.965179939513946e-13,
 -1.510948990087958e-14,  5.997359775466407e-16, -1.509753386896023e-17,  1.673138356068685e-19,  2.043601672648516e-21, -3.625161327656436e-23, -4.412083639862012e-24,
  2.018090523562122e-25, -1.897128945200638e-27,  5.031296983349554e-12, -3.600595906413388e-14,  1.321464522368245e-15, -7.494584488675216e-17,  3.160480815061766e-18,
 -8.892058493324125e-20,  1.498880278082842e-21, -1.331220722304017e-23,  4.702479338291505e-25, -3.716391136217516e-26,  1.324579268496944e-27, -1.561011912270751e-29,
  1.794146471781996e-15, -1.639636565624191e-17,  8.936601557372562e-19, -5.790595771173300e-20,  2.753057278426451e-21, -9.620705173905808e-23,  2.662647111068467e-24,
 -7.215567756584756e-26,  2.480638014386032e-27, -9.439354043356999e-29,  2.972881952475829e-30, -6.724588510083445e-32,  1.242216291556877e-01, -6.079029617108583e-04,
  4.355580440776972e-06, -2.828465750554458e-08, -5.689101690666023e-11,  7.846617549498118e-12, -1.179479627945885e-13, -2.677828489003753e-15,  1.657893048309857e-16,
 -2.577268641860586e-18, -5.544540247414693e-20,  3.449834332756549e-21,  8.037377005041436e-02, -3.940082322871764e-04,  2.894865966762916e-06, -2.348417053348802e-08,
  1.940715222421793e-10, -1.504345523758630e-12,  1.068328340632504e-14, -1.321143023521510e-16,  3.483513876399644e-18, -4.751925253916965e-20, -1.254420027053245e-21,
  7.098185294127312e-23,  3.336029892154616e-02, -1.641268479947465e-04,  1.267647540152841e-06, -1.421972472105114e-08,  2.802381114610998e-10, -6.343865802111881e-12,
  8.150695864331050e-14,  1.259570165786917e-15, -8.658157798118155e-17,  1.356328413715216e-18,  2.941094339059767e-20, -1.827605714651141e-21,  8.723430982095434e-03,
 -4.316307353476363e-05,  3.591075338659345e-07, -5.593069141224926e-09,  1.573398764291213e-10, -4.086701469205286e-12,  5.510693380743406e-14,  8.309508225458741e-16,
 -5.839993713492360e-17,  9.146717641018743e-19,  2.030867072796857e-20, -1.251453284060037e-21,  1.394864144535105e-03, -6.958979252868800e-06,  6.388998778477255e-08,
 -1.335117519578960e-09,  4.504865435959832e-11, -1.235115476864374e-12,  1.729074855359260e-14,  2.328944469169466e-16, -1.732530434970101e-17,  2.714219552874065e-19,
  6.254396036036166e-21, -3.806114458132298e-22,  1.302863061325152e-04, -6.575747181239167e-07,  6.827200697781715e-09, -1.836249123716010e-10,  6.890490525591666e-12,
 -1.951995763894216e-13,  2.852237408037184e-15,  3.159257688435615e-17, -2.600871264882684e-18,  4.068426531767045e-20,  9.982960408932507e-22, -5.952697411121853e-23,
  6.631859859010244e-06, -3.401937500325284e-08,  4.100076265290145e-10, -1.366593709720172e-11,  5.499032541250993e-13, -1.600715053576884e-14,  2.469025639916907e-16,
  1.947391892567810e-18, -1.949102058590929e-19,  3.025782815109311e-21,  8.314126247171129e-23, -4.790140012985115e-24,  1.650561250044381e-07, -8.665984615752696e-10,
  1.249760952536556e-11, -5.005289625538908e-13,  2.121728918790080e-14, -6.357579139939803e-16,  1.053230485094373e-17,  3.938689404399026e-20, -6.608328403817815e-21,
  9.973978490280522e-23,  3.435321477034935e-24, -1.863260560463099e-25,  1.675114033354973e-09, -9.109658957565864e-12,  1.635655349382186e-13, -7.695419986395738e-15,
  3.414609700966388e-16, -1.062292062162514e-17,  1.942233551779428e-19, -3.316703738094364e-22, -7.955915821447950e-23,  1.056749866391470e-24,  6.378762541501061e-26,
 -3.099779853312288e-27,  4.903771447239941e-12, -2.829500320810907e-14,  6.728637193955786e-16, -3.675958868343039e-17,  1.716358639320957e-18, -5.662918894637517e-20,
  1.199433071361383e-21, -1.105085811910159e-23, -1.158956659338609e-25, -1.336149401619377e-27,  4.525238056015196e-28, -1.812041711629725e-29,  1.739347993341868e-15,
 -1.140428841936704e-17,  4.092706369995772e-19, -2.633680908955313e-20,  1.339907408561315e-21, -5.002541356914204e-23,  1.376839452276950e-24, -2.918535124376279e-26,
  6.287375750980263e-28, -2.197959088019268e-29,  9.184221322791486e-31, -2.952709629641008e-32,  1.218575494746401e-01, -5.744206153876178e-04,  4.015337277310426e-06,
 -2.810916216797749e-08,  6.836037356673158e-11,  4.621045605283641e-12, -1.341700889527365e-13,  9.633764683751967e-16,  6.224718481367871e-17, -2.580135902248011e-18,
  3.489872780843547e-20,  7.284012122424317e-22,  7.884234179593241e-02, -3.719259587825989e-04,  2.630736104675239e-06, -2.060684411131171e-08,  1.663065376603272e-10,
 -1.281532189555198e-12,  8.249598874914167e-15, -5.247059333026719e-17,  1.485202416311987e-18, -5.067792305968056e-20,  6.826684325104958e-22,  1.634482827670592e-23,
  3.272308900720581e-02, -1.546009030124403e-04,  1.120091609649828e-06, -1.063766021991451e-08,  1.743709621966174e-10, -4.227754064723682e-12,  8.615993781253568e-14,
 -6.343546267294289e-16, -3.202184659840732e-17,  1.359727501866713e-18, -1.843267466746458e-20, -3.857833049188881e-22,  8.556152183348903e-03, -4.052160374322438e-05,
  3.046442750016547e-07, -3.653106879892697e-09,  8.976658673646088e-11, -2.662427134274357e-12,  5.773984982709984e-14, -4.444381597725349e-16, -2.143907720560818e-17,
  9.224359227011544e-19, -1.252730040140365e-20, -2.656841374047221e-22,  1.367964014920607e-03, -6.501415778417478e-06,  5.145472855294015e-08, -7.881935711430748e-10,
  2.474281887733817e-11, -7.944934573100471e-13,  1.769924537746713e-14, -1.443718157213865e-16, -6.277013121016942e-18,  2.763838328005830e-19, -3.761301170619280e-21,
 -8.144443324079350e-23,  1.277535732652911e-04, -6.101685621338220e-07,  5.168860994414817e-09, -1.007389904100635e-10,  3.700463527379884e-12, -1.240186616689111e-13,
  2.821077853195067e-15, -2.480037411194524e-17, -9.231745537543724e-19,  4.215412926618194e-20, -5.745909509777631e-22, -1.289261989775383e-23,  6.501485646008861e-06,
 -3.126789888850029e-08,  2.893085503437462e-10, -7.099367958307140e-12,  2.902722641995665e-13, -1.001739414730512e-14,  2.329893400845052e-16, -2.252451638637632e-18,
 -6.694296372643612e-20,  3.243944121675014e-21, -4.417634266880723e-23, -1.057552169327615e-24,  1.617586388788324e-07, -7.857487114870540e-10,  8.153105669113789e-12,
 -2.490454781892905e-13,  1.101209979731312e-14, -3.897305885512993e-16,  9.322643928757607e-18, -1.016687414239334e-19, -2.138777966411528e-21,  1.156185264807297e-22,
 -1.558854790965241e-24, -4.245477091224487e-26,  1.640819457756743e-09, -8.092173567971743e-12,  9.779017385084464e-14, -3.686202328925305e-15,  1.735712544353191e-16,
 -6.313803625185397e-18,  1.571753668283340e-19, -2.002815939678529e-21, -2.223540219622491e-23,  1.573486678266239e-24, -2.022627782462154e-26, -7.449217053652211e-28,
  4.799121250213424e-12, -2.428617085070783e-14,  3.639053246708032e-16, -1.690682408464376e-17,  8.445640935077212e-19, -3.192876609667113e-20,  8.478969525726912e-22,
 -1.335634595625805e-23,  6.267041761024582e-27,  4.864343965697080e-27, -4.216854252308414e-29, -4.731461237004775e-30,  1.698705024669055e-15, -9.095448813346345e-18,
  1.939820835485434e-19, -1.135121304725276e-20,  6.130420488430738e-22, -2.504570207779740e-23,  7.605477382828703e-25, -1.670549176519513e-26,  2.560568592500982e-28,
 -3.715094391678335e-30,  1.519947062555683e-31, -7.971834429681027e-33,  1.196220102632847e-01, -5.436226171574920e-04,  3.687105698490749e-06, -2.643876219274628e-08,
  1.316027597741631e-10,  1.874492961803017e-12, -9.114820932708843e-14,  1.769528568507961e-15, -2.440306631200184e-18, -1.025940571337683e-18,  3.436952213652366e-20,
 -4.463769208521257e-22,  7.739522499724670e-02, -3.518258432789917e-04,  2.398607262721778e-06, -1.814064963453053e-08,  1.425581551930122e-10, -1.097277347795220e-12,
  7.213734909268467e-15, -2.815532695252311e-17,  2.231993567695417e-19, -1.961976442373713e-20,  6.840507215282532e-22, -9.516893654929562e-24,  3.212185775979930e-02,
 -1.461090817588537e-04,  1.006732560512099e-06, -8.419410219170807e-09,  1.086288330562922e-10, -2.449206727667850e-12,  6.028870088781135e-14, -1.034573510140402e-15,
  2.028711972087160e-18,  5.384043788854538e-19, -1.816596851444541e-20,  2.359587197203519e-22,  8.398692160831020e-03, -3.823896529672849e-05,  2.678971410252317e-07,
 -2.572806835326772e-09,  4.908341286020490e-11, -1.476643942028460e-12,  3.991917708905422e-14, -7.072171214063239e-16,  1.623236545445296e-18,  3.630263194018188e-19,
 -1.237394931766025e-20,  1.614152566546816e-22,  1.342729812861842e-03, -6.121946983549089e-06,  4.391760841913435e-08, -4.980237534735497e-10,  1.269090104950233e-11,
 -4.328686304417851e-13,  1.211060550435183e-14, -2.185690179095394e-16,  6.172339778183136e-19,  1.078139511398010e-19, -3.730311997322959e-21,  4.891176062391965e-23,
  1.253891455280063e-04, -5.728125867061842e-07,  4.244547606376472e-09, -5.797577710499890e-11,  1.828964943915038e-12, -6.675715423420695e-14,  1.905950215877781e-15,
 -3.505453729968353e-17,  1.249946362033970e-19,  1.623303188473869e-20, -5.743107150372446e-22,  7.579006513052427e-24,  6.380597165745058e-06, -2.922861839208055e-08,
  2.262886154356980e-10, -3.778524919145777e-12,  1.398909936309749e-13, -5.330222614749031e-15,  1.547522191837293e-16, -2.913596202572722e-18,  1.336178057857155e-20,
  1.225281904894424e-21, -4.486442228006276e-23,  5.966003867643102e-25,  1.587307070367127e-07, -7.300013805709176e-10,  6.000996629570452e-12, -1.241145364768408e-13,
  5.198928454970281e-15, -2.045231036292092e-16,  6.045242151013557e-18, -1.174669979811832e-19,  7.055904451545936e-22,  4.233449619583316e-23, -1.641889205572266e-24,
  2.199947684594123e-26,  1.609790810853053e-09, -7.447942299603634e-12,  6.666114033140057e-14, -1.734220887948555e-15,  8.025762353581897e-17, -3.249226098893138e-18,
  9.830960198872947e-20, -1.999781285233957e-21,  1.613268371204763e-23,  5.433290715427740e-25, -2.364625579500155e-26,  3.169998131806248e-28,  4.706782749577599e-12,
 -2.199870565367658e-14,  2.242678531127425e-16, -7.521589876717075e-18,  3.799295691786481e-19, -1.590122303875228e-20,  4.991590508603597e-22, -1.093053804851086e-23,
  1.237826581747356e-25,  1.395630678830040e-27, -8.921871869116279e-29,  1.123203569293618e-30,  1.664756696160276e-15, -7.954055497052165e-18,  1.029046796066717e-19,
 -4.701756532708023e-21,  2.611413092653529e-22, -1.157456359553989e-23,  3.927749385300700e-25, -9.969387104245088e-27,  1.758074470208714e-28, -1.683235520281204e-30,
  2.166941578115355e-33, -6.015985620878254e-34,  1.175045575588514e-01, -5.153568774475912e-04,  3.383371438257592e-06, -2.413572119223184e-08,  1.510712032589448e-10,
  2.470167528329553e-13, -4.659396288613137e-14,  1.324457624088295e-15, -1.974322288462163e-17, -7.514628391589311e-20,  1.363149168798011e-20, -4.005414742060510e-22,
  7.602497326975456e-02, -3.334705685838591e-04,  2.193910605529582e-06, -1.602613700974306e-08,  1.222820682292463e-10, -9.332862491756574e-13,  6.451774882557948e-15,
 -2.791177304723160e-17, -9.907801623838891e-20, -1.224886908377111e-21,  2.482772391331271e-22, -8.192938163037150e-24,  3.155292666900553e-02, -1.384330656552956e-04,
  9.147400044795172e-07, -7.004138294843845e-09,  7.186494999634520e-11, -1.329126077011951e-12,  3.426965037646214e-14, -7.779001154215318e-16,  1.103644154850128e-17,
  3.596834615750097e-20, -7.198397331071746e-21,  2.119089858889946e-22,  8.249843395707548e-03, -3.620787106626221e-05,  2.409116336244041e-07, -1.978183745586176e-09,
  2.759748828186837e-11, -7.413111024572976e-13,  2.221425533587709e-14, -5.267313277902048e-16,  7.633301218902849e-18,  2.144030116602165e-20, -4.873164864075350e-21,
  1.447453738660156e-22,  1.318910979690505e-03, -5.791624726869912e-06,  3.891960451900978e-08, -3.504400122937564e-10,  6.467720696715439e-12, -2.107532351392184e-13,
  6.671530841924206e-15, -1.609779002524652e-16,  2.373631037891558e-18,  5.092393487679333e-21, -1.457143234535826e-21,  4.380636692982968e-23,  1.231619887074890e-04,
 -5.412284925119136e-07,  3.687529872431579e-09, -3.722821603811139e-11,  8.758516902912187e-13, -3.194195329781200e-14,  1.040721973004503e-15, -2.543445566966246e-17,
  3.828898635241695e-19,  4.724506458429889e-22, -2.217447340386581e-22,  6.783685801234196e-24,  6.267060668039165e-06, -2.756855189900483e-08,  1.914387964114760e-10,
 -2.217764787590847e-12,  6.420097644418575e-14, -2.517083706140498e-15,  8.363964580417094e-17, -2.071082255695740e-18,  3.203685706860014e-20,  3.900814185605981e-26,
 -1.702893552117426e-23,  5.347514833480695e-25,  1.558989293059244e-07, -6.868017719728367e-10,  4.898355257862984e-12, -6.683078207074486e-14,  2.310582872217914e-15,
 -9.534923696506490e-17,  3.222885458084259e-18, -8.111897768575443e-20,  1.302390887270567e-21, -2.189422151124103e-24, -6.068334935808357e-25,  1.987175458155263e-26,
  1.580959066310217e-09, -6.980261281886373e-12,  5.177688703838288e-14, -8.595945725916508e-16,  3.468868203147368e-17, -1.491101291325122e-18,  5.135589992533727e-20,
 -1.322930964611020e-21,  2.241216605032285e-23, -9.090667949846424e-26, -8.339946108227064e-27,  2.950204636838672e-28,  4.621923336346371e-12, -2.048268181386529e-14,
  1.618315646742028e-16, -3.431640430841209e-18,  1.593422983304025e-19, -7.121879266117173e-21,  2.518612992418218e-22, -6.738794886738934e-24,  1.242627752376036e-25,
 -9.526098050879998e-28, -2.811961213140963e-29,  1.215293377556765e-30,  1.634310367926538e-15, -7.300164915714589e-18,  6.533968171511266e-20, -1.947435092835770e-21,
  1.043534336632784e-22, -4.917948670555829e-24,  1.832805223667174e-25, -5.313688784702385e-27,  1.153026100167370e-28, -1.638976873433040e-30,  6.079618240227301e-33,
  3.087263106582125e-34,  1.154954877564754e-01, -4.894072911027432e-04,  3.108243190357275e-06, -2.172849463924031e-08,  1.474644885555642e-10, -4.971178205046447e-13,
 -1.818752052274854e-14,  7.247668313798741e-16, -1.617987244198565e-17,  1.943585463569790e-19,  1.671252493237927e-21, -1.536363822479815e-22,  7.472502073191696e-02,
 -3.166566428746945e-04,  2.012746581757788e-06, -1.421080874383740e-08,  1.050996397517705e-10, -7.881680338887778e-13,  5.629320504023996e-15, -3.047257784058767e-17,
 -3.557829090010479e-20,  3.208964555685726e-21,  1.340384795199512e-23, -2.786515019315036e-24,  3.101332318888789e-02, -1.314335607783977e-04,  8.368384059036439e-07,
 -6.028960168940367e-09,  5.194828134324900e-11, -7.285049038431136e-13,  1.732488142169821e-14, -4.437893778016548e-16,  9.024752598455792e-18, -1.060547297981236e-19,
 -8.693531787005080e-22,  8.131932779827561e-23,  8.108725476577176e-03, -3.436898577500207e-05,  2.194148468828468e-07, -1.630786042998064e-09,  1.704974372572283e-11,
 -3.579029701346300e-13,  1.079723444956709e-14, -2.969546994017451e-16,  6.176749117878192e-18, -7.396086625882464e-20, -5.598323317536822e-22,  5.517879440589607e-23,
  1.296342684934617e-03, -5.495600598961994e-06,  3.522049139600944e-08, -2.733565151025750e-10,  3.532611381344845e-12, -9.629087287665415e-14,  3.194223769742895e-15,
 -9.007785000385449e-17,  1.894777870721502e-18, -2.312587641466108e-20, -1.554453004340848e-22,  1.655865723520323e-23,  1.210535279466016e-04, -5.133178128322451e-07,
  3.307585151164987e-09, -2.718572162622090e-11,  4.361420789906731e-13, -1.415857650538595e-14,  4.934335106595430e-16, -1.411763984688050e-17,  3.000582983867125e-19,
 -3.752591010468303e-21, -2.096370709805694e-23,  2.533732843785421e-24,  6.159701323185876e-06, -2.612923848531243e-08,  1.696319981600236e-10, -1.501886849955214e-12,
  2.982052483357196e-14, -1.093447328266146e-15,  3.930006326284425e-17, -1.137687188203884e-18,  2.448081840628915e-20, -3.162433829151802e-22, -1.290567945227451e-24,
  1.962760282751818e-25,  1.532257430673992e-07, -6.503154527801317e-10,  4.266973926762134e-12, -4.160448672233814e-14,  1.016656329712867e-15, -4.074893550636975e-17,
  1.498497688337964e-18, -4.391892182721878e-20,  9.607927631550348e-22, -1.297248114693617e-23, -2.687256963593375e-26,  7.100063464799848e-27,  1.553811933130197e-09,
 -6.599759586793742e-12,  4.399364245581504e-14, -4.873768233556505e-16,  1.459111616377987e-17, -6.267869886226505e-19,  2.353247993148530e-20, -7.007691233409943e-22,
  1.570550301963854e-23, -2.258164169521184e-25,  1.545588779035457e-28,  1.006451217728631e-28,  4.542370361378091e-12, -1.931838568105153e-14,  1.321553289488786e-16,
 -1.749769906141352e-18,  6.423482680540145e-20, -2.929258512573951e-21,  1.126699012694056e-22, -3.439350800716452e-24,  8.021077665404315e-26, -1.270507326226941e-27,
  5.978841668290766e-30,  3.742705753463188e-31,  1.606039037494009e-15, -6.848685785163186e-18,  4.939507723170478e-20, -8.694163002991820e-22,  3.986179220408238e-23,
 -1.939935003762752e-24,  7.775187603889480e-26, -2.498606943881832e-27,  6.330851087688515e-29, -1.198075473478105e-30,  1.382604772172935e-32,  3.065925262723326e-35,
  1.135859945905851e-01, -4.655450824096938e-04,  2.861269428106376e-06, -1.946638589481020e-08,  1.345267599734384e-10, -7.419458333261769e-13, -4.060043835927751e-15,
  3.217059398465984e-16, -9.153976449331902e-18,  1.740504821862966e-19, -1.735646419284512e-21, -2.224726113261581e-23,  7.348955692134911e-02, -3.012093537070356e-04,
  1.851809234353017e-06, -1.264827180842456e-08,  9.061799014202863e-11, -6.633260727705608e-13,  4.777180656682692e-15, -2.983600571351378e-17,  6.937743083518002e-20,
  2.274070456037521e-21, -4.126210777895229e-23, -1.701539066786669e-25,  3.050053880947778e-02, -1.250150929894958e-04,  7.690600543195613e-07, -5.295440936634734e-09,
  4.068291872528914e-11, -4.328127523893082e-13,  8.352478476476560e-15, -2.174198897319421e-16,  5.202396954101014e-18, -9.469862316824288e-20,  9.336183748677612e-22,
  1.175356106240544e-23,  7.974642161078361e-03, -3.268777225321900e-05,  2.012847539506053e-07, -1.403632433508381e-09,  1.191427259176962e-11, -1.787292354611150e-13,
  4.840558709185153e-15, -1.425823249306227e-16,  3.531618045054171e-18, -6.517636908682721e-20,  6.554339169601402e-22,  7.699833831046959e-24,  1.274904228314527e-03,
 -5.226120002547984e-06,  3.222721606647281e-08, -2.288203155728979e-10,  2.201194984871641e-12, -4.382740706217648e-14,  1.393765385823163e-15, -4.287651753955657e-17,
  1.076048748836504e-18, -2.003634297990690e-20,  2.060269475494052e-22,  2.200994647217534e-24,  1.190512555877280e-04, -4.880613498855691e-07,  3.015641962910819e-09,
 -2.194588194683719e-11,  2.444469831145422e-13, -6.100892771503417e-15,  2.121050854994814e-16, -6.673199772925950e-18,  1.690032562159281e-19, -3.177773132215643e-21,
  3.363451689498404e-23,  3.124483115754242e-25,  6.057793958621313e-06, -2.483753875023736e-08,  1.538903992012523e-10, -1.157836331447750e-12,  1.521599657548785e-14,
 -4.545219681166564e-16,  1.670689700689719e-17, -5.336529573061503e-19,  1.363660271209962e-20, -2.596415275036158e-22,  2.855553197833914e-24,  2.135135376245825e-26,
  1.506899133739732e-07, -6.179512303849400e-10,  3.843750483266631e-12, -3.026487591464493e-14,  4.778462140465381e-16, -1.649425902041105e-17,  6.302848455663135e-19,
 -2.039626384611156e-20,  5.268804447681195e-22, -1.020647129922779e-23,  1.182160964720557e-25,  6.043633105061817e-28,  1.528084314638924e-09, -6.268018400617072e-12,
  3.921561429609368e-14, -3.292624908393467e-16,  6.376172951274772e-18, -2.479733385236280e-19,  9.771972906132790e-21, -3.207243488223722e-22,  8.411736171316916e-24,
 -1.671477837916178e-25,  2.081347744557210e-27,  4.083949904476541e-30,  4.467098144647183e-12, -1.833130124661106e-14,  1.157891989256843e-16, -1.071816903022422e-18,
  2.621764917760066e-20, -1.130763592277359e-21,  4.589262762454515e-23, -1.535934049863740e-24,  4.128530823406805e-26, -8.552794639412349e-28,  1.187212625835441e-29,
 -2.914169055910417e-32,  1.579380662990957e-15, -6.486807754792547e-18,  4.178076322634856e-20, -4.607697987181014e-22,  1.508459389154731e-23, -7.205410538966539e-25,
  3.042668648780898e-26, -1.057165569353173e-27,  2.991190634982682e-29, -6.747351412944555e-31,  1.134288372810636e-32, -1.079464330361229e-34,  1.117681652705006e-01,
 -4.435538713544596e-04,  2.640087618933704e-06, -1.743542704563945e-08,  1.192947214499359e-10, -7.591115936422451e-13,  1.687231145685793e-15,  1.147369234147589e-16,
 -4.224881013843466e-18,  1.003905077992363e-19, -1.687845808218067e-21,  1.438472949424591e-23,  7.231342070290396e-02, -2.869783179578691e-04,  1.708310919966907e-06,
 -1.129856536313205e-08,  7.843189989243105e-11, -5.583835248262785e-13,  3.982895498893232e-15, -2.662141841839812e-17,  1.223173735099527e-19,  7.374346072379470e-22,
 -3.147802415810548e-23,  4.143625428405437e-25,  3.001239577785109e-02, -1.191063241128060e-04,  7.091650242527661e-07, -4.704641719951711e-09,  3.362299362011923e-11,
 -2.894722569719635e-13,  4.137403274924756e-15, -9.781052929880338e-17,  2.511199978431115e-18, -5.514264237472799e-20,  9.065931940942997e-22, -7.667007863941796e-24,
  7.847009213416864e-03, -3.114186445218839e-05,  1.854842075191401e-07, -1.236442199164308e-09,  9.235534867363149e-12, -9.967095954031743e-14,  2.115746654084491e-15,
 -6.175570855140702e-17,  1.685354454384342e-18, -3.769259485849495e-20,  6.259065982795515e-22, -5.412484482240709e-24,  1.254498763555233e-03, -4.978743503890828e-06,
  2.966868393149766e-08, -1.991422463928916e-10,  1.579403467918419e-12, -2.149961632650348e-14,  5.787376965054781e-16, -1.831377140524473e-17,  5.103872709422647e-19,
 -1.150893081394741e-20,  1.926709124271664e-22, -1.709642807052576e-24,  1.171456761410079e-04, -4.649308785028488e-07,  2.772477752120349e-09, -1.878808174227589e-11,
  1.609442947870487e-13, -2.737531852491608e-15,  8.569289362809453e-17, -2.825739917841976e-18,  7.968343197209663e-20, -1.809421024391142e-21,  3.058992618770979e-23,
 -2.806931551410821e-25,  5.960823137935818e-06, -2.365842426160662e-08,  1.412157131494083e-10, -9.696140212722642e-13,  9.146020878456538e-15, -1.913821679724167e-16,
  6.629865574491376e-18, -2.242529158481021e-19,  6.382440496065584e-21, -1.460873484301028e-22,  2.502058130998953e-24, -2.399528352543518e-26,  1.482774644681901e-07,
 -5.885445368039571e-10,  3.517764452763361e-12, -2.460044582615717e-14,  2.614965854972679e-16, -6.621872904582212e-18,  2.465642558014829e-19, -8.497375876341878e-21,
  2.441329210180214e-22, -5.646504889218578e-24,  9.847341087607471e-26, -1.001675013119768e-27,  1.503616706606883e-09, -5.968671064427807e-12,  3.574702203823372e-14,
 -2.567484516510495e-16,  3.170263208830795e-18, -9.578236050930629e-20,  3.768756008459942e-21, -1.320728233851490e-22,  3.839609640760893e-24, -9.015713694372104e-26,
  1.614761521727700e-27, -1.781097133318119e-29,  4.395552323150859e-12, -1.745069647994629e-14,  1.048576180238242e-16, -7.856819461892517e-19,  1.179550965618040e-20,
 -4.214111124844773e-22,  1.737969972230046e-23, -6.207973364164232e-25,  1.837458308478975e-26, -4.422520465432120e-28,  8.271041245027484e-30, -1.027226795532867e-31,
  1.554071526329496e-15, -6.171456009610050e-18,  3.732922851682545e-20, -3.034033102697287e-22,  6.052914753256556e-24, -2.568979079073573e-25,  1.114358209433801e-26,
 -4.106890309874288e-28,  1.260151109880082e-29, -3.192604885056949e-31,  6.510972294548831e-33, -9.892023866540979e-35  };
  int offset = -11;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 11;
    if (std::isnan(t)) {
      fill_n(rr+offset, 11, 0.5);
      fill_n(ww+offset, 11, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 11; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=11; ++j) {
        const int boxof = it*132+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
