//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_3.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot3(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[3] = {1.901635091934882e-01,1.784492748543252e+00,5.525343742263258e+00};
  constexpr double aw[3] = {7.246295952243923e-01,1.570673203228564e-01,4.530009905508835e-03};
  constexpr double x[1152] = {  9.957336692678102e-02, -6.807050304362282e-03,  3.315467872729337e-04, -1.337533485322937e-05,  4.481947944382823e-07,
 -1.174035642547162e-08,  1.504657191624295e-10,  7.815869916112967e-12, -6.464553859558240e-13,  2.518229791745552e-14, -6.699963604170288e-16,  9.397072500392028e-18,
  8.009402920832142e-01, -3.630254641170549e-02,  4.533944042960137e-04,  2.715421822468478e-05, -1.109509718946611e-06, -2.705823332383892e-08,  2.579273061161046e-09,
  1.097427914412889e-11, -5.051970776979857e-12,  5.991129367847380e-14,  8.500272771356826e-15, -2.624032320632680e-16,  1.699191937284420e+00, -2.075327538745137e-02,
 -8.702775279212423e-04, -2.024213121755082e-05,  2.298664662700527e-07,  4.547440966841155e-08,  1.906217371846258e-09,  1.013868370107818e-11, -2.990263515152480e-12,
 -1.623106262456608e-13, -2.569507511461012e-15,  1.705875886191511e-16,  7.678385860965928e-02, -4.691122892477133e-03,  2.070785473077664e-04, -7.845028857548377e-06,
  2.580976236648287e-07, -7.165597234384647e-09,  1.843375933373785e-10, -2.633995500259131e-12, -1.112791153069059e-13,  7.440863942197893e-15, -2.439621782753099e-16,
  7.105481860624101e-18,  6.645945998158673e-01, -3.169372339818859e-02,  6.653551350682340e-04,  8.255267928998306e-06, -1.086303775802486e-06,  2.393542021137020e-08,
  1.258047828013299e-09, -7.789309542635687e-11, -1.424558624096968e-13,  1.268355266557106e-13, -3.664087680037891e-15, -9.958024275313273e-17,  1.600915088530914e+00,
 -2.853988432936267e-02, -1.053412244998323e-03, -6.972346630218242e-06,  1.540317886701035e-06,  7.830738234338355e-08, -2.166827257613903e-11, -1.714248112224634e-10,
 -6.941632831855324e-12,  9.221674388075518e-14,  1.908818455561231e-14,  5.861039603905304e-16,  6.082294258434925e-02, -3.350327948175902e-03,  1.336847691094785e-04,
 -4.651283448873308e-06,  1.518223086348844e-07, -3.835218509321935e-09,  9.068355722351428e-11, -3.268645251511763e-12,  4.295766079888408e-14,  2.463421457612769e-15,
 -4.454534961265700e-17,  1.394474102200978e-18,  5.487326886556423e-01, -2.622662808542747e-02,  6.792925451162093e-04, -4.362848838027239e-06, -4.710294425722525e-07,
  3.057943170555136e-08, -5.145331369540422e-10, -3.894095954983057e-11,  1.786139066601996e-12, -1.005917212601054e-15, -1.355667396509577e-15,  8.874105837278536e-17,
  1.470107538504268e+00, -3.677366666388984e-02, -9.429617337023028e-04,  2.818770464920023e-05,  2.617487594735216e-06,  4.143130827958736e-09, -6.237218752626730e-09,
 -1.745445043064081e-10,  1.109283338520693e-11,  7.364594664808635e-13, -8.514005911454161e-15, -2.108755199097332e-15,  4.925850031016817e-02, -2.468016838116199e-03,
  9.021987370123781e-05, -2.744899349741119e-06,  9.057586100850896e-08, -2.531913466572197e-09,  2.924430181944133e-11, -8.470665163622666e-13,  9.239564241440637e-14,
 -3.728136168694968e-16, -1.312074171446097e-16, -2.470123960891144e-18,  4.542365017014143e-01, -2.108908095969949e-02,  5.989891988384770e-04, -7.935048143505549e-06,
 -3.892337795943201e-08,  1.133116594229199e-08, -8.553907980947641e-10,  1.175986670175224e-11,  1.250032630079480e-12, -2.758384966551179e-14, -1.003480812126877e-15,
 -3.463858075429665e-17,  1.311009110780611e+00, -4.230333710996970e-02, -3.792749324565408e-04,  6.191193805780946e-05,  1.095799191401953e-06, -1.463720171213922e-07,
 -3.654185971438748e-09,  3.698923918854573e-10,  1.219292596749420e-11, -9.298523818751762e-13, -3.958968590830541e-14,  2.280627887540643e-15,  4.065133612960935e-02,
 -1.856994452360747e-03,  6.442016661245572e-05, -1.665241400154603e-06,  4.657140289579688e-08, -1.830565416012013e-09,  3.750191941576893e-11,  8.887744102591115e-13,
 -7.422498281641029e-15, -3.947536016283411e-15,  4.600529691509403e-17,  8.662644996886543e-18,  3.788605860631464e-01, -1.667782435194652e-02,  5.043672860294047e-04,
 -7.681768499946465e-06,  2.742140851814756e-08, -1.951573477647749e-09, -1.758870927085431e-10,  2.768796798580436e-11, -4.273675280257750e-13, -5.158244083277977e-14,
  1.028451730386052e-15,  1.066569951406803e-16,  1.140544440604072e+00, -4.230202260924064e-02,  3.673627690667236e-04,  5.511825824676487e-05, -1.793717941559455e-06,
 -1.015500327784187e-07,  6.369812710626452e-09,  1.643879752540310e-10, -1.976387296179212e-11, -1.386776297628059e-13,  5.580004366054972e-14, -4.566266082493522e-16,
  3.414218073811033e-02, -1.411327083890502e-03,  4.787714227432957e-05, -1.157537650631941e-06,  2.037777830571514e-08, -7.618687587615388e-10,  4.370615381465990e-11,
 -7.060337855460291e-13, -5.512200955688924e-14,  1.799586534846847e-15,  1.176603056289014e-16, -6.379428376966874e-18,  3.196414794642862e-01, -1.300747662323446e-02,
  4.134014143736405e-04, -7.566511531075680e-06, -4.653985699787861e-09,  3.353378928504998e-10,  2.259349433777025e-10, -1.309693512082061e-12, -8.607521933220727e-13,
  2.980548172919809e-14,  1.361880216656026e-15, -9.531765612443276e-17,  9.805823215468077e-01, -3.730297250553267e-02,  8.177887916941964e-04,  1.882868204138096e-05,
 -2.264240819264753e-06,  4.319352666603143e-08,  3.773738213428660e-09, -2.400881859207860e-10, -9.342414698925001e-13,  6.296610021272541e-13, -1.904410647313418e-14,
 -9.327865383073545e-16,  2.918164438890982e-02, -1.079161369361728e-03,  3.559983965129775e-05, -9.057362721811663e-07,  1.332410385982508e-08, -7.157974058024067e-11,
  1.209936485301817e-11, -1.097037667548430e-12,  2.603626680238609e-14,  1.247039753105821e-15, -9.007157738272192e-17,  4.827921122487527e-22,  2.736519501122312e-01,
 -1.006253831506654e-02,  3.231953678761197e-04, -7.346406164477725e-06,  4.213915455478476e-08,  3.369929239650835e-09, -6.851247285867609e-12, -9.051955195167803e-12,
  2.663251986507606e-13,  1.490169251478831e-14, -1.211985942662492e-15,  9.697722106139537e-18,  8.451301453263288e-01, -3.038597868105295e-02,  8.648872290641326e-04,
 -7.705354770388170e-06, -9.900873166772018e-07,  6.451044358161738e-08, -1.187363477649519e-09, -7.830288262893643e-11,  6.289023007060070e-12, -1.279340355772744e-13,
 -7.597765692915887e-15,  6.280271181049650e-16,  2.537080882961850e-02, -8.342639643798327e-04,  2.599022072461865e-05, -6.966725720879743e-07,  1.288723984701125e-08,
 -3.672014093089365e-11, -4.569580895316125e-12, -1.269011475913628e-13,  2.201029924453773e-14, -8.373284177878696e-16, -4.005080782579259e-18,  1.712462394083158e-18,
  2.380370348128030e-01, -7.813421326883955e-03,  2.410931773133793e-04, -6.207367218752074e-06,  9.336906999001430e-08,  1.334359247427077e-09, -1.157600405660788e-10,
  7.569705261804282e-13,  2.003101233470217e-13, -9.712719978403031e-15,  1.049344759993195e-17,  1.915458451516486e-17,  7.365724329001125e-01, -2.402031152791995e-02,
  7.137408970912814e-04, -1.517578170481498e-05, -6.699310694884965e-08,  2.718842427880015e-08, -1.424820678595908e-09,  3.134579453484821e-11,  8.397732595443364e-13,
 -1.015613702499748e-13,  3.888860609619490e-15, -2.315319035833839e-17,  2.240147392770786e-02, -6.563730726706544e-04,  1.882317637441723e-05, -5.024320404147865e-07,
  1.106634376256792e-08, -1.357205326236465e-10, -2.417019285422087e-12,  1.601611777331631e-13, -4.999272085929597e-16, -2.954392011601536e-16,  1.604266556596163e-17,
 -3.126207128215551e-19,  2.102064635005432e-01, -6.156110552600271e-03,  1.760024543518637e-04, -4.634549164499184e-06,  9.646785574727580e-08, -7.572453320486394e-10,
 -5.058640819924607e-11,  2.640737540975223e-12, -3.589770187434242e-14, -2.522469504954266e-15,  1.769432910146680e-16, -4.431839578605904e-18,  6.507731659081649e-01,
 -1.902620543876090e-02,  5.379983398387596e-04, -1.343597108424434e-05,  2.108440755976962e-07,  4.149417009531334e-09, -5.327009663754385e-10,  2.497904680914013e-11,
 -6.399179802657013e-13, -1.172323422816213e-15,  1.012210748622635e-15, -5.364361545889675e-17,  2.004292801865518e-02, -5.271140086747597e-04,  1.376046571345407e-05,
 -3.488336251226983e-07,  8.097796692880571e-09, -1.478624074061112e-10,  9.540024525767677e-13,  6.785310865648943e-14, -3.259247874983986e-15,  4.832929731951349e-17,
  2.355894770696846e-18, -1.886627098671161e-19,  1.880809590872855e-01, -4.945776751658568e-03,  1.289968655424677e-04, -3.256054877882421e-06,  7.429115716461166e-08,
 -1.258560437462034e-09,  1.113775790303898e-12,  1.021403215496323e-12, -4.559554396291369e-14,  8.882549998187829e-16,  1.531276432058358e-17, -1.913181649512549e-18,
  5.823400218939185e-01, -1.530698560765435e-02,  3.980487311987819e-04, -9.895550570006670e-06,  2.112240521861095e-07, -2.409010831082303e-09, -9.172284667652862e-11,
  8.151626578365549e-12, -3.543390852061441e-13,  9.872240175851463e-15, -1.102653020082936e-16, -5.976755304754336e-18,  1.813095448204016e-02, -4.317859351212328e-04,
  1.025959865426709e-05, -2.412245265320703e-07,  5.470648836716594e-09, -1.120079624133604e-10,  1.714385052721620e-12, -1.978005035566574e-15, -1.133740124347932e-15,
  4.866810894862286e-17, -1.015409726409804e-18, -5.744290307097071e-21,  1.701404054215444e-01, -4.051751243812594e-03,  9.625050176639033e-05, -2.260161682385776e-06,
  5.098235342513495e-08, -1.022795720166412e-09,  1.424955690148746e-11,  8.054663251575497e-14, -1.510369658132694e-14,  6.233988935911769e-16, -1.449724607320026e-17,
  4.970602516972892e-20,  5.268044749994786e-01, -1.254426284525174e-02,  2.977672485855698e-04, -6.962619205293726e-06,  1.541541861066271e-07, -2.862038466421260e-09,
  2.356838688021449e-11,  1.409130576284075e-12, -1.021559564977648e-13,  4.169213164601209e-15, -1.200974778922183e-16,  2.124713591322806e-18,  1.655152542115175e-02,
 -3.599559639205887e-04,  7.823213642607360e-06, -1.694544508497924e-07,  3.622127083921153e-09, -7.428417032405591e-11,  1.359936370561411e-12, -1.774232188779615e-14,
 -5.820579382751772e-17,  1.432165196063114e-17, -5.762843198459846e-19,  1.381651581556023e-20,  1.553193166370048e-01, -3.377801094041326e-03,  7.340824593644295e-05,
 -1.589497603418409e-06,  3.392093945828831e-08, -6.913763516999211e-10,  1.237486055839134e-11, -1.444701951989962e-13, -1.614768983865957e-15,  1.788479271737474e-16,
 -6.988237228320227e-18,  1.767154497218514e-19,  4.809163070010736e-01, -1.045850638466027e-02,  2.272491701695362e-04, -4.915089889787175e-06,  1.043388754956460e-07,
 -2.082323177655473e-09,  3.424987096725299e-11, -2.081482985812871e-13, -1.707463263835472e-14,  1.081994795555986e-15, -4.171095830946592e-17,  1.204509007644202e-18,
  1.522524996922987e-02, -3.046210773450881e-04,  6.093741199212472e-06, -1.217804643823960e-07,  2.423031232818318e-09, -4.747323765006980e-11,  8.890980162207146e-13,
 -1.475071569995172e-14,  1.679904958724328e-16,  1.076462083448617e-18, -1.477258800392228e-19,  5.659495546403200e-21,  1.428736059828216e-01, -2.858557608798760e-03,
  5.718277031227487e-05, -1.142666392851064e-06,  2.272486681810340e-08, -4.444019279204599e-10,  8.267462565584346e-12, -1.339463834262911e-13,  1.349360982414374e-15,
  2.012176846090968e-17, -1.772953348238404e-18,  6.614150238795539e-20,  4.423809641860729e-01, -8.850945174343414e-03,  1.770476852804819e-04, -3.536904322442654e-06,
  7.023922223025550e-08, -1.365321382012701e-09,  2.483750840839450e-11, -3.687393160119376e-13,  1.776242315821234e-15,  1.720103088056606e-16, -9.908797842722837e-18,
  3.621957767256742e-19,  1.409585420328971e-02, -2.611228246242898e-04,  4.837052800723085e-06, -8.957765653591455e-08,  1.656671221614939e-09, -3.047857608929370e-11,
  5.513288204407602e-13, -9.513177802484219e-15,  1.448813505980850e-16, -1.483500997132423e-18, -1.174443490917588e-20,  1.292816796779345e-21,  1.322753739505338e-01,
 -2.450373674946227e-03,  4.539071524577990e-05, -8.405747226862412e-07,  1.554388802450046e-08, -2.858123637640365e-10,  5.159523887329004e-12, -8.841578227516511e-14,
  1.314792506086520e-15, -1.186975495822867e-17, -1.932543352479372e-19,  1.511435881876611e-20,  4.095656220756485e-01, -7.587111668196440e-03,  1.405424024180704e-04,
 -2.602483312007820e-06,  4.810709053578032e-08, -8.830738760007846e-10,  1.583855025025195e-11, -2.653214098244203e-13,  3.619865009405695e-15, -1.555802240797806e-17,
 -1.482434941001726e-18,  7.973126519306541e-20,  1.312252830887212e-02, -2.263175853320337e-04,  3.903148135352380e-06, -6.731034261952978e-08,  1.160336103368872e-09,
 -1.996967608909386e-11,  3.416737453801844e-13, -5.743016528662668e-15,  9.202559149722896e-17, -1.301867834986033e-18,  1.236632547128301e-20,  9.640034694216289e-23,
  1.231416934596270e-01, -2.123762175514081e-03,  3.662708383277695e-05, -6.316360293903536e-07,  1.088818350558288e-08, -1.873602298203484e-10,  3.203723467415939e-12,
 -5.373574017182342e-14,  8.551862125882390e-16, -1.182246143821924e-17,  9.956877396570390e-20,  1.520202538627430e-21,  3.812849233920620e-01, -6.575826223252370e-03,
  1.134086015387815e-04, -1.955708122790680e-06,  3.370951912265165e-08, -5.797999520157600e-10,  9.895819258551323e-12, -1.648864068849519e-13,  2.566551034115191e-15,
 -3.270467915305797e-17,  1.416017668355674e-19,  1.109933501869178e-20,  1.227500164368785e-02, -1.980353934674192e-04,  3.194943416989113e-06, -5.154377756039874e-08,
  8.314678613200311e-10, -1.340620257681098e-11,  2.157484225605843e-13, -3.450454149552729e-15,  5.419744896851479e-17, -8.121426655365925e-19,  1.078457753444313e-20,
 -9.783293361636663e-23,  1.151885106960961e-01, -1.858362424388379e-03,  2.998131761229126e-05, -4.836857543630298e-07,  7.802419174957442e-09, -1.257976594284665e-10,
  2.024138344662568e-12, -3.235129455156048e-14,  5.070791089914996e-16, -7.548730830710076e-18,  9.810577836388615e-20, -7.991663047955070e-22,  3.566594017008100e-01,
 -5.754067032079066e-03,  9.283143342602442e-05, -1.497635819672978e-06,  2.415809898711651e-08, -3.894537609754603e-10,  6.263288012665798e-12, -9.991159645093752e-14,
  1.555844795795251e-15, -2.268022527462463e-17,  2.736193129094218e-19, -1.294021150960391e-21,  1.153035637438071e-02, -1.747424876828457e-04,  2.648220263873099e-06,
 -4.013358913403929e-08,  6.082061607568223e-10, -9.215865948322880e-12,  1.395647539298206e-13, -2.109240359286699e-15,  3.167320253019789e-17, -4.672354512807291e-19,
  6.587251579872766e-21, -8.283828289779426e-23,  1.082007658779819e-01, -1.639782011095222e-03,  2.485087568838518e-05, -3.766131565062759e-07,  5.707390055617334e-09,
 -8.648059130513022e-11,  1.309599009777313e-12, -1.978831215017931e-14,  2.969573463140169e-16, -4.371686019549768e-18,  6.125556013742635e-20, -7.554453201723020e-22,
  3.350231739662336e-01, -5.077274330741635e-03,  7.694602285535005e-05, -1.166110399196452e-06,  1.767175131654445e-08, -2.677616870631368e-10,  4.054244904035420e-12,
 -6.122721909114876e-14,  9.170443555307533e-16, -1.341637691680333e-17,  1.843842838033301e-19, -2.128936885710638e-21,  1.087092425475955e-02, -1.553306234612250e-04,
  2.219461729533666e-06, -3.171303862515571e-08,  4.531326677894971e-10, -6.474375268646985e-12,  9.249128503177438e-14, -1.320476473743899e-15,  1.881191396116378e-17,
 -2.662947504323649e-19,  3.705511730868617e-21, -4.940084398220824e-23,  1.020126604974225e-01, -1.457621245389856e-03,  2.082740983158358e-05, -2.975948674425074e-07,
  4.252191223735118e-09, -6.075531412847221e-11,  8.679248295967479e-13, -1.239053349334292e-14,  1.764858658558783e-16, -2.496689488180472e-18,  3.467460245257749e-20,
 -4.596810524287867e-22,  3.158628779819533e-01, -4.513248050869039e-03,  6.448812805199559e-05, -9.214459869065880e-07,  1.316608827510607e-08, -1.881158402704457e-10,
  2.687253047218833e-12, -3.835772633086419e-14,  5.460491007533500e-16, -7.710302090343450e-18,  1.064608726038278e-19, -1.386949199764925e-21,  1.028286490240524e-02,
 -1.389830186636334e-04,  1.878491966728002e-06, -2.538965863251509e-08,  3.431656091317053e-10, -4.638172524054392e-12,  6.268611144294592e-14, -8.470646734100848e-16,
  1.143856298988375e-17, -1.541310416996529e-19,  2.064026625050611e-21, -2.719199844092858e-23,  9.649431655095041e-02, -1.304215461802678e-03,  1.762775257816709e-05,
 -2.382563374181905e-07,  3.220262847401593e-09, -4.352454399477284e-11,  5.882438653697578e-13, -7.948714084367729e-15,  1.073318592212244e-16, -1.445989794421095e-18,
  1.935209073508742e-20, -2.544957056763418e-22,  2.987763713532266e-01, -4.038256106735046e-03,  5.458099631266476e-05, -7.377155907457916e-07,  9.970931252111105e-09,
 -1.347652669830416e-10,  1.821367589039792e-12, -2.461051061498374e-14,  3.322660267958509e-16, -4.473879925936085e-18,  5.976902231714965e-20, -7.818470641674149e-22,
  9.755182189377905e-03, -1.250870016695391e-04,  1.603943178590175e-06, -2.056675420211433e-08,  2.637195926695143e-10, -3.381568050462111e-12,  4.335997778276238e-14,
 -5.559530584994355e-16,  7.126909118883531e-18, -9.129908245932638e-20,  1.167109452790933e-21, -1.482956501867886e-23,  9.154254647217884e-02, -1.173815356903264e-03,
  1.505138910654497e-05, -1.929982456140409e-07,  2.474742360263096e-09, -3.173260133561584e-11,  4.068893264879688e-13, -5.217036968313086e-15,  6.687761842239480e-17,
 -8.566877067837414e-19,  1.094934750791430e-20, -1.390465914251635e-22,  2.834441533670327e-01, -3.634496885428271e-03,  4.660377501551659e-05, -5.975825024286617e-07,
  7.662570491350334e-09, -9.825395072311924e-11,  1.259852821846951e-12, -1.615337720930110e-14,  2.070630591480027e-16, -2.652023726822615e-18,  3.387772384533598e-20,
 -4.295105713171030e-22,  9.279029124691364e-03, -1.131757258706037e-04,  1.380397102433970e-06, -1.683661518468057e-08,  2.053551042345668e-10, -2.504701686032973e-12,
  3.054958546175856e-14, -3.726051601748764e-16,  4.544312214402483e-18, -5.541120858700860e-20,  6.751964967131835e-22, -8.209488416030756e-24,  8.707433017385394e-02,
 -1.062040046396848e-03,  1.295363463667307e-05, -1.579946532423959e-07,  1.927050539204782e-09, -2.350409855952401e-11,  2.866769957998802e-13, -3.496520137122792e-15,
  4.264358675321894e-17, -5.199681707941251e-19,  6.335577869623656e-21, -7.701886431756796e-23,  2.696091680566103e-01, -3.288405811204912e-03,  4.010847571734804e-05,
 -4.892005127577809e-07,  5.966746870199316e-09, -7.277598261196303e-11,  8.876405509340984e-13, -1.082628207161009e-14,  1.320360563530476e-16, -1.609894749291407e-18,
  1.961288551797664e-20, -2.383075467942810e-22,  8.847207134923256e-03, -1.028884148090005e-04,  1.196538719962239e-06, -1.391512259818492e-08,  1.618256315319453e-10,
 -1.881947642053627e-12,  2.188605454843811e-14, -2.545223658265961e-16,  2.959905695942522e-18, -3.441945308110469e-20,  4.001649813667121e-22, -4.648654952114952e-24,
  8.302211630448372e-02, -9.655040071273627e-04,  1.122830914388688e-05, -1.305793917817527e-07,  1.518570345035401e-09, -1.766018051306062e-11,  2.053785407434114e-13,
 -2.388435151894312e-15,  2.777569774011870e-17, -3.229902210626762e-19,  3.755070123852248e-21, -4.361985010157152e-23,  2.570622554599318e-01, -2.989500253369894e-03,
  3.476633217703100e-05, -4.043143496566721e-07,  4.701965385965975e-09, -5.468140248877737e-11,  6.359156726580927e-13, -7.395332232029048e-15,  8.600191198322968e-17,
 -1.000063989442148e-18,  1.162621761639961e-20, -1.350337217994376e-22,  8.453799135283588e-03, -9.394270079950564e-05,  1.043936683620292e-06, -1.160072884617891e-08,
  1.289129038696225e-10, -1.432542438145634e-12,  1.591910089806620e-14, -1.769005625392690e-16,  1.965794829548121e-18, -2.184439600101588e-20,  2.427254280230841e-22,
 -2.696170491416414e-24,  7.933037899087814e-02, -8.815575031522287e-04,  9.796292936313199e-06, -1.088611405590564e-07,  1.209717590347232e-09, -1.344296600546158e-11,
  1.493847057359764e-13, -1.660033282241385e-15,  1.844699683678615e-17, -2.049873657145945e-19,  2.277721389718699e-21, -2.530034311792448e-23,  2.456314902296145e-01,
 -2.729575806605552e-03,  3.033236527134498e-05, -3.370678991162719e-07,  3.745661348533518e-09, -4.162359746129678e-11,  4.625414307443632e-13, -5.139977840236216e-15,
  5.711758808567323e-17, -6.347023314989388e-19,  7.052430491269006e-21, -7.833343718962531e-23,  8.093896455647854e-03, -8.611502847525176e-05,  9.162210277701158e-07,
 -9.748135564007849e-09,  1.037153088976643e-10, -1.103479242135311e-12,  1.174046925901562e-14, -1.249127177988147e-16,  1.329007497691452e-18, -1.413989918454924e-20,
  1.504380581253390e-22, -1.600270405382450e-24,  7.595305531445312e-02, -8.081026928164370e-04,  8.597810310992607e-06, -9.147642099958168e-08,  9.732635741750725e-10,
 -1.035503979496935e-11,  1.101724631957726e-13, -1.172179864811673e-15,  1.247139422749636e-17, -1.326886523612556e-19,  1.411707559863775e-21, -1.501684453018825e-23,
  2.351742472644275e-01, -2.502136901651335e-03,  2.662149086218850e-05, -2.832394083661190e-07,  3.013526282527936e-09, -3.206241904825225e-11,  3.411281595305026e-13,
 -3.629432779081660e-15,  3.861530295490593e-17, -4.108449296738305e-19,  4.371068970015712e-21, -4.649613897612815e-23,  7.763392753685055e-03, -7.922654359180981e-05,
  8.085183126307958e-07, -8.251046078944086e-09,  8.420311615041329e-11, -8.593049528444304e-13,  8.769330995345493e-15, -8.949228364803209e-17,  9.132814018367241e-19,
 -9.320155347315375e-21,  9.511295233701143e-23, -9.705174809654708e-25,  7.285161139379419e-02, -7.434612094157312e-04,  7.587128950623300e-06, -7.742774603924342e-08,
  7.901613238606722e-10, -8.063710348864302e-12,  8.229132724281865e-14, -8.397948244255870e-16,  8.570224762293224e-18, -8.746025188952110e-20,  8.925388362152396e-22,
 -9.107315257060174e-24,  2.255712137004177e-01, -2.301986793958163e-03,  2.349210749289363e-05, -2.397403477286012e-07,  2.446584851449371e-09, -2.496775150575923e-11,
  2.547995053059534e-13, -2.600265565734439e-15,  2.653607640259075e-17, -2.708040479248014e-19,  2.763574925336406e-21, -2.819897085905301e-23,  7.458826493468283e-03,
 -7.313277990621989e-05,  7.170569661989585e-07, -7.030646085553296e-09,  6.893452920636442e-11, -6.758936885774323e-13,  6.627045731190533e-15, -6.497728179736485e-17,
  6.370933715835227e-19, -6.246611734932345e-21,  6.124708245695142e-23, -6.004577644484985e-25,  6.999356420528355e-02, -6.862773829582228e-04,  6.728856455696260e-06,
 -6.597552290895765e-08,  6.468810341930976e-10, -6.342580609476400e-12,  6.218814062064803e-14, -6.097462579274810e-16,  5.978478746606740e-18, -5.861815025579725e-20,
  5.747420531684447e-22, -5.634688585775695e-24,  2.167218120085242e-01, -2.124927908213976e-03,  2.083462930315595e-05, -2.042807083105589e-07,  2.002944577485996e-09,
 -1.963859932076351e-11,  1.925537964946685e-13, -1.887963774875760e-15,  1.851122671961863e-17, -1.814999894152752e-19,  1.779579502736754e-21, -1.744672940699040e-23,
  7.177259139737710e-03, -6.771601912238282e-05,  6.388872348770125e-07, -6.027774582420871e-09,  5.687085988390071e-11, -5.365653044195334e-13,  5.062387422919588e-15,
 -4.776262302062050e-17,  4.506308855975164e-19, -4.251612840479548e-21,  4.011310938515497e-23, -3.784249267344944e-25,  6.735133855910302e-02, -6.354465459572316e-04,
  5.995312363608389e-06, -5.656458527613007e-08,  5.336756641515318e-10, -5.035124240794812e-12,  4.750540040351537e-14, -4.482040470521754e-16,  4.228716384495011e-18,
 -3.989709848409200e-20,  3.764210692317330e-22, -3.551135982064945e-24,  2.085406608373082e-01, -1.967539850814078e-03,  1.856334898430897e-05, -1.751415227348536e-07,
  1.652425594737519e-09, -1.559030835959709e-11,  1.470914729390863e-13, -1.387778923688031e-15,  1.309341917404506e-17, -1.235338061032296e-19,  1.165516472592288e-21,
 -1.099541732307803e-23,  6.916179962679287e-03, -6.287956038451430e-05,  5.716796172866020e-07, -5.197517012243905e-09,  4.725406027375783e-11, -4.296178746651128e-13,
  3.905939873720672e-15, -3.551147936157957e-17,  3.228583141169236e-19, -2.935318133799874e-21,  2.668691327290283e-23, -2.426081987981209e-25,  6.490137378808927e-02,
 -5.900612584067504e-04,  5.364636653291505e-06, -4.877345531808800e-08,  4.434316986228146e-10, -4.031530472043029e-12,  3.665330646473777e-14, -3.332394194769194e-16,
  3.029699665865537e-18, -2.754500031158007e-20,  2.504297654675936e-22, -2.276633221859562e-24,  2.009548090442219e-01, -1.827012905684947e-03,  1.661058112227005e-05,
 -1.510177647683619e-07,  1.373002251259711e-09, -1.248287037513042e-11,  1.134900198792480e-13, -1.031812733604133e-15,  9.380891066578112e-18, -8.528787515889796e-20,
  7.754083184222552e-22, -7.049163101558347e-24,  6.673430908064210e-03, -5.854337268370417e-05,  5.135778780659102e-07, -4.505415809637814e-09,  3.952423280802952e-11,
 -3.467304783986555e-13,  3.041729493718839e-15, -2.668389105772009e-17,  2.340872332592150e-19, -2.053554800306146e-21,  1.801502438353891e-23, -1.580265128774002e-25,
  6.262341872976325e-02, -5.493705100016770e-04,  4.819410427940453e-06, -4.227878353512268e-08,  3.708950636049724e-10, -3.253715852349656e-12,  2.854356362894685e-14,
 -2.504014061222994e-16,  2.196672600523303e-18, -1.927054072964895e-20,  1.690528350142935e-22, -1.482919442037814e-24,  1.939015527410212e-01, -1.701021711687931e-03,
  1.492239140291114e-05, -1.309082439404661e-07,  1.148406302238535e-09, -1.007451475415399e-11,  8.837973749548383e-14, -7.753205181049319e-16,  6.801580570177868e-18,
 -5.966757873670414e-20,  5.234400769495562e-22, -4.591579069976049e-24,  6.447146765228237e-03, -5.464076148974432e-05,  4.630905615925483e-07, -3.924778176386735e-09,
  3.326322108761579e-11, -2.819119520639651e-13,  2.389255944484274e-15, -2.024938611624406e-17,  1.716172932297745e-19, -1.454488306054674e-21,  1.232705732922620e-23,
 -1.044665848368465e-25,  6.049997026315835e-02, -5.127484398393141e-04,  4.345637880713987e-06, -3.683008493641517e-08,  3.121417830149818e-10, -2.645459354002283e-12,
  2.242075740728683e-14, -1.900200666264013e-16,  1.610455216093004e-18, -1.364890585949529e-20,  1.156770008260142e-22, -9.803135401238533e-25,  1.873266968294173e-01,
 -1.587628409100670e-03,  1.345544446170846e-05, -1.140373809288772e-07,  9.664878990898960e-10, -8.191163734893468e-12,  6.942162793222204e-14, -5.883611389809358e-16,
  4.986469492549302e-18, -4.226125134622493e-20,  3.581719190456942e-22, -3.035355157914923e-24,  6.235707117621439e-03, -5.111578793150270e-05,  4.190100218906686e-07,
 -3.434739158869836e-09,  2.815549145159129e-11, -2.307982243232173e-13,  1.891915843213186e-15, -1.550854894261304e-17,  1.271277954359320e-19, -1.042101129460651e-21,
  8.542386456915924e-24, -7.001956069220691e-26,  5.851582241318907e-02, -4.796701180300093e-04,  3.931986472073643e-06, -3.223156297512550e-08,  2.642108916696236e-10,
 -2.165808568784776e-12,  1.775372213831422e-14, -1.455320910194048e-16,  1.192966148214023e-18, -9.779068111662378e-21,  8.016168165776472e-23, -6.570629602393065e-25,
  1.811831588881719e-01, -1.485207651962366e-03,  1.217465123681298e-05, -9.979892881792644e-08,  8.180789740481070e-10, -6.706015943322839e-12,  5.497103734318260e-14,
 -4.506125502995798e-16,  3.693793682896721e-18, -3.027903186430967e-20,  2.482054614249229e-22, -2.034470981298136e-24,  6.037697454593722e-03, -4.792125242819910e-05,
  3.803513593646448e-07, -3.018851746149361e-09,  2.396065017475568e-11, -1.901758698582371e-13,  1.509427382502226e-15, -1.198033706770366e-17,  9.508803001634433e-20,
 -7.547144459228170e-22,  5.990174498272633e-24, -4.754106737858235e-26,  5.665770142397799e-02, -4.496926241102429e-04,  3.569213912613363e-06, -2.832887904087512e-08,
  2.248465369017143e-10, -1.784608740915842e-12,  1.416445368489272e-14, -1.124233808741286e-16,  8.923052627554069e-19, -7.082233924267074e-21,  5.621174640656443e-23,
 -4.461249708221315e-25,  1.754298392467855e-01, -1.392388020964408e-03,  1.105139472993450e-05, -8.771500733842200e-08,  6.961947066770838e-10, -5.525702890671431e-12,
  4.385754752676263e-14, -3.480977014358734e-16,  2.762854208163995e-18, -2.192879569079999e-20,  1.740490240122605e-22, -1.381341458212410e-24  };
  constexpr double w[1152] = {  8.415079282350717e-01, -4.434506447476264e-02,  2.651658347560889e-03, -1.543373592882430e-04,  8.451059587317178e-06,
 -4.368360283177318e-07,  2.134392984422344e-08, -9.881021190964115e-10,  4.393508610769244e-11, -1.880346639941242e-12,  7.723123299114189e-14, -3.053092913667579e-15,
  5.148136078628335e-01, -9.048699873900845e-02,  1.160437656742711e-02, -1.159187110487530e-03,  9.674918630166984e-05, -6.984743592730345e-06,  4.458391608886033e-07,
 -2.553804413998085e-08,  1.326749937060782e-09, -6.306859122288812e-11,  2.763989509867213e-12, -1.122506522392878e-13,  1.890404551225362e-01, -6.318988211997251e-02,
  1.186644892280093e-02, -1.571325501198024e-03,  1.618674307556466e-04, -1.369143670139385e-05,  9.842277173466134e-07, -6.158685780310135e-08,  3.413972740788835e-09,
 -1.699219151039722e-10,  7.674244508088654e-12, -3.167379984161416e-13,  6.973763586943796e-01, -2.876182007604963e-02,  1.392529160926526e-03, -6.836366919322103e-05,
  3.212427522526032e-06, -1.440172983683670e-07,  6.285461727488029e-09, -2.583985974946041e-10,  1.011407378726980e-11, -3.919551260462748e-13,  1.463658873959527e-14,
 -5.240229130135767e-16,  2.772075586934579e-01, -3.474804015028797e-02,  3.752375085183516e-03, -3.251065633444694e-04,  2.419114153490832e-05, -1.589360607306253e-06,
  9.372027040617592e-08, -5.031955212143370e-09,  2.478480256961146e-10, -1.125610396708217e-11,  4.744116463832913e-13, -1.862079438595962e-14,  4.923644189363124e-02,
 -1.433532865519346e-02,  2.479218118450741e-03, -3.087694131870350e-04,  3.037158395300224e-05, -2.477832055330947e-06,  1.730228738774341e-07, -1.057262287387672e-08,
  5.746386208633635e-10, -2.813460059319206e-11,  1.253483616596528e-12, -5.116764588495216e-14,  6.004136738521355e-01, -2.020493812295375e-02,  8.066207768968758e-04,
 -3.374790652505388e-05,  1.400030281800079e-06, -5.329877205660762e-08,  2.064872001113712e-09, -8.071789610524629e-11,  2.716141825535060e-12, -9.018692010757815e-14,
  3.381331475318328e-15, -1.038899049668021e-16,  1.804219978930857e-01, -1.556177908237560e-02,  1.419905778855228e-03, -1.056807310789025e-04,  6.901527024837554e-06,
 -4.092269248059647e-07,  2.199208993897381e-08, -1.087152107109985e-09,  5.027288594121338e-11, -2.163938263673993e-12,  8.666603366561959e-14, -3.273973188977673e-15,
  1.617223796000977e-02, -3.742975852519346e-03,  5.794733798314905e-04, -6.621197897903900e-05,  6.108926033647264e-06, -4.747506158537105e-07,  3.188561532492830e-08,
 -1.888103123267573e-09,  1.000288624253076e-10, -4.792681521214046e-12,  2.096557828030065e-13, -8.429599215942697e-15,  5.303839240031645e-01, -1.505779074448281e-02,
  5.078511386646643e-04, -1.780513186260144e-05,  6.873762872666780e-07, -2.329399701576161e-08,  6.770313418477926e-10, -2.679008021488063e-11,  1.059914342256483e-12,
 -2.046552270032496e-14,  4.878252594342523e-16, -4.478039075050486e-17,  1.348765310378242e-01, -7.874411114747567e-03,  6.150580973122596e-04, -3.986634222358476e-05,
  2.232449876865442e-06, -1.184859319070140e-07,  5.882387347975931e-09, -2.623077417347087e-10,  1.100118520114651e-11, -4.552717469947319e-13,  1.742645904223693e-14,
 -5.962576261836616e-16,  7.090497733974742e-03, -1.143709552038438e-03,  1.557575370104383e-04, -1.590689969356315e-05,  1.341513161740016e-06, -9.780641701825821e-08,
  6.248001627360166e-09, -3.543578601147968e-10,  1.815229737243171e-11, -8.476729125388829e-13,  3.618114462700311e-14, -1.423299624113791e-15,  4.771484423951325e-01,
 -1.169334689435858e-02,  3.471149563765959e-04, -9.845431384625756e-06,  3.403750668234286e-07, -1.283835175068332e-08,  3.002317678525713e-10, -3.757350415595333e-12,
  3.571521594791218e-13, -2.204431140360738e-14, -1.777530264363203e-17,  2.526361231656683e-17,  1.108602611948097e-01, -4.400610928754420e-03,  2.921795250196819e-04,
 -1.737078343886608e-05,  8.350960806139883e-07, -3.701345544888327e-08,  1.730617607513067e-09, -7.625074856831047e-11,  2.723649268170908e-12, -9.068011704091017e-14,
  3.840893528393688e-15, -1.531534733922799e-16,  4.168775131485242e-03, -4.049829603743002e-04,  4.849691237757154e-05, -4.419534757434966e-06,  3.293285086643206e-07,
 -2.187074124709401e-08,  1.322433656571142e-09, -7.143908214475171e-11,  3.457069916720463e-12, -1.552521373001138e-13,  6.567375221826170e-15, -2.521936769760986e-16,
  4.352886803502662e-01, -9.313511352543989e-03,  2.543791574139406e-04, -6.083563012217930e-06,  1.508802584939403e-07, -6.282042166495540e-09,  2.486954536642357e-10,
 -2.790079690358608e-12, -1.675642288188981e-13, -1.639542661569474e-15,  7.130280194957681e-16, -1.320434114516685e-17,  9.687381628952961e-02, -2.714417755726731e-03,
  1.451561120649424e-04, -8.253864076184751e-06,  3.782939936776689e-07, -1.348264999390388e-08,  4.733828996597244e-10, -2.216628620534213e-11,  1.006244533462679e-12,
 -2.782136976163037e-14,  3.152091315004422e-16, -1.587968453945118e-17,  3.082408561694771e-03, -1.642560377904722e-04,  1.679729659343711e-05, -1.432195289190007e-06,
  9.515835948001269e-08, -5.414865048304400e-09,  2.949224810055896e-10, -1.561782265858999e-11,  7.419751300551725e-13, -3.012030121060999e-14,  1.130165691867486e-15,
 -4.564171723536849e-17,  4.016901430658863e-01, -7.537064976303092e-03,  1.926681934608472e-04, -4.386862780225473e-06,  7.581703807174203e-08, -1.757382805244664e-09,
  1.155594948991202e-10, -5.431108810282320e-12,  5.241636801712266e-14,  6.969413634800405e-15, -2.403485928481674e-16, -1.035758955283777e-17,  8.783364047651250e-02,
 -1.863762193427796e-03,  7.508362186994398e-05, -3.897761159715149e-06,  1.871333486630878e-07, -6.780236900260634e-09,  1.682306508892691e-10, -3.801133931220865e-12,
  2.200866684496531e-13, -1.425426859980628e-14,  4.624828023840673e-16,  1.211674829886141e-18,  2.613421160873643e-03, -7.905101342107342e-05,  6.105052535549206e-06,
 -5.022529086084665e-07,  3.272737828102470e-08, -1.665255480196507e-09,  7.253587477590151e-11, -3.233462026911964e-12,  1.602668475278473e-13, -7.495937276340290e-15,
  2.707106762744257e-16, -6.781499013116595e-18,  3.743177108177726e-01, -6.187593603951741e-03,  1.465044472401678e-04, -3.350349001379725e-06,  5.777313628630045e-08,
 -4.634521357613011e-10,  9.532540796913286e-12, -1.847533038165597e-12,  1.131455349575860e-13, -2.356894312977520e-15, -9.426542797081594e-17,  7.862610454743865e-18,
  8.134359660533144e-02, -1.408305037506930e-03,  4.243575082757072e-05, -1.795813605894967e-06,  8.583389586315867e-08, -3.575825334416658e-09,  1.072665616310931e-10,
 -1.697104077692176e-12, -5.413647767844721e-15, -5.269120520420671e-16,  1.518065918055199e-16, -8.702459682861474e-18,  2.366584324644206e-03, -4.745316250295050e-05,
  2.362476557101351e-06, -1.733868554050247e-07,  1.166534351686089e-08, -6.185651956616133e-10,  2.522298318574185e-11, -8.234787498517603e-13,  2.688668086669163e-14,
 -1.246054998446501e-15,  6.775422491064708e-17, -2.892823201468201e-18,  3.516780633842773e-01, -5.161345548609694e-03,  1.115480420068820e-04, -2.499072774246202e-06,
  4.833490438303026e-08, -5.366732976868570e-10, -6.262223765426347e-12,  2.141823408779447e-13,  2.060239944599205e-14, -1.782741188185923e-15,  6.061526581786396e-17,
 -1.676021452756669e-19,  7.627970627744536e-02, -1.136279273491038e-03,  2.717419560577331e-05, -8.711765231270462e-07,  3.613838976745639e-08, -1.582383300124746e-09,
  5.929616642409373e-11, -1.585632944431162e-12,  1.784837444587120e-14,  6.457174498245174e-16, -2.987943354903711e-17, -4.206617310207505e-19,  2.204862323790713e-03,
 -3.446269064946166e-05,  1.081919200496628e-06, -5.930016061608188e-08,  3.857916118776261e-09, -2.205021214369955e-10,  1.004244214848386e-11, -3.488176639652701e-13,
  8.781141514182460e-15, -1.626427412068099e-16,  4.937961933717419e-18, -3.829703870652306e-19,  3.326449549006689e-01, -4.376625002186134e-03,  8.582611820325593e-05,
 -1.816973182302345e-06,  3.677462516758373e-08, -5.843632378131179e-10,  2.331493400708994e-12,  2.546213059909589e-13, -8.025360602298001e-15, -1.035389936882637e-16,
  1.936973585135022e-17, -8.892953386709288e-19,  7.211442081380895e-02, -9.528449269065844e-04,  1.935744244139971e-05, -4.825616220709490e-07,  1.552032035378531e-08,
 -6.141836824357984e-10,  2.478841845504078e-11, -8.605356353308462e-13,  2.198733943185293e-14, -2.554348154791177e-16, -8.969063755594609e-18,  5.912825311175425e-19,
  2.080944593011255e-03, -2.786885413676273e-05,  6.297339677085297e-07, -2.256838030568740e-08,  1.211269771951394e-09, -6.951139700892903e-11,  3.483903976947448e-12,
 -1.419714623102526e-13,  4.472552547238410e-15, -9.788230670921062e-17,  9.473267594826050e-19,  1.661722882599780e-20,  3.163865702103334e-01, -3.768086665723644e-03,
  6.718232377643014e-05, -1.317139743149497e-06,  2.607405975208008e-08, -4.715633340047397e-10,  6.008583493846873e-12,  2.745159049023536e-14, -4.790114465481551e-15,
  1.512308030969616e-16, -1.058564375848658e-18, -1.389196064243257e-19,  6.858103584434075e-02, -8.176856611908974e-04,  1.473678783227756e-05, -3.070681864187852e-07,
  7.603456827869507e-09, -2.388145000101959e-10,  8.907412431787404e-12, -3.335854183619942e-13,  1.091755758213474e-14, -2.761517230284424e-16,  3.941590705234611e-18,
  5.882362426993896e-20,  1.978185795207240e-03, -2.366660568478669e-05,  4.409559257384577e-07, -1.086635861130892e-08,  4.060064389224688e-10, -2.039150943300709e-11,
  1.041626788494216e-12, -4.681401185248508e-14,  1.751740019108129e-15, -5.215769442951649e-17,  1.114643462097326e-18, -1.031398263595245e-20,  3.022981699790938e-01,
 -3.287424268201254e-03,  5.359400062669599e-05, -9.675600825743088e-07,  1.807723769767450e-08, -3.309068325219489e-10,  5.349600734072594e-12, -5.346976309465162e-14,
 -8.035697453168226e-16,  6.542407486365912e-17, -2.054564092713560e-18,  3.160397338602673e-20,  6.552526459612079e-02, -7.127632822222822e-04,  1.165470711864755e-05,
 -2.145798880588171e-07,  4.377566235005650e-09, -1.056903654566237e-10,  3.190568219405401e-12, -1.115646696476687e-13,  3.896009448508024e-15, -1.211537410270766e-16,
  3.053891558749688e-18, -5.171612307647384e-20,  1.889872754934470e-03, -2.057409844539719e-05,  3.394915135322887e-07, -6.625723056882570e-09,  1.684050427796175e-10,
 -6.240715227208008e-12,  2.885983162813382e-13, -1.326355714101421e-14,  5.426305497611267e-16, -1.891415986728296e-17,  5.417302613417076e-19, -1.181189410662021e-20,
  2.899387747241778e-01, -2.900658453253802e-03,  4.352142660419914e-05, -7.248319402500146e-07,  1.261411588332449e-08, -2.217081295177218e-10,  3.749964174925823e-12,
 -5.451341256155506e-14,  4.209500676262844e-16,  1.161452809954575e-17, -7.200078493422869e-19,  2.224533232306711e-20,  6.284587655396655e-02, -6.287727806764784e-04,
  9.441326710959906e-06, -1.581416122616013e-07,  2.834897508464466e-09, -5.580852300821868e-11,  1.299751141064646e-12, -3.733734292234879e-14,  1.221431752832386e-15,
 -3.991013064914990e-17,  1.182314570752908e-18, -2.952340513906197e-20,  1.812559289621803e-03, -1.813794327944557e-05,  2.729748855265312e-07, -4.651165485513161e-09,
  9.071377920728473e-11, -2.311194823282378e-12,  8.251531552807991e-14, -3.499535294140069e-15,  1.460988978242292e-16, -5.497302370263442e-18,  1.798628634543815e-19,
 -4.974994966873652e-21,  2.789818330514799e-01, -2.584155613848084e-03,  3.590256634528618e-05, -5.540776862406640e-07,  8.965224761295691e-09, -1.482746910481364e-10,
  2.444807823027061e-12, -3.833579242618796e-14,  5.058849862251602e-16, -3.021993498959754e-18, -1.255619462020751e-19,  6.690387022799829e-21,  6.047081670062701e-02,
 -5.601371822017316e-04,  7.783622630020854e-06, -1.203079727912501e-07,  1.964188151300710e-09, -3.379925485445569e-11,  6.379943792849918e-13, -1.422676197628968e-14,
  3.864910355976900e-16, -1.182394380506921e-17,  3.624094536908244e-19, -1.022836473968061e-20,  1.744052545397515e-03, -1.615567358597863e-05,  2.246201614414935e-07,
 -3.487675254801230e-09,  5.846210847283789e-11, -1.120654857932345e-12,  2.805466282764245e-14, -9.493439704694691e-16,  3.696297024202846e-17, -1.413142661623389e-18,
  4.927103003604541e-20, -1.518944602130296e-21,  2.691807112919726e-01, -2.321298619497307e-03,  3.002583997915930e-05, -4.315035901252109e-07,  6.508478370044875e-09,
 -1.007744850241865e-10,  1.577400471450812e-12, -2.442300835950034e-14,  3.568410527376242e-16, -4.324987585336298e-18,  2.062120573541907e-20,  1.116865820762433e-21,
  5.834635513538065e-02, -5.031552796632304e-04,  6.508557563982445e-06, -9.357139829401940e-08,  1.414913247633580e-09, -2.218169905280694e-11,  3.645450786663691e-13,
 -6.573844792547172e-15,  1.396069156898003e-16, -3.573122640060133e-18,  1.022752164409352e-19, -2.944762619409467e-21,  1.682779168243770e-03, -1.451172157696368e-05,
  1.877392995788890e-07, -2.702126564435632e-09,  4.116100795759593e-11, -6.687658314447631e-13,  1.248146740160986e-14, -3.025690775135928e-16,  9.619545803718627e-18,
 -3.448621859992178e-19,  1.215560382300930e-20, -3.946900285415343e-22,  2.603454488159427e-01, -2.100174645588878e-03,  2.541217931256507e-05, -3.416459883889902e-07,
  4.822257902609028e-09, -6.996915220837003e-11,  1.031526019916550e-12, -1.527549813370412e-14,  2.226571717208737e-16, -3.048701860320383e-18,  3.437466636740691e-20,
 -1.405341957985693e-22,  5.643126193618524e-02, -4.552242960008734e-04,  5.508280394084187e-06, -7.406127973852531e-08,  1.046050901579293e-09, -1.523246193459439e-11,
  2.281200759440732e-13, -3.573753756534257e-15,  6.141756904842791e-17, -1.237386063651026e-18,  2.977077598064913e-20, -7.974179632826942e-22,  1.627545333022631e-03,
 -1.312923642660081e-05,  1.588699450011278e-07, -2.136651397106287e-09,  3.023606225645062e-11, -4.448960625625657e-13,  6.964479132439865e-15, -1.256799598137864e-16,
  2.919420008259787e-18, -8.682184444119215e-20,  2.875989960057849e-21, -9.391048192238179e-23,  2.523271017295199e-01, -1.912062845790600e-03,  2.173317660752980e-05,
 -2.744719625729705e-07,  3.639560246292645e-09, -4.963228791568535e-11,  6.888597934644183e-13, -9.658099339026930e-15,  1.354755325271552e-16, -1.864894407046284e-18,
  2.406803874324573e-20, -2.557216740583336e-22,  5.469324198488559e-02, -4.144498434380525e-04,  4.710791726499186e-06, -5.949467518878243e-08,  7.890436042272792e-10,
 -1.077063392271138e-11,  1.501887351941866e-13, -2.145173063210730e-15,  3.201492149949041e-17, -5.234609654231006e-19,  9.978219258999461e-21, -2.252515263529908e-22,
  1.577418707879451e-03, -1.195323444080373e-05,  1.358656972510931e-07, -1.716013164358384e-09,  2.276923219732885e-11, -3.116777128589789e-13,  4.404622960667015e-15,
 -6.623015016183430e-17,  1.149278154558473e-18, -2.539445643241852e-20,  7.050680774148406e-22, -2.163614368503707e-23,  2.450070262654698e-01, -1.750452155061520e-03,
  1.875883165400146e-05, -2.233657565509457e-07,  2.792627290218623e-09, -3.591081040241504e-11,  4.702359399201893e-13, -6.232125255302507e-15,  8.313559188977284e-17,
 -1.106718197140148e-18,  1.443485192424465e-20, -1.765439444839359e-22,  5.310657658027347e-02, -3.794198267710233e-04,  4.066078364237235e-06, -4.841597137687617e-08,
  6.053440782506576e-10, -7.786180339564658e-12,  1.020900053731397e-13, -1.360695359550332e-15,  1.853391472887492e-17, -2.634928573806403e-19,  4.094258177855256e-21,
 -7.367216904999715e-23,  1.531657366567380e-03, -1.094292355691913e-05,  1.172707202734869e-07, -1.396395213520336e-09,  1.746105589982197e-11, -2.247520262653397e-13,
  2.957861326331000e-15, -4.006016389777380e-17,  5.775169241249331e-19, -9.594612475421930e-21,  2.006501963646602e-22, -5.193676745913274e-24,  2.382893882413699e-01,
 -1.610394338229071e-03,  1.632466989135656e-05, -1.838706184175064e-07,  2.174544042231474e-09, -2.645170266306941e-11,  3.277052445571518e-13, -4.111571026703995e-15,
  5.203193959117709e-17, -6.612105857562510e-19,  8.371611637476878e-21, -1.037778282519125e-22,  5.165049277831027e-02, -3.490615427554895e-04,  3.538459371857662e-06,
 -3.985497994598441e-08,  4.713488550326152e-10, -5.733966150171397e-12,  7.106178956728174e-14, -8.930286052361908e-16,  1.137478591325366e-17, -1.478335176698811e-19,
  2.002693985554677e-21, -2.954396508258551e-23,  1.489662161894616e-03, -1.006735367541078e-05,  1.020534371800321e-07, -1.149469012227407e-09,  1.359465564020725e-11,
 -1.654081926015008e-13,  2.051933868192770e-15, -2.590492514397643e-17,  3.360115613738621e-19, -4.638345547284281e-21,  7.352939554837919e-23, -1.449528126841997e-24,
  2.320958167310337e-01, -1.488068904567124e-03,  1.431080542797807e-05, -1.529188763201875e-07,  1.715720997822972e-09, -1.980000459501436e-11,  2.327267850944558e-13,
 -2.770773101029826e-15,  3.329559672481343e-17, -4.026516009478441e-19,  4.881925892079789e-21, -5.890873214345779e-23,  5.030800319610036e-02, -3.225468529286391e-04,
  3.101943274501882e-06, -3.314598791291026e-08,  3.718925075169280e-10, -4.291830457238295e-12,  5.045012114132157e-14, -6.009096500549586e-16,  7.234688262236647e-18,
 -8.811502140367222e-20,  1.093668591759719e-21, -1.412207400418689e-23,  1.450943151916311e-03, -9.302638122596332e-06,  8.946376876861779e-08, -9.559706644059149e-10,
  1.072589351341928e-11, -1.237874423180982e-13,  1.455470856041395e-15, -1.735754868438714e-17,  2.100931061836824e-19, -2.609885116994718e-21,  3.446839969473330e-23,
 -5.198831299985642e-25,  2.263615136564675e-01, -1.380484138159401e-03,  1.262833595443237e-05, -1.283562362719305e-07,  1.369861144714908e-09, -1.503730646875821e-11,
  1.681244063763768e-13, -1.904088943559608e-15,  2.177029103024344e-17, -2.506744927954039e-19,  2.900270150280020e-21, -3.360172149985485e-23,  4.906506249349740e-02,
 -2.992272821710652e-04,  2.737259019269407e-06, -2.782189850100574e-08,  2.969248387950768e-10, -3.259429076821902e-12,  3.644279902228320e-14, -4.127798746418153e-16,
  4.721996018438609e-18, -5.448698067583241e-20,  6.351663739553317e-22, -7.535504069356859e-24,  1.415095251223148e-03, -8.630073715941648e-06,  7.894583391475951e-08,
 -8.024170273219610e-10,  8.563680031782879e-12, -9.400686117688834e-14,  1.051128538937215e-15, -1.190972888795330e-17,  1.364422729069039e-19, -1.583736269230374e-21,
  1.884875444664963e-23, -2.379866469689466e-25,  2.210323729879931e-01, -1.285267464580629e-03,  1.121030698632726e-05, -1.086420028623849e-07,  1.105520559178367e-09,
 -1.157097718181677e-11,  1.233507131182847e-13, -1.332033152526969e-15,  1.452227653755052e-17, -1.594850779358756e-19,  1.761201495082083e-21, -1.951863228735528e-23,
  4.790994289860344e-02, -2.785885615152944e-04,  2.429893687838434e-06, -2.354873240152437e-08,  2.396274883827527e-10, -2.508073078779678e-12,  2.673708561785690e-14,
 -2.887354569112628e-16,  3.148337951095823e-18, -3.459622432669811e-20,  3.829200584490252e-22, -4.276594003720628e-24,  1.381780216642957e-03, -8.034828255282955e-06,
  7.008104850425011e-08, -6.791737045121387e-10,  6.911146124001895e-12, -7.233600860948513e-14,  7.711423692157708e-16, -8.328281150365098e-18,  9.084607781759798e-20,
 -9.999506551321027e-22,  1.113785108561747e-23, -1.270462178852170e-25,  2.160628138248327e-01, -1.200515725435813e-03,  1.000558460036244e-05, -9.265598060586173e-08,
  9.009346610570972e-10, -9.010468123605176e-12,  9.178466519407785e-14, -9.471007801387214e-16,  9.866784847974492e-18, -1.035498076216204e-19,  1.093019263486265e-21,
 -1.158733205396841e-23,  4.683276450829457e-02, -2.602181711086638e-04,  2.168763699392466e-06, -2.008367683151807e-08,  1.952823856138408e-10, -1.953067281461978e-12,
  1.989484216363935e-14, -2.052908802844901e-16,  2.138774480719153e-18, -2.244967940123826e-20,  2.371238425893601e-22, -2.519770221027446e-24,  1.350713099891721e-03,
 -7.505004161952391e-06,  6.254974633712617e-08, -5.792373312066290e-10,  5.632178548834977e-12, -5.632883191577556e-14,  5.737932635960050e-16, -5.920971998801975e-18,
  6.169240111921081e-20, -6.478477741186082e-22,  6.855312014133766e-24, -7.332477499996289e-26,  2.114141272519800e-01, -1.124686442087520e-03,  8.974620168608066e-06,
 -7.957142956523800e-08,  7.407763918447221e-10, -7.093349431884028e-12,  6.918060707425830e-14, -6.834725337554112e-16,  6.817309985365404e-18, -6.850262382084245e-20,
  6.923673664993183e-22, -7.029911294664895e-24,  4.582513695922320e-02, -2.437817704748460e-04,  1.945296673113002e-06, -1.724753074255246e-08,  1.605672251007329e-10,
 -1.537521293541075e-12,  1.499526931827696e-14, -1.481466039098862e-16,  1.477704637853405e-18, -1.484911677018711e-20,  1.501100033883784e-22, -1.525195476409332e-24,
  1.321651912822362e-03, -7.030958653689640e-06,  5.610468925519743e-08, -4.974394738758909e-10,  4.630951410742261e-12, -4.434396302926357e-14,  4.324819120027873e-16,
 -4.272748716923803e-18,  4.262005558158458e-20, -4.283296926351741e-22,  4.332162161026092e-24, -4.410117864990772e-26,  2.070531989216822e-01, -1.056517644570566e-03,
  8.086471384746614e-06, -6.876982226247593e-08,  6.140810162861685e-10, -5.640111751828234e-12,  5.276167372536472e-14, -4.999806547679056e-16,  4.783475983063260e-18,
 -4.610397283669620e-20,  4.469686030363347e-22, -4.353458599874627e-24,  4.487988254031131e-02, -2.290058209051626e-04,  1.752785698576480e-06, -1.490622488202663e-08,
  1.331053277536559e-10, -1.222524242029996e-12,  1.143637428245721e-14, -1.083735166189132e-16,  1.036846634897224e-18, -9.993418404257218e-21,  9.688891382168972e-23,
 -9.438803517542706e-25,  1.294389641637626e-03, -6.604802545733494e-06,  5.055244184816008e-08, -4.299134042826655e-10,  3.838917308437464e-12, -3.525906623294993e-14,
  3.298388105190097e-16, -3.125626017989899e-18,  2.990411461575890e-20, -2.882328231123121e-22,  2.794867980942387e-24, -2.724185447292560e-26,  2.029515104190781e-01,
 -9.949679433296401e-04,  7.316673389797615e-06, -5.978260978012756e-08,  5.128909337873795e-10, -4.525946925399048e-12,  4.067829304599608e-14, -3.703563484727741e-16,
  3.404338590274000e-18, -3.152467549444251e-20,  2.936397271453669e-22, -2.747957686042731e-24,  4.399081973339733e-02, -2.156645956718626e-04,  1.585927887278735e-06,
 -1.295819875709609e-08,  1.111718388709649e-10, -9.810230791074416e-13,  8.817236582919257e-15, -8.027671727514812e-17,  7.379089628170423e-19, -6.833164073742182e-21,
  6.364899918781543e-23, -5.956760072081707e-25,  1.268748003939459e-03, -6.220025608465087e-06,  4.574006243973007e-08, -3.737299943012389e-10,  3.206329174567637e-12,
 -2.829388237458459e-14,  2.542996882032810e-16, -2.315277437693293e-18,  2.128221491739242e-20, -1.970784176544900e-22,  1.835792978686790e-24, -1.718324338211170e-26,
  1.990843502355682e-01, -9.391711666089134e-04,  6.645695173870116e-06, -5.225077885093157e-08,  4.313542652002671e-10, -3.662770605375236e-12,  3.167773936004143e-14,
 -2.775252232655978e-16,  2.454746520415387e-18, -2.187338074551816e-20,  1.960523809189451e-22, -1.765488006403639e-24,  4.315259218750878e-02, -2.035703474380923e-04,
  1.440489788882020e-06, -1.132563432821973e-08,  9.349833210448684e-11, -7.939250176002546e-13,  6.866318575674600e-15, -6.015507011910841e-17,  5.320794450518273e-19,
 -4.741175454208271e-21,  4.249556752220530e-23, -3.826858804747414e-25,  1.244572516141358e-03, -5.871212983495768e-06,  4.154545324265271e-08, -3.266448780552392e-10,
  2.696604040529656e-12, -2.289774976635583e-14,  1.980328647969332e-16, -1.734944474712639e-18,  1.534581516472585e-20, -1.367414778697184e-22,  1.225636285392541e-24,
 -1.103765751981283e-26,  1.954301842553746e-01, -8.884016257793584e-04,  6.057805361419370e-06, -4.589633729164307e-08,  3.651150557125078e-10, -2.987553984781313e-12,
  2.489835333913972e-14, -2.101983554047320e-16,  1.791611840339681e-18, -1.538380046129765e-20,  1.328710804919849e-22, -1.153020350460083e-24,  4.236053226847357e-02,
 -1.925657793322985e-04,  1.313061544030580e-06, -9.948275309957694e-09,  7.914063100457093e-11, -6.475682222117040e-13,  5.396850567006342e-15, -4.556161216008016e-17,
  3.883414114259399e-19, -3.334521225165127e-21,  2.880054181319551e-23, -2.499244491691509e-25,  1.221728558075411e-03, -5.553828040385830e-06,  3.787026982299648e-08,
 -2.869201919549762e-10,  2.282510719911278e-12, -1.867664422876153e-14,  1.556516436177031e-16, -1.314051558045441e-18,  1.120023302380728e-20, -9.617163903594136e-23,
  8.306443229006598e-25, -7.208209395014386e-27,  1.919701489876687e-01, -8.420472354092079e-04,  5.540228543572968e-06, -4.050192833022588e-08,  3.108942871523465e-10,
 -2.454619046442945e-12,  1.973896186044012e-14, -1.607934463603831e-16,  1.322416641310814e-18, -1.095653882296757e-20,  9.131152898042335e-23, -7.645748141147553e-25,
  4.161055121428704e-02, -1.825182185804021e-04,  1.200874014876173e-06, -8.779008465376739e-09,  6.738799092471285e-11, -5.320517386872134e-13,  4.278525009461665e-15,
 -3.485283507206809e-17,  2.866408452229896e-19, -2.374888187736430e-21,  1.979226434460256e-23, -1.657258482319404e-25,  1.200098204941319e-03, -5.264044337202154e-06,
  3.463464692384937e-08, -2.531971337319833e-10,  1.943550483797078e-12, -1.534501029001643e-14,  1.233977929994888e-16, -1.005197568804156e-18,  8.267065926035597e-21,
 -6.849463145883794e-23,  5.708329922365113e-25, -4.779746671953586e-27,  1.886876402223112e-01, -7.995885074326597e-04,  5.082510598812791e-06, -3.589606833175355e-08,
  2.661978310886532e-10, -2.030469491497388e-12,  1.577456092104895e-14, -1.241429101732217e-16,  9.863759915716063e-19, -7.895291727559146e-21,  6.356836458698686e-23,
 -5.142308586191974e-25,  4.089904997405502e-02, -1.733150633800843e-04,  1.101661214956089e-06, -7.780663804172723e-09,  5.769979625509585e-11, -4.401150658618366e-13,
  3.419220011892535e-15, -2.690863631647752e-17,  2.138022447335350e-19, -1.711346506949252e-21,  1.377878199782650e-23, -1.114623054420808e-25,  1.179577655794573e-03,
 -4.998614302910621e-06,  3.177323077778243e-08, -2.244036762828041e-10,  1.664131329447105e-12, -1.269344637594123e-14,  9.861440618046674e-17, -7.760773461531163e-19,
  6.166313197852013e-21, -4.935728708905512e-23,  3.973966554592057e-25, -3.214708911962842e-27,  1.855679765733637e-01, -7.605819864016229e-04,  4.676036210757884e-06,
 -3.194232899577056e-08,  2.291101592348951e-10, -1.690271429469264e-12,  1.270098532949972e-14, -9.667678783275357e-17,  7.429557372653026e-19, -5.751866384237073e-21,
  4.479213968091699e-23, -3.504619993469206e-25,  4.022284627925964e-02, -1.648601924034650e-04,  1.013555728604973e-06, -6.923669766321316e-09,  4.966084604731860e-11,
 -3.663753258144773e-13,  2.753006148688281e-15, -2.095520815466375e-17,  1.610396091697786e-19, -1.246747645513777e-21,  9.708934722095557e-24, -7.596450803051525e-26,
  1.160075130194287e-03, -4.754765683126718e-06,  2.923216287721700e-08, -1.996869403478560e-10,  1.432278363493469e-12, -1.056670382905975e-14,  7.939999929971986e-17,
 -6.043733370376960e-19,  4.644575484073979e-21, -3.595769764847814e-23,  2.800173313334264e-25, -2.190907898452873e-27,  1.825981223113205e-01, -7.246470765350544e-04,
  4.313658504396710e-06, -2.853132215571300e-08,  1.981468193541061e-10, -1.415424327584409e-12,  1.029805176626211e-14, -7.589747403452950e-17,  5.647490467377456e-19,
 -4.233395186405207e-21,  3.192047095715457e-23, -2.418229741158023e-25,  3.957911456617098e-02, -1.570711094899559e-04,  9.350084326374826e-07, -6.184315884694549e-09,
  4.294937738060408e-11, -3.068007540937389e-13,  2.232157513485930e-15, -1.645118132704395e-17,  1.224123607653399e-19, -9.176109318174950e-22,  6.918931939189582e-24,
 -5.241641710777890e-26,  1.141509135493495e-03, -4.530119189632737e-06,  2.696676465146090e-08, -1.783630876166750e-10,  1.238711557373305e-12, -8.848501726557420e-15,
  6.437809995094648e-17, -4.744718011187238e-19,  3.530519307128173e-21, -2.646499989216545e-23,  1.995502971596638e-25, -1.511752397611969e-27  };
  int offset = -3;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 3;
    if (std::isnan(t)) {
      fill_n(rr+offset, 3, 0.5);
      fill_n(ww+offset, 3, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 3; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=3; ++j) {
        const int boxof = it*36+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
