#include "baghira.h"
#include <qapplication.h>
#include <qbrush.h>
#include <qcolor.h>
#include <qevent.h> 
#include <qimage.h>
#include <qobject.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpopupmenu.h>
#include <qrect.h>
#include <qsettings.h>
#include <qsize.h>
#include <qstring.h>
// #include <kconfig.h>
#include <kpixmapeffect.h>

#define _SCALE_    65536
#define _NORMALIZE_ >>16

OptionHandler::OptionHandler( QObject *parent ) : QObject( parent ) {
	scrollerActive = false;
	groupShadowButton = false;
	reloadSettings();
	}

	
const QColor& OptionHandler::textColor() {
	return ( useCustomMenuColor ? fgColor : qApp->palette().active().text() );
	}

const QColor& OptionHandler::bgColor() {
	LiquidStyle * style = ( LiquidStyle* ) parent();
	if ( !menuColorButton )
		return ( style->isKicker ? style->origPanelBrush.color() : qApp->palette().active().background() );
	else{
//		qWarning("we have button color");
		return ( qApp->palette().active().button() );
		}
	return (color);

	}

const QColor& OptionHandler::buttonColor() {
	LiquidStyle * style = ( LiquidStyle* ) parent();
	if ( !menuColorButton )
		return ( style->isKicker ? style->origPanelBrush.color() : style->isOOO?CustomButtonColor():qApp->palette().active().button() );
	else{
//		qWarning("we have button color");
		return ( qApp->palette().active().background() );
		}
	return (color);

	}

void OptionHandler::reloadSettings() {
	// gather options...
	//QSettings *settings = new QSettings;
//         KConfig *config = new KConfig("baghirarc");
//         config->setGroup("Style");
        QSettings *config = new QSettings;
        config->beginGroup("/baghira/Style");
	//we need that first to make sure we use some proper settings ;)
	customButtonColor = QColor(config->readNumEntry("Design_ButtonColor",(int)qApp->palette().active().button().rgb()));
	forceRectButton = config->readBoolEntry( "Design_RectangularButtons", false);
        brushMe = config->readNumEntry( "Design_Default", 1 ) == 1;
	if (brushMe){
		tintBrush = config->readBoolEntry( "Colors_TintBrushedMetal", false );
		if (tintBrush)
			brushTint.setRgb( config->readNumEntry( "Colors_BrushTint", ( int ) bgColor().rgb()));
		else
			brushedMetalColor = QColor(200, 200, 200);
		
	}
	// menu stuff
        menuBackground = config->readNumEntry( "Menu_Background", Standard);
	menuOpacity = config->readNumEntry( "Menu_Opacity", 70);
	menuColorButton = config->readNumEntry( "Menu_ColorStyle", 0) == 1;
	shadowText = config->readBoolEntry( "Menu_ShadowText", false);
	useCustomMenuColor = config->readNumEntry( "Menu_ColorStyle", 0) == 2;
	if (useCustomMenuColor){
		color = QColor( config->readNumEntry( "Menu_Color1", 0 ) );
                color2 = QColor( config->readNumEntry( "Menu_Color2", 0 ) );
		fgColor = QColor( config->readNumEntry( "Menu_TextColor", 0 ) );
	}
	// color stuff
	// widgets
	customWidgetColor  =  config->readBoolEntry( "Colors_UseCustomColors", false);
	if ( customWidgetColor ) {
		customColors[ CustomRadioOn ].setRgb( config->readNumEntry( "Colors_RadioOn", ( int ) buttonColor().rgb() ) );
		customColors[ CustomRadioOff ].setRgb( config->readNumEntry( "Colors_RadioOff", ( int ) bgColor().rgb() ) );
		customColors[ CustomCBOn ].setRgb( config->readNumEntry( "Colors_CheckOn", ( int ) buttonColor().rgb() ) );
		customColors[ CustomCBOff ].setRgb( config->readNumEntry( "Colors_CheckOff", ( int ) bgColor().rgb() ) );
		customColors[ CustomTabOn ].setRgb( config->readNumEntry( "Colors_TabActive", ( int ) buttonColor().rgb() ) );
		customColors[ CustomTabOff ].setRgb( config->readNumEntry( "Colors_TabInactive", ( int ) bgColor().rgb() ) );
		customColors[ CustomSBSlider ].setRgb( config->readNumEntry( "Colors_Slider", ( int ) bgColor().rgb() ) );
		customColors[ CustomSBSliderHover ].setRgb( config->readNumEntry( "Colors_SliderHovered", ( int ) buttonColor().rgb() ) );
		customColors[ CustomSBSliderPressed ].setRgb( config->readNumEntry( "Colors_SliderPressed", ( int ) buttonColor().dark(110).rgb() ) );
		customColors[ CustomSBGroove ].setRgb( config->readNumEntry( "Colors_SliderGroove", ( int ) bgColor().rgb() ) );
	}
	// Panel
	panelCustom = config->readBoolEntry( "Special_CustomKickerColor", false );
	if (panelCustom)
		customPanelColor = QColor( config->readNumEntry( "Special_KickerColor", ( int ) bgColor().rgb() ) );
	// inactive Button
	inactiveButtonColor = config->readNumEntry( "Design_InactiveButtonStyle", Background);
	if (inactiveButtonColor == Custom)
		customInactiveButtonColor = QColor( config->readNumEntry( "Design_InactiveButtonColor", (int) bgColor().rgb()));
	//design stuff
	//stipple
	bgStipple = brushMe ? true : config->readBoolEntry( "Design_StippleBackground", true );
	panelStipple = brushMe ? true : config->readBoolEntry( "Special_StippleKicker", true );
	contrast = config->readNumEntry( "Design_StippleContrast", 3);
        bevelHighlights_ = config->readBoolEntry( "Design_BevelAsHighlight", true);
	//shadows
	groupboxshadow = brushMe ? false : config->readBoolEntry( "Design_ShadowGroupBoxes", true );
	shadowDarkness = config->readNumEntry( "Design_GroupBoxeShadowDarkness", 6);
	//ListViews
	expanderStyle = config->readNumEntry( "Special_ExpanderStyle", Apple);
	useCustomExpanderColor = config->readBoolEntry( "Special_CustomExpanderColor", false);
	if (useCustomExpanderColor)
		expanderColor = QColor( config->readNumEntry( "Special_ExpanderColor", (int) qApp->palette().active().text().rgb()));
	drawDotlines = config->readBoolEntry( "Special_DrawTreeLines", true);
	if (drawDotlines){
		dotlineStyle = config->readNumEntry( "Special_TreelineStyle", Line);
		dotlineColor = QColor( config->readNumEntry( "Special_TreelineColor", (int) qApp->palette().active().mid().rgb()));
	}
	//slider
	squeezesbslider = config->readBoolEntry( "Special_SqueezeSlider", false );
	shadowsbslider = config->readBoolEntry( "Special_ShadowSlider", false );
	animateSlider = config->readBoolEntry( "Special_AnimateSlider", true );
	// toolbar
	tbFrame = config->readBoolEntry( "Special_UnhoveredToolButtons", false );

	// tweaks
	centerTabs = config->readBoolEntry( "Design_CenterTabs", true);
	smoothListViewHeaders = !config->readBoolEntry( "Special_UseFlatLVH", false);
	smootherLVH = config->readBoolEntry( "Special_RoundTaskbuttons", false);
	icyButtons = config->readNumEntry( "Design_ButtonStyle", 0) == 0;
	progressBar = config->readNumEntry( "Special_ProgressStyle", baghira);
	removeKickerBevel = config->readBoolEntry( "Special_RemoveKickerBevel", false);
	smoothToolbuttons = config->readBoolEntry( "Special_RoundToolButtons", true);
	drawProgressLabel = config->readBoolEntry( "Special_ShowProgressValue", false);
	tabStyle_ = (tabStyle) config->readNumEntry( "Design_TabStyle", Clever);
        config->endGroup();
        config->beginGroup("/baghira/BAB");
//         config->setGroup("BAB");
        config->writeEntry("styleQueried", true);
        config->endGroup();
        delete config;
        
        // hack for konqueror tab bar -- TODO do it better!
//         if (qstrcmp( qApp->argv() [ 0 ], "konqueror" ) == 0 ){
//             KConfig config("konquerorrc");
//             config.setGroup("FMSettings");
//             drawKonquiHack_ = config.readBoolEntry("AlwaysTabbedMode", false);
//         }
//         else
//             drawKonquiHack_ = false;
        // ============
        
	// Option gathered
	}
