<?php

##
## common functions which all code needs access to.
##

// returns the default language

function default_lang() {
	return 'en';
}

// returns the current language setting

function lang() {
	return isset($_SESSION['lang']) ? $_SESSION['lang'] : default_lang();
}

// sets the current language setting

function set_lang($language) {
	if (isset($language) && $language != '')
		$_SESSION['lang'] = $language;
}

function deurlize($name) {
	if (preg_match('#^index\.\w{2,3}$#',$name))
		$title = basename(dirname($name));
	else
		$title = basename($name);

	# remove query string, underscore with space,
	# dash with space, Erase tilde
	
	$title = preg_replace(
		array("/(\?.*)/", "/_/", "/--/", "/-/", "/~/"),
		array("",         " ",   "&ndash;",    " ",   ""),
		$title
	);
	$title = preg_replace("/&ndash;/", "-",$title);
	
	# remove leading or trailing space
	$title = trim($title);
	
	# Capitalize All Words 
	$title = ucwords($title);
	
	return $title;
}

function urlize($title) {
	$name = strtolower($title);
	$name = preg_replace('/-/','--',$name);
	$name = preg_replace('/\s+/','-',$name);
	$name = preg_replace('/[^a-z0-9-]/','',$name);
	return $name;
}

/**
 * magic quotes are stupid, and there is no easy way to turn them off.
 * (set_magic_quotes_runtime doesn't always work).
 **/

function &get($prop, $default='', $raw=false) {
	if (!isset($_REQUEST[$prop])) 
		return $default;
		
	$prop = $_REQUEST[$prop];
	if (!is_array($prop)) {
		if(get_magic_quotes_gpc() || ini_get('magic_quotes_gpc')) {
			$prop = stripslashes($prop);
		}
		if (!$raw)
			$prop = htmlspecialchars($prop,ENT_QUOTES);
	}
	else {
		if(get_magic_quotes_gpc()) {
			$prop = array_map("stripslashes", $prop);
		}
		if (!$raw)
			$prop = array_map("htmlspecialchars", $prop);
	}
	return $prop;
}

function &getraw($prop, $default='') {
	return get($prop, $default, true);
}

#error_reporting (E_USER_ERROR | E_USER_WARNING | E_USER_NOTICE);
function errors($errno='', $errstr='', $errfile='', $errline='') {
	static $errors = array();
	
	if ($errno == '') {
		return join('',$errors);
	}
	else {
		switch ($errno) {
			case E_USER_ERROR:
			case E_ERROR:
				$etype = 'ERROR'; break;
			case E_USER_WARNING:
			case E_WARNING:
				$etype = 'WARNING'; break;
			case E_USER_NOTICE:
			case E_NOTICE:
				if ( ! (ini_get('error_reporting')&E_NOTICE) ) return;
				$etype = 'NOTICE'; break;
			case E_STRICT:
				if ( ! (ini_get('error_reporting')&E_STRICT) ) return;
				$etype = 'STRICT'; break;

		}
		$errors[] = "<p><b>$etype</b>: $errstr <br /><i>$errfile: $errline</i></p>";
	}
}
set_error_handler("errors");

#function errors() {}

?>