<?php

#########################################################
# LANGUAGE FUNCTIONS

// global vars, should only be accessed through Lang class
$_lang_possible       = null;   // array of possible language codes
$_lang_possible_map   = null;   // array of possible codes => full name
$_lang_priorities     = null;   // array of language codes, ordered by priority
$_lang_default        = '';     // fallback default lang code
$_lang_map = array(             // map codes to full names
	'de' => 'Deutsch',
	'en' => 'English',
	'el' => '&epsilon;&lambda;&lambda;&eta;&nu;&iota;&kappa;&#940;',
	'es' => 'Espa&ntilde;ol',
	'fr' => 'Fran&ccedil;ais',
	'it' => 'Italiano',
	'pt' => 'Portugu&ecirc;s',
);

class Lang {

// returns the top choice language
function top() {global $_lang_priorities; return $_lang_priorities[0];}

// sets the current language setting
function set($language) {if (isset($language) && $language != '') $_SESSION['lang'] = $language;}

// init: called very early in frontdoor.php
function init($default, $possible) {
	global $_lang_default, $_lang_possible, $_lang_possible_map, $_lang_map;
	$_lang_default = $default;
	$_lang_possible = $possible;
	$_lang_possible_map = array();
	foreach($_lang_possible as $code) {
		if (isset($_lang_map[$code])) $_lang_possible_map[$code] = $_lang_map[$code];
	}
}

/**
 * returns language priorities, and updates them if necesssary.
 **/

function priority() {
	global $_lang_priorities, $_lang_possible, $_lang_default;
	$languages = &$_lang_priorities;
	if ( ! isset($languages) ) {
		// start with what the browser wants
		if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
			$languages = split("," , preg_replace('/(;q=\d+.\d+)|(\-..)| /i', '', $_SERVER['HTTP_ACCEPT_LANGUAGE']) );
		else
			$languages = array();

		// if session defines a language, put it in first place
		if ( isset( $_SESSION['lang'] ) )
			array_unshift( $languages, $_SESSION['lang'] );
	
		// remove languages which are not allowed in the site configuration
		if (is_array($_lang_possible) && count($_lang_possible)) {
			$languages = array_intersect($_lang_possible, $languages);		
		}

		// Just in case we have no other languages, set a default.
		$languages[] = $_lang_default;
	
		// remove duplicates and make sure indexes are sequential.
		$languages = array_values(array_unique($languages));	
	}

	// if session lang is set, make sure it is our 'highest' priority language.
	// we do this every time, not just the first time, in case it has changed.
	if ( isset($_SESSION['lang']) && $_SESSION['lang'] != $languages[0]) {
		array_unshift( $languages, $_SESSION['lang'] );
		$languages = array_values(array_unique($languages));
	}

	//  if there is no session yet, set the session language to the top choice.
	if (! isset($_SESSION['lang']) ) {
		$_SESSION['lang'] = $languages[0];
	}

	return $languages;
}

// returns a form for selecting the language.
function getform($action, $extra='') {
	global $_lang_possible_map;
	$html = "<form action=\"$action\" method=\"get\">\n";
	$html .= $extra;
	$html .= "<select name=\"lang\" onchange=\"this.form.submit();\">\n";
	foreach ($_lang_possible_map as $lcode => $lname) {
		$selected = $lcode == $_SESSION['lang'] ? "SELECTED" : ""; 
		$html .= "<option value=\"$lcode\" $selected>$lname</option>\n";
	}
	$html .= "</select>\n</form>\n";
	return $html;
}

}
return;
?>
