<? 

/****
 * 
 * Page.php
 *
 * An abstract web page, either dynamic or static.
 * Page knows nothing about how it is stored. It might be a file
 * or it might be in a database. Page knows nothing about what
 * kind of data it contains.
 *
 ****/

class Page {
	
var $path;          # always absolute, in relation to siteroot.
var $absolutepath;  # real absolute path, including siteroot.
var $dirpath;       # path to the nearest directory, may be self or our parent.
var $ps;            # the page store
var $type;          # the page type. ie: raw, txt, html, mod. 
var $static;        # true or false
var $dir;           # true or false, does this page contain other pages.
var $prop;          # pointer to global Properties object. used to resolved properties.
var $dirty=array(); # array of flags of dirty properties (changed this request)
var $messages=array(); # array of strings for error messages.
var $ok=true;       # true or false, is this file ok? (ie no errors occured).
var $fnf=false;     # file not found: true if we determine this page does not refer to real content

## basic properties ##

var $name;          # page name 
var $title;         # page title
var $content=null;  # the content of the page
var $mtime;         # modification time of this data
var $version;       # either: version number, 'draft', or empty string (main version).

function Page() {
	// all the work is done in pagestore->getpage();
}

function init() {
	if ($this->fnf) return;
	
	// get some basic props as references to the
	// real storage for convenience (ie laziness)
	
	$this->name     = &$this->get('name');
	$this->title    = &$this->get('title');
	$this->navtitle = &$this->get('nav-title');
	$this->static   = &$this->get('static');
	$this->dir      = &$this->get('dir');
	$this->mtime    = &$this->get('mtime');
	$this->type     = &$this->get('type');
	$this->version  = '';
	
	# set dirpath to be the closest directory
	$this->dirpath = $this->dir ? $this->path : dirname($this->path);
}

function &get($property, $default=null) {
	if ($property == 'order') {
		$ret = $this->ps->getOrder($this);
		return $ret; 
	}
	elseif ($property=='content') {
		if (!isset($this->content))
			$this->ps->fetch($this,$this->version); // loads $this->content
		return $this->content;
	}
	elseif ($property=='size') {
		return $this->ps->getContentSize($this);
	}
	else {
		$value = &$this->prop->get($property,$this);
		if ($value == null)
			return $default;
		else
			return $value;
	}
}

function setContent(&$data) {
	$this->dirty['content'] = true;
	$this->content = &$data;
}

function set($property,$data) {
	if ($property == 'order') {
		$this->ps->setOrder($this,$data); 
	}
	elseif($property == 'content') {
		$this->dirty['content'] = true;
		$this->content = &$data;
	}
	else {
		$this->dirty[$property] = true;
		if ($property=='name') {
			$data = urlize($data);
			$this->name = $data;
		}
		$this->prop->set($property,$data,$this);
	}
}

/**
 * commit()
 * Saves any changes to this page object.
 * We use two helpers:
 * - PageStore ($ps) is in charge of writing changes to name and content
 * - Properties ($prop) is in charge of writing changes to all other properties
 *   ($prop uses the pagestore to do this).
 *
 **/
function commit() {
	global $search; 
	
	$pathold = $this->path;
	
	if (!$this->dirty())
		return; // no props changed.
	
	// if there are properties besides name and content which are dirty, then commit the
	// changes. we must save the properties first, because a name change will force a
	// reloading of the properties.

	$tmparray = $this->dirty;
	unset($tmparray['name']); unset($tmparray['content']);
	if (count($tmparray)) {
		$this->set('mtime',time());
	    $err = $this->prop->commit($this);
	}
		
	if ($this->isdirty('name') || $this->isdirty('content') ) {
		$ok = $this->ps->commit($this,$this->version); 
		if ($ok) {
			$this->set('mtime',time());
			$this->prop->commit($this); // update mtime
		}
	}
	
	// update the index, only if this is main version.
	if ($search != null && $this->version == '') {
		$search->indexPage($this);
		if ($pathold != $this->path)
			$search->replacePath($pathold,$this->path);
	}
}

/*
 * version() 
 * sets the current version of this page.
 * if content is already loaded, then we replace with
 * content from the specified version.
 */
function setVersion($v) {
	if ($this->version == $v) return;
	
	if (isset($this->content))
		$this->content = null;

	$this->version = $v;	
	$this->get('content'); // loads new content.
}

/////////////////////
// dirty functions

function isdirty($prop) {
	return isset($this->dirty[$prop]);
}

function undirty($prop) {
	unset($this->dirty[$prop]);
}

function dirty() {
	return count($this->dirty);
}

function getDirty() {
	return array_keys($this->dirty);
}

// returns array of languages which have content.
function availableContent() {
	return $this->ps->availableContent($this);
}

function &children() {
	return $this->ps->getChildren($this);
}

function &child($name) {
	return $this->ps->getPage($this->path . '/' . $name);
}

// make this more efficient
function childCount() {
	return count($this->ps->getChildren($this));
}

function &parent() {
	return $this->ps->getPage(dirname($this->path));
}

// return the next peer page, if it exists. null otherwise.
function &next() {
	return $this->ps->getNext($this);
}

// return the next peer page, if it exists. null otherwise.
function &prev() {
	return $this->ps->getPrev($this);
}

/*
 * returns an array of attachment info:
 */
 
function attachments() {
	$ps = &$this->ps;
	return $ps->getAttachments($this);
}

function attach($filedata) {
	$ps = &$this->ps;
	$ps->addAttachment($this,$filedata);
}

function removeAttachment($name) {
	$ps = &$this->ps;
	$ps->removeAttachment($this,$name);
}

/*
 * returns true if the user is allowed to preform the
 * action on this page.
 */	
function may($username, $action) {
	if ($action == 'edit')
		$users = $this->get("access-edit");
	else
		$users = $this->get("access-view");

	## CHANGE ME CHANGE ME -- we need some groups

	$users = split(' ', $users);
	foreach($users as $user) {	
		if ($user == $username)
			return true;
		elseif ($user == 'anonymous' || $user == '')
			return true;
		elseif ($user == 'authenticated' && $username != 'anonymous' && $username != '')
			return true;
	} 
	return false;
}


function destroy() {
	global $search; 
	if ($this->path == '/')
		$this->error('You cannot delete the root page');
	elseif ($this->fnf)
		$this->error('That file does not exist');
	else {
		if ($search != null) $search->deindexPage($this);
		$this->ps->destroyPage($this);
	}
}

/*
 * copies this page to the path specified
 */
function duplicate($copypath) {
	$this->ps->duplicatePage($this,$copypath);
}

/*
 * moves this page to the path specified
 */
function move($newpath) {
	global $search;
	
	while($this->ps->exists($newpath)) {
		$newpath .= '-copy';
	}
	if ($search) {
		$search->replacePath($this->path,$newpath);
	}
	$this->ps->movePage($this,$newpath);	
}

/*
 * moves this page to be under the page
 * specified by $parentpath
 */
function setParent($parentpath) {
	global $search;
	$oldpath = $this->path;
	$newpath = "$parentpath/".basename($this->path);
	$ok = $this->ps->movePage($this,$newpath);
	if ($ok && $search!=null)
		$search->replacePath($oldpath,$newpath);
	if (!$ok) $this->ok = false;
}

// error and message handling

function error($str = '') {
	if ($str) {
		$this->messages[] = "<font color=red>$str</font>";
		$this->ok = false;
	}
	return join('<br/>',$this->messages) . '<br/>';
}

function msg($str = '') {
	if ($str)
		$this->messages[] = "<font color=green>$str</font>";
	return join('<br/>',$this->messages) . '<br/>';
}

// search

function search($tokens) {
	$content = $this->get('content');
	$ret = array();
	for($i=0;$i<count($tokens);$i++) {
		$token = "/^.*$tokens[$i].*$/im";
		preg_match_all($token,$content,$matches);
		$ret = array_merge($ret, $matches[0]);
	}
	$ret = array_slice($ret,0,5); // limit to 5 lines;
	$ret = array_unique($ret);
	return $ret;
}

/* 
 * returns the fully rendered main content of the page,
 * ready to be displayed by the decorator.
 *
 * this is the main function to be overridden by subclasses
 */
function &getDisplay() {
	return "error: called getDisplay on abstract super class";
}

}

return;
?>
