#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h> 
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <gconf/gconf-client.h>

#include "baobab.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "tv.h"
#include "props.h"




void
on_menuallfs_activate                      (GtkMenuItem       *menuitem,
                                        gpointer         user_data)
{
 	//start_process();
	start_proc_on_dir("/");
}

void
on_menuscandir_activate                      (GtkMenuItem       *menuitem,
                                        gpointer         user_data)
{
 	dir_select(FALSE,baobab.window);
}

void
on_esci1_activate                      (GtkObject     *menuitem,
                                        gpointer         user_data)
{
	baobab.STOP_SCANNING=TRUE;
	gtk_main_quit();
}


void
on_tb_exit_clicked                     (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	
	baobab.STOP_SCANNING = TRUE;
	gtk_main_quit();

	
	
}

void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	 const gchar *authors[] = {
    "Fabio Marzocca <thesaltydog@gmail.com>\n\n",_("Coding contributions:"),
	"Benoît Dejean\n",	 
	_("Acknowledgements:"),
    "Beniamino Caputo, Andrea Abelli,\nSean Montel, Piotr Szotkowski, \nFrancesco Accattapà",
    NULL
  };
	
  	GtkWidget * _about=create__about();
	gtk_about_dialog_set_authors (GTK_ABOUT_DIALOG (_about), authors);
	GdkPixbuf* _about_logo_pixbuf= gtk_about_dialog_get_logo((GtkAboutDialog *) _about);
	gtk_window_set_icon(GTK_WINDOW(_about),_about_logo_pixbuf);
  	gtk_window_set_transient_for (GTK_WINDOW (_about), GTK_WINDOW (baobab.window));
  
  	gtk_widget_show(_about);
  
}

void
on_tbscandir_clicked                   (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	dir_select(FALSE,baobab.window);
}



void
on_tv_row_expanded	(GtkTreeView *treeview,GtkTreeIter *arg1,
                                            GtkTreePath *arg2,
                                            gpointer user_data)
{
	gtk_tree_view_columns_autosize(treeview);
}

void        
on_tv_cur_changed      (GtkTreeView *treeview,
                                            gpointer user_data)
{
	GtkTreeIter iter;
	gchar *text;
	gtk_tree_selection_get_selected(gtk_tree_view_get_selection (treeview),
								NULL,&iter);
	if (get_NB_page()==VIEW_TREE) {
		if (gtk_tree_store_iter_is_valid(baobab.model,&iter)) {	
			gtk_tree_model_get((GtkTreeModel*)baobab.model,&iter,1,&text,-1);
			if (!text) { return;}
			set_statusbar(text);
			g_free(text);
			}
		}
	if (get_NB_page()==VIEW_SEARCH) {
		if (gtk_list_store_iter_is_valid(baobab.model_search,&iter)) {	
			gtk_tree_model_get((GtkTreeModel*)baobab.model_search,&iter,COL_FULLPATH,&text,-1);			
			if (!text) { return;}
			set_statusbar(text);
			g_free(text);
			
			}
		}
		
}

void
on_sort_alfa_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (get_NB_page()==VIEW_TREE) {
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)baobab.model,0,GTK_SORT_ASCENDING);
	}
	if (get_NB_page()==VIEW_SEARCH) {
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)baobab.model_search,COL_FULLPATH,GTK_SORT_ASCENDING);
	}

}


void
on_by_sort_size_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (get_NB_page()==VIEW_TREE) {
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)baobab.model,5,GTK_SORT_DESCENDING);
	}
	if (get_NB_page()==VIEW_SEARCH) {
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)baobab.model_search,COL_SIZE,GTK_SORT_DESCENDING);
	}
}



void
on_tbstop_clicked                      (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	baobab.STOP_SCANNING = TRUE;
	stop_scan();

}

void
on_tbsortalfa_clicked                  (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	on_sort_alfa_activate(NULL,NULL);
}


void
on_tbsortnum_clicked                   (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	on_by_sort_size_activate(NULL,NULL);

}


void
on_tbscanall_clicked                   (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
		//start_process();
	start_proc_on_dir("/");
}

gboolean    
on_tv_button_press      (GtkWidget *widget,
                         GdkEventButton *event,
                         gpointer user_data)
{
	GtkTreePath * path;

	gtk_tree_view_get_path_at_pos((GtkTreeView*)widget,event->x, event->y,
									&path,NULL,NULL,NULL);
	
	if (get_NB_page()==VIEW_TREE) {	
		if (baobab.CONTENTS_CHANGED_DELAYED) {
			baobab.CONTENTS_CHANGED_DELAYED =FALSE;
			if (baobab.STOP_SCANNING) {
				contents_changed();
			}
		}
	}
				
	
	if (!path) {return FALSE;}
	//left-click
	if (event->button == 1) {
			gtk_tree_path_free(path);
	}
	//right-click
	if (event->button == 3) {
		if (get_NB_page()==VIEW_TREE) {
			popupmenu_list(path,event);
		}
		if (get_NB_page()==VIEW_SEARCH) {
			popupmenu_list_search(path,event);
		}
			gtk_tree_path_free(path);
		return FALSE;
	}
	return FALSE;
	
}

void
on_tb_search_clicked                   (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	dialog_search();
	
}

void
on_radio_allfs_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dlg = gtk_widget_get_toplevel((GtkWidget*)button);
	gtk_widget_set_sensitive(lookup_widget(dlg,"entry2"),FALSE);
	gtk_widget_set_sensitive(lookup_widget(dlg,"btn_select_search"),FALSE);
}


void
on_radio_dir_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dlg = gtk_widget_get_toplevel((GtkWidget*)button);
	gtk_widget_set_sensitive(lookup_widget(dlg,"entry2"),TRUE);
	gtk_widget_set_sensitive(lookup_widget(dlg,"btn_select_search"),TRUE);
}

void
on_btn_select_search_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dlg = gtk_widget_get_toplevel((GtkWidget*)button);
	GtkWidget * entry_dir = lookup_widget(dlg,"entry2");
	gchar* dirname=dir_select(TRUE,dlg);
	if (dirname) {
		gtk_entry_set_text(GTK_ENTRY(entry_dir),dirname);
		g_free(dirname);
	}
	
}

void
on_search_for_a_file_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	dialog_search();
}

void
on_notebook1_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        guint            page_num,
                                        gpointer         user_data)
{
	
	if (page_num == VIEW_SEARCH) {
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "by_type1"),TRUE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "by_date1"),TRUE);		
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "ck_allocated"),FALSE);
	}
	
	if (page_num == VIEW_TREE) {
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "ck_allocated"),TRUE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "by_type1"),FALSE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "by_date1"),FALSE);
		if (baobab.CONTENTS_CHANGED_DELAYED) {
			baobab.CONTENTS_CHANGED_DELAYED =FALSE;
			if (baobab.STOP_SCANNING) {
				contents_changed();
				
			}
		}
		}
	show_label(page_num);
	

}




gboolean
on_delete_activate                     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	on_esci1_activate(NULL,NULL);
  return TRUE;
}

void
open_file_cb(GtkMenuItem *pmenu, gpointer  filename)
{
	
	//locale_file = g_locale_from_utf8 (filename, -1, NULL, NULL, NULL);
	
	if (!g_file_test (filename, G_FILE_TEST_EXISTS)) {
				message (_("The document does not exist."),baobab.window);
			}
	open_file_with_application(filename); 
	
	g_free(filename);
}

void
trash_file_cb(GtkMenuItem *pmenu, gpointer  filename)
{
	if (trash_file((gchar*) filename)) {
		GtkTreeIter iter;
		guint64 filesize;
		GtkTreeSelection* selection;

		selection = gtk_tree_view_get_selection((GtkTreeView*)baobab.tree_search);
		gtk_tree_selection_get_selected(selection,NULL,&iter);
		gtk_tree_model_get((GtkTreeModel*)baobab.model_search,&iter,
					COL_SIZE,&filesize,
					-1);
		gtk_list_store_remove (GTK_LIST_STORE (baobab.model_search), &iter);
		set_label_search(baobab.number_found_files-1,baobab.size_found_files-filesize);
		show_label(VIEW_SEARCH);
		if (baobab.bbEnableHomeMonitor)
			baobab.CONTENTS_CHANGED_DELAYED = TRUE;
	}
}

void
trash_dir_cb(GtkMenuItem *pmenu, gpointer  dir)
{
	if (trash_file((gchar*) dir)) {
		GtkTreeIter iter;
		guint64 filesize;
		GtkTreeSelection* selection;

		selection = gtk_tree_view_get_selection((GtkTreeView*)baobab.tree_view);
		gtk_tree_selection_get_selected(selection,NULL,&iter);
		gtk_tree_model_get((GtkTreeModel*)baobab.model,&iter,
					5,&filesize,
					-1);
		gtk_tree_store_remove (GTK_TREE_STORE (baobab.model), &iter);
		contents_changed();
		}
	
}


void
list_all_cb(GtkMenuItem *pmenu, gpointer  dir)
{
	bbSearchOpt.mod_date=NONE;
	bbSearchOpt.size_limit=NONE;
	bbSearchOpt.dont_recurse_dir=TRUE;
	start_search("*",(gchar*)dir);
}

// VFS monitoring
void
volume_changed (GnomeVFSVolumeMonitor *volume_monitor,
		  		GnomeVFSVolume *volume)
{
			//filesystem has changed (mounted or unmounted device)
		if (!baobab.STOP_SCANNING) {
			baobab.STOP_SCANNING=TRUE;
			stop_scan();
		}
		on_propstb_clicked(NULL,NULL);
}
	
void
contents_changed_cb(GnomeVFSMonitorHandle *handle,
                                             const gchar *monitor_uri,
                                             const gchar *info_uri,
                                             GnomeVFSMonitorEventType event_type,
                                             gpointer user_data)
{
	//g_print("info=%s \n", info_uri);
	if (!baobab.bbEnableHomeMonitor) return;
		
	if ( baobab.CONTENTS_CHANGED_DELAYED) {
		return;
		}
	
	gchar * excluding;
	excluding = g_path_get_basename(info_uri);
	if (strcmp(excluding, ".recently-used")==0 ||
		strcmp(excluding,".gnome2_private")==0 ||
		strcmp(excluding,".xsession-errors")==0 ||
		strcmp(excluding,".bash_history")==0 ||
		strcmp(excluding,".gconfd")==0) {
			g_free(excluding);
			return;
		}
	g_free(excluding);		


	baobab.CONTENTS_CHANGED_DELAYED =TRUE;
	
}

void
on_propstb_clicked                     (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
		create_props();
}

void
on_pref_menu_                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_propstb_clicked(NULL,NULL);

}

void
on_by_type1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (get_NB_page()==VIEW_SEARCH) {
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)baobab.model_search,
				COL_FILETYPE,GTK_SORT_ASCENDING);
	}

}

void
on_by_date1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (get_NB_page()==VIEW_SEARCH) {
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)baobab.model_search,
				COL_LASTACCESS,GTK_SORT_DESCENDING);
	}

}

void
on_ck_allocated_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

	baobab.show_allocated = gtk_toggle_button_get_active(togglebutton); 

	//change the cursor
	GdkCursor *cursor = NULL;
	if (baobab.window->window) {
 		cursor = gdk_cursor_new(GDK_WATCH);
		gdk_window_set_cursor (baobab.window->window, cursor);
	}
	
	change_icon("busy.gif");
	set_statusbar( _("Calculating percentage bars..."));
	gtk_tree_model_foreach((GtkTreeModel*)baobab.model,show_bars,NULL);
	change_icon("done.png");
	set_statusbar(_("Ready"));
	
	
	/* cursor clean up */
	if (baobab.window->window) {
		gdk_window_set_cursor(baobab.window->window,NULL);
		if (cursor) gdk_cursor_unref(cursor);
	}

}
